## @imqa/web-agent

![NPM Version](https://img.shields.io/npm/v/%40imqa%2Fweb-agent?style=flat-square&logo=npm&color=%238ef7c1) ![NPM Last Update](https://img.shields.io/npm/last-update/%40imqa%2Fweb-agent?color=%238ef7c1) ![NPM Unpacked Size](https://img.shields.io/npm/unpacked-size/%40imqa%2Fweb-agent?color=%238ef7c1) ![npm package minimized gzipped size](https://img.shields.io/bundlejs/size/%40imqa%2Fweb-agent?color=%238ef7c1) ![NPM Downloads](https://img.shields.io/npm/dw/%40imqa%2Fweb-agent?color=%238ef7c1) ![NPM Type Definitions](https://img.shields.io/npm/types/%40imqa%2Fweb-agent)


OpenTelemetry native IMQA RUM Agent

### 설치

```bash
npm install @imqa/web-agent
```

### IMQA 초기화

```js
import IMQA from '@imqa/web-agent';

IMQA.init({
  collectorUrl: 'https://ingest.imqa.io',
  serviceName: 'my-frontend-app',
  serviceVersion: '1.0.0'
  serviceKey: '<YOUR_SERVICE_KEY_HERE>',
  tracePropagationTargets: [/api.myapp.domain/i], // 프론트엔드와 백엔드 요청의 트레이스를 연결하도록 설정
  consoleCapture: true, // 콘솔 로그 캡처 (기본값 false)
  advancedNetworkCapture: true, // HTTP 요청/응답 헤더와 본문 전체 캡처 (기본값 false)
});
```

#### 옵션

- `collectorUrl` - (필수) IMQA 콜렉터 URL.
- `serviceName` - (필수) IMQA에 표시될 서비스 이름.
- `serviceVersion` - (필수) 서비스 버전.
- `serviceKey` - (필수) IMQA 수집 서비스 키.
- `tracePropagationTargets` - (선택) 프론트엔드와 백엔드 트레이스를 연결하기 위해 HTTP 요청과 매칭할 정규식 패턴 목록입니다. 패턴과 일치하는 모든 요청에 `traceparent` 헤더가 추가됩니다. 백엔드 API 도메인으로 설정해야 합니다(예: `api.yoursite.com`).
- `consoleCapture` - (선택) 모든 콘솔 로그 캡처 (기본값 `false`).
- `advancedNetworkCapture` - (선택) 요청/응답 헤더와 본문 전체 캡처 (기본값 false).
- `recordCanvas` - (선택) canvas 요소를 기록할지 여부 (기본값 `false`)


## 추가 설정

### 사용자 정보 추가

사용자 ID를 추가하면 IMQA에서 세션과 이벤트를 검색/필터링할 수 있습니다. 이는 클라이언트 세션 중 언제든지 호출할 수 있습니다. 현재 클라이언트 세션과 호출 이후의 모든 이벤트는 사용자 ID와 연결됩니다.

```js
IMQA.setUserIdAttribute("your-user-id");
```

### 메타데이터 추가

메타 데이터는 계측하는데 필요한 추가 정보를 제공합니다. 이는 클라이언트 세션 중 언제든지 호출할 수 있습니다. 현재 클라이언트 세션과 호출 이후의 모든 이벤트는 메타 데이터와 연결됩니다.

다른 추가 값들은 이벤트 검색에 사용할 수 있도록 지정할 수 있습니다.

```js
IMQA.setGlobalAttributes({
  teamName: "your-team-name",
  groupName: "your-group-name",
  // 기타 사용자 지정 속성...
});
```

### React Error Boundary 오류 자동 캡처

React를 사용하는 경우, React error boundary 내에서 발생하는 오류를 자동으로 캡처하기 위해 error boundary 컴포넌트를 `attachToReactErrorBoundary` 함수에 전달할 수 있습니다.

```js
// ErrorBoundary 가져오기 (예시로 react-error-boundary를 사용)
import { ErrorBoundary } from 'react-error-boundary';

// ErrorBoundary 컴포넌트에 연결하여 모든 인스턴스에서 발생하는 오류를 캡처합니다.
IMQA.attachToReactErrorBoundary(ErrorBoundary);
```

### 사용자 정의 액션 전송

특정 애플리케이션 이벤트(예: 가입, 제출 등)를 명시적으로 추적하기 위해 이벤트 이름과 선택적 이벤트 메타데이터를 포함하여 `addAction` 함수를 호출할 수 있습니다.

예시:

```js
IMQA.addAction('Form-Completed', {
  formId: 'signup-form',
  formName: 'Signup Form',
  formType: 'signup',
});
```

### 네트워크 캡처 동적 활성화

네트워크 캡처를 동적으로 활성화하거나 비활성화하려면 필요에 따라 `enableAdvancedNetworkCapture` 또는 `disableAdvancedNetworkCapture` 함수를 호출하면 됩니다.

```js
IMQA.enableAdvancedNetworkCapture();
```

### CORS 요청에 대한 리소스 타이밍 활성화

프론트엔드 애플리케이션이 다른 도메인으로 API 요청을 하는 경우, 선택적으로 요청과 함께 `Timing-Allow-Origin` [헤더](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Timing-Allow-Origin)를 보내도록 활성화할 수 있습니다. 이를 통해 IMQA는 [PerformanceResourceTiming](https://developer.mozilla.org/en-US/docs/Web/API/PerformanceResourceTiming)을 통해 DNS 조회, 응답 다운로드 등과 같은 요청에 대한 상세한 리소스 타이밍 정보를 캡처할 수 있습니다.

`express`와 `cors` 패키지를 사용하는 경우, 다음 코드를 사용하여 헤더를 활성화할 수 있습니다:

```js
var cors = require('cors');
var onHeaders = require('on-headers');

// ... 기타 코드

app.use(function (req, res, next) {
  onHeaders(res, function () {
    var allowOrigin = res.getHeader('Access-Control-Allow-Origin');
    if (allowOrigin) {
      res.setHeader('Timing-Allow-Origin', allowOrigin);
    }
  });
  next();
});
app.use(cors());
```

### 세션 ID 검색

현재 세션 ID를 검색하려면 `getSessionId` 함수를 호출할 수 있습니다.

```js
const sessionId = IMQA.getSessionId();
```


[discussions-url]: https://github.com/onycom-imqa/imqa-js/discussions
[npm-url]: https://www.npmjs.com/package/@imqa/web-agent
[npm-img]: https://badge.fury.io/js/@imqa%2Fweb-agent.svg

### 커스텀 로그

IMQA는 `recordLog` 매서드를 통해 사용자 정의 로그를 캡처할 수 있습니다.

```js
IMQA.recordLog('## My Custom Log Message ##');
```