import { RumOtelWebType } from '@imqa/otel-web';
import { Attributes } from '@opentelemetry/api';
import { ErrorBoundaryComponent, IMQASDKConfig } from './types';
export declare class IMQA {
    private _advancedNetworkCapture;
    init(configs?: IMQASDKConfig): void;
    opamp: RumOtelWebType['opampClient'] | undefined;
    stopSessionRecorder(): void;
    resumeSessionRecorder(): void;
    addAction(name: string, attributes?: Attributes): void;
    recordException(error: any, attributes?: Attributes): void;
    recordLog(message: string, attributes?: Attributes): void;
    enableAdvancedNetworkCapture(): void;
    disableAdvancedNetworkCapture(): void;
    setGlobalAttributes(attributes: Record<'userId' | 'userEmail' | 'userName' | 'teamName' | 'teamId' | string, string>): void;
    setUserIdAttribute(userId: string): void;
    setAreaCodeAttribute(areaCode: string): void;
    getSessionId(): string | undefined;
    getSessionUrl(): string | undefined;
    attachToReactErrorBoundary(errorBoundary: ErrorBoundaryComponent): void;
    _webviewParamsControl(configs: IMQASDKConfig): {
        urlBase: string;
        serviceName: string;
        serviceKey: string;
        serviceVersion: string;
        serviceType: string;
    };
}
