/**
 * @imqa/web-agent
 *  version: 1.2.2
 *  commit-hash: 279a0412
 *  build time: 2025-06-27T04:41:25.302Z
 *  SPDX-FileCopyrightText: LicenseRef-ONYCOM-Proprietary
 *  Copyright © 2024-2025 ONYCOM CO., LTD. <https://www.imqa.io>
 *  BOM: See CycloneDX SBOM at /.well-known/sbom
 */
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('core-js/stable')) :
	typeof define === 'function' && define.amd ? define(['core-js/stable'], factory) :
	(global = typeof globalThis !== 'undefined' ? globalThis : global || self, global.IMQA = factory());
})(this, (function () { 'use strict';

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function getDefaultExportFromCjs (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function getAugmentedNamespace(n) {
	  if (Object.prototype.hasOwnProperty.call(n, '__esModule')) return n;
	  var f = n.default;
		if (typeof f == "function") {
			var a = function a () {
				if (this instanceof a) {
	        return Reflect.construct(f, arguments, this.constructor);
				}
				return f.apply(this, arguments);
			};
			a.prototype = f.prototype;
	  } else a = {};
	  Object.defineProperty(a, '__esModule', {value: true});
		Object.keys(n).forEach(function (k) {
			var d = Object.getOwnPropertyDescriptor(n, k);
			Object.defineProperty(a, k, d.get ? d : {
				enumerable: true,
				get: function () {
					return n[k];
				}
			});
		});
		return a;
	}

	var fails;
	var hasRequiredFails;

	function requireFails () {
		if (hasRequiredFails) return fails;
		hasRequiredFails = 1;
		fails = function (exec) {
		  try {
		    return !!exec();
		  } catch (error) {
		    return true;
		  }
		};
		return fails;
	}

	var functionBindNative;
	var hasRequiredFunctionBindNative;

	function requireFunctionBindNative () {
		if (hasRequiredFunctionBindNative) return functionBindNative;
		hasRequiredFunctionBindNative = 1;
		var fails = /*@__PURE__*/ requireFails();

		functionBindNative = !fails(function () {
		  // eslint-disable-next-line es/no-function-prototype-bind -- safe
		  var test = (function () { /* empty */ }).bind();
		  // eslint-disable-next-line no-prototype-builtins -- safe
		  return typeof test != 'function' || test.hasOwnProperty('prototype');
		});
		return functionBindNative;
	}

	var functionUncurryThis;
	var hasRequiredFunctionUncurryThis;

	function requireFunctionUncurryThis () {
		if (hasRequiredFunctionUncurryThis) return functionUncurryThis;
		hasRequiredFunctionUncurryThis = 1;
		var NATIVE_BIND = /*@__PURE__*/ requireFunctionBindNative();

		var FunctionPrototype = Function.prototype;
		var call = FunctionPrototype.call;
		// eslint-disable-next-line es/no-function-prototype-bind -- safe
		var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype.bind.bind(call, call);

		functionUncurryThis = NATIVE_BIND ? uncurryThisWithBind : function (fn) {
		  return function () {
		    return call.apply(fn, arguments);
		  };
		};
		return functionUncurryThis;
	}

	var objectIsPrototypeOf;
	var hasRequiredObjectIsPrototypeOf;

	function requireObjectIsPrototypeOf () {
		if (hasRequiredObjectIsPrototypeOf) return objectIsPrototypeOf;
		hasRequiredObjectIsPrototypeOf = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		objectIsPrototypeOf = uncurryThis({}.isPrototypeOf);
		return objectIsPrototypeOf;
	}

	var es_array_slice = {};

	var globalThis_1;
	var hasRequiredGlobalThis$6;

	function requireGlobalThis$6 () {
		if (hasRequiredGlobalThis$6) return globalThis_1;
		hasRequiredGlobalThis$6 = 1;
		var check = function (it) {
		  return it && it.Math === Math && it;
		};

		// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
		globalThis_1 =
		  // eslint-disable-next-line es/no-global-this -- safe
		  check(typeof globalThis == 'object' && globalThis) ||
		  check(typeof window == 'object' && window) ||
		  // eslint-disable-next-line no-restricted-globals -- safe
		  check(typeof self == 'object' && self) ||
		  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
		  check(typeof globalThis_1 == 'object' && globalThis_1) ||
		  // eslint-disable-next-line no-new-func -- fallback
		  (function () { return this; })() || Function('return this')();
		return globalThis_1;
	}

	var functionApply;
	var hasRequiredFunctionApply;

	function requireFunctionApply () {
		if (hasRequiredFunctionApply) return functionApply;
		hasRequiredFunctionApply = 1;
		var NATIVE_BIND = /*@__PURE__*/ requireFunctionBindNative();

		var FunctionPrototype = Function.prototype;
		var apply = FunctionPrototype.apply;
		var call = FunctionPrototype.call;

		// eslint-disable-next-line es/no-function-prototype-bind, es/no-reflect -- safe
		functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND ? call.bind(apply) : function () {
		  return call.apply(apply, arguments);
		});
		return functionApply;
	}

	var classofRaw;
	var hasRequiredClassofRaw;

	function requireClassofRaw () {
		if (hasRequiredClassofRaw) return classofRaw;
		hasRequiredClassofRaw = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		var toString = uncurryThis({}.toString);
		var stringSlice = uncurryThis(''.slice);

		classofRaw = function (it) {
		  return stringSlice(toString(it), 8, -1);
		};
		return classofRaw;
	}

	var functionUncurryThisClause;
	var hasRequiredFunctionUncurryThisClause;

	function requireFunctionUncurryThisClause () {
		if (hasRequiredFunctionUncurryThisClause) return functionUncurryThisClause;
		hasRequiredFunctionUncurryThisClause = 1;
		var classofRaw = /*@__PURE__*/ requireClassofRaw();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		functionUncurryThisClause = function (fn) {
		  // Nashorn bug:
		  //   https://github.com/zloirock/core-js/issues/1128
		  //   https://github.com/zloirock/core-js/issues/1130
		  if (classofRaw(fn) === 'Function') return uncurryThis(fn);
		};
		return functionUncurryThisClause;
	}

	var isCallable;
	var hasRequiredIsCallable;

	function requireIsCallable () {
		if (hasRequiredIsCallable) return isCallable;
		hasRequiredIsCallable = 1;
		// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
		var documentAll = typeof document == 'object' && document.all;

		// `IsCallable` abstract operation
		// https://tc39.es/ecma262/#sec-iscallable
		// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
		isCallable = typeof documentAll == 'undefined' && documentAll !== undefined ? function (argument) {
		  return typeof argument == 'function' || argument === documentAll;
		} : function (argument) {
		  return typeof argument == 'function';
		};
		return isCallable;
	}

	var objectGetOwnPropertyDescriptor = {};

	var descriptors;
	var hasRequiredDescriptors;

	function requireDescriptors () {
		if (hasRequiredDescriptors) return descriptors;
		hasRequiredDescriptors = 1;
		var fails = /*@__PURE__*/ requireFails();

		// Detect IE8's incomplete defineProperty implementation
		descriptors = !fails(function () {
		  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
		  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] !== 7;
		});
		return descriptors;
	}

	var functionCall;
	var hasRequiredFunctionCall;

	function requireFunctionCall () {
		if (hasRequiredFunctionCall) return functionCall;
		hasRequiredFunctionCall = 1;
		var NATIVE_BIND = /*@__PURE__*/ requireFunctionBindNative();

		var call = Function.prototype.call;
		// eslint-disable-next-line es/no-function-prototype-bind -- safe
		functionCall = NATIVE_BIND ? call.bind(call) : function () {
		  return call.apply(call, arguments);
		};
		return functionCall;
	}

	var objectPropertyIsEnumerable = {};

	var hasRequiredObjectPropertyIsEnumerable;

	function requireObjectPropertyIsEnumerable () {
		if (hasRequiredObjectPropertyIsEnumerable) return objectPropertyIsEnumerable;
		hasRequiredObjectPropertyIsEnumerable = 1;
		var $propertyIsEnumerable = {}.propertyIsEnumerable;
		// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
		var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

		// Nashorn ~ JDK8 bug
		var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);

		// `Object.prototype.propertyIsEnumerable` method implementation
		// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
		objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
		  var descriptor = getOwnPropertyDescriptor(this, V);
		  return !!descriptor && descriptor.enumerable;
		} : $propertyIsEnumerable;
		return objectPropertyIsEnumerable;
	}

	var createPropertyDescriptor;
	var hasRequiredCreatePropertyDescriptor;

	function requireCreatePropertyDescriptor () {
		if (hasRequiredCreatePropertyDescriptor) return createPropertyDescriptor;
		hasRequiredCreatePropertyDescriptor = 1;
		createPropertyDescriptor = function (bitmap, value) {
		  return {
		    enumerable: !(bitmap & 1),
		    configurable: !(bitmap & 2),
		    writable: !(bitmap & 4),
		    value: value
		  };
		};
		return createPropertyDescriptor;
	}

	var indexedObject;
	var hasRequiredIndexedObject;

	function requireIndexedObject () {
		if (hasRequiredIndexedObject) return indexedObject;
		hasRequiredIndexedObject = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var fails = /*@__PURE__*/ requireFails();
		var classof = /*@__PURE__*/ requireClassofRaw();

		var $Object = Object;
		var split = uncurryThis(''.split);

		// fallback for non-array-like ES3 and non-enumerable old V8 strings
		indexedObject = fails(function () {
		  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
		  // eslint-disable-next-line no-prototype-builtins -- safe
		  return !$Object('z').propertyIsEnumerable(0);
		}) ? function (it) {
		  return classof(it) === 'String' ? split(it, '') : $Object(it);
		} : $Object;
		return indexedObject;
	}

	var isNullOrUndefined;
	var hasRequiredIsNullOrUndefined;

	function requireIsNullOrUndefined () {
		if (hasRequiredIsNullOrUndefined) return isNullOrUndefined;
		hasRequiredIsNullOrUndefined = 1;
		// we can't use just `it == null` since of `document.all` special case
		// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
		isNullOrUndefined = function (it) {
		  return it === null || it === undefined;
		};
		return isNullOrUndefined;
	}

	var requireObjectCoercible;
	var hasRequiredRequireObjectCoercible;

	function requireRequireObjectCoercible () {
		if (hasRequiredRequireObjectCoercible) return requireObjectCoercible;
		hasRequiredRequireObjectCoercible = 1;
		var isNullOrUndefined = /*@__PURE__*/ requireIsNullOrUndefined();

		var $TypeError = TypeError;

		// `RequireObjectCoercible` abstract operation
		// https://tc39.es/ecma262/#sec-requireobjectcoercible
		requireObjectCoercible = function (it) {
		  if (isNullOrUndefined(it)) throw new $TypeError("Can't call method on " + it);
		  return it;
		};
		return requireObjectCoercible;
	}

	var toIndexedObject;
	var hasRequiredToIndexedObject;

	function requireToIndexedObject () {
		if (hasRequiredToIndexedObject) return toIndexedObject;
		hasRequiredToIndexedObject = 1;
		// toObject with fallback for non-array-like ES3 strings
		var IndexedObject = /*@__PURE__*/ requireIndexedObject();
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();

		toIndexedObject = function (it) {
		  return IndexedObject(requireObjectCoercible(it));
		};
		return toIndexedObject;
	}

	var isObject$2;
	var hasRequiredIsObject$1;

	function requireIsObject$1 () {
		if (hasRequiredIsObject$1) return isObject$2;
		hasRequiredIsObject$1 = 1;
		var isCallable = /*@__PURE__*/ requireIsCallable();

		isObject$2 = function (it) {
		  return typeof it == 'object' ? it !== null : isCallable(it);
		};
		return isObject$2;
	}

	var path$1;
	var hasRequiredPath$1;

	function requirePath$1 () {
		if (hasRequiredPath$1) return path$1;
		hasRequiredPath$1 = 1;
		path$1 = {};
		return path$1;
	}

	var getBuiltIn;
	var hasRequiredGetBuiltIn;

	function requireGetBuiltIn () {
		if (hasRequiredGetBuiltIn) return getBuiltIn;
		hasRequiredGetBuiltIn = 1;
		var path = /*@__PURE__*/ requirePath$1();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var isCallable = /*@__PURE__*/ requireIsCallable();

		var aFunction = function (variable) {
		  return isCallable(variable) ? variable : undefined;
		};

		getBuiltIn = function (namespace, method) {
		  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(globalThis[namespace])
		    : path[namespace] && path[namespace][method] || globalThis[namespace] && globalThis[namespace][method];
		};
		return getBuiltIn;
	}

	var environmentUserAgent;
	var hasRequiredEnvironmentUserAgent;

	function requireEnvironmentUserAgent () {
		if (hasRequiredEnvironmentUserAgent) return environmentUserAgent;
		hasRequiredEnvironmentUserAgent = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();

		var navigator = globalThis.navigator;
		var userAgent = navigator && navigator.userAgent;

		environmentUserAgent = userAgent ? String(userAgent) : '';
		return environmentUserAgent;
	}

	var environmentV8Version;
	var hasRequiredEnvironmentV8Version;

	function requireEnvironmentV8Version () {
		if (hasRequiredEnvironmentV8Version) return environmentV8Version;
		hasRequiredEnvironmentV8Version = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var userAgent = /*@__PURE__*/ requireEnvironmentUserAgent();

		var process = globalThis.process;
		var Deno = globalThis.Deno;
		var versions = process && process.versions || Deno && Deno.version;
		var v8 = versions && versions.v8;
		var match, version;

		if (v8) {
		  match = v8.split('.');
		  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
		  // but their correct versions are not interesting for us
		  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
		}

		// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
		// so check `userAgent` even if `.v8` exists, but 0
		if (!version && userAgent) {
		  match = userAgent.match(/Edge\/(\d+)/);
		  if (!match || match[1] >= 74) {
		    match = userAgent.match(/Chrome\/(\d+)/);
		    if (match) version = +match[1];
		  }
		}

		environmentV8Version = version;
		return environmentV8Version;
	}

	var symbolConstructorDetection;
	var hasRequiredSymbolConstructorDetection;

	function requireSymbolConstructorDetection () {
		if (hasRequiredSymbolConstructorDetection) return symbolConstructorDetection;
		hasRequiredSymbolConstructorDetection = 1;
		/* eslint-disable es/no-symbol -- required for testing */
		var V8_VERSION = /*@__PURE__*/ requireEnvironmentV8Version();
		var fails = /*@__PURE__*/ requireFails();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();

		var $String = globalThis.String;

		// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
		symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails(function () {
		  var symbol = Symbol('symbol detection');
		  // Chrome 38 Symbol has incorrect toString conversion
		  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
		  // nb: Do not call `String` directly to avoid this being optimized out to `symbol+''` which will,
		  // of course, fail.
		  return !$String(symbol) || !(Object(symbol) instanceof Symbol) ||
		    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
		    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
		});
		return symbolConstructorDetection;
	}

	var useSymbolAsUid;
	var hasRequiredUseSymbolAsUid;

	function requireUseSymbolAsUid () {
		if (hasRequiredUseSymbolAsUid) return useSymbolAsUid;
		hasRequiredUseSymbolAsUid = 1;
		/* eslint-disable es/no-symbol -- required for testing */
		var NATIVE_SYMBOL = /*@__PURE__*/ requireSymbolConstructorDetection();

		useSymbolAsUid = NATIVE_SYMBOL &&
		  !Symbol.sham &&
		  typeof Symbol.iterator == 'symbol';
		return useSymbolAsUid;
	}

	var isSymbol;
	var hasRequiredIsSymbol;

	function requireIsSymbol () {
		if (hasRequiredIsSymbol) return isSymbol;
		hasRequiredIsSymbol = 1;
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var USE_SYMBOL_AS_UID = /*@__PURE__*/ requireUseSymbolAsUid();

		var $Object = Object;

		isSymbol = USE_SYMBOL_AS_UID ? function (it) {
		  return typeof it == 'symbol';
		} : function (it) {
		  var $Symbol = getBuiltIn('Symbol');
		  return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it));
		};
		return isSymbol;
	}

	var tryToString;
	var hasRequiredTryToString;

	function requireTryToString () {
		if (hasRequiredTryToString) return tryToString;
		hasRequiredTryToString = 1;
		var $String = String;

		tryToString = function (argument) {
		  try {
		    return $String(argument);
		  } catch (error) {
		    return 'Object';
		  }
		};
		return tryToString;
	}

	var aCallable;
	var hasRequiredACallable;

	function requireACallable () {
		if (hasRequiredACallable) return aCallable;
		hasRequiredACallable = 1;
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var tryToString = /*@__PURE__*/ requireTryToString();

		var $TypeError = TypeError;

		// `Assert: IsCallable(argument) is true`
		aCallable = function (argument) {
		  if (isCallable(argument)) return argument;
		  throw new $TypeError(tryToString(argument) + ' is not a function');
		};
		return aCallable;
	}

	var getMethod;
	var hasRequiredGetMethod;

	function requireGetMethod () {
		if (hasRequiredGetMethod) return getMethod;
		hasRequiredGetMethod = 1;
		var aCallable = /*@__PURE__*/ requireACallable();
		var isNullOrUndefined = /*@__PURE__*/ requireIsNullOrUndefined();

		// `GetMethod` abstract operation
		// https://tc39.es/ecma262/#sec-getmethod
		getMethod = function (V, P) {
		  var func = V[P];
		  return isNullOrUndefined(func) ? undefined : aCallable(func);
		};
		return getMethod;
	}

	var ordinaryToPrimitive;
	var hasRequiredOrdinaryToPrimitive;

	function requireOrdinaryToPrimitive () {
		if (hasRequiredOrdinaryToPrimitive) return ordinaryToPrimitive;
		hasRequiredOrdinaryToPrimitive = 1;
		var call = /*@__PURE__*/ requireFunctionCall();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var isObject = /*@__PURE__*/ requireIsObject$1();

		var $TypeError = TypeError;

		// `OrdinaryToPrimitive` abstract operation
		// https://tc39.es/ecma262/#sec-ordinarytoprimitive
		ordinaryToPrimitive = function (input, pref) {
		  var fn, val;
		  if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
		  if (isCallable(fn = input.valueOf) && !isObject(val = call(fn, input))) return val;
		  if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
		  throw new $TypeError("Can't convert object to primitive value");
		};
		return ordinaryToPrimitive;
	}

	var sharedStore = {exports: {}};

	var isPure;
	var hasRequiredIsPure;

	function requireIsPure () {
		if (hasRequiredIsPure) return isPure;
		hasRequiredIsPure = 1;
		isPure = true;
		return isPure;
	}

	var defineGlobalProperty;
	var hasRequiredDefineGlobalProperty;

	function requireDefineGlobalProperty () {
		if (hasRequiredDefineGlobalProperty) return defineGlobalProperty;
		hasRequiredDefineGlobalProperty = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();

		// eslint-disable-next-line es/no-object-defineproperty -- safe
		var defineProperty = Object.defineProperty;

		defineGlobalProperty = function (key, value) {
		  try {
		    defineProperty(globalThis, key, { value: value, configurable: true, writable: true });
		  } catch (error) {
		    globalThis[key] = value;
		  } return value;
		};
		return defineGlobalProperty;
	}

	var hasRequiredSharedStore;

	function requireSharedStore () {
		if (hasRequiredSharedStore) return sharedStore.exports;
		hasRequiredSharedStore = 1;
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var defineGlobalProperty = /*@__PURE__*/ requireDefineGlobalProperty();

		var SHARED = '__core-js_shared__';
		var store = sharedStore.exports = globalThis[SHARED] || defineGlobalProperty(SHARED, {});

		(store.versions || (store.versions = [])).push({
		  version: '3.42.0',
		  mode: IS_PURE ? 'pure' : 'global',
		  copyright: '© 2014-2025 Denis Pushkarev (zloirock.ru)',
		  license: 'https://github.com/zloirock/core-js/blob/v3.42.0/LICENSE',
		  source: 'https://github.com/zloirock/core-js'
		});
		return sharedStore.exports;
	}

	var shared;
	var hasRequiredShared;

	function requireShared () {
		if (hasRequiredShared) return shared;
		hasRequiredShared = 1;
		var store = /*@__PURE__*/ requireSharedStore();

		shared = function (key, value) {
		  return store[key] || (store[key] = value || {});
		};
		return shared;
	}

	var toObject;
	var hasRequiredToObject;

	function requireToObject () {
		if (hasRequiredToObject) return toObject;
		hasRequiredToObject = 1;
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();

		var $Object = Object;

		// `ToObject` abstract operation
		// https://tc39.es/ecma262/#sec-toobject
		toObject = function (argument) {
		  return $Object(requireObjectCoercible(argument));
		};
		return toObject;
	}

	var hasOwnProperty_1;
	var hasRequiredHasOwnProperty;

	function requireHasOwnProperty () {
		if (hasRequiredHasOwnProperty) return hasOwnProperty_1;
		hasRequiredHasOwnProperty = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var toObject = /*@__PURE__*/ requireToObject();

		var hasOwnProperty = uncurryThis({}.hasOwnProperty);

		// `HasOwnProperty` abstract operation
		// https://tc39.es/ecma262/#sec-hasownproperty
		// eslint-disable-next-line es/no-object-hasown -- safe
		hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
		  return hasOwnProperty(toObject(it), key);
		};
		return hasOwnProperty_1;
	}

	var uid;
	var hasRequiredUid;

	function requireUid () {
		if (hasRequiredUid) return uid;
		hasRequiredUid = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		var id = 0;
		var postfix = Math.random();
		var toString = uncurryThis(1.0.toString);

		uid = function (key) {
		  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
		};
		return uid;
	}

	var wellKnownSymbol;
	var hasRequiredWellKnownSymbol;

	function requireWellKnownSymbol () {
		if (hasRequiredWellKnownSymbol) return wellKnownSymbol;
		hasRequiredWellKnownSymbol = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var shared = /*@__PURE__*/ requireShared();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var uid = /*@__PURE__*/ requireUid();
		var NATIVE_SYMBOL = /*@__PURE__*/ requireSymbolConstructorDetection();
		var USE_SYMBOL_AS_UID = /*@__PURE__*/ requireUseSymbolAsUid();

		var Symbol = globalThis.Symbol;
		var WellKnownSymbolsStore = shared('wks');
		var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol['for'] || Symbol : Symbol && Symbol.withoutSetter || uid;

		wellKnownSymbol = function (name) {
		  if (!hasOwn(WellKnownSymbolsStore, name)) {
		    WellKnownSymbolsStore[name] = NATIVE_SYMBOL && hasOwn(Symbol, name)
		      ? Symbol[name]
		      : createWellKnownSymbol('Symbol.' + name);
		  } return WellKnownSymbolsStore[name];
		};
		return wellKnownSymbol;
	}

	var toPrimitive$6;
	var hasRequiredToPrimitive$5;

	function requireToPrimitive$5 () {
		if (hasRequiredToPrimitive$5) return toPrimitive$6;
		hasRequiredToPrimitive$5 = 1;
		var call = /*@__PURE__*/ requireFunctionCall();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var isSymbol = /*@__PURE__*/ requireIsSymbol();
		var getMethod = /*@__PURE__*/ requireGetMethod();
		var ordinaryToPrimitive = /*@__PURE__*/ requireOrdinaryToPrimitive();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var $TypeError = TypeError;
		var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');

		// `ToPrimitive` abstract operation
		// https://tc39.es/ecma262/#sec-toprimitive
		toPrimitive$6 = function (input, pref) {
		  if (!isObject(input) || isSymbol(input)) return input;
		  var exoticToPrim = getMethod(input, TO_PRIMITIVE);
		  var result;
		  if (exoticToPrim) {
		    if (pref === undefined) pref = 'default';
		    result = call(exoticToPrim, input, pref);
		    if (!isObject(result) || isSymbol(result)) return result;
		    throw new $TypeError("Can't convert object to primitive value");
		  }
		  if (pref === undefined) pref = 'number';
		  return ordinaryToPrimitive(input, pref);
		};
		return toPrimitive$6;
	}

	var toPropertyKey$1;
	var hasRequiredToPropertyKey;

	function requireToPropertyKey () {
		if (hasRequiredToPropertyKey) return toPropertyKey$1;
		hasRequiredToPropertyKey = 1;
		var toPrimitive = /*@__PURE__*/ requireToPrimitive$5();
		var isSymbol = /*@__PURE__*/ requireIsSymbol();

		// `ToPropertyKey` abstract operation
		// https://tc39.es/ecma262/#sec-topropertykey
		toPropertyKey$1 = function (argument) {
		  var key = toPrimitive(argument, 'string');
		  return isSymbol(key) ? key : key + '';
		};
		return toPropertyKey$1;
	}

	var documentCreateElement;
	var hasRequiredDocumentCreateElement;

	function requireDocumentCreateElement () {
		if (hasRequiredDocumentCreateElement) return documentCreateElement;
		hasRequiredDocumentCreateElement = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var isObject = /*@__PURE__*/ requireIsObject$1();

		var document = globalThis.document;
		// typeof document.createElement is 'object' in old IE
		var EXISTS = isObject(document) && isObject(document.createElement);

		documentCreateElement = function (it) {
		  return EXISTS ? document.createElement(it) : {};
		};
		return documentCreateElement;
	}

	var ie8DomDefine;
	var hasRequiredIe8DomDefine;

	function requireIe8DomDefine () {
		if (hasRequiredIe8DomDefine) return ie8DomDefine;
		hasRequiredIe8DomDefine = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var fails = /*@__PURE__*/ requireFails();
		var createElement = /*@__PURE__*/ requireDocumentCreateElement();

		// Thanks to IE8 for its funny defineProperty
		ie8DomDefine = !DESCRIPTORS && !fails(function () {
		  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
		  return Object.defineProperty(createElement('div'), 'a', {
		    get: function () { return 7; }
		  }).a !== 7;
		});
		return ie8DomDefine;
	}

	var hasRequiredObjectGetOwnPropertyDescriptor;

	function requireObjectGetOwnPropertyDescriptor () {
		if (hasRequiredObjectGetOwnPropertyDescriptor) return objectGetOwnPropertyDescriptor;
		hasRequiredObjectGetOwnPropertyDescriptor = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var call = /*@__PURE__*/ requireFunctionCall();
		var propertyIsEnumerableModule = /*@__PURE__*/ requireObjectPropertyIsEnumerable();
		var createPropertyDescriptor = /*@__PURE__*/ requireCreatePropertyDescriptor();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var toPropertyKey = /*@__PURE__*/ requireToPropertyKey();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var IE8_DOM_DEFINE = /*@__PURE__*/ requireIe8DomDefine();

		// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
		var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

		// `Object.getOwnPropertyDescriptor` method
		// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
		objectGetOwnPropertyDescriptor.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
		  O = toIndexedObject(O);
		  P = toPropertyKey(P);
		  if (IE8_DOM_DEFINE) try {
		    return $getOwnPropertyDescriptor(O, P);
		  } catch (error) { /* empty */ }
		  if (hasOwn(O, P)) return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
		};
		return objectGetOwnPropertyDescriptor;
	}

	var isForced_1;
	var hasRequiredIsForced;

	function requireIsForced () {
		if (hasRequiredIsForced) return isForced_1;
		hasRequiredIsForced = 1;
		var fails = /*@__PURE__*/ requireFails();
		var isCallable = /*@__PURE__*/ requireIsCallable();

		var replacement = /#|\.prototype\./;

		var isForced = function (feature, detection) {
		  var value = data[normalize(feature)];
		  return value === POLYFILL ? true
		    : value === NATIVE ? false
		    : isCallable(detection) ? fails(detection)
		    : !!detection;
		};

		var normalize = isForced.normalize = function (string) {
		  return String(string).replace(replacement, '.').toLowerCase();
		};

		var data = isForced.data = {};
		var NATIVE = isForced.NATIVE = 'N';
		var POLYFILL = isForced.POLYFILL = 'P';

		isForced_1 = isForced;
		return isForced_1;
	}

	var functionBindContext;
	var hasRequiredFunctionBindContext;

	function requireFunctionBindContext () {
		if (hasRequiredFunctionBindContext) return functionBindContext;
		hasRequiredFunctionBindContext = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThisClause();
		var aCallable = /*@__PURE__*/ requireACallable();
		var NATIVE_BIND = /*@__PURE__*/ requireFunctionBindNative();

		var bind = uncurryThis(uncurryThis.bind);

		// optional / simple context binding
		functionBindContext = function (fn, that) {
		  aCallable(fn);
		  return that === undefined ? fn : NATIVE_BIND ? bind(fn, that) : function (/* ...args */) {
		    return fn.apply(that, arguments);
		  };
		};
		return functionBindContext;
	}

	var objectDefineProperty = {};

	var v8PrototypeDefineBug;
	var hasRequiredV8PrototypeDefineBug;

	function requireV8PrototypeDefineBug () {
		if (hasRequiredV8PrototypeDefineBug) return v8PrototypeDefineBug;
		hasRequiredV8PrototypeDefineBug = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var fails = /*@__PURE__*/ requireFails();

		// V8 ~ Chrome 36-
		// https://bugs.chromium.org/p/v8/issues/detail?id=3334
		v8PrototypeDefineBug = DESCRIPTORS && fails(function () {
		  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
		  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
		    value: 42,
		    writable: false
		  }).prototype !== 42;
		});
		return v8PrototypeDefineBug;
	}

	var anObject;
	var hasRequiredAnObject;

	function requireAnObject () {
		if (hasRequiredAnObject) return anObject;
		hasRequiredAnObject = 1;
		var isObject = /*@__PURE__*/ requireIsObject$1();

		var $String = String;
		var $TypeError = TypeError;

		// `Assert: Type(argument) is Object`
		anObject = function (argument) {
		  if (isObject(argument)) return argument;
		  throw new $TypeError($String(argument) + ' is not an object');
		};
		return anObject;
	}

	var hasRequiredObjectDefineProperty;

	function requireObjectDefineProperty () {
		if (hasRequiredObjectDefineProperty) return objectDefineProperty;
		hasRequiredObjectDefineProperty = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var IE8_DOM_DEFINE = /*@__PURE__*/ requireIe8DomDefine();
		var V8_PROTOTYPE_DEFINE_BUG = /*@__PURE__*/ requireV8PrototypeDefineBug();
		var anObject = /*@__PURE__*/ requireAnObject();
		var toPropertyKey = /*@__PURE__*/ requireToPropertyKey();

		var $TypeError = TypeError;
		// eslint-disable-next-line es/no-object-defineproperty -- safe
		var $defineProperty = Object.defineProperty;
		// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
		var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
		var ENUMERABLE = 'enumerable';
		var CONFIGURABLE = 'configurable';
		var WRITABLE = 'writable';

		// `Object.defineProperty` method
		// https://tc39.es/ecma262/#sec-object.defineproperty
		objectDefineProperty.f = DESCRIPTORS ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty(O, P, Attributes) {
		  anObject(O);
		  P = toPropertyKey(P);
		  anObject(Attributes);
		  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
		    var current = $getOwnPropertyDescriptor(O, P);
		    if (current && current[WRITABLE]) {
		      O[P] = Attributes.value;
		      Attributes = {
		        configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
		        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
		        writable: false
		      };
		    }
		  } return $defineProperty(O, P, Attributes);
		} : $defineProperty : function defineProperty(O, P, Attributes) {
		  anObject(O);
		  P = toPropertyKey(P);
		  anObject(Attributes);
		  if (IE8_DOM_DEFINE) try {
		    return $defineProperty(O, P, Attributes);
		  } catch (error) { /* empty */ }
		  if ('get' in Attributes || 'set' in Attributes) throw new $TypeError('Accessors not supported');
		  if ('value' in Attributes) O[P] = Attributes.value;
		  return O;
		};
		return objectDefineProperty;
	}

	var createNonEnumerableProperty;
	var hasRequiredCreateNonEnumerableProperty;

	function requireCreateNonEnumerableProperty () {
		if (hasRequiredCreateNonEnumerableProperty) return createNonEnumerableProperty;
		hasRequiredCreateNonEnumerableProperty = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var definePropertyModule = /*@__PURE__*/ requireObjectDefineProperty();
		var createPropertyDescriptor = /*@__PURE__*/ requireCreatePropertyDescriptor();

		createNonEnumerableProperty = DESCRIPTORS ? function (object, key, value) {
		  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
		} : function (object, key, value) {
		  object[key] = value;
		  return object;
		};
		return createNonEnumerableProperty;
	}

	var _export$1;
	var hasRequired_export;

	function require_export () {
		if (hasRequired_export) return _export$1;
		hasRequired_export = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var apply = /*@__PURE__*/ requireFunctionApply();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThisClause();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var getOwnPropertyDescriptor = /*@__PURE__*/ requireObjectGetOwnPropertyDescriptor().f;
		var isForced = /*@__PURE__*/ requireIsForced();
		var path = /*@__PURE__*/ requirePath$1();
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();

		var wrapConstructor = function (NativeConstructor) {
		  var Wrapper = function (a, b, c) {
		    if (this instanceof Wrapper) {
		      switch (arguments.length) {
		        case 0: return new NativeConstructor();
		        case 1: return new NativeConstructor(a);
		        case 2: return new NativeConstructor(a, b);
		      } return new NativeConstructor(a, b, c);
		    } return apply(NativeConstructor, this, arguments);
		  };
		  Wrapper.prototype = NativeConstructor.prototype;
		  return Wrapper;
		};

		/*
		  options.target         - name of the target object
		  options.global         - target is the global object
		  options.stat           - export as static methods of target
		  options.proto          - export as prototype methods of target
		  options.real           - real prototype method for the `pure` version
		  options.forced         - export even if the native feature is available
		  options.bind           - bind methods to the target, required for the `pure` version
		  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
		  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
		  options.sham           - add a flag to not completely full polyfills
		  options.enumerable     - export as enumerable property
		  options.dontCallGetSet - prevent calling a getter on target
		  options.name           - the .name of the function if it does not match the key
		*/
		_export$1 = function (options, source) {
		  var TARGET = options.target;
		  var GLOBAL = options.global;
		  var STATIC = options.stat;
		  var PROTO = options.proto;

		  var nativeSource = GLOBAL ? globalThis : STATIC ? globalThis[TARGET] : globalThis[TARGET] && globalThis[TARGET].prototype;

		  var target = GLOBAL ? path : path[TARGET] || createNonEnumerableProperty(path, TARGET, {})[TARGET];
		  var targetPrototype = target.prototype;

		  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
		  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

		  for (key in source) {
		    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
		    // contains in native
		    USE_NATIVE = !FORCED && nativeSource && hasOwn(nativeSource, key);

		    targetProperty = target[key];

		    if (USE_NATIVE) if (options.dontCallGetSet) {
		      descriptor = getOwnPropertyDescriptor(nativeSource, key);
		      nativeProperty = descriptor && descriptor.value;
		    } else nativeProperty = nativeSource[key];

		    // export native or implementation
		    sourceProperty = (USE_NATIVE && nativeProperty) ? nativeProperty : source[key];

		    if (!FORCED && !PROTO && typeof targetProperty == typeof sourceProperty) continue;

		    // bind methods to global for calling from export context
		    if (options.bind && USE_NATIVE) resultProperty = bind(sourceProperty, globalThis);
		    // wrap global constructors for prevent changes in this version
		    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty);
		    // make static versions for prototype methods
		    else if (PROTO && isCallable(sourceProperty)) resultProperty = uncurryThis(sourceProperty);
		    // default case
		    else resultProperty = sourceProperty;

		    // add a flag to not completely full polyfills
		    if (options.sham || (sourceProperty && sourceProperty.sham) || (targetProperty && targetProperty.sham)) {
		      createNonEnumerableProperty(resultProperty, 'sham', true);
		    }

		    createNonEnumerableProperty(target, key, resultProperty);

		    if (PROTO) {
		      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
		      if (!hasOwn(path, VIRTUAL_PROTOTYPE)) {
		        createNonEnumerableProperty(path, VIRTUAL_PROTOTYPE, {});
		      }
		      // export virtual prototype methods
		      createNonEnumerableProperty(path[VIRTUAL_PROTOTYPE], key, sourceProperty);
		      // export real prototype methods
		      if (options.real && targetPrototype && (FORCED || !targetPrototype[key])) {
		        createNonEnumerableProperty(targetPrototype, key, sourceProperty);
		      }
		    }
		  }
		};
		return _export$1;
	}

	var isArray$8;
	var hasRequiredIsArray$7;

	function requireIsArray$7 () {
		if (hasRequiredIsArray$7) return isArray$8;
		hasRequiredIsArray$7 = 1;
		var classof = /*@__PURE__*/ requireClassofRaw();

		// `IsArray` abstract operation
		// https://tc39.es/ecma262/#sec-isarray
		// eslint-disable-next-line es/no-array-isarray -- safe
		isArray$8 = Array.isArray || function isArray(argument) {
		  return classof(argument) === 'Array';
		};
		return isArray$8;
	}

	var toStringTagSupport;
	var hasRequiredToStringTagSupport;

	function requireToStringTagSupport () {
		if (hasRequiredToStringTagSupport) return toStringTagSupport;
		hasRequiredToStringTagSupport = 1;
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var TO_STRING_TAG = wellKnownSymbol('toStringTag');
		var test = {};

		test[TO_STRING_TAG] = 'z';

		toStringTagSupport = String(test) === '[object z]';
		return toStringTagSupport;
	}

	var classof;
	var hasRequiredClassof;

	function requireClassof () {
		if (hasRequiredClassof) return classof;
		hasRequiredClassof = 1;
		var TO_STRING_TAG_SUPPORT = /*@__PURE__*/ requireToStringTagSupport();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var classofRaw = /*@__PURE__*/ requireClassofRaw();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var TO_STRING_TAG = wellKnownSymbol('toStringTag');
		var $Object = Object;

		// ES3 wrong here
		var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) === 'Arguments';

		// fallback for IE11 Script Access Denied error
		var tryGet = function (it, key) {
		  try {
		    return it[key];
		  } catch (error) { /* empty */ }
		};

		// getting tag from ES6+ `Object.prototype.toString`
		classof = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
		  var O, tag, result;
		  return it === undefined ? 'Undefined' : it === null ? 'Null'
		    // @@toStringTag case
		    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag
		    // builtinTag case
		    : CORRECT_ARGUMENTS ? classofRaw(O)
		    // ES3 arguments fallback
		    : (result = classofRaw(O)) === 'Object' && isCallable(O.callee) ? 'Arguments' : result;
		};
		return classof;
	}

	var inspectSource;
	var hasRequiredInspectSource;

	function requireInspectSource () {
		if (hasRequiredInspectSource) return inspectSource;
		hasRequiredInspectSource = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var store = /*@__PURE__*/ requireSharedStore();

		var functionToString = uncurryThis(Function.toString);

		// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
		if (!isCallable(store.inspectSource)) {
		  store.inspectSource = function (it) {
		    return functionToString(it);
		  };
		}

		inspectSource = store.inspectSource;
		return inspectSource;
	}

	var isConstructor;
	var hasRequiredIsConstructor;

	function requireIsConstructor () {
		if (hasRequiredIsConstructor) return isConstructor;
		hasRequiredIsConstructor = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var fails = /*@__PURE__*/ requireFails();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var classof = /*@__PURE__*/ requireClassof();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var inspectSource = /*@__PURE__*/ requireInspectSource();

		var noop = function () { /* empty */ };
		var construct = getBuiltIn('Reflect', 'construct');
		var constructorRegExp = /^\s*(?:class|function)\b/;
		var exec = uncurryThis(constructorRegExp.exec);
		var INCORRECT_TO_STRING = !constructorRegExp.test(noop);

		var isConstructorModern = function isConstructor(argument) {
		  if (!isCallable(argument)) return false;
		  try {
		    construct(noop, [], argument);
		    return true;
		  } catch (error) {
		    return false;
		  }
		};

		var isConstructorLegacy = function isConstructor(argument) {
		  if (!isCallable(argument)) return false;
		  switch (classof(argument)) {
		    case 'AsyncFunction':
		    case 'GeneratorFunction':
		    case 'AsyncGeneratorFunction': return false;
		  }
		  try {
		    // we can't check .prototype since constructors produced by .bind haven't it
		    // `Function#toString` throws on some built-it function in some legacy engines
		    // (for example, `DOMQuad` and similar in FF41-)
		    return INCORRECT_TO_STRING || !!exec(constructorRegExp, inspectSource(argument));
		  } catch (error) {
		    return true;
		  }
		};

		isConstructorLegacy.sham = true;

		// `IsConstructor` abstract operation
		// https://tc39.es/ecma262/#sec-isconstructor
		isConstructor = !construct || fails(function () {
		  var called;
		  return isConstructorModern(isConstructorModern.call)
		    || !isConstructorModern(Object)
		    || !isConstructorModern(function () { called = true; })
		    || called;
		}) ? isConstructorLegacy : isConstructorModern;
		return isConstructor;
	}

	var mathTrunc;
	var hasRequiredMathTrunc;

	function requireMathTrunc () {
		if (hasRequiredMathTrunc) return mathTrunc;
		hasRequiredMathTrunc = 1;
		var ceil = Math.ceil;
		var floor = Math.floor;

		// `Math.trunc` method
		// https://tc39.es/ecma262/#sec-math.trunc
		// eslint-disable-next-line es/no-math-trunc -- safe
		mathTrunc = Math.trunc || function trunc(x) {
		  var n = +x;
		  return (n > 0 ? floor : ceil)(n);
		};
		return mathTrunc;
	}

	var toIntegerOrInfinity;
	var hasRequiredToIntegerOrInfinity;

	function requireToIntegerOrInfinity () {
		if (hasRequiredToIntegerOrInfinity) return toIntegerOrInfinity;
		hasRequiredToIntegerOrInfinity = 1;
		var trunc = /*@__PURE__*/ requireMathTrunc();

		// `ToIntegerOrInfinity` abstract operation
		// https://tc39.es/ecma262/#sec-tointegerorinfinity
		toIntegerOrInfinity = function (argument) {
		  var number = +argument;
		  // eslint-disable-next-line no-self-compare -- NaN check
		  return number !== number || number === 0 ? 0 : trunc(number);
		};
		return toIntegerOrInfinity;
	}

	var toAbsoluteIndex;
	var hasRequiredToAbsoluteIndex;

	function requireToAbsoluteIndex () {
		if (hasRequiredToAbsoluteIndex) return toAbsoluteIndex;
		hasRequiredToAbsoluteIndex = 1;
		var toIntegerOrInfinity = /*@__PURE__*/ requireToIntegerOrInfinity();

		var max = Math.max;
		var min = Math.min;

		// Helper for a popular repeating case of the spec:
		// Let integer be ? ToInteger(index).
		// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
		toAbsoluteIndex = function (index, length) {
		  var integer = toIntegerOrInfinity(index);
		  return integer < 0 ? max(integer + length, 0) : min(integer, length);
		};
		return toAbsoluteIndex;
	}

	var toLength;
	var hasRequiredToLength;

	function requireToLength () {
		if (hasRequiredToLength) return toLength;
		hasRequiredToLength = 1;
		var toIntegerOrInfinity = /*@__PURE__*/ requireToIntegerOrInfinity();

		var min = Math.min;

		// `ToLength` abstract operation
		// https://tc39.es/ecma262/#sec-tolength
		toLength = function (argument) {
		  var len = toIntegerOrInfinity(argument);
		  return len > 0 ? min(len, 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
		};
		return toLength;
	}

	var lengthOfArrayLike;
	var hasRequiredLengthOfArrayLike;

	function requireLengthOfArrayLike () {
		if (hasRequiredLengthOfArrayLike) return lengthOfArrayLike;
		hasRequiredLengthOfArrayLike = 1;
		var toLength = /*@__PURE__*/ requireToLength();

		// `LengthOfArrayLike` abstract operation
		// https://tc39.es/ecma262/#sec-lengthofarraylike
		lengthOfArrayLike = function (obj) {
		  return toLength(obj.length);
		};
		return lengthOfArrayLike;
	}

	var createProperty;
	var hasRequiredCreateProperty;

	function requireCreateProperty () {
		if (hasRequiredCreateProperty) return createProperty;
		hasRequiredCreateProperty = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var definePropertyModule = /*@__PURE__*/ requireObjectDefineProperty();
		var createPropertyDescriptor = /*@__PURE__*/ requireCreatePropertyDescriptor();

		createProperty = function (object, key, value) {
		  if (DESCRIPTORS) definePropertyModule.f(object, key, createPropertyDescriptor(0, value));
		  else object[key] = value;
		};
		return createProperty;
	}

	var arrayMethodHasSpeciesSupport;
	var hasRequiredArrayMethodHasSpeciesSupport;

	function requireArrayMethodHasSpeciesSupport () {
		if (hasRequiredArrayMethodHasSpeciesSupport) return arrayMethodHasSpeciesSupport;
		hasRequiredArrayMethodHasSpeciesSupport = 1;
		var fails = /*@__PURE__*/ requireFails();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var V8_VERSION = /*@__PURE__*/ requireEnvironmentV8Version();

		var SPECIES = wellKnownSymbol('species');

		arrayMethodHasSpeciesSupport = function (METHOD_NAME) {
		  // We can't use this feature detection in V8 since it causes
		  // deoptimization and serious performance degradation
		  // https://github.com/zloirock/core-js/issues/677
		  return V8_VERSION >= 51 || !fails(function () {
		    var array = [];
		    var constructor = array.constructor = {};
		    constructor[SPECIES] = function () {
		      return { foo: 1 };
		    };
		    return array[METHOD_NAME](Boolean).foo !== 1;
		  });
		};
		return arrayMethodHasSpeciesSupport;
	}

	var arraySlice;
	var hasRequiredArraySlice;

	function requireArraySlice () {
		if (hasRequiredArraySlice) return arraySlice;
		hasRequiredArraySlice = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		arraySlice = uncurryThis([].slice);
		return arraySlice;
	}

	var hasRequiredEs_array_slice;

	function requireEs_array_slice () {
		if (hasRequiredEs_array_slice) return es_array_slice;
		hasRequiredEs_array_slice = 1;
		var $ = /*@__PURE__*/ require_export();
		var isArray = /*@__PURE__*/ requireIsArray$7();
		var isConstructor = /*@__PURE__*/ requireIsConstructor();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var toAbsoluteIndex = /*@__PURE__*/ requireToAbsoluteIndex();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var createProperty = /*@__PURE__*/ requireCreateProperty();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var arrayMethodHasSpeciesSupport = /*@__PURE__*/ requireArrayMethodHasSpeciesSupport();
		var nativeSlice = /*@__PURE__*/ requireArraySlice();

		var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('slice');

		var SPECIES = wellKnownSymbol('species');
		var $Array = Array;
		var max = Math.max;

		// `Array.prototype.slice` method
		// https://tc39.es/ecma262/#sec-array.prototype.slice
		// fallback for not array-like ES3 strings and DOM objects
		$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
		  slice: function slice(start, end) {
		    var O = toIndexedObject(this);
		    var length = lengthOfArrayLike(O);
		    var k = toAbsoluteIndex(start, length);
		    var fin = toAbsoluteIndex(end === undefined ? length : end, length);
		    // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
		    var Constructor, result, n;
		    if (isArray(O)) {
		      Constructor = O.constructor;
		      // cross-realm fallback
		      if (isConstructor(Constructor) && (Constructor === $Array || isArray(Constructor.prototype))) {
		        Constructor = undefined;
		      } else if (isObject(Constructor)) {
		        Constructor = Constructor[SPECIES];
		        if (Constructor === null) Constructor = undefined;
		      }
		      if (Constructor === $Array || Constructor === undefined) {
		        return nativeSlice(O, k, fin);
		      }
		    }
		    result = new (Constructor === undefined ? $Array : Constructor)(max(fin - k, 0));
		    for (n = 0; k < fin; k++, n++) if (k in O) createProperty(result, n, O[k]);
		    result.length = n;
		    return result;
		  }
		});
		return es_array_slice;
	}

	var getBuiltInPrototypeMethod;
	var hasRequiredGetBuiltInPrototypeMethod;

	function requireGetBuiltInPrototypeMethod () {
		if (hasRequiredGetBuiltInPrototypeMethod) return getBuiltInPrototypeMethod;
		hasRequiredGetBuiltInPrototypeMethod = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var path = /*@__PURE__*/ requirePath$1();

		getBuiltInPrototypeMethod = function (CONSTRUCTOR, METHOD) {
		  var Namespace = path[CONSTRUCTOR + 'Prototype'];
		  var pureMethod = Namespace && Namespace[METHOD];
		  if (pureMethod) return pureMethod;
		  var NativeConstructor = globalThis[CONSTRUCTOR];
		  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
		  return NativePrototype && NativePrototype[METHOD];
		};
		return getBuiltInPrototypeMethod;
	}

	var slice$6;
	var hasRequiredSlice$6;

	function requireSlice$6 () {
		if (hasRequiredSlice$6) return slice$6;
		hasRequiredSlice$6 = 1;
		requireEs_array_slice();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		slice$6 = getBuiltInPrototypeMethod('Array', 'slice');
		return slice$6;
	}

	var slice$5;
	var hasRequiredSlice$5;

	function requireSlice$5 () {
		if (hasRequiredSlice$5) return slice$5;
		hasRequiredSlice$5 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireSlice$6();

		var ArrayPrototype = Array.prototype;

		slice$5 = function (it) {
		  var own = it.slice;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.slice) ? method : own;
		};
		return slice$5;
	}

	var slice$4;
	var hasRequiredSlice$4;

	function requireSlice$4 () {
		if (hasRequiredSlice$4) return slice$4;
		hasRequiredSlice$4 = 1;
		var parent = /*@__PURE__*/ requireSlice$5();

		slice$4 = parent;
		return slice$4;
	}

	var slice$3;
	var hasRequiredSlice$3;
	function requireSlice$3() {
	  if (hasRequiredSlice$3) return slice$3;
	  hasRequiredSlice$3 = 1;
	  slice$3 = /*@__PURE__*/requireSlice$4();
	  return slice$3;
	}

	var sliceExports$1 = requireSlice$3();
	var _sliceInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(sliceExports$1);

	var es_array_concat = {};

	var doesNotExceedSafeInteger;
	var hasRequiredDoesNotExceedSafeInteger;

	function requireDoesNotExceedSafeInteger () {
		if (hasRequiredDoesNotExceedSafeInteger) return doesNotExceedSafeInteger;
		hasRequiredDoesNotExceedSafeInteger = 1;
		var $TypeError = TypeError;
		var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF; // 2 ** 53 - 1 == 9007199254740991

		doesNotExceedSafeInteger = function (it) {
		  if (it > MAX_SAFE_INTEGER) throw $TypeError('Maximum allowed index exceeded');
		  return it;
		};
		return doesNotExceedSafeInteger;
	}

	var arraySpeciesConstructor;
	var hasRequiredArraySpeciesConstructor;

	function requireArraySpeciesConstructor () {
		if (hasRequiredArraySpeciesConstructor) return arraySpeciesConstructor;
		hasRequiredArraySpeciesConstructor = 1;
		var isArray = /*@__PURE__*/ requireIsArray$7();
		var isConstructor = /*@__PURE__*/ requireIsConstructor();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var SPECIES = wellKnownSymbol('species');
		var $Array = Array;

		// a part of `ArraySpeciesCreate` abstract operation
		// https://tc39.es/ecma262/#sec-arrayspeciescreate
		arraySpeciesConstructor = function (originalArray) {
		  var C;
		  if (isArray(originalArray)) {
		    C = originalArray.constructor;
		    // cross-realm fallback
		    if (isConstructor(C) && (C === $Array || isArray(C.prototype))) C = undefined;
		    else if (isObject(C)) {
		      C = C[SPECIES];
		      if (C === null) C = undefined;
		    }
		  } return C === undefined ? $Array : C;
		};
		return arraySpeciesConstructor;
	}

	var arraySpeciesCreate;
	var hasRequiredArraySpeciesCreate;

	function requireArraySpeciesCreate () {
		if (hasRequiredArraySpeciesCreate) return arraySpeciesCreate;
		hasRequiredArraySpeciesCreate = 1;
		var arraySpeciesConstructor = /*@__PURE__*/ requireArraySpeciesConstructor();

		// `ArraySpeciesCreate` abstract operation
		// https://tc39.es/ecma262/#sec-arrayspeciescreate
		arraySpeciesCreate = function (originalArray, length) {
		  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
		};
		return arraySpeciesCreate;
	}

	var hasRequiredEs_array_concat;

	function requireEs_array_concat () {
		if (hasRequiredEs_array_concat) return es_array_concat;
		hasRequiredEs_array_concat = 1;
		var $ = /*@__PURE__*/ require_export();
		var fails = /*@__PURE__*/ requireFails();
		var isArray = /*@__PURE__*/ requireIsArray$7();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var toObject = /*@__PURE__*/ requireToObject();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var doesNotExceedSafeInteger = /*@__PURE__*/ requireDoesNotExceedSafeInteger();
		var createProperty = /*@__PURE__*/ requireCreateProperty();
		var arraySpeciesCreate = /*@__PURE__*/ requireArraySpeciesCreate();
		var arrayMethodHasSpeciesSupport = /*@__PURE__*/ requireArrayMethodHasSpeciesSupport();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var V8_VERSION = /*@__PURE__*/ requireEnvironmentV8Version();

		var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');

		// We can't use this feature detection in V8 since it causes
		// deoptimization and serious performance degradation
		// https://github.com/zloirock/core-js/issues/679
		var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails(function () {
		  var array = [];
		  array[IS_CONCAT_SPREADABLE] = false;
		  return array.concat()[0] !== array;
		});

		var isConcatSpreadable = function (O) {
		  if (!isObject(O)) return false;
		  var spreadable = O[IS_CONCAT_SPREADABLE];
		  return spreadable !== undefined ? !!spreadable : isArray(O);
		};

		var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !arrayMethodHasSpeciesSupport('concat');

		// `Array.prototype.concat` method
		// https://tc39.es/ecma262/#sec-array.prototype.concat
		// with adding support of @@isConcatSpreadable and @@species
		$({ target: 'Array', proto: true, arity: 1, forced: FORCED }, {
		  // eslint-disable-next-line no-unused-vars -- required for `.length`
		  concat: function concat(arg) {
		    var O = toObject(this);
		    var A = arraySpeciesCreate(O, 0);
		    var n = 0;
		    var i, k, length, len, E;
		    for (i = -1, length = arguments.length; i < length; i++) {
		      E = i === -1 ? O : arguments[i];
		      if (isConcatSpreadable(E)) {
		        len = lengthOfArrayLike(E);
		        doesNotExceedSafeInteger(n + len);
		        for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
		      } else {
		        doesNotExceedSafeInteger(n + 1);
		        createProperty(A, n++, E);
		      }
		    }
		    A.length = n;
		    return A;
		  }
		});
		return es_array_concat;
	}

	var concat$3;
	var hasRequiredConcat$3;

	function requireConcat$3 () {
		if (hasRequiredConcat$3) return concat$3;
		hasRequiredConcat$3 = 1;
		requireEs_array_concat();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		concat$3 = getBuiltInPrototypeMethod('Array', 'concat');
		return concat$3;
	}

	var concat$2;
	var hasRequiredConcat$2;

	function requireConcat$2 () {
		if (hasRequiredConcat$2) return concat$2;
		hasRequiredConcat$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireConcat$3();

		var ArrayPrototype = Array.prototype;

		concat$2 = function (it) {
		  var own = it.concat;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.concat) ? method : own;
		};
		return concat$2;
	}

	var concat$1;
	var hasRequiredConcat$1;

	function requireConcat$1 () {
		if (hasRequiredConcat$1) return concat$1;
		hasRequiredConcat$1 = 1;
		var parent = /*@__PURE__*/ requireConcat$2();

		concat$1 = parent;
		return concat$1;
	}

	var concat;
	var hasRequiredConcat;
	function requireConcat() {
	  if (hasRequiredConcat) return concat;
	  hasRequiredConcat = 1;
	  concat = /*@__PURE__*/requireConcat$1();
	  return concat;
	}

	var concatExports = requireConcat();
	var _concatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(concatExports);

	var web_urlSearchParams = {};

	var addToUnscopables;
	var hasRequiredAddToUnscopables;

	function requireAddToUnscopables () {
		if (hasRequiredAddToUnscopables) return addToUnscopables;
		hasRequiredAddToUnscopables = 1;
		addToUnscopables = function () { /* empty */ };
		return addToUnscopables;
	}

	var iterators;
	var hasRequiredIterators;

	function requireIterators () {
		if (hasRequiredIterators) return iterators;
		hasRequiredIterators = 1;
		iterators = {};
		return iterators;
	}

	var weakMapBasicDetection;
	var hasRequiredWeakMapBasicDetection;

	function requireWeakMapBasicDetection () {
		if (hasRequiredWeakMapBasicDetection) return weakMapBasicDetection;
		hasRequiredWeakMapBasicDetection = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var isCallable = /*@__PURE__*/ requireIsCallable();

		var WeakMap = globalThis.WeakMap;

		weakMapBasicDetection = isCallable(WeakMap) && /native code/.test(String(WeakMap));
		return weakMapBasicDetection;
	}

	var sharedKey;
	var hasRequiredSharedKey;

	function requireSharedKey () {
		if (hasRequiredSharedKey) return sharedKey;
		hasRequiredSharedKey = 1;
		var shared = /*@__PURE__*/ requireShared();
		var uid = /*@__PURE__*/ requireUid();

		var keys = shared('keys');

		sharedKey = function (key) {
		  return keys[key] || (keys[key] = uid(key));
		};
		return sharedKey;
	}

	var hiddenKeys;
	var hasRequiredHiddenKeys;

	function requireHiddenKeys () {
		if (hasRequiredHiddenKeys) return hiddenKeys;
		hasRequiredHiddenKeys = 1;
		hiddenKeys = {};
		return hiddenKeys;
	}

	var internalState;
	var hasRequiredInternalState;

	function requireInternalState () {
		if (hasRequiredInternalState) return internalState;
		hasRequiredInternalState = 1;
		var NATIVE_WEAK_MAP = /*@__PURE__*/ requireWeakMapBasicDetection();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var shared = /*@__PURE__*/ requireSharedStore();
		var sharedKey = /*@__PURE__*/ requireSharedKey();
		var hiddenKeys = /*@__PURE__*/ requireHiddenKeys();

		var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
		var TypeError = globalThis.TypeError;
		var WeakMap = globalThis.WeakMap;
		var set, get, has;

		var enforce = function (it) {
		  return has(it) ? get(it) : set(it, {});
		};

		var getterFor = function (TYPE) {
		  return function (it) {
		    var state;
		    if (!isObject(it) || (state = get(it)).type !== TYPE) {
		      throw new TypeError('Incompatible receiver, ' + TYPE + ' required');
		    } return state;
		  };
		};

		if (NATIVE_WEAK_MAP || shared.state) {
		  var store = shared.state || (shared.state = new WeakMap());
		  /* eslint-disable no-self-assign -- prototype methods protection */
		  store.get = store.get;
		  store.has = store.has;
		  store.set = store.set;
		  /* eslint-enable no-self-assign -- prototype methods protection */
		  set = function (it, metadata) {
		    if (store.has(it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
		    metadata.facade = it;
		    store.set(it, metadata);
		    return metadata;
		  };
		  get = function (it) {
		    return store.get(it) || {};
		  };
		  has = function (it) {
		    return store.has(it);
		  };
		} else {
		  var STATE = sharedKey('state');
		  hiddenKeys[STATE] = true;
		  set = function (it, metadata) {
		    if (hasOwn(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
		    metadata.facade = it;
		    createNonEnumerableProperty(it, STATE, metadata);
		    return metadata;
		  };
		  get = function (it) {
		    return hasOwn(it, STATE) ? it[STATE] : {};
		  };
		  has = function (it) {
		    return hasOwn(it, STATE);
		  };
		}

		internalState = {
		  set: set,
		  get: get,
		  has: has,
		  enforce: enforce,
		  getterFor: getterFor
		};
		return internalState;
	}

	var functionName;
	var hasRequiredFunctionName;

	function requireFunctionName () {
		if (hasRequiredFunctionName) return functionName;
		hasRequiredFunctionName = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();

		var FunctionPrototype = Function.prototype;
		// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
		var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;

		var EXISTS = hasOwn(FunctionPrototype, 'name');
		// additional protection from minified / mangled / dropped function names
		var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
		var CONFIGURABLE = EXISTS && (!DESCRIPTORS || (DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable));

		functionName = {
		  EXISTS: EXISTS,
		  PROPER: PROPER,
		  CONFIGURABLE: CONFIGURABLE
		};
		return functionName;
	}

	var objectDefineProperties = {};

	var arrayIncludes;
	var hasRequiredArrayIncludes;

	function requireArrayIncludes () {
		if (hasRequiredArrayIncludes) return arrayIncludes;
		hasRequiredArrayIncludes = 1;
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var toAbsoluteIndex = /*@__PURE__*/ requireToAbsoluteIndex();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();

		// `Array.prototype.{ indexOf, includes }` methods implementation
		var createMethod = function (IS_INCLUDES) {
		  return function ($this, el, fromIndex) {
		    var O = toIndexedObject($this);
		    var length = lengthOfArrayLike(O);
		    if (length === 0) return !IS_INCLUDES && -1;
		    var index = toAbsoluteIndex(fromIndex, length);
		    var value;
		    // Array#includes uses SameValueZero equality algorithm
		    // eslint-disable-next-line no-self-compare -- NaN check
		    if (IS_INCLUDES && el !== el) while (length > index) {
		      value = O[index++];
		      // eslint-disable-next-line no-self-compare -- NaN check
		      if (value !== value) return true;
		    // Array#indexOf ignores holes, Array#includes - not
		    } else for (;length > index; index++) {
		      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
		    } return !IS_INCLUDES && -1;
		  };
		};

		arrayIncludes = {
		  // `Array.prototype.includes` method
		  // https://tc39.es/ecma262/#sec-array.prototype.includes
		  includes: createMethod(true),
		  // `Array.prototype.indexOf` method
		  // https://tc39.es/ecma262/#sec-array.prototype.indexof
		  indexOf: createMethod(false)
		};
		return arrayIncludes;
	}

	var objectKeysInternal;
	var hasRequiredObjectKeysInternal;

	function requireObjectKeysInternal () {
		if (hasRequiredObjectKeysInternal) return objectKeysInternal;
		hasRequiredObjectKeysInternal = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var indexOf = /*@__PURE__*/ requireArrayIncludes().indexOf;
		var hiddenKeys = /*@__PURE__*/ requireHiddenKeys();

		var push = uncurryThis([].push);

		objectKeysInternal = function (object, names) {
		  var O = toIndexedObject(object);
		  var i = 0;
		  var result = [];
		  var key;
		  for (key in O) !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
		  // Don't enum bug & hidden keys
		  while (names.length > i) if (hasOwn(O, key = names[i++])) {
		    ~indexOf(result, key) || push(result, key);
		  }
		  return result;
		};
		return objectKeysInternal;
	}

	var enumBugKeys;
	var hasRequiredEnumBugKeys;

	function requireEnumBugKeys () {
		if (hasRequiredEnumBugKeys) return enumBugKeys;
		hasRequiredEnumBugKeys = 1;
		// IE8- don't enum bug keys
		enumBugKeys = [
		  'constructor',
		  'hasOwnProperty',
		  'isPrototypeOf',
		  'propertyIsEnumerable',
		  'toLocaleString',
		  'toString',
		  'valueOf'
		];
		return enumBugKeys;
	}

	var objectKeys;
	var hasRequiredObjectKeys;

	function requireObjectKeys () {
		if (hasRequiredObjectKeys) return objectKeys;
		hasRequiredObjectKeys = 1;
		var internalObjectKeys = /*@__PURE__*/ requireObjectKeysInternal();
		var enumBugKeys = /*@__PURE__*/ requireEnumBugKeys();

		// `Object.keys` method
		// https://tc39.es/ecma262/#sec-object.keys
		// eslint-disable-next-line es/no-object-keys -- safe
		objectKeys = Object.keys || function keys(O) {
		  return internalObjectKeys(O, enumBugKeys);
		};
		return objectKeys;
	}

	var hasRequiredObjectDefineProperties;

	function requireObjectDefineProperties () {
		if (hasRequiredObjectDefineProperties) return objectDefineProperties;
		hasRequiredObjectDefineProperties = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var V8_PROTOTYPE_DEFINE_BUG = /*@__PURE__*/ requireV8PrototypeDefineBug();
		var definePropertyModule = /*@__PURE__*/ requireObjectDefineProperty();
		var anObject = /*@__PURE__*/ requireAnObject();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var objectKeys = /*@__PURE__*/ requireObjectKeys();

		// `Object.defineProperties` method
		// https://tc39.es/ecma262/#sec-object.defineproperties
		// eslint-disable-next-line es/no-object-defineproperties -- safe
		objectDefineProperties.f = DESCRIPTORS && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
		  anObject(O);
		  var props = toIndexedObject(Properties);
		  var keys = objectKeys(Properties);
		  var length = keys.length;
		  var index = 0;
		  var key;
		  while (length > index) definePropertyModule.f(O, key = keys[index++], props[key]);
		  return O;
		};
		return objectDefineProperties;
	}

	var html;
	var hasRequiredHtml;

	function requireHtml () {
		if (hasRequiredHtml) return html;
		hasRequiredHtml = 1;
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();

		html = getBuiltIn('document', 'documentElement');
		return html;
	}

	var objectCreate;
	var hasRequiredObjectCreate;

	function requireObjectCreate () {
		if (hasRequiredObjectCreate) return objectCreate;
		hasRequiredObjectCreate = 1;
		/* global ActiveXObject -- old IE, WSH */
		var anObject = /*@__PURE__*/ requireAnObject();
		var definePropertiesModule = /*@__PURE__*/ requireObjectDefineProperties();
		var enumBugKeys = /*@__PURE__*/ requireEnumBugKeys();
		var hiddenKeys = /*@__PURE__*/ requireHiddenKeys();
		var html = /*@__PURE__*/ requireHtml();
		var documentCreateElement = /*@__PURE__*/ requireDocumentCreateElement();
		var sharedKey = /*@__PURE__*/ requireSharedKey();

		var GT = '>';
		var LT = '<';
		var PROTOTYPE = 'prototype';
		var SCRIPT = 'script';
		var IE_PROTO = sharedKey('IE_PROTO');

		var EmptyConstructor = function () { /* empty */ };

		var scriptTag = function (content) {
		  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
		};

		// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
		var NullProtoObjectViaActiveX = function (activeXDocument) {
		  activeXDocument.write(scriptTag(''));
		  activeXDocument.close();
		  var temp = activeXDocument.parentWindow.Object;
		  // eslint-disable-next-line no-useless-assignment -- avoid memory leak
		  activeXDocument = null;
		  return temp;
		};

		// Create object with fake `null` prototype: use iframe Object with cleared prototype
		var NullProtoObjectViaIFrame = function () {
		  // Thrash, waste and sodomy: IE GC bug
		  var iframe = documentCreateElement('iframe');
		  var JS = 'java' + SCRIPT + ':';
		  var iframeDocument;
		  iframe.style.display = 'none';
		  html.appendChild(iframe);
		  // https://github.com/zloirock/core-js/issues/475
		  iframe.src = String(JS);
		  iframeDocument = iframe.contentWindow.document;
		  iframeDocument.open();
		  iframeDocument.write(scriptTag('document.F=Object'));
		  iframeDocument.close();
		  return iframeDocument.F;
		};

		// Check for document.domain and active x support
		// No need to use active x approach when document.domain is not set
		// see https://github.com/es-shims/es5-shim/issues/150
		// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
		// avoid IE GC bug
		var activeXDocument;
		var NullProtoObject = function () {
		  try {
		    activeXDocument = new ActiveXObject('htmlfile');
		  } catch (error) { /* ignore */ }
		  NullProtoObject = typeof document != 'undefined'
		    ? document.domain && activeXDocument
		      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
		      : NullProtoObjectViaIFrame()
		    : NullProtoObjectViaActiveX(activeXDocument); // WSH
		  var length = enumBugKeys.length;
		  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
		  return NullProtoObject();
		};

		hiddenKeys[IE_PROTO] = true;

		// `Object.create` method
		// https://tc39.es/ecma262/#sec-object.create
		// eslint-disable-next-line es/no-object-create -- safe
		objectCreate = Object.create || function create(O, Properties) {
		  var result;
		  if (O !== null) {
		    EmptyConstructor[PROTOTYPE] = anObject(O);
		    result = new EmptyConstructor();
		    EmptyConstructor[PROTOTYPE] = null;
		    // add "__proto__" for Object.getPrototypeOf polyfill
		    result[IE_PROTO] = O;
		  } else result = NullProtoObject();
		  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
		};
		return objectCreate;
	}

	var correctPrototypeGetter;
	var hasRequiredCorrectPrototypeGetter;

	function requireCorrectPrototypeGetter () {
		if (hasRequiredCorrectPrototypeGetter) return correctPrototypeGetter;
		hasRequiredCorrectPrototypeGetter = 1;
		var fails = /*@__PURE__*/ requireFails();

		correctPrototypeGetter = !fails(function () {
		  function F() { /* empty */ }
		  F.prototype.constructor = null;
		  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
		  return Object.getPrototypeOf(new F()) !== F.prototype;
		});
		return correctPrototypeGetter;
	}

	var objectGetPrototypeOf;
	var hasRequiredObjectGetPrototypeOf;

	function requireObjectGetPrototypeOf () {
		if (hasRequiredObjectGetPrototypeOf) return objectGetPrototypeOf;
		hasRequiredObjectGetPrototypeOf = 1;
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var toObject = /*@__PURE__*/ requireToObject();
		var sharedKey = /*@__PURE__*/ requireSharedKey();
		var CORRECT_PROTOTYPE_GETTER = /*@__PURE__*/ requireCorrectPrototypeGetter();

		var IE_PROTO = sharedKey('IE_PROTO');
		var $Object = Object;
		var ObjectPrototype = $Object.prototype;

		// `Object.getPrototypeOf` method
		// https://tc39.es/ecma262/#sec-object.getprototypeof
		// eslint-disable-next-line es/no-object-getprototypeof -- safe
		objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function (O) {
		  var object = toObject(O);
		  if (hasOwn(object, IE_PROTO)) return object[IE_PROTO];
		  var constructor = object.constructor;
		  if (isCallable(constructor) && object instanceof constructor) {
		    return constructor.prototype;
		  } return object instanceof $Object ? ObjectPrototype : null;
		};
		return objectGetPrototypeOf;
	}

	var defineBuiltIn;
	var hasRequiredDefineBuiltIn;

	function requireDefineBuiltIn () {
		if (hasRequiredDefineBuiltIn) return defineBuiltIn;
		hasRequiredDefineBuiltIn = 1;
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();

		defineBuiltIn = function (target, key, value, options) {
		  if (options && options.enumerable) target[key] = value;
		  else createNonEnumerableProperty(target, key, value);
		  return target;
		};
		return defineBuiltIn;
	}

	var iteratorsCore;
	var hasRequiredIteratorsCore;

	function requireIteratorsCore () {
		if (hasRequiredIteratorsCore) return iteratorsCore;
		hasRequiredIteratorsCore = 1;
		var fails = /*@__PURE__*/ requireFails();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var create = /*@__PURE__*/ requireObjectCreate();
		var getPrototypeOf = /*@__PURE__*/ requireObjectGetPrototypeOf();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var IS_PURE = /*@__PURE__*/ requireIsPure();

		var ITERATOR = wellKnownSymbol('iterator');
		var BUGGY_SAFARI_ITERATORS = false;

		// `%IteratorPrototype%` object
		// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
		var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

		/* eslint-disable es/no-array-prototype-keys -- safe */
		if ([].keys) {
		  arrayIterator = [].keys();
		  // Safari 8 has buggy iterators w/o `next`
		  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
		  else {
		    PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
		    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
		  }
		}

		var NEW_ITERATOR_PROTOTYPE = !isObject(IteratorPrototype) || fails(function () {
		  var test = {};
		  // FF44- legacy iterators case
		  return IteratorPrototype[ITERATOR].call(test) !== test;
		});

		if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};
		else if (IS_PURE) IteratorPrototype = create(IteratorPrototype);

		// `%IteratorPrototype%[@@iterator]()` method
		// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
		if (!isCallable(IteratorPrototype[ITERATOR])) {
		  defineBuiltIn(IteratorPrototype, ITERATOR, function () {
		    return this;
		  });
		}

		iteratorsCore = {
		  IteratorPrototype: IteratorPrototype,
		  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
		};
		return iteratorsCore;
	}

	var objectToString$1;
	var hasRequiredObjectToString;

	function requireObjectToString () {
		if (hasRequiredObjectToString) return objectToString$1;
		hasRequiredObjectToString = 1;
		var TO_STRING_TAG_SUPPORT = /*@__PURE__*/ requireToStringTagSupport();
		var classof = /*@__PURE__*/ requireClassof();

		// `Object.prototype.toString` method implementation
		// https://tc39.es/ecma262/#sec-object.prototype.tostring
		objectToString$1 = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
		  return '[object ' + classof(this) + ']';
		};
		return objectToString$1;
	}

	var setToStringTag;
	var hasRequiredSetToStringTag;

	function requireSetToStringTag () {
		if (hasRequiredSetToStringTag) return setToStringTag;
		hasRequiredSetToStringTag = 1;
		var TO_STRING_TAG_SUPPORT = /*@__PURE__*/ requireToStringTagSupport();
		var defineProperty = /*@__PURE__*/ requireObjectDefineProperty().f;
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var toString = /*@__PURE__*/ requireObjectToString();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var TO_STRING_TAG = wellKnownSymbol('toStringTag');

		setToStringTag = function (it, TAG, STATIC, SET_METHOD) {
		  var target = STATIC ? it : it && it.prototype;
		  if (target) {
		    if (!hasOwn(target, TO_STRING_TAG)) {
		      defineProperty(target, TO_STRING_TAG, { configurable: true, value: TAG });
		    }
		    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
		      createNonEnumerableProperty(target, 'toString', toString);
		    }
		  }
		};
		return setToStringTag;
	}

	var iteratorCreateConstructor;
	var hasRequiredIteratorCreateConstructor;

	function requireIteratorCreateConstructor () {
		if (hasRequiredIteratorCreateConstructor) return iteratorCreateConstructor;
		hasRequiredIteratorCreateConstructor = 1;
		var IteratorPrototype = /*@__PURE__*/ requireIteratorsCore().IteratorPrototype;
		var create = /*@__PURE__*/ requireObjectCreate();
		var createPropertyDescriptor = /*@__PURE__*/ requireCreatePropertyDescriptor();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();
		var Iterators = /*@__PURE__*/ requireIterators();

		var returnThis = function () { return this; };

		iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
		  var TO_STRING_TAG = NAME + ' Iterator';
		  IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next) });
		  setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
		  Iterators[TO_STRING_TAG] = returnThis;
		  return IteratorConstructor;
		};
		return iteratorCreateConstructor;
	}

	var functionUncurryThisAccessor;
	var hasRequiredFunctionUncurryThisAccessor;

	function requireFunctionUncurryThisAccessor () {
		if (hasRequiredFunctionUncurryThisAccessor) return functionUncurryThisAccessor;
		hasRequiredFunctionUncurryThisAccessor = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var aCallable = /*@__PURE__*/ requireACallable();

		functionUncurryThisAccessor = function (object, key, method) {
		  try {
		    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
		    return uncurryThis(aCallable(Object.getOwnPropertyDescriptor(object, key)[method]));
		  } catch (error) { /* empty */ }
		};
		return functionUncurryThisAccessor;
	}

	var isPossiblePrototype;
	var hasRequiredIsPossiblePrototype;

	function requireIsPossiblePrototype () {
		if (hasRequiredIsPossiblePrototype) return isPossiblePrototype;
		hasRequiredIsPossiblePrototype = 1;
		var isObject = /*@__PURE__*/ requireIsObject$1();

		isPossiblePrototype = function (argument) {
		  return isObject(argument) || argument === null;
		};
		return isPossiblePrototype;
	}

	var aPossiblePrototype;
	var hasRequiredAPossiblePrototype;

	function requireAPossiblePrototype () {
		if (hasRequiredAPossiblePrototype) return aPossiblePrototype;
		hasRequiredAPossiblePrototype = 1;
		var isPossiblePrototype = /*@__PURE__*/ requireIsPossiblePrototype();

		var $String = String;
		var $TypeError = TypeError;

		aPossiblePrototype = function (argument) {
		  if (isPossiblePrototype(argument)) return argument;
		  throw new $TypeError("Can't set " + $String(argument) + ' as a prototype');
		};
		return aPossiblePrototype;
	}

	var objectSetPrototypeOf;
	var hasRequiredObjectSetPrototypeOf;

	function requireObjectSetPrototypeOf () {
		if (hasRequiredObjectSetPrototypeOf) return objectSetPrototypeOf;
		hasRequiredObjectSetPrototypeOf = 1;
		/* eslint-disable no-proto -- safe */
		var uncurryThisAccessor = /*@__PURE__*/ requireFunctionUncurryThisAccessor();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();
		var aPossiblePrototype = /*@__PURE__*/ requireAPossiblePrototype();

		// `Object.setPrototypeOf` method
		// https://tc39.es/ecma262/#sec-object.setprototypeof
		// Works with __proto__ only. Old v8 can't work with null proto objects.
		// eslint-disable-next-line es/no-object-setprototypeof -- safe
		objectSetPrototypeOf = Object.setPrototypeOf || ('__proto__' in {} ? function () {
		  var CORRECT_SETTER = false;
		  var test = {};
		  var setter;
		  try {
		    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
		    setter(test, []);
		    CORRECT_SETTER = test instanceof Array;
		  } catch (error) { /* empty */ }
		  return function setPrototypeOf(O, proto) {
		    requireObjectCoercible(O);
		    aPossiblePrototype(proto);
		    if (!isObject(O)) return O;
		    if (CORRECT_SETTER) setter(O, proto);
		    else O.__proto__ = proto;
		    return O;
		  };
		}() : undefined);
		return objectSetPrototypeOf;
	}

	var iteratorDefine;
	var hasRequiredIteratorDefine;

	function requireIteratorDefine () {
		if (hasRequiredIteratorDefine) return iteratorDefine;
		hasRequiredIteratorDefine = 1;
		var $ = /*@__PURE__*/ require_export();
		var call = /*@__PURE__*/ requireFunctionCall();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var FunctionName = /*@__PURE__*/ requireFunctionName();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var createIteratorConstructor = /*@__PURE__*/ requireIteratorCreateConstructor();
		var getPrototypeOf = /*@__PURE__*/ requireObjectGetPrototypeOf();
		var setPrototypeOf = /*@__PURE__*/ requireObjectSetPrototypeOf();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var Iterators = /*@__PURE__*/ requireIterators();
		var IteratorsCore = /*@__PURE__*/ requireIteratorsCore();

		var PROPER_FUNCTION_NAME = FunctionName.PROPER;
		var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
		var IteratorPrototype = IteratorsCore.IteratorPrototype;
		var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
		var ITERATOR = wellKnownSymbol('iterator');
		var KEYS = 'keys';
		var VALUES = 'values';
		var ENTRIES = 'entries';

		var returnThis = function () { return this; };

		iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
		  createIteratorConstructor(IteratorConstructor, NAME, next);

		  var getIterationMethod = function (KIND) {
		    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
		    if (!BUGGY_SAFARI_ITERATORS && KIND && KIND in IterablePrototype) return IterablePrototype[KIND];

		    switch (KIND) {
		      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
		      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
		      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
		    }

		    return function () { return new IteratorConstructor(this); };
		  };

		  var TO_STRING_TAG = NAME + ' Iterator';
		  var INCORRECT_VALUES_NAME = false;
		  var IterablePrototype = Iterable.prototype;
		  var nativeIterator = IterablePrototype[ITERATOR]
		    || IterablePrototype['@@iterator']
		    || DEFAULT && IterablePrototype[DEFAULT];
		  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
		  var anyNativeIterator = NAME === 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
		  var CurrentIteratorPrototype, methods, KEY;

		  // fix native
		  if (anyNativeIterator) {
		    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
		    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
		      if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
		        if (setPrototypeOf) {
		          setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
		        } else if (!isCallable(CurrentIteratorPrototype[ITERATOR])) {
		          defineBuiltIn(CurrentIteratorPrototype, ITERATOR, returnThis);
		        }
		      }
		      // Set @@toStringTag to native iterators
		      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
		      if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
		    }
		  }

		  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
		  if (PROPER_FUNCTION_NAME && DEFAULT === VALUES && nativeIterator && nativeIterator.name !== VALUES) {
		    if (!IS_PURE && CONFIGURABLE_FUNCTION_NAME) {
		      createNonEnumerableProperty(IterablePrototype, 'name', VALUES);
		    } else {
		      INCORRECT_VALUES_NAME = true;
		      defaultIterator = function values() { return call(nativeIterator, this); };
		    }
		  }

		  // export additional methods
		  if (DEFAULT) {
		    methods = {
		      values: getIterationMethod(VALUES),
		      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
		      entries: getIterationMethod(ENTRIES)
		    };
		    if (FORCED) for (KEY in methods) {
		      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
		        defineBuiltIn(IterablePrototype, KEY, methods[KEY]);
		      }
		    } else $({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
		  }

		  // define iterator
		  if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
		    defineBuiltIn(IterablePrototype, ITERATOR, defaultIterator, { name: DEFAULT });
		  }
		  Iterators[NAME] = defaultIterator;

		  return methods;
		};
		return iteratorDefine;
	}

	var createIterResultObject;
	var hasRequiredCreateIterResultObject;

	function requireCreateIterResultObject () {
		if (hasRequiredCreateIterResultObject) return createIterResultObject;
		hasRequiredCreateIterResultObject = 1;
		// `CreateIterResultObject` abstract operation
		// https://tc39.es/ecma262/#sec-createiterresultobject
		createIterResultObject = function (value, done) {
		  return { value: value, done: done };
		};
		return createIterResultObject;
	}

	var es_array_iterator;
	var hasRequiredEs_array_iterator;

	function requireEs_array_iterator () {
		if (hasRequiredEs_array_iterator) return es_array_iterator;
		hasRequiredEs_array_iterator = 1;
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var addToUnscopables = /*@__PURE__*/ requireAddToUnscopables();
		var Iterators = /*@__PURE__*/ requireIterators();
		var InternalStateModule = /*@__PURE__*/ requireInternalState();
		var defineProperty = /*@__PURE__*/ requireObjectDefineProperty().f;
		var defineIterator = /*@__PURE__*/ requireIteratorDefine();
		var createIterResultObject = /*@__PURE__*/ requireCreateIterResultObject();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();

		var ARRAY_ITERATOR = 'Array Iterator';
		var setInternalState = InternalStateModule.set;
		var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);

		// `Array.prototype.entries` method
		// https://tc39.es/ecma262/#sec-array.prototype.entries
		// `Array.prototype.keys` method
		// https://tc39.es/ecma262/#sec-array.prototype.keys
		// `Array.prototype.values` method
		// https://tc39.es/ecma262/#sec-array.prototype.values
		// `Array.prototype[@@iterator]` method
		// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
		// `CreateArrayIterator` internal method
		// https://tc39.es/ecma262/#sec-createarrayiterator
		es_array_iterator = defineIterator(Array, 'Array', function (iterated, kind) {
		  setInternalState(this, {
		    type: ARRAY_ITERATOR,
		    target: toIndexedObject(iterated), // target
		    index: 0,                          // next index
		    kind: kind                         // kind
		  });
		// `%ArrayIteratorPrototype%.next` method
		// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
		}, function () {
		  var state = getInternalState(this);
		  var target = state.target;
		  var index = state.index++;
		  if (!target || index >= target.length) {
		    state.target = null;
		    return createIterResultObject(undefined, true);
		  }
		  switch (state.kind) {
		    case 'keys': return createIterResultObject(index, false);
		    case 'values': return createIterResultObject(target[index], false);
		  } return createIterResultObject([index, target[index]], false);
		}, 'values');

		// argumentsList[@@iterator] is %ArrayProto_values%
		// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
		// https://tc39.es/ecma262/#sec-createmappedargumentsobject
		var values = Iterators.Arguments = Iterators.Array;

		// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
		addToUnscopables('keys');
		addToUnscopables('values');
		addToUnscopables('entries');

		// V8 ~ Chrome 45- bug
		if (!IS_PURE && DESCRIPTORS && values.name !== 'values') try {
		  defineProperty(values, 'name', { value: 'values' });
		} catch (error) { /* empty */ }
		return es_array_iterator;
	}

	var es_string_fromCodePoint = {};

	var hasRequiredEs_string_fromCodePoint;

	function requireEs_string_fromCodePoint () {
		if (hasRequiredEs_string_fromCodePoint) return es_string_fromCodePoint;
		hasRequiredEs_string_fromCodePoint = 1;
		var $ = /*@__PURE__*/ require_export();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var toAbsoluteIndex = /*@__PURE__*/ requireToAbsoluteIndex();

		var $RangeError = RangeError;
		var fromCharCode = String.fromCharCode;
		// eslint-disable-next-line es/no-string-fromcodepoint -- required for testing
		var $fromCodePoint = String.fromCodePoint;
		var join = uncurryThis([].join);

		// length should be 1, old FF problem
		var INCORRECT_LENGTH = !!$fromCodePoint && $fromCodePoint.length !== 1;

		// `String.fromCodePoint` method
		// https://tc39.es/ecma262/#sec-string.fromcodepoint
		$({ target: 'String', stat: true, arity: 1, forced: INCORRECT_LENGTH }, {
		  // eslint-disable-next-line no-unused-vars -- required for `.length`
		  fromCodePoint: function fromCodePoint(x) {
		    var elements = [];
		    var length = arguments.length;
		    var i = 0;
		    var code;
		    while (length > i) {
		      code = +arguments[i++];
		      if (toAbsoluteIndex(code, 0x10FFFF) !== code) throw new $RangeError(code + ' is not a valid code point');
		      elements[i] = code < 0x10000
		        ? fromCharCode(code)
		        : fromCharCode(((code -= 0x10000) >> 10) + 0xD800, code % 0x400 + 0xDC00);
		    } return join(elements, '');
		  }
		});
		return es_string_fromCodePoint;
	}

	var safeGetBuiltIn;
	var hasRequiredSafeGetBuiltIn;

	function requireSafeGetBuiltIn () {
		if (hasRequiredSafeGetBuiltIn) return safeGetBuiltIn;
		hasRequiredSafeGetBuiltIn = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();

		// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
		var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

		// Avoid NodeJS experimental warning
		safeGetBuiltIn = function (name) {
		  if (!DESCRIPTORS) return globalThis[name];
		  var descriptor = getOwnPropertyDescriptor(globalThis, name);
		  return descriptor && descriptor.value;
		};
		return safeGetBuiltIn;
	}

	var urlConstructorDetection;
	var hasRequiredUrlConstructorDetection;

	function requireUrlConstructorDetection () {
		if (hasRequiredUrlConstructorDetection) return urlConstructorDetection;
		hasRequiredUrlConstructorDetection = 1;
		var fails = /*@__PURE__*/ requireFails();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var IS_PURE = /*@__PURE__*/ requireIsPure();

		var ITERATOR = wellKnownSymbol('iterator');

		urlConstructorDetection = !fails(function () {
		  // eslint-disable-next-line unicorn/relative-url-style -- required for testing
		  var url = new URL('b?a=1&b=2&c=3', 'https://a');
		  var params = url.searchParams;
		  var params2 = new URLSearchParams('a=1&a=2&b=3');
		  var result = '';
		  url.pathname = 'c%20d';
		  params.forEach(function (value, key) {
		    params['delete']('b');
		    result += key + value;
		  });
		  params2['delete']('a', 2);
		  // `undefined` case is a Chromium 117 bug
		  // https://bugs.chromium.org/p/v8/issues/detail?id=14222
		  params2['delete']('b', undefined);
		  return (IS_PURE && (!url.toJSON || !params2.has('a', 1) || params2.has('a', 2) || !params2.has('a', undefined) || params2.has('b')))
		    || (!params.size && (IS_PURE || !DESCRIPTORS))
		    || !params.sort
		    || url.href !== 'https://a/c%20d?a=1&c=3'
		    || params.get('c') !== '3'
		    || String(new URLSearchParams('?a=1')) !== 'a=1'
		    || !params[ITERATOR]
		    // throws in Edge
		    || new URL('https://a@b').username !== 'a'
		    || new URLSearchParams(new URLSearchParams('a=b')).get('a') !== 'b'
		    // not punycoded in Edge
		    || new URL('https://тест').host !== 'xn--e1aybc'
		    // not escaped in Chrome 62-
		    || new URL('https://a#б').hash !== '#%D0%B1'
		    // fails in Chrome 66-
		    || result !== 'a1c3'
		    // throws in Safari
		    || new URL('https://x', undefined).host !== 'x';
		});
		return urlConstructorDetection;
	}

	var defineBuiltInAccessor;
	var hasRequiredDefineBuiltInAccessor;

	function requireDefineBuiltInAccessor () {
		if (hasRequiredDefineBuiltInAccessor) return defineBuiltInAccessor;
		hasRequiredDefineBuiltInAccessor = 1;
		var defineProperty = /*@__PURE__*/ requireObjectDefineProperty();

		defineBuiltInAccessor = function (target, name, descriptor) {
		  return defineProperty.f(target, name, descriptor);
		};
		return defineBuiltInAccessor;
	}

	var defineBuiltIns;
	var hasRequiredDefineBuiltIns;

	function requireDefineBuiltIns () {
		if (hasRequiredDefineBuiltIns) return defineBuiltIns;
		hasRequiredDefineBuiltIns = 1;
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();

		defineBuiltIns = function (target, src, options) {
		  for (var key in src) {
		    if (options && options.unsafe && target[key]) target[key] = src[key];
		    else defineBuiltIn(target, key, src[key], options);
		  } return target;
		};
		return defineBuiltIns;
	}

	var anInstance;
	var hasRequiredAnInstance;

	function requireAnInstance () {
		if (hasRequiredAnInstance) return anInstance;
		hasRequiredAnInstance = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();

		var $TypeError = TypeError;

		anInstance = function (it, Prototype) {
		  if (isPrototypeOf(Prototype, it)) return it;
		  throw new $TypeError('Incorrect invocation');
		};
		return anInstance;
	}

	var toString;
	var hasRequiredToString;

	function requireToString () {
		if (hasRequiredToString) return toString;
		hasRequiredToString = 1;
		var classof = /*@__PURE__*/ requireClassof();

		var $String = String;

		toString = function (argument) {
		  if (classof(argument) === 'Symbol') throw new TypeError('Cannot convert a Symbol value to a string');
		  return $String(argument);
		};
		return toString;
	}

	var getIteratorMethod$5;
	var hasRequiredGetIteratorMethod$6;

	function requireGetIteratorMethod$6 () {
		if (hasRequiredGetIteratorMethod$6) return getIteratorMethod$5;
		hasRequiredGetIteratorMethod$6 = 1;
		var classof = /*@__PURE__*/ requireClassof();
		var getMethod = /*@__PURE__*/ requireGetMethod();
		var isNullOrUndefined = /*@__PURE__*/ requireIsNullOrUndefined();
		var Iterators = /*@__PURE__*/ requireIterators();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var ITERATOR = wellKnownSymbol('iterator');

		getIteratorMethod$5 = function (it) {
		  if (!isNullOrUndefined(it)) return getMethod(it, ITERATOR)
		    || getMethod(it, '@@iterator')
		    || Iterators[classof(it)];
		};
		return getIteratorMethod$5;
	}

	var getIterator$5;
	var hasRequiredGetIterator$6;

	function requireGetIterator$6 () {
		if (hasRequiredGetIterator$6) return getIterator$5;
		hasRequiredGetIterator$6 = 1;
		var call = /*@__PURE__*/ requireFunctionCall();
		var aCallable = /*@__PURE__*/ requireACallable();
		var anObject = /*@__PURE__*/ requireAnObject();
		var tryToString = /*@__PURE__*/ requireTryToString();
		var getIteratorMethod = /*@__PURE__*/ requireGetIteratorMethod$6();

		var $TypeError = TypeError;

		getIterator$5 = function (argument, usingIterator) {
		  var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
		  if (aCallable(iteratorMethod)) return anObject(call(iteratorMethod, argument));
		  throw new $TypeError(tryToString(argument) + ' is not iterable');
		};
		return getIterator$5;
	}

	var validateArgumentsLength;
	var hasRequiredValidateArgumentsLength;

	function requireValidateArgumentsLength () {
		if (hasRequiredValidateArgumentsLength) return validateArgumentsLength;
		hasRequiredValidateArgumentsLength = 1;
		var $TypeError = TypeError;

		validateArgumentsLength = function (passed, required) {
		  if (passed < required) throw new $TypeError('Not enough arguments');
		  return passed;
		};
		return validateArgumentsLength;
	}

	var arraySort;
	var hasRequiredArraySort;

	function requireArraySort () {
		if (hasRequiredArraySort) return arraySort;
		hasRequiredArraySort = 1;
		var arraySlice = /*@__PURE__*/ requireArraySlice();

		var floor = Math.floor;

		var sort = function (array, comparefn) {
		  var length = array.length;

		  if (length < 8) {
		    // insertion sort
		    var i = 1;
		    var element, j;

		    while (i < length) {
		      j = i;
		      element = array[i];
		      while (j && comparefn(array[j - 1], element) > 0) {
		        array[j] = array[--j];
		      }
		      if (j !== i++) array[j] = element;
		    }
		  } else {
		    // merge sort
		    var middle = floor(length / 2);
		    var left = sort(arraySlice(array, 0, middle), comparefn);
		    var right = sort(arraySlice(array, middle), comparefn);
		    var llength = left.length;
		    var rlength = right.length;
		    var lindex = 0;
		    var rindex = 0;

		    while (lindex < llength || rindex < rlength) {
		      array[lindex + rindex] = (lindex < llength && rindex < rlength)
		        ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]
		        : lindex < llength ? left[lindex++] : right[rindex++];
		    }
		  }

		  return array;
		};

		arraySort = sort;
		return arraySort;
	}

	var web_urlSearchParams_constructor;
	var hasRequiredWeb_urlSearchParams_constructor;

	function requireWeb_urlSearchParams_constructor () {
		if (hasRequiredWeb_urlSearchParams_constructor) return web_urlSearchParams_constructor;
		hasRequiredWeb_urlSearchParams_constructor = 1;
		// TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`
		requireEs_array_iterator();
		requireEs_string_fromCodePoint();
		var $ = /*@__PURE__*/ require_export();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var safeGetBuiltIn = /*@__PURE__*/ requireSafeGetBuiltIn();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var call = /*@__PURE__*/ requireFunctionCall();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var USE_NATIVE_URL = /*@__PURE__*/ requireUrlConstructorDetection();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();
		var defineBuiltInAccessor = /*@__PURE__*/ requireDefineBuiltInAccessor();
		var defineBuiltIns = /*@__PURE__*/ requireDefineBuiltIns();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();
		var createIteratorConstructor = /*@__PURE__*/ requireIteratorCreateConstructor();
		var InternalStateModule = /*@__PURE__*/ requireInternalState();
		var anInstance = /*@__PURE__*/ requireAnInstance();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var classof = /*@__PURE__*/ requireClassof();
		var anObject = /*@__PURE__*/ requireAnObject();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var $toString = /*@__PURE__*/ requireToString();
		var create = /*@__PURE__*/ requireObjectCreate();
		var createPropertyDescriptor = /*@__PURE__*/ requireCreatePropertyDescriptor();
		var getIterator = /*@__PURE__*/ requireGetIterator$6();
		var getIteratorMethod = /*@__PURE__*/ requireGetIteratorMethod$6();
		var createIterResultObject = /*@__PURE__*/ requireCreateIterResultObject();
		var validateArgumentsLength = /*@__PURE__*/ requireValidateArgumentsLength();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var arraySort = /*@__PURE__*/ requireArraySort();

		var ITERATOR = wellKnownSymbol('iterator');
		var URL_SEARCH_PARAMS = 'URLSearchParams';
		var URL_SEARCH_PARAMS_ITERATOR = URL_SEARCH_PARAMS + 'Iterator';
		var setInternalState = InternalStateModule.set;
		var getInternalParamsState = InternalStateModule.getterFor(URL_SEARCH_PARAMS);
		var getInternalIteratorState = InternalStateModule.getterFor(URL_SEARCH_PARAMS_ITERATOR);

		var nativeFetch = safeGetBuiltIn('fetch');
		var NativeRequest = safeGetBuiltIn('Request');
		var Headers = safeGetBuiltIn('Headers');
		var RequestPrototype = NativeRequest && NativeRequest.prototype;
		var HeadersPrototype = Headers && Headers.prototype;
		var TypeError = globalThis.TypeError;
		var encodeURIComponent = globalThis.encodeURIComponent;
		var fromCharCode = String.fromCharCode;
		var fromCodePoint = getBuiltIn('String', 'fromCodePoint');
		var $parseInt = parseInt;
		var charAt = uncurryThis(''.charAt);
		var join = uncurryThis([].join);
		var push = uncurryThis([].push);
		var replace = uncurryThis(''.replace);
		var shift = uncurryThis([].shift);
		var splice = uncurryThis([].splice);
		var split = uncurryThis(''.split);
		var stringSlice = uncurryThis(''.slice);
		var exec = uncurryThis(/./.exec);

		var plus = /\+/g;
		var FALLBACK_REPLACER = '\uFFFD';
		var VALID_HEX = /^[0-9a-f]+$/i;

		var parseHexOctet = function (string, start) {
		  var substr = stringSlice(string, start, start + 2);
		  if (!exec(VALID_HEX, substr)) return NaN;

		  return $parseInt(substr, 16);
		};

		var getLeadingOnes = function (octet) {
		  var count = 0;
		  for (var mask = 0x80; mask > 0 && (octet & mask) !== 0; mask >>= 1) {
		    count++;
		  }
		  return count;
		};

		var utf8Decode = function (octets) {
		  var codePoint = null;

		  switch (octets.length) {
		    case 1:
		      codePoint = octets[0];
		      break;
		    case 2:
		      codePoint = (octets[0] & 0x1F) << 6 | (octets[1] & 0x3F);
		      break;
		    case 3:
		      codePoint = (octets[0] & 0x0F) << 12 | (octets[1] & 0x3F) << 6 | (octets[2] & 0x3F);
		      break;
		    case 4:
		      codePoint = (octets[0] & 0x07) << 18 | (octets[1] & 0x3F) << 12 | (octets[2] & 0x3F) << 6 | (octets[3] & 0x3F);
		      break;
		  }

		  return codePoint > 0x10FFFF ? null : codePoint;
		};

		var decode = function (input) {
		  input = replace(input, plus, ' ');
		  var length = input.length;
		  var result = '';
		  var i = 0;

		  while (i < length) {
		    var decodedChar = charAt(input, i);

		    if (decodedChar === '%') {
		      if (charAt(input, i + 1) === '%' || i + 3 > length) {
		        result += '%';
		        i++;
		        continue;
		      }

		      var octet = parseHexOctet(input, i + 1);

		      // eslint-disable-next-line no-self-compare -- NaN check
		      if (octet !== octet) {
		        result += decodedChar;
		        i++;
		        continue;
		      }

		      i += 2;
		      var byteSequenceLength = getLeadingOnes(octet);

		      if (byteSequenceLength === 0) {
		        decodedChar = fromCharCode(octet);
		      } else {
		        if (byteSequenceLength === 1 || byteSequenceLength > 4) {
		          result += FALLBACK_REPLACER;
		          i++;
		          continue;
		        }

		        var octets = [octet];
		        var sequenceIndex = 1;

		        while (sequenceIndex < byteSequenceLength) {
		          i++;
		          if (i + 3 > length || charAt(input, i) !== '%') break;

		          var nextByte = parseHexOctet(input, i + 1);

		          // eslint-disable-next-line no-self-compare -- NaN check
		          if (nextByte !== nextByte) {
		            i += 3;
		            break;
		          }
		          if (nextByte > 191 || nextByte < 128) break;

		          push(octets, nextByte);
		          i += 2;
		          sequenceIndex++;
		        }

		        if (octets.length !== byteSequenceLength) {
		          result += FALLBACK_REPLACER;
		          continue;
		        }

		        var codePoint = utf8Decode(octets);
		        if (codePoint === null) {
		          result += FALLBACK_REPLACER;
		        } else {
		          decodedChar = fromCodePoint(codePoint);
		        }
		      }
		    }

		    result += decodedChar;
		    i++;
		  }

		  return result;
		};

		var find = /[!'()~]|%20/g;

		var replacements = {
		  '!': '%21',
		  "'": '%27',
		  '(': '%28',
		  ')': '%29',
		  '~': '%7E',
		  '%20': '+'
		};

		var replacer = function (match) {
		  return replacements[match];
		};

		var serialize = function (it) {
		  return replace(encodeURIComponent(it), find, replacer);
		};

		var URLSearchParamsIterator = createIteratorConstructor(function Iterator(params, kind) {
		  setInternalState(this, {
		    type: URL_SEARCH_PARAMS_ITERATOR,
		    target: getInternalParamsState(params).entries,
		    index: 0,
		    kind: kind
		  });
		}, URL_SEARCH_PARAMS, function next() {
		  var state = getInternalIteratorState(this);
		  var target = state.target;
		  var index = state.index++;
		  if (!target || index >= target.length) {
		    state.target = null;
		    return createIterResultObject(undefined, true);
		  }
		  var entry = target[index];
		  switch (state.kind) {
		    case 'keys': return createIterResultObject(entry.key, false);
		    case 'values': return createIterResultObject(entry.value, false);
		  } return createIterResultObject([entry.key, entry.value], false);
		}, true);

		var URLSearchParamsState = function (init) {
		  this.entries = [];
		  this.url = null;

		  if (init !== undefined) {
		    if (isObject(init)) this.parseObject(init);
		    else this.parseQuery(typeof init == 'string' ? charAt(init, 0) === '?' ? stringSlice(init, 1) : init : $toString(init));
		  }
		};

		URLSearchParamsState.prototype = {
		  type: URL_SEARCH_PARAMS,
		  bindURL: function (url) {
		    this.url = url;
		    this.update();
		  },
		  parseObject: function (object) {
		    var entries = this.entries;
		    var iteratorMethod = getIteratorMethod(object);
		    var iterator, next, step, entryIterator, entryNext, first, second;

		    if (iteratorMethod) {
		      iterator = getIterator(object, iteratorMethod);
		      next = iterator.next;
		      while (!(step = call(next, iterator)).done) {
		        entryIterator = getIterator(anObject(step.value));
		        entryNext = entryIterator.next;
		        if (
		          (first = call(entryNext, entryIterator)).done ||
		          (second = call(entryNext, entryIterator)).done ||
		          !call(entryNext, entryIterator).done
		        ) throw new TypeError('Expected sequence with length 2');
		        push(entries, { key: $toString(first.value), value: $toString(second.value) });
		      }
		    } else for (var key in object) if (hasOwn(object, key)) {
		      push(entries, { key: key, value: $toString(object[key]) });
		    }
		  },
		  parseQuery: function (query) {
		    if (query) {
		      var entries = this.entries;
		      var attributes = split(query, '&');
		      var index = 0;
		      var attribute, entry;
		      while (index < attributes.length) {
		        attribute = attributes[index++];
		        if (attribute.length) {
		          entry = split(attribute, '=');
		          push(entries, {
		            key: decode(shift(entry)),
		            value: decode(join(entry, '='))
		          });
		        }
		      }
		    }
		  },
		  serialize: function () {
		    var entries = this.entries;
		    var result = [];
		    var index = 0;
		    var entry;
		    while (index < entries.length) {
		      entry = entries[index++];
		      push(result, serialize(entry.key) + '=' + serialize(entry.value));
		    } return join(result, '&');
		  },
		  update: function () {
		    this.entries.length = 0;
		    this.parseQuery(this.url.query);
		  },
		  updateURL: function () {
		    if (this.url) this.url.update();
		  }
		};

		// `URLSearchParams` constructor
		// https://url.spec.whatwg.org/#interface-urlsearchparams
		var URLSearchParamsConstructor = function URLSearchParams(/* init */) {
		  anInstance(this, URLSearchParamsPrototype);
		  var init = arguments.length > 0 ? arguments[0] : undefined;
		  var state = setInternalState(this, new URLSearchParamsState(init));
		  if (!DESCRIPTORS) this.size = state.entries.length;
		};

		var URLSearchParamsPrototype = URLSearchParamsConstructor.prototype;

		defineBuiltIns(URLSearchParamsPrototype, {
		  // `URLSearchParams.prototype.append` method
		  // https://url.spec.whatwg.org/#dom-urlsearchparams-append
		  append: function append(name, value) {
		    var state = getInternalParamsState(this);
		    validateArgumentsLength(arguments.length, 2);
		    push(state.entries, { key: $toString(name), value: $toString(value) });
		    if (!DESCRIPTORS) this.length++;
		    state.updateURL();
		  },
		  // `URLSearchParams.prototype.delete` method
		  // https://url.spec.whatwg.org/#dom-urlsearchparams-delete
		  'delete': function (name /* , value */) {
		    var state = getInternalParamsState(this);
		    var length = validateArgumentsLength(arguments.length, 1);
		    var entries = state.entries;
		    var key = $toString(name);
		    var $value = length < 2 ? undefined : arguments[1];
		    var value = $value === undefined ? $value : $toString($value);
		    var index = 0;
		    while (index < entries.length) {
		      var entry = entries[index];
		      if (entry.key === key && (value === undefined || entry.value === value)) {
		        splice(entries, index, 1);
		        if (value !== undefined) break;
		      } else index++;
		    }
		    if (!DESCRIPTORS) this.size = entries.length;
		    state.updateURL();
		  },
		  // `URLSearchParams.prototype.get` method
		  // https://url.spec.whatwg.org/#dom-urlsearchparams-get
		  get: function get(name) {
		    var entries = getInternalParamsState(this).entries;
		    validateArgumentsLength(arguments.length, 1);
		    var key = $toString(name);
		    var index = 0;
		    for (; index < entries.length; index++) {
		      if (entries[index].key === key) return entries[index].value;
		    }
		    return null;
		  },
		  // `URLSearchParams.prototype.getAll` method
		  // https://url.spec.whatwg.org/#dom-urlsearchparams-getall
		  getAll: function getAll(name) {
		    var entries = getInternalParamsState(this).entries;
		    validateArgumentsLength(arguments.length, 1);
		    var key = $toString(name);
		    var result = [];
		    var index = 0;
		    for (; index < entries.length; index++) {
		      if (entries[index].key === key) push(result, entries[index].value);
		    }
		    return result;
		  },
		  // `URLSearchParams.prototype.has` method
		  // https://url.spec.whatwg.org/#dom-urlsearchparams-has
		  has: function has(name /* , value */) {
		    var entries = getInternalParamsState(this).entries;
		    var length = validateArgumentsLength(arguments.length, 1);
		    var key = $toString(name);
		    var $value = length < 2 ? undefined : arguments[1];
		    var value = $value === undefined ? $value : $toString($value);
		    var index = 0;
		    while (index < entries.length) {
		      var entry = entries[index++];
		      if (entry.key === key && (value === undefined || entry.value === value)) return true;
		    }
		    return false;
		  },
		  // `URLSearchParams.prototype.set` method
		  // https://url.spec.whatwg.org/#dom-urlsearchparams-set
		  set: function set(name, value) {
		    var state = getInternalParamsState(this);
		    validateArgumentsLength(arguments.length, 1);
		    var entries = state.entries;
		    var found = false;
		    var key = $toString(name);
		    var val = $toString(value);
		    var index = 0;
		    var entry;
		    for (; index < entries.length; index++) {
		      entry = entries[index];
		      if (entry.key === key) {
		        if (found) splice(entries, index--, 1);
		        else {
		          found = true;
		          entry.value = val;
		        }
		      }
		    }
		    if (!found) push(entries, { key: key, value: val });
		    if (!DESCRIPTORS) this.size = entries.length;
		    state.updateURL();
		  },
		  // `URLSearchParams.prototype.sort` method
		  // https://url.spec.whatwg.org/#dom-urlsearchparams-sort
		  sort: function sort() {
		    var state = getInternalParamsState(this);
		    arraySort(state.entries, function (a, b) {
		      return a.key > b.key ? 1 : -1;
		    });
		    state.updateURL();
		  },
		  // `URLSearchParams.prototype.forEach` method
		  forEach: function forEach(callback /* , thisArg */) {
		    var entries = getInternalParamsState(this).entries;
		    var boundFunction = bind(callback, arguments.length > 1 ? arguments[1] : undefined);
		    var index = 0;
		    var entry;
		    while (index < entries.length) {
		      entry = entries[index++];
		      boundFunction(entry.value, entry.key, this);
		    }
		  },
		  // `URLSearchParams.prototype.keys` method
		  keys: function keys() {
		    return new URLSearchParamsIterator(this, 'keys');
		  },
		  // `URLSearchParams.prototype.values` method
		  values: function values() {
		    return new URLSearchParamsIterator(this, 'values');
		  },
		  // `URLSearchParams.prototype.entries` method
		  entries: function entries() {
		    return new URLSearchParamsIterator(this, 'entries');
		  }
		}, { enumerable: true });

		// `URLSearchParams.prototype[@@iterator]` method
		defineBuiltIn(URLSearchParamsPrototype, ITERATOR, URLSearchParamsPrototype.entries, { name: 'entries' });

		// `URLSearchParams.prototype.toString` method
		// https://url.spec.whatwg.org/#urlsearchparams-stringification-behavior
		defineBuiltIn(URLSearchParamsPrototype, 'toString', function toString() {
		  return getInternalParamsState(this).serialize();
		}, { enumerable: true });

		// `URLSearchParams.prototype.size` getter
		// https://github.com/whatwg/url/pull/734
		if (DESCRIPTORS) defineBuiltInAccessor(URLSearchParamsPrototype, 'size', {
		  get: function size() {
		    return getInternalParamsState(this).entries.length;
		  },
		  configurable: true,
		  enumerable: true
		});

		setToStringTag(URLSearchParamsConstructor, URL_SEARCH_PARAMS);

		$({ global: true, constructor: true, forced: !USE_NATIVE_URL }, {
		  URLSearchParams: URLSearchParamsConstructor
		});

		// Wrap `fetch` and `Request` for correct work with polyfilled `URLSearchParams`
		if (!USE_NATIVE_URL && isCallable(Headers)) {
		  var headersHas = uncurryThis(HeadersPrototype.has);
		  var headersSet = uncurryThis(HeadersPrototype.set);

		  var wrapRequestOptions = function (init) {
		    if (isObject(init)) {
		      var body = init.body;
		      var headers;
		      if (classof(body) === URL_SEARCH_PARAMS) {
		        headers = init.headers ? new Headers(init.headers) : new Headers();
		        if (!headersHas(headers, 'content-type')) {
		          headersSet(headers, 'content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
		        }
		        return create(init, {
		          body: createPropertyDescriptor(0, $toString(body)),
		          headers: createPropertyDescriptor(0, headers)
		        });
		      }
		    } return init;
		  };

		  if (isCallable(nativeFetch)) {
		    $({ global: true, enumerable: true, dontCallGetSet: true, forced: true }, {
		      fetch: function fetch(input /* , init */) {
		        return nativeFetch(input, arguments.length > 1 ? wrapRequestOptions(arguments[1]) : {});
		      }
		    });
		  }

		  if (isCallable(NativeRequest)) {
		    var RequestConstructor = function Request(input /* , init */) {
		      anInstance(this, RequestPrototype);
		      return new NativeRequest(input, arguments.length > 1 ? wrapRequestOptions(arguments[1]) : {});
		    };

		    RequestPrototype.constructor = RequestConstructor;
		    RequestConstructor.prototype = RequestPrototype;

		    $({ global: true, constructor: true, dontCallGetSet: true, forced: true }, {
		      Request: RequestConstructor
		    });
		  }
		}

		web_urlSearchParams_constructor = {
		  URLSearchParams: URLSearchParamsConstructor,
		  getState: getInternalParamsState
		};
		return web_urlSearchParams_constructor;
	}

	var hasRequiredWeb_urlSearchParams;

	function requireWeb_urlSearchParams () {
		if (hasRequiredWeb_urlSearchParams) return web_urlSearchParams;
		hasRequiredWeb_urlSearchParams = 1;
		// TODO: Remove this module from `core-js@4` since it's replaced to module below
		requireWeb_urlSearchParams_constructor();
		return web_urlSearchParams;
	}

	var urlSearchParams$2;
	var hasRequiredUrlSearchParams$2;

	function requireUrlSearchParams$2 () {
		if (hasRequiredUrlSearchParams$2) return urlSearchParams$2;
		hasRequiredUrlSearchParams$2 = 1;
		requireWeb_urlSearchParams();
		var path = /*@__PURE__*/ requirePath$1();

		urlSearchParams$2 = path.URLSearchParams;
		return urlSearchParams$2;
	}

	var web_url = {};

	var web_url_constructor = {};

	var es_string_iterator = {};

	var stringMultibyte;
	var hasRequiredStringMultibyte;

	function requireStringMultibyte () {
		if (hasRequiredStringMultibyte) return stringMultibyte;
		hasRequiredStringMultibyte = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var toIntegerOrInfinity = /*@__PURE__*/ requireToIntegerOrInfinity();
		var toString = /*@__PURE__*/ requireToString();
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();

		var charAt = uncurryThis(''.charAt);
		var charCodeAt = uncurryThis(''.charCodeAt);
		var stringSlice = uncurryThis(''.slice);

		var createMethod = function (CONVERT_TO_STRING) {
		  return function ($this, pos) {
		    var S = toString(requireObjectCoercible($this));
		    var position = toIntegerOrInfinity(pos);
		    var size = S.length;
		    var first, second;
		    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
		    first = charCodeAt(S, position);
		    return first < 0xD800 || first > 0xDBFF || position + 1 === size
		      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
		        ? CONVERT_TO_STRING
		          ? charAt(S, position)
		          : first
		        : CONVERT_TO_STRING
		          ? stringSlice(S, position, position + 2)
		          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
		  };
		};

		stringMultibyte = {
		  // `String.prototype.codePointAt` method
		  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
		  codeAt: createMethod(false),
		  // `String.prototype.at` method
		  // https://github.com/mathiasbynens/String.prototype.at
		  charAt: createMethod(true)
		};
		return stringMultibyte;
	}

	var hasRequiredEs_string_iterator;

	function requireEs_string_iterator () {
		if (hasRequiredEs_string_iterator) return es_string_iterator;
		hasRequiredEs_string_iterator = 1;
		var charAt = /*@__PURE__*/ requireStringMultibyte().charAt;
		var toString = /*@__PURE__*/ requireToString();
		var InternalStateModule = /*@__PURE__*/ requireInternalState();
		var defineIterator = /*@__PURE__*/ requireIteratorDefine();
		var createIterResultObject = /*@__PURE__*/ requireCreateIterResultObject();

		var STRING_ITERATOR = 'String Iterator';
		var setInternalState = InternalStateModule.set;
		var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);

		// `String.prototype[@@iterator]` method
		// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
		defineIterator(String, 'String', function (iterated) {
		  setInternalState(this, {
		    type: STRING_ITERATOR,
		    string: toString(iterated),
		    index: 0
		  });
		// `%StringIteratorPrototype%.next` method
		// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
		}, function next() {
		  var state = getInternalState(this);
		  var string = state.string;
		  var index = state.index;
		  var point;
		  if (index >= string.length) return createIterResultObject(undefined, true);
		  point = charAt(string, index);
		  state.index += point.length;
		  return createIterResultObject(point, false);
		});
		return es_string_iterator;
	}

	var objectGetOwnPropertySymbols = {};

	var hasRequiredObjectGetOwnPropertySymbols;

	function requireObjectGetOwnPropertySymbols () {
		if (hasRequiredObjectGetOwnPropertySymbols) return objectGetOwnPropertySymbols;
		hasRequiredObjectGetOwnPropertySymbols = 1;
		// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
		objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;
		return objectGetOwnPropertySymbols;
	}

	var objectAssign;
	var hasRequiredObjectAssign;

	function requireObjectAssign () {
		if (hasRequiredObjectAssign) return objectAssign;
		hasRequiredObjectAssign = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var call = /*@__PURE__*/ requireFunctionCall();
		var fails = /*@__PURE__*/ requireFails();
		var objectKeys = /*@__PURE__*/ requireObjectKeys();
		var getOwnPropertySymbolsModule = /*@__PURE__*/ requireObjectGetOwnPropertySymbols();
		var propertyIsEnumerableModule = /*@__PURE__*/ requireObjectPropertyIsEnumerable();
		var toObject = /*@__PURE__*/ requireToObject();
		var IndexedObject = /*@__PURE__*/ requireIndexedObject();

		// eslint-disable-next-line es/no-object-assign -- safe
		var $assign = Object.assign;
		// eslint-disable-next-line es/no-object-defineproperty -- required for testing
		var defineProperty = Object.defineProperty;
		var concat = uncurryThis([].concat);

		// `Object.assign` method
		// https://tc39.es/ecma262/#sec-object.assign
		objectAssign = !$assign || fails(function () {
		  // should have correct order of operations (Edge bug)
		  if (DESCRIPTORS && $assign({ b: 1 }, $assign(defineProperty({}, 'a', {
		    enumerable: true,
		    get: function () {
		      defineProperty(this, 'b', {
		        value: 3,
		        enumerable: false
		      });
		    }
		  }), { b: 2 })).b !== 1) return true;
		  // should work with symbols and should have deterministic property order (V8 bug)
		  var A = {};
		  var B = {};
		  // eslint-disable-next-line es/no-symbol -- safe
		  var symbol = Symbol('assign detection');
		  var alphabet = 'abcdefghijklmnopqrst';
		  A[symbol] = 7;
		  // eslint-disable-next-line es/no-array-prototype-foreach -- safe
		  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
		  return $assign({}, A)[symbol] !== 7 || objectKeys($assign({}, B)).join('') !== alphabet;
		}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
		  var T = toObject(target);
		  var argumentsLength = arguments.length;
		  var index = 1;
		  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
		  var propertyIsEnumerable = propertyIsEnumerableModule.f;
		  while (argumentsLength > index) {
		    var S = IndexedObject(arguments[index++]);
		    var keys = getOwnPropertySymbols ? concat(objectKeys(S), getOwnPropertySymbols(S)) : objectKeys(S);
		    var length = keys.length;
		    var j = 0;
		    var key;
		    while (length > j) {
		      key = keys[j++];
		      if (!DESCRIPTORS || call(propertyIsEnumerable, S, key)) T[key] = S[key];
		    }
		  } return T;
		} : $assign;
		return objectAssign;
	}

	var iteratorClose;
	var hasRequiredIteratorClose;

	function requireIteratorClose () {
		if (hasRequiredIteratorClose) return iteratorClose;
		hasRequiredIteratorClose = 1;
		var call = /*@__PURE__*/ requireFunctionCall();
		var anObject = /*@__PURE__*/ requireAnObject();
		var getMethod = /*@__PURE__*/ requireGetMethod();

		iteratorClose = function (iterator, kind, value) {
		  var innerResult, innerError;
		  anObject(iterator);
		  try {
		    innerResult = getMethod(iterator, 'return');
		    if (!innerResult) {
		      if (kind === 'throw') throw value;
		      return value;
		    }
		    innerResult = call(innerResult, iterator);
		  } catch (error) {
		    innerError = true;
		    innerResult = error;
		  }
		  if (kind === 'throw') throw value;
		  if (innerError) throw innerResult;
		  anObject(innerResult);
		  return value;
		};
		return iteratorClose;
	}

	var callWithSafeIterationClosing;
	var hasRequiredCallWithSafeIterationClosing;

	function requireCallWithSafeIterationClosing () {
		if (hasRequiredCallWithSafeIterationClosing) return callWithSafeIterationClosing;
		hasRequiredCallWithSafeIterationClosing = 1;
		var anObject = /*@__PURE__*/ requireAnObject();
		var iteratorClose = /*@__PURE__*/ requireIteratorClose();

		// call something on iterator step with safe closing on error
		callWithSafeIterationClosing = function (iterator, fn, value, ENTRIES) {
		  try {
		    return ENTRIES ? fn(anObject(value)[0], value[1]) : fn(value);
		  } catch (error) {
		    iteratorClose(iterator, 'throw', error);
		  }
		};
		return callWithSafeIterationClosing;
	}

	var isArrayIteratorMethod;
	var hasRequiredIsArrayIteratorMethod;

	function requireIsArrayIteratorMethod () {
		if (hasRequiredIsArrayIteratorMethod) return isArrayIteratorMethod;
		hasRequiredIsArrayIteratorMethod = 1;
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var Iterators = /*@__PURE__*/ requireIterators();

		var ITERATOR = wellKnownSymbol('iterator');
		var ArrayPrototype = Array.prototype;

		// check on default Array iterator
		isArrayIteratorMethod = function (it) {
		  return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
		};
		return isArrayIteratorMethod;
	}

	var arrayFrom;
	var hasRequiredArrayFrom;

	function requireArrayFrom () {
		if (hasRequiredArrayFrom) return arrayFrom;
		hasRequiredArrayFrom = 1;
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var call = /*@__PURE__*/ requireFunctionCall();
		var toObject = /*@__PURE__*/ requireToObject();
		var callWithSafeIterationClosing = /*@__PURE__*/ requireCallWithSafeIterationClosing();
		var isArrayIteratorMethod = /*@__PURE__*/ requireIsArrayIteratorMethod();
		var isConstructor = /*@__PURE__*/ requireIsConstructor();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var createProperty = /*@__PURE__*/ requireCreateProperty();
		var getIterator = /*@__PURE__*/ requireGetIterator$6();
		var getIteratorMethod = /*@__PURE__*/ requireGetIteratorMethod$6();

		var $Array = Array;

		// `Array.from` method implementation
		// https://tc39.es/ecma262/#sec-array.from
		arrayFrom = function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
		  var O = toObject(arrayLike);
		  var IS_CONSTRUCTOR = isConstructor(this);
		  var argumentsLength = arguments.length;
		  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
		  var mapping = mapfn !== undefined;
		  if (mapping) mapfn = bind(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
		  var iteratorMethod = getIteratorMethod(O);
		  var index = 0;
		  var length, result, step, iterator, next, value;
		  // if the target is not iterable or it's an array with the default iterator - use a simple case
		  if (iteratorMethod && !(this === $Array && isArrayIteratorMethod(iteratorMethod))) {
		    result = IS_CONSTRUCTOR ? new this() : [];
		    iterator = getIterator(O, iteratorMethod);
		    next = iterator.next;
		    for (;!(step = call(next, iterator)).done; index++) {
		      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
		      createProperty(result, index, value);
		    }
		  } else {
		    length = lengthOfArrayLike(O);
		    result = IS_CONSTRUCTOR ? new this(length) : $Array(length);
		    for (;length > index; index++) {
		      value = mapping ? mapfn(O[index], index) : O[index];
		      createProperty(result, index, value);
		    }
		  }
		  result.length = index;
		  return result;
		};
		return arrayFrom;
	}

	var stringPunycodeToAscii;
	var hasRequiredStringPunycodeToAscii;

	function requireStringPunycodeToAscii () {
		if (hasRequiredStringPunycodeToAscii) return stringPunycodeToAscii;
		hasRequiredStringPunycodeToAscii = 1;
		// based on https://github.com/bestiejs/punycode.js/blob/master/punycode.js
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1
		var base = 36;
		var tMin = 1;
		var tMax = 26;
		var skew = 38;
		var damp = 700;
		var initialBias = 72;
		var initialN = 128; // 0x80
		var delimiter = '-'; // '\x2D'
		var regexNonASCII = /[^\0-\u007E]/; // non-ASCII chars
		var regexSeparators = /[.\u3002\uFF0E\uFF61]/g; // RFC 3490 separators
		var OVERFLOW_ERROR = 'Overflow: input needs wider integers to process';
		var baseMinusTMin = base - tMin;

		var $RangeError = RangeError;
		var exec = uncurryThis(regexSeparators.exec);
		var floor = Math.floor;
		var fromCharCode = String.fromCharCode;
		var charCodeAt = uncurryThis(''.charCodeAt);
		var join = uncurryThis([].join);
		var push = uncurryThis([].push);
		var replace = uncurryThis(''.replace);
		var split = uncurryThis(''.split);
		var toLowerCase = uncurryThis(''.toLowerCase);

		/**
		 * Creates an array containing the numeric code points of each Unicode
		 * character in the string. While JavaScript uses UCS-2 internally,
		 * this function will convert a pair of surrogate halves (each of which
		 * UCS-2 exposes as separate characters) into a single code point,
		 * matching UTF-16.
		 */
		var ucs2decode = function (string) {
		  var output = [];
		  var counter = 0;
		  var length = string.length;
		  while (counter < length) {
		    var value = charCodeAt(string, counter++);
		    if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
		      // It's a high surrogate, and there is a next character.
		      var extra = charCodeAt(string, counter++);
		      if ((extra & 0xFC00) === 0xDC00) { // Low surrogate.
		        push(output, ((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
		      } else {
		        // It's an unmatched surrogate; only append this code unit, in case the
		        // next code unit is the high surrogate of a surrogate pair.
		        push(output, value);
		        counter--;
		      }
		    } else {
		      push(output, value);
		    }
		  }
		  return output;
		};

		/**
		 * Converts a digit/integer into a basic code point.
		 */
		var digitToBasic = function (digit) {
		  //  0..25 map to ASCII a..z or A..Z
		  // 26..35 map to ASCII 0..9
		  return digit + 22 + 75 * (digit < 26);
		};

		/**
		 * Bias adaptation function as per section 3.4 of RFC 3492.
		 * https://tools.ietf.org/html/rfc3492#section-3.4
		 */
		var adapt = function (delta, numPoints, firstTime) {
		  var k = 0;
		  delta = firstTime ? floor(delta / damp) : delta >> 1;
		  delta += floor(delta / numPoints);
		  while (delta > baseMinusTMin * tMax >> 1) {
		    delta = floor(delta / baseMinusTMin);
		    k += base;
		  }
		  return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
		};

		/**
		 * Converts a string of Unicode symbols (e.g. a domain name label) to a
		 * Punycode string of ASCII-only symbols.
		 */
		var encode = function (input) {
		  var output = [];

		  // Convert the input in UCS-2 to an array of Unicode code points.
		  input = ucs2decode(input);

		  // Cache the length.
		  var inputLength = input.length;

		  // Initialize the state.
		  var n = initialN;
		  var delta = 0;
		  var bias = initialBias;
		  var i, currentValue;

		  // Handle the basic code points.
		  for (i = 0; i < input.length; i++) {
		    currentValue = input[i];
		    if (currentValue < 0x80) {
		      push(output, fromCharCode(currentValue));
		    }
		  }

		  var basicLength = output.length; // number of basic code points.
		  var handledCPCount = basicLength; // number of code points that have been handled;

		  // Finish the basic string with a delimiter unless it's empty.
		  if (basicLength) {
		    push(output, delimiter);
		  }

		  // Main encoding loop:
		  while (handledCPCount < inputLength) {
		    // All non-basic code points < n have been handled already. Find the next larger one:
		    var m = maxInt;
		    for (i = 0; i < input.length; i++) {
		      currentValue = input[i];
		      if (currentValue >= n && currentValue < m) {
		        m = currentValue;
		      }
		    }

		    // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>, but guard against overflow.
		    var handledCPCountPlusOne = handledCPCount + 1;
		    if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
		      throw new $RangeError(OVERFLOW_ERROR);
		    }

		    delta += (m - n) * handledCPCountPlusOne;
		    n = m;

		    for (i = 0; i < input.length; i++) {
		      currentValue = input[i];
		      if (currentValue < n && ++delta > maxInt) {
		        throw new $RangeError(OVERFLOW_ERROR);
		      }
		      if (currentValue === n) {
		        // Represent delta as a generalized variable-length integer.
		        var q = delta;
		        var k = base;
		        while (true) {
		          var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
		          if (q < t) break;
		          var qMinusT = q - t;
		          var baseMinusT = base - t;
		          push(output, fromCharCode(digitToBasic(t + qMinusT % baseMinusT)));
		          q = floor(qMinusT / baseMinusT);
		          k += base;
		        }

		        push(output, fromCharCode(digitToBasic(q)));
		        bias = adapt(delta, handledCPCountPlusOne, handledCPCount === basicLength);
		        delta = 0;
		        handledCPCount++;
		      }
		    }

		    delta++;
		    n++;
		  }
		  return join(output, '');
		};

		stringPunycodeToAscii = function (input) {
		  var encoded = [];
		  var labels = split(replace(toLowerCase(input), regexSeparators, '\u002E'), '.');
		  var i, label;
		  for (i = 0; i < labels.length; i++) {
		    label = labels[i];
		    push(encoded, exec(regexNonASCII, label) ? 'xn--' + encode(label) : label);
		  }
		  return join(encoded, '.');
		};
		return stringPunycodeToAscii;
	}

	var hasRequiredWeb_url_constructor;

	function requireWeb_url_constructor () {
		if (hasRequiredWeb_url_constructor) return web_url_constructor;
		hasRequiredWeb_url_constructor = 1;
		// TODO: in core-js@4, move /modules/ dependencies to public entries for better optimization by tools like `preset-env`
		requireEs_string_iterator();
		var $ = /*@__PURE__*/ require_export();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var USE_NATIVE_URL = /*@__PURE__*/ requireUrlConstructorDetection();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();
		var defineBuiltInAccessor = /*@__PURE__*/ requireDefineBuiltInAccessor();
		var anInstance = /*@__PURE__*/ requireAnInstance();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var assign = /*@__PURE__*/ requireObjectAssign();
		var arrayFrom = /*@__PURE__*/ requireArrayFrom();
		var arraySlice = /*@__PURE__*/ requireArraySlice();
		var codeAt = /*@__PURE__*/ requireStringMultibyte().codeAt;
		var toASCII = /*@__PURE__*/ requireStringPunycodeToAscii();
		var $toString = /*@__PURE__*/ requireToString();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();
		var validateArgumentsLength = /*@__PURE__*/ requireValidateArgumentsLength();
		var URLSearchParamsModule = requireWeb_urlSearchParams_constructor();
		var InternalStateModule = /*@__PURE__*/ requireInternalState();

		var setInternalState = InternalStateModule.set;
		var getInternalURLState = InternalStateModule.getterFor('URL');
		var URLSearchParams = URLSearchParamsModule.URLSearchParams;
		var getInternalSearchParamsState = URLSearchParamsModule.getState;

		var NativeURL = globalThis.URL;
		var TypeError = globalThis.TypeError;
		var parseInt = globalThis.parseInt;
		var floor = Math.floor;
		var pow = Math.pow;
		var charAt = uncurryThis(''.charAt);
		var exec = uncurryThis(/./.exec);
		var join = uncurryThis([].join);
		var numberToString = uncurryThis(1.0.toString);
		var pop = uncurryThis([].pop);
		var push = uncurryThis([].push);
		var replace = uncurryThis(''.replace);
		var shift = uncurryThis([].shift);
		var split = uncurryThis(''.split);
		var stringSlice = uncurryThis(''.slice);
		var toLowerCase = uncurryThis(''.toLowerCase);
		var unshift = uncurryThis([].unshift);

		var INVALID_AUTHORITY = 'Invalid authority';
		var INVALID_SCHEME = 'Invalid scheme';
		var INVALID_HOST = 'Invalid host';
		var INVALID_PORT = 'Invalid port';

		var ALPHA = /[a-z]/i;
		// eslint-disable-next-line regexp/no-obscure-range -- safe
		var ALPHANUMERIC = /[\d+-.a-z]/i;
		var DIGIT = /\d/;
		var HEX_START = /^0x/i;
		var OCT = /^[0-7]+$/;
		var DEC = /^\d+$/;
		var HEX = /^[\da-f]+$/i;
		/* eslint-disable regexp/no-control-character -- safe */
		var FORBIDDEN_HOST_CODE_POINT = /[\0\t\n\r #%/:<>?@[\\\]^|]/;
		var FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT = /[\0\t\n\r #/:<>?@[\\\]^|]/;
		var LEADING_C0_CONTROL_OR_SPACE = /^[\u0000-\u0020]+/;
		var TRAILING_C0_CONTROL_OR_SPACE = /(^|[^\u0000-\u0020])[\u0000-\u0020]+$/;
		var TAB_AND_NEW_LINE = /[\t\n\r]/g;
		/* eslint-enable regexp/no-control-character -- safe */
		var EOF;

		// https://url.spec.whatwg.org/#ipv4-number-parser
		var parseIPv4 = function (input) {
		  var parts = split(input, '.');
		  var partsLength, numbers, index, part, radix, number, ipv4;
		  if (parts.length && parts[parts.length - 1] === '') {
		    parts.length--;
		  }
		  partsLength = parts.length;
		  if (partsLength > 4) return input;
		  numbers = [];
		  for (index = 0; index < partsLength; index++) {
		    part = parts[index];
		    if (part === '') return input;
		    radix = 10;
		    if (part.length > 1 && charAt(part, 0) === '0') {
		      radix = exec(HEX_START, part) ? 16 : 8;
		      part = stringSlice(part, radix === 8 ? 1 : 2);
		    }
		    if (part === '') {
		      number = 0;
		    } else {
		      if (!exec(radix === 10 ? DEC : radix === 8 ? OCT : HEX, part)) return input;
		      number = parseInt(part, radix);
		    }
		    push(numbers, number);
		  }
		  for (index = 0; index < partsLength; index++) {
		    number = numbers[index];
		    if (index === partsLength - 1) {
		      if (number >= pow(256, 5 - partsLength)) return null;
		    } else if (number > 255) return null;
		  }
		  ipv4 = pop(numbers);
		  for (index = 0; index < numbers.length; index++) {
		    ipv4 += numbers[index] * pow(256, 3 - index);
		  }
		  return ipv4;
		};

		// https://url.spec.whatwg.org/#concept-ipv6-parser
		// eslint-disable-next-line max-statements -- TODO
		var parseIPv6 = function (input) {
		  var address = [0, 0, 0, 0, 0, 0, 0, 0];
		  var pieceIndex = 0;
		  var compress = null;
		  var pointer = 0;
		  var value, length, numbersSeen, ipv4Piece, number, swaps, swap;

		  var chr = function () {
		    return charAt(input, pointer);
		  };

		  if (chr() === ':') {
		    if (charAt(input, 1) !== ':') return;
		    pointer += 2;
		    pieceIndex++;
		    compress = pieceIndex;
		  }
		  while (chr()) {
		    if (pieceIndex === 8) return;
		    if (chr() === ':') {
		      if (compress !== null) return;
		      pointer++;
		      pieceIndex++;
		      compress = pieceIndex;
		      continue;
		    }
		    value = length = 0;
		    while (length < 4 && exec(HEX, chr())) {
		      value = value * 16 + parseInt(chr(), 16);
		      pointer++;
		      length++;
		    }
		    if (chr() === '.') {
		      if (length === 0) return;
		      pointer -= length;
		      if (pieceIndex > 6) return;
		      numbersSeen = 0;
		      while (chr()) {
		        ipv4Piece = null;
		        if (numbersSeen > 0) {
		          if (chr() === '.' && numbersSeen < 4) pointer++;
		          else return;
		        }
		        if (!exec(DIGIT, chr())) return;
		        while (exec(DIGIT, chr())) {
		          number = parseInt(chr(), 10);
		          if (ipv4Piece === null) ipv4Piece = number;
		          else if (ipv4Piece === 0) return;
		          else ipv4Piece = ipv4Piece * 10 + number;
		          if (ipv4Piece > 255) return;
		          pointer++;
		        }
		        address[pieceIndex] = address[pieceIndex] * 256 + ipv4Piece;
		        numbersSeen++;
		        if (numbersSeen === 2 || numbersSeen === 4) pieceIndex++;
		      }
		      if (numbersSeen !== 4) return;
		      break;
		    } else if (chr() === ':') {
		      pointer++;
		      if (!chr()) return;
		    } else if (chr()) return;
		    address[pieceIndex++] = value;
		  }
		  if (compress !== null) {
		    swaps = pieceIndex - compress;
		    pieceIndex = 7;
		    while (pieceIndex !== 0 && swaps > 0) {
		      swap = address[pieceIndex];
		      address[pieceIndex--] = address[compress + swaps - 1];
		      address[compress + --swaps] = swap;
		    }
		  } else if (pieceIndex !== 8) return;
		  return address;
		};

		var findLongestZeroSequence = function (ipv6) {
		  var maxIndex = null;
		  var maxLength = 1;
		  var currStart = null;
		  var currLength = 0;
		  var index = 0;
		  for (; index < 8; index++) {
		    if (ipv6[index] !== 0) {
		      if (currLength > maxLength) {
		        maxIndex = currStart;
		        maxLength = currLength;
		      }
		      currStart = null;
		      currLength = 0;
		    } else {
		      if (currStart === null) currStart = index;
		      ++currLength;
		    }
		  }
		  return currLength > maxLength ? currStart : maxIndex;
		};

		// https://url.spec.whatwg.org/#host-serializing
		var serializeHost = function (host) {
		  var result, index, compress, ignore0;

		  // ipv4
		  if (typeof host == 'number') {
		    result = [];
		    for (index = 0; index < 4; index++) {
		      unshift(result, host % 256);
		      host = floor(host / 256);
		    }
		    return join(result, '.');
		  }

		  // ipv6
		  if (typeof host == 'object') {
		    result = '';
		    compress = findLongestZeroSequence(host);
		    for (index = 0; index < 8; index++) {
		      if (ignore0 && host[index] === 0) continue;
		      if (ignore0) ignore0 = false;
		      if (compress === index) {
		        result += index ? ':' : '::';
		        ignore0 = true;
		      } else {
		        result += numberToString(host[index], 16);
		        if (index < 7) result += ':';
		      }
		    }
		    return '[' + result + ']';
		  }

		  return host;
		};

		var C0ControlPercentEncodeSet = {};
		var fragmentPercentEncodeSet = assign({}, C0ControlPercentEncodeSet, {
		  ' ': 1, '"': 1, '<': 1, '>': 1, '`': 1
		});
		var pathPercentEncodeSet = assign({}, fragmentPercentEncodeSet, {
		  '#': 1, '?': 1, '{': 1, '}': 1
		});
		var userinfoPercentEncodeSet = assign({}, pathPercentEncodeSet, {
		  '/': 1, ':': 1, ';': 1, '=': 1, '@': 1, '[': 1, '\\': 1, ']': 1, '^': 1, '|': 1
		});

		var percentEncode = function (chr, set) {
		  var code = codeAt(chr, 0);
		  return code > 0x20 && code < 0x7F && !hasOwn(set, chr) ? chr : encodeURIComponent(chr);
		};

		// https://url.spec.whatwg.org/#special-scheme
		var specialSchemes = {
		  ftp: 21,
		  file: null,
		  http: 80,
		  https: 443,
		  ws: 80,
		  wss: 443
		};

		// https://url.spec.whatwg.org/#windows-drive-letter
		var isWindowsDriveLetter = function (string, normalized) {
		  var second;
		  return string.length === 2 && exec(ALPHA, charAt(string, 0))
		    && ((second = charAt(string, 1)) === ':' || (!normalized && second === '|'));
		};

		// https://url.spec.whatwg.org/#start-with-a-windows-drive-letter
		var startsWithWindowsDriveLetter = function (string) {
		  var third;
		  return string.length > 1 && isWindowsDriveLetter(stringSlice(string, 0, 2)) && (
		    string.length === 2 ||
		    ((third = charAt(string, 2)) === '/' || third === '\\' || third === '?' || third === '#')
		  );
		};

		// https://url.spec.whatwg.org/#single-dot-path-segment
		var isSingleDot = function (segment) {
		  return segment === '.' || toLowerCase(segment) === '%2e';
		};

		// https://url.spec.whatwg.org/#double-dot-path-segment
		var isDoubleDot = function (segment) {
		  segment = toLowerCase(segment);
		  return segment === '..' || segment === '%2e.' || segment === '.%2e' || segment === '%2e%2e';
		};

		// States:
		var SCHEME_START = {};
		var SCHEME = {};
		var NO_SCHEME = {};
		var SPECIAL_RELATIVE_OR_AUTHORITY = {};
		var PATH_OR_AUTHORITY = {};
		var RELATIVE = {};
		var RELATIVE_SLASH = {};
		var SPECIAL_AUTHORITY_SLASHES = {};
		var SPECIAL_AUTHORITY_IGNORE_SLASHES = {};
		var AUTHORITY = {};
		var HOST = {};
		var HOSTNAME = {};
		var PORT = {};
		var FILE = {};
		var FILE_SLASH = {};
		var FILE_HOST = {};
		var PATH_START = {};
		var PATH = {};
		var CANNOT_BE_A_BASE_URL_PATH = {};
		var QUERY = {};
		var FRAGMENT = {};

		var URLState = function (url, isBase, base) {
		  var urlString = $toString(url);
		  var baseState, failure, searchParams;
		  if (isBase) {
		    failure = this.parse(urlString);
		    if (failure) throw new TypeError(failure);
		    this.searchParams = null;
		  } else {
		    if (base !== undefined) baseState = new URLState(base, true);
		    failure = this.parse(urlString, null, baseState);
		    if (failure) throw new TypeError(failure);
		    searchParams = getInternalSearchParamsState(new URLSearchParams());
		    searchParams.bindURL(this);
		    this.searchParams = searchParams;
		  }
		};

		URLState.prototype = {
		  type: 'URL',
		  // https://url.spec.whatwg.org/#url-parsing
		  // eslint-disable-next-line max-statements -- TODO
		  parse: function (input, stateOverride, base) {
		    var url = this;
		    var state = stateOverride || SCHEME_START;
		    var pointer = 0;
		    var buffer = '';
		    var seenAt = false;
		    var seenBracket = false;
		    var seenPasswordToken = false;
		    var codePoints, chr, bufferCodePoints, failure;

		    input = $toString(input);

		    if (!stateOverride) {
		      url.scheme = '';
		      url.username = '';
		      url.password = '';
		      url.host = null;
		      url.port = null;
		      url.path = [];
		      url.query = null;
		      url.fragment = null;
		      url.cannotBeABaseURL = false;
		      input = replace(input, LEADING_C0_CONTROL_OR_SPACE, '');
		      input = replace(input, TRAILING_C0_CONTROL_OR_SPACE, '$1');
		    }

		    input = replace(input, TAB_AND_NEW_LINE, '');

		    codePoints = arrayFrom(input);

		    while (pointer <= codePoints.length) {
		      chr = codePoints[pointer];
		      switch (state) {
		        case SCHEME_START:
		          if (chr && exec(ALPHA, chr)) {
		            buffer += toLowerCase(chr);
		            state = SCHEME;
		          } else if (!stateOverride) {
		            state = NO_SCHEME;
		            continue;
		          } else return INVALID_SCHEME;
		          break;

		        case SCHEME:
		          if (chr && (exec(ALPHANUMERIC, chr) || chr === '+' || chr === '-' || chr === '.')) {
		            buffer += toLowerCase(chr);
		          } else if (chr === ':') {
		            if (stateOverride && (
		              (url.isSpecial() !== hasOwn(specialSchemes, buffer)) ||
		              (buffer === 'file' && (url.includesCredentials() || url.port !== null)) ||
		              (url.scheme === 'file' && !url.host)
		            )) return;
		            url.scheme = buffer;
		            if (stateOverride) {
		              if (url.isSpecial() && specialSchemes[url.scheme] === url.port) url.port = null;
		              return;
		            }
		            buffer = '';
		            if (url.scheme === 'file') {
		              state = FILE;
		            } else if (url.isSpecial() && base && base.scheme === url.scheme) {
		              state = SPECIAL_RELATIVE_OR_AUTHORITY;
		            } else if (url.isSpecial()) {
		              state = SPECIAL_AUTHORITY_SLASHES;
		            } else if (codePoints[pointer + 1] === '/') {
		              state = PATH_OR_AUTHORITY;
		              pointer++;
		            } else {
		              url.cannotBeABaseURL = true;
		              push(url.path, '');
		              state = CANNOT_BE_A_BASE_URL_PATH;
		            }
		          } else if (!stateOverride) {
		            buffer = '';
		            state = NO_SCHEME;
		            pointer = 0;
		            continue;
		          } else return INVALID_SCHEME;
		          break;

		        case NO_SCHEME:
		          if (!base || (base.cannotBeABaseURL && chr !== '#')) return INVALID_SCHEME;
		          if (base.cannotBeABaseURL && chr === '#') {
		            url.scheme = base.scheme;
		            url.path = arraySlice(base.path);
		            url.query = base.query;
		            url.fragment = '';
		            url.cannotBeABaseURL = true;
		            state = FRAGMENT;
		            break;
		          }
		          state = base.scheme === 'file' ? FILE : RELATIVE;
		          continue;

		        case SPECIAL_RELATIVE_OR_AUTHORITY:
		          if (chr === '/' && codePoints[pointer + 1] === '/') {
		            state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
		            pointer++;
		          } else {
		            state = RELATIVE;
		            continue;
		          } break;

		        case PATH_OR_AUTHORITY:
		          if (chr === '/') {
		            state = AUTHORITY;
		            break;
		          } else {
		            state = PATH;
		            continue;
		          }

		        case RELATIVE:
		          url.scheme = base.scheme;
		          if (chr === EOF) {
		            url.username = base.username;
		            url.password = base.password;
		            url.host = base.host;
		            url.port = base.port;
		            url.path = arraySlice(base.path);
		            url.query = base.query;
		          } else if (chr === '/' || (chr === '\\' && url.isSpecial())) {
		            state = RELATIVE_SLASH;
		          } else if (chr === '?') {
		            url.username = base.username;
		            url.password = base.password;
		            url.host = base.host;
		            url.port = base.port;
		            url.path = arraySlice(base.path);
		            url.query = '';
		            state = QUERY;
		          } else if (chr === '#') {
		            url.username = base.username;
		            url.password = base.password;
		            url.host = base.host;
		            url.port = base.port;
		            url.path = arraySlice(base.path);
		            url.query = base.query;
		            url.fragment = '';
		            state = FRAGMENT;
		          } else {
		            url.username = base.username;
		            url.password = base.password;
		            url.host = base.host;
		            url.port = base.port;
		            url.path = arraySlice(base.path);
		            url.path.length--;
		            state = PATH;
		            continue;
		          } break;

		        case RELATIVE_SLASH:
		          if (url.isSpecial() && (chr === '/' || chr === '\\')) {
		            state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
		          } else if (chr === '/') {
		            state = AUTHORITY;
		          } else {
		            url.username = base.username;
		            url.password = base.password;
		            url.host = base.host;
		            url.port = base.port;
		            state = PATH;
		            continue;
		          } break;

		        case SPECIAL_AUTHORITY_SLASHES:
		          state = SPECIAL_AUTHORITY_IGNORE_SLASHES;
		          if (chr !== '/' || charAt(buffer, pointer + 1) !== '/') continue;
		          pointer++;
		          break;

		        case SPECIAL_AUTHORITY_IGNORE_SLASHES:
		          if (chr !== '/' && chr !== '\\') {
		            state = AUTHORITY;
		            continue;
		          } break;

		        case AUTHORITY:
		          if (chr === '@') {
		            if (seenAt) buffer = '%40' + buffer;
		            seenAt = true;
		            bufferCodePoints = arrayFrom(buffer);
		            for (var i = 0; i < bufferCodePoints.length; i++) {
		              var codePoint = bufferCodePoints[i];
		              if (codePoint === ':' && !seenPasswordToken) {
		                seenPasswordToken = true;
		                continue;
		              }
		              var encodedCodePoints = percentEncode(codePoint, userinfoPercentEncodeSet);
		              if (seenPasswordToken) url.password += encodedCodePoints;
		              else url.username += encodedCodePoints;
		            }
		            buffer = '';
		          } else if (
		            chr === EOF || chr === '/' || chr === '?' || chr === '#' ||
		            (chr === '\\' && url.isSpecial())
		          ) {
		            if (seenAt && buffer === '') return INVALID_AUTHORITY;
		            pointer -= arrayFrom(buffer).length + 1;
		            buffer = '';
		            state = HOST;
		          } else buffer += chr;
		          break;

		        case HOST:
		        case HOSTNAME:
		          if (stateOverride && url.scheme === 'file') {
		            state = FILE_HOST;
		            continue;
		          } else if (chr === ':' && !seenBracket) {
		            if (buffer === '') return INVALID_HOST;
		            failure = url.parseHost(buffer);
		            if (failure) return failure;
		            buffer = '';
		            state = PORT;
		            if (stateOverride === HOSTNAME) return;
		          } else if (
		            chr === EOF || chr === '/' || chr === '?' || chr === '#' ||
		            (chr === '\\' && url.isSpecial())
		          ) {
		            if (url.isSpecial() && buffer === '') return INVALID_HOST;
		            if (stateOverride && buffer === '' && (url.includesCredentials() || url.port !== null)) return;
		            failure = url.parseHost(buffer);
		            if (failure) return failure;
		            buffer = '';
		            state = PATH_START;
		            if (stateOverride) return;
		            continue;
		          } else {
		            if (chr === '[') seenBracket = true;
		            else if (chr === ']') seenBracket = false;
		            buffer += chr;
		          } break;

		        case PORT:
		          if (exec(DIGIT, chr)) {
		            buffer += chr;
		          } else if (
		            chr === EOF || chr === '/' || chr === '?' || chr === '#' ||
		            (chr === '\\' && url.isSpecial()) ||
		            stateOverride
		          ) {
		            if (buffer !== '') {
		              var port = parseInt(buffer, 10);
		              if (port > 0xFFFF) return INVALID_PORT;
		              url.port = (url.isSpecial() && port === specialSchemes[url.scheme]) ? null : port;
		              buffer = '';
		            }
		            if (stateOverride) return;
		            state = PATH_START;
		            continue;
		          } else return INVALID_PORT;
		          break;

		        case FILE:
		          url.scheme = 'file';
		          if (chr === '/' || chr === '\\') state = FILE_SLASH;
		          else if (base && base.scheme === 'file') {
		            switch (chr) {
		              case EOF:
		                url.host = base.host;
		                url.path = arraySlice(base.path);
		                url.query = base.query;
		                break;
		              case '?':
		                url.host = base.host;
		                url.path = arraySlice(base.path);
		                url.query = '';
		                state = QUERY;
		                break;
		              case '#':
		                url.host = base.host;
		                url.path = arraySlice(base.path);
		                url.query = base.query;
		                url.fragment = '';
		                state = FRAGMENT;
		                break;
		              default:
		                if (!startsWithWindowsDriveLetter(join(arraySlice(codePoints, pointer), ''))) {
		                  url.host = base.host;
		                  url.path = arraySlice(base.path);
		                  url.shortenPath();
		                }
		                state = PATH;
		                continue;
		            }
		          } else {
		            state = PATH;
		            continue;
		          } break;

		        case FILE_SLASH:
		          if (chr === '/' || chr === '\\') {
		            state = FILE_HOST;
		            break;
		          }
		          if (base && base.scheme === 'file' && !startsWithWindowsDriveLetter(join(arraySlice(codePoints, pointer), ''))) {
		            if (isWindowsDriveLetter(base.path[0], true)) push(url.path, base.path[0]);
		            else url.host = base.host;
		          }
		          state = PATH;
		          continue;

		        case FILE_HOST:
		          if (chr === EOF || chr === '/' || chr === '\\' || chr === '?' || chr === '#') {
		            if (!stateOverride && isWindowsDriveLetter(buffer)) {
		              state = PATH;
		            } else if (buffer === '') {
		              url.host = '';
		              if (stateOverride) return;
		              state = PATH_START;
		            } else {
		              failure = url.parseHost(buffer);
		              if (failure) return failure;
		              if (url.host === 'localhost') url.host = '';
		              if (stateOverride) return;
		              buffer = '';
		              state = PATH_START;
		            } continue;
		          } else buffer += chr;
		          break;

		        case PATH_START:
		          if (url.isSpecial()) {
		            state = PATH;
		            if (chr !== '/' && chr !== '\\') continue;
		          } else if (!stateOverride && chr === '?') {
		            url.query = '';
		            state = QUERY;
		          } else if (!stateOverride && chr === '#') {
		            url.fragment = '';
		            state = FRAGMENT;
		          } else if (chr !== EOF) {
		            state = PATH;
		            if (chr !== '/') continue;
		          } break;

		        case PATH:
		          if (
		            chr === EOF || chr === '/' ||
		            (chr === '\\' && url.isSpecial()) ||
		            (!stateOverride && (chr === '?' || chr === '#'))
		          ) {
		            if (isDoubleDot(buffer)) {
		              url.shortenPath();
		              if (chr !== '/' && !(chr === '\\' && url.isSpecial())) {
		                push(url.path, '');
		              }
		            } else if (isSingleDot(buffer)) {
		              if (chr !== '/' && !(chr === '\\' && url.isSpecial())) {
		                push(url.path, '');
		              }
		            } else {
		              if (url.scheme === 'file' && !url.path.length && isWindowsDriveLetter(buffer)) {
		                if (url.host) url.host = '';
		                buffer = charAt(buffer, 0) + ':'; // normalize windows drive letter
		              }
		              push(url.path, buffer);
		            }
		            buffer = '';
		            if (url.scheme === 'file' && (chr === EOF || chr === '?' || chr === '#')) {
		              while (url.path.length > 1 && url.path[0] === '') {
		                shift(url.path);
		              }
		            }
		            if (chr === '?') {
		              url.query = '';
		              state = QUERY;
		            } else if (chr === '#') {
		              url.fragment = '';
		              state = FRAGMENT;
		            }
		          } else {
		            buffer += percentEncode(chr, pathPercentEncodeSet);
		          } break;

		        case CANNOT_BE_A_BASE_URL_PATH:
		          if (chr === '?') {
		            url.query = '';
		            state = QUERY;
		          } else if (chr === '#') {
		            url.fragment = '';
		            state = FRAGMENT;
		          } else if (chr !== EOF) {
		            url.path[0] += percentEncode(chr, C0ControlPercentEncodeSet);
		          } break;

		        case QUERY:
		          if (!stateOverride && chr === '#') {
		            url.fragment = '';
		            state = FRAGMENT;
		          } else if (chr !== EOF) {
		            if (chr === "'" && url.isSpecial()) url.query += '%27';
		            else if (chr === '#') url.query += '%23';
		            else url.query += percentEncode(chr, C0ControlPercentEncodeSet);
		          } break;

		        case FRAGMENT:
		          if (chr !== EOF) url.fragment += percentEncode(chr, fragmentPercentEncodeSet);
		          break;
		      }

		      pointer++;
		    }
		  },
		  // https://url.spec.whatwg.org/#host-parsing
		  parseHost: function (input) {
		    var result, codePoints, index;
		    if (charAt(input, 0) === '[') {
		      if (charAt(input, input.length - 1) !== ']') return INVALID_HOST;
		      result = parseIPv6(stringSlice(input, 1, -1));
		      if (!result) return INVALID_HOST;
		      this.host = result;
		    // opaque host
		    } else if (!this.isSpecial()) {
		      if (exec(FORBIDDEN_HOST_CODE_POINT_EXCLUDING_PERCENT, input)) return INVALID_HOST;
		      result = '';
		      codePoints = arrayFrom(input);
		      for (index = 0; index < codePoints.length; index++) {
		        result += percentEncode(codePoints[index], C0ControlPercentEncodeSet);
		      }
		      this.host = result;
		    } else {
		      input = toASCII(input);
		      if (exec(FORBIDDEN_HOST_CODE_POINT, input)) return INVALID_HOST;
		      result = parseIPv4(input);
		      if (result === null) return INVALID_HOST;
		      this.host = result;
		    }
		  },
		  // https://url.spec.whatwg.org/#cannot-have-a-username-password-port
		  cannotHaveUsernamePasswordPort: function () {
		    return !this.host || this.cannotBeABaseURL || this.scheme === 'file';
		  },
		  // https://url.spec.whatwg.org/#include-credentials
		  includesCredentials: function () {
		    return this.username !== '' || this.password !== '';
		  },
		  // https://url.spec.whatwg.org/#is-special
		  isSpecial: function () {
		    return hasOwn(specialSchemes, this.scheme);
		  },
		  // https://url.spec.whatwg.org/#shorten-a-urls-path
		  shortenPath: function () {
		    var path = this.path;
		    var pathSize = path.length;
		    if (pathSize && (this.scheme !== 'file' || pathSize !== 1 || !isWindowsDriveLetter(path[0], true))) {
		      path.length--;
		    }
		  },
		  // https://url.spec.whatwg.org/#concept-url-serializer
		  serialize: function () {
		    var url = this;
		    var scheme = url.scheme;
		    var username = url.username;
		    var password = url.password;
		    var host = url.host;
		    var port = url.port;
		    var path = url.path;
		    var query = url.query;
		    var fragment = url.fragment;
		    var output = scheme + ':';
		    if (host !== null) {
		      output += '//';
		      if (url.includesCredentials()) {
		        output += username + (password ? ':' + password : '') + '@';
		      }
		      output += serializeHost(host);
		      if (port !== null) output += ':' + port;
		    } else if (scheme === 'file') output += '//';
		    output += url.cannotBeABaseURL ? path[0] : path.length ? '/' + join(path, '/') : '';
		    if (query !== null) output += '?' + query;
		    if (fragment !== null) output += '#' + fragment;
		    return output;
		  },
		  // https://url.spec.whatwg.org/#dom-url-href
		  setHref: function (href) {
		    var failure = this.parse(href);
		    if (failure) throw new TypeError(failure);
		    this.searchParams.update();
		  },
		  // https://url.spec.whatwg.org/#dom-url-origin
		  getOrigin: function () {
		    var scheme = this.scheme;
		    var port = this.port;
		    if (scheme === 'blob') try {
		      return new URLConstructor(scheme.path[0]).origin;
		    } catch (error) {
		      return 'null';
		    }
		    if (scheme === 'file' || !this.isSpecial()) return 'null';
		    return scheme + '://' + serializeHost(this.host) + (port !== null ? ':' + port : '');
		  },
		  // https://url.spec.whatwg.org/#dom-url-protocol
		  getProtocol: function () {
		    return this.scheme + ':';
		  },
		  setProtocol: function (protocol) {
		    this.parse($toString(protocol) + ':', SCHEME_START);
		  },
		  // https://url.spec.whatwg.org/#dom-url-username
		  getUsername: function () {
		    return this.username;
		  },
		  setUsername: function (username) {
		    var codePoints = arrayFrom($toString(username));
		    if (this.cannotHaveUsernamePasswordPort()) return;
		    this.username = '';
		    for (var i = 0; i < codePoints.length; i++) {
		      this.username += percentEncode(codePoints[i], userinfoPercentEncodeSet);
		    }
		  },
		  // https://url.spec.whatwg.org/#dom-url-password
		  getPassword: function () {
		    return this.password;
		  },
		  setPassword: function (password) {
		    var codePoints = arrayFrom($toString(password));
		    if (this.cannotHaveUsernamePasswordPort()) return;
		    this.password = '';
		    for (var i = 0; i < codePoints.length; i++) {
		      this.password += percentEncode(codePoints[i], userinfoPercentEncodeSet);
		    }
		  },
		  // https://url.spec.whatwg.org/#dom-url-host
		  getHost: function () {
		    var host = this.host;
		    var port = this.port;
		    return host === null ? ''
		      : port === null ? serializeHost(host)
		      : serializeHost(host) + ':' + port;
		  },
		  setHost: function (host) {
		    if (this.cannotBeABaseURL) return;
		    this.parse(host, HOST);
		  },
		  // https://url.spec.whatwg.org/#dom-url-hostname
		  getHostname: function () {
		    var host = this.host;
		    return host === null ? '' : serializeHost(host);
		  },
		  setHostname: function (hostname) {
		    if (this.cannotBeABaseURL) return;
		    this.parse(hostname, HOSTNAME);
		  },
		  // https://url.spec.whatwg.org/#dom-url-port
		  getPort: function () {
		    var port = this.port;
		    return port === null ? '' : $toString(port);
		  },
		  setPort: function (port) {
		    if (this.cannotHaveUsernamePasswordPort()) return;
		    port = $toString(port);
		    if (port === '') this.port = null;
		    else this.parse(port, PORT);
		  },
		  // https://url.spec.whatwg.org/#dom-url-pathname
		  getPathname: function () {
		    var path = this.path;
		    return this.cannotBeABaseURL ? path[0] : path.length ? '/' + join(path, '/') : '';
		  },
		  setPathname: function (pathname) {
		    if (this.cannotBeABaseURL) return;
		    this.path = [];
		    this.parse(pathname, PATH_START);
		  },
		  // https://url.spec.whatwg.org/#dom-url-search
		  getSearch: function () {
		    var query = this.query;
		    return query ? '?' + query : '';
		  },
		  setSearch: function (search) {
		    search = $toString(search);
		    if (search === '') {
		      this.query = null;
		    } else {
		      if (charAt(search, 0) === '?') search = stringSlice(search, 1);
		      this.query = '';
		      this.parse(search, QUERY);
		    }
		    this.searchParams.update();
		  },
		  // https://url.spec.whatwg.org/#dom-url-searchparams
		  getSearchParams: function () {
		    return this.searchParams.facade;
		  },
		  // https://url.spec.whatwg.org/#dom-url-hash
		  getHash: function () {
		    var fragment = this.fragment;
		    return fragment ? '#' + fragment : '';
		  },
		  setHash: function (hash) {
		    hash = $toString(hash);
		    if (hash === '') {
		      this.fragment = null;
		      return;
		    }
		    if (charAt(hash, 0) === '#') hash = stringSlice(hash, 1);
		    this.fragment = '';
		    this.parse(hash, FRAGMENT);
		  },
		  update: function () {
		    this.query = this.searchParams.serialize() || null;
		  }
		};

		// `URL` constructor
		// https://url.spec.whatwg.org/#url-class
		var URLConstructor = function URL(url /* , base */) {
		  var that = anInstance(this, URLPrototype);
		  var base = validateArgumentsLength(arguments.length, 1) > 1 ? arguments[1] : undefined;
		  var state = setInternalState(that, new URLState(url, false, base));
		  if (!DESCRIPTORS) {
		    that.href = state.serialize();
		    that.origin = state.getOrigin();
		    that.protocol = state.getProtocol();
		    that.username = state.getUsername();
		    that.password = state.getPassword();
		    that.host = state.getHost();
		    that.hostname = state.getHostname();
		    that.port = state.getPort();
		    that.pathname = state.getPathname();
		    that.search = state.getSearch();
		    that.searchParams = state.getSearchParams();
		    that.hash = state.getHash();
		  }
		};

		var URLPrototype = URLConstructor.prototype;

		var accessorDescriptor = function (getter, setter) {
		  return {
		    get: function () {
		      return getInternalURLState(this)[getter]();
		    },
		    set: setter && function (value) {
		      return getInternalURLState(this)[setter](value);
		    },
		    configurable: true,
		    enumerable: true
		  };
		};

		if (DESCRIPTORS) {
		  // `URL.prototype.href` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-href
		  defineBuiltInAccessor(URLPrototype, 'href', accessorDescriptor('serialize', 'setHref'));
		  // `URL.prototype.origin` getter
		  // https://url.spec.whatwg.org/#dom-url-origin
		  defineBuiltInAccessor(URLPrototype, 'origin', accessorDescriptor('getOrigin'));
		  // `URL.prototype.protocol` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-protocol
		  defineBuiltInAccessor(URLPrototype, 'protocol', accessorDescriptor('getProtocol', 'setProtocol'));
		  // `URL.prototype.username` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-username
		  defineBuiltInAccessor(URLPrototype, 'username', accessorDescriptor('getUsername', 'setUsername'));
		  // `URL.prototype.password` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-password
		  defineBuiltInAccessor(URLPrototype, 'password', accessorDescriptor('getPassword', 'setPassword'));
		  // `URL.prototype.host` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-host
		  defineBuiltInAccessor(URLPrototype, 'host', accessorDescriptor('getHost', 'setHost'));
		  // `URL.prototype.hostname` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-hostname
		  defineBuiltInAccessor(URLPrototype, 'hostname', accessorDescriptor('getHostname', 'setHostname'));
		  // `URL.prototype.port` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-port
		  defineBuiltInAccessor(URLPrototype, 'port', accessorDescriptor('getPort', 'setPort'));
		  // `URL.prototype.pathname` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-pathname
		  defineBuiltInAccessor(URLPrototype, 'pathname', accessorDescriptor('getPathname', 'setPathname'));
		  // `URL.prototype.search` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-search
		  defineBuiltInAccessor(URLPrototype, 'search', accessorDescriptor('getSearch', 'setSearch'));
		  // `URL.prototype.searchParams` getter
		  // https://url.spec.whatwg.org/#dom-url-searchparams
		  defineBuiltInAccessor(URLPrototype, 'searchParams', accessorDescriptor('getSearchParams'));
		  // `URL.prototype.hash` accessors pair
		  // https://url.spec.whatwg.org/#dom-url-hash
		  defineBuiltInAccessor(URLPrototype, 'hash', accessorDescriptor('getHash', 'setHash'));
		}

		// `URL.prototype.toJSON` method
		// https://url.spec.whatwg.org/#dom-url-tojson
		defineBuiltIn(URLPrototype, 'toJSON', function toJSON() {
		  return getInternalURLState(this).serialize();
		}, { enumerable: true });

		// `URL.prototype.toString` method
		// https://url.spec.whatwg.org/#URL-stringification-behavior
		defineBuiltIn(URLPrototype, 'toString', function toString() {
		  return getInternalURLState(this).serialize();
		}, { enumerable: true });

		if (NativeURL) {
		  var nativeCreateObjectURL = NativeURL.createObjectURL;
		  var nativeRevokeObjectURL = NativeURL.revokeObjectURL;
		  // `URL.createObjectURL` method
		  // https://developer.mozilla.org/en-US/docs/Web/API/URL/createObjectURL
		  if (nativeCreateObjectURL) defineBuiltIn(URLConstructor, 'createObjectURL', bind(nativeCreateObjectURL, NativeURL));
		  // `URL.revokeObjectURL` method
		  // https://developer.mozilla.org/en-US/docs/Web/API/URL/revokeObjectURL
		  if (nativeRevokeObjectURL) defineBuiltIn(URLConstructor, 'revokeObjectURL', bind(nativeRevokeObjectURL, NativeURL));
		}

		setToStringTag(URLConstructor, 'URL');

		$({ global: true, constructor: true, forced: !USE_NATIVE_URL, sham: !DESCRIPTORS }, {
		  URL: URLConstructor
		});
		return web_url_constructor;
	}

	var hasRequiredWeb_url;

	function requireWeb_url () {
		if (hasRequiredWeb_url) return web_url;
		hasRequiredWeb_url = 1;
		// TODO: Remove this module from `core-js@4` since it's replaced to module below
		requireWeb_url_constructor();
		return web_url;
	}

	var web_url_canParse = {};

	var hasRequiredWeb_url_canParse;

	function requireWeb_url_canParse () {
		if (hasRequiredWeb_url_canParse) return web_url_canParse;
		hasRequiredWeb_url_canParse = 1;
		var $ = /*@__PURE__*/ require_export();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var fails = /*@__PURE__*/ requireFails();
		var validateArgumentsLength = /*@__PURE__*/ requireValidateArgumentsLength();
		var toString = /*@__PURE__*/ requireToString();
		var USE_NATIVE_URL = /*@__PURE__*/ requireUrlConstructorDetection();

		var URL = getBuiltIn('URL');

		// https://github.com/nodejs/node/issues/47505
		// https://github.com/denoland/deno/issues/18893
		var THROWS_WITHOUT_ARGUMENTS = USE_NATIVE_URL && fails(function () {
		  URL.canParse();
		});

		// Bun ~ 1.0.30 bug
		// https://github.com/oven-sh/bun/issues/9250
		var WRONG_ARITY = fails(function () {
		  return URL.canParse.length !== 1;
		});

		// `URL.canParse` method
		// https://url.spec.whatwg.org/#dom-url-canparse
		$({ target: 'URL', stat: true, forced: !THROWS_WITHOUT_ARGUMENTS || WRONG_ARITY }, {
		  canParse: function canParse(url) {
		    var length = validateArgumentsLength(arguments.length, 1);
		    var urlString = toString(url);
		    var base = length < 2 || arguments[1] === undefined ? undefined : toString(arguments[1]);
		    try {
		      return !!new URL(urlString, base);
		    } catch (error) {
		      return false;
		    }
		  }
		});
		return web_url_canParse;
	}

	var web_url_parse = {};

	var hasRequiredWeb_url_parse;

	function requireWeb_url_parse () {
		if (hasRequiredWeb_url_parse) return web_url_parse;
		hasRequiredWeb_url_parse = 1;
		var $ = /*@__PURE__*/ require_export();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var validateArgumentsLength = /*@__PURE__*/ requireValidateArgumentsLength();
		var toString = /*@__PURE__*/ requireToString();
		var USE_NATIVE_URL = /*@__PURE__*/ requireUrlConstructorDetection();

		var URL = getBuiltIn('URL');

		// `URL.parse` method
		// https://url.spec.whatwg.org/#dom-url-canparse
		$({ target: 'URL', stat: true, forced: !USE_NATIVE_URL }, {
		  parse: function parse(url) {
		    var length = validateArgumentsLength(arguments.length, 1);
		    var urlString = toString(url);
		    var base = length < 2 || arguments[1] === undefined ? undefined : toString(arguments[1]);
		    try {
		      return new URL(urlString, base);
		    } catch (error) {
		      return null;
		    }
		  }
		});
		return web_url_parse;
	}

	var url$3;
	var hasRequiredUrl$3;

	function requireUrl$3 () {
		if (hasRequiredUrl$3) return url$3;
		hasRequiredUrl$3 = 1;
		requireWeb_url();
		requireWeb_url_canParse();
		requireWeb_url_parse();
		var path = /*@__PURE__*/ requirePath$1();

		url$3 = path.URL;
		return url$3;
	}

	var url$2;
	var hasRequiredUrl$2;

	function requireUrl$2 () {
		if (hasRequiredUrl$2) return url$2;
		hasRequiredUrl$2 = 1;
		var parent = /*@__PURE__*/ requireUrl$3();

		url$2 = parent;
		return url$2;
	}

	var url$1;
	var hasRequiredUrl$1;
	function requireUrl$1() {
	  if (hasRequiredUrl$1) return url$1;
	  hasRequiredUrl$1 = 1;
	  url$1 = /*@__PURE__*/requireUrl$2();
	  return url$1;
	}

	var urlExports = requireUrl$1();
	var _URL = /*@__PURE__*/getDefaultExportFromCjs(urlExports);

	var es_array_indexOf = {};

	var arrayMethodIsStrict;
	var hasRequiredArrayMethodIsStrict;

	function requireArrayMethodIsStrict () {
		if (hasRequiredArrayMethodIsStrict) return arrayMethodIsStrict;
		hasRequiredArrayMethodIsStrict = 1;
		var fails = /*@__PURE__*/ requireFails();

		arrayMethodIsStrict = function (METHOD_NAME, argument) {
		  var method = [][METHOD_NAME];
		  return !!method && fails(function () {
		    // eslint-disable-next-line no-useless-call -- required for testing
		    method.call(null, argument || function () { return 1; }, 1);
		  });
		};
		return arrayMethodIsStrict;
	}

	var hasRequiredEs_array_indexOf;

	function requireEs_array_indexOf () {
		if (hasRequiredEs_array_indexOf) return es_array_indexOf;
		hasRequiredEs_array_indexOf = 1;
		/* eslint-disable es/no-array-prototype-indexof -- required for testing */
		var $ = /*@__PURE__*/ require_export();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThisClause();
		var $indexOf = /*@__PURE__*/ requireArrayIncludes().indexOf;
		var arrayMethodIsStrict = /*@__PURE__*/ requireArrayMethodIsStrict();

		var nativeIndexOf = uncurryThis([].indexOf);

		var NEGATIVE_ZERO = !!nativeIndexOf && 1 / nativeIndexOf([1], 1, -0) < 0;
		var FORCED = NEGATIVE_ZERO || !arrayMethodIsStrict('indexOf');

		// `Array.prototype.indexOf` method
		// https://tc39.es/ecma262/#sec-array.prototype.indexof
		$({ target: 'Array', proto: true, forced: FORCED }, {
		  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
		    var fromIndex = arguments.length > 1 ? arguments[1] : undefined;
		    return NEGATIVE_ZERO
		      // convert -0 to +0
		      ? nativeIndexOf(this, searchElement, fromIndex) || 0
		      : $indexOf(this, searchElement, fromIndex);
		  }
		});
		return es_array_indexOf;
	}

	var indexOf$6;
	var hasRequiredIndexOf$6;

	function requireIndexOf$6 () {
		if (hasRequiredIndexOf$6) return indexOf$6;
		hasRequiredIndexOf$6 = 1;
		requireEs_array_indexOf();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		indexOf$6 = getBuiltInPrototypeMethod('Array', 'indexOf');
		return indexOf$6;
	}

	var indexOf$5;
	var hasRequiredIndexOf$5;

	function requireIndexOf$5 () {
		if (hasRequiredIndexOf$5) return indexOf$5;
		hasRequiredIndexOf$5 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireIndexOf$6();

		var ArrayPrototype = Array.prototype;

		indexOf$5 = function (it) {
		  var own = it.indexOf;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.indexOf) ? method : own;
		};
		return indexOf$5;
	}

	var indexOf$4;
	var hasRequiredIndexOf$4;

	function requireIndexOf$4 () {
		if (hasRequiredIndexOf$4) return indexOf$4;
		hasRequiredIndexOf$4 = 1;
		var parent = /*@__PURE__*/ requireIndexOf$5();

		indexOf$4 = parent;
		return indexOf$4;
	}

	var indexOf$3;
	var hasRequiredIndexOf$3;
	function requireIndexOf$3() {
	  if (hasRequiredIndexOf$3) return indexOf$3;
	  hasRequiredIndexOf$3 = 1;
	  indexOf$3 = /*@__PURE__*/requireIndexOf$4();
	  return indexOf$3;
	}

	var indexOfExports$1 = requireIndexOf$3();
	var _indexOfInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(indexOfExports$1);

	var text_min = {};

	var hasRequiredText_min;
	function requireText_min() {
	  if (hasRequiredText_min) return text_min;
	  hasRequiredText_min = 1;
	  (function (scope, _context3) {

	    function B(r, e) {
	      var f;
	      return r instanceof Buffer ? f = r : f = Buffer.from(r.buffer, r.byteOffset, r.byteLength), f.toString(e);
	    }
	    var w = function w(r) {
	      return Buffer.from(r);
	    };
	    function h(r) {
	      for (var e = 0, f = Math.min(256 * 256, r.length + 1), n = new Uint16Array(f), i = [], o = 0;;) {
	        var t = e < r.length;
	        if (!t || o >= f - 1) {
	          var s = n.subarray(0, o),
	            m = s;
	          if (i.push(String.fromCharCode.apply(null, m)), !t) return i.join("");
	          r = r.subarray(e), e = 0, o = 0;
	        }
	        var a = r[e++];
	        if ((a & 128) === 0) n[o++] = a;else if ((a & 224) === 192) {
	          var d = r[e++] & 63;
	          n[o++] = (a & 31) << 6 | d;
	        } else if ((a & 240) === 224) {
	          var d = r[e++] & 63,
	            l = r[e++] & 63;
	          n[o++] = (a & 31) << 12 | d << 6 | l;
	        } else if ((a & 248) === 240) {
	          var d = r[e++] & 63,
	            l = r[e++] & 63,
	            R = r[e++] & 63,
	            c = (a & 7) << 18 | d << 12 | l << 6 | R;
	          c > 65535 && (c -= 65536, n[o++] = c >>> 10 & 1023 | 55296, c = 56320 | c & 1023), n[o++] = c;
	        }
	      }
	    }
	    function F(r) {
	      for (var e = 0, f = r.length, n = 0, i = Math.max(32, f + (f >>> 1) + 7), o = new Uint8Array(i >>> 3 << 3); e < f;) {
	        var t = r.charCodeAt(e++);
	        if (t >= 55296 && t <= 56319) {
	          if (e < f) {
	            var s = r.charCodeAt(e);
	            (s & 64512) === 56320 && (++e, t = ((t & 1023) << 10) + (s & 1023) + 65536);
	          }
	          if (t >= 55296 && t <= 56319) continue;
	        }
	        if (n + 4 > o.length) {
	          i += 8, i *= 1 + e / r.length * 2, i = i >>> 3 << 3;
	          var m = new Uint8Array(i);
	          m.set(o), o = m;
	        }
	        if ((t & 4294967168) === 0) {
	          o[n++] = t;
	          continue;
	        } else if ((t & 4294965248) === 0) o[n++] = t >>> 6 & 31 | 192;else if ((t & 4294901760) === 0) o[n++] = t >>> 12 & 15 | 224, o[n++] = t >>> 6 & 63 | 128;else if ((t & 4292870144) === 0) o[n++] = t >>> 18 & 7 | 240, o[n++] = t >>> 12 & 63 | 128, o[n++] = t >>> 6 & 63 | 128;else continue;
	        o[n++] = t & 63 | 128;
	      }
	      return _sliceInstanceProperty$1(o) ? _sliceInstanceProperty$1(o).call(o, 0, n) : o.subarray(0, n);
	    }
	    var u = "Failed to ",
	      p = function p(r, e, f) {
	        var _context, _context2;
	        if (r) throw new Error(_concatInstanceProperty(_context = _concatInstanceProperty(_context2 = "".concat(u)).call(_context2, e, ": the '")).call(_context, f, "' option is unsupported."));
	      };
	    var x = typeof Buffer == "function" && Buffer.from;
	    var A = x ? w : F;
	    function v() {
	      this.encoding = "utf-8";
	    }
	    v.prototype.encode = function (r, e) {
	      return p(e && e.stream, "encode", "stream"), A(r);
	    };
	    function U(r) {
	      var e;
	      try {
	        var f = new Blob([r], {
	          type: "text/plain;charset=UTF-8"
	        });
	        e = _URL.createObjectURL(f);
	        var n = new XMLHttpRequest();
	        return n.open("GET", e, !1), n.send(), n.responseText;
	      } finally {
	        e && _URL.revokeObjectURL(e);
	      }
	    }
	    var O = !x && typeof Blob == "function" && typeof _URL == "function" && typeof _URL.createObjectURL == "function",
	      S = ["utf-8", "utf8", "unicode-1-1-utf-8"],
	      T = h;
	    x ? T = B : O && (T = function T(r) {
	      try {
	        return U(r);
	      } catch (e) {
	        return h(r);
	      }
	    });
	    var y = "construct 'TextDecoder'",
	      E = _concatInstanceProperty(_context3 = "".concat(u, " ")).call(_context3, y, ": the ");
	    function g(r, e) {
	      var _context4;
	      p(e && e.fatal, y, "fatal"), r = r || "utf-8";
	      var f;
	      if (x ? f = Buffer.isEncoding(r) : f = _indexOfInstanceProperty$1(S).call(S, r.toLowerCase()) !== -1, !f) throw new RangeError(_concatInstanceProperty(_context4 = "".concat(E, " encoding label provided ('")).call(_context4, r, "') is invalid."));
	      this.encoding = r, this.fatal = false, this.ignoreBOM = false;
	    }
	    g.prototype.decode = function (r, e) {
	      p(e && e.stream, "decode", "stream");
	      var f;
	      return r instanceof Uint8Array ? f = r : r.buffer instanceof ArrayBuffer ? f = new Uint8Array(r.buffer) : f = new Uint8Array(r), T(f, this.encoding);
	    };
	    scope.TextEncoder = scope.TextEncoder || v;
	    scope.TextDecoder = scope.TextDecoder || g;
	  })(typeof window !== 'undefined' ? window : typeof commonjsGlobal !== 'undefined' ? commonjsGlobal : text_min);
	  return text_min;
	}

	requireText_min();

	var es_object_keys = {};

	var hasRequiredEs_object_keys;

	function requireEs_object_keys () {
		if (hasRequiredEs_object_keys) return es_object_keys;
		hasRequiredEs_object_keys = 1;
		var $ = /*@__PURE__*/ require_export();
		var toObject = /*@__PURE__*/ requireToObject();
		var nativeKeys = /*@__PURE__*/ requireObjectKeys();
		var fails = /*@__PURE__*/ requireFails();

		var FAILS_ON_PRIMITIVES = fails(function () { nativeKeys(1); });

		// `Object.keys` method
		// https://tc39.es/ecma262/#sec-object.keys
		$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
		  keys: function keys(it) {
		    return nativeKeys(toObject(it));
		  }
		});
		return es_object_keys;
	}

	var keys$6;
	var hasRequiredKeys$6;

	function requireKeys$6 () {
		if (hasRequiredKeys$6) return keys$6;
		hasRequiredKeys$6 = 1;
		requireEs_object_keys();
		var path = /*@__PURE__*/ requirePath$1();

		keys$6 = path.Object.keys;
		return keys$6;
	}

	var keys$5;
	var hasRequiredKeys$5;

	function requireKeys$5 () {
		if (hasRequiredKeys$5) return keys$5;
		hasRequiredKeys$5 = 1;
		var parent = /*@__PURE__*/ requireKeys$6();

		keys$5 = parent;
		return keys$5;
	}

	var keys$4;
	var hasRequiredKeys$4;
	function requireKeys$4() {
	  if (hasRequiredKeys$4) return keys$4;
	  hasRequiredKeys$4 = 1;
	  keys$4 = /*@__PURE__*/requireKeys$5();
	  return keys$4;
	}

	var keysExports$1 = requireKeys$4();
	var _Object$keys = /*@__PURE__*/getDefaultExportFromCjs(keysExports$1);

	var es_symbol = {};

	var es_symbol_constructor = {};

	var objectGetOwnPropertyNames = {};

	var hasRequiredObjectGetOwnPropertyNames;

	function requireObjectGetOwnPropertyNames () {
		if (hasRequiredObjectGetOwnPropertyNames) return objectGetOwnPropertyNames;
		hasRequiredObjectGetOwnPropertyNames = 1;
		var internalObjectKeys = /*@__PURE__*/ requireObjectKeysInternal();
		var enumBugKeys = /*@__PURE__*/ requireEnumBugKeys();

		var hiddenKeys = enumBugKeys.concat('length', 'prototype');

		// `Object.getOwnPropertyNames` method
		// https://tc39.es/ecma262/#sec-object.getownpropertynames
		// eslint-disable-next-line es/no-object-getownpropertynames -- safe
		objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
		  return internalObjectKeys(O, hiddenKeys);
		};
		return objectGetOwnPropertyNames;
	}

	var objectGetOwnPropertyNamesExternal = {};

	var hasRequiredObjectGetOwnPropertyNamesExternal;

	function requireObjectGetOwnPropertyNamesExternal () {
		if (hasRequiredObjectGetOwnPropertyNamesExternal) return objectGetOwnPropertyNamesExternal;
		hasRequiredObjectGetOwnPropertyNamesExternal = 1;
		/* eslint-disable es/no-object-getownpropertynames -- safe */
		var classof = /*@__PURE__*/ requireClassofRaw();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var $getOwnPropertyNames = /*@__PURE__*/ requireObjectGetOwnPropertyNames().f;
		var arraySlice = /*@__PURE__*/ requireArraySlice();

		var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
		  ? Object.getOwnPropertyNames(window) : [];

		var getWindowNames = function (it) {
		  try {
		    return $getOwnPropertyNames(it);
		  } catch (error) {
		    return arraySlice(windowNames);
		  }
		};

		// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
		objectGetOwnPropertyNamesExternal.f = function getOwnPropertyNames(it) {
		  return windowNames && classof(it) === 'Window'
		    ? getWindowNames(it)
		    : $getOwnPropertyNames(toIndexedObject(it));
		};
		return objectGetOwnPropertyNamesExternal;
	}

	var wellKnownSymbolWrapped = {};

	var hasRequiredWellKnownSymbolWrapped;

	function requireWellKnownSymbolWrapped () {
		if (hasRequiredWellKnownSymbolWrapped) return wellKnownSymbolWrapped;
		hasRequiredWellKnownSymbolWrapped = 1;
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		wellKnownSymbolWrapped.f = wellKnownSymbol;
		return wellKnownSymbolWrapped;
	}

	var wellKnownSymbolDefine;
	var hasRequiredWellKnownSymbolDefine;

	function requireWellKnownSymbolDefine () {
		if (hasRequiredWellKnownSymbolDefine) return wellKnownSymbolDefine;
		hasRequiredWellKnownSymbolDefine = 1;
		var path = /*@__PURE__*/ requirePath$1();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var wrappedWellKnownSymbolModule = /*@__PURE__*/ requireWellKnownSymbolWrapped();
		var defineProperty = /*@__PURE__*/ requireObjectDefineProperty().f;

		wellKnownSymbolDefine = function (NAME) {
		  var Symbol = path.Symbol || (path.Symbol = {});
		  if (!hasOwn(Symbol, NAME)) defineProperty(Symbol, NAME, {
		    value: wrappedWellKnownSymbolModule.f(NAME)
		  });
		};
		return wellKnownSymbolDefine;
	}

	var symbolDefineToPrimitive;
	var hasRequiredSymbolDefineToPrimitive;

	function requireSymbolDefineToPrimitive () {
		if (hasRequiredSymbolDefineToPrimitive) return symbolDefineToPrimitive;
		hasRequiredSymbolDefineToPrimitive = 1;
		var call = /*@__PURE__*/ requireFunctionCall();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();

		symbolDefineToPrimitive = function () {
		  var Symbol = getBuiltIn('Symbol');
		  var SymbolPrototype = Symbol && Symbol.prototype;
		  var valueOf = SymbolPrototype && SymbolPrototype.valueOf;
		  var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');

		  if (SymbolPrototype && !SymbolPrototype[TO_PRIMITIVE]) {
		    // `Symbol.prototype[@@toPrimitive]` method
		    // https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
		    // eslint-disable-next-line no-unused-vars -- required for .length
		    defineBuiltIn(SymbolPrototype, TO_PRIMITIVE, function (hint) {
		      return call(valueOf, this);
		    }, { arity: 1 });
		  }
		};
		return symbolDefineToPrimitive;
	}

	var arrayIteration;
	var hasRequiredArrayIteration;

	function requireArrayIteration () {
		if (hasRequiredArrayIteration) return arrayIteration;
		hasRequiredArrayIteration = 1;
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var IndexedObject = /*@__PURE__*/ requireIndexedObject();
		var toObject = /*@__PURE__*/ requireToObject();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var arraySpeciesCreate = /*@__PURE__*/ requireArraySpeciesCreate();

		var push = uncurryThis([].push);

		// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
		var createMethod = function (TYPE) {
		  var IS_MAP = TYPE === 1;
		  var IS_FILTER = TYPE === 2;
		  var IS_SOME = TYPE === 3;
		  var IS_EVERY = TYPE === 4;
		  var IS_FIND_INDEX = TYPE === 6;
		  var IS_FILTER_REJECT = TYPE === 7;
		  var NO_HOLES = TYPE === 5 || IS_FIND_INDEX;
		  return function ($this, callbackfn, that, specificCreate) {
		    var O = toObject($this);
		    var self = IndexedObject(O);
		    var length = lengthOfArrayLike(self);
		    var boundFunction = bind(callbackfn, that);
		    var index = 0;
		    var create = specificCreate || arraySpeciesCreate;
		    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
		    var value, result;
		    for (;length > index; index++) if (NO_HOLES || index in self) {
		      value = self[index];
		      result = boundFunction(value, index, O);
		      if (TYPE) {
		        if (IS_MAP) target[index] = result; // map
		        else if (result) switch (TYPE) {
		          case 3: return true;              // some
		          case 5: return value;             // find
		          case 6: return index;             // findIndex
		          case 2: push(target, value);      // filter
		        } else switch (TYPE) {
		          case 4: return false;             // every
		          case 7: push(target, value);      // filterReject
		        }
		      }
		    }
		    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
		  };
		};

		arrayIteration = {
		  // `Array.prototype.forEach` method
		  // https://tc39.es/ecma262/#sec-array.prototype.foreach
		  forEach: createMethod(0),
		  // `Array.prototype.map` method
		  // https://tc39.es/ecma262/#sec-array.prototype.map
		  map: createMethod(1),
		  // `Array.prototype.filter` method
		  // https://tc39.es/ecma262/#sec-array.prototype.filter
		  filter: createMethod(2),
		  // `Array.prototype.some` method
		  // https://tc39.es/ecma262/#sec-array.prototype.some
		  some: createMethod(3),
		  // `Array.prototype.every` method
		  // https://tc39.es/ecma262/#sec-array.prototype.every
		  every: createMethod(4),
		  // `Array.prototype.find` method
		  // https://tc39.es/ecma262/#sec-array.prototype.find
		  find: createMethod(5),
		  // `Array.prototype.findIndex` method
		  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
		  findIndex: createMethod(6),
		  // `Array.prototype.filterReject` method
		  // https://github.com/tc39/proposal-array-filtering
		  filterReject: createMethod(7)
		};
		return arrayIteration;
	}

	var hasRequiredEs_symbol_constructor;

	function requireEs_symbol_constructor () {
		if (hasRequiredEs_symbol_constructor) return es_symbol_constructor;
		hasRequiredEs_symbol_constructor = 1;
		var $ = /*@__PURE__*/ require_export();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var call = /*@__PURE__*/ requireFunctionCall();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var NATIVE_SYMBOL = /*@__PURE__*/ requireSymbolConstructorDetection();
		var fails = /*@__PURE__*/ requireFails();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var anObject = /*@__PURE__*/ requireAnObject();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var toPropertyKey = /*@__PURE__*/ requireToPropertyKey();
		var $toString = /*@__PURE__*/ requireToString();
		var createPropertyDescriptor = /*@__PURE__*/ requireCreatePropertyDescriptor();
		var nativeObjectCreate = /*@__PURE__*/ requireObjectCreate();
		var objectKeys = /*@__PURE__*/ requireObjectKeys();
		var getOwnPropertyNamesModule = /*@__PURE__*/ requireObjectGetOwnPropertyNames();
		var getOwnPropertyNamesExternal = /*@__PURE__*/ requireObjectGetOwnPropertyNamesExternal();
		var getOwnPropertySymbolsModule = /*@__PURE__*/ requireObjectGetOwnPropertySymbols();
		var getOwnPropertyDescriptorModule = /*@__PURE__*/ requireObjectGetOwnPropertyDescriptor();
		var definePropertyModule = /*@__PURE__*/ requireObjectDefineProperty();
		var definePropertiesModule = /*@__PURE__*/ requireObjectDefineProperties();
		var propertyIsEnumerableModule = /*@__PURE__*/ requireObjectPropertyIsEnumerable();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();
		var defineBuiltInAccessor = /*@__PURE__*/ requireDefineBuiltInAccessor();
		var shared = /*@__PURE__*/ requireShared();
		var sharedKey = /*@__PURE__*/ requireSharedKey();
		var hiddenKeys = /*@__PURE__*/ requireHiddenKeys();
		var uid = /*@__PURE__*/ requireUid();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var wrappedWellKnownSymbolModule = /*@__PURE__*/ requireWellKnownSymbolWrapped();
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();
		var defineSymbolToPrimitive = /*@__PURE__*/ requireSymbolDefineToPrimitive();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();
		var InternalStateModule = /*@__PURE__*/ requireInternalState();
		var $forEach = /*@__PURE__*/ requireArrayIteration().forEach;

		var HIDDEN = sharedKey('hidden');
		var SYMBOL = 'Symbol';
		var PROTOTYPE = 'prototype';

		var setInternalState = InternalStateModule.set;
		var getInternalState = InternalStateModule.getterFor(SYMBOL);

		var ObjectPrototype = Object[PROTOTYPE];
		var $Symbol = globalThis.Symbol;
		var SymbolPrototype = $Symbol && $Symbol[PROTOTYPE];
		var RangeError = globalThis.RangeError;
		var TypeError = globalThis.TypeError;
		var QObject = globalThis.QObject;
		var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
		var nativeDefineProperty = definePropertyModule.f;
		var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
		var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
		var push = uncurryThis([].push);

		var AllSymbols = shared('symbols');
		var ObjectPrototypeSymbols = shared('op-symbols');
		var WellKnownSymbolsStore = shared('wks');

		// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
		var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

		// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
		var fallbackDefineProperty = function (O, P, Attributes) {
		  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor(ObjectPrototype, P);
		  if (ObjectPrototypeDescriptor) delete ObjectPrototype[P];
		  nativeDefineProperty(O, P, Attributes);
		  if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
		    nativeDefineProperty(ObjectPrototype, P, ObjectPrototypeDescriptor);
		  }
		};

		var setSymbolDescriptor = DESCRIPTORS && fails(function () {
		  return nativeObjectCreate(nativeDefineProperty({}, 'a', {
		    get: function () { return nativeDefineProperty(this, 'a', { value: 7 }).a; }
		  })).a !== 7;
		}) ? fallbackDefineProperty : nativeDefineProperty;

		var wrap = function (tag, description) {
		  var symbol = AllSymbols[tag] = nativeObjectCreate(SymbolPrototype);
		  setInternalState(symbol, {
		    type: SYMBOL,
		    tag: tag,
		    description: description
		  });
		  if (!DESCRIPTORS) symbol.description = description;
		  return symbol;
		};

		var $defineProperty = function defineProperty(O, P, Attributes) {
		  if (O === ObjectPrototype) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
		  anObject(O);
		  var key = toPropertyKey(P);
		  anObject(Attributes);
		  if (hasOwn(AllSymbols, key)) {
		    if (!Attributes.enumerable) {
		      if (!hasOwn(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor(1, nativeObjectCreate(null)));
		      O[HIDDEN][key] = true;
		    } else {
		      if (hasOwn(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
		      Attributes = nativeObjectCreate(Attributes, { enumerable: createPropertyDescriptor(0, false) });
		    } return setSymbolDescriptor(O, key, Attributes);
		  } return nativeDefineProperty(O, key, Attributes);
		};

		var $defineProperties = function defineProperties(O, Properties) {
		  anObject(O);
		  var properties = toIndexedObject(Properties);
		  var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
		  $forEach(keys, function (key) {
		    if (!DESCRIPTORS || call($propertyIsEnumerable, properties, key)) $defineProperty(O, key, properties[key]);
		  });
		  return O;
		};

		var $create = function create(O, Properties) {
		  return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
		};

		var $propertyIsEnumerable = function propertyIsEnumerable(V) {
		  var P = toPropertyKey(V);
		  var enumerable = call(nativePropertyIsEnumerable, this, P);
		  if (this === ObjectPrototype && hasOwn(AllSymbols, P) && !hasOwn(ObjectPrototypeSymbols, P)) return false;
		  return enumerable || !hasOwn(this, P) || !hasOwn(AllSymbols, P) || hasOwn(this, HIDDEN) && this[HIDDEN][P]
		    ? enumerable : true;
		};

		var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
		  var it = toIndexedObject(O);
		  var key = toPropertyKey(P);
		  if (it === ObjectPrototype && hasOwn(AllSymbols, key) && !hasOwn(ObjectPrototypeSymbols, key)) return;
		  var descriptor = nativeGetOwnPropertyDescriptor(it, key);
		  if (descriptor && hasOwn(AllSymbols, key) && !(hasOwn(it, HIDDEN) && it[HIDDEN][key])) {
		    descriptor.enumerable = true;
		  }
		  return descriptor;
		};

		var $getOwnPropertyNames = function getOwnPropertyNames(O) {
		  var names = nativeGetOwnPropertyNames(toIndexedObject(O));
		  var result = [];
		  $forEach(names, function (key) {
		    if (!hasOwn(AllSymbols, key) && !hasOwn(hiddenKeys, key)) push(result, key);
		  });
		  return result;
		};

		var $getOwnPropertySymbols = function (O) {
		  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
		  var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
		  var result = [];
		  $forEach(names, function (key) {
		    if (hasOwn(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn(ObjectPrototype, key))) {
		      push(result, AllSymbols[key]);
		    }
		  });
		  return result;
		};

		// `Symbol` constructor
		// https://tc39.es/ecma262/#sec-symbol-constructor
		if (!NATIVE_SYMBOL) {
		  $Symbol = function Symbol() {
		    if (isPrototypeOf(SymbolPrototype, this)) throw new TypeError('Symbol is not a constructor');
		    var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
		    var tag = uid(description);
		    var setter = function (value) {
		      var $this = this === undefined ? globalThis : this;
		      if ($this === ObjectPrototype) call(setter, ObjectPrototypeSymbols, value);
		      if (hasOwn($this, HIDDEN) && hasOwn($this[HIDDEN], tag)) $this[HIDDEN][tag] = false;
		      var descriptor = createPropertyDescriptor(1, value);
		      try {
		        setSymbolDescriptor($this, tag, descriptor);
		      } catch (error) {
		        if (!(error instanceof RangeError)) throw error;
		        fallbackDefineProperty($this, tag, descriptor);
		      }
		    };
		    if (DESCRIPTORS && USE_SETTER) setSymbolDescriptor(ObjectPrototype, tag, { configurable: true, set: setter });
		    return wrap(tag, description);
		  };

		  SymbolPrototype = $Symbol[PROTOTYPE];

		  defineBuiltIn(SymbolPrototype, 'toString', function toString() {
		    return getInternalState(this).tag;
		  });

		  defineBuiltIn($Symbol, 'withoutSetter', function (description) {
		    return wrap(uid(description), description);
		  });

		  propertyIsEnumerableModule.f = $propertyIsEnumerable;
		  definePropertyModule.f = $defineProperty;
		  definePropertiesModule.f = $defineProperties;
		  getOwnPropertyDescriptorModule.f = $getOwnPropertyDescriptor;
		  getOwnPropertyNamesModule.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
		  getOwnPropertySymbolsModule.f = $getOwnPropertySymbols;

		  wrappedWellKnownSymbolModule.f = function (name) {
		    return wrap(wellKnownSymbol(name), name);
		  };

		  if (DESCRIPTORS) {
		    // https://github.com/tc39/proposal-Symbol-description
		    defineBuiltInAccessor(SymbolPrototype, 'description', {
		      configurable: true,
		      get: function description() {
		        return getInternalState(this).description;
		      }
		    });
		    if (!IS_PURE) {
		      defineBuiltIn(ObjectPrototype, 'propertyIsEnumerable', $propertyIsEnumerable, { unsafe: true });
		    }
		  }
		}

		$({ global: true, constructor: true, wrap: true, forced: !NATIVE_SYMBOL, sham: !NATIVE_SYMBOL }, {
		  Symbol: $Symbol
		});

		$forEach(objectKeys(WellKnownSymbolsStore), function (name) {
		  defineWellKnownSymbol(name);
		});

		$({ target: SYMBOL, stat: true, forced: !NATIVE_SYMBOL }, {
		  useSetter: function () { USE_SETTER = true; },
		  useSimple: function () { USE_SETTER = false; }
		});

		$({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL, sham: !DESCRIPTORS }, {
		  // `Object.create` method
		  // https://tc39.es/ecma262/#sec-object.create
		  create: $create,
		  // `Object.defineProperty` method
		  // https://tc39.es/ecma262/#sec-object.defineproperty
		  defineProperty: $defineProperty,
		  // `Object.defineProperties` method
		  // https://tc39.es/ecma262/#sec-object.defineproperties
		  defineProperties: $defineProperties,
		  // `Object.getOwnPropertyDescriptor` method
		  // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
		  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
		});

		$({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL }, {
		  // `Object.getOwnPropertyNames` method
		  // https://tc39.es/ecma262/#sec-object.getownpropertynames
		  getOwnPropertyNames: $getOwnPropertyNames
		});

		// `Symbol.prototype[@@toPrimitive]` method
		// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
		defineSymbolToPrimitive();

		// `Symbol.prototype[@@toStringTag]` property
		// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
		setToStringTag($Symbol, SYMBOL);

		hiddenKeys[HIDDEN] = true;
		return es_symbol_constructor;
	}

	var es_symbol_for = {};

	var symbolRegistryDetection;
	var hasRequiredSymbolRegistryDetection;

	function requireSymbolRegistryDetection () {
		if (hasRequiredSymbolRegistryDetection) return symbolRegistryDetection;
		hasRequiredSymbolRegistryDetection = 1;
		var NATIVE_SYMBOL = /*@__PURE__*/ requireSymbolConstructorDetection();

		/* eslint-disable es/no-symbol -- safe */
		symbolRegistryDetection = NATIVE_SYMBOL && !!Symbol['for'] && !!Symbol.keyFor;
		return symbolRegistryDetection;
	}

	var hasRequiredEs_symbol_for;

	function requireEs_symbol_for () {
		if (hasRequiredEs_symbol_for) return es_symbol_for;
		hasRequiredEs_symbol_for = 1;
		var $ = /*@__PURE__*/ require_export();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var toString = /*@__PURE__*/ requireToString();
		var shared = /*@__PURE__*/ requireShared();
		var NATIVE_SYMBOL_REGISTRY = /*@__PURE__*/ requireSymbolRegistryDetection();

		var StringToSymbolRegistry = shared('string-to-symbol-registry');
		var SymbolToStringRegistry = shared('symbol-to-string-registry');

		// `Symbol.for` method
		// https://tc39.es/ecma262/#sec-symbol.for
		$({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY }, {
		  'for': function (key) {
		    var string = toString(key);
		    if (hasOwn(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
		    var symbol = getBuiltIn('Symbol')(string);
		    StringToSymbolRegistry[string] = symbol;
		    SymbolToStringRegistry[symbol] = string;
		    return symbol;
		  }
		});
		return es_symbol_for;
	}

	var es_symbol_keyFor = {};

	var hasRequiredEs_symbol_keyFor;

	function requireEs_symbol_keyFor () {
		if (hasRequiredEs_symbol_keyFor) return es_symbol_keyFor;
		hasRequiredEs_symbol_keyFor = 1;
		var $ = /*@__PURE__*/ require_export();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var isSymbol = /*@__PURE__*/ requireIsSymbol();
		var tryToString = /*@__PURE__*/ requireTryToString();
		var shared = /*@__PURE__*/ requireShared();
		var NATIVE_SYMBOL_REGISTRY = /*@__PURE__*/ requireSymbolRegistryDetection();

		var SymbolToStringRegistry = shared('symbol-to-string-registry');

		// `Symbol.keyFor` method
		// https://tc39.es/ecma262/#sec-symbol.keyfor
		$({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY }, {
		  keyFor: function keyFor(sym) {
		    if (!isSymbol(sym)) throw new TypeError(tryToString(sym) + ' is not a symbol');
		    if (hasOwn(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
		  }
		});
		return es_symbol_keyFor;
	}

	var es_json_stringify = {};

	var getJsonReplacerFunction;
	var hasRequiredGetJsonReplacerFunction;

	function requireGetJsonReplacerFunction () {
		if (hasRequiredGetJsonReplacerFunction) return getJsonReplacerFunction;
		hasRequiredGetJsonReplacerFunction = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var isArray = /*@__PURE__*/ requireIsArray$7();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var classof = /*@__PURE__*/ requireClassofRaw();
		var toString = /*@__PURE__*/ requireToString();

		var push = uncurryThis([].push);

		getJsonReplacerFunction = function (replacer) {
		  if (isCallable(replacer)) return replacer;
		  if (!isArray(replacer)) return;
		  var rawLength = replacer.length;
		  var keys = [];
		  for (var i = 0; i < rawLength; i++) {
		    var element = replacer[i];
		    if (typeof element == 'string') push(keys, element);
		    else if (typeof element == 'number' || classof(element) === 'Number' || classof(element) === 'String') push(keys, toString(element));
		  }
		  var keysLength = keys.length;
		  var root = true;
		  return function (key, value) {
		    if (root) {
		      root = false;
		      return value;
		    }
		    if (isArray(this)) return value;
		    for (var j = 0; j < keysLength; j++) if (keys[j] === key) return value;
		  };
		};
		return getJsonReplacerFunction;
	}

	var hasRequiredEs_json_stringify;

	function requireEs_json_stringify () {
		if (hasRequiredEs_json_stringify) return es_json_stringify;
		hasRequiredEs_json_stringify = 1;
		var $ = /*@__PURE__*/ require_export();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var apply = /*@__PURE__*/ requireFunctionApply();
		var call = /*@__PURE__*/ requireFunctionCall();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var fails = /*@__PURE__*/ requireFails();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var isSymbol = /*@__PURE__*/ requireIsSymbol();
		var arraySlice = /*@__PURE__*/ requireArraySlice();
		var getReplacerFunction = /*@__PURE__*/ requireGetJsonReplacerFunction();
		var NATIVE_SYMBOL = /*@__PURE__*/ requireSymbolConstructorDetection();

		var $String = String;
		var $stringify = getBuiltIn('JSON', 'stringify');
		var exec = uncurryThis(/./.exec);
		var charAt = uncurryThis(''.charAt);
		var charCodeAt = uncurryThis(''.charCodeAt);
		var replace = uncurryThis(''.replace);
		var numberToString = uncurryThis(1.0.toString);

		var tester = /[\uD800-\uDFFF]/g;
		var low = /^[\uD800-\uDBFF]$/;
		var hi = /^[\uDC00-\uDFFF]$/;

		var WRONG_SYMBOLS_CONVERSION = !NATIVE_SYMBOL || fails(function () {
		  var symbol = getBuiltIn('Symbol')('stringify detection');
		  // MS Edge converts symbol values to JSON as {}
		  return $stringify([symbol]) !== '[null]'
		    // WebKit converts symbol values to JSON as null
		    || $stringify({ a: symbol }) !== '{}'
		    // V8 throws on boxed symbols
		    || $stringify(Object(symbol)) !== '{}';
		});

		// https://github.com/tc39/proposal-well-formed-stringify
		var ILL_FORMED_UNICODE = fails(function () {
		  return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"'
		    || $stringify('\uDEAD') !== '"\\udead"';
		});

		var stringifyWithSymbolsFix = function (it, replacer) {
		  var args = arraySlice(arguments);
		  var $replacer = getReplacerFunction(replacer);
		  if (!isCallable($replacer) && (it === undefined || isSymbol(it))) return; // IE8 returns string on undefined
		  args[1] = function (key, value) {
		    // some old implementations (like WebKit) could pass numbers as keys
		    if (isCallable($replacer)) value = call($replacer, this, $String(key), value);
		    if (!isSymbol(value)) return value;
		  };
		  return apply($stringify, null, args);
		};

		var fixIllFormed = function (match, offset, string) {
		  var prev = charAt(string, offset - 1);
		  var next = charAt(string, offset + 1);
		  if ((exec(low, match) && !exec(hi, next)) || (exec(hi, match) && !exec(low, prev))) {
		    return '\\u' + numberToString(charCodeAt(match, 0), 16);
		  } return match;
		};

		if ($stringify) {
		  // `JSON.stringify` method
		  // https://tc39.es/ecma262/#sec-json.stringify
		  $({ target: 'JSON', stat: true, arity: 3, forced: WRONG_SYMBOLS_CONVERSION || ILL_FORMED_UNICODE }, {
		    // eslint-disable-next-line no-unused-vars -- required for `.length`
		    stringify: function stringify(it, replacer, space) {
		      var args = arraySlice(arguments);
		      var result = apply(WRONG_SYMBOLS_CONVERSION ? stringifyWithSymbolsFix : $stringify, null, args);
		      return ILL_FORMED_UNICODE && typeof result == 'string' ? replace(result, tester, fixIllFormed) : result;
		    }
		  });
		}
		return es_json_stringify;
	}

	var es_object_getOwnPropertySymbols = {};

	var hasRequiredEs_object_getOwnPropertySymbols;

	function requireEs_object_getOwnPropertySymbols () {
		if (hasRequiredEs_object_getOwnPropertySymbols) return es_object_getOwnPropertySymbols;
		hasRequiredEs_object_getOwnPropertySymbols = 1;
		var $ = /*@__PURE__*/ require_export();
		var NATIVE_SYMBOL = /*@__PURE__*/ requireSymbolConstructorDetection();
		var fails = /*@__PURE__*/ requireFails();
		var getOwnPropertySymbolsModule = /*@__PURE__*/ requireObjectGetOwnPropertySymbols();
		var toObject = /*@__PURE__*/ requireToObject();

		// V8 ~ Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
		// https://bugs.chromium.org/p/v8/issues/detail?id=3443
		var FORCED = !NATIVE_SYMBOL || fails(function () { getOwnPropertySymbolsModule.f(1); });

		// `Object.getOwnPropertySymbols` method
		// https://tc39.es/ecma262/#sec-object.getownpropertysymbols
		$({ target: 'Object', stat: true, forced: FORCED }, {
		  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
		    var $getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
		    return $getOwnPropertySymbols ? $getOwnPropertySymbols(toObject(it)) : [];
		  }
		});
		return es_object_getOwnPropertySymbols;
	}

	var hasRequiredEs_symbol;

	function requireEs_symbol () {
		if (hasRequiredEs_symbol) return es_symbol;
		hasRequiredEs_symbol = 1;
		// TODO: Remove this module from `core-js@4` since it's split to modules listed below
		requireEs_symbol_constructor();
		requireEs_symbol_for();
		requireEs_symbol_keyFor();
		requireEs_json_stringify();
		requireEs_object_getOwnPropertySymbols();
		return es_symbol;
	}

	var getOwnPropertySymbols$5;
	var hasRequiredGetOwnPropertySymbols$5;

	function requireGetOwnPropertySymbols$5 () {
		if (hasRequiredGetOwnPropertySymbols$5) return getOwnPropertySymbols$5;
		hasRequiredGetOwnPropertySymbols$5 = 1;
		requireEs_symbol();
		var path = /*@__PURE__*/ requirePath$1();

		getOwnPropertySymbols$5 = path.Object.getOwnPropertySymbols;
		return getOwnPropertySymbols$5;
	}

	var getOwnPropertySymbols$4;
	var hasRequiredGetOwnPropertySymbols$4;

	function requireGetOwnPropertySymbols$4 () {
		if (hasRequiredGetOwnPropertySymbols$4) return getOwnPropertySymbols$4;
		hasRequiredGetOwnPropertySymbols$4 = 1;
		var parent = /*@__PURE__*/ requireGetOwnPropertySymbols$5();

		getOwnPropertySymbols$4 = parent;
		return getOwnPropertySymbols$4;
	}

	var getOwnPropertySymbols$3;
	var hasRequiredGetOwnPropertySymbols$3;
	function requireGetOwnPropertySymbols$3() {
	  if (hasRequiredGetOwnPropertySymbols$3) return getOwnPropertySymbols$3;
	  hasRequiredGetOwnPropertySymbols$3 = 1;
	  getOwnPropertySymbols$3 = /*@__PURE__*/requireGetOwnPropertySymbols$4();
	  return getOwnPropertySymbols$3;
	}

	var getOwnPropertySymbolsExports$1 = requireGetOwnPropertySymbols$3();
	var _Object$getOwnPropertySymbols$1 = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertySymbolsExports$1);

	var es_array_filter = {};

	var hasRequiredEs_array_filter;

	function requireEs_array_filter () {
		if (hasRequiredEs_array_filter) return es_array_filter;
		hasRequiredEs_array_filter = 1;
		var $ = /*@__PURE__*/ require_export();
		var $filter = /*@__PURE__*/ requireArrayIteration().filter;
		var arrayMethodHasSpeciesSupport = /*@__PURE__*/ requireArrayMethodHasSpeciesSupport();

		var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');

		// `Array.prototype.filter` method
		// https://tc39.es/ecma262/#sec-array.prototype.filter
		// with adding support of @@species
		$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
		  filter: function filter(callbackfn /* , thisArg */) {
		    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
		  }
		});
		return es_array_filter;
	}

	var filter$3;
	var hasRequiredFilter$3;

	function requireFilter$3 () {
		if (hasRequiredFilter$3) return filter$3;
		hasRequiredFilter$3 = 1;
		requireEs_array_filter();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		filter$3 = getBuiltInPrototypeMethod('Array', 'filter');
		return filter$3;
	}

	var filter$2;
	var hasRequiredFilter$2;

	function requireFilter$2 () {
		if (hasRequiredFilter$2) return filter$2;
		hasRequiredFilter$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireFilter$3();

		var ArrayPrototype = Array.prototype;

		filter$2 = function (it) {
		  var own = it.filter;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.filter) ? method : own;
		};
		return filter$2;
	}

	var filter$1;
	var hasRequiredFilter$1;

	function requireFilter$1 () {
		if (hasRequiredFilter$1) return filter$1;
		hasRequiredFilter$1 = 1;
		var parent = /*@__PURE__*/ requireFilter$2();

		filter$1 = parent;
		return filter$1;
	}

	var filter;
	var hasRequiredFilter;
	function requireFilter() {
	  if (hasRequiredFilter) return filter;
	  hasRequiredFilter = 1;
	  filter = /*@__PURE__*/requireFilter$1();
	  return filter;
	}

	var filterExports = requireFilter();
	var _filterInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(filterExports);

	var getOwnPropertyDescriptor$5 = {exports: {}};

	var es_object_getOwnPropertyDescriptor = {};

	var hasRequiredEs_object_getOwnPropertyDescriptor;

	function requireEs_object_getOwnPropertyDescriptor () {
		if (hasRequiredEs_object_getOwnPropertyDescriptor) return es_object_getOwnPropertyDescriptor;
		hasRequiredEs_object_getOwnPropertyDescriptor = 1;
		var $ = /*@__PURE__*/ require_export();
		var fails = /*@__PURE__*/ requireFails();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var nativeGetOwnPropertyDescriptor = /*@__PURE__*/ requireObjectGetOwnPropertyDescriptor().f;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();

		var FORCED = !DESCRIPTORS || fails(function () { nativeGetOwnPropertyDescriptor(1); });

		// `Object.getOwnPropertyDescriptor` method
		// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
		$({ target: 'Object', stat: true, forced: FORCED, sham: !DESCRIPTORS }, {
		  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
		    return nativeGetOwnPropertyDescriptor(toIndexedObject(it), key);
		  }
		});
		return es_object_getOwnPropertyDescriptor;
	}

	var hasRequiredGetOwnPropertyDescriptor$5;

	function requireGetOwnPropertyDescriptor$5 () {
		if (hasRequiredGetOwnPropertyDescriptor$5) return getOwnPropertyDescriptor$5.exports;
		hasRequiredGetOwnPropertyDescriptor$5 = 1;
		requireEs_object_getOwnPropertyDescriptor();
		var path = /*@__PURE__*/ requirePath$1();

		var Object = path.Object;

		var getOwnPropertyDescriptor = getOwnPropertyDescriptor$5.exports = function getOwnPropertyDescriptor(it, key) {
		  return Object.getOwnPropertyDescriptor(it, key);
		};

		if (Object.getOwnPropertyDescriptor.sham) getOwnPropertyDescriptor.sham = true;
		return getOwnPropertyDescriptor$5.exports;
	}

	var getOwnPropertyDescriptor$4;
	var hasRequiredGetOwnPropertyDescriptor$4;

	function requireGetOwnPropertyDescriptor$4 () {
		if (hasRequiredGetOwnPropertyDescriptor$4) return getOwnPropertyDescriptor$4;
		hasRequiredGetOwnPropertyDescriptor$4 = 1;
		var parent = /*@__PURE__*/ requireGetOwnPropertyDescriptor$5();

		getOwnPropertyDescriptor$4 = parent;
		return getOwnPropertyDescriptor$4;
	}

	var getOwnPropertyDescriptor$3;
	var hasRequiredGetOwnPropertyDescriptor$3;
	function requireGetOwnPropertyDescriptor$3() {
	  if (hasRequiredGetOwnPropertyDescriptor$3) return getOwnPropertyDescriptor$3;
	  hasRequiredGetOwnPropertyDescriptor$3 = 1;
	  getOwnPropertyDescriptor$3 = /*@__PURE__*/requireGetOwnPropertyDescriptor$4();
	  return getOwnPropertyDescriptor$3;
	}

	var getOwnPropertyDescriptorExports$1 = requireGetOwnPropertyDescriptor$3();
	var _Object$getOwnPropertyDescriptor$1 = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptorExports$1);

	var es_array_forEach = {};

	var arrayForEach;
	var hasRequiredArrayForEach;

	function requireArrayForEach () {
		if (hasRequiredArrayForEach) return arrayForEach;
		hasRequiredArrayForEach = 1;
		var $forEach = /*@__PURE__*/ requireArrayIteration().forEach;
		var arrayMethodIsStrict = /*@__PURE__*/ requireArrayMethodIsStrict();

		var STRICT_METHOD = arrayMethodIsStrict('forEach');

		// `Array.prototype.forEach` method implementation
		// https://tc39.es/ecma262/#sec-array.prototype.foreach
		arrayForEach = !STRICT_METHOD ? function forEach(callbackfn /* , thisArg */) {
		  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
		// eslint-disable-next-line es/no-array-prototype-foreach -- safe
		} : [].forEach;
		return arrayForEach;
	}

	var hasRequiredEs_array_forEach;

	function requireEs_array_forEach () {
		if (hasRequiredEs_array_forEach) return es_array_forEach;
		hasRequiredEs_array_forEach = 1;
		var $ = /*@__PURE__*/ require_export();
		var forEach = /*@__PURE__*/ requireArrayForEach();

		// `Array.prototype.forEach` method
		// https://tc39.es/ecma262/#sec-array.prototype.foreach
		// eslint-disable-next-line es/no-array-prototype-foreach -- safe
		$({ target: 'Array', proto: true, forced: [].forEach !== forEach }, {
		  forEach: forEach
		});
		return es_array_forEach;
	}

	var forEach$6;
	var hasRequiredForEach$6;

	function requireForEach$6 () {
		if (hasRequiredForEach$6) return forEach$6;
		hasRequiredForEach$6 = 1;
		requireEs_array_forEach();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		forEach$6 = getBuiltInPrototypeMethod('Array', 'forEach');
		return forEach$6;
	}

	var forEach$5;
	var hasRequiredForEach$5;

	function requireForEach$5 () {
		if (hasRequiredForEach$5) return forEach$5;
		hasRequiredForEach$5 = 1;
		var parent = /*@__PURE__*/ requireForEach$6();

		forEach$5 = parent;
		return forEach$5;
	}

	var forEach$4;
	var hasRequiredForEach$4;

	function requireForEach$4 () {
		if (hasRequiredForEach$4) return forEach$4;
		hasRequiredForEach$4 = 1;
		var classof = /*@__PURE__*/ requireClassof();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireForEach$5();

		var ArrayPrototype = Array.prototype;

		var DOMIterables = {
		  DOMTokenList: true,
		  NodeList: true
		};

		forEach$4 = function (it) {
		  var own = it.forEach;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.forEach)
		    || hasOwn(DOMIterables, classof(it)) ? method : own;
		};
		return forEach$4;
	}

	var forEach$3;
	var hasRequiredForEach$3;
	function requireForEach$3() {
	  if (hasRequiredForEach$3) return forEach$3;
	  hasRequiredForEach$3 = 1;
	  forEach$3 = /*@__PURE__*/requireForEach$4();
	  return forEach$3;
	}

	var forEachExports = requireForEach$3();
	var _forEachInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(forEachExports);

	var es_object_getOwnPropertyDescriptors = {};

	var ownKeys$H;
	var hasRequiredOwnKeys;

	function requireOwnKeys () {
		if (hasRequiredOwnKeys) return ownKeys$H;
		hasRequiredOwnKeys = 1;
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var getOwnPropertyNamesModule = /*@__PURE__*/ requireObjectGetOwnPropertyNames();
		var getOwnPropertySymbolsModule = /*@__PURE__*/ requireObjectGetOwnPropertySymbols();
		var anObject = /*@__PURE__*/ requireAnObject();

		var concat = uncurryThis([].concat);

		// all object keys, includes non-enumerable and symbols
		ownKeys$H = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
		  var keys = getOwnPropertyNamesModule.f(anObject(it));
		  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
		  return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
		};
		return ownKeys$H;
	}

	var hasRequiredEs_object_getOwnPropertyDescriptors;

	function requireEs_object_getOwnPropertyDescriptors () {
		if (hasRequiredEs_object_getOwnPropertyDescriptors) return es_object_getOwnPropertyDescriptors;
		hasRequiredEs_object_getOwnPropertyDescriptors = 1;
		var $ = /*@__PURE__*/ require_export();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var ownKeys = /*@__PURE__*/ requireOwnKeys();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var getOwnPropertyDescriptorModule = /*@__PURE__*/ requireObjectGetOwnPropertyDescriptor();
		var createProperty = /*@__PURE__*/ requireCreateProperty();

		// `Object.getOwnPropertyDescriptors` method
		// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
		$({ target: 'Object', stat: true, sham: !DESCRIPTORS }, {
		  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
		    var O = toIndexedObject(object);
		    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
		    var keys = ownKeys(O);
		    var result = {};
		    var index = 0;
		    var key, descriptor;
		    while (keys.length > index) {
		      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
		      if (descriptor !== undefined) createProperty(result, key, descriptor);
		    }
		    return result;
		  }
		});
		return es_object_getOwnPropertyDescriptors;
	}

	var getOwnPropertyDescriptors$2;
	var hasRequiredGetOwnPropertyDescriptors$2;

	function requireGetOwnPropertyDescriptors$2 () {
		if (hasRequiredGetOwnPropertyDescriptors$2) return getOwnPropertyDescriptors$2;
		hasRequiredGetOwnPropertyDescriptors$2 = 1;
		requireEs_object_getOwnPropertyDescriptors();
		var path = /*@__PURE__*/ requirePath$1();

		getOwnPropertyDescriptors$2 = path.Object.getOwnPropertyDescriptors;
		return getOwnPropertyDescriptors$2;
	}

	var getOwnPropertyDescriptors$1;
	var hasRequiredGetOwnPropertyDescriptors$1;

	function requireGetOwnPropertyDescriptors$1 () {
		if (hasRequiredGetOwnPropertyDescriptors$1) return getOwnPropertyDescriptors$1;
		hasRequiredGetOwnPropertyDescriptors$1 = 1;
		var parent = /*@__PURE__*/ requireGetOwnPropertyDescriptors$2();

		getOwnPropertyDescriptors$1 = parent;
		return getOwnPropertyDescriptors$1;
	}

	var getOwnPropertyDescriptors;
	var hasRequiredGetOwnPropertyDescriptors;
	function requireGetOwnPropertyDescriptors() {
	  if (hasRequiredGetOwnPropertyDescriptors) return getOwnPropertyDescriptors;
	  hasRequiredGetOwnPropertyDescriptors = 1;
	  getOwnPropertyDescriptors = /*@__PURE__*/requireGetOwnPropertyDescriptors$1();
	  return getOwnPropertyDescriptors;
	}

	var getOwnPropertyDescriptorsExports = requireGetOwnPropertyDescriptors();
	var _Object$getOwnPropertyDescriptors = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptorsExports);

	var defineProperties$2 = {exports: {}};

	var es_object_defineProperties = {};

	var hasRequiredEs_object_defineProperties;

	function requireEs_object_defineProperties () {
		if (hasRequiredEs_object_defineProperties) return es_object_defineProperties;
		hasRequiredEs_object_defineProperties = 1;
		var $ = /*@__PURE__*/ require_export();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var defineProperties = /*@__PURE__*/ requireObjectDefineProperties().f;

		// `Object.defineProperties` method
		// https://tc39.es/ecma262/#sec-object.defineproperties
		// eslint-disable-next-line es/no-object-defineproperties -- safe
		$({ target: 'Object', stat: true, forced: Object.defineProperties !== defineProperties, sham: !DESCRIPTORS }, {
		  defineProperties: defineProperties
		});
		return es_object_defineProperties;
	}

	var hasRequiredDefineProperties$2;

	function requireDefineProperties$2 () {
		if (hasRequiredDefineProperties$2) return defineProperties$2.exports;
		hasRequiredDefineProperties$2 = 1;
		requireEs_object_defineProperties();
		var path = /*@__PURE__*/ requirePath$1();

		var Object = path.Object;

		var defineProperties = defineProperties$2.exports = function defineProperties(T, D) {
		  return Object.defineProperties(T, D);
		};

		if (Object.defineProperties.sham) defineProperties.sham = true;
		return defineProperties$2.exports;
	}

	var defineProperties$1;
	var hasRequiredDefineProperties$1;

	function requireDefineProperties$1 () {
		if (hasRequiredDefineProperties$1) return defineProperties$1;
		hasRequiredDefineProperties$1 = 1;
		var parent = /*@__PURE__*/ requireDefineProperties$2();

		defineProperties$1 = parent;
		return defineProperties$1;
	}

	var defineProperties;
	var hasRequiredDefineProperties;
	function requireDefineProperties() {
	  if (hasRequiredDefineProperties) return defineProperties;
	  hasRequiredDefineProperties = 1;
	  defineProperties = /*@__PURE__*/requireDefineProperties$1();
	  return defineProperties;
	}

	var definePropertiesExports = requireDefineProperties();
	var _Object$defineProperties = /*@__PURE__*/getDefaultExportFromCjs(definePropertiesExports);

	var defineProperty$5 = {exports: {}};

	var es_object_defineProperty = {};

	var hasRequiredEs_object_defineProperty;

	function requireEs_object_defineProperty () {
		if (hasRequiredEs_object_defineProperty) return es_object_defineProperty;
		hasRequiredEs_object_defineProperty = 1;
		var $ = /*@__PURE__*/ require_export();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var defineProperty = /*@__PURE__*/ requireObjectDefineProperty().f;

		// `Object.defineProperty` method
		// https://tc39.es/ecma262/#sec-object.defineproperty
		// eslint-disable-next-line es/no-object-defineproperty -- safe
		$({ target: 'Object', stat: true, forced: Object.defineProperty !== defineProperty, sham: !DESCRIPTORS }, {
		  defineProperty: defineProperty
		});
		return es_object_defineProperty;
	}

	var hasRequiredDefineProperty$5;

	function requireDefineProperty$5 () {
		if (hasRequiredDefineProperty$5) return defineProperty$5.exports;
		hasRequiredDefineProperty$5 = 1;
		requireEs_object_defineProperty();
		var path = /*@__PURE__*/ requirePath$1();

		var Object = path.Object;

		var defineProperty = defineProperty$5.exports = function defineProperty(it, key, desc) {
		  return Object.defineProperty(it, key, desc);
		};

		if (Object.defineProperty.sham) defineProperty.sham = true;
		return defineProperty$5.exports;
	}

	var defineProperty$4;
	var hasRequiredDefineProperty$4;

	function requireDefineProperty$4 () {
		if (hasRequiredDefineProperty$4) return defineProperty$4;
		hasRequiredDefineProperty$4 = 1;
		var parent = /*@__PURE__*/ requireDefineProperty$5();

		defineProperty$4 = parent;
		return defineProperty$4;
	}

	var defineProperty$3;
	var hasRequiredDefineProperty$3;
	function requireDefineProperty$3() {
	  if (hasRequiredDefineProperty$3) return defineProperty$3;
	  hasRequiredDefineProperty$3 = 1;
	  defineProperty$3 = /*@__PURE__*/requireDefineProperty$4();
	  return defineProperty$3;
	}

	var definePropertyExports$1 = requireDefineProperty$3();
	var _Object$defineProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(definePropertyExports$1);

	var defineProperty$2;
	var hasRequiredDefineProperty$2;

	function requireDefineProperty$2 () {
		if (hasRequiredDefineProperty$2) return defineProperty$2;
		hasRequiredDefineProperty$2 = 1;
		var parent = /*@__PURE__*/ requireDefineProperty$4();

		defineProperty$2 = parent;
		return defineProperty$2;
	}

	var defineProperty$1;
	var hasRequiredDefineProperty$1;

	function requireDefineProperty$1 () {
		if (hasRequiredDefineProperty$1) return defineProperty$1;
		hasRequiredDefineProperty$1 = 1;
		var parent = /*@__PURE__*/ requireDefineProperty$2();

		defineProperty$1 = parent;
		return defineProperty$1;
	}

	var defineProperty;
	var hasRequiredDefineProperty;

	function requireDefineProperty () {
		if (hasRequiredDefineProperty) return defineProperty;
		hasRequiredDefineProperty = 1;
		defineProperty = /*@__PURE__*/ requireDefineProperty$1();
		return defineProperty;
	}

	var definePropertyExports = /*@__PURE__*/ requireDefineProperty();
	var _Object$defineProperty = /*@__PURE__*/getDefaultExportFromCjs(definePropertyExports);

	var es_symbol_asyncIterator = {};

	var hasRequiredEs_symbol_asyncIterator;

	function requireEs_symbol_asyncIterator () {
		if (hasRequiredEs_symbol_asyncIterator) return es_symbol_asyncIterator;
		hasRequiredEs_symbol_asyncIterator = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.asyncIterator` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.asynciterator
		defineWellKnownSymbol('asyncIterator');
		return es_symbol_asyncIterator;
	}

	var es_symbol_hasInstance = {};

	var hasRequiredEs_symbol_hasInstance;

	function requireEs_symbol_hasInstance () {
		if (hasRequiredEs_symbol_hasInstance) return es_symbol_hasInstance;
		hasRequiredEs_symbol_hasInstance = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.hasInstance` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.hasinstance
		defineWellKnownSymbol('hasInstance');
		return es_symbol_hasInstance;
	}

	var es_symbol_isConcatSpreadable = {};

	var hasRequiredEs_symbol_isConcatSpreadable;

	function requireEs_symbol_isConcatSpreadable () {
		if (hasRequiredEs_symbol_isConcatSpreadable) return es_symbol_isConcatSpreadable;
		hasRequiredEs_symbol_isConcatSpreadable = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.isConcatSpreadable` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.isconcatspreadable
		defineWellKnownSymbol('isConcatSpreadable');
		return es_symbol_isConcatSpreadable;
	}

	var es_symbol_iterator = {};

	var hasRequiredEs_symbol_iterator;

	function requireEs_symbol_iterator () {
		if (hasRequiredEs_symbol_iterator) return es_symbol_iterator;
		hasRequiredEs_symbol_iterator = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.iterator` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.iterator
		defineWellKnownSymbol('iterator');
		return es_symbol_iterator;
	}

	var es_symbol_match = {};

	var hasRequiredEs_symbol_match;

	function requireEs_symbol_match () {
		if (hasRequiredEs_symbol_match) return es_symbol_match;
		hasRequiredEs_symbol_match = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.match` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.match
		defineWellKnownSymbol('match');
		return es_symbol_match;
	}

	var es_symbol_matchAll = {};

	var hasRequiredEs_symbol_matchAll;

	function requireEs_symbol_matchAll () {
		if (hasRequiredEs_symbol_matchAll) return es_symbol_matchAll;
		hasRequiredEs_symbol_matchAll = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.matchAll` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.matchall
		defineWellKnownSymbol('matchAll');
		return es_symbol_matchAll;
	}

	var es_symbol_replace = {};

	var hasRequiredEs_symbol_replace;

	function requireEs_symbol_replace () {
		if (hasRequiredEs_symbol_replace) return es_symbol_replace;
		hasRequiredEs_symbol_replace = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.replace` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.replace
		defineWellKnownSymbol('replace');
		return es_symbol_replace;
	}

	var es_symbol_search = {};

	var hasRequiredEs_symbol_search;

	function requireEs_symbol_search () {
		if (hasRequiredEs_symbol_search) return es_symbol_search;
		hasRequiredEs_symbol_search = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.search` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.search
		defineWellKnownSymbol('search');
		return es_symbol_search;
	}

	var es_symbol_species = {};

	var hasRequiredEs_symbol_species;

	function requireEs_symbol_species () {
		if (hasRequiredEs_symbol_species) return es_symbol_species;
		hasRequiredEs_symbol_species = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.species` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.species
		defineWellKnownSymbol('species');
		return es_symbol_species;
	}

	var es_symbol_split = {};

	var hasRequiredEs_symbol_split;

	function requireEs_symbol_split () {
		if (hasRequiredEs_symbol_split) return es_symbol_split;
		hasRequiredEs_symbol_split = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.split` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.split
		defineWellKnownSymbol('split');
		return es_symbol_split;
	}

	var es_symbol_toPrimitive = {};

	var hasRequiredEs_symbol_toPrimitive;

	function requireEs_symbol_toPrimitive () {
		if (hasRequiredEs_symbol_toPrimitive) return es_symbol_toPrimitive;
		hasRequiredEs_symbol_toPrimitive = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();
		var defineSymbolToPrimitive = /*@__PURE__*/ requireSymbolDefineToPrimitive();

		// `Symbol.toPrimitive` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.toprimitive
		defineWellKnownSymbol('toPrimitive');

		// `Symbol.prototype[@@toPrimitive]` method
		// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
		defineSymbolToPrimitive();
		return es_symbol_toPrimitive;
	}

	var es_symbol_toStringTag = {};

	var hasRequiredEs_symbol_toStringTag;

	function requireEs_symbol_toStringTag () {
		if (hasRequiredEs_symbol_toStringTag) return es_symbol_toStringTag;
		hasRequiredEs_symbol_toStringTag = 1;
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();

		// `Symbol.toStringTag` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.tostringtag
		defineWellKnownSymbol('toStringTag');

		// `Symbol.prototype[@@toStringTag]` property
		// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
		setToStringTag(getBuiltIn('Symbol'), 'Symbol');
		return es_symbol_toStringTag;
	}

	var es_symbol_unscopables = {};

	var hasRequiredEs_symbol_unscopables;

	function requireEs_symbol_unscopables () {
		if (hasRequiredEs_symbol_unscopables) return es_symbol_unscopables;
		hasRequiredEs_symbol_unscopables = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.unscopables` well-known symbol
		// https://tc39.es/ecma262/#sec-symbol.unscopables
		defineWellKnownSymbol('unscopables');
		return es_symbol_unscopables;
	}

	var es_json_toStringTag = {};

	var hasRequiredEs_json_toStringTag;

	function requireEs_json_toStringTag () {
		if (hasRequiredEs_json_toStringTag) return es_json_toStringTag;
		hasRequiredEs_json_toStringTag = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();

		// JSON[@@toStringTag] property
		// https://tc39.es/ecma262/#sec-json-@@tostringtag
		setToStringTag(globalThis.JSON, 'JSON', true);
		return es_json_toStringTag;
	}

	var symbol$5;
	var hasRequiredSymbol$5;

	function requireSymbol$5 () {
		if (hasRequiredSymbol$5) return symbol$5;
		hasRequiredSymbol$5 = 1;
		requireEs_array_concat();
		requireEs_symbol();
		requireEs_symbol_asyncIterator();
		requireEs_symbol_hasInstance();
		requireEs_symbol_isConcatSpreadable();
		requireEs_symbol_iterator();
		requireEs_symbol_match();
		requireEs_symbol_matchAll();
		requireEs_symbol_replace();
		requireEs_symbol_search();
		requireEs_symbol_species();
		requireEs_symbol_split();
		requireEs_symbol_toPrimitive();
		requireEs_symbol_toStringTag();
		requireEs_symbol_unscopables();
		requireEs_json_toStringTag();
		var path = /*@__PURE__*/ requirePath$1();

		symbol$5 = path.Symbol;
		return symbol$5;
	}

	var web_domCollections_iterator = {};

	var domIterables;
	var hasRequiredDomIterables;

	function requireDomIterables () {
		if (hasRequiredDomIterables) return domIterables;
		hasRequiredDomIterables = 1;
		// iterable DOM collections
		// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
		domIterables = {
		  CSSRuleList: 0,
		  CSSStyleDeclaration: 0,
		  CSSValueList: 0,
		  ClientRectList: 0,
		  DOMRectList: 0,
		  DOMStringList: 0,
		  DOMTokenList: 1,
		  DataTransferItemList: 0,
		  FileList: 0,
		  HTMLAllCollection: 0,
		  HTMLCollection: 0,
		  HTMLFormElement: 0,
		  HTMLSelectElement: 0,
		  MediaList: 0,
		  MimeTypeArray: 0,
		  NamedNodeMap: 0,
		  NodeList: 1,
		  PaintRequestList: 0,
		  Plugin: 0,
		  PluginArray: 0,
		  SVGLengthList: 0,
		  SVGNumberList: 0,
		  SVGPathSegList: 0,
		  SVGPointList: 0,
		  SVGStringList: 0,
		  SVGTransformList: 0,
		  SourceBufferList: 0,
		  StyleSheetList: 0,
		  TextTrackCueList: 0,
		  TextTrackList: 0,
		  TouchList: 0
		};
		return domIterables;
	}

	var hasRequiredWeb_domCollections_iterator;

	function requireWeb_domCollections_iterator () {
		if (hasRequiredWeb_domCollections_iterator) return web_domCollections_iterator;
		hasRequiredWeb_domCollections_iterator = 1;
		requireEs_array_iterator();
		var DOMIterables = /*@__PURE__*/ requireDomIterables();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();
		var Iterators = /*@__PURE__*/ requireIterators();

		for (var COLLECTION_NAME in DOMIterables) {
		  setToStringTag(globalThis[COLLECTION_NAME], COLLECTION_NAME);
		  Iterators[COLLECTION_NAME] = Iterators.Array;
		}
		return web_domCollections_iterator;
	}

	var symbol$4;
	var hasRequiredSymbol$4;

	function requireSymbol$4 () {
		if (hasRequiredSymbol$4) return symbol$4;
		hasRequiredSymbol$4 = 1;
		var parent = /*@__PURE__*/ requireSymbol$5();
		requireWeb_domCollections_iterator();

		symbol$4 = parent;
		return symbol$4;
	}

	var esnext_function_metadata = {};

	var hasRequiredEsnext_function_metadata;

	function requireEsnext_function_metadata () {
		if (hasRequiredEsnext_function_metadata) return esnext_function_metadata;
		hasRequiredEsnext_function_metadata = 1;
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var defineProperty = /*@__PURE__*/ requireObjectDefineProperty().f;

		var METADATA = wellKnownSymbol('metadata');
		var FunctionPrototype = Function.prototype;

		// Function.prototype[@@metadata]
		// https://github.com/tc39/proposal-decorator-metadata
		if (FunctionPrototype[METADATA] === undefined) {
		  defineProperty(FunctionPrototype, METADATA, {
		    value: null
		  });
		}
		return esnext_function_metadata;
	}

	var esnext_symbol_asyncDispose = {};

	var hasRequiredEsnext_symbol_asyncDispose;

	function requireEsnext_symbol_asyncDispose () {
		if (hasRequiredEsnext_symbol_asyncDispose) return esnext_symbol_asyncDispose;
		hasRequiredEsnext_symbol_asyncDispose = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.asyncDispose` well-known symbol
		// https://github.com/tc39/proposal-async-explicit-resource-management
		defineWellKnownSymbol('asyncDispose');
		return esnext_symbol_asyncDispose;
	}

	var esnext_symbol_dispose = {};

	var hasRequiredEsnext_symbol_dispose;

	function requireEsnext_symbol_dispose () {
		if (hasRequiredEsnext_symbol_dispose) return esnext_symbol_dispose;
		hasRequiredEsnext_symbol_dispose = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.dispose` well-known symbol
		// https://github.com/tc39/proposal-explicit-resource-management
		defineWellKnownSymbol('dispose');
		return esnext_symbol_dispose;
	}

	var esnext_symbol_metadata = {};

	var hasRequiredEsnext_symbol_metadata;

	function requireEsnext_symbol_metadata () {
		if (hasRequiredEsnext_symbol_metadata) return esnext_symbol_metadata;
		hasRequiredEsnext_symbol_metadata = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.metadata` well-known symbol
		// https://github.com/tc39/proposal-decorators
		defineWellKnownSymbol('metadata');
		return esnext_symbol_metadata;
	}

	var symbol$3;
	var hasRequiredSymbol$3;

	function requireSymbol$3 () {
		if (hasRequiredSymbol$3) return symbol$3;
		hasRequiredSymbol$3 = 1;
		var parent = /*@__PURE__*/ requireSymbol$4();

		requireEsnext_function_metadata();
		requireEsnext_symbol_asyncDispose();
		requireEsnext_symbol_dispose();
		requireEsnext_symbol_metadata();

		symbol$3 = parent;
		return symbol$3;
	}

	var esnext_symbol_isRegisteredSymbol = {};

	var symbolIsRegistered;
	var hasRequiredSymbolIsRegistered;

	function requireSymbolIsRegistered () {
		if (hasRequiredSymbolIsRegistered) return symbolIsRegistered;
		hasRequiredSymbolIsRegistered = 1;
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		var Symbol = getBuiltIn('Symbol');
		var keyFor = Symbol.keyFor;
		var thisSymbolValue = uncurryThis(Symbol.prototype.valueOf);

		// `Symbol.isRegisteredSymbol` method
		// https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
		symbolIsRegistered = Symbol.isRegisteredSymbol || function isRegisteredSymbol(value) {
		  try {
		    return keyFor(thisSymbolValue(value)) !== undefined;
		  } catch (error) {
		    return false;
		  }
		};
		return symbolIsRegistered;
	}

	var hasRequiredEsnext_symbol_isRegisteredSymbol;

	function requireEsnext_symbol_isRegisteredSymbol () {
		if (hasRequiredEsnext_symbol_isRegisteredSymbol) return esnext_symbol_isRegisteredSymbol;
		hasRequiredEsnext_symbol_isRegisteredSymbol = 1;
		var $ = /*@__PURE__*/ require_export();
		var isRegisteredSymbol = /*@__PURE__*/ requireSymbolIsRegistered();

		// `Symbol.isRegisteredSymbol` method
		// https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
		$({ target: 'Symbol', stat: true }, {
		  isRegisteredSymbol: isRegisteredSymbol
		});
		return esnext_symbol_isRegisteredSymbol;
	}

	var esnext_symbol_isWellKnownSymbol = {};

	var symbolIsWellKnown;
	var hasRequiredSymbolIsWellKnown;

	function requireSymbolIsWellKnown () {
		if (hasRequiredSymbolIsWellKnown) return symbolIsWellKnown;
		hasRequiredSymbolIsWellKnown = 1;
		var shared = /*@__PURE__*/ requireShared();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var isSymbol = /*@__PURE__*/ requireIsSymbol();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var Symbol = getBuiltIn('Symbol');
		var $isWellKnownSymbol = Symbol.isWellKnownSymbol;
		var getOwnPropertyNames = getBuiltIn('Object', 'getOwnPropertyNames');
		var thisSymbolValue = uncurryThis(Symbol.prototype.valueOf);
		var WellKnownSymbolsStore = shared('wks');

		for (var i = 0, symbolKeys = getOwnPropertyNames(Symbol), symbolKeysLength = symbolKeys.length; i < symbolKeysLength; i++) {
		  // some old engines throws on access to some keys like `arguments` or `caller`
		  try {
		    var symbolKey = symbolKeys[i];
		    if (isSymbol(Symbol[symbolKey])) wellKnownSymbol(symbolKey);
		  } catch (error) { /* empty */ }
		}

		// `Symbol.isWellKnownSymbol` method
		// https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
		// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
		symbolIsWellKnown = function isWellKnownSymbol(value) {
		  if ($isWellKnownSymbol && $isWellKnownSymbol(value)) return true;
		  try {
		    var symbol = thisSymbolValue(value);
		    for (var j = 0, keys = getOwnPropertyNames(WellKnownSymbolsStore), keysLength = keys.length; j < keysLength; j++) {
		      // eslint-disable-next-line eqeqeq -- polyfilled symbols case
		      if (WellKnownSymbolsStore[keys[j]] == symbol) return true;
		    }
		  } catch (error) { /* empty */ }
		  return false;
		};
		return symbolIsWellKnown;
	}

	var hasRequiredEsnext_symbol_isWellKnownSymbol;

	function requireEsnext_symbol_isWellKnownSymbol () {
		if (hasRequiredEsnext_symbol_isWellKnownSymbol) return esnext_symbol_isWellKnownSymbol;
		hasRequiredEsnext_symbol_isWellKnownSymbol = 1;
		var $ = /*@__PURE__*/ require_export();
		var isWellKnownSymbol = /*@__PURE__*/ requireSymbolIsWellKnown();

		// `Symbol.isWellKnownSymbol` method
		// https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
		// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
		$({ target: 'Symbol', stat: true, forced: true }, {
		  isWellKnownSymbol: isWellKnownSymbol
		});
		return esnext_symbol_isWellKnownSymbol;
	}

	var esnext_symbol_customMatcher = {};

	var hasRequiredEsnext_symbol_customMatcher;

	function requireEsnext_symbol_customMatcher () {
		if (hasRequiredEsnext_symbol_customMatcher) return esnext_symbol_customMatcher;
		hasRequiredEsnext_symbol_customMatcher = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.customMatcher` well-known symbol
		// https://github.com/tc39/proposal-pattern-matching
		defineWellKnownSymbol('customMatcher');
		return esnext_symbol_customMatcher;
	}

	var esnext_symbol_observable = {};

	var hasRequiredEsnext_symbol_observable;

	function requireEsnext_symbol_observable () {
		if (hasRequiredEsnext_symbol_observable) return esnext_symbol_observable;
		hasRequiredEsnext_symbol_observable = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.observable` well-known symbol
		// https://github.com/tc39/proposal-observable
		defineWellKnownSymbol('observable');
		return esnext_symbol_observable;
	}

	var esnext_symbol_isRegistered = {};

	var hasRequiredEsnext_symbol_isRegistered;

	function requireEsnext_symbol_isRegistered () {
		if (hasRequiredEsnext_symbol_isRegistered) return esnext_symbol_isRegistered;
		hasRequiredEsnext_symbol_isRegistered = 1;
		var $ = /*@__PURE__*/ require_export();
		var isRegisteredSymbol = /*@__PURE__*/ requireSymbolIsRegistered();

		// `Symbol.isRegistered` method
		// obsolete version of https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
		$({ target: 'Symbol', stat: true, name: 'isRegisteredSymbol' }, {
		  isRegistered: isRegisteredSymbol
		});
		return esnext_symbol_isRegistered;
	}

	var esnext_symbol_isWellKnown = {};

	var hasRequiredEsnext_symbol_isWellKnown;

	function requireEsnext_symbol_isWellKnown () {
		if (hasRequiredEsnext_symbol_isWellKnown) return esnext_symbol_isWellKnown;
		hasRequiredEsnext_symbol_isWellKnown = 1;
		var $ = /*@__PURE__*/ require_export();
		var isWellKnownSymbol = /*@__PURE__*/ requireSymbolIsWellKnown();

		// `Symbol.isWellKnown` method
		// obsolete version of https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
		// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
		$({ target: 'Symbol', stat: true, name: 'isWellKnownSymbol', forced: true }, {
		  isWellKnown: isWellKnownSymbol
		});
		return esnext_symbol_isWellKnown;
	}

	var esnext_symbol_matcher = {};

	var hasRequiredEsnext_symbol_matcher;

	function requireEsnext_symbol_matcher () {
		if (hasRequiredEsnext_symbol_matcher) return esnext_symbol_matcher;
		hasRequiredEsnext_symbol_matcher = 1;
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.matcher` well-known symbol
		// https://github.com/tc39/proposal-pattern-matching
		defineWellKnownSymbol('matcher');
		return esnext_symbol_matcher;
	}

	var esnext_symbol_metadataKey = {};

	var hasRequiredEsnext_symbol_metadataKey;

	function requireEsnext_symbol_metadataKey () {
		if (hasRequiredEsnext_symbol_metadataKey) return esnext_symbol_metadataKey;
		hasRequiredEsnext_symbol_metadataKey = 1;
		// TODO: Remove from `core-js@4`
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.metadataKey` well-known symbol
		// https://github.com/tc39/proposal-decorator-metadata
		defineWellKnownSymbol('metadataKey');
		return esnext_symbol_metadataKey;
	}

	var esnext_symbol_patternMatch = {};

	var hasRequiredEsnext_symbol_patternMatch;

	function requireEsnext_symbol_patternMatch () {
		if (hasRequiredEsnext_symbol_patternMatch) return esnext_symbol_patternMatch;
		hasRequiredEsnext_symbol_patternMatch = 1;
		// TODO: remove from `core-js@4`
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		// `Symbol.patternMatch` well-known symbol
		// https://github.com/tc39/proposal-pattern-matching
		defineWellKnownSymbol('patternMatch');
		return esnext_symbol_patternMatch;
	}

	var esnext_symbol_replaceAll = {};

	var hasRequiredEsnext_symbol_replaceAll;

	function requireEsnext_symbol_replaceAll () {
		if (hasRequiredEsnext_symbol_replaceAll) return esnext_symbol_replaceAll;
		hasRequiredEsnext_symbol_replaceAll = 1;
		// TODO: remove from `core-js@4`
		var defineWellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbolDefine();

		defineWellKnownSymbol('replaceAll');
		return esnext_symbol_replaceAll;
	}

	var symbol$2;
	var hasRequiredSymbol$2;

	function requireSymbol$2 () {
		if (hasRequiredSymbol$2) return symbol$2;
		hasRequiredSymbol$2 = 1;
		var parent = /*@__PURE__*/ requireSymbol$3();
		requireEsnext_symbol_isRegisteredSymbol();
		requireEsnext_symbol_isWellKnownSymbol();
		requireEsnext_symbol_customMatcher();
		requireEsnext_symbol_observable();
		// TODO: Remove from `core-js@4`
		requireEsnext_symbol_isRegistered();
		requireEsnext_symbol_isWellKnown();
		requireEsnext_symbol_matcher();
		requireEsnext_symbol_metadataKey();
		requireEsnext_symbol_patternMatch();
		requireEsnext_symbol_replaceAll();

		symbol$2 = parent;
		return symbol$2;
	}

	var symbol$1;
	var hasRequiredSymbol$1;

	function requireSymbol$1 () {
		if (hasRequiredSymbol$1) return symbol$1;
		hasRequiredSymbol$1 = 1;
		symbol$1 = /*@__PURE__*/ requireSymbol$2();
		return symbol$1;
	}

	var symbolExports$1 = /*@__PURE__*/ requireSymbol$1();
	var _Symbol$2 = /*@__PURE__*/getDefaultExportFromCjs(symbolExports$1);

	var iterator$5;
	var hasRequiredIterator$5;

	function requireIterator$5 () {
		if (hasRequiredIterator$5) return iterator$5;
		hasRequiredIterator$5 = 1;
		requireEs_array_iterator();
		requireEs_string_iterator();
		requireEs_symbol_iterator();
		var WrappedWellKnownSymbolModule = /*@__PURE__*/ requireWellKnownSymbolWrapped();

		iterator$5 = WrappedWellKnownSymbolModule.f('iterator');
		return iterator$5;
	}

	var iterator$4;
	var hasRequiredIterator$4;

	function requireIterator$4 () {
		if (hasRequiredIterator$4) return iterator$4;
		hasRequiredIterator$4 = 1;
		var parent = /*@__PURE__*/ requireIterator$5();
		requireWeb_domCollections_iterator();

		iterator$4 = parent;
		return iterator$4;
	}

	var iterator$3;
	var hasRequiredIterator$3;

	function requireIterator$3 () {
		if (hasRequiredIterator$3) return iterator$3;
		hasRequiredIterator$3 = 1;
		var parent = /*@__PURE__*/ requireIterator$4();

		iterator$3 = parent;
		return iterator$3;
	}

	var iterator$2;
	var hasRequiredIterator$2;

	function requireIterator$2 () {
		if (hasRequiredIterator$2) return iterator$2;
		hasRequiredIterator$2 = 1;
		var parent = /*@__PURE__*/ requireIterator$3();

		iterator$2 = parent;
		return iterator$2;
	}

	var iterator$1;
	var hasRequiredIterator$1;

	function requireIterator$1 () {
		if (hasRequiredIterator$1) return iterator$1;
		hasRequiredIterator$1 = 1;
		iterator$1 = /*@__PURE__*/ requireIterator$2();
		return iterator$1;
	}

	var iteratorExports$1 = /*@__PURE__*/ requireIterator$1();
	var _Symbol$iterator$1 = /*@__PURE__*/getDefaultExportFromCjs(iteratorExports$1);

	function _typeof$1(o) {
	  "@babel/helpers - typeof";

	  return _typeof$1 = "function" == typeof _Symbol$2 && "symbol" == typeof _Symbol$iterator$1 ? function (o) {
	    return typeof o;
	  } : function (o) {
	    return o && "function" == typeof _Symbol$2 && o.constructor === _Symbol$2 && o !== _Symbol$2.prototype ? "symbol" : typeof o;
	  }, _typeof$1(o);
	}

	var toPrimitive$5;
	var hasRequiredToPrimitive$4;

	function requireToPrimitive$4 () {
		if (hasRequiredToPrimitive$4) return toPrimitive$5;
		hasRequiredToPrimitive$4 = 1;
		requireEs_symbol_toPrimitive();
		var WrappedWellKnownSymbolModule = /*@__PURE__*/ requireWellKnownSymbolWrapped();

		toPrimitive$5 = WrappedWellKnownSymbolModule.f('toPrimitive');
		return toPrimitive$5;
	}

	var toPrimitive$4;
	var hasRequiredToPrimitive$3;

	function requireToPrimitive$3 () {
		if (hasRequiredToPrimitive$3) return toPrimitive$4;
		hasRequiredToPrimitive$3 = 1;
		var parent = /*@__PURE__*/ requireToPrimitive$4();

		toPrimitive$4 = parent;
		return toPrimitive$4;
	}

	var toPrimitive$3;
	var hasRequiredToPrimitive$2;

	function requireToPrimitive$2 () {
		if (hasRequiredToPrimitive$2) return toPrimitive$3;
		hasRequiredToPrimitive$2 = 1;
		var parent = /*@__PURE__*/ requireToPrimitive$3();

		toPrimitive$3 = parent;
		return toPrimitive$3;
	}

	var toPrimitive$2;
	var hasRequiredToPrimitive$1;

	function requireToPrimitive$1 () {
		if (hasRequiredToPrimitive$1) return toPrimitive$2;
		hasRequiredToPrimitive$1 = 1;
		var parent = /*@__PURE__*/ requireToPrimitive$2();

		toPrimitive$2 = parent;
		return toPrimitive$2;
	}

	var toPrimitive$1;
	var hasRequiredToPrimitive;

	function requireToPrimitive () {
		if (hasRequiredToPrimitive) return toPrimitive$1;
		hasRequiredToPrimitive = 1;
		toPrimitive$1 = /*@__PURE__*/ requireToPrimitive$1();
		return toPrimitive$1;
	}

	var toPrimitiveExports = /*@__PURE__*/ requireToPrimitive();
	var _Symbol$toPrimitive = /*@__PURE__*/getDefaultExportFromCjs(toPrimitiveExports);

	function toPrimitive(t, r) {
	  if ("object" != _typeof$1(t) || !t) return t;
	  var e = t[_Symbol$toPrimitive];
	  if (void 0 !== e) {
	    var i = e.call(t, r);
	    if ("object" != _typeof$1(i)) return i;
	    throw new TypeError("@@toPrimitive must return a primitive value.");
	  }
	  return ("string" === r ? String : Number)(t);
	}

	function toPropertyKey(t) {
	  var i = toPrimitive(t, "string");
	  return "symbol" == _typeof$1(i) ? i : i + "";
	}

	function _defineProperty(e, r, t) {
	  return (r = toPropertyKey(r)) in e ? _Object$defineProperty(e, r, {
	    value: t,
	    enumerable: true,
	    configurable: true,
	    writable: true
	  }) : e[r] = t, e;
	}

	function _classCallCheck(a, n) {
	  if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function");
	}

	function _defineProperties(e, r) {
	  for (var t = 0; t < r.length; t++) {
	    var o = r[t];
	    o.enumerable = o.enumerable || false, o.configurable = true, "value" in o && (o.writable = true), _Object$defineProperty(e, toPropertyKey(o.key), o);
	  }
	}
	function _createClass(e, r, t) {
	  return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), _Object$defineProperty(e, "prototype", {
	    writable: false
	  }), e;
	}

	var es_aggregateError = {};

	var es_aggregateError_constructor = {};

	var copyConstructorProperties;
	var hasRequiredCopyConstructorProperties;

	function requireCopyConstructorProperties () {
		if (hasRequiredCopyConstructorProperties) return copyConstructorProperties;
		hasRequiredCopyConstructorProperties = 1;
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var ownKeys = /*@__PURE__*/ requireOwnKeys();
		var getOwnPropertyDescriptorModule = /*@__PURE__*/ requireObjectGetOwnPropertyDescriptor();
		var definePropertyModule = /*@__PURE__*/ requireObjectDefineProperty();

		copyConstructorProperties = function (target, source, exceptions) {
		  var keys = ownKeys(source);
		  var defineProperty = definePropertyModule.f;
		  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
		  for (var i = 0; i < keys.length; i++) {
		    var key = keys[i];
		    if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
		      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
		    }
		  }
		};
		return copyConstructorProperties;
	}

	var installErrorCause;
	var hasRequiredInstallErrorCause;

	function requireInstallErrorCause () {
		if (hasRequiredInstallErrorCause) return installErrorCause;
		hasRequiredInstallErrorCause = 1;
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();

		// `InstallErrorCause` abstract operation
		// https://tc39.es/proposal-error-cause/#sec-errorobjects-install-error-cause
		installErrorCause = function (O, options) {
		  if (isObject(options) && 'cause' in options) {
		    createNonEnumerableProperty(O, 'cause', options.cause);
		  }
		};
		return installErrorCause;
	}

	var errorStackClear;
	var hasRequiredErrorStackClear;

	function requireErrorStackClear () {
		if (hasRequiredErrorStackClear) return errorStackClear;
		hasRequiredErrorStackClear = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		var $Error = Error;
		var replace = uncurryThis(''.replace);

		var TEST = (function (arg) { return String(new $Error(arg).stack); })('zxcasd');
		// eslint-disable-next-line redos/no-vulnerable, sonarjs/slow-regex -- safe
		var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
		var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);

		errorStackClear = function (stack, dropEntries) {
		  if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string' && !$Error.prepareStackTrace) {
		    while (dropEntries--) stack = replace(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
		  } return stack;
		};
		return errorStackClear;
	}

	var errorStackInstallable;
	var hasRequiredErrorStackInstallable;

	function requireErrorStackInstallable () {
		if (hasRequiredErrorStackInstallable) return errorStackInstallable;
		hasRequiredErrorStackInstallable = 1;
		var fails = /*@__PURE__*/ requireFails();
		var createPropertyDescriptor = /*@__PURE__*/ requireCreatePropertyDescriptor();

		errorStackInstallable = !fails(function () {
		  var error = new Error('a');
		  if (!('stack' in error)) return true;
		  // eslint-disable-next-line es/no-object-defineproperty -- safe
		  Object.defineProperty(error, 'stack', createPropertyDescriptor(1, 7));
		  return error.stack !== 7;
		});
		return errorStackInstallable;
	}

	var errorStackInstall;
	var hasRequiredErrorStackInstall;

	function requireErrorStackInstall () {
		if (hasRequiredErrorStackInstall) return errorStackInstall;
		hasRequiredErrorStackInstall = 1;
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();
		var clearErrorStack = /*@__PURE__*/ requireErrorStackClear();
		var ERROR_STACK_INSTALLABLE = /*@__PURE__*/ requireErrorStackInstallable();

		// non-standard V8
		var captureStackTrace = Error.captureStackTrace;

		errorStackInstall = function (error, C, stack, dropEntries) {
		  if (ERROR_STACK_INSTALLABLE) {
		    if (captureStackTrace) captureStackTrace(error, C);
		    else createNonEnumerableProperty(error, 'stack', clearErrorStack(stack, dropEntries));
		  }
		};
		return errorStackInstall;
	}

	var iterate;
	var hasRequiredIterate;

	function requireIterate () {
		if (hasRequiredIterate) return iterate;
		hasRequiredIterate = 1;
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var call = /*@__PURE__*/ requireFunctionCall();
		var anObject = /*@__PURE__*/ requireAnObject();
		var tryToString = /*@__PURE__*/ requireTryToString();
		var isArrayIteratorMethod = /*@__PURE__*/ requireIsArrayIteratorMethod();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var getIterator = /*@__PURE__*/ requireGetIterator$6();
		var getIteratorMethod = /*@__PURE__*/ requireGetIteratorMethod$6();
		var iteratorClose = /*@__PURE__*/ requireIteratorClose();

		var $TypeError = TypeError;

		var Result = function (stopped, result) {
		  this.stopped = stopped;
		  this.result = result;
		};

		var ResultPrototype = Result.prototype;

		iterate = function (iterable, unboundFunction, options) {
		  var that = options && options.that;
		  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
		  var IS_RECORD = !!(options && options.IS_RECORD);
		  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
		  var INTERRUPTED = !!(options && options.INTERRUPTED);
		  var fn = bind(unboundFunction, that);
		  var iterator, iterFn, index, length, result, next, step;

		  var stop = function (condition) {
		    if (iterator) iteratorClose(iterator, 'normal', condition);
		    return new Result(true, condition);
		  };

		  var callFn = function (value) {
		    if (AS_ENTRIES) {
		      anObject(value);
		      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
		    } return INTERRUPTED ? fn(value, stop) : fn(value);
		  };

		  if (IS_RECORD) {
		    iterator = iterable.iterator;
		  } else if (IS_ITERATOR) {
		    iterator = iterable;
		  } else {
		    iterFn = getIteratorMethod(iterable);
		    if (!iterFn) throw new $TypeError(tryToString(iterable) + ' is not iterable');
		    // optimisation for array iterators
		    if (isArrayIteratorMethod(iterFn)) {
		      for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
		        result = callFn(iterable[index]);
		        if (result && isPrototypeOf(ResultPrototype, result)) return result;
		      } return new Result(false);
		    }
		    iterator = getIterator(iterable, iterFn);
		  }

		  next = IS_RECORD ? iterable.next : iterator.next;
		  while (!(step = call(next, iterator)).done) {
		    try {
		      result = callFn(step.value);
		    } catch (error) {
		      iteratorClose(iterator, 'throw', error);
		    }
		    if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result)) return result;
		  } return new Result(false);
		};
		return iterate;
	}

	var normalizeStringArgument;
	var hasRequiredNormalizeStringArgument;

	function requireNormalizeStringArgument () {
		if (hasRequiredNormalizeStringArgument) return normalizeStringArgument;
		hasRequiredNormalizeStringArgument = 1;
		var toString = /*@__PURE__*/ requireToString();

		normalizeStringArgument = function (argument, $default) {
		  return argument === undefined ? arguments.length < 2 ? '' : $default : toString(argument);
		};
		return normalizeStringArgument;
	}

	var hasRequiredEs_aggregateError_constructor;

	function requireEs_aggregateError_constructor () {
		if (hasRequiredEs_aggregateError_constructor) return es_aggregateError_constructor;
		hasRequiredEs_aggregateError_constructor = 1;
		var $ = /*@__PURE__*/ require_export();
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var getPrototypeOf = /*@__PURE__*/ requireObjectGetPrototypeOf();
		var setPrototypeOf = /*@__PURE__*/ requireObjectSetPrototypeOf();
		var copyConstructorProperties = /*@__PURE__*/ requireCopyConstructorProperties();
		var create = /*@__PURE__*/ requireObjectCreate();
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();
		var createPropertyDescriptor = /*@__PURE__*/ requireCreatePropertyDescriptor();
		var installErrorCause = /*@__PURE__*/ requireInstallErrorCause();
		var installErrorStack = /*@__PURE__*/ requireErrorStackInstall();
		var iterate = /*@__PURE__*/ requireIterate();
		var normalizeStringArgument = /*@__PURE__*/ requireNormalizeStringArgument();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var TO_STRING_TAG = wellKnownSymbol('toStringTag');
		var $Error = Error;
		var push = [].push;

		var $AggregateError = function AggregateError(errors, message /* , options */) {
		  var isInstance = isPrototypeOf(AggregateErrorPrototype, this);
		  var that;
		  if (setPrototypeOf) {
		    that = setPrototypeOf(new $Error(), isInstance ? getPrototypeOf(this) : AggregateErrorPrototype);
		  } else {
		    that = isInstance ? this : create(AggregateErrorPrototype);
		    createNonEnumerableProperty(that, TO_STRING_TAG, 'Error');
		  }
		  if (message !== undefined) createNonEnumerableProperty(that, 'message', normalizeStringArgument(message));
		  installErrorStack(that, $AggregateError, that.stack, 1);
		  if (arguments.length > 2) installErrorCause(that, arguments[2]);
		  var errorsArray = [];
		  iterate(errors, push, { that: errorsArray });
		  createNonEnumerableProperty(that, 'errors', errorsArray);
		  return that;
		};

		if (setPrototypeOf) setPrototypeOf($AggregateError, $Error);
		else copyConstructorProperties($AggregateError, $Error, { name: true });

		var AggregateErrorPrototype = $AggregateError.prototype = create($Error.prototype, {
		  constructor: createPropertyDescriptor(1, $AggregateError),
		  message: createPropertyDescriptor(1, ''),
		  name: createPropertyDescriptor(1, 'AggregateError')
		});

		// `AggregateError` constructor
		// https://tc39.es/ecma262/#sec-aggregate-error-constructor
		$({ global: true, constructor: true, arity: 2 }, {
		  AggregateError: $AggregateError
		});
		return es_aggregateError_constructor;
	}

	var hasRequiredEs_aggregateError;

	function requireEs_aggregateError () {
		if (hasRequiredEs_aggregateError) return es_aggregateError;
		hasRequiredEs_aggregateError = 1;
		// TODO: Remove this module from `core-js@4` since it's replaced to module below
		requireEs_aggregateError_constructor();
		return es_aggregateError;
	}

	var es_promise = {};

	var es_promise_constructor = {};

	var environment;
	var hasRequiredEnvironment;

	function requireEnvironment () {
		if (hasRequiredEnvironment) return environment;
		hasRequiredEnvironment = 1;
		/* global Bun, Deno -- detection */
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var userAgent = /*@__PURE__*/ requireEnvironmentUserAgent();
		var classof = /*@__PURE__*/ requireClassofRaw();

		var userAgentStartsWith = function (string) {
		  return userAgent.slice(0, string.length) === string;
		};

		environment = (function () {
		  if (userAgentStartsWith('Bun/')) return 'BUN';
		  if (userAgentStartsWith('Cloudflare-Workers')) return 'CLOUDFLARE';
		  if (userAgentStartsWith('Deno/')) return 'DENO';
		  if (userAgentStartsWith('Node.js/')) return 'NODE';
		  if (globalThis.Bun && typeof Bun.version == 'string') return 'BUN';
		  if (globalThis.Deno && typeof Deno.version == 'object') return 'DENO';
		  if (classof(globalThis.process) === 'process') return 'NODE';
		  if (globalThis.window && globalThis.document) return 'BROWSER';
		  return 'REST';
		})();
		return environment;
	}

	var environmentIsNode;
	var hasRequiredEnvironmentIsNode;

	function requireEnvironmentIsNode () {
		if (hasRequiredEnvironmentIsNode) return environmentIsNode;
		hasRequiredEnvironmentIsNode = 1;
		var ENVIRONMENT = /*@__PURE__*/ requireEnvironment();

		environmentIsNode = ENVIRONMENT === 'NODE';
		return environmentIsNode;
	}

	var setSpecies;
	var hasRequiredSetSpecies;

	function requireSetSpecies () {
		if (hasRequiredSetSpecies) return setSpecies;
		hasRequiredSetSpecies = 1;
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var defineBuiltInAccessor = /*@__PURE__*/ requireDefineBuiltInAccessor();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();

		var SPECIES = wellKnownSymbol('species');

		setSpecies = function (CONSTRUCTOR_NAME) {
		  var Constructor = getBuiltIn(CONSTRUCTOR_NAME);

		  if (DESCRIPTORS && Constructor && !Constructor[SPECIES]) {
		    defineBuiltInAccessor(Constructor, SPECIES, {
		      configurable: true,
		      get: function () { return this; }
		    });
		  }
		};
		return setSpecies;
	}

	var aConstructor;
	var hasRequiredAConstructor;

	function requireAConstructor () {
		if (hasRequiredAConstructor) return aConstructor;
		hasRequiredAConstructor = 1;
		var isConstructor = /*@__PURE__*/ requireIsConstructor();
		var tryToString = /*@__PURE__*/ requireTryToString();

		var $TypeError = TypeError;

		// `Assert: IsConstructor(argument) is true`
		aConstructor = function (argument) {
		  if (isConstructor(argument)) return argument;
		  throw new $TypeError(tryToString(argument) + ' is not a constructor');
		};
		return aConstructor;
	}

	var speciesConstructor;
	var hasRequiredSpeciesConstructor;

	function requireSpeciesConstructor () {
		if (hasRequiredSpeciesConstructor) return speciesConstructor;
		hasRequiredSpeciesConstructor = 1;
		var anObject = /*@__PURE__*/ requireAnObject();
		var aConstructor = /*@__PURE__*/ requireAConstructor();
		var isNullOrUndefined = /*@__PURE__*/ requireIsNullOrUndefined();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var SPECIES = wellKnownSymbol('species');

		// `SpeciesConstructor` abstract operation
		// https://tc39.es/ecma262/#sec-speciesconstructor
		speciesConstructor = function (O, defaultConstructor) {
		  var C = anObject(O).constructor;
		  var S;
		  return C === undefined || isNullOrUndefined(S = anObject(C)[SPECIES]) ? defaultConstructor : aConstructor(S);
		};
		return speciesConstructor;
	}

	var environmentIsIos;
	var hasRequiredEnvironmentIsIos;

	function requireEnvironmentIsIos () {
		if (hasRequiredEnvironmentIsIos) return environmentIsIos;
		hasRequiredEnvironmentIsIos = 1;
		var userAgent = /*@__PURE__*/ requireEnvironmentUserAgent();

		// eslint-disable-next-line redos/no-vulnerable -- safe
		environmentIsIos = /(?:ipad|iphone|ipod).*applewebkit/i.test(userAgent);
		return environmentIsIos;
	}

	var task;
	var hasRequiredTask;

	function requireTask () {
		if (hasRequiredTask) return task;
		hasRequiredTask = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var apply = /*@__PURE__*/ requireFunctionApply();
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var fails = /*@__PURE__*/ requireFails();
		var html = /*@__PURE__*/ requireHtml();
		var arraySlice = /*@__PURE__*/ requireArraySlice();
		var createElement = /*@__PURE__*/ requireDocumentCreateElement();
		var validateArgumentsLength = /*@__PURE__*/ requireValidateArgumentsLength();
		var IS_IOS = /*@__PURE__*/ requireEnvironmentIsIos();
		var IS_NODE = /*@__PURE__*/ requireEnvironmentIsNode();

		var set = globalThis.setImmediate;
		var clear = globalThis.clearImmediate;
		var process = globalThis.process;
		var Dispatch = globalThis.Dispatch;
		var Function = globalThis.Function;
		var MessageChannel = globalThis.MessageChannel;
		var String = globalThis.String;
		var counter = 0;
		var queue = {};
		var ONREADYSTATECHANGE = 'onreadystatechange';
		var $location, defer, channel, port;

		fails(function () {
		  // Deno throws a ReferenceError on `location` access without `--location` flag
		  $location = globalThis.location;
		});

		var run = function (id) {
		  if (hasOwn(queue, id)) {
		    var fn = queue[id];
		    delete queue[id];
		    fn();
		  }
		};

		var runner = function (id) {
		  return function () {
		    run(id);
		  };
		};

		var eventListener = function (event) {
		  run(event.data);
		};

		var globalPostMessageDefer = function (id) {
		  // old engines have not location.origin
		  globalThis.postMessage(String(id), $location.protocol + '//' + $location.host);
		};

		// Node.js 0.9+ & IE10+ has setImmediate, otherwise:
		if (!set || !clear) {
		  set = function setImmediate(handler) {
		    validateArgumentsLength(arguments.length, 1);
		    var fn = isCallable(handler) ? handler : Function(handler);
		    var args = arraySlice(arguments, 1);
		    queue[++counter] = function () {
		      apply(fn, undefined, args);
		    };
		    defer(counter);
		    return counter;
		  };
		  clear = function clearImmediate(id) {
		    delete queue[id];
		  };
		  // Node.js 0.8-
		  if (IS_NODE) {
		    defer = function (id) {
		      process.nextTick(runner(id));
		    };
		  // Sphere (JS game engine) Dispatch API
		  } else if (Dispatch && Dispatch.now) {
		    defer = function (id) {
		      Dispatch.now(runner(id));
		    };
		  // Browsers with MessageChannel, includes WebWorkers
		  // except iOS - https://github.com/zloirock/core-js/issues/624
		  } else if (MessageChannel && !IS_IOS) {
		    channel = new MessageChannel();
		    port = channel.port2;
		    channel.port1.onmessage = eventListener;
		    defer = bind(port.postMessage, port);
		  // Browsers with postMessage, skip WebWorkers
		  // IE8 has postMessage, but it's sync & typeof its postMessage is 'object'
		  } else if (
		    globalThis.addEventListener &&
		    isCallable(globalThis.postMessage) &&
		    !globalThis.importScripts &&
		    $location && $location.protocol !== 'file:' &&
		    !fails(globalPostMessageDefer)
		  ) {
		    defer = globalPostMessageDefer;
		    globalThis.addEventListener('message', eventListener, false);
		  // IE8-
		  } else if (ONREADYSTATECHANGE in createElement('script')) {
		    defer = function (id) {
		      html.appendChild(createElement('script'))[ONREADYSTATECHANGE] = function () {
		        html.removeChild(this);
		        run(id);
		      };
		    };
		  // Rest old browsers
		  } else {
		    defer = function (id) {
		      setTimeout(runner(id), 0);
		    };
		  }
		}

		task = {
		  set: set,
		  clear: clear
		};
		return task;
	}

	var queue;
	var hasRequiredQueue;

	function requireQueue () {
		if (hasRequiredQueue) return queue;
		hasRequiredQueue = 1;
		var Queue = function () {
		  this.head = null;
		  this.tail = null;
		};

		Queue.prototype = {
		  add: function (item) {
		    var entry = { item: item, next: null };
		    var tail = this.tail;
		    if (tail) tail.next = entry;
		    else this.head = entry;
		    this.tail = entry;
		  },
		  get: function () {
		    var entry = this.head;
		    if (entry) {
		      var next = this.head = entry.next;
		      if (next === null) this.tail = null;
		      return entry.item;
		    }
		  }
		};

		queue = Queue;
		return queue;
	}

	var environmentIsIosPebble;
	var hasRequiredEnvironmentIsIosPebble;

	function requireEnvironmentIsIosPebble () {
		if (hasRequiredEnvironmentIsIosPebble) return environmentIsIosPebble;
		hasRequiredEnvironmentIsIosPebble = 1;
		var userAgent = /*@__PURE__*/ requireEnvironmentUserAgent();

		environmentIsIosPebble = /ipad|iphone|ipod/i.test(userAgent) && typeof Pebble != 'undefined';
		return environmentIsIosPebble;
	}

	var environmentIsWebosWebkit;
	var hasRequiredEnvironmentIsWebosWebkit;

	function requireEnvironmentIsWebosWebkit () {
		if (hasRequiredEnvironmentIsWebosWebkit) return environmentIsWebosWebkit;
		hasRequiredEnvironmentIsWebosWebkit = 1;
		var userAgent = /*@__PURE__*/ requireEnvironmentUserAgent();

		environmentIsWebosWebkit = /web0s(?!.*chrome)/i.test(userAgent);
		return environmentIsWebosWebkit;
	}

	var microtask_1;
	var hasRequiredMicrotask;

	function requireMicrotask () {
		if (hasRequiredMicrotask) return microtask_1;
		hasRequiredMicrotask = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var safeGetBuiltIn = /*@__PURE__*/ requireSafeGetBuiltIn();
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var macrotask = /*@__PURE__*/ requireTask().set;
		var Queue = /*@__PURE__*/ requireQueue();
		var IS_IOS = /*@__PURE__*/ requireEnvironmentIsIos();
		var IS_IOS_PEBBLE = /*@__PURE__*/ requireEnvironmentIsIosPebble();
		var IS_WEBOS_WEBKIT = /*@__PURE__*/ requireEnvironmentIsWebosWebkit();
		var IS_NODE = /*@__PURE__*/ requireEnvironmentIsNode();

		var MutationObserver = globalThis.MutationObserver || globalThis.WebKitMutationObserver;
		var document = globalThis.document;
		var process = globalThis.process;
		var Promise = globalThis.Promise;
		var microtask = safeGetBuiltIn('queueMicrotask');
		var notify, toggle, node, promise, then;

		// modern engines have queueMicrotask method
		if (!microtask) {
		  var queue = new Queue();

		  var flush = function () {
		    var parent, fn;
		    if (IS_NODE && (parent = process.domain)) parent.exit();
		    while (fn = queue.get()) try {
		      fn();
		    } catch (error) {
		      if (queue.head) notify();
		      throw error;
		    }
		    if (parent) parent.enter();
		  };

		  // browsers with MutationObserver, except iOS - https://github.com/zloirock/core-js/issues/339
		  // also except WebOS Webkit https://github.com/zloirock/core-js/issues/898
		  if (!IS_IOS && !IS_NODE && !IS_WEBOS_WEBKIT && MutationObserver && document) {
		    toggle = true;
		    node = document.createTextNode('');
		    new MutationObserver(flush).observe(node, { characterData: true });
		    notify = function () {
		      node.data = toggle = !toggle;
		    };
		  // environments with maybe non-completely correct, but existent Promise
		  } else if (!IS_IOS_PEBBLE && Promise && Promise.resolve) {
		    // Promise.resolve without an argument throws an error in LG WebOS 2
		    promise = Promise.resolve(undefined);
		    // workaround of WebKit ~ iOS Safari 10.1 bug
		    promise.constructor = Promise;
		    then = bind(promise.then, promise);
		    notify = function () {
		      then(flush);
		    };
		  // Node.js without promises
		  } else if (IS_NODE) {
		    notify = function () {
		      process.nextTick(flush);
		    };
		  // for other environments - macrotask based on:
		  // - setImmediate
		  // - MessageChannel
		  // - window.postMessage
		  // - onreadystatechange
		  // - setTimeout
		  } else {
		    // `webpack` dev server bug on IE global methods - use bind(fn, global)
		    macrotask = bind(macrotask, globalThis);
		    notify = function () {
		      macrotask(flush);
		    };
		  }

		  microtask = function (fn) {
		    if (!queue.head) notify();
		    queue.add(fn);
		  };
		}

		microtask_1 = microtask;
		return microtask_1;
	}

	var hostReportErrors;
	var hasRequiredHostReportErrors;

	function requireHostReportErrors () {
		if (hasRequiredHostReportErrors) return hostReportErrors;
		hasRequiredHostReportErrors = 1;
		hostReportErrors = function (a, b) {
		  try {
		    // eslint-disable-next-line no-console -- safe
		    arguments.length === 1 ? console.error(a) : console.error(a, b);
		  } catch (error) { /* empty */ }
		};
		return hostReportErrors;
	}

	var perform;
	var hasRequiredPerform;

	function requirePerform () {
		if (hasRequiredPerform) return perform;
		hasRequiredPerform = 1;
		perform = function (exec) {
		  try {
		    return { error: false, value: exec() };
		  } catch (error) {
		    return { error: true, value: error };
		  }
		};
		return perform;
	}

	var promiseNativeConstructor;
	var hasRequiredPromiseNativeConstructor;

	function requirePromiseNativeConstructor () {
		if (hasRequiredPromiseNativeConstructor) return promiseNativeConstructor;
		hasRequiredPromiseNativeConstructor = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();

		promiseNativeConstructor = globalThis.Promise;
		return promiseNativeConstructor;
	}

	var promiseConstructorDetection;
	var hasRequiredPromiseConstructorDetection;

	function requirePromiseConstructorDetection () {
		if (hasRequiredPromiseConstructorDetection) return promiseConstructorDetection;
		hasRequiredPromiseConstructorDetection = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var NativePromiseConstructor = /*@__PURE__*/ requirePromiseNativeConstructor();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var isForced = /*@__PURE__*/ requireIsForced();
		var inspectSource = /*@__PURE__*/ requireInspectSource();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();
		var ENVIRONMENT = /*@__PURE__*/ requireEnvironment();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var V8_VERSION = /*@__PURE__*/ requireEnvironmentV8Version();

		var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
		var SPECIES = wellKnownSymbol('species');
		var SUBCLASSING = false;
		var NATIVE_PROMISE_REJECTION_EVENT = isCallable(globalThis.PromiseRejectionEvent);

		var FORCED_PROMISE_CONSTRUCTOR = isForced('Promise', function () {
		  var PROMISE_CONSTRUCTOR_SOURCE = inspectSource(NativePromiseConstructor);
		  var GLOBAL_CORE_JS_PROMISE = PROMISE_CONSTRUCTOR_SOURCE !== String(NativePromiseConstructor);
		  // V8 6.6 (Node 10 and Chrome 66) have a bug with resolving custom thenables
		  // https://bugs.chromium.org/p/chromium/issues/detail?id=830565
		  // We can't detect it synchronously, so just check versions
		  if (!GLOBAL_CORE_JS_PROMISE && V8_VERSION === 66) return true;
		  // We need Promise#{ catch, finally } in the pure version for preventing prototype pollution
		  if (IS_PURE && !(NativePromisePrototype['catch'] && NativePromisePrototype['finally'])) return true;
		  // We can't use @@species feature detection in V8 since it causes
		  // deoptimization and performance degradation
		  // https://github.com/zloirock/core-js/issues/679
		  if (!V8_VERSION || V8_VERSION < 51 || !/native code/.test(PROMISE_CONSTRUCTOR_SOURCE)) {
		    // Detect correctness of subclassing with @@species support
		    var promise = new NativePromiseConstructor(function (resolve) { resolve(1); });
		    var FakePromise = function (exec) {
		      exec(function () { /* empty */ }, function () { /* empty */ });
		    };
		    var constructor = promise.constructor = {};
		    constructor[SPECIES] = FakePromise;
		    SUBCLASSING = promise.then(function () { /* empty */ }) instanceof FakePromise;
		    if (!SUBCLASSING) return true;
		  // Unhandled rejections tracking support, NodeJS Promise without it fails @@species test
		  } return !GLOBAL_CORE_JS_PROMISE && (ENVIRONMENT === 'BROWSER' || ENVIRONMENT === 'DENO') && !NATIVE_PROMISE_REJECTION_EVENT;
		});

		promiseConstructorDetection = {
		  CONSTRUCTOR: FORCED_PROMISE_CONSTRUCTOR,
		  REJECTION_EVENT: NATIVE_PROMISE_REJECTION_EVENT,
		  SUBCLASSING: SUBCLASSING
		};
		return promiseConstructorDetection;
	}

	var newPromiseCapability = {};

	var hasRequiredNewPromiseCapability;

	function requireNewPromiseCapability () {
		if (hasRequiredNewPromiseCapability) return newPromiseCapability;
		hasRequiredNewPromiseCapability = 1;
		var aCallable = /*@__PURE__*/ requireACallable();

		var $TypeError = TypeError;

		var PromiseCapability = function (C) {
		  var resolve, reject;
		  this.promise = new C(function ($$resolve, $$reject) {
		    if (resolve !== undefined || reject !== undefined) throw new $TypeError('Bad Promise constructor');
		    resolve = $$resolve;
		    reject = $$reject;
		  });
		  this.resolve = aCallable(resolve);
		  this.reject = aCallable(reject);
		};

		// `NewPromiseCapability` abstract operation
		// https://tc39.es/ecma262/#sec-newpromisecapability
		newPromiseCapability.f = function (C) {
		  return new PromiseCapability(C);
		};
		return newPromiseCapability;
	}

	var hasRequiredEs_promise_constructor;

	function requireEs_promise_constructor () {
		if (hasRequiredEs_promise_constructor) return es_promise_constructor;
		hasRequiredEs_promise_constructor = 1;
		var $ = /*@__PURE__*/ require_export();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var IS_NODE = /*@__PURE__*/ requireEnvironmentIsNode();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var call = /*@__PURE__*/ requireFunctionCall();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();
		var setPrototypeOf = /*@__PURE__*/ requireObjectSetPrototypeOf();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();
		var setSpecies = /*@__PURE__*/ requireSetSpecies();
		var aCallable = /*@__PURE__*/ requireACallable();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var anInstance = /*@__PURE__*/ requireAnInstance();
		var speciesConstructor = /*@__PURE__*/ requireSpeciesConstructor();
		var task = /*@__PURE__*/ requireTask().set;
		var microtask = /*@__PURE__*/ requireMicrotask();
		var hostReportErrors = /*@__PURE__*/ requireHostReportErrors();
		var perform = /*@__PURE__*/ requirePerform();
		var Queue = /*@__PURE__*/ requireQueue();
		var InternalStateModule = /*@__PURE__*/ requireInternalState();
		var NativePromiseConstructor = /*@__PURE__*/ requirePromiseNativeConstructor();
		var PromiseConstructorDetection = /*@__PURE__*/ requirePromiseConstructorDetection();
		var newPromiseCapabilityModule = /*@__PURE__*/ requireNewPromiseCapability();

		var PROMISE = 'Promise';
		var FORCED_PROMISE_CONSTRUCTOR = PromiseConstructorDetection.CONSTRUCTOR;
		var NATIVE_PROMISE_REJECTION_EVENT = PromiseConstructorDetection.REJECTION_EVENT;
		var NATIVE_PROMISE_SUBCLASSING = PromiseConstructorDetection.SUBCLASSING;
		var getInternalPromiseState = InternalStateModule.getterFor(PROMISE);
		var setInternalState = InternalStateModule.set;
		var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;
		var PromiseConstructor = NativePromiseConstructor;
		var PromisePrototype = NativePromisePrototype;
		var TypeError = globalThis.TypeError;
		var document = globalThis.document;
		var process = globalThis.process;
		var newPromiseCapability = newPromiseCapabilityModule.f;
		var newGenericPromiseCapability = newPromiseCapability;

		var DISPATCH_EVENT = !!(document && document.createEvent && globalThis.dispatchEvent);
		var UNHANDLED_REJECTION = 'unhandledrejection';
		var REJECTION_HANDLED = 'rejectionhandled';
		var PENDING = 0;
		var FULFILLED = 1;
		var REJECTED = 2;
		var HANDLED = 1;
		var UNHANDLED = 2;

		var Internal, OwnPromiseCapability, PromiseWrapper, nativeThen;

		// helpers
		var isThenable = function (it) {
		  var then;
		  return isObject(it) && isCallable(then = it.then) ? then : false;
		};

		var callReaction = function (reaction, state) {
		  var value = state.value;
		  var ok = state.state === FULFILLED;
		  var handler = ok ? reaction.ok : reaction.fail;
		  var resolve = reaction.resolve;
		  var reject = reaction.reject;
		  var domain = reaction.domain;
		  var result, then, exited;
		  try {
		    if (handler) {
		      if (!ok) {
		        if (state.rejection === UNHANDLED) onHandleUnhandled(state);
		        state.rejection = HANDLED;
		      }
		      if (handler === true) result = value;
		      else {
		        if (domain) domain.enter();
		        result = handler(value); // can throw
		        if (domain) {
		          domain.exit();
		          exited = true;
		        }
		      }
		      if (result === reaction.promise) {
		        reject(new TypeError('Promise-chain cycle'));
		      } else if (then = isThenable(result)) {
		        call(then, result, resolve, reject);
		      } else resolve(result);
		    } else reject(value);
		  } catch (error) {
		    if (domain && !exited) domain.exit();
		    reject(error);
		  }
		};

		var notify = function (state, isReject) {
		  if (state.notified) return;
		  state.notified = true;
		  microtask(function () {
		    var reactions = state.reactions;
		    var reaction;
		    while (reaction = reactions.get()) {
		      callReaction(reaction, state);
		    }
		    state.notified = false;
		    if (isReject && !state.rejection) onUnhandled(state);
		  });
		};

		var dispatchEvent = function (name, promise, reason) {
		  var event, handler;
		  if (DISPATCH_EVENT) {
		    event = document.createEvent('Event');
		    event.promise = promise;
		    event.reason = reason;
		    event.initEvent(name, false, true);
		    globalThis.dispatchEvent(event);
		  } else event = { promise: promise, reason: reason };
		  if (!NATIVE_PROMISE_REJECTION_EVENT && (handler = globalThis['on' + name])) handler(event);
		  else if (name === UNHANDLED_REJECTION) hostReportErrors('Unhandled promise rejection', reason);
		};

		var onUnhandled = function (state) {
		  call(task, globalThis, function () {
		    var promise = state.facade;
		    var value = state.value;
		    var IS_UNHANDLED = isUnhandled(state);
		    var result;
		    if (IS_UNHANDLED) {
		      result = perform(function () {
		        if (IS_NODE) {
		          process.emit('unhandledRejection', value, promise);
		        } else dispatchEvent(UNHANDLED_REJECTION, promise, value);
		      });
		      // Browsers should not trigger `rejectionHandled` event if it was handled here, NodeJS - should
		      state.rejection = IS_NODE || isUnhandled(state) ? UNHANDLED : HANDLED;
		      if (result.error) throw result.value;
		    }
		  });
		};

		var isUnhandled = function (state) {
		  return state.rejection !== HANDLED && !state.parent;
		};

		var onHandleUnhandled = function (state) {
		  call(task, globalThis, function () {
		    var promise = state.facade;
		    if (IS_NODE) {
		      process.emit('rejectionHandled', promise);
		    } else dispatchEvent(REJECTION_HANDLED, promise, state.value);
		  });
		};

		var bind = function (fn, state, unwrap) {
		  return function (value) {
		    fn(state, value, unwrap);
		  };
		};

		var internalReject = function (state, value, unwrap) {
		  if (state.done) return;
		  state.done = true;
		  if (unwrap) state = unwrap;
		  state.value = value;
		  state.state = REJECTED;
		  notify(state, true);
		};

		var internalResolve = function (state, value, unwrap) {
		  if (state.done) return;
		  state.done = true;
		  if (unwrap) state = unwrap;
		  try {
		    if (state.facade === value) throw new TypeError("Promise can't be resolved itself");
		    var then = isThenable(value);
		    if (then) {
		      microtask(function () {
		        var wrapper = { done: false };
		        try {
		          call(then, value,
		            bind(internalResolve, wrapper, state),
		            bind(internalReject, wrapper, state)
		          );
		        } catch (error) {
		          internalReject(wrapper, error, state);
		        }
		      });
		    } else {
		      state.value = value;
		      state.state = FULFILLED;
		      notify(state, false);
		    }
		  } catch (error) {
		    internalReject({ done: false }, error, state);
		  }
		};

		// constructor polyfill
		if (FORCED_PROMISE_CONSTRUCTOR) {
		  // 25.4.3.1 Promise(executor)
		  PromiseConstructor = function Promise(executor) {
		    anInstance(this, PromisePrototype);
		    aCallable(executor);
		    call(Internal, this);
		    var state = getInternalPromiseState(this);
		    try {
		      executor(bind(internalResolve, state), bind(internalReject, state));
		    } catch (error) {
		      internalReject(state, error);
		    }
		  };

		  PromisePrototype = PromiseConstructor.prototype;

		  // eslint-disable-next-line no-unused-vars -- required for `.length`
		  Internal = function Promise(executor) {
		    setInternalState(this, {
		      type: PROMISE,
		      done: false,
		      notified: false,
		      parent: false,
		      reactions: new Queue(),
		      rejection: false,
		      state: PENDING,
		      value: null
		    });
		  };

		  // `Promise.prototype.then` method
		  // https://tc39.es/ecma262/#sec-promise.prototype.then
		  Internal.prototype = defineBuiltIn(PromisePrototype, 'then', function then(onFulfilled, onRejected) {
		    var state = getInternalPromiseState(this);
		    var reaction = newPromiseCapability(speciesConstructor(this, PromiseConstructor));
		    state.parent = true;
		    reaction.ok = isCallable(onFulfilled) ? onFulfilled : true;
		    reaction.fail = isCallable(onRejected) && onRejected;
		    reaction.domain = IS_NODE ? process.domain : undefined;
		    if (state.state === PENDING) state.reactions.add(reaction);
		    else microtask(function () {
		      callReaction(reaction, state);
		    });
		    return reaction.promise;
		  });

		  OwnPromiseCapability = function () {
		    var promise = new Internal();
		    var state = getInternalPromiseState(promise);
		    this.promise = promise;
		    this.resolve = bind(internalResolve, state);
		    this.reject = bind(internalReject, state);
		  };

		  newPromiseCapabilityModule.f = newPromiseCapability = function (C) {
		    return C === PromiseConstructor || C === PromiseWrapper
		      ? new OwnPromiseCapability(C)
		      : newGenericPromiseCapability(C);
		  };

		  if (!IS_PURE && isCallable(NativePromiseConstructor) && NativePromisePrototype !== Object.prototype) {
		    nativeThen = NativePromisePrototype.then;

		    if (!NATIVE_PROMISE_SUBCLASSING) {
		      // make `Promise#then` return a polyfilled `Promise` for native promise-based APIs
		      defineBuiltIn(NativePromisePrototype, 'then', function then(onFulfilled, onRejected) {
		        var that = this;
		        return new PromiseConstructor(function (resolve, reject) {
		          call(nativeThen, that, resolve, reject);
		        }).then(onFulfilled, onRejected);
		      // https://github.com/zloirock/core-js/issues/640
		      }, { unsafe: true });
		    }

		    // make `.constructor === Promise` work for native promise-based APIs
		    try {
		      delete NativePromisePrototype.constructor;
		    } catch (error) { /* empty */ }

		    // make `instanceof Promise` work for native promise-based APIs
		    if (setPrototypeOf) {
		      setPrototypeOf(NativePromisePrototype, PromisePrototype);
		    }
		  }
		}

		// `Promise` constructor
		// https://tc39.es/ecma262/#sec-promise-executor
		$({ global: true, constructor: true, wrap: true, forced: FORCED_PROMISE_CONSTRUCTOR }, {
		  Promise: PromiseConstructor
		});

		setToStringTag(PromiseConstructor, PROMISE, false, true);
		setSpecies(PROMISE);
		return es_promise_constructor;
	}

	var es_promise_all = {};

	var checkCorrectnessOfIteration;
	var hasRequiredCheckCorrectnessOfIteration;

	function requireCheckCorrectnessOfIteration () {
		if (hasRequiredCheckCorrectnessOfIteration) return checkCorrectnessOfIteration;
		hasRequiredCheckCorrectnessOfIteration = 1;
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var ITERATOR = wellKnownSymbol('iterator');
		var SAFE_CLOSING = false;

		try {
		  var called = 0;
		  var iteratorWithReturn = {
		    next: function () {
		      return { done: !!called++ };
		    },
		    'return': function () {
		      SAFE_CLOSING = true;
		    }
		  };
		  iteratorWithReturn[ITERATOR] = function () {
		    return this;
		  };
		  // eslint-disable-next-line es/no-array-from, no-throw-literal -- required for testing
		  Array.from(iteratorWithReturn, function () { throw 2; });
		} catch (error) { /* empty */ }

		checkCorrectnessOfIteration = function (exec, SKIP_CLOSING) {
		  try {
		    if (!SKIP_CLOSING && !SAFE_CLOSING) return false;
		  } catch (error) { return false; } // workaround of old WebKit + `eval` bug
		  var ITERATION_SUPPORT = false;
		  try {
		    var object = {};
		    object[ITERATOR] = function () {
		      return {
		        next: function () {
		          return { done: ITERATION_SUPPORT = true };
		        }
		      };
		    };
		    exec(object);
		  } catch (error) { /* empty */ }
		  return ITERATION_SUPPORT;
		};
		return checkCorrectnessOfIteration;
	}

	var promiseStaticsIncorrectIteration;
	var hasRequiredPromiseStaticsIncorrectIteration;

	function requirePromiseStaticsIncorrectIteration () {
		if (hasRequiredPromiseStaticsIncorrectIteration) return promiseStaticsIncorrectIteration;
		hasRequiredPromiseStaticsIncorrectIteration = 1;
		var NativePromiseConstructor = /*@__PURE__*/ requirePromiseNativeConstructor();
		var checkCorrectnessOfIteration = /*@__PURE__*/ requireCheckCorrectnessOfIteration();
		var FORCED_PROMISE_CONSTRUCTOR = /*@__PURE__*/ requirePromiseConstructorDetection().CONSTRUCTOR;

		promiseStaticsIncorrectIteration = FORCED_PROMISE_CONSTRUCTOR || !checkCorrectnessOfIteration(function (iterable) {
		  NativePromiseConstructor.all(iterable).then(undefined, function () { /* empty */ });
		});
		return promiseStaticsIncorrectIteration;
	}

	var hasRequiredEs_promise_all;

	function requireEs_promise_all () {
		if (hasRequiredEs_promise_all) return es_promise_all;
		hasRequiredEs_promise_all = 1;
		var $ = /*@__PURE__*/ require_export();
		var call = /*@__PURE__*/ requireFunctionCall();
		var aCallable = /*@__PURE__*/ requireACallable();
		var newPromiseCapabilityModule = /*@__PURE__*/ requireNewPromiseCapability();
		var perform = /*@__PURE__*/ requirePerform();
		var iterate = /*@__PURE__*/ requireIterate();
		var PROMISE_STATICS_INCORRECT_ITERATION = /*@__PURE__*/ requirePromiseStaticsIncorrectIteration();

		// `Promise.all` method
		// https://tc39.es/ecma262/#sec-promise.all
		$({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
		  all: function all(iterable) {
		    var C = this;
		    var capability = newPromiseCapabilityModule.f(C);
		    var resolve = capability.resolve;
		    var reject = capability.reject;
		    var result = perform(function () {
		      var $promiseResolve = aCallable(C.resolve);
		      var values = [];
		      var counter = 0;
		      var remaining = 1;
		      iterate(iterable, function (promise) {
		        var index = counter++;
		        var alreadyCalled = false;
		        remaining++;
		        call($promiseResolve, C, promise).then(function (value) {
		          if (alreadyCalled) return;
		          alreadyCalled = true;
		          values[index] = value;
		          --remaining || resolve(values);
		        }, reject);
		      });
		      --remaining || resolve(values);
		    });
		    if (result.error) reject(result.value);
		    return capability.promise;
		  }
		});
		return es_promise_all;
	}

	var es_promise_catch = {};

	var hasRequiredEs_promise_catch;

	function requireEs_promise_catch () {
		if (hasRequiredEs_promise_catch) return es_promise_catch;
		hasRequiredEs_promise_catch = 1;
		var $ = /*@__PURE__*/ require_export();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var FORCED_PROMISE_CONSTRUCTOR = /*@__PURE__*/ requirePromiseConstructorDetection().CONSTRUCTOR;
		var NativePromiseConstructor = /*@__PURE__*/ requirePromiseNativeConstructor();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();

		var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;

		// `Promise.prototype.catch` method
		// https://tc39.es/ecma262/#sec-promise.prototype.catch
		$({ target: 'Promise', proto: true, forced: FORCED_PROMISE_CONSTRUCTOR, real: true }, {
		  'catch': function (onRejected) {
		    return this.then(undefined, onRejected);
		  }
		});

		// makes sure that native promise-based APIs `Promise#catch` properly works with patched `Promise#then`
		if (!IS_PURE && isCallable(NativePromiseConstructor)) {
		  var method = getBuiltIn('Promise').prototype['catch'];
		  if (NativePromisePrototype['catch'] !== method) {
		    defineBuiltIn(NativePromisePrototype, 'catch', method, { unsafe: true });
		  }
		}
		return es_promise_catch;
	}

	var es_promise_race = {};

	var hasRequiredEs_promise_race;

	function requireEs_promise_race () {
		if (hasRequiredEs_promise_race) return es_promise_race;
		hasRequiredEs_promise_race = 1;
		var $ = /*@__PURE__*/ require_export();
		var call = /*@__PURE__*/ requireFunctionCall();
		var aCallable = /*@__PURE__*/ requireACallable();
		var newPromiseCapabilityModule = /*@__PURE__*/ requireNewPromiseCapability();
		var perform = /*@__PURE__*/ requirePerform();
		var iterate = /*@__PURE__*/ requireIterate();
		var PROMISE_STATICS_INCORRECT_ITERATION = /*@__PURE__*/ requirePromiseStaticsIncorrectIteration();

		// `Promise.race` method
		// https://tc39.es/ecma262/#sec-promise.race
		$({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
		  race: function race(iterable) {
		    var C = this;
		    var capability = newPromiseCapabilityModule.f(C);
		    var reject = capability.reject;
		    var result = perform(function () {
		      var $promiseResolve = aCallable(C.resolve);
		      iterate(iterable, function (promise) {
		        call($promiseResolve, C, promise).then(capability.resolve, reject);
		      });
		    });
		    if (result.error) reject(result.value);
		    return capability.promise;
		  }
		});
		return es_promise_race;
	}

	var es_promise_reject = {};

	var hasRequiredEs_promise_reject;

	function requireEs_promise_reject () {
		if (hasRequiredEs_promise_reject) return es_promise_reject;
		hasRequiredEs_promise_reject = 1;
		var $ = /*@__PURE__*/ require_export();
		var newPromiseCapabilityModule = /*@__PURE__*/ requireNewPromiseCapability();
		var FORCED_PROMISE_CONSTRUCTOR = /*@__PURE__*/ requirePromiseConstructorDetection().CONSTRUCTOR;

		// `Promise.reject` method
		// https://tc39.es/ecma262/#sec-promise.reject
		$({ target: 'Promise', stat: true, forced: FORCED_PROMISE_CONSTRUCTOR }, {
		  reject: function reject(r) {
		    var capability = newPromiseCapabilityModule.f(this);
		    var capabilityReject = capability.reject;
		    capabilityReject(r);
		    return capability.promise;
		  }
		});
		return es_promise_reject;
	}

	var es_promise_resolve = {};

	var promiseResolve;
	var hasRequiredPromiseResolve;

	function requirePromiseResolve () {
		if (hasRequiredPromiseResolve) return promiseResolve;
		hasRequiredPromiseResolve = 1;
		var anObject = /*@__PURE__*/ requireAnObject();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var newPromiseCapability = /*@__PURE__*/ requireNewPromiseCapability();

		promiseResolve = function (C, x) {
		  anObject(C);
		  if (isObject(x) && x.constructor === C) return x;
		  var promiseCapability = newPromiseCapability.f(C);
		  var resolve = promiseCapability.resolve;
		  resolve(x);
		  return promiseCapability.promise;
		};
		return promiseResolve;
	}

	var hasRequiredEs_promise_resolve;

	function requireEs_promise_resolve () {
		if (hasRequiredEs_promise_resolve) return es_promise_resolve;
		hasRequiredEs_promise_resolve = 1;
		var $ = /*@__PURE__*/ require_export();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var NativePromiseConstructor = /*@__PURE__*/ requirePromiseNativeConstructor();
		var FORCED_PROMISE_CONSTRUCTOR = /*@__PURE__*/ requirePromiseConstructorDetection().CONSTRUCTOR;
		var promiseResolve = /*@__PURE__*/ requirePromiseResolve();

		var PromiseConstructorWrapper = getBuiltIn('Promise');
		var CHECK_WRAPPER = IS_PURE && !FORCED_PROMISE_CONSTRUCTOR;

		// `Promise.resolve` method
		// https://tc39.es/ecma262/#sec-promise.resolve
		$({ target: 'Promise', stat: true, forced: IS_PURE || FORCED_PROMISE_CONSTRUCTOR }, {
		  resolve: function resolve(x) {
		    return promiseResolve(CHECK_WRAPPER && this === PromiseConstructorWrapper ? NativePromiseConstructor : this, x);
		  }
		});
		return es_promise_resolve;
	}

	var hasRequiredEs_promise;

	function requireEs_promise () {
		if (hasRequiredEs_promise) return es_promise;
		hasRequiredEs_promise = 1;
		// TODO: Remove this module from `core-js@4` since it's split to modules listed below
		requireEs_promise_constructor();
		requireEs_promise_all();
		requireEs_promise_catch();
		requireEs_promise_race();
		requireEs_promise_reject();
		requireEs_promise_resolve();
		return es_promise;
	}

	var es_promise_allSettled = {};

	var hasRequiredEs_promise_allSettled;

	function requireEs_promise_allSettled () {
		if (hasRequiredEs_promise_allSettled) return es_promise_allSettled;
		hasRequiredEs_promise_allSettled = 1;
		var $ = /*@__PURE__*/ require_export();
		var call = /*@__PURE__*/ requireFunctionCall();
		var aCallable = /*@__PURE__*/ requireACallable();
		var newPromiseCapabilityModule = /*@__PURE__*/ requireNewPromiseCapability();
		var perform = /*@__PURE__*/ requirePerform();
		var iterate = /*@__PURE__*/ requireIterate();
		var PROMISE_STATICS_INCORRECT_ITERATION = /*@__PURE__*/ requirePromiseStaticsIncorrectIteration();

		// `Promise.allSettled` method
		// https://tc39.es/ecma262/#sec-promise.allsettled
		$({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
		  allSettled: function allSettled(iterable) {
		    var C = this;
		    var capability = newPromiseCapabilityModule.f(C);
		    var resolve = capability.resolve;
		    var reject = capability.reject;
		    var result = perform(function () {
		      var promiseResolve = aCallable(C.resolve);
		      var values = [];
		      var counter = 0;
		      var remaining = 1;
		      iterate(iterable, function (promise) {
		        var index = counter++;
		        var alreadyCalled = false;
		        remaining++;
		        call(promiseResolve, C, promise).then(function (value) {
		          if (alreadyCalled) return;
		          alreadyCalled = true;
		          values[index] = { status: 'fulfilled', value: value };
		          --remaining || resolve(values);
		        }, function (error) {
		          if (alreadyCalled) return;
		          alreadyCalled = true;
		          values[index] = { status: 'rejected', reason: error };
		          --remaining || resolve(values);
		        });
		      });
		      --remaining || resolve(values);
		    });
		    if (result.error) reject(result.value);
		    return capability.promise;
		  }
		});
		return es_promise_allSettled;
	}

	var es_promise_any = {};

	var hasRequiredEs_promise_any;

	function requireEs_promise_any () {
		if (hasRequiredEs_promise_any) return es_promise_any;
		hasRequiredEs_promise_any = 1;
		var $ = /*@__PURE__*/ require_export();
		var call = /*@__PURE__*/ requireFunctionCall();
		var aCallable = /*@__PURE__*/ requireACallable();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var newPromiseCapabilityModule = /*@__PURE__*/ requireNewPromiseCapability();
		var perform = /*@__PURE__*/ requirePerform();
		var iterate = /*@__PURE__*/ requireIterate();
		var PROMISE_STATICS_INCORRECT_ITERATION = /*@__PURE__*/ requirePromiseStaticsIncorrectIteration();

		var PROMISE_ANY_ERROR = 'No one promise resolved';

		// `Promise.any` method
		// https://tc39.es/ecma262/#sec-promise.any
		$({ target: 'Promise', stat: true, forced: PROMISE_STATICS_INCORRECT_ITERATION }, {
		  any: function any(iterable) {
		    var C = this;
		    var AggregateError = getBuiltIn('AggregateError');
		    var capability = newPromiseCapabilityModule.f(C);
		    var resolve = capability.resolve;
		    var reject = capability.reject;
		    var result = perform(function () {
		      var promiseResolve = aCallable(C.resolve);
		      var errors = [];
		      var counter = 0;
		      var remaining = 1;
		      var alreadyResolved = false;
		      iterate(iterable, function (promise) {
		        var index = counter++;
		        var alreadyRejected = false;
		        remaining++;
		        call(promiseResolve, C, promise).then(function (value) {
		          if (alreadyRejected || alreadyResolved) return;
		          alreadyResolved = true;
		          resolve(value);
		        }, function (error) {
		          if (alreadyRejected || alreadyResolved) return;
		          alreadyRejected = true;
		          errors[index] = error;
		          --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
		        });
		      });
		      --remaining || reject(new AggregateError(errors, PROMISE_ANY_ERROR));
		    });
		    if (result.error) reject(result.value);
		    return capability.promise;
		  }
		});
		return es_promise_any;
	}

	var es_promise_try = {};

	var hasRequiredEs_promise_try;

	function requireEs_promise_try () {
		if (hasRequiredEs_promise_try) return es_promise_try;
		hasRequiredEs_promise_try = 1;
		var $ = /*@__PURE__*/ require_export();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var apply = /*@__PURE__*/ requireFunctionApply();
		var slice = /*@__PURE__*/ requireArraySlice();
		var newPromiseCapabilityModule = /*@__PURE__*/ requireNewPromiseCapability();
		var aCallable = /*@__PURE__*/ requireACallable();
		var perform = /*@__PURE__*/ requirePerform();

		var Promise = globalThis.Promise;

		var ACCEPT_ARGUMENTS = false;
		// Avoiding the use of polyfills of the previous iteration of this proposal
		// that does not accept arguments of the callback
		var FORCED = !Promise || !Promise['try'] || perform(function () {
		  Promise['try'](function (argument) {
		    ACCEPT_ARGUMENTS = argument === 8;
		  }, 8);
		}).error || !ACCEPT_ARGUMENTS;

		// `Promise.try` method
		// https://tc39.es/ecma262/#sec-promise.try
		$({ target: 'Promise', stat: true, forced: FORCED }, {
		  'try': function (callbackfn /* , ...args */) {
		    var args = arguments.length > 1 ? slice(arguments, 1) : [];
		    var promiseCapability = newPromiseCapabilityModule.f(this);
		    var result = perform(function () {
		      return apply(aCallable(callbackfn), undefined, args);
		    });
		    (result.error ? promiseCapability.reject : promiseCapability.resolve)(result.value);
		    return promiseCapability.promise;
		  }
		});
		return es_promise_try;
	}

	var es_promise_withResolvers = {};

	var hasRequiredEs_promise_withResolvers;

	function requireEs_promise_withResolvers () {
		if (hasRequiredEs_promise_withResolvers) return es_promise_withResolvers;
		hasRequiredEs_promise_withResolvers = 1;
		var $ = /*@__PURE__*/ require_export();
		var newPromiseCapabilityModule = /*@__PURE__*/ requireNewPromiseCapability();

		// `Promise.withResolvers` method
		// https://tc39.es/ecma262/#sec-promise.withResolvers
		$({ target: 'Promise', stat: true }, {
		  withResolvers: function withResolvers() {
		    var promiseCapability = newPromiseCapabilityModule.f(this);
		    return {
		      promise: promiseCapability.promise,
		      resolve: promiseCapability.resolve,
		      reject: promiseCapability.reject
		    };
		  }
		});
		return es_promise_withResolvers;
	}

	var es_promise_finally = {};

	var hasRequiredEs_promise_finally;

	function requireEs_promise_finally () {
		if (hasRequiredEs_promise_finally) return es_promise_finally;
		hasRequiredEs_promise_finally = 1;
		var $ = /*@__PURE__*/ require_export();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var NativePromiseConstructor = /*@__PURE__*/ requirePromiseNativeConstructor();
		var fails = /*@__PURE__*/ requireFails();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var speciesConstructor = /*@__PURE__*/ requireSpeciesConstructor();
		var promiseResolve = /*@__PURE__*/ requirePromiseResolve();
		var defineBuiltIn = /*@__PURE__*/ requireDefineBuiltIn();

		var NativePromisePrototype = NativePromiseConstructor && NativePromiseConstructor.prototype;

		// Safari bug https://bugs.webkit.org/show_bug.cgi?id=200829
		var NON_GENERIC = !!NativePromiseConstructor && fails(function () {
		  // eslint-disable-next-line unicorn/no-thenable -- required for testing
		  NativePromisePrototype['finally'].call({ then: function () { /* empty */ } }, function () { /* empty */ });
		});

		// `Promise.prototype.finally` method
		// https://tc39.es/ecma262/#sec-promise.prototype.finally
		$({ target: 'Promise', proto: true, real: true, forced: NON_GENERIC }, {
		  'finally': function (onFinally) {
		    var C = speciesConstructor(this, getBuiltIn('Promise'));
		    var isFunction = isCallable(onFinally);
		    return this.then(
		      isFunction ? function (x) {
		        return promiseResolve(C, onFinally()).then(function () { return x; });
		      } : onFinally,
		      isFunction ? function (e) {
		        return promiseResolve(C, onFinally()).then(function () { throw e; });
		      } : onFinally
		    );
		  }
		});

		// makes sure that native promise-based APIs `Promise#finally` properly works with patched `Promise#then`
		if (!IS_PURE && isCallable(NativePromiseConstructor)) {
		  var method = getBuiltIn('Promise').prototype['finally'];
		  if (NativePromisePrototype['finally'] !== method) {
		    defineBuiltIn(NativePromisePrototype, 'finally', method, { unsafe: true });
		  }
		}
		return es_promise_finally;
	}

	var promise$5;
	var hasRequiredPromise$5;

	function requirePromise$5 () {
		if (hasRequiredPromise$5) return promise$5;
		hasRequiredPromise$5 = 1;
		requireEs_aggregateError();
		requireEs_array_iterator();
		requireEs_promise();
		requireEs_promise_allSettled();
		requireEs_promise_any();
		requireEs_promise_try();
		requireEs_promise_withResolvers();
		requireEs_promise_finally();
		requireEs_string_iterator();
		var path = /*@__PURE__*/ requirePath$1();

		promise$5 = path.Promise;
		return promise$5;
	}

	var promise$4;
	var hasRequiredPromise$4;

	function requirePromise$4 () {
		if (hasRequiredPromise$4) return promise$4;
		hasRequiredPromise$4 = 1;
		var parent = /*@__PURE__*/ requirePromise$5();
		requireWeb_domCollections_iterator();

		promise$4 = parent;
		return promise$4;
	}

	var promise$3;
	var hasRequiredPromise$3;
	function requirePromise$3() {
	  if (hasRequiredPromise$3) return promise$3;
	  hasRequiredPromise$3 = 1;
	  promise$3 = /*@__PURE__*/requirePromise$4();
	  return promise$3;
	}

	var promiseExports$1 = requirePromise$3();
	var _Promise$1 = /*@__PURE__*/getDefaultExportFromCjs(promiseExports$1);

	var web_timers = {};

	var web_setInterval = {};

	var schedulersFix;
	var hasRequiredSchedulersFix;

	function requireSchedulersFix () {
		if (hasRequiredSchedulersFix) return schedulersFix;
		hasRequiredSchedulersFix = 1;
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var apply = /*@__PURE__*/ requireFunctionApply();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var ENVIRONMENT = /*@__PURE__*/ requireEnvironment();
		var USER_AGENT = /*@__PURE__*/ requireEnvironmentUserAgent();
		var arraySlice = /*@__PURE__*/ requireArraySlice();
		var validateArgumentsLength = /*@__PURE__*/ requireValidateArgumentsLength();

		var Function = globalThis.Function;
		// dirty IE9- and Bun 0.3.0- checks
		var WRAP = /MSIE .\./.test(USER_AGENT) || ENVIRONMENT === 'BUN' && (function () {
		  var version = globalThis.Bun.version.split('.');
		  return version.length < 3 || version[0] === '0' && (version[1] < 3 || version[1] === '3' && version[2] === '0');
		})();

		// IE9- / Bun 0.3.0- setTimeout / setInterval / setImmediate additional parameters fix
		// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers
		// https://github.com/oven-sh/bun/issues/1633
		schedulersFix = function (scheduler, hasTimeArg) {
		  var firstParamIndex = hasTimeArg ? 2 : 1;
		  return WRAP ? function (handler, timeout /* , ...arguments */) {
		    var boundArgs = validateArgumentsLength(arguments.length, 1) > firstParamIndex;
		    var fn = isCallable(handler) ? handler : Function(handler);
		    var params = boundArgs ? arraySlice(arguments, firstParamIndex) : [];
		    var callback = boundArgs ? function () {
		      apply(fn, this, params);
		    } : fn;
		    return hasTimeArg ? scheduler(callback, timeout) : scheduler(callback);
		  } : scheduler;
		};
		return schedulersFix;
	}

	var hasRequiredWeb_setInterval;

	function requireWeb_setInterval () {
		if (hasRequiredWeb_setInterval) return web_setInterval;
		hasRequiredWeb_setInterval = 1;
		var $ = /*@__PURE__*/ require_export();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var schedulersFix = /*@__PURE__*/ requireSchedulersFix();

		var setInterval = schedulersFix(globalThis.setInterval, true);

		// Bun / IE9- setInterval additional parameters fix
		// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
		$({ global: true, bind: true, forced: globalThis.setInterval !== setInterval }, {
		  setInterval: setInterval
		});
		return web_setInterval;
	}

	var web_setTimeout = {};

	var hasRequiredWeb_setTimeout;

	function requireWeb_setTimeout () {
		if (hasRequiredWeb_setTimeout) return web_setTimeout;
		hasRequiredWeb_setTimeout = 1;
		var $ = /*@__PURE__*/ require_export();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var schedulersFix = /*@__PURE__*/ requireSchedulersFix();

		var setTimeout = schedulersFix(globalThis.setTimeout, true);

		// Bun / IE9- setTimeout additional parameters fix
		// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
		$({ global: true, bind: true, forced: globalThis.setTimeout !== setTimeout }, {
		  setTimeout: setTimeout
		});
		return web_setTimeout;
	}

	var hasRequiredWeb_timers;

	function requireWeb_timers () {
		if (hasRequiredWeb_timers) return web_timers;
		hasRequiredWeb_timers = 1;
		// TODO: Remove this module from `core-js@4` since it's split to modules listed below
		requireWeb_setInterval();
		requireWeb_setTimeout();
		return web_timers;
	}

	var setInterval$1;
	var hasRequiredSetInterval$1;

	function requireSetInterval$1 () {
		if (hasRequiredSetInterval$1) return setInterval$1;
		hasRequiredSetInterval$1 = 1;
		requireWeb_timers();
		var path = /*@__PURE__*/ requirePath$1();

		setInterval$1 = path.setInterval;
		return setInterval$1;
	}

	var setInterval;
	var hasRequiredSetInterval;
	function requireSetInterval() {
	  if (hasRequiredSetInterval) return setInterval;
	  hasRequiredSetInterval = 1;
	  setInterval = /*@__PURE__*/requireSetInterval$1();
	  return setInterval;
	}

	var setIntervalExports = requireSetInterval();
	var _setInterval = /*@__PURE__*/getDefaultExportFromCjs(setIntervalExports);

	var es_date_now = {};

	var hasRequiredEs_date_now;

	function requireEs_date_now () {
		if (hasRequiredEs_date_now) return es_date_now;
		hasRequiredEs_date_now = 1;
		// TODO: Remove from `core-js@4`
		var $ = /*@__PURE__*/ require_export();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();

		var $Date = Date;
		var thisTimeValue = uncurryThis($Date.prototype.getTime);

		// `Date.now` method
		// https://tc39.es/ecma262/#sec-date.now
		$({ target: 'Date', stat: true }, {
		  now: function now() {
		    return thisTimeValue(new $Date());
		  }
		});
		return es_date_now;
	}

	var now$2;
	var hasRequiredNow$2;

	function requireNow$2 () {
		if (hasRequiredNow$2) return now$2;
		hasRequiredNow$2 = 1;
		requireEs_date_now();
		var path = /*@__PURE__*/ requirePath$1();

		now$2 = path.Date.now;
		return now$2;
	}

	var now$1;
	var hasRequiredNow$1;

	function requireNow$1 () {
		if (hasRequiredNow$1) return now$1;
		hasRequiredNow$1 = 1;
		var parent = /*@__PURE__*/ requireNow$2();

		now$1 = parent;
		return now$1;
	}

	var now;
	var hasRequiredNow;
	function requireNow() {
	  if (hasRequiredNow) return now;
	  hasRequiredNow = 1;
	  now = /*@__PURE__*/requireNow$1();
	  return now;
	}

	var nowExports = requireNow();
	var _Date$now = /*@__PURE__*/getDefaultExportFromCjs(nowExports);

	var es_object_assign = {};

	var hasRequiredEs_object_assign;

	function requireEs_object_assign () {
		if (hasRequiredEs_object_assign) return es_object_assign;
		hasRequiredEs_object_assign = 1;
		var $ = /*@__PURE__*/ require_export();
		var assign = /*@__PURE__*/ requireObjectAssign();

		// `Object.assign` method
		// https://tc39.es/ecma262/#sec-object.assign
		// eslint-disable-next-line es/no-object-assign -- required for testing
		$({ target: 'Object', stat: true, arity: 2, forced: Object.assign !== assign }, {
		  assign: assign
		});
		return es_object_assign;
	}

	var assign$2;
	var hasRequiredAssign$2;

	function requireAssign$2 () {
		if (hasRequiredAssign$2) return assign$2;
		hasRequiredAssign$2 = 1;
		requireEs_object_assign();
		var path = /*@__PURE__*/ requirePath$1();

		assign$2 = path.Object.assign;
		return assign$2;
	}

	var assign$1;
	var hasRequiredAssign$1;

	function requireAssign$1 () {
		if (hasRequiredAssign$1) return assign$1;
		hasRequiredAssign$1 = 1;
		var parent = /*@__PURE__*/ requireAssign$2();

		assign$1 = parent;
		return assign$1;
	}

	var assign;
	var hasRequiredAssign;
	function requireAssign() {
	  if (hasRequiredAssign) return assign;
	  hasRequiredAssign = 1;
	  assign = /*@__PURE__*/requireAssign$1();
	  return assign;
	}

	var assignExports = requireAssign();
	var _Object$assign = /*@__PURE__*/getDefaultExportFromCjs(assignExports);

	var symbol;
	var hasRequiredSymbol;
	function requireSymbol() {
	  if (hasRequiredSymbol) return symbol;
	  hasRequiredSymbol = 1;
	  symbol = /*@__PURE__*/requireSymbol$4();
	  return symbol;
	}

	var symbolExports = requireSymbol();
	var _Symbol$1 = /*@__PURE__*/getDefaultExportFromCjs(symbolExports);

	var es_string_startsWith = {};

	var isRegexp;
	var hasRequiredIsRegexp;

	function requireIsRegexp () {
		if (hasRequiredIsRegexp) return isRegexp;
		hasRequiredIsRegexp = 1;
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var classof = /*@__PURE__*/ requireClassofRaw();
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var MATCH = wellKnownSymbol('match');

		// `IsRegExp` abstract operation
		// https://tc39.es/ecma262/#sec-isregexp
		isRegexp = function (it) {
		  var isRegExp;
		  return isObject(it) && ((isRegExp = it[MATCH]) !== undefined ? !!isRegExp : classof(it) === 'RegExp');
		};
		return isRegexp;
	}

	var notARegexp;
	var hasRequiredNotARegexp;

	function requireNotARegexp () {
		if (hasRequiredNotARegexp) return notARegexp;
		hasRequiredNotARegexp = 1;
		var isRegExp = /*@__PURE__*/ requireIsRegexp();

		var $TypeError = TypeError;

		notARegexp = function (it) {
		  if (isRegExp(it)) {
		    throw new $TypeError("The method doesn't accept regular expressions");
		  } return it;
		};
		return notARegexp;
	}

	var correctIsRegexpLogic;
	var hasRequiredCorrectIsRegexpLogic;

	function requireCorrectIsRegexpLogic () {
		if (hasRequiredCorrectIsRegexpLogic) return correctIsRegexpLogic;
		hasRequiredCorrectIsRegexpLogic = 1;
		var wellKnownSymbol = /*@__PURE__*/ requireWellKnownSymbol();

		var MATCH = wellKnownSymbol('match');

		correctIsRegexpLogic = function (METHOD_NAME) {
		  var regexp = /./;
		  try {
		    '/./'[METHOD_NAME](regexp);
		  } catch (error1) {
		    try {
		      regexp[MATCH] = false;
		      return '/./'[METHOD_NAME](regexp);
		    } catch (error2) { /* empty */ }
		  } return false;
		};
		return correctIsRegexpLogic;
	}

	var hasRequiredEs_string_startsWith;

	function requireEs_string_startsWith () {
		if (hasRequiredEs_string_startsWith) return es_string_startsWith;
		hasRequiredEs_string_startsWith = 1;
		var $ = /*@__PURE__*/ require_export();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThisClause();
		var getOwnPropertyDescriptor = /*@__PURE__*/ requireObjectGetOwnPropertyDescriptor().f;
		var toLength = /*@__PURE__*/ requireToLength();
		var toString = /*@__PURE__*/ requireToString();
		var notARegExp = /*@__PURE__*/ requireNotARegexp();
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();
		var correctIsRegExpLogic = /*@__PURE__*/ requireCorrectIsRegexpLogic();
		var IS_PURE = /*@__PURE__*/ requireIsPure();

		var stringSlice = uncurryThis(''.slice);
		var min = Math.min;

		var CORRECT_IS_REGEXP_LOGIC = correctIsRegExpLogic('startsWith');
		// https://github.com/zloirock/core-js/pull/702
		var MDN_POLYFILL_BUG = !IS_PURE && !CORRECT_IS_REGEXP_LOGIC && !!function () {
		  var descriptor = getOwnPropertyDescriptor(String.prototype, 'startsWith');
		  return descriptor && !descriptor.writable;
		}();

		// `String.prototype.startsWith` method
		// https://tc39.es/ecma262/#sec-string.prototype.startswith
		$({ target: 'String', proto: true, forced: !MDN_POLYFILL_BUG && !CORRECT_IS_REGEXP_LOGIC }, {
		  startsWith: function startsWith(searchString /* , position = 0 */) {
		    var that = toString(requireObjectCoercible(this));
		    notARegExp(searchString);
		    var index = toLength(min(arguments.length > 1 ? arguments[1] : undefined, that.length));
		    var search = toString(searchString);
		    return stringSlice(that, index, index + search.length) === search;
		  }
		});
		return es_string_startsWith;
	}

	var startsWith$3;
	var hasRequiredStartsWith$3;

	function requireStartsWith$3 () {
		if (hasRequiredStartsWith$3) return startsWith$3;
		hasRequiredStartsWith$3 = 1;
		requireEs_string_startsWith();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		startsWith$3 = getBuiltInPrototypeMethod('String', 'startsWith');
		return startsWith$3;
	}

	var startsWith$2;
	var hasRequiredStartsWith$2;

	function requireStartsWith$2 () {
		if (hasRequiredStartsWith$2) return startsWith$2;
		hasRequiredStartsWith$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireStartsWith$3();

		var StringPrototype = String.prototype;

		startsWith$2 = function (it) {
		  var own = it.startsWith;
		  return typeof it == 'string' || it === StringPrototype
		    || (isPrototypeOf(StringPrototype, it) && own === StringPrototype.startsWith) ? method : own;
		};
		return startsWith$2;
	}

	var startsWith$1;
	var hasRequiredStartsWith$1;

	function requireStartsWith$1 () {
		if (hasRequiredStartsWith$1) return startsWith$1;
		hasRequiredStartsWith$1 = 1;
		var parent = /*@__PURE__*/ requireStartsWith$2();

		startsWith$1 = parent;
		return startsWith$1;
	}

	var startsWith;
	var hasRequiredStartsWith;
	function requireStartsWith() {
	  if (hasRequiredStartsWith) return startsWith;
	  hasRequiredStartsWith = 1;
	  startsWith = /*@__PURE__*/requireStartsWith$1();
	  return startsWith;
	}

	var startsWithExports = requireStartsWith();
	var _startsWithInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(startsWithExports);

	var es_array_map = {};

	var hasRequiredEs_array_map;

	function requireEs_array_map () {
		if (hasRequiredEs_array_map) return es_array_map;
		hasRequiredEs_array_map = 1;
		var $ = /*@__PURE__*/ require_export();
		var $map = /*@__PURE__*/ requireArrayIteration().map;
		var arrayMethodHasSpeciesSupport = /*@__PURE__*/ requireArrayMethodHasSpeciesSupport();

		var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('map');

		// `Array.prototype.map` method
		// https://tc39.es/ecma262/#sec-array.prototype.map
		// with adding support of @@species
		$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
		  map: function map(callbackfn /* , thisArg */) {
		    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
		  }
		});
		return es_array_map;
	}

	var map$9;
	var hasRequiredMap$9;

	function requireMap$9 () {
		if (hasRequiredMap$9) return map$9;
		hasRequiredMap$9 = 1;
		requireEs_array_map();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		map$9 = getBuiltInPrototypeMethod('Array', 'map');
		return map$9;
	}

	var map$8;
	var hasRequiredMap$8;

	function requireMap$8 () {
		if (hasRequiredMap$8) return map$8;
		hasRequiredMap$8 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireMap$9();

		var ArrayPrototype = Array.prototype;

		map$8 = function (it) {
		  var own = it.map;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.map) ? method : own;
		};
		return map$8;
	}

	var map$7;
	var hasRequiredMap$7;

	function requireMap$7 () {
		if (hasRequiredMap$7) return map$7;
		hasRequiredMap$7 = 1;
		var parent = /*@__PURE__*/ requireMap$8();

		map$7 = parent;
		return map$7;
	}

	var map$6;
	var hasRequiredMap$6;
	function requireMap$6() {
	  if (hasRequiredMap$6) return map$6;
	  hasRequiredMap$6 = 1;
	  map$6 = /*@__PURE__*/requireMap$7();
	  return map$6;
	}

	var mapExports$2 = requireMap$6();
	var _mapInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(mapExports$2);

	var build$p = {};

	var es_object_setPrototypeOf = {};

	var hasRequiredEs_object_setPrototypeOf;

	function requireEs_object_setPrototypeOf () {
		if (hasRequiredEs_object_setPrototypeOf) return es_object_setPrototypeOf;
		hasRequiredEs_object_setPrototypeOf = 1;
		var $ = /*@__PURE__*/ require_export();
		var setPrototypeOf = /*@__PURE__*/ requireObjectSetPrototypeOf();

		// `Object.setPrototypeOf` method
		// https://tc39.es/ecma262/#sec-object.setprototypeof
		$({ target: 'Object', stat: true }, {
		  setPrototypeOf: setPrototypeOf
		});
		return es_object_setPrototypeOf;
	}

	var setPrototypeOf$5;
	var hasRequiredSetPrototypeOf$5;

	function requireSetPrototypeOf$5 () {
		if (hasRequiredSetPrototypeOf$5) return setPrototypeOf$5;
		hasRequiredSetPrototypeOf$5 = 1;
		requireEs_object_setPrototypeOf();
		var path = /*@__PURE__*/ requirePath$1();

		setPrototypeOf$5 = path.Object.setPrototypeOf;
		return setPrototypeOf$5;
	}

	var setPrototypeOf$4;
	var hasRequiredSetPrototypeOf$4;

	function requireSetPrototypeOf$4 () {
		if (hasRequiredSetPrototypeOf$4) return setPrototypeOf$4;
		hasRequiredSetPrototypeOf$4 = 1;
		var parent = /*@__PURE__*/ requireSetPrototypeOf$5();

		setPrototypeOf$4 = parent;
		return setPrototypeOf$4;
	}

	var setPrototypeOf$3;
	var hasRequiredSetPrototypeOf$3;
	function requireSetPrototypeOf$3() {
	  if (hasRequiredSetPrototypeOf$3) return setPrototypeOf$3;
	  hasRequiredSetPrototypeOf$3 = 1;
	  setPrototypeOf$3 = /*@__PURE__*/requireSetPrototypeOf$4();
	  return setPrototypeOf$3;
	}

	var setPrototypeOfExports$1 = requireSetPrototypeOf$3();
	var _Object$setPrototypeOf$1 = /*@__PURE__*/getDefaultExportFromCjs(setPrototypeOfExports$1);

	var es_object_create = {};

	var hasRequiredEs_object_create;

	function requireEs_object_create () {
		if (hasRequiredEs_object_create) return es_object_create;
		hasRequiredEs_object_create = 1;
		// TODO: Remove from `core-js@4`
		var $ = /*@__PURE__*/ require_export();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var create = /*@__PURE__*/ requireObjectCreate();

		// `Object.create` method
		// https://tc39.es/ecma262/#sec-object.create
		$({ target: 'Object', stat: true, sham: !DESCRIPTORS }, {
		  create: create
		});
		return es_object_create;
	}

	var create$5;
	var hasRequiredCreate$5;

	function requireCreate$5 () {
		if (hasRequiredCreate$5) return create$5;
		hasRequiredCreate$5 = 1;
		requireEs_object_create();
		var path = /*@__PURE__*/ requirePath$1();

		var Object = path.Object;

		create$5 = function create(P, D) {
		  return Object.create(P, D);
		};
		return create$5;
	}

	var create$4;
	var hasRequiredCreate$4;

	function requireCreate$4 () {
		if (hasRequiredCreate$4) return create$4;
		hasRequiredCreate$4 = 1;
		var parent = /*@__PURE__*/ requireCreate$5();

		create$4 = parent;
		return create$4;
	}

	var create$3;
	var hasRequiredCreate$3;
	function requireCreate$3() {
	  if (hasRequiredCreate$3) return create$3;
	  hasRequiredCreate$3 = 1;
	  create$3 = /*@__PURE__*/requireCreate$4();
	  return create$3;
	}

	var createExports$1 = requireCreate$3();
	var _Object$create$1 = /*@__PURE__*/getDefaultExportFromCjs(createExports$1);

	var iterator;
	var hasRequiredIterator;
	function requireIterator() {
	  if (hasRequiredIterator) return iterator;
	  hasRequiredIterator = 1;
	  iterator = /*@__PURE__*/requireIterator$4();
	  return iterator;
	}

	var iteratorExports = requireIterator();
	var _Symbol$iterator = /*@__PURE__*/getDefaultExportFromCjs(iteratorExports);

	var getIteratorMethod_1;
	var hasRequiredGetIteratorMethod$5;

	function requireGetIteratorMethod$5 () {
		if (hasRequiredGetIteratorMethod$5) return getIteratorMethod_1;
		hasRequiredGetIteratorMethod$5 = 1;
		requireEs_array_iterator();
		requireEs_string_iterator();
		var getIteratorMethod = /*@__PURE__*/ requireGetIteratorMethod$6();

		getIteratorMethod_1 = getIteratorMethod;
		return getIteratorMethod_1;
	}

	var getIteratorMethod$4;
	var hasRequiredGetIteratorMethod$4;

	function requireGetIteratorMethod$4 () {
		if (hasRequiredGetIteratorMethod$4) return getIteratorMethod$4;
		hasRequiredGetIteratorMethod$4 = 1;
		var parent = /*@__PURE__*/ requireGetIteratorMethod$5();
		requireWeb_domCollections_iterator();

		getIteratorMethod$4 = parent;
		return getIteratorMethod$4;
	}

	var getIteratorMethod$3;
	var hasRequiredGetIteratorMethod$3;

	function requireGetIteratorMethod$3 () {
		if (hasRequiredGetIteratorMethod$3) return getIteratorMethod$3;
		hasRequiredGetIteratorMethod$3 = 1;
		var parent = /*@__PURE__*/ requireGetIteratorMethod$4();

		getIteratorMethod$3 = parent;
		return getIteratorMethod$3;
	}

	var getIteratorMethod$2;
	var hasRequiredGetIteratorMethod$2;

	function requireGetIteratorMethod$2 () {
		if (hasRequiredGetIteratorMethod$2) return getIteratorMethod$2;
		hasRequiredGetIteratorMethod$2 = 1;
		var parent = /*@__PURE__*/ requireGetIteratorMethod$3();

		getIteratorMethod$2 = parent;
		return getIteratorMethod$2;
	}

	var getIteratorMethod$1;
	var hasRequiredGetIteratorMethod$1;

	function requireGetIteratorMethod$1 () {
		if (hasRequiredGetIteratorMethod$1) return getIteratorMethod$1;
		hasRequiredGetIteratorMethod$1 = 1;
		getIteratorMethod$1 = /*@__PURE__*/ requireGetIteratorMethod$2();
		return getIteratorMethod$1;
	}

	var getIteratorMethod;
	var hasRequiredGetIteratorMethod;
	function requireGetIteratorMethod() {
	  if (hasRequiredGetIteratorMethod) return getIteratorMethod;
	  hasRequiredGetIteratorMethod = 1;
	  getIteratorMethod = /*@__PURE__*/requireGetIteratorMethod$1();
	  return getIteratorMethod;
	}

	var getIteratorMethodExports$1 = requireGetIteratorMethod();
	var _getIteratorMethod$1 = /*@__PURE__*/getDefaultExportFromCjs(getIteratorMethodExports$1);

	var asyncIterator$2;
	var hasRequiredAsyncIterator$2;

	function requireAsyncIterator$2 () {
		if (hasRequiredAsyncIterator$2) return asyncIterator$2;
		hasRequiredAsyncIterator$2 = 1;
		requireEs_symbol_asyncIterator();
		var WrappedWellKnownSymbolModule = /*@__PURE__*/ requireWellKnownSymbolWrapped();

		asyncIterator$2 = WrappedWellKnownSymbolModule.f('asyncIterator');
		return asyncIterator$2;
	}

	var asyncIterator$1;
	var hasRequiredAsyncIterator$1;

	function requireAsyncIterator$1 () {
		if (hasRequiredAsyncIterator$1) return asyncIterator$1;
		hasRequiredAsyncIterator$1 = 1;
		var parent = /*@__PURE__*/ requireAsyncIterator$2();

		asyncIterator$1 = parent;
		return asyncIterator$1;
	}

	var asyncIterator;
	var hasRequiredAsyncIterator;
	function requireAsyncIterator() {
	  if (hasRequiredAsyncIterator) return asyncIterator;
	  hasRequiredAsyncIterator = 1;
	  asyncIterator = /*@__PURE__*/requireAsyncIterator$1();
	  return asyncIterator;
	}

	var asyncIteratorExports = requireAsyncIterator();
	var _Symbol$asyncIterator = /*@__PURE__*/getDefaultExportFromCjs(asyncIteratorExports);

	var getIterator_1;
	var hasRequiredGetIterator$5;

	function requireGetIterator$5 () {
		if (hasRequiredGetIterator$5) return getIterator_1;
		hasRequiredGetIterator$5 = 1;
		requireEs_array_iterator();
		requireEs_string_iterator();
		var getIterator = /*@__PURE__*/ requireGetIterator$6();

		getIterator_1 = getIterator;
		return getIterator_1;
	}

	var getIterator$4;
	var hasRequiredGetIterator$4;

	function requireGetIterator$4 () {
		if (hasRequiredGetIterator$4) return getIterator$4;
		hasRequiredGetIterator$4 = 1;
		var parent = /*@__PURE__*/ requireGetIterator$5();
		requireWeb_domCollections_iterator();

		getIterator$4 = parent;
		return getIterator$4;
	}

	var getIterator$3;
	var hasRequiredGetIterator$3;

	function requireGetIterator$3 () {
		if (hasRequiredGetIterator$3) return getIterator$3;
		hasRequiredGetIterator$3 = 1;
		var parent = /*@__PURE__*/ requireGetIterator$4();

		getIterator$3 = parent;
		return getIterator$3;
	}

	var getIterator$2;
	var hasRequiredGetIterator$2;

	function requireGetIterator$2 () {
		if (hasRequiredGetIterator$2) return getIterator$2;
		hasRequiredGetIterator$2 = 1;
		var parent = /*@__PURE__*/ requireGetIterator$3();

		getIterator$2 = parent;
		return getIterator$2;
	}

	var getIterator$1;
	var hasRequiredGetIterator$1;

	function requireGetIterator$1 () {
		if (hasRequiredGetIterator$1) return getIterator$1;
		hasRequiredGetIterator$1 = 1;
		getIterator$1 = /*@__PURE__*/ requireGetIterator$2();
		return getIterator$1;
	}

	var getIterator;
	var hasRequiredGetIterator;
	function requireGetIterator() {
	  if (hasRequiredGetIterator) return getIterator;
	  hasRequiredGetIterator = 1;
	  getIterator = /*@__PURE__*/requireGetIterator$1();
	  return getIterator;
	}

	var getIteratorExports = requireGetIterator();
	var _getIterator = /*@__PURE__*/getDefaultExportFromCjs(getIteratorExports);

	var es_object_getOwnPropertyNames = {};

	var hasRequiredEs_object_getOwnPropertyNames;

	function requireEs_object_getOwnPropertyNames () {
		if (hasRequiredEs_object_getOwnPropertyNames) return es_object_getOwnPropertyNames;
		hasRequiredEs_object_getOwnPropertyNames = 1;
		var $ = /*@__PURE__*/ require_export();
		var fails = /*@__PURE__*/ requireFails();
		var getOwnPropertyNames = /*@__PURE__*/ requireObjectGetOwnPropertyNamesExternal().f;

		// eslint-disable-next-line es/no-object-getownpropertynames -- required for testing
		var FAILS_ON_PRIMITIVES = fails(function () { return !Object.getOwnPropertyNames(1); });

		// `Object.getOwnPropertyNames` method
		// https://tc39.es/ecma262/#sec-object.getownpropertynames
		$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
		  getOwnPropertyNames: getOwnPropertyNames
		});
		return es_object_getOwnPropertyNames;
	}

	var getOwnPropertyNames$2;
	var hasRequiredGetOwnPropertyNames$2;

	function requireGetOwnPropertyNames$2 () {
		if (hasRequiredGetOwnPropertyNames$2) return getOwnPropertyNames$2;
		hasRequiredGetOwnPropertyNames$2 = 1;
		requireEs_object_getOwnPropertyNames();
		var path = /*@__PURE__*/ requirePath$1();

		var Object = path.Object;

		getOwnPropertyNames$2 = function getOwnPropertyNames(it) {
		  return Object.getOwnPropertyNames(it);
		};
		return getOwnPropertyNames$2;
	}

	var getOwnPropertyNames$1;
	var hasRequiredGetOwnPropertyNames$1;

	function requireGetOwnPropertyNames$1 () {
		if (hasRequiredGetOwnPropertyNames$1) return getOwnPropertyNames$1;
		hasRequiredGetOwnPropertyNames$1 = 1;
		var parent = /*@__PURE__*/ requireGetOwnPropertyNames$2();

		getOwnPropertyNames$1 = parent;
		return getOwnPropertyNames$1;
	}

	var getOwnPropertyNames;
	var hasRequiredGetOwnPropertyNames;
	function requireGetOwnPropertyNames() {
	  if (hasRequiredGetOwnPropertyNames) return getOwnPropertyNames;
	  hasRequiredGetOwnPropertyNames = 1;
	  getOwnPropertyNames = /*@__PURE__*/requireGetOwnPropertyNames$1();
	  return getOwnPropertyNames;
	}

	var getOwnPropertyNamesExports = requireGetOwnPropertyNames();
	var _Object$getOwnPropertyNames = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyNamesExports);

	/******************************************************************************
	Copyright (c) Microsoft Corporation.

	Permission to use, copy, modify, and/or distribute this software for any
	purpose with or without fee is hereby granted.

	THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
	REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
	AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
	INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
	LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
	OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
	PERFORMANCE OF THIS SOFTWARE.
	***************************************************************************** */
	/* global Reflect, Promise, SuppressedError, Symbol, Iterator */

	var _extendStatics = function extendStatics(d, b) {
	  _extendStatics = _Object$setPrototypeOf$1 || {
	    __proto__: []
	  } instanceof Array && function (d, b) {
	    d.__proto__ = b;
	  } || function (d, b) {
	    for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
	  };
	  return _extendStatics(d, b);
	};
	function __extends$k(d, b) {
	  if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
	  _extendStatics(d, b);
	  function __() {
	    this.constructor = d;
	  }
	  d.prototype = b === null ? _Object$create$1(b) : (__.prototype = b.prototype, new __());
	}
	var _assign$1 = function __assign() {
	  _assign$1 = _Object$assign || function __assign(t) {
	    for (var s, i = 1, n = arguments.length; i < n; i++) {
	      s = arguments[i];
	      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
	    }
	    return t;
	  };
	  return _assign$1.apply(this, arguments);
	};
	function __rest$3(s, e) {
	  var t = {};
	  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && _indexOfInstanceProperty$1(e).call(e, p) < 0) t[p] = s[p];
	  if (s != null && typeof _Object$getOwnPropertySymbols$1 === "function") for (var i = 0, p = _Object$getOwnPropertySymbols$1(s); i < p.length; i++) {
	    if (_indexOfInstanceProperty$1(e).call(e, p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
	  }
	  return t;
	}
	function __decorate(decorators, target, key, desc) {
	  var c = arguments.length,
	    r = c < 3 ? target : desc === null ? desc = _Object$getOwnPropertyDescriptor$1(target, key) : desc,
	    d;
	  if ((typeof Reflect === "undefined" ? "undefined" : _typeof$1(Reflect)) === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
	  return c > 3 && r && _Object$defineProperty$1(target, key, r), r;
	}
	function __param(paramIndex, decorator) {
	  return function (target, key) {
	    decorator(target, key, paramIndex);
	  };
	}
	function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
	  function accept(f) {
	    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
	    return f;
	  }
	  var kind = contextIn.kind,
	    key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
	  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
	  var descriptor = descriptorIn || (target ? _Object$getOwnPropertyDescriptor$1(target, contextIn.name) : {});
	  var _,
	    done = false;
	  for (var i = decorators.length - 1; i >= 0; i--) {
	    var context = {};
	    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
	    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
	    context.addInitializer = function (f) {
	      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
	      extraInitializers.push(accept(f || null));
	    };
	    var result = (0, decorators[i])(kind === "accessor" ? {
	      get: descriptor.get,
	      set: descriptor.set
	    } : descriptor[key], context);
	    if (kind === "accessor") {
	      if (result === void 0) continue;
	      if (result === null || _typeof$1(result) !== "object") throw new TypeError("Object expected");
	      if (_ = accept(result.get)) descriptor.get = _;
	      if (_ = accept(result.set)) descriptor.set = _;
	      if (_ = accept(result.init)) initializers.unshift(_);
	    } else if (_ = accept(result)) {
	      if (kind === "field") initializers.unshift(_);else descriptor[key] = _;
	    }
	  }
	  if (target) _Object$defineProperty$1(target, contextIn.name, descriptor);
	  done = true;
	}
	function __runInitializers(thisArg, initializers, value) {
	  var useValue = arguments.length > 2;
	  for (var i = 0; i < initializers.length; i++) {
	    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
	  }
	  return useValue ? value : void 0;
	}
	function __propKey(x) {
	  return _typeof$1(x) === "symbol" ? x : "".concat(x);
	}
	function __setFunctionName(f, name, prefix) {
	  if (_typeof$1(name) === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
	  return _Object$defineProperty$1(f, "name", {
	    configurable: true,
	    value: prefix ? "".concat(prefix, " ", name) : name
	  });
	}
	function __metadata(metadataKey, metadataValue) {
	  if ((typeof Reflect === "undefined" ? "undefined" : _typeof$1(Reflect)) === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
	}
	function __awaiter$b(thisArg, _arguments, P, generator) {
	  function adopt(value) {
	    return value instanceof P ? value : new P(function (resolve) {
	      resolve(value);
	    });
	  }
	  return new (P || (P = _Promise$1))(function (resolve, reject) {
	    function fulfilled(value) {
	      try {
	        step(generator.next(value));
	      } catch (e) {
	        reject(e);
	      }
	    }
	    function rejected(value) {
	      try {
	        step(generator["throw"](value));
	      } catch (e) {
	        reject(e);
	      }
	    }
	    function step(result) {
	      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
	    }
	    step((generator = generator.apply(thisArg, _arguments || [])).next());
	  });
	}
	function __generator$b(thisArg, body) {
	  var _ = {
	      label: 0,
	      sent: function sent() {
	        if (t[0] & 1) throw t[1];
	        return t[1];
	      },
	      trys: [],
	      ops: []
	    },
	    f,
	    y,
	    t,
	    g = _Object$create$1((typeof Iterator === "function" ? Iterator : Object).prototype);
	  return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof _Symbol$1 === "function" && (g[_Symbol$iterator] = function () {
	    return this;
	  }), g;
	  function verb(n) {
	    return function (v) {
	      return step([n, v]);
	    };
	  }
	  function step(op) {
	    if (f) throw new TypeError("Generator is already executing.");
	    while (g && (g = 0, op[0] && (_ = 0)), _) try {
	      if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
	      if (y = 0, t) op = [op[0] & 2, t.value];
	      switch (op[0]) {
	        case 0:
	        case 1:
	          t = op;
	          break;
	        case 4:
	          _.label++;
	          return {
	            value: op[1],
	            done: false
	          };
	        case 5:
	          _.label++;
	          y = op[1];
	          op = [0];
	          continue;
	        case 7:
	          op = _.ops.pop();
	          _.trys.pop();
	          continue;
	        default:
	          if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
	            _ = 0;
	            continue;
	          }
	          if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
	            _.label = op[1];
	            break;
	          }
	          if (op[0] === 6 && _.label < t[1]) {
	            _.label = t[1];
	            t = op;
	            break;
	          }
	          if (t && _.label < t[2]) {
	            _.label = t[2];
	            _.ops.push(op);
	            break;
	          }
	          if (t[2]) _.ops.pop();
	          _.trys.pop();
	          continue;
	      }
	      op = body.call(thisArg, _);
	    } catch (e) {
	      op = [6, e];
	      y = 0;
	    } finally {
	      f = t = 0;
	    }
	    if (op[0] & 5) throw op[1];
	    return {
	      value: op[0] ? op[1] : void 0,
	      done: true
	    };
	  }
	}
	var __createBinding = _Object$create$1 ? function (o, m, k, k2) {
	  if (k2 === undefined) k2 = k;
	  var desc = _Object$getOwnPropertyDescriptor$1(m, k);
	  if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
	    desc = {
	      enumerable: true,
	      get: function get() {
	        return m[k];
	      }
	    };
	  }
	  _Object$defineProperty$1(o, k2, desc);
	} : function (o, m, k, k2) {
	  if (k2 === undefined) k2 = k;
	  o[k2] = m[k];
	};
	function __exportStar(m, o) {
	  for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
	}
	function __values$c(o) {
	  var s = typeof _Symbol$1 === "function" && _Symbol$iterator,
	    m = s && o[s],
	    i = 0;
	  if (m) return m.call(o);
	  if (o && typeof o.length === "number") return {
	    next: function next() {
	      if (o && i >= o.length) o = void 0;
	      return {
	        value: o && o[i++],
	        done: !o
	      };
	    }
	  };
	  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
	}
	function __read$v(o, n) {
	  var m = typeof _Symbol$1 === "function" && _getIteratorMethod$1(o);
	  if (!m) return o;
	  var i = m.call(o),
	    r,
	    ar = [],
	    e;
	  try {
	    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
	  } catch (error) {
	    e = {
	      error: error
	    };
	  } finally {
	    try {
	      if (r && !r.done && (m = i["return"])) m.call(i);
	    } finally {
	      if (e) throw e.error;
	    }
	  }
	  return ar;
	}

	/** @deprecated */
	function __spread() {
	  for (var ar = [], i = 0; i < arguments.length; i++) ar = _concatInstanceProperty(ar).call(ar, __read$v(arguments[i]));
	  return ar;
	}

	/** @deprecated */
	function __spreadArrays() {
	  for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
	  for (var r = Array(s), k = 0, i = 0; i < il; i++) for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++) r[k] = a[j];
	  return r;
	}
	function __spreadArray$g(to, from, pack) {
	  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
	    if (ar || !(i in from)) {
	      if (!ar) ar = _sliceInstanceProperty$1(Array.prototype).call(from, 0, i);
	      ar[i] = from[i];
	    }
	  }
	  return _concatInstanceProperty(to).call(to, ar || _sliceInstanceProperty$1(Array.prototype).call(from));
	}
	function __await(v) {
	  return this instanceof __await ? (this.v = v, this) : new __await(v);
	}
	function __asyncGenerator(thisArg, _arguments, generator) {
	  if (!_Symbol$asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
	  var g = generator.apply(thisArg, _arguments || []),
	    i,
	    q = [];
	  return i = _Object$create$1((typeof AsyncIterator === "function" ? AsyncIterator : Object).prototype), verb("next"), verb("throw"), verb("return", awaitReturn), i[_Symbol$asyncIterator] = function () {
	    return this;
	  }, i;
	  function awaitReturn(f) {
	    return function (v) {
	      return _Promise$1.resolve(v).then(f, reject);
	    };
	  }
	  function verb(n, f) {
	    if (g[n]) {
	      i[n] = function (v) {
	        return new _Promise$1(function (a, b) {
	          q.push([n, v, a, b]) > 1 || resume(n, v);
	        });
	      };
	      if (f) i[n] = f(i[n]);
	    }
	  }
	  function resume(n, v) {
	    try {
	      step(g[n](v));
	    } catch (e) {
	      settle(q[0][3], e);
	    }
	  }
	  function step(r) {
	    r.value instanceof __await ? _Promise$1.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
	  }
	  function fulfill(value) {
	    resume("next", value);
	  }
	  function reject(value) {
	    resume("throw", value);
	  }
	  function settle(f, v) {
	    if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
	  }
	}
	function __asyncDelegator(o) {
	  var i, p;
	  return i = {}, verb("next"), verb("throw", function (e) {
	    throw e;
	  }), verb("return"), i[_Symbol$iterator] = function () {
	    return this;
	  }, i;
	  function verb(n, f) {
	    i[n] = o[n] ? function (v) {
	      return (p = !p) ? {
	        value: __await(o[n](v)),
	        done: false
	      } : f ? f(v) : v;
	    } : f;
	  }
	}
	function __asyncValues(o) {
	  if (!_Symbol$asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
	  var m = o[_Symbol$asyncIterator],
	    i;
	  return m ? m.call(o) : (o = typeof __values$c === "function" ? __values$c(o) : _getIterator(o), i = {}, verb("next"), verb("throw"), verb("return"), i[_Symbol$asyncIterator] = function () {
	    return this;
	  }, i);
	  function verb(n) {
	    i[n] = o[n] && function (v) {
	      return new _Promise$1(function (resolve, reject) {
	        v = o[n](v), settle(resolve, reject, v.done, v.value);
	      });
	    };
	  }
	  function settle(resolve, reject, d, v) {
	    _Promise$1.resolve(v).then(function (v) {
	      resolve({
	        value: v,
	        done: d
	      });
	    }, reject);
	  }
	}
	function __makeTemplateObject(cooked, raw) {
	  if (_Object$defineProperty$1) {
	    _Object$defineProperty$1(cooked, "raw", {
	      value: raw
	    });
	  } else {
	    cooked.raw = raw;
	  }
	  return cooked;
	}
	var __setModuleDefault = _Object$create$1 ? function (o, v) {
	  _Object$defineProperty$1(o, "default", {
	    enumerable: true,
	    value: v
	  });
	} : function (o, v) {
	  o["default"] = v;
	};
	var _ownKeys = function ownKeys(o) {
	  _ownKeys = _Object$getOwnPropertyNames || function (o) {
	    var ar = [];
	    for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
	    return ar;
	  };
	  return _ownKeys(o);
	};
	function __importStar(mod) {
	  if (mod && mod.__esModule) return mod;
	  var result = {};
	  if (mod != null) for (var k = _ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
	  __setModuleDefault(result, mod);
	  return result;
	}
	function __importDefault(mod) {
	  return mod && mod.__esModule ? mod : {
	    default: mod
	  };
	}
	function __classPrivateFieldGet(receiver, state, kind, f) {
	  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
	  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
	  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
	}
	function __classPrivateFieldSet(receiver, state, value, kind, f) {
	  if (kind === "m") throw new TypeError("Private method is not writable");
	  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
	  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
	  return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
	}
	function __classPrivateFieldIn(state, receiver) {
	  if (receiver === null || _typeof$1(receiver) !== "object" && typeof receiver !== "function") throw new TypeError("Cannot use 'in' operator on non-object");
	  return typeof state === "function" ? receiver === state : state.has(receiver);
	}
	function __addDisposableResource(env, value, async) {
	  if (value !== null && value !== void 0) {
	    if (_typeof$1(value) !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
	    var dispose, inner;
	    if (async) {
	      if (!_Symbol$1.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
	      dispose = value[_Symbol$1.asyncDispose];
	    }
	    if (dispose === void 0) {
	      if (!_Symbol$1.dispose) throw new TypeError("Symbol.dispose is not defined.");
	      dispose = value[_Symbol$1.dispose];
	      if (async) inner = dispose;
	    }
	    if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
	    if (inner) dispose = function dispose() {
	      try {
	        inner.call(this);
	      } catch (e) {
	        return _Promise$1.reject(e);
	      }
	    };
	    env.stack.push({
	      value: value,
	      dispose: dispose,
	      async: async
	    });
	  } else if (async) {
	    env.stack.push({
	      async: true
	    });
	  }
	  return value;
	}
	var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
	  var e = new Error(message);
	  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
	};
	function __disposeResources(env) {
	  function fail(e) {
	    env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
	    env.hasError = true;
	  }
	  var r,
	    s = 0;
	  function next() {
	    while (r = env.stack.pop()) {
	      try {
	        if (!r.async && s === 1) return s = 0, env.stack.push(r), _Promise$1.resolve().then(next);
	        if (r.dispose) {
	          var result = r.dispose.call(r.value);
	          if (r.async) return s |= 2, _Promise$1.resolve(result).then(next, function (e) {
	            fail(e);
	            return next();
	          });
	        } else s |= 1;
	      } catch (e) {
	        fail(e);
	      }
	    }
	    if (s === 1) return env.hasError ? _Promise$1.reject(env.error) : _Promise$1.resolve();
	    if (env.hasError) throw env.error;
	  }
	  return next();
	}
	function __rewriteRelativeImportExtension(path, preserveJsx) {
	  if (typeof path === "string" && /^\.\.?\//.test(path)) {
	    return path.replace(/\.(tsx)$|((?:\.d)?)((?:\.[^./]+?)?)\.([cm]?)ts$/i, function (m, tsx, d, ext, cm) {
	      return tsx ? preserveJsx ? ".jsx" : ".js" : d && (!ext || !cm) ? m : d + ext + "." + cm.toLowerCase() + "js";
	    });
	  }
	  return path;
	}
	var tslib_es6 = {
	  __extends: __extends$k,
	  __assign: _assign$1,
	  __rest: __rest$3,
	  __decorate: __decorate,
	  __param: __param,
	  __esDecorate: __esDecorate,
	  __runInitializers: __runInitializers,
	  __propKey: __propKey,
	  __setFunctionName: __setFunctionName,
	  __metadata: __metadata,
	  __awaiter: __awaiter$b,
	  __generator: __generator$b,
	  __createBinding: __createBinding,
	  __exportStar: __exportStar,
	  __values: __values$c,
	  __read: __read$v,
	  __spread: __spread,
	  __spreadArrays: __spreadArrays,
	  __spreadArray: __spreadArray$g,
	  __await: __await,
	  __asyncGenerator: __asyncGenerator,
	  __asyncDelegator: __asyncDelegator,
	  __asyncValues: __asyncValues,
	  __makeTemplateObject: __makeTemplateObject,
	  __importStar: __importStar,
	  __importDefault: __importDefault,
	  __classPrivateFieldGet: __classPrivateFieldGet,
	  __classPrivateFieldSet: __classPrivateFieldSet,
	  __classPrivateFieldIn: __classPrivateFieldIn,
	  __addDisposableResource: __addDisposableResource,
	  __disposeResources: __disposeResources,
	  __rewriteRelativeImportExtension: __rewriteRelativeImportExtension
	};

	var tslib_es6$1 = /*#__PURE__*/Object.freeze({
		__proto__: null,
		__addDisposableResource: __addDisposableResource,
		get __assign () { return _assign$1; },
		__asyncDelegator: __asyncDelegator,
		__asyncGenerator: __asyncGenerator,
		__asyncValues: __asyncValues,
		__await: __await,
		__awaiter: __awaiter$b,
		__classPrivateFieldGet: __classPrivateFieldGet,
		__classPrivateFieldIn: __classPrivateFieldIn,
		__classPrivateFieldSet: __classPrivateFieldSet,
		__createBinding: __createBinding,
		__decorate: __decorate,
		__disposeResources: __disposeResources,
		__esDecorate: __esDecorate,
		__exportStar: __exportStar,
		__extends: __extends$k,
		__generator: __generator$b,
		__importDefault: __importDefault,
		__importStar: __importStar,
		__makeTemplateObject: __makeTemplateObject,
		__metadata: __metadata,
		__param: __param,
		__propKey: __propKey,
		__read: __read$v,
		__rest: __rest$3,
		__rewriteRelativeImportExtension: __rewriteRelativeImportExtension,
		__runInitializers: __runInitializers,
		__setFunctionName: __setFunctionName,
		__spread: __spread,
		__spreadArray: __spreadArray$g,
		__spreadArrays: __spreadArrays,
		__values: __values$c,
		default: tslib_es6
	});

	var require$$0$9 = /*@__PURE__*/getAugmentedNamespace(tslib_es6$1);

	var es_reflect_construct = {};

	var functionBind;
	var hasRequiredFunctionBind;

	function requireFunctionBind () {
		if (hasRequiredFunctionBind) return functionBind;
		hasRequiredFunctionBind = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var aCallable = /*@__PURE__*/ requireACallable();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var arraySlice = /*@__PURE__*/ requireArraySlice();
		var NATIVE_BIND = /*@__PURE__*/ requireFunctionBindNative();

		var $Function = Function;
		var concat = uncurryThis([].concat);
		var join = uncurryThis([].join);
		var factories = {};

		var construct = function (C, argsLength, args) {
		  if (!hasOwn(factories, argsLength)) {
		    var list = [];
		    var i = 0;
		    for (; i < argsLength; i++) list[i] = 'a[' + i + ']';
		    factories[argsLength] = $Function('C,a', 'return new C(' + join(list, ',') + ')');
		  } return factories[argsLength](C, args);
		};

		// `Function.prototype.bind` method implementation
		// https://tc39.es/ecma262/#sec-function.prototype.bind
		// eslint-disable-next-line es/no-function-prototype-bind -- detection
		functionBind = NATIVE_BIND ? $Function.bind : function bind(that /* , ...args */) {
		  var F = aCallable(this);
		  var Prototype = F.prototype;
		  var partArgs = arraySlice(arguments, 1);
		  var boundFunction = function bound(/* args... */) {
		    var args = concat(partArgs, arraySlice(arguments));
		    return this instanceof boundFunction ? construct(F, args.length, args) : F.apply(that, args);
		  };
		  if (isObject(Prototype)) boundFunction.prototype = Prototype;
		  return boundFunction;
		};
		return functionBind;
	}

	var hasRequiredEs_reflect_construct;

	function requireEs_reflect_construct () {
		if (hasRequiredEs_reflect_construct) return es_reflect_construct;
		hasRequiredEs_reflect_construct = 1;
		var $ = /*@__PURE__*/ require_export();
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var apply = /*@__PURE__*/ requireFunctionApply();
		var bind = /*@__PURE__*/ requireFunctionBind();
		var aConstructor = /*@__PURE__*/ requireAConstructor();
		var anObject = /*@__PURE__*/ requireAnObject();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var create = /*@__PURE__*/ requireObjectCreate();
		var fails = /*@__PURE__*/ requireFails();

		var nativeConstruct = getBuiltIn('Reflect', 'construct');
		var ObjectPrototype = Object.prototype;
		var push = [].push;

		// `Reflect.construct` method
		// https://tc39.es/ecma262/#sec-reflect.construct
		// MS Edge supports only 2 arguments and argumentsList argument is optional
		// FF Nightly sets third argument as `new.target`, but does not create `this` from it
		var NEW_TARGET_BUG = fails(function () {
		  function F() { /* empty */ }
		  return !(nativeConstruct(function () { /* empty */ }, [], F) instanceof F);
		});

		var ARGS_BUG = !fails(function () {
		  nativeConstruct(function () { /* empty */ });
		});

		var FORCED = NEW_TARGET_BUG || ARGS_BUG;

		$({ target: 'Reflect', stat: true, forced: FORCED, sham: FORCED }, {
		  construct: function construct(Target, args /* , newTarget */) {
		    aConstructor(Target);
		    anObject(args);
		    var newTarget = arguments.length < 3 ? Target : aConstructor(arguments[2]);
		    if (ARGS_BUG && !NEW_TARGET_BUG) return nativeConstruct(Target, args, newTarget);
		    if (Target === newTarget) {
		      // w/o altered newTarget, optimization for 0-4 arguments
		      switch (args.length) {
		        case 0: return new Target();
		        case 1: return new Target(args[0]);
		        case 2: return new Target(args[0], args[1]);
		        case 3: return new Target(args[0], args[1], args[2]);
		        case 4: return new Target(args[0], args[1], args[2], args[3]);
		      }
		      // w/o altered newTarget, lot of arguments case
		      var $args = [null];
		      apply(push, $args, args);
		      return new (apply(bind, Target, $args))();
		    }
		    // with altered newTarget, not support built-in constructors
		    var proto = newTarget.prototype;
		    var instance = create(isObject(proto) ? proto : ObjectPrototype);
		    var result = apply(Target, instance, args);
		    return isObject(result) ? result : instance;
		  }
		});
		return es_reflect_construct;
	}

	var construct$5;
	var hasRequiredConstruct$5;

	function requireConstruct$5 () {
		if (hasRequiredConstruct$5) return construct$5;
		hasRequiredConstruct$5 = 1;
		requireEs_reflect_construct();
		var path = /*@__PURE__*/ requirePath$1();

		construct$5 = path.Reflect.construct;
		return construct$5;
	}

	var construct$4;
	var hasRequiredConstruct$4;

	function requireConstruct$4 () {
		if (hasRequiredConstruct$4) return construct$4;
		hasRequiredConstruct$4 = 1;
		var parent = /*@__PURE__*/ requireConstruct$5();

		construct$4 = parent;
		return construct$4;
	}

	var construct$3;
	var hasRequiredConstruct$3;
	function requireConstruct$3() {
	  if (hasRequiredConstruct$3) return construct$3;
	  hasRequiredConstruct$3 = 1;
	  construct$3 = /*@__PURE__*/requireConstruct$4();
	  return construct$3;
	}

	var constructExports$1 = requireConstruct$3();
	var _Reflect$construct$1 = /*@__PURE__*/getDefaultExportFromCjs(constructExports$1);

	function _assertThisInitialized(e) {
	  if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
	  return e;
	}

	function _possibleConstructorReturn(t, e) {
	  if (e && ("object" == _typeof$1(e) || "function" == typeof e)) return e;
	  if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined");
	  return _assertThisInitialized(t);
	}

	var setPrototypeOf$2;
	var hasRequiredSetPrototypeOf$2;

	function requireSetPrototypeOf$2 () {
		if (hasRequiredSetPrototypeOf$2) return setPrototypeOf$2;
		hasRequiredSetPrototypeOf$2 = 1;
		var parent = /*@__PURE__*/ requireSetPrototypeOf$4();

		setPrototypeOf$2 = parent;
		return setPrototypeOf$2;
	}

	var setPrototypeOf$1;
	var hasRequiredSetPrototypeOf$1;

	function requireSetPrototypeOf$1 () {
		if (hasRequiredSetPrototypeOf$1) return setPrototypeOf$1;
		hasRequiredSetPrototypeOf$1 = 1;
		var parent = /*@__PURE__*/ requireSetPrototypeOf$2();

		setPrototypeOf$1 = parent;
		return setPrototypeOf$1;
	}

	var setPrototypeOf;
	var hasRequiredSetPrototypeOf;

	function requireSetPrototypeOf () {
		if (hasRequiredSetPrototypeOf) return setPrototypeOf;
		hasRequiredSetPrototypeOf = 1;
		setPrototypeOf = /*@__PURE__*/ requireSetPrototypeOf$1();
		return setPrototypeOf;
	}

	var setPrototypeOfExports = /*@__PURE__*/ requireSetPrototypeOf();
	var _Object$setPrototypeOf = /*@__PURE__*/getDefaultExportFromCjs(setPrototypeOfExports);

	var es_function_bind = {};

	var hasRequiredEs_function_bind;

	function requireEs_function_bind () {
		if (hasRequiredEs_function_bind) return es_function_bind;
		hasRequiredEs_function_bind = 1;
		// TODO: Remove from `core-js@4`
		var $ = /*@__PURE__*/ require_export();
		var bind = /*@__PURE__*/ requireFunctionBind();

		// `Function.prototype.bind` method
		// https://tc39.es/ecma262/#sec-function.prototype.bind
		// eslint-disable-next-line es/no-function-prototype-bind -- detection
		$({ target: 'Function', proto: true, forced: Function.bind !== bind }, {
		  bind: bind
		});
		return es_function_bind;
	}

	var bind$6;
	var hasRequiredBind$6;

	function requireBind$6 () {
		if (hasRequiredBind$6) return bind$6;
		hasRequiredBind$6 = 1;
		requireEs_function_bind();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		bind$6 = getBuiltInPrototypeMethod('Function', 'bind');
		return bind$6;
	}

	var bind$5;
	var hasRequiredBind$5;

	function requireBind$5 () {
		if (hasRequiredBind$5) return bind$5;
		hasRequiredBind$5 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireBind$6();

		var FunctionPrototype = Function.prototype;

		bind$5 = function (it) {
		  var own = it.bind;
		  return it === FunctionPrototype || (isPrototypeOf(FunctionPrototype, it) && own === FunctionPrototype.bind) ? method : own;
		};
		return bind$5;
	}

	var bind$4;
	var hasRequiredBind$4;

	function requireBind$4 () {
		if (hasRequiredBind$4) return bind$4;
		hasRequiredBind$4 = 1;
		var parent = /*@__PURE__*/ requireBind$5();

		bind$4 = parent;
		return bind$4;
	}

	var bind$3;
	var hasRequiredBind$3;

	function requireBind$3 () {
		if (hasRequiredBind$3) return bind$3;
		hasRequiredBind$3 = 1;
		var parent = /*@__PURE__*/ requireBind$4();

		bind$3 = parent;
		return bind$3;
	}

	var bind$2;
	var hasRequiredBind$2;

	function requireBind$2 () {
		if (hasRequiredBind$2) return bind$2;
		hasRequiredBind$2 = 1;
		var parent = /*@__PURE__*/ requireBind$3();

		bind$2 = parent;
		return bind$2;
	}

	var bind$1;
	var hasRequiredBind$1;

	function requireBind$1 () {
		if (hasRequiredBind$1) return bind$1;
		hasRequiredBind$1 = 1;
		bind$1 = /*@__PURE__*/ requireBind$2();
		return bind$1;
	}

	var bindExports$1 = /*@__PURE__*/ requireBind$1();
	var _bindInstanceProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(bindExports$1);

	var es_object_getPrototypeOf = {};

	var hasRequiredEs_object_getPrototypeOf;

	function requireEs_object_getPrototypeOf () {
		if (hasRequiredEs_object_getPrototypeOf) return es_object_getPrototypeOf;
		hasRequiredEs_object_getPrototypeOf = 1;
		var $ = /*@__PURE__*/ require_export();
		var fails = /*@__PURE__*/ requireFails();
		var toObject = /*@__PURE__*/ requireToObject();
		var nativeGetPrototypeOf = /*@__PURE__*/ requireObjectGetPrototypeOf();
		var CORRECT_PROTOTYPE_GETTER = /*@__PURE__*/ requireCorrectPrototypeGetter();

		var FAILS_ON_PRIMITIVES = fails(function () { nativeGetPrototypeOf(1); });

		// `Object.getPrototypeOf` method
		// https://tc39.es/ecma262/#sec-object.getprototypeof
		$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES, sham: !CORRECT_PROTOTYPE_GETTER }, {
		  getPrototypeOf: function getPrototypeOf(it) {
		    return nativeGetPrototypeOf(toObject(it));
		  }
		});
		return es_object_getPrototypeOf;
	}

	var getPrototypeOf$5;
	var hasRequiredGetPrototypeOf$5;

	function requireGetPrototypeOf$5 () {
		if (hasRequiredGetPrototypeOf$5) return getPrototypeOf$5;
		hasRequiredGetPrototypeOf$5 = 1;
		requireEs_object_getPrototypeOf();
		var path = /*@__PURE__*/ requirePath$1();

		getPrototypeOf$5 = path.Object.getPrototypeOf;
		return getPrototypeOf$5;
	}

	var getPrototypeOf$4;
	var hasRequiredGetPrototypeOf$4;

	function requireGetPrototypeOf$4 () {
		if (hasRequiredGetPrototypeOf$4) return getPrototypeOf$4;
		hasRequiredGetPrototypeOf$4 = 1;
		var parent = /*@__PURE__*/ requireGetPrototypeOf$5();

		getPrototypeOf$4 = parent;
		return getPrototypeOf$4;
	}

	var getPrototypeOf$3;
	var hasRequiredGetPrototypeOf$3;

	function requireGetPrototypeOf$3 () {
		if (hasRequiredGetPrototypeOf$3) return getPrototypeOf$3;
		hasRequiredGetPrototypeOf$3 = 1;
		var parent = /*@__PURE__*/ requireGetPrototypeOf$4();

		getPrototypeOf$3 = parent;
		return getPrototypeOf$3;
	}

	var getPrototypeOf$2;
	var hasRequiredGetPrototypeOf$2;

	function requireGetPrototypeOf$2 () {
		if (hasRequiredGetPrototypeOf$2) return getPrototypeOf$2;
		hasRequiredGetPrototypeOf$2 = 1;
		var parent = /*@__PURE__*/ requireGetPrototypeOf$3();

		getPrototypeOf$2 = parent;
		return getPrototypeOf$2;
	}

	var getPrototypeOf$1;
	var hasRequiredGetPrototypeOf$1;

	function requireGetPrototypeOf$1 () {
		if (hasRequiredGetPrototypeOf$1) return getPrototypeOf$1;
		hasRequiredGetPrototypeOf$1 = 1;
		getPrototypeOf$1 = /*@__PURE__*/ requireGetPrototypeOf$2();
		return getPrototypeOf$1;
	}

	var getPrototypeOfExports$1 = /*@__PURE__*/ requireGetPrototypeOf$1();
	var _Object$getPrototypeOf$1 = /*@__PURE__*/getDefaultExportFromCjs(getPrototypeOfExports$1);

	function _getPrototypeOf(t) {
	  var _context;
	  return _getPrototypeOf = _Object$setPrototypeOf ? _bindInstanceProperty$1(_context = _Object$getPrototypeOf$1).call(_context) : function (t) {
	    return t.__proto__ || _Object$getPrototypeOf$1(t);
	  }, _getPrototypeOf(t);
	}

	var create$2;
	var hasRequiredCreate$2;

	function requireCreate$2 () {
		if (hasRequiredCreate$2) return create$2;
		hasRequiredCreate$2 = 1;
		var parent = /*@__PURE__*/ requireCreate$4();

		create$2 = parent;
		return create$2;
	}

	var create$1;
	var hasRequiredCreate$1;

	function requireCreate$1 () {
		if (hasRequiredCreate$1) return create$1;
		hasRequiredCreate$1 = 1;
		var parent = /*@__PURE__*/ requireCreate$2();

		create$1 = parent;
		return create$1;
	}

	var create;
	var hasRequiredCreate;

	function requireCreate () {
		if (hasRequiredCreate) return create;
		hasRequiredCreate = 1;
		create = /*@__PURE__*/ requireCreate$1();
		return create;
	}

	var createExports = /*@__PURE__*/ requireCreate();
	var _Object$create = /*@__PURE__*/getDefaultExportFromCjs(createExports);

	function _setPrototypeOf(t, e) {
	  var _context;
	  return _setPrototypeOf = _Object$setPrototypeOf ? _bindInstanceProperty$1(_context = _Object$setPrototypeOf).call(_context) : function (t, e) {
	    return t.__proto__ = e, t;
	  }, _setPrototypeOf(t, e);
	}

	function _inherits(t, e) {
	  if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function");
	  t.prototype = _Object$create(e && e.prototype, {
	    constructor: {
	      value: t,
	      writable: true,
	      configurable: true
	    }
	  }), _Object$defineProperty(t, "prototype", {
	    writable: false
	  }), e && _setPrototypeOf(t, e);
	}

	var es_string_trim = {};

	var whitespaces;
	var hasRequiredWhitespaces;

	function requireWhitespaces () {
		if (hasRequiredWhitespaces) return whitespaces;
		hasRequiredWhitespaces = 1;
		// a string of all valid unicode whitespaces
		whitespaces = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
		  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';
		return whitespaces;
	}

	var stringTrim;
	var hasRequiredStringTrim;

	function requireStringTrim () {
		if (hasRequiredStringTrim) return stringTrim;
		hasRequiredStringTrim = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();
		var toString = /*@__PURE__*/ requireToString();
		var whitespaces = /*@__PURE__*/ requireWhitespaces();

		var replace = uncurryThis(''.replace);
		var ltrim = RegExp('^[' + whitespaces + ']+');
		var rtrim = RegExp('(^|[^' + whitespaces + '])[' + whitespaces + ']+$');

		// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
		var createMethod = function (TYPE) {
		  return function ($this) {
		    var string = toString(requireObjectCoercible($this));
		    if (TYPE & 1) string = replace(string, ltrim, '');
		    if (TYPE & 2) string = replace(string, rtrim, '$1');
		    return string;
		  };
		};

		stringTrim = {
		  // `String.prototype.{ trimLeft, trimStart }` methods
		  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
		  start: createMethod(1),
		  // `String.prototype.{ trimRight, trimEnd }` methods
		  // https://tc39.es/ecma262/#sec-string.prototype.trimend
		  end: createMethod(2),
		  // `String.prototype.trim` method
		  // https://tc39.es/ecma262/#sec-string.prototype.trim
		  trim: createMethod(3)
		};
		return stringTrim;
	}

	var stringTrimForced;
	var hasRequiredStringTrimForced;

	function requireStringTrimForced () {
		if (hasRequiredStringTrimForced) return stringTrimForced;
		hasRequiredStringTrimForced = 1;
		var PROPER_FUNCTION_NAME = /*@__PURE__*/ requireFunctionName().PROPER;
		var fails = /*@__PURE__*/ requireFails();
		var whitespaces = /*@__PURE__*/ requireWhitespaces();

		var non = '\u200B\u0085\u180E';

		// check that a method works with the correct list
		// of whitespaces and has a correct name
		stringTrimForced = function (METHOD_NAME) {
		  return fails(function () {
		    return !!whitespaces[METHOD_NAME]()
		      || non[METHOD_NAME]() !== non
		      || (PROPER_FUNCTION_NAME && whitespaces[METHOD_NAME].name !== METHOD_NAME);
		  });
		};
		return stringTrimForced;
	}

	var hasRequiredEs_string_trim;

	function requireEs_string_trim () {
		if (hasRequiredEs_string_trim) return es_string_trim;
		hasRequiredEs_string_trim = 1;
		var $ = /*@__PURE__*/ require_export();
		var $trim = /*@__PURE__*/ requireStringTrim().trim;
		var forcedStringTrimMethod = /*@__PURE__*/ requireStringTrimForced();

		// `String.prototype.trim` method
		// https://tc39.es/ecma262/#sec-string.prototype.trim
		$({ target: 'String', proto: true, forced: forcedStringTrimMethod('trim') }, {
		  trim: function trim() {
		    return $trim(this);
		  }
		});
		return es_string_trim;
	}

	var trim$4;
	var hasRequiredTrim$3;

	function requireTrim$3 () {
		if (hasRequiredTrim$3) return trim$4;
		hasRequiredTrim$3 = 1;
		requireEs_string_trim();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		trim$4 = getBuiltInPrototypeMethod('String', 'trim');
		return trim$4;
	}

	var trim$3;
	var hasRequiredTrim$2;

	function requireTrim$2 () {
		if (hasRequiredTrim$2) return trim$3;
		hasRequiredTrim$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireTrim$3();

		var StringPrototype = String.prototype;

		trim$3 = function (it) {
		  var own = it.trim;
		  return typeof it == 'string' || it === StringPrototype
		    || (isPrototypeOf(StringPrototype, it) && own === StringPrototype.trim) ? method : own;
		};
		return trim$3;
	}

	var trim$2;
	var hasRequiredTrim$1;

	function requireTrim$1 () {
		if (hasRequiredTrim$1) return trim$2;
		hasRequiredTrim$1 = 1;
		var parent = /*@__PURE__*/ requireTrim$2();

		trim$2 = parent;
		return trim$2;
	}

	var trim$1;
	var hasRequiredTrim;
	function requireTrim() {
	  if (hasRequiredTrim) return trim$1;
	  hasRequiredTrim = 1;
	  trim$1 = /*@__PURE__*/requireTrim$1();
	  return trim$1;
	}

	var trimExports = requireTrim();
	var _trimInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(trimExports);

	var es_array_isArray = {};

	var hasRequiredEs_array_isArray;

	function requireEs_array_isArray () {
		if (hasRequiredEs_array_isArray) return es_array_isArray;
		hasRequiredEs_array_isArray = 1;
		var $ = /*@__PURE__*/ require_export();
		var isArray = /*@__PURE__*/ requireIsArray$7();

		// `Array.isArray` method
		// https://tc39.es/ecma262/#sec-array.isarray
		$({ target: 'Array', stat: true }, {
		  isArray: isArray
		});
		return es_array_isArray;
	}

	var isArray$7;
	var hasRequiredIsArray$6;

	function requireIsArray$6 () {
		if (hasRequiredIsArray$6) return isArray$7;
		hasRequiredIsArray$6 = 1;
		requireEs_array_isArray();
		var path = /*@__PURE__*/ requirePath$1();

		isArray$7 = path.Array.isArray;
		return isArray$7;
	}

	var isArray$6;
	var hasRequiredIsArray$5;

	function requireIsArray$5 () {
		if (hasRequiredIsArray$5) return isArray$6;
		hasRequiredIsArray$5 = 1;
		var parent = /*@__PURE__*/ requireIsArray$6();

		isArray$6 = parent;
		return isArray$6;
	}

	var isArray$5;
	var hasRequiredIsArray$4;
	function requireIsArray$4() {
	  if (hasRequiredIsArray$4) return isArray$5;
	  hasRequiredIsArray$4 = 1;
	  isArray$5 = /*@__PURE__*/requireIsArray$5();
	  return isArray$5;
	}

	var isArrayExports$1 = requireIsArray$4();
	var _Array$isArray$1 = /*@__PURE__*/getDefaultExportFromCjs(isArrayExports$1);

	var es_array_find = {};

	var hasRequiredEs_array_find;

	function requireEs_array_find () {
		if (hasRequiredEs_array_find) return es_array_find;
		hasRequiredEs_array_find = 1;
		var $ = /*@__PURE__*/ require_export();
		var $find = /*@__PURE__*/ requireArrayIteration().find;
		var addToUnscopables = /*@__PURE__*/ requireAddToUnscopables();

		var FIND = 'find';
		var SKIPS_HOLES = true;

		// Shouldn't skip holes
		// eslint-disable-next-line es/no-array-prototype-find -- testing
		if (FIND in []) Array(1)[FIND](function () { SKIPS_HOLES = false; });

		// `Array.prototype.find` method
		// https://tc39.es/ecma262/#sec-array.prototype.find
		$({ target: 'Array', proto: true, forced: SKIPS_HOLES }, {
		  find: function find(callbackfn /* , that = undefined */) {
		    return $find(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
		  }
		});

		// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
		addToUnscopables(FIND);
		return es_array_find;
	}

	var find$3;
	var hasRequiredFind$3;

	function requireFind$3 () {
		if (hasRequiredFind$3) return find$3;
		hasRequiredFind$3 = 1;
		requireEs_array_find();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		find$3 = getBuiltInPrototypeMethod('Array', 'find');
		return find$3;
	}

	var find$2;
	var hasRequiredFind$2;

	function requireFind$2 () {
		if (hasRequiredFind$2) return find$2;
		hasRequiredFind$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireFind$3();

		var ArrayPrototype = Array.prototype;

		find$2 = function (it) {
		  var own = it.find;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.find) ? method : own;
		};
		return find$2;
	}

	var find$1;
	var hasRequiredFind$1;

	function requireFind$1 () {
		if (hasRequiredFind$1) return find$1;
		hasRequiredFind$1 = 1;
		var parent = /*@__PURE__*/ requireFind$2();

		find$1 = parent;
		return find$1;
	}

	var find;
	var hasRequiredFind;
	function requireFind() {
	  if (hasRequiredFind) return find;
	  hasRequiredFind = 1;
	  find = /*@__PURE__*/requireFind$1();
	  return find;
	}

	var findExports = requireFind();
	var _findInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(findExports);

	var IMQAErrorInstrumentation = {};

	var es_map = {};

	var es_map_constructor = {};

	var internalMetadata = {exports: {}};

	var arrayBufferNonExtensible;
	var hasRequiredArrayBufferNonExtensible;

	function requireArrayBufferNonExtensible () {
		if (hasRequiredArrayBufferNonExtensible) return arrayBufferNonExtensible;
		hasRequiredArrayBufferNonExtensible = 1;
		// FF26- bug: ArrayBuffers are non-extensible, but Object.isExtensible does not report it
		var fails = /*@__PURE__*/ requireFails();

		arrayBufferNonExtensible = fails(function () {
		  if (typeof ArrayBuffer == 'function') {
		    var buffer = new ArrayBuffer(8);
		    // eslint-disable-next-line es/no-object-isextensible, es/no-object-defineproperty -- safe
		    if (Object.isExtensible(buffer)) Object.defineProperty(buffer, 'a', { value: 8 });
		  }
		});
		return arrayBufferNonExtensible;
	}

	var objectIsExtensible;
	var hasRequiredObjectIsExtensible;

	function requireObjectIsExtensible () {
		if (hasRequiredObjectIsExtensible) return objectIsExtensible;
		hasRequiredObjectIsExtensible = 1;
		var fails = /*@__PURE__*/ requireFails();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var classof = /*@__PURE__*/ requireClassofRaw();
		var ARRAY_BUFFER_NON_EXTENSIBLE = /*@__PURE__*/ requireArrayBufferNonExtensible();

		// eslint-disable-next-line es/no-object-isextensible -- safe
		var $isExtensible = Object.isExtensible;
		var FAILS_ON_PRIMITIVES = fails(function () { });

		// `Object.isExtensible` method
		// https://tc39.es/ecma262/#sec-object.isextensible
		objectIsExtensible = (FAILS_ON_PRIMITIVES || ARRAY_BUFFER_NON_EXTENSIBLE) ? function isExtensible(it) {
		  if (!isObject(it)) return false;
		  if (ARRAY_BUFFER_NON_EXTENSIBLE && classof(it) === 'ArrayBuffer') return false;
		  return $isExtensible ? $isExtensible(it) : true;
		} : $isExtensible;
		return objectIsExtensible;
	}

	var freezing;
	var hasRequiredFreezing;

	function requireFreezing () {
		if (hasRequiredFreezing) return freezing;
		hasRequiredFreezing = 1;
		var fails = /*@__PURE__*/ requireFails();

		freezing = !fails(function () {
		  // eslint-disable-next-line es/no-object-isextensible, es/no-object-preventextensions -- required for testing
		  return Object.isExtensible(Object.preventExtensions({}));
		});
		return freezing;
	}

	var hasRequiredInternalMetadata;

	function requireInternalMetadata () {
		if (hasRequiredInternalMetadata) return internalMetadata.exports;
		hasRequiredInternalMetadata = 1;
		var $ = /*@__PURE__*/ require_export();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var hiddenKeys = /*@__PURE__*/ requireHiddenKeys();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var defineProperty = /*@__PURE__*/ requireObjectDefineProperty().f;
		var getOwnPropertyNamesModule = /*@__PURE__*/ requireObjectGetOwnPropertyNames();
		var getOwnPropertyNamesExternalModule = /*@__PURE__*/ requireObjectGetOwnPropertyNamesExternal();
		var isExtensible = /*@__PURE__*/ requireObjectIsExtensible();
		var uid = /*@__PURE__*/ requireUid();
		var FREEZING = /*@__PURE__*/ requireFreezing();

		var REQUIRED = false;
		var METADATA = uid('meta');
		var id = 0;

		var setMetadata = function (it) {
		  defineProperty(it, METADATA, { value: {
		    objectID: 'O' + id++, // object ID
		    weakData: {}          // weak collections IDs
		  } });
		};

		var fastKey = function (it, create) {
		  // return a primitive with prefix
		  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
		  if (!hasOwn(it, METADATA)) {
		    // can't set metadata to uncaught frozen object
		    if (!isExtensible(it)) return 'F';
		    // not necessary to add metadata
		    if (!create) return 'E';
		    // add missing metadata
		    setMetadata(it);
		  // return object ID
		  } return it[METADATA].objectID;
		};

		var getWeakData = function (it, create) {
		  if (!hasOwn(it, METADATA)) {
		    // can't set metadata to uncaught frozen object
		    if (!isExtensible(it)) return true;
		    // not necessary to add metadata
		    if (!create) return false;
		    // add missing metadata
		    setMetadata(it);
		  // return the store of weak collections IDs
		  } return it[METADATA].weakData;
		};

		// add metadata on freeze-family methods calling
		var onFreeze = function (it) {
		  if (FREEZING && REQUIRED && isExtensible(it) && !hasOwn(it, METADATA)) setMetadata(it);
		  return it;
		};

		var enable = function () {
		  meta.enable = function () { /* empty */ };
		  REQUIRED = true;
		  var getOwnPropertyNames = getOwnPropertyNamesModule.f;
		  var splice = uncurryThis([].splice);
		  var test = {};
		  test[METADATA] = 1;

		  // prevent exposing of metadata key
		  if (getOwnPropertyNames(test).length) {
		    getOwnPropertyNamesModule.f = function (it) {
		      var result = getOwnPropertyNames(it);
		      for (var i = 0, length = result.length; i < length; i++) {
		        if (result[i] === METADATA) {
		          splice(result, i, 1);
		          break;
		        }
		      } return result;
		    };

		    $({ target: 'Object', stat: true, forced: true }, {
		      getOwnPropertyNames: getOwnPropertyNamesExternalModule.f
		    });
		  }
		};

		var meta = internalMetadata.exports = {
		  enable: enable,
		  fastKey: fastKey,
		  getWeakData: getWeakData,
		  onFreeze: onFreeze
		};

		hiddenKeys[METADATA] = true;
		return internalMetadata.exports;
	}

	var collection;
	var hasRequiredCollection;

	function requireCollection () {
		if (hasRequiredCollection) return collection;
		hasRequiredCollection = 1;
		var $ = /*@__PURE__*/ require_export();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();
		var InternalMetadataModule = /*@__PURE__*/ requireInternalMetadata();
		var fails = /*@__PURE__*/ requireFails();
		var createNonEnumerableProperty = /*@__PURE__*/ requireCreateNonEnumerableProperty();
		var iterate = /*@__PURE__*/ requireIterate();
		var anInstance = /*@__PURE__*/ requireAnInstance();
		var isCallable = /*@__PURE__*/ requireIsCallable();
		var isObject = /*@__PURE__*/ requireIsObject$1();
		var isNullOrUndefined = /*@__PURE__*/ requireIsNullOrUndefined();
		var setToStringTag = /*@__PURE__*/ requireSetToStringTag();
		var defineProperty = /*@__PURE__*/ requireObjectDefineProperty().f;
		var forEach = /*@__PURE__*/ requireArrayIteration().forEach;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var InternalStateModule = /*@__PURE__*/ requireInternalState();

		var setInternalState = InternalStateModule.set;
		var internalStateGetterFor = InternalStateModule.getterFor;

		collection = function (CONSTRUCTOR_NAME, wrapper, common) {
		  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
		  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
		  var ADDER = IS_MAP ? 'set' : 'add';
		  var NativeConstructor = globalThis[CONSTRUCTOR_NAME];
		  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
		  var exported = {};
		  var Constructor;

		  if (!DESCRIPTORS || !isCallable(NativeConstructor)
		    || !(IS_WEAK || NativePrototype.forEach && !fails(function () { new NativeConstructor().entries().next(); }))
		  ) {
		    // create collection constructor
		    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
		    InternalMetadataModule.enable();
		  } else {
		    Constructor = wrapper(function (target, iterable) {
		      setInternalState(anInstance(target, Prototype), {
		        type: CONSTRUCTOR_NAME,
		        collection: new NativeConstructor()
		      });
		      if (!isNullOrUndefined(iterable)) iterate(iterable, target[ADDER], { that: target, AS_ENTRIES: IS_MAP });
		    });

		    var Prototype = Constructor.prototype;

		    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

		    forEach(['add', 'clear', 'delete', 'forEach', 'get', 'has', 'set', 'keys', 'values', 'entries'], function (KEY) {
		      var IS_ADDER = KEY === 'add' || KEY === 'set';
		      if (KEY in NativePrototype && !(IS_WEAK && KEY === 'clear')) {
		        createNonEnumerableProperty(Prototype, KEY, function (a, b) {
		          var collection = getInternalState(this).collection;
		          if (!IS_ADDER && IS_WEAK && !isObject(a)) return KEY === 'get' ? undefined : false;
		          var result = collection[KEY](a === 0 ? 0 : a, b);
		          return IS_ADDER ? this : result;
		        });
		      }
		    });

		    IS_WEAK || defineProperty(Prototype, 'size', {
		      configurable: true,
		      get: function () {
		        return getInternalState(this).collection.size;
		      }
		    });
		  }

		  setToStringTag(Constructor, CONSTRUCTOR_NAME, false, true);

		  exported[CONSTRUCTOR_NAME] = Constructor;
		  $({ global: true, forced: true }, exported);

		  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);

		  return Constructor;
		};
		return collection;
	}

	var collectionStrong;
	var hasRequiredCollectionStrong;

	function requireCollectionStrong () {
		if (hasRequiredCollectionStrong) return collectionStrong;
		hasRequiredCollectionStrong = 1;
		var create = /*@__PURE__*/ requireObjectCreate();
		var defineBuiltInAccessor = /*@__PURE__*/ requireDefineBuiltInAccessor();
		var defineBuiltIns = /*@__PURE__*/ requireDefineBuiltIns();
		var bind = /*@__PURE__*/ requireFunctionBindContext();
		var anInstance = /*@__PURE__*/ requireAnInstance();
		var isNullOrUndefined = /*@__PURE__*/ requireIsNullOrUndefined();
		var iterate = /*@__PURE__*/ requireIterate();
		var defineIterator = /*@__PURE__*/ requireIteratorDefine();
		var createIterResultObject = /*@__PURE__*/ requireCreateIterResultObject();
		var setSpecies = /*@__PURE__*/ requireSetSpecies();
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var fastKey = /*@__PURE__*/ requireInternalMetadata().fastKey;
		var InternalStateModule = /*@__PURE__*/ requireInternalState();

		var setInternalState = InternalStateModule.set;
		var internalStateGetterFor = InternalStateModule.getterFor;

		collectionStrong = {
		  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
		    var Constructor = wrapper(function (that, iterable) {
		      anInstance(that, Prototype);
		      setInternalState(that, {
		        type: CONSTRUCTOR_NAME,
		        index: create(null),
		        first: null,
		        last: null,
		        size: 0
		      });
		      if (!DESCRIPTORS) that.size = 0;
		      if (!isNullOrUndefined(iterable)) iterate(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
		    });

		    var Prototype = Constructor.prototype;

		    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

		    var define = function (that, key, value) {
		      var state = getInternalState(that);
		      var entry = getEntry(that, key);
		      var previous, index;
		      // change existing entry
		      if (entry) {
		        entry.value = value;
		      // create new entry
		      } else {
		        state.last = entry = {
		          index: index = fastKey(key, true),
		          key: key,
		          value: value,
		          previous: previous = state.last,
		          next: null,
		          removed: false
		        };
		        if (!state.first) state.first = entry;
		        if (previous) previous.next = entry;
		        if (DESCRIPTORS) state.size++;
		        else that.size++;
		        // add to index
		        if (index !== 'F') state.index[index] = entry;
		      } return that;
		    };

		    var getEntry = function (that, key) {
		      var state = getInternalState(that);
		      // fast case
		      var index = fastKey(key);
		      var entry;
		      if (index !== 'F') return state.index[index];
		      // frozen object case
		      for (entry = state.first; entry; entry = entry.next) {
		        if (entry.key === key) return entry;
		      }
		    };

		    defineBuiltIns(Prototype, {
		      // `{ Map, Set }.prototype.clear()` methods
		      // https://tc39.es/ecma262/#sec-map.prototype.clear
		      // https://tc39.es/ecma262/#sec-set.prototype.clear
		      clear: function clear() {
		        var that = this;
		        var state = getInternalState(that);
		        var entry = state.first;
		        while (entry) {
		          entry.removed = true;
		          if (entry.previous) entry.previous = entry.previous.next = null;
		          entry = entry.next;
		        }
		        state.first = state.last = null;
		        state.index = create(null);
		        if (DESCRIPTORS) state.size = 0;
		        else that.size = 0;
		      },
		      // `{ Map, Set }.prototype.delete(key)` methods
		      // https://tc39.es/ecma262/#sec-map.prototype.delete
		      // https://tc39.es/ecma262/#sec-set.prototype.delete
		      'delete': function (key) {
		        var that = this;
		        var state = getInternalState(that);
		        var entry = getEntry(that, key);
		        if (entry) {
		          var next = entry.next;
		          var prev = entry.previous;
		          delete state.index[entry.index];
		          entry.removed = true;
		          if (prev) prev.next = next;
		          if (next) next.previous = prev;
		          if (state.first === entry) state.first = next;
		          if (state.last === entry) state.last = prev;
		          if (DESCRIPTORS) state.size--;
		          else that.size--;
		        } return !!entry;
		      },
		      // `{ Map, Set }.prototype.forEach(callbackfn, thisArg = undefined)` methods
		      // https://tc39.es/ecma262/#sec-map.prototype.foreach
		      // https://tc39.es/ecma262/#sec-set.prototype.foreach
		      forEach: function forEach(callbackfn /* , that = undefined */) {
		        var state = getInternalState(this);
		        var boundFunction = bind(callbackfn, arguments.length > 1 ? arguments[1] : undefined);
		        var entry;
		        while (entry = entry ? entry.next : state.first) {
		          boundFunction(entry.value, entry.key, this);
		          // revert to the last existing entry
		          while (entry && entry.removed) entry = entry.previous;
		        }
		      },
		      // `{ Map, Set}.prototype.has(key)` methods
		      // https://tc39.es/ecma262/#sec-map.prototype.has
		      // https://tc39.es/ecma262/#sec-set.prototype.has
		      has: function has(key) {
		        return !!getEntry(this, key);
		      }
		    });

		    defineBuiltIns(Prototype, IS_MAP ? {
		      // `Map.prototype.get(key)` method
		      // https://tc39.es/ecma262/#sec-map.prototype.get
		      get: function get(key) {
		        var entry = getEntry(this, key);
		        return entry && entry.value;
		      },
		      // `Map.prototype.set(key, value)` method
		      // https://tc39.es/ecma262/#sec-map.prototype.set
		      set: function set(key, value) {
		        return define(this, key === 0 ? 0 : key, value);
		      }
		    } : {
		      // `Set.prototype.add(value)` method
		      // https://tc39.es/ecma262/#sec-set.prototype.add
		      add: function add(value) {
		        return define(this, value = value === 0 ? 0 : value, value);
		      }
		    });
		    if (DESCRIPTORS) defineBuiltInAccessor(Prototype, 'size', {
		      configurable: true,
		      get: function () {
		        return getInternalState(this).size;
		      }
		    });
		    return Constructor;
		  },
		  setStrong: function (Constructor, CONSTRUCTOR_NAME, IS_MAP) {
		    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
		    var getInternalCollectionState = internalStateGetterFor(CONSTRUCTOR_NAME);
		    var getInternalIteratorState = internalStateGetterFor(ITERATOR_NAME);
		    // `{ Map, Set }.prototype.{ keys, values, entries, @@iterator }()` methods
		    // https://tc39.es/ecma262/#sec-map.prototype.entries
		    // https://tc39.es/ecma262/#sec-map.prototype.keys
		    // https://tc39.es/ecma262/#sec-map.prototype.values
		    // https://tc39.es/ecma262/#sec-map.prototype-@@iterator
		    // https://tc39.es/ecma262/#sec-set.prototype.entries
		    // https://tc39.es/ecma262/#sec-set.prototype.keys
		    // https://tc39.es/ecma262/#sec-set.prototype.values
		    // https://tc39.es/ecma262/#sec-set.prototype-@@iterator
		    defineIterator(Constructor, CONSTRUCTOR_NAME, function (iterated, kind) {
		      setInternalState(this, {
		        type: ITERATOR_NAME,
		        target: iterated,
		        state: getInternalCollectionState(iterated),
		        kind: kind,
		        last: null
		      });
		    }, function () {
		      var state = getInternalIteratorState(this);
		      var kind = state.kind;
		      var entry = state.last;
		      // revert to the last existing entry
		      while (entry && entry.removed) entry = entry.previous;
		      // get next entry
		      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
		        // or finish the iteration
		        state.target = null;
		        return createIterResultObject(undefined, true);
		      }
		      // return step by kind
		      if (kind === 'keys') return createIterResultObject(entry.key, false);
		      if (kind === 'values') return createIterResultObject(entry.value, false);
		      return createIterResultObject([entry.key, entry.value], false);
		    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

		    // `{ Map, Set }.prototype[@@species]` accessors
		    // https://tc39.es/ecma262/#sec-get-map-@@species
		    // https://tc39.es/ecma262/#sec-get-set-@@species
		    setSpecies(CONSTRUCTOR_NAME);
		  }
		};
		return collectionStrong;
	}

	var hasRequiredEs_map_constructor;

	function requireEs_map_constructor () {
		if (hasRequiredEs_map_constructor) return es_map_constructor;
		hasRequiredEs_map_constructor = 1;
		var collection = /*@__PURE__*/ requireCollection();
		var collectionStrong = /*@__PURE__*/ requireCollectionStrong();

		// `Map` constructor
		// https://tc39.es/ecma262/#sec-map-objects
		collection('Map', function (init) {
		  return function Map() { return init(this, arguments.length ? arguments[0] : undefined); };
		}, collectionStrong);
		return es_map_constructor;
	}

	var hasRequiredEs_map;

	function requireEs_map () {
		if (hasRequiredEs_map) return es_map;
		hasRequiredEs_map = 1;
		// TODO: Remove this module from `core-js@4` since it's replaced to module below
		requireEs_map_constructor();
		return es_map;
	}

	var es_map_groupBy = {};

	var caller;
	var hasRequiredCaller;

	function requireCaller () {
		if (hasRequiredCaller) return caller;
		hasRequiredCaller = 1;
		caller = function (methodName, numArgs) {
		  return numArgs === 1 ? function (object, arg) {
		    return object[methodName](arg);
		  } : function (object, arg1, arg2) {
		    return object[methodName](arg1, arg2);
		  };
		};
		return caller;
	}

	var mapHelpers;
	var hasRequiredMapHelpers;

	function requireMapHelpers () {
		if (hasRequiredMapHelpers) return mapHelpers;
		hasRequiredMapHelpers = 1;
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var caller = /*@__PURE__*/ requireCaller();

		var Map = getBuiltIn('Map');

		mapHelpers = {
		  Map: Map,
		  set: caller('set', 2),
		  get: caller('get', 1),
		  has: caller('has', 1),
		  remove: caller('delete', 1),
		  proto: Map.prototype
		};
		return mapHelpers;
	}

	var hasRequiredEs_map_groupBy;

	function requireEs_map_groupBy () {
		if (hasRequiredEs_map_groupBy) return es_map_groupBy;
		hasRequiredEs_map_groupBy = 1;
		var $ = /*@__PURE__*/ require_export();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var aCallable = /*@__PURE__*/ requireACallable();
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();
		var iterate = /*@__PURE__*/ requireIterate();
		var MapHelpers = /*@__PURE__*/ requireMapHelpers();
		var IS_PURE = /*@__PURE__*/ requireIsPure();
		var fails = /*@__PURE__*/ requireFails();

		var Map = MapHelpers.Map;
		var has = MapHelpers.has;
		var get = MapHelpers.get;
		var set = MapHelpers.set;
		var push = uncurryThis([].push);

		// https://bugs.webkit.org/show_bug.cgi?id=271524
		var DOES_NOT_WORK_WITH_PRIMITIVES = IS_PURE || fails(function () {
		  return Map.groupBy('ab', function (it) {
		    return it;
		  }).get('a').length !== 1;
		});

		// `Map.groupBy` method
		// https://tc39.es/ecma262/#sec-map.groupby
		$({ target: 'Map', stat: true, forced: IS_PURE || DOES_NOT_WORK_WITH_PRIMITIVES }, {
		  groupBy: function groupBy(items, callbackfn) {
		    requireObjectCoercible(items);
		    aCallable(callbackfn);
		    var map = new Map();
		    var k = 0;
		    iterate(items, function (value) {
		      var key = callbackfn(value, k++);
		      if (!has(map, key)) set(map, key, [value]);
		      else push(get(map, key), value);
		    });
		    return map;
		  }
		});
		return es_map_groupBy;
	}

	var map$5;
	var hasRequiredMap$5;

	function requireMap$5 () {
		if (hasRequiredMap$5) return map$5;
		hasRequiredMap$5 = 1;
		requireEs_array_iterator();
		requireEs_map();
		requireEs_map_groupBy();
		requireEs_string_iterator();
		var path = /*@__PURE__*/ requirePath$1();

		map$5 = path.Map;
		return map$5;
	}

	var map$4;
	var hasRequiredMap$4;

	function requireMap$4 () {
		if (hasRequiredMap$4) return map$4;
		hasRequiredMap$4 = 1;
		var parent = /*@__PURE__*/ requireMap$5();
		requireWeb_domCollections_iterator();

		map$4 = parent;
		return map$4;
	}

	var map$3;
	var hasRequiredMap$3;
	function requireMap$3() {
	  if (hasRequiredMap$3) return map$3;
	  hasRequiredMap$3 = 1;
	  map$3 = /*@__PURE__*/requireMap$4();
	  return map$3;
	}

	var mapExports$1 = requireMap$3();
	var _Map$1 = /*@__PURE__*/getDefaultExportFromCjs(mapExports$1);

	var es_object_entries = {};

	var objectToArray;
	var hasRequiredObjectToArray;

	function requireObjectToArray () {
		if (hasRequiredObjectToArray) return objectToArray;
		hasRequiredObjectToArray = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var fails = /*@__PURE__*/ requireFails();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var objectGetPrototypeOf = /*@__PURE__*/ requireObjectGetPrototypeOf();
		var objectKeys = /*@__PURE__*/ requireObjectKeys();
		var toIndexedObject = /*@__PURE__*/ requireToIndexedObject();
		var $propertyIsEnumerable = /*@__PURE__*/ requireObjectPropertyIsEnumerable().f;

		var propertyIsEnumerable = uncurryThis($propertyIsEnumerable);
		var push = uncurryThis([].push);

		// in some IE versions, `propertyIsEnumerable` returns incorrect result on integer keys
		// of `null` prototype objects
		var IE_BUG = DESCRIPTORS && fails(function () {
		  // eslint-disable-next-line es/no-object-create -- safe
		  var O = Object.create(null);
		  O[2] = 2;
		  return !propertyIsEnumerable(O, 2);
		});

		// `Object.{ entries, values }` methods implementation
		var createMethod = function (TO_ENTRIES) {
		  return function (it) {
		    var O = toIndexedObject(it);
		    var keys = objectKeys(O);
		    var IE_WORKAROUND = IE_BUG && objectGetPrototypeOf(O) === null;
		    var length = keys.length;
		    var i = 0;
		    var result = [];
		    var key;
		    while (length > i) {
		      key = keys[i++];
		      if (!DESCRIPTORS || (IE_WORKAROUND ? key in O : propertyIsEnumerable(O, key))) {
		        push(result, TO_ENTRIES ? [key, O[key]] : O[key]);
		      }
		    }
		    return result;
		  };
		};

		objectToArray = {
		  // `Object.entries` method
		  // https://tc39.es/ecma262/#sec-object.entries
		  entries: createMethod(true),
		  // `Object.values` method
		  // https://tc39.es/ecma262/#sec-object.values
		  values: createMethod(false)
		};
		return objectToArray;
	}

	var hasRequiredEs_object_entries;

	function requireEs_object_entries () {
		if (hasRequiredEs_object_entries) return es_object_entries;
		hasRequiredEs_object_entries = 1;
		var $ = /*@__PURE__*/ require_export();
		var $entries = /*@__PURE__*/ requireObjectToArray().entries;

		// `Object.entries` method
		// https://tc39.es/ecma262/#sec-object.entries
		$({ target: 'Object', stat: true }, {
		  entries: function entries(O) {
		    return $entries(O);
		  }
		});
		return es_object_entries;
	}

	var entries$6;
	var hasRequiredEntries$6;

	function requireEntries$6 () {
		if (hasRequiredEntries$6) return entries$6;
		hasRequiredEntries$6 = 1;
		requireEs_object_entries();
		var path = /*@__PURE__*/ requirePath$1();

		entries$6 = path.Object.entries;
		return entries$6;
	}

	var entries$5;
	var hasRequiredEntries$5;

	function requireEntries$5 () {
		if (hasRequiredEntries$5) return entries$5;
		hasRequiredEntries$5 = 1;
		var parent = /*@__PURE__*/ requireEntries$6();

		entries$5 = parent;
		return entries$5;
	}

	var entries$4;
	var hasRequiredEntries$4;
	function requireEntries$4() {
	  if (hasRequiredEntries$4) return entries$4;
	  hasRequiredEntries$4 = 1;
	  entries$4 = /*@__PURE__*/requireEntries$5();
	  return entries$4;
	}

	var entriesExports$1 = requireEntries$4();
	var _Object$entries = /*@__PURE__*/getDefaultExportFromCjs(entriesExports$1);

	var _for$2;
	var hasRequired_for$2;

	function require_for$2 () {
		if (hasRequired_for$2) return _for$2;
		hasRequired_for$2 = 1;
		requireEs_symbol();
		var path = /*@__PURE__*/ requirePath$1();

		_for$2 = path.Symbol['for'];
		return _for$2;
	}

	var _for$1;
	var hasRequired_for$1;

	function require_for$1 () {
		if (hasRequired_for$1) return _for$1;
		hasRequired_for$1 = 1;
		var parent = /*@__PURE__*/ require_for$2();

		_for$1 = parent;
		return _for$1;
	}

	var _for;
	var hasRequired_for;
	function require_for() {
	  if (hasRequired_for) return _for;
	  hasRequired_for = 1;
	  _for = /*@__PURE__*/require_for$1();
	  return _for;
	}

	var _forExports = require_for();
	var _Symbol$for = /*@__PURE__*/getDefaultExportFromCjs(_forExports);

	var esnext_globalThis = {};

	var es_globalThis = {};

	var hasRequiredEs_globalThis;

	function requireEs_globalThis () {
		if (hasRequiredEs_globalThis) return es_globalThis;
		hasRequiredEs_globalThis = 1;
		var $ = /*@__PURE__*/ require_export();
		var globalThis = /*@__PURE__*/ requireGlobalThis$6();

		// `globalThis` object
		// https://tc39.es/ecma262/#sec-globalthis
		$({ global: true, forced: globalThis.globalThis !== globalThis }, {
		  globalThis: globalThis
		});
		return es_globalThis;
	}

	var hasRequiredEsnext_globalThis;

	function requireEsnext_globalThis () {
		if (hasRequiredEsnext_globalThis) return esnext_globalThis;
		hasRequiredEsnext_globalThis = 1;
		// TODO: Remove from `core-js@4`
		requireEs_globalThis();
		return esnext_globalThis;
	}

	var globalThis$6;
	var hasRequiredGlobalThis$5;

	function requireGlobalThis$5 () {
		if (hasRequiredGlobalThis$5) return globalThis$6;
		hasRequiredGlobalThis$5 = 1;
		requireEs_globalThis();

		globalThis$6 = /*@__PURE__*/ requireGlobalThis$6();
		return globalThis$6;
	}

	var globalThis$5;
	var hasRequiredGlobalThis$4;

	function requireGlobalThis$4 () {
		if (hasRequiredGlobalThis$4) return globalThis$5;
		hasRequiredGlobalThis$4 = 1;
		var parent = /*@__PURE__*/ requireGlobalThis$5();

		globalThis$5 = parent;
		return globalThis$5;
	}

	var globalThis$4;
	var hasRequiredGlobalThis$3;

	function requireGlobalThis$3 () {
		if (hasRequiredGlobalThis$3) return globalThis$4;
		hasRequiredGlobalThis$3 = 1;
		var parent = /*@__PURE__*/ requireGlobalThis$4();

		globalThis$4 = parent;
		return globalThis$4;
	}

	var globalThis$3;
	var hasRequiredGlobalThis$2;

	function requireGlobalThis$2 () {
		if (hasRequiredGlobalThis$2) return globalThis$3;
		hasRequiredGlobalThis$2 = 1;
		// TODO: remove from `core-js@4`
		requireEsnext_globalThis();

		var parent = /*@__PURE__*/ requireGlobalThis$3();

		globalThis$3 = parent;
		return globalThis$3;
	}

	var globalThis$2;
	var hasRequiredGlobalThis$1;

	function requireGlobalThis$1 () {
		if (hasRequiredGlobalThis$1) return globalThis$2;
		hasRequiredGlobalThis$1 = 1;
		globalThis$2 = /*@__PURE__*/ requireGlobalThis$2();
		return globalThis$2;
	}

	var globalThis$1;
	var hasRequiredGlobalThis;
	function requireGlobalThis() {
	  if (hasRequiredGlobalThis) return globalThis$1;
	  hasRequiredGlobalThis = 1;
	  globalThis$1 = /*@__PURE__*/requireGlobalThis$1();
	  return globalThis$1;
	}

	var globalThisExports = requireGlobalThis();
	var _globalThis$3 = /*@__PURE__*/getDefaultExportFromCjs(globalThisExports);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// Updates to this file should also be replicated to @opentelemetry/core too.
	/**
	 * - globalThis (New standard)
	 * - self (Will return the current window instance for supported browsers)
	 * - window (fallback for older browser implementations)
	 * - global (NodeJS implementation)
	 * - <object> (When all else fails)
	 */
	/** only globals that common to node and browsers are allowed */
	// eslint-disable-next-line node/no-unsupported-features/es-builtins, no-undef
	var _globalThis$2 = (typeof _globalThis$3 === "undefined" ? "undefined" : _typeof$1(_globalThis$3)) === 'object' ? _globalThis$3 : (typeof self === "undefined" ? "undefined" : _typeof$1(self)) === 'object' ? self : (typeof window === "undefined" ? "undefined" : _typeof$1(window)) === 'object' ? window : (typeof global === "undefined" ? "undefined" : _typeof$1(global)) === 'object' ? global : {};

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// this is autogenerated file, see scripts/version-update.js
	var VERSION$6 = '1.9.0';

	var es_set = {};

	var es_set_constructor = {};

	var hasRequiredEs_set_constructor;

	function requireEs_set_constructor () {
		if (hasRequiredEs_set_constructor) return es_set_constructor;
		hasRequiredEs_set_constructor = 1;
		var collection = /*@__PURE__*/ requireCollection();
		var collectionStrong = /*@__PURE__*/ requireCollectionStrong();

		// `Set` constructor
		// https://tc39.es/ecma262/#sec-set-objects
		collection('Set', function (init) {
		  return function Set() { return init(this, arguments.length ? arguments[0] : undefined); };
		}, collectionStrong);
		return es_set_constructor;
	}

	var hasRequiredEs_set;

	function requireEs_set () {
		if (hasRequiredEs_set) return es_set;
		hasRequiredEs_set = 1;
		// TODO: Remove this module from `core-js@4` since it's replaced to module below
		requireEs_set_constructor();
		return es_set;
	}

	var es_set_difference_v2 = {};

	var aSet;
	var hasRequiredASet;

	function requireASet () {
		if (hasRequiredASet) return aSet;
		hasRequiredASet = 1;
		var tryToString = /*@__PURE__*/ requireTryToString();

		var $TypeError = TypeError;

		// Perform ? RequireInternalSlot(M, [[SetData]])
		aSet = function (it) {
		  if (typeof it == 'object' && 'size' in it && 'has' in it && 'add' in it && 'delete' in it && 'keys' in it) return it;
		  throw new $TypeError(tryToString(it) + ' is not a set');
		};
		return aSet;
	}

	var setHelpers;
	var hasRequiredSetHelpers;

	function requireSetHelpers () {
		if (hasRequiredSetHelpers) return setHelpers;
		hasRequiredSetHelpers = 1;
		var getBuiltIn = /*@__PURE__*/ requireGetBuiltIn();
		var caller = /*@__PURE__*/ requireCaller();

		var Set = getBuiltIn('Set');
		var SetPrototype = Set.prototype;

		setHelpers = {
		  Set: Set,
		  add: caller('add', 1),
		  has: caller('has', 1),
		  remove: caller('delete', 1),
		  proto: SetPrototype
		};
		return setHelpers;
	}

	var iterateSimple;
	var hasRequiredIterateSimple;

	function requireIterateSimple () {
		if (hasRequiredIterateSimple) return iterateSimple;
		hasRequiredIterateSimple = 1;
		var call = /*@__PURE__*/ requireFunctionCall();

		iterateSimple = function (record, fn, ITERATOR_INSTEAD_OF_RECORD) {
		  var iterator = ITERATOR_INSTEAD_OF_RECORD ? record : record.iterator;
		  var next = record.next;
		  var step, result;
		  while (!(step = call(next, iterator)).done) {
		    result = fn(step.value);
		    if (result !== undefined) return result;
		  }
		};
		return iterateSimple;
	}

	var setIterate;
	var hasRequiredSetIterate;

	function requireSetIterate () {
		if (hasRequiredSetIterate) return setIterate;
		hasRequiredSetIterate = 1;
		var iterateSimple = /*@__PURE__*/ requireIterateSimple();

		setIterate = function (set, fn, interruptible) {
		  return interruptible ? iterateSimple(set.keys(), fn, true) : set.forEach(fn);
		};
		return setIterate;
	}

	var setClone;
	var hasRequiredSetClone;

	function requireSetClone () {
		if (hasRequiredSetClone) return setClone;
		hasRequiredSetClone = 1;
		var SetHelpers = /*@__PURE__*/ requireSetHelpers();
		var iterate = /*@__PURE__*/ requireSetIterate();

		var Set = SetHelpers.Set;
		var add = SetHelpers.add;

		setClone = function (set) {
		  var result = new Set();
		  iterate(set, function (it) {
		    add(result, it);
		  });
		  return result;
		};
		return setClone;
	}

	var setSize;
	var hasRequiredSetSize;

	function requireSetSize () {
		if (hasRequiredSetSize) return setSize;
		hasRequiredSetSize = 1;
		setSize = function (set) {
		  return set.size;
		};
		return setSize;
	}

	var getIteratorDirect;
	var hasRequiredGetIteratorDirect;

	function requireGetIteratorDirect () {
		if (hasRequiredGetIteratorDirect) return getIteratorDirect;
		hasRequiredGetIteratorDirect = 1;
		// `GetIteratorDirect(obj)` abstract operation
		// https://tc39.es/proposal-iterator-helpers/#sec-getiteratordirect
		getIteratorDirect = function (obj) {
		  return {
		    iterator: obj,
		    next: obj.next,
		    done: false
		  };
		};
		return getIteratorDirect;
	}

	var getSetRecord;
	var hasRequiredGetSetRecord;

	function requireGetSetRecord () {
		if (hasRequiredGetSetRecord) return getSetRecord;
		hasRequiredGetSetRecord = 1;
		var aCallable = /*@__PURE__*/ requireACallable();
		var anObject = /*@__PURE__*/ requireAnObject();
		var call = /*@__PURE__*/ requireFunctionCall();
		var toIntegerOrInfinity = /*@__PURE__*/ requireToIntegerOrInfinity();
		var getIteratorDirect = /*@__PURE__*/ requireGetIteratorDirect();

		var INVALID_SIZE = 'Invalid size';
		var $RangeError = RangeError;
		var $TypeError = TypeError;
		var max = Math.max;

		var SetRecord = function (set, intSize) {
		  this.set = set;
		  this.size = max(intSize, 0);
		  this.has = aCallable(set.has);
		  this.keys = aCallable(set.keys);
		};

		SetRecord.prototype = {
		  getIterator: function () {
		    return getIteratorDirect(anObject(call(this.keys, this.set)));
		  },
		  includes: function (it) {
		    return call(this.has, this.set, it);
		  }
		};

		// `GetSetRecord` abstract operation
		// https://tc39.es/proposal-set-methods/#sec-getsetrecord
		getSetRecord = function (obj) {
		  anObject(obj);
		  var numSize = +obj.size;
		  // NOTE: If size is undefined, then numSize will be NaN
		  // eslint-disable-next-line no-self-compare -- NaN check
		  if (numSize !== numSize) throw new $TypeError(INVALID_SIZE);
		  var intSize = toIntegerOrInfinity(numSize);
		  if (intSize < 0) throw new $RangeError(INVALID_SIZE);
		  return new SetRecord(obj, intSize);
		};
		return getSetRecord;
	}

	var setDifference;
	var hasRequiredSetDifference;

	function requireSetDifference () {
		if (hasRequiredSetDifference) return setDifference;
		hasRequiredSetDifference = 1;
		var aSet = /*@__PURE__*/ requireASet();
		var SetHelpers = /*@__PURE__*/ requireSetHelpers();
		var clone = /*@__PURE__*/ requireSetClone();
		var size = /*@__PURE__*/ requireSetSize();
		var getSetRecord = /*@__PURE__*/ requireGetSetRecord();
		var iterateSet = /*@__PURE__*/ requireSetIterate();
		var iterateSimple = /*@__PURE__*/ requireIterateSimple();

		var has = SetHelpers.has;
		var remove = SetHelpers.remove;

		// `Set.prototype.difference` method
		// https://github.com/tc39/proposal-set-methods
		setDifference = function difference(other) {
		  var O = aSet(this);
		  var otherRec = getSetRecord(other);
		  var result = clone(O);
		  if (size(O) <= otherRec.size) iterateSet(O, function (e) {
		    if (otherRec.includes(e)) remove(result, e);
		  });
		  else iterateSimple(otherRec.getIterator(), function (e) {
		    if (has(O, e)) remove(result, e);
		  });
		  return result;
		};
		return setDifference;
	}

	var setMethodAcceptSetLike;
	var hasRequiredSetMethodAcceptSetLike;

	function requireSetMethodAcceptSetLike () {
		if (hasRequiredSetMethodAcceptSetLike) return setMethodAcceptSetLike;
		hasRequiredSetMethodAcceptSetLike = 1;
		setMethodAcceptSetLike = function () {
		  return false;
		};
		return setMethodAcceptSetLike;
	}

	var hasRequiredEs_set_difference_v2;

	function requireEs_set_difference_v2 () {
		if (hasRequiredEs_set_difference_v2) return es_set_difference_v2;
		hasRequiredEs_set_difference_v2 = 1;
		var $ = /*@__PURE__*/ require_export();
		var difference = /*@__PURE__*/ requireSetDifference();
		var setMethodAcceptSetLike = /*@__PURE__*/ requireSetMethodAcceptSetLike();

		var INCORRECT = !setMethodAcceptSetLike('difference', function (result) {
		  return result.size === 0;
		});

		// `Set.prototype.difference` method
		// https://tc39.es/ecma262/#sec-set.prototype.difference
		$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
		  difference: difference
		});
		return es_set_difference_v2;
	}

	var es_set_intersection_v2 = {};

	var setIntersection;
	var hasRequiredSetIntersection;

	function requireSetIntersection () {
		if (hasRequiredSetIntersection) return setIntersection;
		hasRequiredSetIntersection = 1;
		var aSet = /*@__PURE__*/ requireASet();
		var SetHelpers = /*@__PURE__*/ requireSetHelpers();
		var size = /*@__PURE__*/ requireSetSize();
		var getSetRecord = /*@__PURE__*/ requireGetSetRecord();
		var iterateSet = /*@__PURE__*/ requireSetIterate();
		var iterateSimple = /*@__PURE__*/ requireIterateSimple();

		var Set = SetHelpers.Set;
		var add = SetHelpers.add;
		var has = SetHelpers.has;

		// `Set.prototype.intersection` method
		// https://github.com/tc39/proposal-set-methods
		setIntersection = function intersection(other) {
		  var O = aSet(this);
		  var otherRec = getSetRecord(other);
		  var result = new Set();

		  if (size(O) > otherRec.size) {
		    iterateSimple(otherRec.getIterator(), function (e) {
		      if (has(O, e)) add(result, e);
		    });
		  } else {
		    iterateSet(O, function (e) {
		      if (otherRec.includes(e)) add(result, e);
		    });
		  }

		  return result;
		};
		return setIntersection;
	}

	var hasRequiredEs_set_intersection_v2;

	function requireEs_set_intersection_v2 () {
		if (hasRequiredEs_set_intersection_v2) return es_set_intersection_v2;
		hasRequiredEs_set_intersection_v2 = 1;
		var $ = /*@__PURE__*/ require_export();
		var fails = /*@__PURE__*/ requireFails();
		var intersection = /*@__PURE__*/ requireSetIntersection();
		var setMethodAcceptSetLike = /*@__PURE__*/ requireSetMethodAcceptSetLike();

		var INCORRECT = !setMethodAcceptSetLike('intersection', function (result) {
		  return result.size === 2 && result.has(1) && result.has(2);
		}) || fails(function () {
		  // eslint-disable-next-line es/no-array-from, es/no-set, es/no-set-prototype-intersection -- testing
		  return String(Array.from(new Set([1, 2, 3]).intersection(new Set([3, 2])))) !== '3,2';
		});

		// `Set.prototype.intersection` method
		// https://tc39.es/ecma262/#sec-set.prototype.intersection
		$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
		  intersection: intersection
		});
		return es_set_intersection_v2;
	}

	var es_set_isDisjointFrom_v2 = {};

	var setIsDisjointFrom;
	var hasRequiredSetIsDisjointFrom;

	function requireSetIsDisjointFrom () {
		if (hasRequiredSetIsDisjointFrom) return setIsDisjointFrom;
		hasRequiredSetIsDisjointFrom = 1;
		var aSet = /*@__PURE__*/ requireASet();
		var has = /*@__PURE__*/ requireSetHelpers().has;
		var size = /*@__PURE__*/ requireSetSize();
		var getSetRecord = /*@__PURE__*/ requireGetSetRecord();
		var iterateSet = /*@__PURE__*/ requireSetIterate();
		var iterateSimple = /*@__PURE__*/ requireIterateSimple();
		var iteratorClose = /*@__PURE__*/ requireIteratorClose();

		// `Set.prototype.isDisjointFrom` method
		// https://tc39.github.io/proposal-set-methods/#Set.prototype.isDisjointFrom
		setIsDisjointFrom = function isDisjointFrom(other) {
		  var O = aSet(this);
		  var otherRec = getSetRecord(other);
		  if (size(O) <= otherRec.size) return iterateSet(O, function (e) {
		    if (otherRec.includes(e)) return false;
		  }, true) !== false;
		  var iterator = otherRec.getIterator();
		  return iterateSimple(iterator, function (e) {
		    if (has(O, e)) return iteratorClose(iterator, 'normal', false);
		  }) !== false;
		};
		return setIsDisjointFrom;
	}

	var hasRequiredEs_set_isDisjointFrom_v2;

	function requireEs_set_isDisjointFrom_v2 () {
		if (hasRequiredEs_set_isDisjointFrom_v2) return es_set_isDisjointFrom_v2;
		hasRequiredEs_set_isDisjointFrom_v2 = 1;
		var $ = /*@__PURE__*/ require_export();
		var isDisjointFrom = /*@__PURE__*/ requireSetIsDisjointFrom();
		var setMethodAcceptSetLike = /*@__PURE__*/ requireSetMethodAcceptSetLike();

		var INCORRECT = !setMethodAcceptSetLike('isDisjointFrom', function (result) {
		  return !result;
		});

		// `Set.prototype.isDisjointFrom` method
		// https://tc39.es/ecma262/#sec-set.prototype.isdisjointfrom
		$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
		  isDisjointFrom: isDisjointFrom
		});
		return es_set_isDisjointFrom_v2;
	}

	var es_set_isSubsetOf_v2 = {};

	var setIsSubsetOf;
	var hasRequiredSetIsSubsetOf;

	function requireSetIsSubsetOf () {
		if (hasRequiredSetIsSubsetOf) return setIsSubsetOf;
		hasRequiredSetIsSubsetOf = 1;
		var aSet = /*@__PURE__*/ requireASet();
		var size = /*@__PURE__*/ requireSetSize();
		var iterate = /*@__PURE__*/ requireSetIterate();
		var getSetRecord = /*@__PURE__*/ requireGetSetRecord();

		// `Set.prototype.isSubsetOf` method
		// https://tc39.github.io/proposal-set-methods/#Set.prototype.isSubsetOf
		setIsSubsetOf = function isSubsetOf(other) {
		  var O = aSet(this);
		  var otherRec = getSetRecord(other);
		  if (size(O) > otherRec.size) return false;
		  return iterate(O, function (e) {
		    if (!otherRec.includes(e)) return false;
		  }, true) !== false;
		};
		return setIsSubsetOf;
	}

	var hasRequiredEs_set_isSubsetOf_v2;

	function requireEs_set_isSubsetOf_v2 () {
		if (hasRequiredEs_set_isSubsetOf_v2) return es_set_isSubsetOf_v2;
		hasRequiredEs_set_isSubsetOf_v2 = 1;
		var $ = /*@__PURE__*/ require_export();
		var isSubsetOf = /*@__PURE__*/ requireSetIsSubsetOf();
		var setMethodAcceptSetLike = /*@__PURE__*/ requireSetMethodAcceptSetLike();

		var INCORRECT = !setMethodAcceptSetLike('isSubsetOf', function (result) {
		  return result;
		});

		// `Set.prototype.isSubsetOf` method
		// https://tc39.es/ecma262/#sec-set.prototype.issubsetof
		$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
		  isSubsetOf: isSubsetOf
		});
		return es_set_isSubsetOf_v2;
	}

	var es_set_isSupersetOf_v2 = {};

	var setIsSupersetOf;
	var hasRequiredSetIsSupersetOf;

	function requireSetIsSupersetOf () {
		if (hasRequiredSetIsSupersetOf) return setIsSupersetOf;
		hasRequiredSetIsSupersetOf = 1;
		var aSet = /*@__PURE__*/ requireASet();
		var has = /*@__PURE__*/ requireSetHelpers().has;
		var size = /*@__PURE__*/ requireSetSize();
		var getSetRecord = /*@__PURE__*/ requireGetSetRecord();
		var iterateSimple = /*@__PURE__*/ requireIterateSimple();
		var iteratorClose = /*@__PURE__*/ requireIteratorClose();

		// `Set.prototype.isSupersetOf` method
		// https://tc39.github.io/proposal-set-methods/#Set.prototype.isSupersetOf
		setIsSupersetOf = function isSupersetOf(other) {
		  var O = aSet(this);
		  var otherRec = getSetRecord(other);
		  if (size(O) < otherRec.size) return false;
		  var iterator = otherRec.getIterator();
		  return iterateSimple(iterator, function (e) {
		    if (!has(O, e)) return iteratorClose(iterator, 'normal', false);
		  }) !== false;
		};
		return setIsSupersetOf;
	}

	var hasRequiredEs_set_isSupersetOf_v2;

	function requireEs_set_isSupersetOf_v2 () {
		if (hasRequiredEs_set_isSupersetOf_v2) return es_set_isSupersetOf_v2;
		hasRequiredEs_set_isSupersetOf_v2 = 1;
		var $ = /*@__PURE__*/ require_export();
		var isSupersetOf = /*@__PURE__*/ requireSetIsSupersetOf();
		var setMethodAcceptSetLike = /*@__PURE__*/ requireSetMethodAcceptSetLike();

		var INCORRECT = !setMethodAcceptSetLike('isSupersetOf', function (result) {
		  return !result;
		});

		// `Set.prototype.isSupersetOf` method
		// https://tc39.es/ecma262/#sec-set.prototype.issupersetof
		$({ target: 'Set', proto: true, real: true, forced: INCORRECT }, {
		  isSupersetOf: isSupersetOf
		});
		return es_set_isSupersetOf_v2;
	}

	var es_set_symmetricDifference_v2 = {};

	var setSymmetricDifference;
	var hasRequiredSetSymmetricDifference;

	function requireSetSymmetricDifference () {
		if (hasRequiredSetSymmetricDifference) return setSymmetricDifference;
		hasRequiredSetSymmetricDifference = 1;
		var aSet = /*@__PURE__*/ requireASet();
		var SetHelpers = /*@__PURE__*/ requireSetHelpers();
		var clone = /*@__PURE__*/ requireSetClone();
		var getSetRecord = /*@__PURE__*/ requireGetSetRecord();
		var iterateSimple = /*@__PURE__*/ requireIterateSimple();

		var add = SetHelpers.add;
		var has = SetHelpers.has;
		var remove = SetHelpers.remove;

		// `Set.prototype.symmetricDifference` method
		// https://github.com/tc39/proposal-set-methods
		setSymmetricDifference = function symmetricDifference(other) {
		  var O = aSet(this);
		  var keysIter = getSetRecord(other).getIterator();
		  var result = clone(O);
		  iterateSimple(keysIter, function (e) {
		    if (has(O, e)) remove(result, e);
		    else add(result, e);
		  });
		  return result;
		};
		return setSymmetricDifference;
	}

	var hasRequiredEs_set_symmetricDifference_v2;

	function requireEs_set_symmetricDifference_v2 () {
		if (hasRequiredEs_set_symmetricDifference_v2) return es_set_symmetricDifference_v2;
		hasRequiredEs_set_symmetricDifference_v2 = 1;
		var $ = /*@__PURE__*/ require_export();
		var symmetricDifference = /*@__PURE__*/ requireSetSymmetricDifference();
		var setMethodAcceptSetLike = /*@__PURE__*/ requireSetMethodAcceptSetLike();

		// `Set.prototype.symmetricDifference` method
		// https://tc39.es/ecma262/#sec-set.prototype.symmetricdifference
		$({ target: 'Set', proto: true, real: true, forced: !setMethodAcceptSetLike('symmetricDifference') }, {
		  symmetricDifference: symmetricDifference
		});
		return es_set_symmetricDifference_v2;
	}

	var es_set_union_v2 = {};

	var setUnion;
	var hasRequiredSetUnion;

	function requireSetUnion () {
		if (hasRequiredSetUnion) return setUnion;
		hasRequiredSetUnion = 1;
		var aSet = /*@__PURE__*/ requireASet();
		var add = /*@__PURE__*/ requireSetHelpers().add;
		var clone = /*@__PURE__*/ requireSetClone();
		var getSetRecord = /*@__PURE__*/ requireGetSetRecord();
		var iterateSimple = /*@__PURE__*/ requireIterateSimple();

		// `Set.prototype.union` method
		// https://github.com/tc39/proposal-set-methods
		setUnion = function union(other) {
		  var O = aSet(this);
		  var keysIter = getSetRecord(other).getIterator();
		  var result = clone(O);
		  iterateSimple(keysIter, function (it) {
		    add(result, it);
		  });
		  return result;
		};
		return setUnion;
	}

	var hasRequiredEs_set_union_v2;

	function requireEs_set_union_v2 () {
		if (hasRequiredEs_set_union_v2) return es_set_union_v2;
		hasRequiredEs_set_union_v2 = 1;
		var $ = /*@__PURE__*/ require_export();
		var union = /*@__PURE__*/ requireSetUnion();
		var setMethodAcceptSetLike = /*@__PURE__*/ requireSetMethodAcceptSetLike();

		// `Set.prototype.union` method
		// https://tc39.es/ecma262/#sec-set.prototype.union
		$({ target: 'Set', proto: true, real: true, forced: !setMethodAcceptSetLike('union') }, {
		  union: union
		});
		return es_set_union_v2;
	}

	var set$2;
	var hasRequiredSet$2;

	function requireSet$2 () {
		if (hasRequiredSet$2) return set$2;
		hasRequiredSet$2 = 1;
		requireEs_array_iterator();
		requireEs_set();
		requireEs_set_difference_v2();
		requireEs_set_intersection_v2();
		requireEs_set_isDisjointFrom_v2();
		requireEs_set_isSubsetOf_v2();
		requireEs_set_isSupersetOf_v2();
		requireEs_set_symmetricDifference_v2();
		requireEs_set_union_v2();
		requireEs_string_iterator();
		var path = /*@__PURE__*/ requirePath$1();

		set$2 = path.Set;
		return set$2;
	}

	var set$1;
	var hasRequiredSet$1;

	function requireSet$1 () {
		if (hasRequiredSet$1) return set$1;
		hasRequiredSet$1 = 1;
		var parent = /*@__PURE__*/ requireSet$2();
		requireWeb_domCollections_iterator();

		set$1 = parent;
		return set$1;
	}

	var set;
	var hasRequiredSet;
	function requireSet() {
	  if (hasRequiredSet) return set;
	  hasRequiredSet = 1;
	  set = /*@__PURE__*/requireSet$1();
	  return set;
	}

	var setExports = requireSet();
	var _Set = /*@__PURE__*/getDefaultExportFromCjs(setExports);

	var re = /^(\d+)\.(\d+)\.(\d+)(-(.+))?$/;
	/**
	 * Create a function to test an API version to see if it is compatible with the provided ownVersion.
	 *
	 * The returned function has the following semantics:
	 * - Exact match is always compatible
	 * - Major versions must match exactly
	 *    - 1.x package cannot use global 2.x package
	 *    - 2.x package cannot use global 1.x package
	 * - The minor version of the API module requesting access to the global API must be less than or equal to the minor version of this API
	 *    - 1.3 package may use 1.4 global because the later global contains all functions 1.3 expects
	 *    - 1.4 package may NOT use 1.3 global because it may try to call functions which don't exist on 1.3
	 * - If the major version is 0, the minor version is treated as the major and the patch is treated as the minor
	 * - Patch and build tag differences are not considered at this time
	 *
	 * @param ownVersion version which should be checked against
	 */
	function _makeCompatibilityCheck(ownVersion) {
	  var acceptedVersions = new _Set([ownVersion]);
	  var rejectedVersions = new _Set();
	  var myVersionMatch = ownVersion.match(re);
	  if (!myVersionMatch) {
	    // we cannot guarantee compatibility so we always return noop
	    return function () {
	      return false;
	    };
	  }
	  var ownVersionParsed = {
	    major: +myVersionMatch[1],
	    minor: +myVersionMatch[2],
	    patch: +myVersionMatch[3],
	    prerelease: myVersionMatch[4]
	  };
	  // if ownVersion has a prerelease tag, versions must match exactly
	  if (ownVersionParsed.prerelease != null) {
	    return function isExactmatch(globalVersion) {
	      return globalVersion === ownVersion;
	    };
	  }
	  function _reject(v) {
	    rejectedVersions.add(v);
	    return false;
	  }
	  function _accept(v) {
	    acceptedVersions.add(v);
	    return true;
	  }
	  return function isCompatible(globalVersion) {
	    if (acceptedVersions.has(globalVersion)) {
	      return true;
	    }
	    if (rejectedVersions.has(globalVersion)) {
	      return false;
	    }
	    var globalVersionMatch = globalVersion.match(re);
	    if (!globalVersionMatch) {
	      // cannot parse other version
	      // we cannot guarantee compatibility so we always noop
	      return _reject(globalVersion);
	    }
	    var globalVersionParsed = {
	      major: +globalVersionMatch[1],
	      minor: +globalVersionMatch[2],
	      patch: +globalVersionMatch[3],
	      prerelease: globalVersionMatch[4]
	    };
	    // if globalVersion has a prerelease tag, versions must match exactly
	    if (globalVersionParsed.prerelease != null) {
	      return _reject(globalVersion);
	    }
	    // major versions must match
	    if (ownVersionParsed.major !== globalVersionParsed.major) {
	      return _reject(globalVersion);
	    }
	    if (ownVersionParsed.major === 0) {
	      if (ownVersionParsed.minor === globalVersionParsed.minor && ownVersionParsed.patch <= globalVersionParsed.patch) {
	        return _accept(globalVersion);
	      }
	      return _reject(globalVersion);
	    }
	    if (ownVersionParsed.minor <= globalVersionParsed.minor) {
	      return _accept(globalVersion);
	    }
	    return _reject(globalVersion);
	  };
	}
	/**
	 * Test an API version to see if it is compatible with this API.
	 *
	 * - Exact match is always compatible
	 * - Major versions must match exactly
	 *    - 1.x package cannot use global 2.x package
	 *    - 2.x package cannot use global 1.x package
	 * - The minor version of the API module requesting access to the global API must be less than or equal to the minor version of this API
	 *    - 1.3 package may use 1.4 global because the later global contains all functions 1.3 expects
	 *    - 1.4 package may NOT use 1.3 global because it may try to call functions which don't exist on 1.3
	 * - If the major version is 0, the minor version is treated as the major and the patch is treated as the minor
	 * - Patch and build tag differences are not considered at this time
	 *
	 * @param version version of the API requesting an instance of the global API
	 */
	var isCompatible = _makeCompatibilityCheck(VERSION$6);

	var major = VERSION$6.split('.')[0];
	var GLOBAL_OPENTELEMETRY_API_KEY = _Symbol$for("opentelemetry.js.api." + major);
	var _global$1 = _globalThis$2;
	function registerGlobal(type, instance, diag, allowOverride) {
	  var _a;
	  if (allowOverride === void 0) {
	    allowOverride = false;
	  }
	  var api = _global$1[GLOBAL_OPENTELEMETRY_API_KEY] = (_a = _global$1[GLOBAL_OPENTELEMETRY_API_KEY]) !== null && _a !== void 0 ? _a : {
	    version: VERSION$6
	  };
	  if (!allowOverride && api[type]) {
	    // already registered an API of this type
	    var err = new Error("@opentelemetry/api: Attempted duplicate registration of API: " + type);
	    diag.error(err.stack || err.message);
	    return false;
	  }
	  if (api.version !== VERSION$6) {
	    // All registered APIs must be of the same version exactly
	    var err = new Error("@opentelemetry/api: Registration of version v" + api.version + " for " + type + " does not match previously registered API v" + VERSION$6);
	    diag.error(err.stack || err.message);
	    return false;
	  }
	  api[type] = instance;
	  diag.debug("@opentelemetry/api: Registered a global for " + type + " v" + VERSION$6 + ".");
	  return true;
	}
	function getGlobal(type) {
	  var _a, _b;
	  var globalVersion = (_a = _global$1[GLOBAL_OPENTELEMETRY_API_KEY]) === null || _a === void 0 ? void 0 : _a.version;
	  if (!globalVersion || !isCompatible(globalVersion)) {
	    return;
	  }
	  return (_b = _global$1[GLOBAL_OPENTELEMETRY_API_KEY]) === null || _b === void 0 ? void 0 : _b[type];
	}
	function unregisterGlobal(type, diag) {
	  diag.debug("@opentelemetry/api: Unregistering a global for " + type + " v" + VERSION$6 + ".");
	  var api = _global$1[GLOBAL_OPENTELEMETRY_API_KEY];
	  if (api) {
	    delete api[type];
	  }
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __read$u = undefined && undefined.__read || function (o, n) {
	  var m = typeof _Symbol$1 === "function" && _getIteratorMethod$1(o);
	  if (!m) return o;
	  var i = m.call(o),
	    r,
	    ar = [],
	    e;
	  try {
	    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
	  } catch (error) {
	    e = {
	      error: error
	    };
	  } finally {
	    try {
	      if (r && !r.done && (m = i["return"])) m.call(i);
	    } finally {
	      if (e) throw e.error;
	    }
	  }
	  return ar;
	};
	var __spreadArray$f = undefined && undefined.__spreadArray || function (to, from, pack) {
	  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
	    if (ar || !(i in from)) {
	      if (!ar) ar = _sliceInstanceProperty$1(Array.prototype).call(from, 0, i);
	      ar[i] = from[i];
	    }
	  }
	  return _concatInstanceProperty(to).call(to, ar || _sliceInstanceProperty$1(Array.prototype).call(from));
	};
	/**
	 * Component Logger which is meant to be used as part of any component which
	 * will add automatically additional namespace in front of the log message.
	 * It will then forward all message to global diag logger
	 * @example
	 * const cLogger = diag.createComponentLogger({ namespace: '@opentelemetry/instrumentation-http' });
	 * cLogger.debug('test');
	 * // @opentelemetry/instrumentation-http test
	 */
	var DiagComponentLogger = /** @class */function () {
	  function DiagComponentLogger(props) {
	    this._namespace = props.namespace || 'DiagComponentLogger';
	  }
	  DiagComponentLogger.prototype.debug = function () {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	      args[_i] = arguments[_i];
	    }
	    return logProxy('debug', this._namespace, args);
	  };
	  DiagComponentLogger.prototype.error = function () {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	      args[_i] = arguments[_i];
	    }
	    return logProxy('error', this._namespace, args);
	  };
	  DiagComponentLogger.prototype.info = function () {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	      args[_i] = arguments[_i];
	    }
	    return logProxy('info', this._namespace, args);
	  };
	  DiagComponentLogger.prototype.warn = function () {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	      args[_i] = arguments[_i];
	    }
	    return logProxy('warn', this._namespace, args);
	  };
	  DiagComponentLogger.prototype.verbose = function () {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	      args[_i] = arguments[_i];
	    }
	    return logProxy('verbose', this._namespace, args);
	  };
	  return DiagComponentLogger;
	}();
	function logProxy(funcName, namespace, args) {
	  var logger = getGlobal('diag');
	  // shortcut if logger not set
	  if (!logger) {
	    return;
	  }
	  args.unshift(namespace);
	  return logger[funcName].apply(logger, __spreadArray$f([], __read$u(args), false));
	}

	var bind;
	var hasRequiredBind;
	function requireBind() {
	  if (hasRequiredBind) return bind;
	  hasRequiredBind = 1;
	  bind = /*@__PURE__*/requireBind$4();
	  return bind;
	}

	var bindExports = requireBind();
	var _bindInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(bindExports);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * Defines the available internal logging levels for the diagnostic logger, the numeric values
	 * of the levels are defined to match the original values from the initial LogLevel to avoid
	 * compatibility/migration issues for any implementation that assume the numeric ordering.
	 */
	var DiagLogLevel;
	(function (DiagLogLevel) {
	  /** Diagnostic Logging level setting to disable all logging (except and forced logs) */
	  DiagLogLevel[DiagLogLevel["NONE"] = 0] = "NONE";
	  /** Identifies an error scenario */
	  DiagLogLevel[DiagLogLevel["ERROR"] = 30] = "ERROR";
	  /** Identifies a warning scenario */
	  DiagLogLevel[DiagLogLevel["WARN"] = 50] = "WARN";
	  /** General informational log message */
	  DiagLogLevel[DiagLogLevel["INFO"] = 60] = "INFO";
	  /** General debug log message */
	  DiagLogLevel[DiagLogLevel["DEBUG"] = 70] = "DEBUG";
	  /**
	   * Detailed trace level logging should only be used for development, should only be set
	   * in a development environment.
	   */
	  DiagLogLevel[DiagLogLevel["VERBOSE"] = 80] = "VERBOSE";
	  /** Used to set the logging level to include all logging */
	  DiagLogLevel[DiagLogLevel["ALL"] = 9999] = "ALL";
	})(DiagLogLevel || (DiagLogLevel = {}));

	function createLogLevelDiagLogger(maxLevel, logger) {
	  if (maxLevel < DiagLogLevel.NONE) {
	    maxLevel = DiagLogLevel.NONE;
	  } else if (maxLevel > DiagLogLevel.ALL) {
	    maxLevel = DiagLogLevel.ALL;
	  }
	  // In case the logger is null or undefined
	  logger = logger || {};
	  function _filterFunc(funcName, theLevel) {
	    var theFunc = logger[funcName];
	    if (typeof theFunc === 'function' && maxLevel >= theLevel) {
	      return _bindInstanceProperty(theFunc).call(theFunc, logger);
	    }
	    return function () {};
	  }
	  return {
	    error: _filterFunc('error', DiagLogLevel.ERROR),
	    warn: _filterFunc('warn', DiagLogLevel.WARN),
	    info: _filterFunc('info', DiagLogLevel.INFO),
	    debug: _filterFunc('debug', DiagLogLevel.DEBUG),
	    verbose: _filterFunc('verbose', DiagLogLevel.VERBOSE)
	  };
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __read$t = undefined && undefined.__read || function (o, n) {
	  var m = typeof _Symbol$1 === "function" && _getIteratorMethod$1(o);
	  if (!m) return o;
	  var i = m.call(o),
	    r,
	    ar = [],
	    e;
	  try {
	    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
	  } catch (error) {
	    e = {
	      error: error
	    };
	  } finally {
	    try {
	      if (r && !r.done && (m = i["return"])) m.call(i);
	    } finally {
	      if (e) throw e.error;
	    }
	  }
	  return ar;
	};
	var __spreadArray$e = undefined && undefined.__spreadArray || function (to, from, pack) {
	  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
	    if (ar || !(i in from)) {
	      if (!ar) ar = _sliceInstanceProperty$1(Array.prototype).call(from, 0, i);
	      ar[i] = from[i];
	    }
	  }
	  return _concatInstanceProperty(to).call(to, ar || _sliceInstanceProperty$1(Array.prototype).call(from));
	};
	var API_NAME$4 = 'diag';
	/**
	 * Singleton object which represents the entry point to the OpenTelemetry internal
	 * diagnostic API
	 */
	var DiagAPI = /** @class */function () {
	  /**
	   * Private internal constructor
	   * @private
	   */
	  function DiagAPI() {
	    function _logProxy(funcName) {
	      return function () {
	        var args = [];
	        for (var _i = 0; _i < arguments.length; _i++) {
	          args[_i] = arguments[_i];
	        }
	        var logger = getGlobal('diag');
	        // shortcut if logger not set
	        if (!logger) return;
	        return logger[funcName].apply(logger, __spreadArray$e([], __read$t(args), false));
	      };
	    }
	    // Using self local variable for minification purposes as 'this' cannot be minified
	    var self = this;
	    // DiagAPI specific functions
	    var setLogger = function setLogger(logger, optionsOrLogLevel) {
	      var _a, _b, _c;
	      if (optionsOrLogLevel === void 0) {
	        optionsOrLogLevel = {
	          logLevel: DiagLogLevel.INFO
	        };
	      }
	      if (logger === self) {
	        // There isn't much we can do here.
	        // Logging to the console might break the user application.
	        // Try to log to self. If a logger was previously registered it will receive the log.
	        var err = new Error('Cannot use diag as the logger for itself. Please use a DiagLogger implementation like ConsoleDiagLogger or a custom implementation');
	        self.error((_a = err.stack) !== null && _a !== void 0 ? _a : err.message);
	        return false;
	      }
	      if (typeof optionsOrLogLevel === 'number') {
	        optionsOrLogLevel = {
	          logLevel: optionsOrLogLevel
	        };
	      }
	      var oldLogger = getGlobal('diag');
	      var newLogger = createLogLevelDiagLogger((_b = optionsOrLogLevel.logLevel) !== null && _b !== void 0 ? _b : DiagLogLevel.INFO, logger);
	      // There already is an logger registered. We'll let it know before overwriting it.
	      if (oldLogger && !optionsOrLogLevel.suppressOverrideMessage) {
	        var stack = (_c = new Error().stack) !== null && _c !== void 0 ? _c : '<failed to generate stacktrace>';
	        oldLogger.warn("Current logger will be overwritten from " + stack);
	        newLogger.warn("Current logger will overwrite one already registered from " + stack);
	      }
	      return registerGlobal('diag', newLogger, self, true);
	    };
	    self.setLogger = setLogger;
	    self.disable = function () {
	      unregisterGlobal(API_NAME$4, self);
	    };
	    self.createComponentLogger = function (options) {
	      return new DiagComponentLogger(options);
	    };
	    self.verbose = _logProxy('verbose');
	    self.debug = _logProxy('debug');
	    self.info = _logProxy('info');
	    self.warn = _logProxy('warn');
	    self.error = _logProxy('error');
	  }
	  /** Get the singleton instance of the DiagAPI API */
	  DiagAPI.instance = function () {
	    if (!this._instance) {
	      this._instance = new DiagAPI();
	    }
	    return this._instance;
	  };
	  return DiagAPI;
	}();

	var es_array_from = {};

	var hasRequiredEs_array_from;

	function requireEs_array_from () {
		if (hasRequiredEs_array_from) return es_array_from;
		hasRequiredEs_array_from = 1;
		var $ = /*@__PURE__*/ require_export();
		var from = /*@__PURE__*/ requireArrayFrom();
		var checkCorrectnessOfIteration = /*@__PURE__*/ requireCheckCorrectnessOfIteration();

		var INCORRECT_ITERATION = !checkCorrectnessOfIteration(function (iterable) {
		  // eslint-disable-next-line es/no-array-from -- required for testing
		  Array.from(iterable);
		});

		// `Array.from` method
		// https://tc39.es/ecma262/#sec-array.from
		$({ target: 'Array', stat: true, forced: INCORRECT_ITERATION }, {
		  from: from
		});
		return es_array_from;
	}

	var from$5;
	var hasRequiredFrom$5;

	function requireFrom$5 () {
		if (hasRequiredFrom$5) return from$5;
		hasRequiredFrom$5 = 1;
		requireEs_string_iterator();
		requireEs_array_from();
		var path = /*@__PURE__*/ requirePath$1();

		from$5 = path.Array.from;
		return from$5;
	}

	var from$4;
	var hasRequiredFrom$4;

	function requireFrom$4 () {
		if (hasRequiredFrom$4) return from$4;
		hasRequiredFrom$4 = 1;
		var parent = /*@__PURE__*/ requireFrom$5();

		from$4 = parent;
		return from$4;
	}

	var from$3;
	var hasRequiredFrom$3;
	function requireFrom$3() {
	  if (hasRequiredFrom$3) return from$3;
	  hasRequiredFrom$3 = 1;
	  from$3 = /*@__PURE__*/requireFrom$4();
	  return from$3;
	}

	var fromExports$1 = requireFrom$3();
	var _Array$from$1 = /*@__PURE__*/getDefaultExportFromCjs(fromExports$1);

	var entries$3;
	var hasRequiredEntries$3;

	function requireEntries$3 () {
		if (hasRequiredEntries$3) return entries$3;
		hasRequiredEntries$3 = 1;
		requireEs_array_iterator();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		entries$3 = getBuiltInPrototypeMethod('Array', 'entries');
		return entries$3;
	}

	var entries$2;
	var hasRequiredEntries$2;

	function requireEntries$2 () {
		if (hasRequiredEntries$2) return entries$2;
		hasRequiredEntries$2 = 1;
		var parent = /*@__PURE__*/ requireEntries$3();

		entries$2 = parent;
		return entries$2;
	}

	var entries$1;
	var hasRequiredEntries$1;

	function requireEntries$1 () {
		if (hasRequiredEntries$1) return entries$1;
		hasRequiredEntries$1 = 1;
		requireWeb_domCollections_iterator();
		var classof = /*@__PURE__*/ requireClassof();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireEntries$2();

		var ArrayPrototype = Array.prototype;

		var DOMIterables = {
		  DOMTokenList: true,
		  NodeList: true
		};

		entries$1 = function (it) {
		  var own = it.entries;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.entries)
		    || hasOwn(DOMIterables, classof(it)) ? method : own;
		};
		return entries$1;
	}

	var entries;
	var hasRequiredEntries;
	function requireEntries() {
	  if (hasRequiredEntries) return entries;
	  hasRequiredEntries = 1;
	  entries = /*@__PURE__*/requireEntries$1();
	  return entries;
	}

	var entriesExports = requireEntries();
	var _entriesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(entriesExports);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __read$s = undefined && undefined.__read || function (o, n) {
	  var m = typeof _Symbol$1 === "function" && _getIteratorMethod$1(o);
	  if (!m) return o;
	  var i = m.call(o),
	    r,
	    ar = [],
	    e;
	  try {
	    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
	  } catch (error) {
	    e = {
	      error: error
	    };
	  } finally {
	    try {
	      if (r && !r.done && (m = i["return"])) m.call(i);
	    } finally {
	      if (e) throw e.error;
	    }
	  }
	  return ar;
	};
	var __values$b = undefined && undefined.__values || function (o) {
	  var s = typeof _Symbol$1 === "function" && _Symbol$iterator,
	    m = s && o[s],
	    i = 0;
	  if (m) return m.call(o);
	  if (o && typeof o.length === "number") return {
	    next: function next() {
	      if (o && i >= o.length) o = void 0;
	      return {
	        value: o && o[i++],
	        done: !o
	      };
	    }
	  };
	  throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
	};
	var BaggageImpl = /** @class */function () {
	  function BaggageImpl(entries) {
	    this._entries = entries ? new _Map$1(entries) : new _Map$1();
	  }
	  BaggageImpl.prototype.getEntry = function (key) {
	    var entry = this._entries.get(key);
	    if (!entry) {
	      return undefined;
	    }
	    return _Object$assign({}, entry);
	  };
	  BaggageImpl.prototype.getAllEntries = function () {
	    var _context, _context2;
	    return _mapInstanceProperty(_context = _Array$from$1(_entriesInstanceProperty(_context2 = this._entries).call(_context2))).call(_context, function (_a) {
	      var _b = __read$s(_a, 2),
	        k = _b[0],
	        v = _b[1];
	      return [k, v];
	    });
	  };
	  BaggageImpl.prototype.setEntry = function (key, entry) {
	    var newBaggage = new BaggageImpl(this._entries);
	    newBaggage._entries.set(key, entry);
	    return newBaggage;
	  };
	  BaggageImpl.prototype.removeEntry = function (key) {
	    var newBaggage = new BaggageImpl(this._entries);
	    newBaggage._entries.delete(key);
	    return newBaggage;
	  };
	  BaggageImpl.prototype.removeEntries = function () {
	    var e_1, _a;
	    var keys = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	      keys[_i] = arguments[_i];
	    }
	    var newBaggage = new BaggageImpl(this._entries);
	    try {
	      for (var keys_1 = __values$b(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
	        var key = keys_1_1.value;
	        newBaggage._entries.delete(key);
	      }
	    } catch (e_1_1) {
	      e_1 = {
	        error: e_1_1
	      };
	    } finally {
	      try {
	        if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return)) _a.call(keys_1);
	      } finally {
	        if (e_1) throw e_1.error;
	      }
	    }
	    return newBaggage;
	  };
	  BaggageImpl.prototype.clear = function () {
	    return new BaggageImpl();
	  };
	  return BaggageImpl;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * Symbol used to make BaggageEntryMetadata an opaque type
	 */
	var baggageEntryMetadataSymbol = _Symbol$1('BaggageEntryMetadata');

	var diag$1 = DiagAPI.instance();
	/**
	 * Create a new Baggage with optional entries
	 *
	 * @param entries An array of baggage entries the new baggage should contain
	 */
	function createBaggage(entries) {
	  if (entries === void 0) {
	    entries = {};
	  }
	  return new BaggageImpl(new _Map$1(_Object$entries(entries)));
	}
	/**
	 * Create a serializable BaggageEntryMetadata object from a string.
	 *
	 * @param str string metadata. Format is currently not defined by the spec and has no special meaning.
	 *
	 */
	function baggageEntryMetadataFromString(str) {
	  if (typeof str !== 'string') {
	    diag$1.error("Cannot create baggage metadata from unknown type: " + _typeof$1(str));
	    str = '';
	  }
	  return {
	    __TYPE__: baggageEntryMetadataSymbol,
	    toString: function toString() {
	      return str;
	    }
	  };
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/** Get a key to uniquely identify a context value */
	function createContextKey(description) {
	  // The specification states that for the same input, multiple calls should
	  // return different keys. Due to the nature of the JS dependency management
	  // system, this creates problems where multiple versions of some package
	  // could hold different keys for the same property.
	  //
	  // Therefore, we use Symbol.for which returns the same key for the same input.
	  return _Symbol$for(description);
	}
	var BaseContext = /** @class */function () {
	  /**
	   * Construct a new context which inherits values from an optional parent context.
	   *
	   * @param parentContext a context from which to inherit values
	   */
	  function BaseContext(parentContext) {
	    // for minification
	    var self = this;
	    self._currentContext = parentContext ? new _Map$1(parentContext) : new _Map$1();
	    self.getValue = function (key) {
	      return self._currentContext.get(key);
	    };
	    self.setValue = function (key, value) {
	      var context = new BaseContext(self._currentContext);
	      context._currentContext.set(key, value);
	      return context;
	    };
	    self.deleteValue = function (key) {
	      var context = new BaseContext(self._currentContext);
	      context._currentContext.delete(key);
	      return context;
	    };
	  }
	  return BaseContext;
	}();
	/** The root context is used as the default parent context when there is no active context */
	var ROOT_CONTEXT = new BaseContext();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var consoleMap = [{
	  n: 'error',
	  c: 'error'
	}, {
	  n: 'warn',
	  c: 'warn'
	}, {
	  n: 'info',
	  c: 'info'
	}, {
	  n: 'debug',
	  c: 'debug'
	}, {
	  n: 'verbose',
	  c: 'trace'
	}];
	/**
	 * A simple Immutable Console based diagnostic logger which will output any messages to the Console.
	 * If you want to limit the amount of logging to a specific level or lower use the
	 * {@link createLogLevelDiagLogger}
	 */
	var DiagConsoleLogger = /** @class */function () {
	  function DiagConsoleLogger() {
	    function _consoleFunc(funcName) {
	      return function () {
	        var args = [];
	        for (var _i = 0; _i < arguments.length; _i++) {
	          args[_i] = arguments[_i];
	        }
	        if (console) {
	          // Some environments only expose the console when the F12 developer console is open
	          // eslint-disable-next-line no-console
	          var theFunc = console[funcName];
	          if (typeof theFunc !== 'function') {
	            // Not all environments support all functions
	            // eslint-disable-next-line no-console
	            theFunc = console.log;
	          }
	          // One last final check
	          if (typeof theFunc === 'function') {
	            return theFunc.apply(console, args);
	          }
	        }
	      };
	    }
	    for (var i = 0; i < consoleMap.length; i++) {
	      this[consoleMap[i].n] = _consoleFunc(consoleMap[i].c);
	    }
	  }
	  return DiagConsoleLogger;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __extends$j = undefined && undefined.__extends || function () {
	  var _extendStatics = function extendStatics(d, b) {
	    _extendStatics = _Object$setPrototypeOf$1 || {
	      __proto__: []
	    } instanceof Array && function (d, b) {
	      d.__proto__ = b;
	    } || function (d, b) {
	      for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
	    };
	    return _extendStatics(d, b);
	  };
	  return function (d, b) {
	    if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
	    _extendStatics(d, b);
	    function __() {
	      this.constructor = d;
	    }
	    d.prototype = b === null ? _Object$create$1(b) : (__.prototype = b.prototype, new __());
	  };
	}();
	/**
	 * NoopMeter is a noop implementation of the {@link Meter} interface. It reuses
	 * constant NoopMetrics for all of its methods.
	 */
	var NoopMeter = /** @class */function () {
	  function NoopMeter() {}
	  /**
	   * @see {@link Meter.createGauge}
	   */
	  NoopMeter.prototype.createGauge = function (_name, _options) {
	    return NOOP_GAUGE_METRIC;
	  };
	  /**
	   * @see {@link Meter.createHistogram}
	   */
	  NoopMeter.prototype.createHistogram = function (_name, _options) {
	    return NOOP_HISTOGRAM_METRIC;
	  };
	  /**
	   * @see {@link Meter.createCounter}
	   */
	  NoopMeter.prototype.createCounter = function (_name, _options) {
	    return NOOP_COUNTER_METRIC;
	  };
	  /**
	   * @see {@link Meter.createUpDownCounter}
	   */
	  NoopMeter.prototype.createUpDownCounter = function (_name, _options) {
	    return NOOP_UP_DOWN_COUNTER_METRIC;
	  };
	  /**
	   * @see {@link Meter.createObservableGauge}
	   */
	  NoopMeter.prototype.createObservableGauge = function (_name, _options) {
	    return NOOP_OBSERVABLE_GAUGE_METRIC;
	  };
	  /**
	   * @see {@link Meter.createObservableCounter}
	   */
	  NoopMeter.prototype.createObservableCounter = function (_name, _options) {
	    return NOOP_OBSERVABLE_COUNTER_METRIC;
	  };
	  /**
	   * @see {@link Meter.createObservableUpDownCounter}
	   */
	  NoopMeter.prototype.createObservableUpDownCounter = function (_name, _options) {
	    return NOOP_OBSERVABLE_UP_DOWN_COUNTER_METRIC;
	  };
	  /**
	   * @see {@link Meter.addBatchObservableCallback}
	   */
	  NoopMeter.prototype.addBatchObservableCallback = function (_callback, _observables) {};
	  /**
	   * @see {@link Meter.removeBatchObservableCallback}
	   */
	  NoopMeter.prototype.removeBatchObservableCallback = function (_callback) {};
	  return NoopMeter;
	}();
	var NoopMetric = /** @class */function () {
	  function NoopMetric() {}
	  return NoopMetric;
	}();
	var NoopCounterMetric = /** @class */function (_super) {
	  __extends$j(NoopCounterMetric, _super);
	  function NoopCounterMetric() {
	    return _super !== null && _super.apply(this, arguments) || this;
	  }
	  NoopCounterMetric.prototype.add = function (_value, _attributes) {};
	  return NoopCounterMetric;
	}(NoopMetric);
	var NoopUpDownCounterMetric = /** @class */function (_super) {
	  __extends$j(NoopUpDownCounterMetric, _super);
	  function NoopUpDownCounterMetric() {
	    return _super !== null && _super.apply(this, arguments) || this;
	  }
	  NoopUpDownCounterMetric.prototype.add = function (_value, _attributes) {};
	  return NoopUpDownCounterMetric;
	}(NoopMetric);
	var NoopGaugeMetric = /** @class */function (_super) {
	  __extends$j(NoopGaugeMetric, _super);
	  function NoopGaugeMetric() {
	    return _super !== null && _super.apply(this, arguments) || this;
	  }
	  NoopGaugeMetric.prototype.record = function (_value, _attributes) {};
	  return NoopGaugeMetric;
	}(NoopMetric);
	var NoopHistogramMetric = /** @class */function (_super) {
	  __extends$j(NoopHistogramMetric, _super);
	  function NoopHistogramMetric() {
	    return _super !== null && _super.apply(this, arguments) || this;
	  }
	  NoopHistogramMetric.prototype.record = function (_value, _attributes) {};
	  return NoopHistogramMetric;
	}(NoopMetric);
	var NoopObservableMetric = /** @class */function () {
	  function NoopObservableMetric() {}
	  NoopObservableMetric.prototype.addCallback = function (_callback) {};
	  NoopObservableMetric.prototype.removeCallback = function (_callback) {};
	  return NoopObservableMetric;
	}();
	var NoopObservableCounterMetric = /** @class */function (_super) {
	  __extends$j(NoopObservableCounterMetric, _super);
	  function NoopObservableCounterMetric() {
	    return _super !== null && _super.apply(this, arguments) || this;
	  }
	  return NoopObservableCounterMetric;
	}(NoopObservableMetric);
	var NoopObservableGaugeMetric = /** @class */function (_super) {
	  __extends$j(NoopObservableGaugeMetric, _super);
	  function NoopObservableGaugeMetric() {
	    return _super !== null && _super.apply(this, arguments) || this;
	  }
	  return NoopObservableGaugeMetric;
	}(NoopObservableMetric);
	var NoopObservableUpDownCounterMetric = /** @class */function (_super) {
	  __extends$j(NoopObservableUpDownCounterMetric, _super);
	  function NoopObservableUpDownCounterMetric() {
	    return _super !== null && _super.apply(this, arguments) || this;
	  }
	  return NoopObservableUpDownCounterMetric;
	}(NoopObservableMetric);
	var NOOP_METER = new NoopMeter();
	// Synchronous instruments
	var NOOP_COUNTER_METRIC = new NoopCounterMetric();
	var NOOP_GAUGE_METRIC = new NoopGaugeMetric();
	var NOOP_HISTOGRAM_METRIC = new NoopHistogramMetric();
	var NOOP_UP_DOWN_COUNTER_METRIC = new NoopUpDownCounterMetric();
	// Asynchronous instruments
	var NOOP_OBSERVABLE_COUNTER_METRIC = new NoopObservableCounterMetric();
	var NOOP_OBSERVABLE_GAUGE_METRIC = new NoopObservableGaugeMetric();
	var NOOP_OBSERVABLE_UP_DOWN_COUNTER_METRIC = new NoopObservableUpDownCounterMetric();
	/**
	 * Create a no-op Meter
	 */
	function createNoopMeter() {
	  return NOOP_METER;
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/** The Type of value. It describes how the data is reported. */
	var ValueType;
	(function (ValueType) {
	  ValueType[ValueType["INT"] = 0] = "INT";
	  ValueType[ValueType["DOUBLE"] = 1] = "DOUBLE";
	})(ValueType || (ValueType = {}));

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var defaultTextMapGetter = {
	  get: function get(carrier, key) {
	    if (carrier == null) {
	      return undefined;
	    }
	    return carrier[key];
	  },
	  keys: function keys(carrier) {
	    if (carrier == null) {
	      return [];
	    }
	    return _Object$keys(carrier);
	  }
	};
	var defaultTextMapSetter = {
	  set: function set(carrier, key, value) {
	    if (carrier == null) {
	      return;
	    }
	    carrier[key] = value;
	  }
	};

	var es_reflect_apply = {};

	var hasRequiredEs_reflect_apply;

	function requireEs_reflect_apply () {
		if (hasRequiredEs_reflect_apply) return es_reflect_apply;
		hasRequiredEs_reflect_apply = 1;
		var $ = /*@__PURE__*/ require_export();
		var functionApply = /*@__PURE__*/ requireFunctionApply();
		var aCallable = /*@__PURE__*/ requireACallable();
		var anObject = /*@__PURE__*/ requireAnObject();
		var fails = /*@__PURE__*/ requireFails();

		// MS Edge argumentsList argument is optional
		var OPTIONAL_ARGUMENTS_LIST = !fails(function () {
		  // eslint-disable-next-line es/no-reflect -- required for testing
		  Reflect.apply(function () { /* empty */ });
		});

		// `Reflect.apply` method
		// https://tc39.es/ecma262/#sec-reflect.apply
		$({ target: 'Reflect', stat: true, forced: OPTIONAL_ARGUMENTS_LIST }, {
		  apply: function apply(target, thisArgument, argumentsList) {
		    return functionApply(aCallable(target), thisArgument, anObject(argumentsList));
		  }
		});
		return es_reflect_apply;
	}

	var apply$2;
	var hasRequiredApply$2;

	function requireApply$2 () {
		if (hasRequiredApply$2) return apply$2;
		hasRequiredApply$2 = 1;
		requireEs_reflect_apply();
		var path = /*@__PURE__*/ requirePath$1();

		apply$2 = path.Reflect.apply;
		return apply$2;
	}

	var apply$1;
	var hasRequiredApply$1;

	function requireApply$1 () {
		if (hasRequiredApply$1) return apply$1;
		hasRequiredApply$1 = 1;
		var parent = /*@__PURE__*/ requireApply$2();

		apply$1 = parent;
		return apply$1;
	}

	var apply;
	var hasRequiredApply;
	function requireApply() {
	  if (hasRequiredApply) return apply;
	  hasRequiredApply = 1;
	  apply = /*@__PURE__*/requireApply$1();
	  return apply;
	}

	var applyExports = requireApply();
	var _Reflect$apply = /*@__PURE__*/getDefaultExportFromCjs(applyExports);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __read$r = undefined && undefined.__read || function (o, n) {
	  var m = typeof _Symbol$1 === "function" && _getIteratorMethod$1(o);
	  if (!m) return o;
	  var i = m.call(o),
	    r,
	    ar = [],
	    e;
	  try {
	    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
	  } catch (error) {
	    e = {
	      error: error
	    };
	  } finally {
	    try {
	      if (r && !r.done && (m = i["return"])) m.call(i);
	    } finally {
	      if (e) throw e.error;
	    }
	  }
	  return ar;
	};
	var __spreadArray$d = undefined && undefined.__spreadArray || function (to, from, pack) {
	  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
	    if (ar || !(i in from)) {
	      if (!ar) ar = _sliceInstanceProperty$1(Array.prototype).call(from, 0, i);
	      ar[i] = from[i];
	    }
	  }
	  return _concatInstanceProperty(to).call(to, ar || _sliceInstanceProperty$1(Array.prototype).call(from));
	};
	var NoopContextManager = /** @class */function () {
	  function NoopContextManager() {}
	  NoopContextManager.prototype.active = function () {
	    return ROOT_CONTEXT;
	  };
	  NoopContextManager.prototype.with = function (_context, fn, thisArg) {
	    var args = [];
	    for (var _i = 3; _i < arguments.length; _i++) {
	      args[_i - 3] = arguments[_i];
	    }
	    return fn.call.apply(fn, __spreadArray$d([thisArg], __read$r(args), false));
	  };
	  NoopContextManager.prototype.bind = function (_context, target) {
	    return target;
	  };
	  NoopContextManager.prototype.enable = function () {
	    return this;
	  };
	  NoopContextManager.prototype.disable = function () {
	    return this;
	  };
	  return NoopContextManager;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __read$q = undefined && undefined.__read || function (o, n) {
	  var m = typeof _Symbol$1 === "function" && _getIteratorMethod$1(o);
	  if (!m) return o;
	  var i = m.call(o),
	    r,
	    ar = [],
	    e;
	  try {
	    while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
	  } catch (error) {
	    e = {
	      error: error
	    };
	  } finally {
	    try {
	      if (r && !r.done && (m = i["return"])) m.call(i);
	    } finally {
	      if (e) throw e.error;
	    }
	  }
	  return ar;
	};
	var __spreadArray$c = undefined && undefined.__spreadArray || function (to, from, pack) {
	  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
	    if (ar || !(i in from)) {
	      if (!ar) ar = _sliceInstanceProperty$1(Array.prototype).call(from, 0, i);
	      ar[i] = from[i];
	    }
	  }
	  return _concatInstanceProperty(to).call(to, ar || _sliceInstanceProperty$1(Array.prototype).call(from));
	};
	var API_NAME$3 = 'context';
	var NOOP_CONTEXT_MANAGER = new NoopContextManager();
	/**
	 * Singleton object which represents the entry point to the OpenTelemetry Context API
	 */
	var ContextAPI = /** @class */function () {
	  /** Empty private constructor prevents end users from constructing a new instance of the API */
	  function ContextAPI() {}
	  /** Get the singleton instance of the Context API */
	  ContextAPI.getInstance = function () {
	    if (!this._instance) {
	      this._instance = new ContextAPI();
	    }
	    return this._instance;
	  };
	  /**
	   * Set the current context manager.
	   *
	   * @returns true if the context manager was successfully registered, else false
	   */
	  ContextAPI.prototype.setGlobalContextManager = function (contextManager) {
	    return registerGlobal(API_NAME$3, contextManager, DiagAPI.instance());
	  };
	  /**
	   * Get the currently active context
	   */
	  ContextAPI.prototype.active = function () {
	    return this._getContextManager().active();
	  };
	  /**
	   * Execute a function with an active context
	   *
	   * @param context context to be active during function execution
	   * @param fn function to execute in a context
	   * @param thisArg optional receiver to be used for calling fn
	   * @param args optional arguments forwarded to fn
	   */
	  ContextAPI.prototype.with = function (context, fn, thisArg) {
	    var _a;
	    var args = [];
	    for (var _i = 3; _i < arguments.length; _i++) {
	      args[_i - 3] = arguments[_i];
	    }
	    return (_a = this._getContextManager()).with.apply(_a, __spreadArray$c([context, fn, thisArg], __read$q(args), false));
	  };
	  /**
	   * Bind a context to a target function or event emitter
	   *
	   * @param context context to bind to the event emitter or function. Defaults to the currently active context
	   * @param target function or event emitter to bind
	   */
	  ContextAPI.prototype.bind = function (context, target) {
	    var _context;
	    return _bindInstanceProperty(_context = this._getContextManager()).call(_context, context, target);
	  };
	  ContextAPI.prototype._getContextManager = function () {
	    return getGlobal(API_NAME$3) || NOOP_CONTEXT_MANAGER;
	  };
	  /** Disable and remove the global context manager */
	  ContextAPI.prototype.disable = function () {
	    this._getContextManager().disable();
	    unregisterGlobal(API_NAME$3, DiagAPI.instance());
	  };
	  return ContextAPI;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var TraceFlags;
	(function (TraceFlags) {
	  /** Represents no flag set. */
	  TraceFlags[TraceFlags["NONE"] = 0] = "NONE";
	  /** Bit to represent whether trace is sampled in trace flags. */
	  TraceFlags[TraceFlags["SAMPLED"] = 1] = "SAMPLED";
	})(TraceFlags || (TraceFlags = {}));

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var INVALID_SPANID = '0000000000000000';
	var INVALID_TRACEID = '00000000000000000000000000000000';
	var INVALID_SPAN_CONTEXT = {
	  traceId: INVALID_TRACEID,
	  spanId: INVALID_SPANID,
	  traceFlags: TraceFlags.NONE
	};

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * The NonRecordingSpan is the default {@link Span} that is used when no Span
	 * implementation is available. All operations are no-op including context
	 * propagation.
	 */
	var NonRecordingSpan = /** @class */function () {
	  function NonRecordingSpan(_spanContext) {
	    if (_spanContext === void 0) {
	      _spanContext = INVALID_SPAN_CONTEXT;
	    }
	    this._spanContext = _spanContext;
	  }
	  // Returns a SpanContext.
	  NonRecordingSpan.prototype.spanContext = function () {
	    return this._spanContext;
	  };
	  // By default does nothing
	  NonRecordingSpan.prototype.setAttribute = function (_key, _value) {
	    return this;
	  };
	  // By default does nothing
	  NonRecordingSpan.prototype.setAttributes = function (_attributes) {
	    return this;
	  };
	  // By default does nothing
	  NonRecordingSpan.prototype.addEvent = function (_name, _attributes) {
	    return this;
	  };
	  NonRecordingSpan.prototype.addLink = function (_link) {
	    return this;
	  };
	  NonRecordingSpan.prototype.addLinks = function (_links) {
	    return this;
	  };
	  // By default does nothing
	  NonRecordingSpan.prototype.setStatus = function (_status) {
	    return this;
	  };
	  // By default does nothing
	  NonRecordingSpan.prototype.updateName = function (_name) {
	    return this;
	  };
	  // By default does nothing
	  NonRecordingSpan.prototype.end = function (_endTime) {};
	  // isRecording always returns false for NonRecordingSpan.
	  NonRecordingSpan.prototype.isRecording = function () {
	    return false;
	  };
	  // By default does nothing
	  NonRecordingSpan.prototype.recordException = function (_exception, _time) {};
	  return NonRecordingSpan;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * span key
	 */
	var SPAN_KEY = createContextKey('OpenTelemetry Context Key SPAN');
	/**
	 * Return the span if one exists
	 *
	 * @param context context to get span from
	 */
	function getSpan(context) {
	  return context.getValue(SPAN_KEY) || undefined;
	}
	/**
	 * Gets the span from the current context, if one exists.
	 */
	function getActiveSpan() {
	  return getSpan(ContextAPI.getInstance().active());
	}
	/**
	 * Set the span on a context
	 *
	 * @param context context to use as parent
	 * @param span span to set active
	 */
	function setSpan(context, span) {
	  return context.setValue(SPAN_KEY, span);
	}
	/**
	 * Remove current span stored in the context
	 *
	 * @param context context to delete span from
	 */
	function deleteSpan(context) {
	  return context.deleteValue(SPAN_KEY);
	}
	/**
	 * Wrap span context in a NoopSpan and set as span in a new
	 * context
	 *
	 * @param context context to set active span on
	 * @param spanContext span context to be wrapped
	 */
	function setSpanContext(context, spanContext) {
	  return setSpan(context, new NonRecordingSpan(spanContext));
	}
	/**
	 * Get the span context of the span if it exists.
	 *
	 * @param context context to get values from
	 */
	function getSpanContext(context) {
	  var _a;
	  return (_a = getSpan(context)) === null || _a === void 0 ? void 0 : _a.spanContext();
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var VALID_TRACEID_REGEX = /^([0-9a-f]{32})$/i;
	var VALID_SPANID_REGEX = /^[0-9a-f]{16}$/i;
	function isValidTraceId(traceId) {
	  return VALID_TRACEID_REGEX.test(traceId) && traceId !== INVALID_TRACEID;
	}
	function isValidSpanId(spanId) {
	  return VALID_SPANID_REGEX.test(spanId) && spanId !== INVALID_SPANID;
	}
	/**
	 * Returns true if this {@link SpanContext} is valid.
	 * @return true if this {@link SpanContext} is valid.
	 */
	function isSpanContextValid(spanContext) {
	  return isValidTraceId(spanContext.traceId) && isValidSpanId(spanContext.spanId);
	}
	/**
	 * Wrap the given {@link SpanContext} in a new non-recording {@link Span}
	 *
	 * @param spanContext span context to be wrapped
	 * @returns a new non-recording {@link Span} with the provided context
	 */
	function wrapSpanContext(spanContext) {
	  return new NonRecordingSpan(spanContext);
	}

	var contextApi = ContextAPI.getInstance();
	/**
	 * No-op implementations of {@link Tracer}.
	 */
	var NoopTracer = /** @class */function () {
	  function NoopTracer() {}
	  // startSpan starts a noop span.
	  NoopTracer.prototype.startSpan = function (name, options, context) {
	    if (context === void 0) {
	      context = contextApi.active();
	    }
	    var root = Boolean(options === null || options === void 0 ? void 0 : options.root);
	    if (root) {
	      return new NonRecordingSpan();
	    }
	    var parentFromContext = context && getSpanContext(context);
	    if (isSpanContext(parentFromContext) && isSpanContextValid(parentFromContext)) {
	      return new NonRecordingSpan(parentFromContext);
	    } else {
	      return new NonRecordingSpan();
	    }
	  };
	  NoopTracer.prototype.startActiveSpan = function (name, arg2, arg3, arg4) {
	    var opts;
	    var ctx;
	    var fn;
	    if (arguments.length < 2) {
	      return;
	    } else if (arguments.length === 2) {
	      fn = arg2;
	    } else if (arguments.length === 3) {
	      opts = arg2;
	      fn = arg3;
	    } else {
	      opts = arg2;
	      ctx = arg3;
	      fn = arg4;
	    }
	    var parentContext = ctx !== null && ctx !== void 0 ? ctx : contextApi.active();
	    var span = this.startSpan(name, opts, parentContext);
	    var contextWithSpanSet = setSpan(parentContext, span);
	    return contextApi.with(contextWithSpanSet, fn, undefined, span);
	  };
	  return NoopTracer;
	}();
	function isSpanContext(spanContext) {
	  return _typeof$1(spanContext) === 'object' && typeof spanContext['spanId'] === 'string' && typeof spanContext['traceId'] === 'string' && typeof spanContext['traceFlags'] === 'number';
	}

	var NOOP_TRACER = new NoopTracer();
	/**
	 * Proxy tracer provided by the proxy tracer provider
	 */
	var ProxyTracer = /** @class */function () {
	  function ProxyTracer(_provider, name, version, options) {
	    this._provider = _provider;
	    this.name = name;
	    this.version = version;
	    this.options = options;
	  }
	  ProxyTracer.prototype.startSpan = function (name, options, context) {
	    return this._getTracer().startSpan(name, options, context);
	  };
	  ProxyTracer.prototype.startActiveSpan = function (_name, _options, _context, _fn) {
	    var tracer = this._getTracer();
	    return _Reflect$apply(tracer.startActiveSpan, tracer, arguments);
	  };
	  /**
	   * Try to get a tracer from the proxy tracer provider.
	   * If the proxy tracer provider has no delegate, return a noop tracer.
	   */
	  ProxyTracer.prototype._getTracer = function () {
	    if (this._delegate) {
	      return this._delegate;
	    }
	    var tracer = this._provider.getDelegateTracer(this.name, this.version, this.options);
	    if (!tracer) {
	      return NOOP_TRACER;
	    }
	    this._delegate = tracer;
	    return this._delegate;
	  };
	  return ProxyTracer;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * An implementation of the {@link TracerProvider} which returns an impotent
	 * Tracer for all calls to `getTracer`.
	 *
	 * All operations are no-op.
	 */
	var NoopTracerProvider = /** @class */function () {
	  function NoopTracerProvider() {}
	  NoopTracerProvider.prototype.getTracer = function (_name, _version, _options) {
	    return new NoopTracer();
	  };
	  return NoopTracerProvider;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var NOOP_TRACER_PROVIDER = new NoopTracerProvider();
	/**
	 * Tracer provider which provides {@link ProxyTracer}s.
	 *
	 * Before a delegate is set, tracers provided are NoOp.
	 *   When a delegate is set, traces are provided from the delegate.
	 *   When a delegate is set after tracers have already been provided,
	 *   all tracers already provided will use the provided delegate implementation.
	 */
	var ProxyTracerProvider = /** @class */function () {
	  function ProxyTracerProvider() {}
	  /**
	   * Get a {@link ProxyTracer}
	   */
	  ProxyTracerProvider.prototype.getTracer = function (name, version, options) {
	    var _a;
	    return (_a = this.getDelegateTracer(name, version, options)) !== null && _a !== void 0 ? _a : new ProxyTracer(this, name, version, options);
	  };
	  ProxyTracerProvider.prototype.getDelegate = function () {
	    var _a;
	    return (_a = this._delegate) !== null && _a !== void 0 ? _a : NOOP_TRACER_PROVIDER;
	  };
	  /**
	   * Set the delegate tracer provider
	   */
	  ProxyTracerProvider.prototype.setDelegate = function (delegate) {
	    this._delegate = delegate;
	  };
	  ProxyTracerProvider.prototype.getDelegateTracer = function (name, version, options) {
	    var _a;
	    return (_a = this._delegate) === null || _a === void 0 ? void 0 : _a.getTracer(name, version, options);
	  };
	  return ProxyTracerProvider;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * @deprecated use the one declared in @opentelemetry/sdk-trace-base instead.
	 * A sampling decision that determines how a {@link Span} will be recorded
	 * and collected.
	 */
	var SamplingDecision$1;
	(function (SamplingDecision) {
	  /**
	   * `Span.isRecording() === false`, span will not be recorded and all events
	   * and attributes will be dropped.
	   */
	  SamplingDecision[SamplingDecision["NOT_RECORD"] = 0] = "NOT_RECORD";
	  /**
	   * `Span.isRecording() === true`, but `Sampled` flag in {@link TraceFlags}
	   * MUST NOT be set.
	   */
	  SamplingDecision[SamplingDecision["RECORD"] = 1] = "RECORD";
	  /**
	   * `Span.isRecording() === true` AND `Sampled` flag in {@link TraceFlags}
	   * MUST be set.
	   */
	  SamplingDecision[SamplingDecision["RECORD_AND_SAMPLED"] = 2] = "RECORD_AND_SAMPLED";
	})(SamplingDecision$1 || (SamplingDecision$1 = {}));

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var SpanKind;
	(function (SpanKind) {
	  /** Default value. Indicates that the span is used internally. */
	  SpanKind[SpanKind["INTERNAL"] = 0] = "INTERNAL";
	  /**
	   * Indicates that the span covers server-side handling of an RPC or other
	   * remote request.
	   */
	  SpanKind[SpanKind["SERVER"] = 1] = "SERVER";
	  /**
	   * Indicates that the span covers the client-side wrapper around an RPC or
	   * other remote request.
	   */
	  SpanKind[SpanKind["CLIENT"] = 2] = "CLIENT";
	  /**
	   * Indicates that the span describes producer sending a message to a
	   * broker. Unlike client and server, there is no direct critical path latency
	   * relationship between producer and consumer spans.
	   */
	  SpanKind[SpanKind["PRODUCER"] = 3] = "PRODUCER";
	  /**
	   * Indicates that the span describes consumer receiving a message from a
	   * broker. Unlike client and server, there is no direct critical path latency
	   * relationship between producer and consumer spans.
	   */
	  SpanKind[SpanKind["CONSUMER"] = 4] = "CONSUMER";
	})(SpanKind || (SpanKind = {}));

	/**
	 * An enumeration of status codes.
	 */
	var SpanStatusCode;
	(function (SpanStatusCode) {
	  /**
	   * The default status.
	   */
	  SpanStatusCode[SpanStatusCode["UNSET"] = 0] = "UNSET";
	  /**
	   * The operation has been validated by an Application developer or
	   * Operator to have completed successfully.
	   */
	  SpanStatusCode[SpanStatusCode["OK"] = 1] = "OK";
	  /**
	   * The operation contains an error.
	   */
	  SpanStatusCode[SpanStatusCode["ERROR"] = 2] = "ERROR";
	})(SpanStatusCode || (SpanStatusCode = {}));

	var es_array_reduce = {};

	var arrayReduce;
	var hasRequiredArrayReduce;

	function requireArrayReduce () {
		if (hasRequiredArrayReduce) return arrayReduce;
		hasRequiredArrayReduce = 1;
		var aCallable = /*@__PURE__*/ requireACallable();
		var toObject = /*@__PURE__*/ requireToObject();
		var IndexedObject = /*@__PURE__*/ requireIndexedObject();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();

		var $TypeError = TypeError;

		var REDUCE_EMPTY = 'Reduce of empty array with no initial value';

		// `Array.prototype.{ reduce, reduceRight }` methods implementation
		var createMethod = function (IS_RIGHT) {
		  return function (that, callbackfn, argumentsLength, memo) {
		    var O = toObject(that);
		    var self = IndexedObject(O);
		    var length = lengthOfArrayLike(O);
		    aCallable(callbackfn);
		    if (length === 0 && argumentsLength < 2) throw new $TypeError(REDUCE_EMPTY);
		    var index = IS_RIGHT ? length - 1 : 0;
		    var i = IS_RIGHT ? -1 : 1;
		    if (argumentsLength < 2) while (true) {
		      if (index in self) {
		        memo = self[index];
		        index += i;
		        break;
		      }
		      index += i;
		      if (IS_RIGHT ? index < 0 : length <= index) {
		        throw new $TypeError(REDUCE_EMPTY);
		      }
		    }
		    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
		      memo = callbackfn(memo, self[index], index, O);
		    }
		    return memo;
		  };
		};

		arrayReduce = {
		  // `Array.prototype.reduce` method
		  // https://tc39.es/ecma262/#sec-array.prototype.reduce
		  left: createMethod(false),
		  // `Array.prototype.reduceRight` method
		  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
		  right: createMethod(true)
		};
		return arrayReduce;
	}

	var hasRequiredEs_array_reduce;

	function requireEs_array_reduce () {
		if (hasRequiredEs_array_reduce) return es_array_reduce;
		hasRequiredEs_array_reduce = 1;
		var $ = /*@__PURE__*/ require_export();
		var $reduce = /*@__PURE__*/ requireArrayReduce().left;
		var arrayMethodIsStrict = /*@__PURE__*/ requireArrayMethodIsStrict();
		var CHROME_VERSION = /*@__PURE__*/ requireEnvironmentV8Version();
		var IS_NODE = /*@__PURE__*/ requireEnvironmentIsNode();

		// Chrome 80-82 has a critical bug
		// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
		var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;
		var FORCED = CHROME_BUG || !arrayMethodIsStrict('reduce');

		// `Array.prototype.reduce` method
		// https://tc39.es/ecma262/#sec-array.prototype.reduce
		$({ target: 'Array', proto: true, forced: FORCED }, {
		  reduce: function reduce(callbackfn /* , initialValue */) {
		    var length = arguments.length;
		    return $reduce(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
		  }
		});
		return es_array_reduce;
	}

	var reduce$3;
	var hasRequiredReduce$3;

	function requireReduce$3 () {
		if (hasRequiredReduce$3) return reduce$3;
		hasRequiredReduce$3 = 1;
		requireEs_array_reduce();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		reduce$3 = getBuiltInPrototypeMethod('Array', 'reduce');
		return reduce$3;
	}

	var reduce$2;
	var hasRequiredReduce$2;

	function requireReduce$2 () {
		if (hasRequiredReduce$2) return reduce$2;
		hasRequiredReduce$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireReduce$3();

		var ArrayPrototype = Array.prototype;

		reduce$2 = function (it) {
		  var own = it.reduce;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.reduce) ? method : own;
		};
		return reduce$2;
	}

	var reduce$1;
	var hasRequiredReduce$1;

	function requireReduce$1 () {
		if (hasRequiredReduce$1) return reduce$1;
		hasRequiredReduce$1 = 1;
		var parent = /*@__PURE__*/ requireReduce$2();

		reduce$1 = parent;
		return reduce$1;
	}

	var reduce;
	var hasRequiredReduce;
	function requireReduce() {
	  if (hasRequiredReduce) return reduce;
	  hasRequiredReduce = 1;
	  reduce = /*@__PURE__*/requireReduce$1();
	  return reduce;
	}

	var reduceExports = requireReduce();
	var _reduceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reduceExports);

	var es_array_reverse = {};

	var hasRequiredEs_array_reverse;

	function requireEs_array_reverse () {
		if (hasRequiredEs_array_reverse) return es_array_reverse;
		hasRequiredEs_array_reverse = 1;
		var $ = /*@__PURE__*/ require_export();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var isArray = /*@__PURE__*/ requireIsArray$7();

		var nativeReverse = uncurryThis([].reverse);
		var test = [1, 2];

		// `Array.prototype.reverse` method
		// https://tc39.es/ecma262/#sec-array.prototype.reverse
		// fix for Safari 12.0 bug
		// https://bugs.webkit.org/show_bug.cgi?id=188794
		$({ target: 'Array', proto: true, forced: String(test) === String(test.reverse()) }, {
		  reverse: function reverse() {
		    // eslint-disable-next-line no-self-assign -- dirty hack
		    if (isArray(this)) this.length = this.length;
		    return nativeReverse(this);
		  }
		});
		return es_array_reverse;
	}

	var reverse$3;
	var hasRequiredReverse$3;

	function requireReverse$3 () {
		if (hasRequiredReverse$3) return reverse$3;
		hasRequiredReverse$3 = 1;
		requireEs_array_reverse();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		reverse$3 = getBuiltInPrototypeMethod('Array', 'reverse');
		return reverse$3;
	}

	var reverse$2;
	var hasRequiredReverse$2;

	function requireReverse$2 () {
		if (hasRequiredReverse$2) return reverse$2;
		hasRequiredReverse$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireReverse$3();

		var ArrayPrototype = Array.prototype;

		reverse$2 = function (it) {
		  var own = it.reverse;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.reverse) ? method : own;
		};
		return reverse$2;
	}

	var reverse$1;
	var hasRequiredReverse$1;

	function requireReverse$1 () {
		if (hasRequiredReverse$1) return reverse$1;
		hasRequiredReverse$1 = 1;
		var parent = /*@__PURE__*/ requireReverse$2();

		reverse$1 = parent;
		return reverse$1;
	}

	var reverse;
	var hasRequiredReverse;
	function requireReverse() {
	  if (hasRequiredReverse) return reverse;
	  hasRequiredReverse = 1;
	  reverse = /*@__PURE__*/requireReverse$1();
	  return reverse;
	}

	var reverseExports = requireReverse();
	var _reverseInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reverseExports);

	var keys$3;
	var hasRequiredKeys$3;

	function requireKeys$3 () {
		if (hasRequiredKeys$3) return keys$3;
		hasRequiredKeys$3 = 1;
		requireEs_array_iterator();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		keys$3 = getBuiltInPrototypeMethod('Array', 'keys');
		return keys$3;
	}

	var keys$2;
	var hasRequiredKeys$2;

	function requireKeys$2 () {
		if (hasRequiredKeys$2) return keys$2;
		hasRequiredKeys$2 = 1;
		var parent = /*@__PURE__*/ requireKeys$3();

		keys$2 = parent;
		return keys$2;
	}

	var keys$1;
	var hasRequiredKeys$1;

	function requireKeys$1 () {
		if (hasRequiredKeys$1) return keys$1;
		hasRequiredKeys$1 = 1;
		requireWeb_domCollections_iterator();
		var classof = /*@__PURE__*/ requireClassof();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireKeys$2();

		var ArrayPrototype = Array.prototype;

		var DOMIterables = {
		  DOMTokenList: true,
		  NodeList: true
		};

		keys$1 = function (it) {
		  var own = it.keys;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.keys)
		    || hasOwn(DOMIterables, classof(it)) ? method : own;
		};
		return keys$1;
	}

	var keys;
	var hasRequiredKeys;
	function requireKeys() {
	  if (hasRequiredKeys) return keys;
	  hasRequiredKeys = 1;
	  keys = /*@__PURE__*/requireKeys$1();
	  return keys;
	}

	var keysExports = requireKeys();
	var _keysInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(keysExports);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var VALID_KEY_CHAR_RANGE$1 = '[_0-9a-z-*/]';
	var VALID_KEY$1 = "[a-z]" + VALID_KEY_CHAR_RANGE$1 + "{0,255}";
	var VALID_VENDOR_KEY$1 = "[a-z0-9]" + VALID_KEY_CHAR_RANGE$1 + "{0,240}@[a-z]" + VALID_KEY_CHAR_RANGE$1 + "{0,13}";
	var VALID_KEY_REGEX$1 = new RegExp("^(?:" + VALID_KEY$1 + "|" + VALID_VENDOR_KEY$1 + ")$");
	var VALID_VALUE_BASE_REGEX$1 = /^[ -~]{0,255}[!-~]$/;
	var INVALID_VALUE_COMMA_EQUAL_REGEX$1 = /,|=/;
	/**
	 * Key is opaque string up to 256 characters printable. It MUST begin with a
	 * lowercase letter, and can only contain lowercase letters a-z, digits 0-9,
	 * underscores _, dashes -, asterisks *, and forward slashes /.
	 * For multi-tenant vendor scenarios, an at sign (@) can be used to prefix the
	 * vendor name. Vendors SHOULD set the tenant ID at the beginning of the key.
	 * see https://www.w3.org/TR/trace-context/#key
	 */
	function validateKey$1(key) {
	  return VALID_KEY_REGEX$1.test(key);
	}
	/**
	 * Value is opaque string up to 256 characters printable ASCII RFC0020
	 * characters (i.e., the range 0x20 to 0x7E) except comma , and =.
	 */
	function validateValue$1(value) {
	  return VALID_VALUE_BASE_REGEX$1.test(value) && !INVALID_VALUE_COMMA_EQUAL_REGEX$1.test(value);
	}

	var MAX_TRACE_STATE_ITEMS$1 = 32;
	var MAX_TRACE_STATE_LEN$1 = 512;
	var LIST_MEMBERS_SEPARATOR$1 = ',';
	var LIST_MEMBER_KEY_VALUE_SPLITTER$1 = '=';
	/**
	 * TraceState must be a class and not a simple object type because of the spec
	 * requirement (https://www.w3.org/TR/trace-context/#tracestate-field).
	 *
	 * Here is the list of allowed mutations:
	 * - New key-value pair should be added into the beginning of the list
	 * - The value of any key can be updated. Modified keys MUST be moved to the
	 * beginning of the list.
	 */
	var TraceStateImpl = /** @class */function () {
	  function TraceStateImpl(rawTraceState) {
	    this._internalState = new _Map$1();
	    if (rawTraceState) this._parse(rawTraceState);
	  }
	  TraceStateImpl.prototype.set = function (key, value) {
	    // TODO: Benchmark the different approaches(map vs list) and
	    // use the faster one.
	    var traceState = this._clone();
	    if (traceState._internalState.has(key)) {
	      traceState._internalState.delete(key);
	    }
	    traceState._internalState.set(key, value);
	    return traceState;
	  };
	  TraceStateImpl.prototype.unset = function (key) {
	    var traceState = this._clone();
	    traceState._internalState.delete(key);
	    return traceState;
	  };
	  TraceStateImpl.prototype.get = function (key) {
	    return this._internalState.get(key);
	  };
	  TraceStateImpl.prototype.serialize = function () {
	    var _context;
	    var _this = this;
	    return _reduceInstanceProperty(_context = this._keys()).call(_context, function (agg, key) {
	      agg.push(key + LIST_MEMBER_KEY_VALUE_SPLITTER$1 + _this.get(key));
	      return agg;
	    }, []).join(LIST_MEMBERS_SEPARATOR$1);
	  };
	  TraceStateImpl.prototype._parse = function (rawTraceState) {
	    var _context2, _context3;
	    if (rawTraceState.length > MAX_TRACE_STATE_LEN$1) return;
	    this._internalState = _reduceInstanceProperty(_context2 = _reverseInstanceProperty(_context3 = rawTraceState.split(LIST_MEMBERS_SEPARATOR$1)).call(_context3) // Store in reverse so new keys (.set(...)) will be placed at the beginning
	    ).call(_context2, function (agg, part) {
	      var listMember = _trimInstanceProperty(part).call(part); // Optional Whitespace (OWS) handling
	      var i = _indexOfInstanceProperty$1(listMember).call(listMember, LIST_MEMBER_KEY_VALUE_SPLITTER$1);
	      if (i !== -1) {
	        var key = _sliceInstanceProperty$1(listMember).call(listMember, 0, i);
	        var value = _sliceInstanceProperty$1(listMember).call(listMember, i + 1, part.length);
	        if (validateKey$1(key) && validateValue$1(value)) {
	          agg.set(key, value);
	        }
	      }
	      return agg;
	    }, new _Map$1());
	    // Because of the reverse() requirement, trunc must be done after map is created
	    if (this._internalState.size > MAX_TRACE_STATE_ITEMS$1) {
	      var _context4, _context5, _context6;
	      this._internalState = new _Map$1(_sliceInstanceProperty$1(_context4 = _reverseInstanceProperty(_context5 = _Array$from$1(_entriesInstanceProperty(_context6 = this._internalState).call(_context6))).call(_context5) // Use reverse same as original tracestate parse chain
	      ).call(_context4, 0, MAX_TRACE_STATE_ITEMS$1));
	    }
	  };
	  TraceStateImpl.prototype._keys = function () {
	    var _context7, _context8;
	    return _reverseInstanceProperty(_context7 = _Array$from$1(_keysInstanceProperty(_context8 = this._internalState).call(_context8))).call(_context7);
	  };
	  TraceStateImpl.prototype._clone = function () {
	    var traceState = new TraceStateImpl();
	    traceState._internalState = new _Map$1(this._internalState);
	    return traceState;
	  };
	  return TraceStateImpl;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	function createTraceState(rawTraceState) {
	  return new TraceStateImpl(rawTraceState);
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// Split module-level variable definition into separate files to allow
	// tree-shaking on each api instance.
	/** Entrypoint for context API */
	var context = ContextAPI.getInstance();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// Split module-level variable definition into separate files to allow
	// tree-shaking on each api instance.
	/**
	 * Entrypoint for Diag API.
	 * Defines Diagnostic handler used for internal diagnostic logging operations.
	 * The default provides a Noop DiagLogger implementation which may be changed via the
	 * diag.setLogger(logger: DiagLogger) function.
	 */
	var diag = DiagAPI.instance();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * An implementation of the {@link MeterProvider} which returns an impotent Meter
	 * for all calls to `getMeter`
	 */
	var NoopMeterProvider = /** @class */function () {
	  function NoopMeterProvider() {}
	  NoopMeterProvider.prototype.getMeter = function (_name, _version, _options) {
	    return NOOP_METER;
	  };
	  return NoopMeterProvider;
	}();
	var NOOP_METER_PROVIDER = new NoopMeterProvider();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var API_NAME$2 = 'metrics';
	/**
	 * Singleton object which represents the entry point to the OpenTelemetry Metrics API
	 */
	var MetricsAPI = /** @class */function () {
	  /** Empty private constructor prevents end users from constructing a new instance of the API */
	  function MetricsAPI() {}
	  /** Get the singleton instance of the Metrics API */
	  MetricsAPI.getInstance = function () {
	    if (!this._instance) {
	      this._instance = new MetricsAPI();
	    }
	    return this._instance;
	  };
	  /**
	   * Set the current global meter provider.
	   * Returns true if the meter provider was successfully registered, else false.
	   */
	  MetricsAPI.prototype.setGlobalMeterProvider = function (provider) {
	    return registerGlobal(API_NAME$2, provider, DiagAPI.instance());
	  };
	  /**
	   * Returns the global meter provider.
	   */
	  MetricsAPI.prototype.getMeterProvider = function () {
	    return getGlobal(API_NAME$2) || NOOP_METER_PROVIDER;
	  };
	  /**
	   * Returns a meter from the global meter provider.
	   */
	  MetricsAPI.prototype.getMeter = function (name, version, options) {
	    return this.getMeterProvider().getMeter(name, version, options);
	  };
	  /** Remove the global meter provider */
	  MetricsAPI.prototype.disable = function () {
	    unregisterGlobal(API_NAME$2, DiagAPI.instance());
	  };
	  return MetricsAPI;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// Split module-level variable definition into separate files to allow
	// tree-shaking on each api instance.
	/** Entrypoint for metrics API */
	var metrics = MetricsAPI.getInstance();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * No-op implementations of {@link TextMapPropagator}.
	 */
	var NoopTextMapPropagator = /** @class */function () {
	  function NoopTextMapPropagator() {}
	  /** Noop inject function does nothing */
	  NoopTextMapPropagator.prototype.inject = function (_context, _carrier) {};
	  /** Noop extract function does nothing and returns the input context */
	  NoopTextMapPropagator.prototype.extract = function (context, _carrier) {
	    return context;
	  };
	  NoopTextMapPropagator.prototype.fields = function () {
	    return [];
	  };
	  return NoopTextMapPropagator;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * Baggage key
	 */
	var BAGGAGE_KEY = createContextKey('OpenTelemetry Baggage Key');
	/**
	 * Retrieve the current baggage from the given context
	 *
	 * @param {Context} Context that manage all context values
	 * @returns {Baggage} Extracted baggage from the context
	 */
	function getBaggage(context) {
	  return context.getValue(BAGGAGE_KEY) || undefined;
	}
	/**
	 * Retrieve the current baggage from the active/current context
	 *
	 * @returns {Baggage} Extracted baggage from the context
	 */
	function getActiveBaggage() {
	  return getBaggage(ContextAPI.getInstance().active());
	}
	/**
	 * Store a baggage in the given context
	 *
	 * @param {Context} Context that manage all context values
	 * @param {Baggage} baggage that will be set in the actual context
	 */
	function setBaggage(context, baggage) {
	  return context.setValue(BAGGAGE_KEY, baggage);
	}
	/**
	 * Delete the baggage stored in the given context
	 *
	 * @param {Context} Context that manage all context values
	 */
	function deleteBaggage(context) {
	  return context.deleteValue(BAGGAGE_KEY);
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var API_NAME$1 = 'propagation';
	var NOOP_TEXT_MAP_PROPAGATOR = new NoopTextMapPropagator();
	/**
	 * Singleton object which represents the entry point to the OpenTelemetry Propagation API
	 */
	var PropagationAPI = /** @class */function () {
	  /** Empty private constructor prevents end users from constructing a new instance of the API */
	  function PropagationAPI() {
	    this.createBaggage = createBaggage;
	    this.getBaggage = getBaggage;
	    this.getActiveBaggage = getActiveBaggage;
	    this.setBaggage = setBaggage;
	    this.deleteBaggage = deleteBaggage;
	  }
	  /** Get the singleton instance of the Propagator API */
	  PropagationAPI.getInstance = function () {
	    if (!this._instance) {
	      this._instance = new PropagationAPI();
	    }
	    return this._instance;
	  };
	  /**
	   * Set the current propagator.
	   *
	   * @returns true if the propagator was successfully registered, else false
	   */
	  PropagationAPI.prototype.setGlobalPropagator = function (propagator) {
	    return registerGlobal(API_NAME$1, propagator, DiagAPI.instance());
	  };
	  /**
	   * Inject context into a carrier to be propagated inter-process
	   *
	   * @param context Context carrying tracing data to inject
	   * @param carrier carrier to inject context into
	   * @param setter Function used to set values on the carrier
	   */
	  PropagationAPI.prototype.inject = function (context, carrier, setter) {
	    if (setter === void 0) {
	      setter = defaultTextMapSetter;
	    }
	    return this._getGlobalPropagator().inject(context, carrier, setter);
	  };
	  /**
	   * Extract context from a carrier
	   *
	   * @param context Context which the newly created context will inherit from
	   * @param carrier Carrier to extract context from
	   * @param getter Function used to extract keys from a carrier
	   */
	  PropagationAPI.prototype.extract = function (context, carrier, getter) {
	    if (getter === void 0) {
	      getter = defaultTextMapGetter;
	    }
	    return this._getGlobalPropagator().extract(context, carrier, getter);
	  };
	  /**
	   * Return a list of all fields which may be used by the propagator.
	   */
	  PropagationAPI.prototype.fields = function () {
	    return this._getGlobalPropagator().fields();
	  };
	  /** Remove the global propagator */
	  PropagationAPI.prototype.disable = function () {
	    unregisterGlobal(API_NAME$1, DiagAPI.instance());
	  };
	  PropagationAPI.prototype._getGlobalPropagator = function () {
	    return getGlobal(API_NAME$1) || NOOP_TEXT_MAP_PROPAGATOR;
	  };
	  return PropagationAPI;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// Split module-level variable definition into separate files to allow
	// tree-shaking on each api instance.
	/** Entrypoint for propagation API */
	var propagation = PropagationAPI.getInstance();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var API_NAME = 'trace';
	/**
	 * Singleton object which represents the entry point to the OpenTelemetry Tracing API
	 */
	var TraceAPI = /** @class */function () {
	  /** Empty private constructor prevents end users from constructing a new instance of the API */
	  function TraceAPI() {
	    this._proxyTracerProvider = new ProxyTracerProvider();
	    this.wrapSpanContext = wrapSpanContext;
	    this.isSpanContextValid = isSpanContextValid;
	    this.deleteSpan = deleteSpan;
	    this.getSpan = getSpan;
	    this.getActiveSpan = getActiveSpan;
	    this.getSpanContext = getSpanContext;
	    this.setSpan = setSpan;
	    this.setSpanContext = setSpanContext;
	  }
	  /** Get the singleton instance of the Trace API */
	  TraceAPI.getInstance = function () {
	    if (!this._instance) {
	      this._instance = new TraceAPI();
	    }
	    return this._instance;
	  };
	  /**
	   * Set the current global tracer.
	   *
	   * @returns true if the tracer provider was successfully registered, else false
	   */
	  TraceAPI.prototype.setGlobalTracerProvider = function (provider) {
	    var success = registerGlobal(API_NAME, this._proxyTracerProvider, DiagAPI.instance());
	    if (success) {
	      this._proxyTracerProvider.setDelegate(provider);
	    }
	    return success;
	  };
	  /**
	   * Returns the global tracer provider.
	   */
	  TraceAPI.prototype.getTracerProvider = function () {
	    return getGlobal(API_NAME) || this._proxyTracerProvider;
	  };
	  /**
	   * Returns a tracer from the global tracer provider.
	   */
	  TraceAPI.prototype.getTracer = function (name, version) {
	    return this.getTracerProvider().getTracer(name, version);
	  };
	  /** Remove the global tracer provider */
	  TraceAPI.prototype.disable = function () {
	    unregisterGlobal(API_NAME, DiagAPI.instance());
	    this._proxyTracerProvider = new ProxyTracerProvider();
	  };
	  return TraceAPI;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// Split module-level variable definition into separate files to allow
	// tree-shaking on each api instance.
	/** Entrypoint for trace API */
	var trace$1 = TraceAPI.getInstance();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// Default export.
	var opentelemetry = {
	  context: context,
	  diag: diag,
	  metrics: metrics,
	  propagation: propagation,
	  trace: trace$1
	};

	var esm$f = /*#__PURE__*/Object.freeze({
		__proto__: null,
		DiagConsoleLogger: DiagConsoleLogger,
		get DiagLogLevel () { return DiagLogLevel; },
		INVALID_SPANID: INVALID_SPANID,
		INVALID_SPAN_CONTEXT: INVALID_SPAN_CONTEXT,
		INVALID_TRACEID: INVALID_TRACEID,
		ProxyTracer: ProxyTracer,
		ProxyTracerProvider: ProxyTracerProvider,
		ROOT_CONTEXT: ROOT_CONTEXT,
		get SamplingDecision () { return SamplingDecision$1; },
		get SpanKind () { return SpanKind; },
		get SpanStatusCode () { return SpanStatusCode; },
		get TraceFlags () { return TraceFlags; },
		get ValueType () { return ValueType; },
		baggageEntryMetadataFromString: baggageEntryMetadataFromString,
		context: context,
		createContextKey: createContextKey,
		createNoopMeter: createNoopMeter,
		createTraceState: createTraceState,
		default: opentelemetry,
		defaultTextMapGetter: defaultTextMapGetter,
		defaultTextMapSetter: defaultTextMapSetter,
		diag: diag,
		isSpanContextValid: isSpanContextValid,
		isValidSpanId: isValidSpanId,
		isValidTraceId: isValidTraceId,
		metrics: metrics,
		propagation: propagation,
		trace: trace$1
	});

	var require$$0$8 = /*@__PURE__*/getAugmentedNamespace(esm$f);

	var es_array_flat = {};

	var flattenIntoArray_1;
	var hasRequiredFlattenIntoArray;

	function requireFlattenIntoArray () {
		if (hasRequiredFlattenIntoArray) return flattenIntoArray_1;
		hasRequiredFlattenIntoArray = 1;
		var isArray = /*@__PURE__*/ requireIsArray$7();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var doesNotExceedSafeInteger = /*@__PURE__*/ requireDoesNotExceedSafeInteger();
		var bind = /*@__PURE__*/ requireFunctionBindContext();

		// `FlattenIntoArray` abstract operation
		// https://tc39.github.io/proposal-flatMap/#sec-FlattenIntoArray
		var flattenIntoArray = function (target, original, source, sourceLen, start, depth, mapper, thisArg) {
		  var targetIndex = start;
		  var sourceIndex = 0;
		  var mapFn = mapper ? bind(mapper, thisArg) : false;
		  var element, elementLen;

		  while (sourceIndex < sourceLen) {
		    if (sourceIndex in source) {
		      element = mapFn ? mapFn(source[sourceIndex], sourceIndex, original) : source[sourceIndex];

		      if (depth > 0 && isArray(element)) {
		        elementLen = lengthOfArrayLike(element);
		        targetIndex = flattenIntoArray(target, original, element, elementLen, targetIndex, depth - 1) - 1;
		      } else {
		        doesNotExceedSafeInteger(targetIndex + 1);
		        target[targetIndex] = element;
		      }

		      targetIndex++;
		    }
		    sourceIndex++;
		  }
		  return targetIndex;
		};

		flattenIntoArray_1 = flattenIntoArray;
		return flattenIntoArray_1;
	}

	var hasRequiredEs_array_flat;

	function requireEs_array_flat () {
		if (hasRequiredEs_array_flat) return es_array_flat;
		hasRequiredEs_array_flat = 1;
		var $ = /*@__PURE__*/ require_export();
		var flattenIntoArray = /*@__PURE__*/ requireFlattenIntoArray();
		var toObject = /*@__PURE__*/ requireToObject();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var toIntegerOrInfinity = /*@__PURE__*/ requireToIntegerOrInfinity();
		var arraySpeciesCreate = /*@__PURE__*/ requireArraySpeciesCreate();

		// `Array.prototype.flat` method
		// https://tc39.es/ecma262/#sec-array.prototype.flat
		$({ target: 'Array', proto: true }, {
		  flat: function flat(/* depthArg = 1 */) {
		    var depthArg = arguments.length ? arguments[0] : undefined;
		    var O = toObject(this);
		    var sourceLen = lengthOfArrayLike(O);
		    var A = arraySpeciesCreate(O, 0);
		    A.length = flattenIntoArray(A, O, O, sourceLen, 0, depthArg === undefined ? 1 : toIntegerOrInfinity(depthArg));
		    return A;
		  }
		});
		return es_array_flat;
	}

	var es_array_unscopables_flat = {};

	var hasRequiredEs_array_unscopables_flat;

	function requireEs_array_unscopables_flat () {
		if (hasRequiredEs_array_unscopables_flat) return es_array_unscopables_flat;
		hasRequiredEs_array_unscopables_flat = 1;
		// this method was added to unscopables after implementation
		// in popular engines, so it's moved to a separate module
		var addToUnscopables = /*@__PURE__*/ requireAddToUnscopables();

		// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
		addToUnscopables('flat');
		return es_array_unscopables_flat;
	}

	var flat$3;
	var hasRequiredFlat$3;

	function requireFlat$3 () {
		if (hasRequiredFlat$3) return flat$3;
		hasRequiredFlat$3 = 1;
		requireEs_array_flat();
		requireEs_array_unscopables_flat();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		flat$3 = getBuiltInPrototypeMethod('Array', 'flat');
		return flat$3;
	}

	var flat$2;
	var hasRequiredFlat$2;

	function requireFlat$2 () {
		if (hasRequiredFlat$2) return flat$2;
		hasRequiredFlat$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireFlat$3();

		var ArrayPrototype = Array.prototype;

		flat$2 = function (it) {
		  var own = it.flat;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.flat) ? method : own;
		};
		return flat$2;
	}

	var flat$1;
	var hasRequiredFlat$1;

	function requireFlat$1 () {
		if (hasRequiredFlat$1) return flat$1;
		hasRequiredFlat$1 = 1;
		var parent = /*@__PURE__*/ requireFlat$2();

		flat$1 = parent;
		return flat$1;
	}

	var flat;
	var hasRequiredFlat;
	function requireFlat() {
	  if (hasRequiredFlat) return flat;
	  hasRequiredFlat = 1;
	  flat = /*@__PURE__*/requireFlat$1();
	  return flat;
	}

	var flatExports = requireFlat();
	var _flatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(flatExports);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var SeverityNumber$1;
	(function (SeverityNumber) {
	  SeverityNumber[SeverityNumber["UNSPECIFIED"] = 0] = "UNSPECIFIED";
	  SeverityNumber[SeverityNumber["TRACE"] = 1] = "TRACE";
	  SeverityNumber[SeverityNumber["TRACE2"] = 2] = "TRACE2";
	  SeverityNumber[SeverityNumber["TRACE3"] = 3] = "TRACE3";
	  SeverityNumber[SeverityNumber["TRACE4"] = 4] = "TRACE4";
	  SeverityNumber[SeverityNumber["DEBUG"] = 5] = "DEBUG";
	  SeverityNumber[SeverityNumber["DEBUG2"] = 6] = "DEBUG2";
	  SeverityNumber[SeverityNumber["DEBUG3"] = 7] = "DEBUG3";
	  SeverityNumber[SeverityNumber["DEBUG4"] = 8] = "DEBUG4";
	  SeverityNumber[SeverityNumber["INFO"] = 9] = "INFO";
	  SeverityNumber[SeverityNumber["INFO2"] = 10] = "INFO2";
	  SeverityNumber[SeverityNumber["INFO3"] = 11] = "INFO3";
	  SeverityNumber[SeverityNumber["INFO4"] = 12] = "INFO4";
	  SeverityNumber[SeverityNumber["WARN"] = 13] = "WARN";
	  SeverityNumber[SeverityNumber["WARN2"] = 14] = "WARN2";
	  SeverityNumber[SeverityNumber["WARN3"] = 15] = "WARN3";
	  SeverityNumber[SeverityNumber["WARN4"] = 16] = "WARN4";
	  SeverityNumber[SeverityNumber["ERROR"] = 17] = "ERROR";
	  SeverityNumber[SeverityNumber["ERROR2"] = 18] = "ERROR2";
	  SeverityNumber[SeverityNumber["ERROR3"] = 19] = "ERROR3";
	  SeverityNumber[SeverityNumber["ERROR4"] = 20] = "ERROR4";
	  SeverityNumber[SeverityNumber["FATAL"] = 21] = "FATAL";
	  SeverityNumber[SeverityNumber["FATAL2"] = 22] = "FATAL2";
	  SeverityNumber[SeverityNumber["FATAL3"] = 23] = "FATAL3";
	  SeverityNumber[SeverityNumber["FATAL4"] = 24] = "FATAL4";
	})(SeverityNumber$1 || (SeverityNumber$1 = {}));

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var NoopLogger = /** @class */function () {
	  function NoopLogger() {}
	  NoopLogger.prototype.emit = function (_logRecord) {};
	  return NoopLogger;
	}();
	var NOOP_LOGGER = new NoopLogger();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var NoopLoggerProvider = /** @class */function () {
	  function NoopLoggerProvider() {}
	  NoopLoggerProvider.prototype.getLogger = function (_name, _version, _options) {
	    return new NoopLogger();
	  };
	  return NoopLoggerProvider;
	}();
	var NOOP_LOGGER_PROVIDER = new NoopLoggerProvider();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var ProxyLogger = /** @class */function () {
	  function ProxyLogger(_provider, name, version, options) {
	    this._provider = _provider;
	    this.name = name;
	    this.version = version;
	    this.options = options;
	  }
	  /**
	   * Emit a log record. This method should only be used by log appenders.
	   *
	   * @param logRecord
	   */
	  ProxyLogger.prototype.emit = function (logRecord) {
	    this._getLogger().emit(logRecord);
	  };
	  /**
	   * Try to get a logger from the proxy logger provider.
	   * If the proxy logger provider has no delegate, return a noop logger.
	   */
	  ProxyLogger.prototype._getLogger = function () {
	    if (this._delegate) {
	      return this._delegate;
	    }
	    var logger = this._provider.getDelegateLogger(this.name, this.version, this.options);
	    if (!logger) {
	      return NOOP_LOGGER;
	    }
	    this._delegate = logger;
	    return this._delegate;
	  };
	  return ProxyLogger;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var ProxyLoggerProvider = /** @class */function () {
	  function ProxyLoggerProvider() {}
	  ProxyLoggerProvider.prototype.getLogger = function (name, version, options) {
	    var _a;
	    return (_a = this.getDelegateLogger(name, version, options)) !== null && _a !== void 0 ? _a : new ProxyLogger(this, name, version, options);
	  };
	  ProxyLoggerProvider.prototype.getDelegate = function () {
	    var _a;
	    return (_a = this._delegate) !== null && _a !== void 0 ? _a : NOOP_LOGGER_PROVIDER;
	  };
	  /**
	   * Set the delegate logger provider
	   */
	  ProxyLoggerProvider.prototype.setDelegate = function (delegate) {
	    this._delegate = delegate;
	  };
	  ProxyLoggerProvider.prototype.getDelegateLogger = function (name, version, options) {
	    var _a;
	    return (_a = this._delegate) === null || _a === void 0 ? void 0 : _a.getLogger(name, version, options);
	  };
	  return ProxyLoggerProvider;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	// Updates to this file should also be replicated to @opentelemetry/api and
	// @opentelemetry/core too.
	/**
	 * - globalThis (New standard)
	 * - self (Will return the current window instance for supported browsers)
	 * - window (fallback for older browser implementations)
	 * - global (NodeJS implementation)
	 * - <object> (When all else fails)
	 */
	/** only globals that common to node and browsers are allowed */
	// eslint-disable-next-line node/no-unsupported-features/es-builtins, no-undef
	var _globalThis$1 = (typeof _globalThis$3 === "undefined" ? "undefined" : _typeof$1(_globalThis$3)) === 'object' ? _globalThis$3 : (typeof self === "undefined" ? "undefined" : _typeof$1(self)) === 'object' ? self : (typeof window === "undefined" ? "undefined" : _typeof$1(window)) === 'object' ? window : (typeof global === "undefined" ? "undefined" : _typeof$1(global)) === 'object' ? global : {};

	var GLOBAL_LOGS_API_KEY = _Symbol$for('io.opentelemetry.js.api.logs');
	var _global = _globalThis$1;
	/**
	 * Make a function which accepts a version integer and returns the instance of an API if the version
	 * is compatible, or a fallback version (usually NOOP) if it is not.
	 *
	 * @param requiredVersion Backwards compatibility version which is required to return the instance
	 * @param instance Instance which should be returned if the required version is compatible
	 * @param fallback Fallback instance, usually NOOP, which will be returned if the required version is not compatible
	 */
	function makeGetter(requiredVersion, instance, fallback) {
	  return function (version) {
	    return version === requiredVersion ? instance : fallback;
	  };
	}
	/**
	 * A number which should be incremented each time a backwards incompatible
	 * change is made to the API. This number is used when an API package
	 * attempts to access the global API to ensure it is getting a compatible
	 * version. If the global API is not compatible with the API package
	 * attempting to get it, a NOOP API implementation will be returned.
	 */
	var API_BACKWARDS_COMPATIBILITY_VERSION = 1;

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var LogsAPI = /** @class */function () {
	  function LogsAPI() {
	    this._proxyLoggerProvider = new ProxyLoggerProvider();
	  }
	  LogsAPI.getInstance = function () {
	    if (!this._instance) {
	      this._instance = new LogsAPI();
	    }
	    return this._instance;
	  };
	  LogsAPI.prototype.setGlobalLoggerProvider = function (provider) {
	    if (_global[GLOBAL_LOGS_API_KEY]) {
	      return this.getLoggerProvider();
	    }
	    _global[GLOBAL_LOGS_API_KEY] = makeGetter(API_BACKWARDS_COMPATIBILITY_VERSION, provider, NOOP_LOGGER_PROVIDER);
	    this._proxyLoggerProvider.setDelegate(provider);
	    return provider;
	  };
	  /**
	   * Returns the global logger provider.
	   *
	   * @returns LoggerProvider
	   */
	  LogsAPI.prototype.getLoggerProvider = function () {
	    var _a, _b;
	    return (_b = (_a = _global[GLOBAL_LOGS_API_KEY]) === null || _a === void 0 ? void 0 : _a.call(_global, API_BACKWARDS_COMPATIBILITY_VERSION)) !== null && _b !== void 0 ? _b : this._proxyLoggerProvider;
	  };
	  /**
	   * Returns a logger from the global logger provider.
	   *
	   * @returns Logger
	   */
	  LogsAPI.prototype.getLogger = function (name, version, options) {
	    return this.getLoggerProvider().getLogger(name, version, options);
	  };
	  /** Remove the global logger provider */
	  LogsAPI.prototype.disable = function () {
	    delete _global[GLOBAL_LOGS_API_KEY];
	    this._proxyLoggerProvider = new ProxyLoggerProvider();
	  };
	  return LogsAPI;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var logs = LogsAPI.getInstance();

	var esm$e = /*#__PURE__*/Object.freeze({
		__proto__: null,
		NOOP_LOGGER: NOOP_LOGGER,
		NOOP_LOGGER_PROVIDER: NOOP_LOGGER_PROVIDER,
		NoopLogger: NoopLogger,
		NoopLoggerProvider: NoopLoggerProvider,
		ProxyLogger: ProxyLogger,
		ProxyLoggerProvider: ProxyLoggerProvider,
		get SeverityNumber () { return SeverityNumber$1; },
		logs: logs
	});

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * Enable instrumentations
	 * @param instrumentations
	 * @param tracerProvider
	 * @param meterProvider
	 */
	function enableInstrumentations(instrumentations, tracerProvider, meterProvider, loggerProvider) {
	  for (var i = 0, j = instrumentations.length; i < j; i++) {
	    var instrumentation = instrumentations[i];
	    if (tracerProvider) {
	      instrumentation.setTracerProvider(tracerProvider);
	    }
	    if (meterProvider) {
	      instrumentation.setMeterProvider(meterProvider);
	    }
	    if (loggerProvider && instrumentation.setLoggerProvider) {
	      instrumentation.setLoggerProvider(loggerProvider);
	    }
	    // instrumentations have been already enabled during creation
	    // so enable only if user prevented that by setting enabled to false
	    // this is to prevent double enabling but when calling register all
	    // instrumentations should be now enabled
	    if (!instrumentation.getConfig().enabled) {
	      instrumentation.enable();
	    }
	  }
	}
	/**
	 * Disable instrumentations
	 * @param instrumentations
	 */
	function disableInstrumentations(instrumentations) {
	  _forEachInstanceProperty(instrumentations).call(instrumentations, function (instrumentation) {
	    return instrumentation.disable();
	  });
	}

	/**
	 * It will register instrumentations and plugins
	 * @param options
	 * @return returns function to unload instrumentation and plugins that were
	 *   registered
	 */
	function registerInstrumentations(options) {
	  var _a, _b;
	  var tracerProvider = options.tracerProvider || trace$1.getTracerProvider();
	  var meterProvider = options.meterProvider || metrics.getMeterProvider();
	  var loggerProvider = options.loggerProvider || logs.getLoggerProvider();
	  var instrumentations = (_b = (_a = options.instrumentations) === null || _a === void 0 ? void 0 : _flatInstanceProperty(_a).call(_a)) !== null && _b !== void 0 ? _b : [];
	  enableInstrumentations(instrumentations, tracerProvider, meterProvider, loggerProvider);
	  return function () {
	    disableInstrumentations(instrumentations);
	  };
	}

	var shimmer_1;
	var hasRequiredShimmer;
	function requireShimmer() {
	  var _context;
	  if (hasRequiredShimmer) return shimmer_1;
	  hasRequiredShimmer = 1;
	  function isFunction(funktion) {
	    return typeof funktion === 'function';
	  }

	  // Default to complaining loudly when things don't go according to plan.
	  var logger = _bindInstanceProperty(_context = console.error).call(_context, console);

	  // Sets a property on an object, preserving its enumerability.
	  // This function assumes that the property is already writable.
	  function defineProperty(obj, name, value) {
	    var enumerable = !!obj[name] && obj.propertyIsEnumerable(name);
	    _Object$defineProperty$1(obj, name, {
	      configurable: true,
	      enumerable: enumerable,
	      writable: true,
	      value: value
	    });
	  }

	  // Keep initialization idempotent.
	  function shimmer(options) {
	    if (options && options.logger) {
	      if (!isFunction(options.logger)) logger("new logger isn't a function, not replacing");else logger = options.logger;
	    }
	  }
	  function wrap(nodule, name, wrapper) {
	    if (!nodule || !nodule[name]) {
	      logger('no original function ' + name + ' to wrap');
	      return;
	    }
	    if (!wrapper) {
	      logger('no wrapper function');
	      logger(new Error().stack);
	      return;
	    }
	    if (!isFunction(nodule[name]) || !isFunction(wrapper)) {
	      logger('original object and wrapper must be functions');
	      return;
	    }
	    var original = nodule[name];
	    var wrapped = wrapper(original, name);
	    defineProperty(wrapped, '__original', original);
	    defineProperty(wrapped, '__unwrap', function () {
	      if (nodule[name] === wrapped) defineProperty(nodule, name, original);
	    });
	    defineProperty(wrapped, '__wrapped', true);
	    defineProperty(nodule, name, wrapped);
	    return wrapped;
	  }
	  function massWrap(nodules, names, wrapper) {
	    if (!nodules) {
	      logger('must provide one or more modules to patch');
	      logger(new Error().stack);
	      return;
	    } else if (!_Array$isArray$1(nodules)) {
	      nodules = [nodules];
	    }
	    if (!(names && _Array$isArray$1(names))) {
	      logger('must provide one or more functions to wrap on modules');
	      return;
	    }
	    _forEachInstanceProperty(nodules).call(nodules, function (nodule) {
	      _forEachInstanceProperty(names).call(names, function (name) {
	        wrap(nodule, name, wrapper);
	      });
	    });
	  }
	  function unwrap(nodule, name) {
	    if (!nodule || !nodule[name]) {
	      logger('no function to unwrap.');
	      logger(new Error().stack);
	      return;
	    }
	    if (!nodule[name].__unwrap) {
	      logger('no original to unwrap to -- has ' + name + ' already been unwrapped?');
	    } else {
	      return nodule[name].__unwrap();
	    }
	  }
	  function massUnwrap(nodules, names) {
	    if (!nodules) {
	      logger('must provide one or more modules to patch');
	      logger(new Error().stack);
	      return;
	    } else if (!_Array$isArray$1(nodules)) {
	      nodules = [nodules];
	    }
	    if (!(names && _Array$isArray$1(names))) {
	      logger('must provide one or more functions to unwrap on modules');
	      return;
	    }
	    _forEachInstanceProperty(nodules).call(nodules, function (nodule) {
	      _forEachInstanceProperty(names).call(names, function (name) {
	        unwrap(nodule, name);
	      });
	    });
	  }
	  shimmer.wrap = wrap;
	  shimmer.massWrap = massWrap;
	  shimmer.unwrap = unwrap;
	  shimmer.massUnwrap = massUnwrap;
	  shimmer_1 = shimmer;
	  return shimmer_1;
	}

	var shimmerExports = requireShimmer();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __assign$4 = undefined && undefined.__assign || function () {
	  __assign$4 = _Object$assign || function (t) {
	    for (var s, i = 1, n = arguments.length; i < n; i++) {
	      s = arguments[i];
	      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
	    }
	    return t;
	  };
	  return __assign$4.apply(this, arguments);
	};
	/**
	 * Base abstract internal class for instrumenting node and web plugins
	 */
	var InstrumentationAbstract = /** @class */function () {
	  function InstrumentationAbstract(instrumentationName, instrumentationVersion, config) {
	    this.instrumentationName = instrumentationName;
	    this.instrumentationVersion = instrumentationVersion;
	    this._config = {};
	    /* Api to wrap instrumented method */
	    this._wrap = shimmerExports.wrap;
	    /* Api to unwrap instrumented methods */
	    this._unwrap = shimmerExports.unwrap;
	    /* Api to mass wrap instrumented method */
	    this._massWrap = shimmerExports.massWrap;
	    /* Api to mass unwrap instrumented methods */
	    this._massUnwrap = shimmerExports.massUnwrap;
	    this.setConfig(config);
	    this._diag = diag.createComponentLogger({
	      namespace: instrumentationName
	    });
	    this._tracer = trace$1.getTracer(instrumentationName, instrumentationVersion);
	    this._meter = metrics.getMeter(instrumentationName, instrumentationVersion);
	    this._logger = logs.getLogger(instrumentationName, instrumentationVersion);
	    this._updateMetricInstruments();
	  }
	  _Object$defineProperty$1(InstrumentationAbstract.prototype, "meter", {
	    /* Returns meter */
	    get: function get() {
	      return this._meter;
	    },
	    enumerable: false,
	    configurable: true
	  });
	  /**
	   * Sets MeterProvider to this plugin
	   * @param meterProvider
	   */
	  InstrumentationAbstract.prototype.setMeterProvider = function (meterProvider) {
	    this._meter = meterProvider.getMeter(this.instrumentationName, this.instrumentationVersion);
	    this._updateMetricInstruments();
	  };
	  _Object$defineProperty$1(InstrumentationAbstract.prototype, "logger", {
	    /* Returns logger */
	    get: function get() {
	      return this._logger;
	    },
	    enumerable: false,
	    configurable: true
	  });
	  /**
	   * Sets LoggerProvider to this plugin
	   * @param loggerProvider
	   */
	  InstrumentationAbstract.prototype.setLoggerProvider = function (loggerProvider) {
	    this._logger = loggerProvider.getLogger(this.instrumentationName, this.instrumentationVersion);
	  };
	  /**
	   * @experimental
	   *
	   * Get module definitions defined by {@link init}.
	   * This can be used for experimental compile-time instrumentation.
	   *
	   * @returns an array of {@link InstrumentationModuleDefinition}
	   */
	  InstrumentationAbstract.prototype.getModuleDefinitions = function () {
	    var _a;
	    var initResult = (_a = this.init()) !== null && _a !== void 0 ? _a : [];
	    if (!_Array$isArray$1(initResult)) {
	      return [initResult];
	    }
	    return initResult;
	  };
	  /**
	   * Sets the new metric instruments with the current Meter.
	   */
	  InstrumentationAbstract.prototype._updateMetricInstruments = function () {
	    return;
	  };
	  /* Returns InstrumentationConfig */
	  InstrumentationAbstract.prototype.getConfig = function () {
	    return this._config;
	  };
	  /**
	   * Sets InstrumentationConfig to this plugin
	   * @param config
	   */
	  InstrumentationAbstract.prototype.setConfig = function (config) {
	    // copy config first level properties to ensure they are immutable.
	    // nested properties are not copied, thus are mutable from the outside.
	    this._config = __assign$4({
	      enabled: true
	    }, config);
	  };
	  /**
	   * Sets TraceProvider to this plugin
	   * @param tracerProvider
	   */
	  InstrumentationAbstract.prototype.setTracerProvider = function (tracerProvider) {
	    this._tracer = tracerProvider.getTracer(this.instrumentationName, this.instrumentationVersion);
	  };
	  _Object$defineProperty$1(InstrumentationAbstract.prototype, "tracer", {
	    /* Returns tracer */
	    get: function get() {
	      return this._tracer;
	    },
	    enumerable: false,
	    configurable: true
	  });
	  /**
	   * Execute span customization hook, if configured, and log any errors.
	   * Any semantics of the trigger and info are defined by the specific instrumentation.
	   * @param hookHandler The optional hook handler which the user has configured via instrumentation config
	   * @param triggerName The name of the trigger for executing the hook for logging purposes
	   * @param span The span to which the hook should be applied
	   * @param info The info object to be passed to the hook, with useful data the hook may use
	   */
	  InstrumentationAbstract.prototype._runSpanCustomizationHook = function (hookHandler, triggerName, span, info) {
	    if (!hookHandler) {
	      return;
	    }
	    try {
	      hookHandler(span, info);
	    } catch (e) {
	      this._diag.error("Error running span customization hook due to exception in handler", {
	        triggerName: triggerName
	      }, e);
	    }
	  };
	  return InstrumentationAbstract;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __extends$i = undefined && undefined.__extends || function () {
	  var _extendStatics = function extendStatics(d, b) {
	    _extendStatics = _Object$setPrototypeOf$1 || {
	      __proto__: []
	    } instanceof Array && function (d, b) {
	      d.__proto__ = b;
	    } || function (d, b) {
	      for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p];
	    };
	    return _extendStatics(d, b);
	  };
	  return function (d, b) {
	    if (typeof b !== "function" && b !== null) throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
	    _extendStatics(d, b);
	    function __() {
	      this.constructor = d;
	    }
	    d.prototype = b === null ? _Object$create$1(b) : (__.prototype = b.prototype, new __());
	  };
	}();
	/**
	 * Base abstract class for instrumenting web plugins
	 */
	var InstrumentationBase = /** @class */function (_super) {
	  __extends$i(InstrumentationBase, _super);
	  function InstrumentationBase(instrumentationName, instrumentationVersion, config) {
	    var _this = _super.call(this, instrumentationName, instrumentationVersion, config) || this;
	    if (_this._config.enabled) {
	      _this.enable();
	    }
	    return _this;
	  }
	  return InstrumentationBase;
	}(InstrumentationAbstract);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * Placeholder normalize function to replace the node variant in browser runtimes,
	 * this should never be called and will perform a no-op and warn if it is called regardless.
	 *
	 * This is a workaround to fix https://github.com/open-telemetry/opentelemetry-js/issues/4373 until the instrumentation
	 * package can be made node-only.
	 *
	 * @param path input path
	 * @return unmodified path
	 * @internal
	 */
	function normalize$1(path) {
	  diag.warn('Path normalization is not implemented for this platform. To silence this warning, ensure no node-specific instrumentations are loaded, and node-specific types (e.g. InstrumentationNodeModuleFile), are not used in a browser context)');
	  return path;
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var InstrumentationNodeModuleDefinition = /** @class */function () {
	  function InstrumentationNodeModuleDefinition(name, supportedVersions,
	  // eslint-disable-next-line @typescript-eslint/no-explicit-any
	  patch,
	  // eslint-disable-next-line @typescript-eslint/no-explicit-any
	  unpatch, files) {
	    this.name = name;
	    this.supportedVersions = supportedVersions;
	    this.patch = patch;
	    this.unpatch = unpatch;
	    this.files = files || [];
	  }
	  return InstrumentationNodeModuleDefinition;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var InstrumentationNodeModuleFile = /** @class */function () {
	  function InstrumentationNodeModuleFile(name, supportedVersions,
	  // eslint-disable-next-line @typescript-eslint/no-explicit-any
	  patch,
	  // eslint-disable-next-line @typescript-eslint/no-explicit-any
	  unpatch) {
	    this.supportedVersions = supportedVersions;
	    this.patch = patch;
	    this.unpatch = unpatch;
	    this.name = normalize$1(name);
	  }
	  return InstrumentationNodeModuleFile;
	}();

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	var __awaiter$a = undefined && undefined.__awaiter || function (thisArg, _arguments, P, generator) {
	  function adopt(value) {
	    return value instanceof P ? value : new P(function (resolve) {
	      resolve(value);
	    });
	  }
	  return new (P || (P = _Promise$1))(function (resolve, reject) {
	    function fulfilled(value) {
	      try {
	        step(generator.next(value));
	      } catch (e) {
	        reject(e);
	      }
	    }
	    function rejected(value) {
	      try {
	        step(generator["throw"](value));
	      } catch (e) {
	        reject(e);
	      }
	    }
	    function step(result) {
	      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
	    }
	    step((generator = generator.apply(thisArg, _arguments || [])).next());
	  });
	};
	var __generator$a = undefined && undefined.__generator || function (thisArg, body) {
	  var _ = {
	      label: 0,
	      sent: function sent() {
	        if (t[0] & 1) throw t[1];
	        return t[1];
	      },
	      trys: [],
	      ops: []
	    },
	    f,
	    y,
	    t,
	    g;
	  return g = {
	    next: verb(0),
	    "throw": verb(1),
	    "return": verb(2)
	  }, typeof _Symbol$1 === "function" && (g[_Symbol$iterator] = function () {
	    return this;
	  }), g;
	  function verb(n) {
	    return function (v) {
	      return step([n, v]);
	    };
	  }
	  function step(op) {
	    if (f) throw new TypeError("Generator is already executing.");
	    while (_) try {
	      if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
	      if (y = 0, t) op = [op[0] & 2, t.value];
	      switch (op[0]) {
	        case 0:
	        case 1:
	          t = op;
	          break;
	        case 4:
	          _.label++;
	          return {
	            value: op[1],
	            done: false
	          };
	        case 5:
	          _.label++;
	          y = op[1];
	          op = [0];
	          continue;
	        case 7:
	          op = _.ops.pop();
	          _.trys.pop();
	          continue;
	        default:
	          if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
	            _ = 0;
	            continue;
	          }
	          if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
	            _.label = op[1];
	            break;
	          }
	          if (op[0] === 6 && _.label < t[1]) {
	            _.label = t[1];
	            t = op;
	            break;
	          }
	          if (t && _.label < t[2]) {
	            _.label = t[2];
	            _.ops.push(op);
	            break;
	          }
	          if (t[2]) _.ops.pop();
	          _.trys.pop();
	          continue;
	      }
	      op = body.call(thisArg, _);
	    } catch (e) {
	      op = [6, e];
	      y = 0;
	    } finally {
	      f = t = 0;
	    }
	    if (op[0] & 5) throw op[1];
	    return {
	      value: op[0] ? op[1] : void 0,
	      done: true
	    };
	  }
	};
	/**
	 * function to execute patched function and being able to catch errors
	 * @param execute - function to be executed
	 * @param onFinish - callback to run when execute finishes
	 */
	function safeExecuteInTheMiddle(execute, onFinish, preventThrowingError) {
	  var error;
	  var result;
	  try {
	    result = execute();
	  } catch (e) {
	    error = e;
	  } finally {
	    onFinish(error, result);
	    if (error && !preventThrowingError) {
	      // eslint-disable-next-line no-unsafe-finally
	      throw error;
	    }
	    // eslint-disable-next-line no-unsafe-finally
	    return result;
	  }
	}
	/**
	 * Async function to execute patched function and being able to catch errors
	 * @param execute - function to be executed
	 * @param onFinish - callback to run when execute finishes
	 */
	function safeExecuteInTheMiddleAsync(execute, onFinish, preventThrowingError) {
	  return __awaiter$a(this, void 0, void 0, function () {
	    var error, result, e_1;
	    return __generator$a(this, function (_a) {
	      switch (_a.label) {
	        case 0:
	          _a.trys.push([0, 2, 3, 4]);
	          return [4 /*yield*/, execute()];
	        case 1:
	          result = _a.sent();
	          return [3 /*break*/, 4];
	        case 2:
	          e_1 = _a.sent();
	          error = e_1;
	          return [3 /*break*/, 4];
	        case 3:
	          onFinish(error, result);
	          if (error && !preventThrowingError) {
	            // eslint-disable-next-line no-unsafe-finally
	            throw error;
	          }
	          // eslint-disable-next-line no-unsafe-finally
	          return [2 /*return*/, result];
	        case 4:
	          return [2 /*return*/];
	      }
	    });
	  });
	}
	/**
	 * Checks if certain function has been already wrapped
	 * @param func
	 */
	function isWrapped$1(func) {
	  return typeof func === 'function' && typeof func.__original === 'function' && typeof func.__unwrap === 'function' && func.__wrapped === true;
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */

	var esm$d = /*#__PURE__*/Object.freeze({
		__proto__: null,
		InstrumentationBase: InstrumentationBase,
		InstrumentationNodeModuleDefinition: InstrumentationNodeModuleDefinition,
		InstrumentationNodeModuleFile: InstrumentationNodeModuleFile,
		isWrapped: isWrapped$1,
		registerInstrumentations: registerInstrumentations,
		safeExecuteInTheMiddle: safeExecuteInTheMiddle,
		safeExecuteInTheMiddleAsync: safeExecuteInTheMiddleAsync
	});

	var require$$0$7 = /*@__PURE__*/getAugmentedNamespace(esm$d);

	var es_date_toJson = {};

	var stringRepeat;
	var hasRequiredStringRepeat;

	function requireStringRepeat () {
		if (hasRequiredStringRepeat) return stringRepeat;
		hasRequiredStringRepeat = 1;
		var toIntegerOrInfinity = /*@__PURE__*/ requireToIntegerOrInfinity();
		var toString = /*@__PURE__*/ requireToString();
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();

		var $RangeError = RangeError;

		// `String.prototype.repeat` method implementation
		// https://tc39.es/ecma262/#sec-string.prototype.repeat
		stringRepeat = function repeat(count) {
		  var str = toString(requireObjectCoercible(this));
		  var result = '';
		  var n = toIntegerOrInfinity(count);
		  if (n < 0 || n === Infinity) throw new $RangeError('Wrong number of repetitions');
		  for (;n > 0; (n >>>= 1) && (str += str)) if (n & 1) result += str;
		  return result;
		};
		return stringRepeat;
	}

	var stringPad;
	var hasRequiredStringPad;

	function requireStringPad () {
		if (hasRequiredStringPad) return stringPad;
		hasRequiredStringPad = 1;
		// https://github.com/tc39/proposal-string-pad-start-end
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var toLength = /*@__PURE__*/ requireToLength();
		var toString = /*@__PURE__*/ requireToString();
		var $repeat = /*@__PURE__*/ requireStringRepeat();
		var requireObjectCoercible = /*@__PURE__*/ requireRequireObjectCoercible();

		var repeat = uncurryThis($repeat);
		var stringSlice = uncurryThis(''.slice);
		var ceil = Math.ceil;

		// `String.prototype.{ padStart, padEnd }` methods implementation
		var createMethod = function (IS_END) {
		  return function ($this, maxLength, fillString) {
		    var S = toString(requireObjectCoercible($this));
		    var intMaxLength = toLength(maxLength);
		    var stringLength = S.length;
		    var fillStr = fillString === undefined ? ' ' : toString(fillString);
		    var fillLen, stringFiller;
		    if (intMaxLength <= stringLength || fillStr === '') return S;
		    fillLen = intMaxLength - stringLength;
		    stringFiller = repeat(fillStr, ceil(fillLen / fillStr.length));
		    if (stringFiller.length > fillLen) stringFiller = stringSlice(stringFiller, 0, fillLen);
		    return IS_END ? S + stringFiller : stringFiller + S;
		  };
		};

		stringPad = {
		  // `String.prototype.padStart` method
		  // https://tc39.es/ecma262/#sec-string.prototype.padstart
		  start: createMethod(false),
		  // `String.prototype.padEnd` method
		  // https://tc39.es/ecma262/#sec-string.prototype.padend
		  end: createMethod(true)
		};
		return stringPad;
	}

	var dateToIsoString;
	var hasRequiredDateToIsoString;

	function requireDateToIsoString () {
		if (hasRequiredDateToIsoString) return dateToIsoString;
		hasRequiredDateToIsoString = 1;
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var fails = /*@__PURE__*/ requireFails();
		var padStart = /*@__PURE__*/ requireStringPad().start;

		var $RangeError = RangeError;
		var $isFinite = isFinite;
		var abs = Math.abs;
		var DatePrototype = Date.prototype;
		var nativeDateToISOString = DatePrototype.toISOString;
		var thisTimeValue = uncurryThis(DatePrototype.getTime);
		var getUTCDate = uncurryThis(DatePrototype.getUTCDate);
		var getUTCFullYear = uncurryThis(DatePrototype.getUTCFullYear);
		var getUTCHours = uncurryThis(DatePrototype.getUTCHours);
		var getUTCMilliseconds = uncurryThis(DatePrototype.getUTCMilliseconds);
		var getUTCMinutes = uncurryThis(DatePrototype.getUTCMinutes);
		var getUTCMonth = uncurryThis(DatePrototype.getUTCMonth);
		var getUTCSeconds = uncurryThis(DatePrototype.getUTCSeconds);

		// `Date.prototype.toISOString` method implementation
		// https://tc39.es/ecma262/#sec-date.prototype.toisostring
		// PhantomJS / old WebKit fails here:
		dateToIsoString = (fails(function () {
		  return nativeDateToISOString.call(new Date(-5e13 - 1)) !== '0385-07-25T07:06:39.999Z';
		}) || !fails(function () {
		  nativeDateToISOString.call(new Date(NaN));
		})) ? function toISOString() {
		  if (!$isFinite(thisTimeValue(this))) throw new $RangeError('Invalid time value');
		  var date = this;
		  var year = getUTCFullYear(date);
		  var milliseconds = getUTCMilliseconds(date);
		  var sign = year < 0 ? '-' : year > 9999 ? '+' : '';
		  return sign + padStart(abs(year), sign ? 6 : 4, 0) +
		    '-' + padStart(getUTCMonth(date) + 1, 2, 0) +
		    '-' + padStart(getUTCDate(date), 2, 0) +
		    'T' + padStart(getUTCHours(date), 2, 0) +
		    ':' + padStart(getUTCMinutes(date), 2, 0) +
		    ':' + padStart(getUTCSeconds(date), 2, 0) +
		    '.' + padStart(milliseconds, 3, 0) +
		    'Z';
		} : nativeDateToISOString;
		return dateToIsoString;
	}

	var hasRequiredEs_date_toJson;

	function requireEs_date_toJson () {
		if (hasRequiredEs_date_toJson) return es_date_toJson;
		hasRequiredEs_date_toJson = 1;
		var $ = /*@__PURE__*/ require_export();
		var call = /*@__PURE__*/ requireFunctionCall();
		var toObject = /*@__PURE__*/ requireToObject();
		var toPrimitive = /*@__PURE__*/ requireToPrimitive$5();
		var toISOString = /*@__PURE__*/ requireDateToIsoString();
		var classof = /*@__PURE__*/ requireClassofRaw();
		var fails = /*@__PURE__*/ requireFails();

		var FORCED = fails(function () {
		  return new Date(NaN).toJSON() !== null
		    || call(Date.prototype.toJSON, { toISOString: function () { return 1; } }) !== 1;
		});

		// `Date.prototype.toJSON` method
		// https://tc39.es/ecma262/#sec-date.prototype.tojson
		$({ target: 'Date', proto: true, forced: FORCED }, {
		  // eslint-disable-next-line no-unused-vars -- required for `.length`
		  toJSON: function toJSON(key) {
		    var O = toObject(this);
		    var pv = toPrimitive(O, 'number');
		    return typeof pv == 'number' && !isFinite(pv) ? null :
		      (!('toISOString' in O) && classof(O) === 'Date') ? call(toISOString, O) : O.toISOString();
		  }
		});
		return es_date_toJson;
	}

	var stringify$4;
	var hasRequiredStringify$4;

	function requireStringify$4 () {
		if (hasRequiredStringify$4) return stringify$4;
		hasRequiredStringify$4 = 1;
		requireEs_date_toJson();
		requireEs_json_stringify();
		var path = /*@__PURE__*/ requirePath$1();
		var apply = /*@__PURE__*/ requireFunctionApply();

		// eslint-disable-next-line es/no-json -- safe
		if (!path.JSON) path.JSON = { stringify: JSON.stringify };

		// eslint-disable-next-line no-unused-vars -- required for `.length`
		stringify$4 = function stringify(it, replacer, space) {
		  return apply(path.JSON.stringify, null, arguments);
		};
		return stringify$4;
	}

	var stringify$3;
	var hasRequiredStringify$3;

	function requireStringify$3 () {
		if (hasRequiredStringify$3) return stringify$3;
		hasRequiredStringify$3 = 1;
		var parent = /*@__PURE__*/ requireStringify$4();

		stringify$3 = parent;
		return stringify$3;
	}

	var stringify$2;
	var hasRequiredStringify$2;
	function requireStringify$2() {
	  if (hasRequiredStringify$2) return stringify$2;
	  hasRequiredStringify$2 = 1;
	  stringify$2 = /*@__PURE__*/requireStringify$3();
	  return stringify$2;
	}

	var stringifyExports = requireStringify$2();
	var _JSON$stringify = /*@__PURE__*/getDefaultExportFromCjs(stringifyExports);

	var build$o = {};

	var build$n = {};

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/**
	 * Creates a const map from the given values
	 * @param values - An array of values to be used as keys and values in the map.
	 * @returns A populated version of the map with the values and keys derived from the values.
	 */
	/*#__NO_SIDE_EFFECTS__*/
	function createConstMap(values) {
	  // eslint-disable-next-line prefer-const, @typescript-eslint/no-explicit-any
	  var res = {};
	  var len = values.length;
	  for (var lp = 0; lp < len; lp++) {
	    var val = values[lp];
	    if (val) {
	      res[String(val).toUpperCase().replace(/[-.]/g, '_')] = val;
	    }
	  }
	  return res;
	}

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	//----------------------------------------------------------------------------------------------------------
	// DO NOT EDIT, this is an Auto-generated file from scripts/semconv/templates//templates/SemanticAttributes.ts.j2
	//----------------------------------------------------------------------------------------------------------
	//----------------------------------------------------------------------------------------------------------
	// Constant values for SemanticAttributes
	//----------------------------------------------------------------------------------------------------------
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_AWS_LAMBDA_INVOKED_ARN = 'aws.lambda.invoked_arn';
	var TMP_DB_SYSTEM = 'db.system';
	var TMP_DB_CONNECTION_STRING = 'db.connection_string';
	var TMP_DB_USER = 'db.user';
	var TMP_DB_JDBC_DRIVER_CLASSNAME = 'db.jdbc.driver_classname';
	var TMP_DB_NAME = 'db.name';
	var TMP_DB_STATEMENT = 'db.statement';
	var TMP_DB_OPERATION = 'db.operation';
	var TMP_DB_MSSQL_INSTANCE_NAME = 'db.mssql.instance_name';
	var TMP_DB_CASSANDRA_KEYSPACE = 'db.cassandra.keyspace';
	var TMP_DB_CASSANDRA_PAGE_SIZE = 'db.cassandra.page_size';
	var TMP_DB_CASSANDRA_CONSISTENCY_LEVEL = 'db.cassandra.consistency_level';
	var TMP_DB_CASSANDRA_TABLE = 'db.cassandra.table';
	var TMP_DB_CASSANDRA_IDEMPOTENCE = 'db.cassandra.idempotence';
	var TMP_DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT = 'db.cassandra.speculative_execution_count';
	var TMP_DB_CASSANDRA_COORDINATOR_ID = 'db.cassandra.coordinator.id';
	var TMP_DB_CASSANDRA_COORDINATOR_DC = 'db.cassandra.coordinator.dc';
	var TMP_DB_HBASE_NAMESPACE = 'db.hbase.namespace';
	var TMP_DB_REDIS_DATABASE_INDEX = 'db.redis.database_index';
	var TMP_DB_MONGODB_COLLECTION = 'db.mongodb.collection';
	var TMP_DB_SQL_TABLE = 'db.sql.table';
	var TMP_EXCEPTION_TYPE = 'exception.type';
	var TMP_EXCEPTION_MESSAGE = 'exception.message';
	var TMP_EXCEPTION_STACKTRACE = 'exception.stacktrace';
	var TMP_EXCEPTION_ESCAPED = 'exception.escaped';
	var TMP_FAAS_TRIGGER = 'faas.trigger';
	var TMP_FAAS_EXECUTION = 'faas.execution';
	var TMP_FAAS_DOCUMENT_COLLECTION = 'faas.document.collection';
	var TMP_FAAS_DOCUMENT_OPERATION = 'faas.document.operation';
	var TMP_FAAS_DOCUMENT_TIME = 'faas.document.time';
	var TMP_FAAS_DOCUMENT_NAME = 'faas.document.name';
	var TMP_FAAS_TIME = 'faas.time';
	var TMP_FAAS_CRON = 'faas.cron';
	var TMP_FAAS_COLDSTART = 'faas.coldstart';
	var TMP_FAAS_INVOKED_NAME = 'faas.invoked_name';
	var TMP_FAAS_INVOKED_PROVIDER = 'faas.invoked_provider';
	var TMP_FAAS_INVOKED_REGION = 'faas.invoked_region';
	var TMP_NET_TRANSPORT = 'net.transport';
	var TMP_NET_PEER_IP = 'net.peer.ip';
	var TMP_NET_PEER_PORT = 'net.peer.port';
	var TMP_NET_PEER_NAME = 'net.peer.name';
	var TMP_NET_HOST_IP = 'net.host.ip';
	var TMP_NET_HOST_PORT = 'net.host.port';
	var TMP_NET_HOST_NAME = 'net.host.name';
	var TMP_NET_HOST_CONNECTION_TYPE = 'net.host.connection.type';
	var TMP_NET_HOST_CONNECTION_SUBTYPE = 'net.host.connection.subtype';
	var TMP_NET_HOST_CARRIER_NAME = 'net.host.carrier.name';
	var TMP_NET_HOST_CARRIER_MCC = 'net.host.carrier.mcc';
	var TMP_NET_HOST_CARRIER_MNC = 'net.host.carrier.mnc';
	var TMP_NET_HOST_CARRIER_ICC = 'net.host.carrier.icc';
	var TMP_PEER_SERVICE = 'peer.service';
	var TMP_ENDUSER_ID = 'enduser.id';
	var TMP_ENDUSER_ROLE = 'enduser.role';
	var TMP_ENDUSER_SCOPE = 'enduser.scope';
	var TMP_THREAD_ID = 'thread.id';
	var TMP_THREAD_NAME = 'thread.name';
	var TMP_CODE_FUNCTION = 'code.function';
	var TMP_CODE_NAMESPACE = 'code.namespace';
	var TMP_CODE_FILEPATH = 'code.filepath';
	var TMP_CODE_LINENO = 'code.lineno';
	var TMP_HTTP_METHOD = 'http.method';
	var TMP_HTTP_URL = 'http.url';
	var TMP_HTTP_TARGET = 'http.target';
	var TMP_HTTP_HOST = 'http.host';
	var TMP_HTTP_SCHEME = 'http.scheme';
	var TMP_HTTP_STATUS_CODE = 'http.status_code';
	var TMP_HTTP_FLAVOR = 'http.flavor';
	var TMP_HTTP_USER_AGENT = 'http.user_agent';
	var TMP_HTTP_REQUEST_CONTENT_LENGTH = 'http.request_content_length';
	var TMP_HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED = 'http.request_content_length_uncompressed';
	var TMP_HTTP_RESPONSE_CONTENT_LENGTH = 'http.response_content_length';
	var TMP_HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED = 'http.response_content_length_uncompressed';
	var TMP_HTTP_SERVER_NAME = 'http.server_name';
	var TMP_HTTP_ROUTE = 'http.route';
	var TMP_HTTP_CLIENT_IP = 'http.client_ip';
	var TMP_AWS_DYNAMODB_TABLE_NAMES = 'aws.dynamodb.table_names';
	var TMP_AWS_DYNAMODB_CONSUMED_CAPACITY = 'aws.dynamodb.consumed_capacity';
	var TMP_AWS_DYNAMODB_ITEM_COLLECTION_METRICS = 'aws.dynamodb.item_collection_metrics';
	var TMP_AWS_DYNAMODB_PROVISIONED_READ_CAPACITY = 'aws.dynamodb.provisioned_read_capacity';
	var TMP_AWS_DYNAMODB_PROVISIONED_WRITE_CAPACITY = 'aws.dynamodb.provisioned_write_capacity';
	var TMP_AWS_DYNAMODB_CONSISTENT_READ = 'aws.dynamodb.consistent_read';
	var TMP_AWS_DYNAMODB_PROJECTION = 'aws.dynamodb.projection';
	var TMP_AWS_DYNAMODB_LIMIT = 'aws.dynamodb.limit';
	var TMP_AWS_DYNAMODB_ATTRIBUTES_TO_GET = 'aws.dynamodb.attributes_to_get';
	var TMP_AWS_DYNAMODB_INDEX_NAME = 'aws.dynamodb.index_name';
	var TMP_AWS_DYNAMODB_SELECT = 'aws.dynamodb.select';
	var TMP_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEXES = 'aws.dynamodb.global_secondary_indexes';
	var TMP_AWS_DYNAMODB_LOCAL_SECONDARY_INDEXES = 'aws.dynamodb.local_secondary_indexes';
	var TMP_AWS_DYNAMODB_EXCLUSIVE_START_TABLE = 'aws.dynamodb.exclusive_start_table';
	var TMP_AWS_DYNAMODB_TABLE_COUNT = 'aws.dynamodb.table_count';
	var TMP_AWS_DYNAMODB_SCAN_FORWARD = 'aws.dynamodb.scan_forward';
	var TMP_AWS_DYNAMODB_SEGMENT = 'aws.dynamodb.segment';
	var TMP_AWS_DYNAMODB_TOTAL_SEGMENTS = 'aws.dynamodb.total_segments';
	var TMP_AWS_DYNAMODB_COUNT = 'aws.dynamodb.count';
	var TMP_AWS_DYNAMODB_SCANNED_COUNT = 'aws.dynamodb.scanned_count';
	var TMP_AWS_DYNAMODB_ATTRIBUTE_DEFINITIONS = 'aws.dynamodb.attribute_definitions';
	var TMP_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEX_UPDATES = 'aws.dynamodb.global_secondary_index_updates';
	var TMP_MESSAGING_SYSTEM = 'messaging.system';
	var TMP_MESSAGING_DESTINATION = 'messaging.destination';
	var TMP_MESSAGING_DESTINATION_KIND = 'messaging.destination_kind';
	var TMP_MESSAGING_TEMP_DESTINATION = 'messaging.temp_destination';
	var TMP_MESSAGING_PROTOCOL = 'messaging.protocol';
	var TMP_MESSAGING_PROTOCOL_VERSION = 'messaging.protocol_version';
	var TMP_MESSAGING_URL = 'messaging.url';
	var TMP_MESSAGING_MESSAGE_ID = 'messaging.message_id';
	var TMP_MESSAGING_CONVERSATION_ID = 'messaging.conversation_id';
	var TMP_MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES = 'messaging.message_payload_size_bytes';
	var TMP_MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES = 'messaging.message_payload_compressed_size_bytes';
	var TMP_MESSAGING_OPERATION = 'messaging.operation';
	var TMP_MESSAGING_CONSUMER_ID = 'messaging.consumer_id';
	var TMP_MESSAGING_RABBITMQ_ROUTING_KEY = 'messaging.rabbitmq.routing_key';
	var TMP_MESSAGING_KAFKA_MESSAGE_KEY = 'messaging.kafka.message_key';
	var TMP_MESSAGING_KAFKA_CONSUMER_GROUP = 'messaging.kafka.consumer_group';
	var TMP_MESSAGING_KAFKA_CLIENT_ID = 'messaging.kafka.client_id';
	var TMP_MESSAGING_KAFKA_PARTITION = 'messaging.kafka.partition';
	var TMP_MESSAGING_KAFKA_TOMBSTONE = 'messaging.kafka.tombstone';
	var TMP_RPC_SYSTEM = 'rpc.system';
	var TMP_RPC_SERVICE = 'rpc.service';
	var TMP_RPC_METHOD = 'rpc.method';
	var TMP_RPC_GRPC_STATUS_CODE = 'rpc.grpc.status_code';
	var TMP_RPC_JSONRPC_VERSION = 'rpc.jsonrpc.version';
	var TMP_RPC_JSONRPC_REQUEST_ID = 'rpc.jsonrpc.request_id';
	var TMP_RPC_JSONRPC_ERROR_CODE = 'rpc.jsonrpc.error_code';
	var TMP_RPC_JSONRPC_ERROR_MESSAGE = 'rpc.jsonrpc.error_message';
	var TMP_MESSAGE_TYPE = 'message.type';
	var TMP_MESSAGE_ID = 'message.id';
	var TMP_MESSAGE_COMPRESSED_SIZE = 'message.compressed_size';
	var TMP_MESSAGE_UNCOMPRESSED_SIZE = 'message.uncompressed_size';
	/**
	 * The full invoked ARN as provided on the `Context` passed to the function (`Lambda-Runtime-Invoked-Function-Arn` header on the `/runtime/invocation/next` applicable).
	 *
	 * Note: This may be different from `faas.id` if an alias is involved.
	 *
	 * @deprecated Use ATTR_AWS_LAMBDA_INVOKED_ARN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_LAMBDA_INVOKED_ARN = TMP_AWS_LAMBDA_INVOKED_ARN;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use ATTR_DB_SYSTEM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_SYSTEM = TMP_DB_SYSTEM;
	/**
	 * The connection string used to connect to the database. It is recommended to remove embedded credentials.
	 *
	 * @deprecated Use ATTR_DB_CONNECTION_STRING in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CONNECTION_STRING = TMP_DB_CONNECTION_STRING;
	/**
	 * Username for accessing the database.
	 *
	 * @deprecated Use ATTR_DB_USER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_USER = TMP_DB_USER;
	/**
	 * The fully-qualified class name of the [Java Database Connectivity (JDBC)](https://docs.oracle.com/javase/8/docs/technotes/guides/jdbc/) driver used to connect.
	 *
	 * @deprecated Use ATTR_DB_JDBC_DRIVER_CLASSNAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_JDBC_DRIVER_CLASSNAME = TMP_DB_JDBC_DRIVER_CLASSNAME;
	/**
	 * If no [tech-specific attribute](#call-level-attributes-for-specific-technologies) is defined, this attribute is used to report the name of the database being accessed. For commands that switch the database, this should be set to the target database (even if the command fails).
	 *
	 * Note: In some SQL databases, the database name to be used is called &#34;schema name&#34;.
	 *
	 * @deprecated Use ATTR_DB_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_NAME = TMP_DB_NAME;
	/**
	 * The database statement being executed.
	 *
	 * Note: The value may be sanitized to exclude sensitive information.
	 *
	 * @deprecated Use ATTR_DB_STATEMENT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_STATEMENT = TMP_DB_STATEMENT;
	/**
	 * The name of the operation being executed, e.g. the [MongoDB command name](https://docs.mongodb.com/manual/reference/command/#database-operations) such as `findAndModify`, or the SQL keyword.
	 *
	 * Note: When setting this to an SQL keyword, it is not recommended to attempt any client-side parsing of `db.statement` just to get this property, but it should be set if the operation name is provided by the library being instrumented. If the SQL statement has an ambiguous operation, or performs more than one operation, this value may be omitted.
	 *
	 * @deprecated Use ATTR_DB_OPERATION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_OPERATION = TMP_DB_OPERATION;
	/**
	 * The Microsoft SQL Server [instance name](https://docs.microsoft.com/en-us/sql/connect/jdbc/building-the-connection-url?view=sql-server-ver15) connecting to. This name is used to determine the port of a named instance.
	 *
	 * Note: If setting a `db.mssql.instance_name`, `net.peer.port` is no longer required (but still recommended if non-standard).
	 *
	 * @deprecated Use ATTR_DB_MSSQL_INSTANCE_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_MSSQL_INSTANCE_NAME = TMP_DB_MSSQL_INSTANCE_NAME;
	/**
	 * The name of the keyspace being accessed. To be used instead of the generic `db.name` attribute.
	 *
	 * @deprecated Use ATTR_DB_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CASSANDRA_KEYSPACE = TMP_DB_CASSANDRA_KEYSPACE;
	/**
	 * The fetch size used for paging, i.e. how many rows will be returned at once.
	 *
	 * @deprecated Use ATTR_DB_CASSANDRA_PAGE_SIZE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CASSANDRA_PAGE_SIZE = TMP_DB_CASSANDRA_PAGE_SIZE;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use ATTR_DB_CASSANDRA_CONSISTENCY_LEVEL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CASSANDRA_CONSISTENCY_LEVEL = TMP_DB_CASSANDRA_CONSISTENCY_LEVEL;
	/**
	 * The name of the primary table that the operation is acting upon, including the schema name (if applicable).
	 *
	 * Note: This mirrors the db.sql.table attribute but references cassandra rather than sql. It is not recommended to attempt any client-side parsing of `db.statement` just to get this property, but it should be set if it is provided by the library being instrumented. If the operation is acting upon an anonymous table, or more than one table, this value MUST NOT be set.
	 *
	 * @deprecated Use ATTR_DB_CASSANDRA_TABLE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CASSANDRA_TABLE = TMP_DB_CASSANDRA_TABLE;
	/**
	 * Whether or not the query is idempotent.
	 *
	 * @deprecated Use ATTR_DB_CASSANDRA_IDEMPOTENCE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CASSANDRA_IDEMPOTENCE = TMP_DB_CASSANDRA_IDEMPOTENCE;
	/**
	 * The number of times a query was speculatively executed. Not set or `0` if the query was not executed speculatively.
	 *
	 * @deprecated Use ATTR_DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT = TMP_DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT;
	/**
	 * The ID of the coordinating node for a query.
	 *
	 * @deprecated Use ATTR_DB_CASSANDRA_COORDINATOR_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CASSANDRA_COORDINATOR_ID = TMP_DB_CASSANDRA_COORDINATOR_ID;
	/**
	 * The data center of the coordinating node for a query.
	 *
	 * @deprecated Use ATTR_DB_CASSANDRA_COORDINATOR_DC in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_CASSANDRA_COORDINATOR_DC = TMP_DB_CASSANDRA_COORDINATOR_DC;
	/**
	 * The [HBase namespace](https://hbase.apache.org/book.html#_namespace) being accessed. To be used instead of the generic `db.name` attribute.
	 *
	 * @deprecated Use ATTR_DB_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_HBASE_NAMESPACE = TMP_DB_HBASE_NAMESPACE;
	/**
	 * The index of the database being accessed as used in the [`SELECT` command](https://redis.io/commands/select), provided as an integer. To be used instead of the generic `db.name` attribute.
	 *
	 * @deprecated Use ATTR_DB_REDIS_DATABASE_INDEX in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_REDIS_DATABASE_INDEX = TMP_DB_REDIS_DATABASE_INDEX;
	/**
	 * The collection being accessed within the database stated in `db.name`.
	 *
	 * @deprecated Use ATTR_DB_MONGODB_COLLECTION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_MONGODB_COLLECTION = TMP_DB_MONGODB_COLLECTION;
	/**
	 * The name of the primary table that the operation is acting upon, including the schema name (if applicable).
	 *
	 * Note: It is not recommended to attempt any client-side parsing of `db.statement` just to get this property, but it should be set if it is provided by the library being instrumented. If the operation is acting upon an anonymous table, or more than one table, this value MUST NOT be set.
	 *
	 * @deprecated Use ATTR_DB_SQL_TABLE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_DB_SQL_TABLE = TMP_DB_SQL_TABLE;
	/**
	 * The type of the exception (its fully-qualified class name, if applicable). The dynamic type of the exception should be preferred over the static type in languages that support it.
	 *
	 * @deprecated Use ATTR_EXCEPTION_TYPE.
	 */
	var SEMATTRS_EXCEPTION_TYPE = TMP_EXCEPTION_TYPE;
	/**
	 * The exception message.
	 *
	 * @deprecated Use ATTR_EXCEPTION_MESSAGE.
	 */
	var SEMATTRS_EXCEPTION_MESSAGE = TMP_EXCEPTION_MESSAGE;
	/**
	 * A stacktrace as a string in the natural representation for the language runtime. The representation is to be determined and documented by each language SIG.
	 *
	 * @deprecated Use ATTR_EXCEPTION_STACKTRACE.
	 */
	var SEMATTRS_EXCEPTION_STACKTRACE = TMP_EXCEPTION_STACKTRACE;
	/**
	* SHOULD be set to true if the exception event is recorded at a point where it is known that the exception is escaping the scope of the span.
	*
	* Note: An exception is considered to have escaped (or left) the scope of a span,
	if that span is ended while the exception is still logically &#34;in flight&#34;.
	This may be actually &#34;in flight&#34; in some languages (e.g. if the exception
	is passed to a Context manager&#39;s `__exit__` method in Python) but will
	usually be caught at the point of recording the exception in most languages.

	It is usually not possible to determine at the point where an exception is thrown
	whether it will escape the scope of a span.
	However, it is trivial to know that an exception
	will escape, if one checks for an active exception just before ending the span,
	as done in the [example above](#exception-end-example).

	It follows that an exception may still escape the scope of the span
	even if the `exception.escaped` attribute was not set or set to false,
	since the event might have been recorded at a time where it was not
	clear whether the exception will escape.
	*
	* @deprecated Use ATTR_EXCEPTION_ESCAPED.
	*/
	var SEMATTRS_EXCEPTION_ESCAPED = TMP_EXCEPTION_ESCAPED;
	/**
	 * Type of the trigger on which the function is executed.
	 *
	 * @deprecated Use ATTR_FAAS_TRIGGER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_TRIGGER = TMP_FAAS_TRIGGER;
	/**
	 * The execution ID of the current function execution.
	 *
	 * @deprecated Use ATTR_FAAS_INVOCATION_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_EXECUTION = TMP_FAAS_EXECUTION;
	/**
	 * The name of the source on which the triggering operation was performed. For example, in Cloud Storage or S3 corresponds to the bucket name, and in Cosmos DB to the database name.
	 *
	 * @deprecated Use ATTR_FAAS_DOCUMENT_COLLECTION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_DOCUMENT_COLLECTION = TMP_FAAS_DOCUMENT_COLLECTION;
	/**
	 * Describes the type of the operation that was performed on the data.
	 *
	 * @deprecated Use ATTR_FAAS_DOCUMENT_OPERATION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_DOCUMENT_OPERATION = TMP_FAAS_DOCUMENT_OPERATION;
	/**
	 * A string containing the time when the data was accessed in the [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format expressed in [UTC](https://www.w3.org/TR/NOTE-datetime).
	 *
	 * @deprecated Use ATTR_FAAS_DOCUMENT_TIME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_DOCUMENT_TIME = TMP_FAAS_DOCUMENT_TIME;
	/**
	 * The document name/table subjected to the operation. For example, in Cloud Storage or S3 is the name of the file, and in Cosmos DB the table name.
	 *
	 * @deprecated Use ATTR_FAAS_DOCUMENT_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_DOCUMENT_NAME = TMP_FAAS_DOCUMENT_NAME;
	/**
	 * A string containing the function invocation time in the [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format expressed in [UTC](https://www.w3.org/TR/NOTE-datetime).
	 *
	 * @deprecated Use ATTR_FAAS_TIME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_TIME = TMP_FAAS_TIME;
	/**
	 * A string containing the schedule period as [Cron Expression](https://docs.oracle.com/cd/E12058_01/doc/doc.1014/e12030/cron_expressions.htm).
	 *
	 * @deprecated Use ATTR_FAAS_CRON in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_CRON = TMP_FAAS_CRON;
	/**
	 * A boolean that is true if the serverless function is executed for the first time (aka cold-start).
	 *
	 * @deprecated Use ATTR_FAAS_COLDSTART in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_COLDSTART = TMP_FAAS_COLDSTART;
	/**
	 * The name of the invoked function.
	 *
	 * Note: SHOULD be equal to the `faas.name` resource attribute of the invoked function.
	 *
	 * @deprecated Use ATTR_FAAS_INVOKED_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_INVOKED_NAME = TMP_FAAS_INVOKED_NAME;
	/**
	 * The cloud provider of the invoked function.
	 *
	 * Note: SHOULD be equal to the `cloud.provider` resource attribute of the invoked function.
	 *
	 * @deprecated Use ATTR_FAAS_INVOKED_PROVIDER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_INVOKED_PROVIDER = TMP_FAAS_INVOKED_PROVIDER;
	/**
	 * The cloud region of the invoked function.
	 *
	 * Note: SHOULD be equal to the `cloud.region` resource attribute of the invoked function.
	 *
	 * @deprecated Use ATTR_FAAS_INVOKED_REGION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_FAAS_INVOKED_REGION = TMP_FAAS_INVOKED_REGION;
	/**
	 * Transport protocol used. See note below.
	 *
	 * @deprecated Use ATTR_NET_TRANSPORT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_TRANSPORT = TMP_NET_TRANSPORT;
	/**
	 * Remote address of the peer (dotted decimal for IPv4 or [RFC5952](https://tools.ietf.org/html/rfc5952) for IPv6).
	 *
	 * @deprecated Use ATTR_NET_PEER_IP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_PEER_IP = TMP_NET_PEER_IP;
	/**
	 * Remote port number.
	 *
	 * @deprecated Use ATTR_NET_PEER_PORT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_PEER_PORT = TMP_NET_PEER_PORT;
	/**
	 * Remote hostname or similar, see note below.
	 *
	 * @deprecated Use ATTR_NET_PEER_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_PEER_NAME = TMP_NET_PEER_NAME;
	/**
	 * Like `net.peer.ip` but for the host IP. Useful in case of a multi-IP host.
	 *
	 * @deprecated Use ATTR_NET_HOST_IP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_IP = TMP_NET_HOST_IP;
	/**
	 * Like `net.peer.port` but for the host port.
	 *
	 * @deprecated Use ATTR_NET_HOST_PORT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_PORT = TMP_NET_HOST_PORT;
	/**
	 * Local hostname or similar, see note below.
	 *
	 * @deprecated Use ATTR_NET_HOST_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_NAME = TMP_NET_HOST_NAME;
	/**
	 * The internet connection type currently being used by the host.
	 *
	 * @deprecated Use ATTR_NETWORK_CONNECTION_TYPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_CONNECTION_TYPE = TMP_NET_HOST_CONNECTION_TYPE;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use ATTR_NETWORK_CONNECTION_SUBTYPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_CONNECTION_SUBTYPE = TMP_NET_HOST_CONNECTION_SUBTYPE;
	/**
	 * The name of the mobile carrier.
	 *
	 * @deprecated Use ATTR_NETWORK_CARRIER_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_CARRIER_NAME = TMP_NET_HOST_CARRIER_NAME;
	/**
	 * The mobile carrier country code.
	 *
	 * @deprecated Use ATTR_NETWORK_CARRIER_MCC in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_CARRIER_MCC = TMP_NET_HOST_CARRIER_MCC;
	/**
	 * The mobile carrier network code.
	 *
	 * @deprecated Use ATTR_NETWORK_CARRIER_MNC in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_CARRIER_MNC = TMP_NET_HOST_CARRIER_MNC;
	/**
	 * The ISO 3166-1 alpha-2 2-character country code associated with the mobile carrier network.
	 *
	 * @deprecated Use ATTR_NETWORK_CARRIER_ICC in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_NET_HOST_CARRIER_ICC = TMP_NET_HOST_CARRIER_ICC;
	/**
	 * The [`service.name`](../../resource/semantic_conventions/README.md#service) of the remote service. SHOULD be equal to the actual `service.name` resource attribute of the remote service if any.
	 *
	 * @deprecated Use ATTR_PEER_SERVICE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_PEER_SERVICE = TMP_PEER_SERVICE;
	/**
	 * Username or client_id extracted from the access token or [Authorization](https://tools.ietf.org/html/rfc7235#section-4.2) header in the inbound request from outside the system.
	 *
	 * @deprecated Use ATTR_ENDUSER_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_ENDUSER_ID = TMP_ENDUSER_ID;
	/**
	 * Actual/assumed role the client is making the request under extracted from token or application security context.
	 *
	 * @deprecated Use ATTR_ENDUSER_ROLE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_ENDUSER_ROLE = TMP_ENDUSER_ROLE;
	/**
	 * Scopes or granted authorities the client currently possesses extracted from token or application security context. The value would come from the scope associated with an [OAuth 2.0 Access Token](https://tools.ietf.org/html/rfc6749#section-3.3) or an attribute value in a [SAML 2.0 Assertion](http://docs.oasis-open.org/security/saml/Post2.0/sstc-saml-tech-overview-2.0.html).
	 *
	 * @deprecated Use ATTR_ENDUSER_SCOPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_ENDUSER_SCOPE = TMP_ENDUSER_SCOPE;
	/**
	 * Current &#34;managed&#34; thread ID (as opposed to OS thread ID).
	 *
	 * @deprecated Use ATTR_THREAD_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_THREAD_ID = TMP_THREAD_ID;
	/**
	 * Current thread name.
	 *
	 * @deprecated Use ATTR_THREAD_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_THREAD_NAME = TMP_THREAD_NAME;
	/**
	 * The method or function name, or equivalent (usually rightmost part of the code unit&#39;s name).
	 *
	 * @deprecated Use ATTR_CODE_FUNCTION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_CODE_FUNCTION = TMP_CODE_FUNCTION;
	/**
	 * The &#34;namespace&#34; within which `code.function` is defined. Usually the qualified class or module name, such that `code.namespace` + some separator + `code.function` form a unique identifier for the code unit.
	 *
	 * @deprecated Use ATTR_CODE_NAMESPACE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_CODE_NAMESPACE = TMP_CODE_NAMESPACE;
	/**
	 * The source code file name that identifies the code unit as uniquely as possible (preferably an absolute file path).
	 *
	 * @deprecated Use ATTR_CODE_FILEPATH in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_CODE_FILEPATH = TMP_CODE_FILEPATH;
	/**
	 * The line number in `code.filepath` best representing the operation. It SHOULD point within the code unit named in `code.function`.
	 *
	 * @deprecated Use ATTR_CODE_LINENO in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_CODE_LINENO = TMP_CODE_LINENO;
	/**
	 * HTTP request method.
	 *
	 * @deprecated Use ATTR_HTTP_METHOD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_METHOD = TMP_HTTP_METHOD;
	/**
	 * Full HTTP request URL in the form `scheme://host[:port]/path?query[#fragment]`. Usually the fragment is not transmitted over HTTP, but if it is known, it should be included nevertheless.
	 *
	 * Note: `http.url` MUST NOT contain credentials passed via URL in form of `https://username:password@www.example.com/`. In such case the attribute&#39;s value should be `https://www.example.com/`.
	 *
	 * @deprecated Use ATTR_HTTP_URL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_URL = TMP_HTTP_URL;
	/**
	 * The full request target as passed in a HTTP request line or equivalent.
	 *
	 * @deprecated Use ATTR_HTTP_TARGET in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_TARGET = TMP_HTTP_TARGET;
	/**
	 * The value of the [HTTP host header](https://tools.ietf.org/html/rfc7230#section-5.4). An empty Host header should also be reported, see note.
	 *
	 * Note: When the header is present but empty the attribute SHOULD be set to the empty string. Note that this is a valid situation that is expected in certain cases, according the aforementioned [section of RFC 7230](https://tools.ietf.org/html/rfc7230#section-5.4). When the header is not set the attribute MUST NOT be set.
	 *
	 * @deprecated Use ATTR_HTTP_HOST in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_HOST = TMP_HTTP_HOST;
	/**
	 * The URI scheme identifying the used protocol.
	 *
	 * @deprecated Use ATTR_HTTP_SCHEME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_SCHEME = TMP_HTTP_SCHEME;
	/**
	 * [HTTP response status code](https://tools.ietf.org/html/rfc7231#section-6).
	 *
	 * @deprecated Use ATTR_HTTP_STATUS_CODE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_STATUS_CODE = TMP_HTTP_STATUS_CODE;
	/**
	 * Kind of HTTP protocol used.
	 *
	 * Note: If `net.transport` is not specified, it can be assumed to be `IP.TCP` except if `http.flavor` is `QUIC`, in which case `IP.UDP` is assumed.
	 *
	 * @deprecated Use ATTR_HTTP_FLAVOR in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_FLAVOR = TMP_HTTP_FLAVOR;
	/**
	 * Value of the [HTTP User-Agent](https://tools.ietf.org/html/rfc7231#section-5.5.3) header sent by the client.
	 *
	 * @deprecated Use ATTR_HTTP_USER_AGENT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_USER_AGENT = TMP_HTTP_USER_AGENT;
	/**
	 * The size of the request payload body in bytes. This is the number of bytes transferred excluding headers and is often, but not always, present as the [Content-Length](https://tools.ietf.org/html/rfc7230#section-3.3.2) header. For requests using transport encoding, this should be the compressed size.
	 *
	 * @deprecated Use ATTR_HTTP_REQUEST_CONTENT_LENGTH in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_REQUEST_CONTENT_LENGTH = TMP_HTTP_REQUEST_CONTENT_LENGTH;
	/**
	 * The size of the uncompressed request payload body after transport decoding. Not set if transport encoding not used.
	 *
	 * @deprecated Use ATTR_HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED = TMP_HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED;
	/**
	 * The size of the response payload body in bytes. This is the number of bytes transferred excluding headers and is often, but not always, present as the [Content-Length](https://tools.ietf.org/html/rfc7230#section-3.3.2) header. For requests using transport encoding, this should be the compressed size.
	 *
	 * @deprecated Use ATTR_HTTP_RESPONSE_CONTENT_LENGTH in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_RESPONSE_CONTENT_LENGTH = TMP_HTTP_RESPONSE_CONTENT_LENGTH;
	/**
	 * The size of the uncompressed response payload body after transport decoding. Not set if transport encoding not used.
	 *
	 * @deprecated Use ATTR_HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED = TMP_HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED;
	/**
	 * The primary server name of the matched virtual host. This should be obtained via configuration. If no such configuration can be obtained, this attribute MUST NOT be set ( `net.host.name` should be used instead).
	 *
	 * Note: `http.url` is usually not readily available on the server side but would have to be assembled in a cumbersome and sometimes lossy process from other information (see e.g. open-telemetry/opentelemetry-python/pull/148). It is thus preferred to supply the raw data that is available.
	 *
	 * @deprecated Use ATTR_HTTP_SERVER_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_HTTP_SERVER_NAME = TMP_HTTP_SERVER_NAME;
	/**
	 * The matched route (path template).
	 *
	 * @deprecated Use ATTR_HTTP_ROUTE.
	 */
	var SEMATTRS_HTTP_ROUTE = TMP_HTTP_ROUTE;
	/**
	* The IP address of the original client behind all proxies, if known (e.g. from [X-Forwarded-For](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For)).
	*
	* Note: This is not necessarily the same as `net.peer.ip`, which would
	identify the network-level peer, which may be a proxy.

	This attribute should be set when a source of information different
	from the one used for `net.peer.ip`, is available even if that other
	source just confirms the same value as `net.peer.ip`.
	Rationale: For `net.peer.ip`, one typically does not know if it
	comes from a proxy, reverse proxy, or the actual client. Setting
	`http.client_ip` when it&#39;s the same as `net.peer.ip` means that
	one is at least somewhat confident that the address is not that of
	the closest proxy.
	*
	* @deprecated Use ATTR_HTTP_CLIENT_IP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	*/
	var SEMATTRS_HTTP_CLIENT_IP = TMP_HTTP_CLIENT_IP;
	/**
	 * The keys in the `RequestItems` object field.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_TABLE_NAMES in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_TABLE_NAMES = TMP_AWS_DYNAMODB_TABLE_NAMES;
	/**
	 * The JSON-serialized value of each item in the `ConsumedCapacity` response field.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_CONSUMED_CAPACITY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_CONSUMED_CAPACITY = TMP_AWS_DYNAMODB_CONSUMED_CAPACITY;
	/**
	 * The JSON-serialized value of the `ItemCollectionMetrics` response field.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_ITEM_COLLECTION_METRICS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_ITEM_COLLECTION_METRICS = TMP_AWS_DYNAMODB_ITEM_COLLECTION_METRICS;
	/**
	 * The value of the `ProvisionedThroughput.ReadCapacityUnits` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_PROVISIONED_READ_CAPACITY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_PROVISIONED_READ_CAPACITY = TMP_AWS_DYNAMODB_PROVISIONED_READ_CAPACITY;
	/**
	 * The value of the `ProvisionedThroughput.WriteCapacityUnits` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_PROVISIONED_WRITE_CAPACITY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_PROVISIONED_WRITE_CAPACITY = TMP_AWS_DYNAMODB_PROVISIONED_WRITE_CAPACITY;
	/**
	 * The value of the `ConsistentRead` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_CONSISTENT_READ in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_CONSISTENT_READ = TMP_AWS_DYNAMODB_CONSISTENT_READ;
	/**
	 * The value of the `ProjectionExpression` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_PROJECTION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_PROJECTION = TMP_AWS_DYNAMODB_PROJECTION;
	/**
	 * The value of the `Limit` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_LIMIT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_LIMIT = TMP_AWS_DYNAMODB_LIMIT;
	/**
	 * The value of the `AttributesToGet` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_ATTRIBUTES_TO_GET in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_ATTRIBUTES_TO_GET = TMP_AWS_DYNAMODB_ATTRIBUTES_TO_GET;
	/**
	 * The value of the `IndexName` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_INDEX_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_INDEX_NAME = TMP_AWS_DYNAMODB_INDEX_NAME;
	/**
	 * The value of the `Select` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_SELECT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_SELECT = TMP_AWS_DYNAMODB_SELECT;
	/**
	 * The JSON-serialized value of each item of the `GlobalSecondaryIndexes` request field.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEXES in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEXES = TMP_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEXES;
	/**
	 * The JSON-serialized value of each item of the `LocalSecondaryIndexes` request field.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_LOCAL_SECONDARY_INDEXES in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_LOCAL_SECONDARY_INDEXES = TMP_AWS_DYNAMODB_LOCAL_SECONDARY_INDEXES;
	/**
	 * The value of the `ExclusiveStartTableName` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_EXCLUSIVE_START_TABLE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_EXCLUSIVE_START_TABLE = TMP_AWS_DYNAMODB_EXCLUSIVE_START_TABLE;
	/**
	 * The the number of items in the `TableNames` response parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_TABLE_COUNT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_TABLE_COUNT = TMP_AWS_DYNAMODB_TABLE_COUNT;
	/**
	 * The value of the `ScanIndexForward` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_SCAN_FORWARD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_SCAN_FORWARD = TMP_AWS_DYNAMODB_SCAN_FORWARD;
	/**
	 * The value of the `Segment` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_SEGMENT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_SEGMENT = TMP_AWS_DYNAMODB_SEGMENT;
	/**
	 * The value of the `TotalSegments` request parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_TOTAL_SEGMENTS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_TOTAL_SEGMENTS = TMP_AWS_DYNAMODB_TOTAL_SEGMENTS;
	/**
	 * The value of the `Count` response parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_COUNT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_COUNT = TMP_AWS_DYNAMODB_COUNT;
	/**
	 * The value of the `ScannedCount` response parameter.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_SCANNED_COUNT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_SCANNED_COUNT = TMP_AWS_DYNAMODB_SCANNED_COUNT;
	/**
	 * The JSON-serialized value of each item in the `AttributeDefinitions` request field.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_ATTRIBUTE_DEFINITIONS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_ATTRIBUTE_DEFINITIONS = TMP_AWS_DYNAMODB_ATTRIBUTE_DEFINITIONS;
	/**
	 * The JSON-serialized value of each item in the the `GlobalSecondaryIndexUpdates` request field.
	 *
	 * @deprecated Use ATTR_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEX_UPDATES in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEX_UPDATES = TMP_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEX_UPDATES;
	/**
	 * A string identifying the messaging system.
	 *
	 * @deprecated Use ATTR_MESSAGING_SYSTEM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_SYSTEM = TMP_MESSAGING_SYSTEM;
	/**
	 * The message destination name. This might be equal to the span name but is required nevertheless.
	 *
	 * @deprecated Use ATTR_MESSAGING_DESTINATION_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_DESTINATION = TMP_MESSAGING_DESTINATION;
	/**
	 * The kind of message destination.
	 *
	 * @deprecated Removed in semconv v1.20.0.
	 */
	var SEMATTRS_MESSAGING_DESTINATION_KIND = TMP_MESSAGING_DESTINATION_KIND;
	/**
	 * A boolean that is true if the message destination is temporary.
	 *
	 * @deprecated Use ATTR_MESSAGING_DESTINATION_TEMPORARY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_TEMP_DESTINATION = TMP_MESSAGING_TEMP_DESTINATION;
	/**
	 * The name of the transport protocol.
	 *
	 * @deprecated Use ATTR_NETWORK_PROTOCOL_NAME.
	 */
	var SEMATTRS_MESSAGING_PROTOCOL = TMP_MESSAGING_PROTOCOL;
	/**
	 * The version of the transport protocol.
	 *
	 * @deprecated Use ATTR_NETWORK_PROTOCOL_VERSION.
	 */
	var SEMATTRS_MESSAGING_PROTOCOL_VERSION = TMP_MESSAGING_PROTOCOL_VERSION;
	/**
	 * Connection string.
	 *
	 * @deprecated Removed in semconv v1.17.0.
	 */
	var SEMATTRS_MESSAGING_URL = TMP_MESSAGING_URL;
	/**
	 * A value used by the messaging system as an identifier for the message, represented as a string.
	 *
	 * @deprecated Use ATTR_MESSAGING_MESSAGE_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_MESSAGE_ID = TMP_MESSAGING_MESSAGE_ID;
	/**
	 * The [conversation ID](#conversations) identifying the conversation to which the message belongs, represented as a string. Sometimes called &#34;Correlation ID&#34;.
	 *
	 * @deprecated Use ATTR_MESSAGING_MESSAGE_CONVERSATION_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_CONVERSATION_ID = TMP_MESSAGING_CONVERSATION_ID;
	/**
	 * The (uncompressed) size of the message payload in bytes. Also use this attribute if it is unknown whether the compressed or uncompressed payload size is reported.
	 *
	 * @deprecated Use ATTR_MESSAGING_MESSAGE_BODY_SIZE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES = TMP_MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES;
	/**
	 * The compressed size of the message payload in bytes.
	 *
	 * @deprecated Removed in semconv v1.22.0.
	 */
	var SEMATTRS_MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES = TMP_MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES;
	/**
	 * A string identifying the kind of message consumption as defined in the [Operation names](#operation-names) section above. If the operation is &#34;send&#34;, this attribute MUST NOT be set, since the operation can be inferred from the span kind in that case.
	 *
	 * @deprecated Use ATTR_MESSAGING_OPERATION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_OPERATION = TMP_MESSAGING_OPERATION;
	/**
	 * The identifier for the consumer receiving a message. For Kafka, set it to `{messaging.kafka.consumer_group} - {messaging.kafka.client_id}`, if both are present, or only `messaging.kafka.consumer_group`. For brokers, such as RabbitMQ and Artemis, set it to the `client_id` of the client consuming the message.
	 *
	 * @deprecated Removed in semconv v1.21.0.
	 */
	var SEMATTRS_MESSAGING_CONSUMER_ID = TMP_MESSAGING_CONSUMER_ID;
	/**
	 * RabbitMQ message routing key.
	 *
	 * @deprecated Use ATTR_MESSAGING_RABBITMQ_DESTINATION_ROUTING_KEY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_RABBITMQ_ROUTING_KEY = TMP_MESSAGING_RABBITMQ_ROUTING_KEY;
	/**
	 * Message keys in Kafka are used for grouping alike messages to ensure they&#39;re processed on the same partition. They differ from `messaging.message_id` in that they&#39;re not unique. If the key is `null`, the attribute MUST NOT be set.
	 *
	 * Note: If the key type is not string, it&#39;s string representation has to be supplied for the attribute. If the key has no unambiguous, canonical string form, don&#39;t include its value.
	 *
	 * @deprecated Use ATTR_MESSAGING_KAFKA_MESSAGE_KEY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_KAFKA_MESSAGE_KEY = TMP_MESSAGING_KAFKA_MESSAGE_KEY;
	/**
	 * Name of the Kafka Consumer Group that is handling the message. Only applies to consumers, not producers.
	 *
	 * @deprecated Use ATTR_MESSAGING_KAFKA_CONSUMER_GROUP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_KAFKA_CONSUMER_GROUP = TMP_MESSAGING_KAFKA_CONSUMER_GROUP;
	/**
	 * Client Id for the Consumer or Producer that is handling the message.
	 *
	 * @deprecated Use ATTR_MESSAGING_CLIENT_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_KAFKA_CLIENT_ID = TMP_MESSAGING_KAFKA_CLIENT_ID;
	/**
	 * Partition the message is sent to.
	 *
	 * @deprecated Use ATTR_MESSAGING_KAFKA_DESTINATION_PARTITION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_KAFKA_PARTITION = TMP_MESSAGING_KAFKA_PARTITION;
	/**
	 * A boolean that is true if the message is a tombstone.
	 *
	 * @deprecated Use ATTR_MESSAGING_KAFKA_MESSAGE_TOMBSTONE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGING_KAFKA_TOMBSTONE = TMP_MESSAGING_KAFKA_TOMBSTONE;
	/**
	 * A string identifying the remoting system.
	 *
	 * @deprecated Use ATTR_RPC_SYSTEM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_RPC_SYSTEM = TMP_RPC_SYSTEM;
	/**
	 * The full (logical) name of the service being called, including its package name, if applicable.
	 *
	 * Note: This is the logical name of the service from the RPC interface perspective, which can be different from the name of any implementing class. The `code.namespace` attribute may be used to store the latter (despite the attribute name, it may include a class name; e.g., class with method actually executing the call on the server side, RPC client stub class on the client side).
	 *
	 * @deprecated Use ATTR_RPC_SERVICE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_RPC_SERVICE = TMP_RPC_SERVICE;
	/**
	 * The name of the (logical) method being called, must be equal to the $method part in the span name.
	 *
	 * Note: This is the logical name of the method from the RPC interface perspective, which can be different from the name of any implementing method/function. The `code.function` attribute may be used to store the latter (e.g., method actually executing the call on the server side, RPC client stub method on the client side).
	 *
	 * @deprecated Use ATTR_RPC_METHOD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_RPC_METHOD = TMP_RPC_METHOD;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use ATTR_RPC_GRPC_STATUS_CODE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_RPC_GRPC_STATUS_CODE = TMP_RPC_GRPC_STATUS_CODE;
	/**
	 * Protocol version as in `jsonrpc` property of request/response. Since JSON-RPC 1.0 does not specify this, the value can be omitted.
	 *
	 * @deprecated Use ATTR_RPC_JSONRPC_VERSION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_RPC_JSONRPC_VERSION = TMP_RPC_JSONRPC_VERSION;
	/**
	 * `id` property of request or response. Since protocol allows id to be int, string, `null` or missing (for notifications), value is expected to be cast to string for simplicity. Use empty string in case of `null` value. Omit entirely if this is a notification.
	 *
	 * @deprecated Use ATTR_RPC_JSONRPC_REQUEST_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_RPC_JSONRPC_REQUEST_ID = TMP_RPC_JSONRPC_REQUEST_ID;
	/**
	 * `error.code` property of response if it is an error response.
	 *
	 * @deprecated Use ATTR_RPC_JSONRPC_ERROR_CODE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_RPC_JSONRPC_ERROR_CODE = TMP_RPC_JSONRPC_ERROR_CODE;
	/**
	 * `error.message` property of response if it is an error response.
	 *
	 * @deprecated Use ATTR_RPC_JSONRPC_ERROR_MESSAGE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_RPC_JSONRPC_ERROR_MESSAGE = TMP_RPC_JSONRPC_ERROR_MESSAGE;
	/**
	 * Whether this is a received or sent message.
	 *
	 * @deprecated Use ATTR_MESSAGE_TYPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGE_TYPE = TMP_MESSAGE_TYPE;
	/**
	 * MUST be calculated as two different counters starting from `1` one for sent messages and one for received message.
	 *
	 * Note: This way we guarantee that the values will be consistent between different implementations.
	 *
	 * @deprecated Use ATTR_MESSAGE_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGE_ID = TMP_MESSAGE_ID;
	/**
	 * Compressed size of the message in bytes.
	 *
	 * @deprecated Use ATTR_MESSAGE_COMPRESSED_SIZE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGE_COMPRESSED_SIZE = TMP_MESSAGE_COMPRESSED_SIZE;
	/**
	 * Uncompressed size of the message in bytes.
	 *
	 * @deprecated Use ATTR_MESSAGE_UNCOMPRESSED_SIZE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMATTRS_MESSAGE_UNCOMPRESSED_SIZE = TMP_MESSAGE_UNCOMPRESSED_SIZE;
	/**
	 * Create exported Value Map for SemanticAttributes values
	 * @deprecated Use the SEMATTRS_XXXXX constants rather than the SemanticAttributes.XXXXX for bundle minification
	 */
	var SemanticAttributes = /*#__PURE__*/createConstMap([TMP_AWS_LAMBDA_INVOKED_ARN, TMP_DB_SYSTEM, TMP_DB_CONNECTION_STRING, TMP_DB_USER, TMP_DB_JDBC_DRIVER_CLASSNAME, TMP_DB_NAME, TMP_DB_STATEMENT, TMP_DB_OPERATION, TMP_DB_MSSQL_INSTANCE_NAME, TMP_DB_CASSANDRA_KEYSPACE, TMP_DB_CASSANDRA_PAGE_SIZE, TMP_DB_CASSANDRA_CONSISTENCY_LEVEL, TMP_DB_CASSANDRA_TABLE, TMP_DB_CASSANDRA_IDEMPOTENCE, TMP_DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT, TMP_DB_CASSANDRA_COORDINATOR_ID, TMP_DB_CASSANDRA_COORDINATOR_DC, TMP_DB_HBASE_NAMESPACE, TMP_DB_REDIS_DATABASE_INDEX, TMP_DB_MONGODB_COLLECTION, TMP_DB_SQL_TABLE, TMP_EXCEPTION_TYPE, TMP_EXCEPTION_MESSAGE, TMP_EXCEPTION_STACKTRACE, TMP_EXCEPTION_ESCAPED, TMP_FAAS_TRIGGER, TMP_FAAS_EXECUTION, TMP_FAAS_DOCUMENT_COLLECTION, TMP_FAAS_DOCUMENT_OPERATION, TMP_FAAS_DOCUMENT_TIME, TMP_FAAS_DOCUMENT_NAME, TMP_FAAS_TIME, TMP_FAAS_CRON, TMP_FAAS_COLDSTART, TMP_FAAS_INVOKED_NAME, TMP_FAAS_INVOKED_PROVIDER, TMP_FAAS_INVOKED_REGION, TMP_NET_TRANSPORT, TMP_NET_PEER_IP, TMP_NET_PEER_PORT, TMP_NET_PEER_NAME, TMP_NET_HOST_IP, TMP_NET_HOST_PORT, TMP_NET_HOST_NAME, TMP_NET_HOST_CONNECTION_TYPE, TMP_NET_HOST_CONNECTION_SUBTYPE, TMP_NET_HOST_CARRIER_NAME, TMP_NET_HOST_CARRIER_MCC, TMP_NET_HOST_CARRIER_MNC, TMP_NET_HOST_CARRIER_ICC, TMP_PEER_SERVICE, TMP_ENDUSER_ID, TMP_ENDUSER_ROLE, TMP_ENDUSER_SCOPE, TMP_THREAD_ID, TMP_THREAD_NAME, TMP_CODE_FUNCTION, TMP_CODE_NAMESPACE, TMP_CODE_FILEPATH, TMP_CODE_LINENO, TMP_HTTP_METHOD, TMP_HTTP_URL, TMP_HTTP_TARGET, TMP_HTTP_HOST, TMP_HTTP_SCHEME, TMP_HTTP_STATUS_CODE, TMP_HTTP_FLAVOR, TMP_HTTP_USER_AGENT, TMP_HTTP_REQUEST_CONTENT_LENGTH, TMP_HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED, TMP_HTTP_RESPONSE_CONTENT_LENGTH, TMP_HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED, TMP_HTTP_SERVER_NAME, TMP_HTTP_ROUTE, TMP_HTTP_CLIENT_IP, TMP_AWS_DYNAMODB_TABLE_NAMES, TMP_AWS_DYNAMODB_CONSUMED_CAPACITY, TMP_AWS_DYNAMODB_ITEM_COLLECTION_METRICS, TMP_AWS_DYNAMODB_PROVISIONED_READ_CAPACITY, TMP_AWS_DYNAMODB_PROVISIONED_WRITE_CAPACITY, TMP_AWS_DYNAMODB_CONSISTENT_READ, TMP_AWS_DYNAMODB_PROJECTION, TMP_AWS_DYNAMODB_LIMIT, TMP_AWS_DYNAMODB_ATTRIBUTES_TO_GET, TMP_AWS_DYNAMODB_INDEX_NAME, TMP_AWS_DYNAMODB_SELECT, TMP_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEXES, TMP_AWS_DYNAMODB_LOCAL_SECONDARY_INDEXES, TMP_AWS_DYNAMODB_EXCLUSIVE_START_TABLE, TMP_AWS_DYNAMODB_TABLE_COUNT, TMP_AWS_DYNAMODB_SCAN_FORWARD, TMP_AWS_DYNAMODB_SEGMENT, TMP_AWS_DYNAMODB_TOTAL_SEGMENTS, TMP_AWS_DYNAMODB_COUNT, TMP_AWS_DYNAMODB_SCANNED_COUNT, TMP_AWS_DYNAMODB_ATTRIBUTE_DEFINITIONS, TMP_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEX_UPDATES, TMP_MESSAGING_SYSTEM, TMP_MESSAGING_DESTINATION, TMP_MESSAGING_DESTINATION_KIND, TMP_MESSAGING_TEMP_DESTINATION, TMP_MESSAGING_PROTOCOL, TMP_MESSAGING_PROTOCOL_VERSION, TMP_MESSAGING_URL, TMP_MESSAGING_MESSAGE_ID, TMP_MESSAGING_CONVERSATION_ID, TMP_MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES, TMP_MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES, TMP_MESSAGING_OPERATION, TMP_MESSAGING_CONSUMER_ID, TMP_MESSAGING_RABBITMQ_ROUTING_KEY, TMP_MESSAGING_KAFKA_MESSAGE_KEY, TMP_MESSAGING_KAFKA_CONSUMER_GROUP, TMP_MESSAGING_KAFKA_CLIENT_ID, TMP_MESSAGING_KAFKA_PARTITION, TMP_MESSAGING_KAFKA_TOMBSTONE, TMP_RPC_SYSTEM, TMP_RPC_SERVICE, TMP_RPC_METHOD, TMP_RPC_GRPC_STATUS_CODE, TMP_RPC_JSONRPC_VERSION, TMP_RPC_JSONRPC_REQUEST_ID, TMP_RPC_JSONRPC_ERROR_CODE, TMP_RPC_JSONRPC_ERROR_MESSAGE, TMP_MESSAGE_TYPE, TMP_MESSAGE_ID, TMP_MESSAGE_COMPRESSED_SIZE, TMP_MESSAGE_UNCOMPRESSED_SIZE]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for DbSystemValues enum definition
	 *
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_DBSYSTEMVALUES_OTHER_SQL = 'other_sql';
	var TMP_DBSYSTEMVALUES_MSSQL = 'mssql';
	var TMP_DBSYSTEMVALUES_MYSQL = 'mysql';
	var TMP_DBSYSTEMVALUES_ORACLE = 'oracle';
	var TMP_DBSYSTEMVALUES_DB2 = 'db2';
	var TMP_DBSYSTEMVALUES_POSTGRESQL = 'postgresql';
	var TMP_DBSYSTEMVALUES_REDSHIFT = 'redshift';
	var TMP_DBSYSTEMVALUES_HIVE = 'hive';
	var TMP_DBSYSTEMVALUES_CLOUDSCAPE = 'cloudscape';
	var TMP_DBSYSTEMVALUES_HSQLDB = 'hsqldb';
	var TMP_DBSYSTEMVALUES_PROGRESS = 'progress';
	var TMP_DBSYSTEMVALUES_MAXDB = 'maxdb';
	var TMP_DBSYSTEMVALUES_HANADB = 'hanadb';
	var TMP_DBSYSTEMVALUES_INGRES = 'ingres';
	var TMP_DBSYSTEMVALUES_FIRSTSQL = 'firstsql';
	var TMP_DBSYSTEMVALUES_EDB = 'edb';
	var TMP_DBSYSTEMVALUES_CACHE = 'cache';
	var TMP_DBSYSTEMVALUES_ADABAS = 'adabas';
	var TMP_DBSYSTEMVALUES_FIREBIRD = 'firebird';
	var TMP_DBSYSTEMVALUES_DERBY = 'derby';
	var TMP_DBSYSTEMVALUES_FILEMAKER = 'filemaker';
	var TMP_DBSYSTEMVALUES_INFORMIX = 'informix';
	var TMP_DBSYSTEMVALUES_INSTANTDB = 'instantdb';
	var TMP_DBSYSTEMVALUES_INTERBASE = 'interbase';
	var TMP_DBSYSTEMVALUES_MARIADB = 'mariadb';
	var TMP_DBSYSTEMVALUES_NETEZZA = 'netezza';
	var TMP_DBSYSTEMVALUES_PERVASIVE = 'pervasive';
	var TMP_DBSYSTEMVALUES_POINTBASE = 'pointbase';
	var TMP_DBSYSTEMVALUES_SQLITE = 'sqlite';
	var TMP_DBSYSTEMVALUES_SYBASE = 'sybase';
	var TMP_DBSYSTEMVALUES_TERADATA = 'teradata';
	var TMP_DBSYSTEMVALUES_VERTICA = 'vertica';
	var TMP_DBSYSTEMVALUES_H2 = 'h2';
	var TMP_DBSYSTEMVALUES_COLDFUSION = 'coldfusion';
	var TMP_DBSYSTEMVALUES_CASSANDRA = 'cassandra';
	var TMP_DBSYSTEMVALUES_HBASE = 'hbase';
	var TMP_DBSYSTEMVALUES_MONGODB = 'mongodb';
	var TMP_DBSYSTEMVALUES_REDIS = 'redis';
	var TMP_DBSYSTEMVALUES_COUCHBASE = 'couchbase';
	var TMP_DBSYSTEMVALUES_COUCHDB = 'couchdb';
	var TMP_DBSYSTEMVALUES_COSMOSDB = 'cosmosdb';
	var TMP_DBSYSTEMVALUES_DYNAMODB = 'dynamodb';
	var TMP_DBSYSTEMVALUES_NEO4J = 'neo4j';
	var TMP_DBSYSTEMVALUES_GEODE = 'geode';
	var TMP_DBSYSTEMVALUES_ELASTICSEARCH = 'elasticsearch';
	var TMP_DBSYSTEMVALUES_MEMCACHED = 'memcached';
	var TMP_DBSYSTEMVALUES_COCKROACHDB = 'cockroachdb';
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_OTHER_SQL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_OTHER_SQL = TMP_DBSYSTEMVALUES_OTHER_SQL;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_MSSQL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_MSSQL = TMP_DBSYSTEMVALUES_MSSQL;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_MYSQL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_MYSQL = TMP_DBSYSTEMVALUES_MYSQL;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_ORACLE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_ORACLE = TMP_DBSYSTEMVALUES_ORACLE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_DB2 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_DB2 = TMP_DBSYSTEMVALUES_DB2;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_POSTGRESQL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_POSTGRESQL = TMP_DBSYSTEMVALUES_POSTGRESQL;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_REDSHIFT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_REDSHIFT = TMP_DBSYSTEMVALUES_REDSHIFT;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_HIVE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_HIVE = TMP_DBSYSTEMVALUES_HIVE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_CLOUDSCAPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_CLOUDSCAPE = TMP_DBSYSTEMVALUES_CLOUDSCAPE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_HSQLDB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_HSQLDB = TMP_DBSYSTEMVALUES_HSQLDB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_PROGRESS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_PROGRESS = TMP_DBSYSTEMVALUES_PROGRESS;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_MAXDB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_MAXDB = TMP_DBSYSTEMVALUES_MAXDB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_HANADB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_HANADB = TMP_DBSYSTEMVALUES_HANADB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_INGRES in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_INGRES = TMP_DBSYSTEMVALUES_INGRES;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_FIRSTSQL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_FIRSTSQL = TMP_DBSYSTEMVALUES_FIRSTSQL;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_EDB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_EDB = TMP_DBSYSTEMVALUES_EDB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_CACHE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_CACHE = TMP_DBSYSTEMVALUES_CACHE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_ADABAS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_ADABAS = TMP_DBSYSTEMVALUES_ADABAS;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_FIREBIRD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_FIREBIRD = TMP_DBSYSTEMVALUES_FIREBIRD;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_DERBY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_DERBY = TMP_DBSYSTEMVALUES_DERBY;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_FILEMAKER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_FILEMAKER = TMP_DBSYSTEMVALUES_FILEMAKER;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_INFORMIX in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_INFORMIX = TMP_DBSYSTEMVALUES_INFORMIX;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_INSTANTDB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_INSTANTDB = TMP_DBSYSTEMVALUES_INSTANTDB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_INTERBASE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_INTERBASE = TMP_DBSYSTEMVALUES_INTERBASE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_MARIADB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_MARIADB = TMP_DBSYSTEMVALUES_MARIADB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_NETEZZA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_NETEZZA = TMP_DBSYSTEMVALUES_NETEZZA;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_PERVASIVE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_PERVASIVE = TMP_DBSYSTEMVALUES_PERVASIVE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_POINTBASE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_POINTBASE = TMP_DBSYSTEMVALUES_POINTBASE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_SQLITE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_SQLITE = TMP_DBSYSTEMVALUES_SQLITE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_SYBASE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_SYBASE = TMP_DBSYSTEMVALUES_SYBASE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_TERADATA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_TERADATA = TMP_DBSYSTEMVALUES_TERADATA;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_VERTICA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_VERTICA = TMP_DBSYSTEMVALUES_VERTICA;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_H2 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_H2 = TMP_DBSYSTEMVALUES_H2;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_COLDFUSION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_COLDFUSION = TMP_DBSYSTEMVALUES_COLDFUSION;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_CASSANDRA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_CASSANDRA = TMP_DBSYSTEMVALUES_CASSANDRA;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_HBASE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_HBASE = TMP_DBSYSTEMVALUES_HBASE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_MONGODB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_MONGODB = TMP_DBSYSTEMVALUES_MONGODB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_REDIS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_REDIS = TMP_DBSYSTEMVALUES_REDIS;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_COUCHBASE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_COUCHBASE = TMP_DBSYSTEMVALUES_COUCHBASE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_COUCHDB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_COUCHDB = TMP_DBSYSTEMVALUES_COUCHDB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_COSMOSDB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_COSMOSDB = TMP_DBSYSTEMVALUES_COSMOSDB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_DYNAMODB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_DYNAMODB = TMP_DBSYSTEMVALUES_DYNAMODB;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_NEO4J in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_NEO4J = TMP_DBSYSTEMVALUES_NEO4J;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_GEODE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_GEODE = TMP_DBSYSTEMVALUES_GEODE;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_ELASTICSEARCH in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_ELASTICSEARCH = TMP_DBSYSTEMVALUES_ELASTICSEARCH;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_MEMCACHED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_MEMCACHED = TMP_DBSYSTEMVALUES_MEMCACHED;
	/**
	 * An identifier for the database management system (DBMS) product being used. See below for a list of well-known identifiers.
	 *
	 * @deprecated Use DB_SYSTEM_VALUE_COCKROACHDB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBSYSTEMVALUES_COCKROACHDB = TMP_DBSYSTEMVALUES_COCKROACHDB;
	/**
	 * The constant map of values for DbSystemValues.
	 * @deprecated Use the DBSYSTEMVALUES_XXXXX constants rather than the DbSystemValues.XXXXX for bundle minification.
	 */
	var DbSystemValues = /*#__PURE__*/createConstMap([TMP_DBSYSTEMVALUES_OTHER_SQL, TMP_DBSYSTEMVALUES_MSSQL, TMP_DBSYSTEMVALUES_MYSQL, TMP_DBSYSTEMVALUES_ORACLE, TMP_DBSYSTEMVALUES_DB2, TMP_DBSYSTEMVALUES_POSTGRESQL, TMP_DBSYSTEMVALUES_REDSHIFT, TMP_DBSYSTEMVALUES_HIVE, TMP_DBSYSTEMVALUES_CLOUDSCAPE, TMP_DBSYSTEMVALUES_HSQLDB, TMP_DBSYSTEMVALUES_PROGRESS, TMP_DBSYSTEMVALUES_MAXDB, TMP_DBSYSTEMVALUES_HANADB, TMP_DBSYSTEMVALUES_INGRES, TMP_DBSYSTEMVALUES_FIRSTSQL, TMP_DBSYSTEMVALUES_EDB, TMP_DBSYSTEMVALUES_CACHE, TMP_DBSYSTEMVALUES_ADABAS, TMP_DBSYSTEMVALUES_FIREBIRD, TMP_DBSYSTEMVALUES_DERBY, TMP_DBSYSTEMVALUES_FILEMAKER, TMP_DBSYSTEMVALUES_INFORMIX, TMP_DBSYSTEMVALUES_INSTANTDB, TMP_DBSYSTEMVALUES_INTERBASE, TMP_DBSYSTEMVALUES_MARIADB, TMP_DBSYSTEMVALUES_NETEZZA, TMP_DBSYSTEMVALUES_PERVASIVE, TMP_DBSYSTEMVALUES_POINTBASE, TMP_DBSYSTEMVALUES_SQLITE, TMP_DBSYSTEMVALUES_SYBASE, TMP_DBSYSTEMVALUES_TERADATA, TMP_DBSYSTEMVALUES_VERTICA, TMP_DBSYSTEMVALUES_H2, TMP_DBSYSTEMVALUES_COLDFUSION, TMP_DBSYSTEMVALUES_CASSANDRA, TMP_DBSYSTEMVALUES_HBASE, TMP_DBSYSTEMVALUES_MONGODB, TMP_DBSYSTEMVALUES_REDIS, TMP_DBSYSTEMVALUES_COUCHBASE, TMP_DBSYSTEMVALUES_COUCHDB, TMP_DBSYSTEMVALUES_COSMOSDB, TMP_DBSYSTEMVALUES_DYNAMODB, TMP_DBSYSTEMVALUES_NEO4J, TMP_DBSYSTEMVALUES_GEODE, TMP_DBSYSTEMVALUES_ELASTICSEARCH, TMP_DBSYSTEMVALUES_MEMCACHED, TMP_DBSYSTEMVALUES_COCKROACHDB]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for DbCassandraConsistencyLevelValues enum definition
	 *
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ALL = 'all';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_EACH_QUORUM = 'each_quorum';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_QUORUM = 'quorum';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_QUORUM = 'local_quorum';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ONE = 'one';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_TWO = 'two';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_THREE = 'three';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_ONE = 'local_one';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ANY = 'any';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_SERIAL = 'serial';
	var TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_SERIAL = 'local_serial';
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_ALL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_ALL = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ALL;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_EACH_QUORUM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_EACH_QUORUM = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_EACH_QUORUM;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_QUORUM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_QUORUM = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_QUORUM;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_LOCAL_QUORUM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_QUORUM = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_QUORUM;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_ONE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_ONE = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ONE;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_TWO in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_TWO = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_TWO;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_THREE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_THREE = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_THREE;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_LOCAL_ONE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_ONE = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_ONE;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_ANY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_ANY = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ANY;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_SERIAL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_SERIAL = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_SERIAL;
	/**
	 * The consistency level of the query. Based on consistency values from [CQL](https://docs.datastax.com/en/cassandra-oss/3.0/cassandra/dml/dmlConfigConsistency.html).
	 *
	 * @deprecated Use DB_CASSANDRA_CONSISTENCY_LEVEL_VALUE_LOCAL_SERIAL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_SERIAL = TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_SERIAL;
	/**
	 * The constant map of values for DbCassandraConsistencyLevelValues.
	 * @deprecated Use the DBCASSANDRACONSISTENCYLEVELVALUES_XXXXX constants rather than the DbCassandraConsistencyLevelValues.XXXXX for bundle minification.
	 */
	var DbCassandraConsistencyLevelValues = /*#__PURE__*/createConstMap([TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ALL, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_EACH_QUORUM, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_QUORUM, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_QUORUM, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ONE, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_TWO, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_THREE, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_ONE, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_ANY, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_SERIAL, TMP_DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_SERIAL]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for FaasTriggerValues enum definition
	 *
	 * Type of the trigger on which the function is executed.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_FAASTRIGGERVALUES_DATASOURCE = 'datasource';
	var TMP_FAASTRIGGERVALUES_HTTP = 'http';
	var TMP_FAASTRIGGERVALUES_PUBSUB = 'pubsub';
	var TMP_FAASTRIGGERVALUES_TIMER = 'timer';
	var TMP_FAASTRIGGERVALUES_OTHER = 'other';
	/**
	 * Type of the trigger on which the function is executed.
	 *
	 * @deprecated Use FAAS_TRIGGER_VALUE_DATASOURCE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASTRIGGERVALUES_DATASOURCE = TMP_FAASTRIGGERVALUES_DATASOURCE;
	/**
	 * Type of the trigger on which the function is executed.
	 *
	 * @deprecated Use FAAS_TRIGGER_VALUE_HTTP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASTRIGGERVALUES_HTTP = TMP_FAASTRIGGERVALUES_HTTP;
	/**
	 * Type of the trigger on which the function is executed.
	 *
	 * @deprecated Use FAAS_TRIGGER_VALUE_PUBSUB in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASTRIGGERVALUES_PUBSUB = TMP_FAASTRIGGERVALUES_PUBSUB;
	/**
	 * Type of the trigger on which the function is executed.
	 *
	 * @deprecated Use FAAS_TRIGGER_VALUE_TIMER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASTRIGGERVALUES_TIMER = TMP_FAASTRIGGERVALUES_TIMER;
	/**
	 * Type of the trigger on which the function is executed.
	 *
	 * @deprecated Use FAAS_TRIGGER_VALUE_OTHER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASTRIGGERVALUES_OTHER = TMP_FAASTRIGGERVALUES_OTHER;
	/**
	 * The constant map of values for FaasTriggerValues.
	 * @deprecated Use the FAASTRIGGERVALUES_XXXXX constants rather than the FaasTriggerValues.XXXXX for bundle minification.
	 */
	var FaasTriggerValues = /*#__PURE__*/createConstMap([TMP_FAASTRIGGERVALUES_DATASOURCE, TMP_FAASTRIGGERVALUES_HTTP, TMP_FAASTRIGGERVALUES_PUBSUB, TMP_FAASTRIGGERVALUES_TIMER, TMP_FAASTRIGGERVALUES_OTHER]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for FaasDocumentOperationValues enum definition
	 *
	 * Describes the type of the operation that was performed on the data.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_FAASDOCUMENTOPERATIONVALUES_INSERT = 'insert';
	var TMP_FAASDOCUMENTOPERATIONVALUES_EDIT = 'edit';
	var TMP_FAASDOCUMENTOPERATIONVALUES_DELETE = 'delete';
	/**
	 * Describes the type of the operation that was performed on the data.
	 *
	 * @deprecated Use FAAS_DOCUMENT_OPERATION_VALUE_INSERT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASDOCUMENTOPERATIONVALUES_INSERT = TMP_FAASDOCUMENTOPERATIONVALUES_INSERT;
	/**
	 * Describes the type of the operation that was performed on the data.
	 *
	 * @deprecated Use FAAS_DOCUMENT_OPERATION_VALUE_EDIT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASDOCUMENTOPERATIONVALUES_EDIT = TMP_FAASDOCUMENTOPERATIONVALUES_EDIT;
	/**
	 * Describes the type of the operation that was performed on the data.
	 *
	 * @deprecated Use FAAS_DOCUMENT_OPERATION_VALUE_DELETE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASDOCUMENTOPERATIONVALUES_DELETE = TMP_FAASDOCUMENTOPERATIONVALUES_DELETE;
	/**
	 * The constant map of values for FaasDocumentOperationValues.
	 * @deprecated Use the FAASDOCUMENTOPERATIONVALUES_XXXXX constants rather than the FaasDocumentOperationValues.XXXXX for bundle minification.
	 */
	var FaasDocumentOperationValues = /*#__PURE__*/createConstMap([TMP_FAASDOCUMENTOPERATIONVALUES_INSERT, TMP_FAASDOCUMENTOPERATIONVALUES_EDIT, TMP_FAASDOCUMENTOPERATIONVALUES_DELETE]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for FaasInvokedProviderValues enum definition
	 *
	 * The cloud provider of the invoked function.
	 *
	 * Note: SHOULD be equal to the `cloud.provider` resource attribute of the invoked function.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_FAASINVOKEDPROVIDERVALUES_ALIBABA_CLOUD = 'alibaba_cloud';
	var TMP_FAASINVOKEDPROVIDERVALUES_AWS = 'aws';
	var TMP_FAASINVOKEDPROVIDERVALUES_AZURE = 'azure';
	var TMP_FAASINVOKEDPROVIDERVALUES_GCP = 'gcp';
	/**
	 * The cloud provider of the invoked function.
	 *
	 * Note: SHOULD be equal to the `cloud.provider` resource attribute of the invoked function.
	 *
	 * @deprecated Use FAAS_INVOKED_PROVIDER_VALUE_ALIBABA_CLOUD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASINVOKEDPROVIDERVALUES_ALIBABA_CLOUD = TMP_FAASINVOKEDPROVIDERVALUES_ALIBABA_CLOUD;
	/**
	 * The cloud provider of the invoked function.
	 *
	 * Note: SHOULD be equal to the `cloud.provider` resource attribute of the invoked function.
	 *
	 * @deprecated Use FAAS_INVOKED_PROVIDER_VALUE_AWS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASINVOKEDPROVIDERVALUES_AWS = TMP_FAASINVOKEDPROVIDERVALUES_AWS;
	/**
	 * The cloud provider of the invoked function.
	 *
	 * Note: SHOULD be equal to the `cloud.provider` resource attribute of the invoked function.
	 *
	 * @deprecated Use FAAS_INVOKED_PROVIDER_VALUE_AZURE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASINVOKEDPROVIDERVALUES_AZURE = TMP_FAASINVOKEDPROVIDERVALUES_AZURE;
	/**
	 * The cloud provider of the invoked function.
	 *
	 * Note: SHOULD be equal to the `cloud.provider` resource attribute of the invoked function.
	 *
	 * @deprecated Use FAAS_INVOKED_PROVIDER_VALUE_GCP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var FAASINVOKEDPROVIDERVALUES_GCP = TMP_FAASINVOKEDPROVIDERVALUES_GCP;
	/**
	 * The constant map of values for FaasInvokedProviderValues.
	 * @deprecated Use the FAASINVOKEDPROVIDERVALUES_XXXXX constants rather than the FaasInvokedProviderValues.XXXXX for bundle minification.
	 */
	var FaasInvokedProviderValues = /*#__PURE__*/createConstMap([TMP_FAASINVOKEDPROVIDERVALUES_ALIBABA_CLOUD, TMP_FAASINVOKEDPROVIDERVALUES_AWS, TMP_FAASINVOKEDPROVIDERVALUES_AZURE, TMP_FAASINVOKEDPROVIDERVALUES_GCP]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for NetTransportValues enum definition
	 *
	 * Transport protocol used. See note below.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_NETTRANSPORTVALUES_IP_TCP = 'ip_tcp';
	var TMP_NETTRANSPORTVALUES_IP_UDP = 'ip_udp';
	var TMP_NETTRANSPORTVALUES_IP = 'ip';
	var TMP_NETTRANSPORTVALUES_UNIX = 'unix';
	var TMP_NETTRANSPORTVALUES_PIPE = 'pipe';
	var TMP_NETTRANSPORTVALUES_INPROC = 'inproc';
	var TMP_NETTRANSPORTVALUES_OTHER = 'other';
	/**
	 * Transport protocol used. See note below.
	 *
	 * @deprecated Use NET_TRANSPORT_VALUE_IP_TCP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETTRANSPORTVALUES_IP_TCP = TMP_NETTRANSPORTVALUES_IP_TCP;
	/**
	 * Transport protocol used. See note below.
	 *
	 * @deprecated Use NET_TRANSPORT_VALUE_IP_UDP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETTRANSPORTVALUES_IP_UDP = TMP_NETTRANSPORTVALUES_IP_UDP;
	/**
	 * Transport protocol used. See note below.
	 *
	 * @deprecated Removed in v1.21.0.
	 */
	var NETTRANSPORTVALUES_IP = TMP_NETTRANSPORTVALUES_IP;
	/**
	 * Transport protocol used. See note below.
	 *
	 * @deprecated Removed in v1.21.0.
	 */
	var NETTRANSPORTVALUES_UNIX = TMP_NETTRANSPORTVALUES_UNIX;
	/**
	 * Transport protocol used. See note below.
	 *
	 * @deprecated Use NET_TRANSPORT_VALUE_PIPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETTRANSPORTVALUES_PIPE = TMP_NETTRANSPORTVALUES_PIPE;
	/**
	 * Transport protocol used. See note below.
	 *
	 * @deprecated Use NET_TRANSPORT_VALUE_INPROC in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETTRANSPORTVALUES_INPROC = TMP_NETTRANSPORTVALUES_INPROC;
	/**
	 * Transport protocol used. See note below.
	 *
	 * @deprecated Use NET_TRANSPORT_VALUE_OTHER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETTRANSPORTVALUES_OTHER = TMP_NETTRANSPORTVALUES_OTHER;
	/**
	 * The constant map of values for NetTransportValues.
	 * @deprecated Use the NETTRANSPORTVALUES_XXXXX constants rather than the NetTransportValues.XXXXX for bundle minification.
	 */
	var NetTransportValues = /*#__PURE__*/createConstMap([TMP_NETTRANSPORTVALUES_IP_TCP, TMP_NETTRANSPORTVALUES_IP_UDP, TMP_NETTRANSPORTVALUES_IP, TMP_NETTRANSPORTVALUES_UNIX, TMP_NETTRANSPORTVALUES_PIPE, TMP_NETTRANSPORTVALUES_INPROC, TMP_NETTRANSPORTVALUES_OTHER]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for NetHostConnectionTypeValues enum definition
	 *
	 * The internet connection type currently being used by the host.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_NETHOSTCONNECTIONTYPEVALUES_WIFI = 'wifi';
	var TMP_NETHOSTCONNECTIONTYPEVALUES_WIRED = 'wired';
	var TMP_NETHOSTCONNECTIONTYPEVALUES_CELL = 'cell';
	var TMP_NETHOSTCONNECTIONTYPEVALUES_UNAVAILABLE = 'unavailable';
	var TMP_NETHOSTCONNECTIONTYPEVALUES_UNKNOWN = 'unknown';
	/**
	 * The internet connection type currently being used by the host.
	 *
	 * @deprecated Use NETWORK_CONNECTION_TYPE_VALUE_WIFI in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONTYPEVALUES_WIFI = TMP_NETHOSTCONNECTIONTYPEVALUES_WIFI;
	/**
	 * The internet connection type currently being used by the host.
	 *
	 * @deprecated Use NETWORK_CONNECTION_TYPE_VALUE_WIRED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONTYPEVALUES_WIRED = TMP_NETHOSTCONNECTIONTYPEVALUES_WIRED;
	/**
	 * The internet connection type currently being used by the host.
	 *
	 * @deprecated Use NETWORK_CONNECTION_TYPE_VALUE_CELL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONTYPEVALUES_CELL = TMP_NETHOSTCONNECTIONTYPEVALUES_CELL;
	/**
	 * The internet connection type currently being used by the host.
	 *
	 * @deprecated Use NETWORK_CONNECTION_TYPE_VALUE_UNAVAILABLE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONTYPEVALUES_UNAVAILABLE = TMP_NETHOSTCONNECTIONTYPEVALUES_UNAVAILABLE;
	/**
	 * The internet connection type currently being used by the host.
	 *
	 * @deprecated Use NETWORK_CONNECTION_TYPE_VALUE_UNKNOWN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONTYPEVALUES_UNKNOWN = TMP_NETHOSTCONNECTIONTYPEVALUES_UNKNOWN;
	/**
	 * The constant map of values for NetHostConnectionTypeValues.
	 * @deprecated Use the NETHOSTCONNECTIONTYPEVALUES_XXXXX constants rather than the NetHostConnectionTypeValues.XXXXX for bundle minification.
	 */
	var NetHostConnectionTypeValues = /*#__PURE__*/createConstMap([TMP_NETHOSTCONNECTIONTYPEVALUES_WIFI, TMP_NETHOSTCONNECTIONTYPEVALUES_WIRED, TMP_NETHOSTCONNECTIONTYPEVALUES_CELL, TMP_NETHOSTCONNECTIONTYPEVALUES_UNAVAILABLE, TMP_NETHOSTCONNECTIONTYPEVALUES_UNKNOWN]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for NetHostConnectionSubtypeValues enum definition
	 *
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_GPRS = 'gprs';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EDGE = 'edge';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_UMTS = 'umts';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_CDMA = 'cdma';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_0 = 'evdo_0';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_A = 'evdo_a';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_CDMA2000_1XRTT = 'cdma2000_1xrtt';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSDPA = 'hsdpa';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSUPA = 'hsupa';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSPA = 'hspa';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_IDEN = 'iden';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_B = 'evdo_b';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_LTE = 'lte';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EHRPD = 'ehrpd';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSPAP = 'hspap';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_GSM = 'gsm';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_TD_SCDMA = 'td_scdma';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_IWLAN = 'iwlan';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_NR = 'nr';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_NRNSA = 'nrnsa';
	var TMP_NETHOSTCONNECTIONSUBTYPEVALUES_LTE_CA = 'lte_ca';
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_GPRS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_GPRS = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_GPRS;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_EDGE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_EDGE = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EDGE;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_UMTS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_UMTS = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_UMTS;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_CDMA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_CDMA = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_CDMA;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_EVDO_0 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_0 = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_0;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_EVDO_A in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_A = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_A;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_CDMA2000_1XRTT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_CDMA2000_1XRTT = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_CDMA2000_1XRTT;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_HSDPA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_HSDPA = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSDPA;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_HSUPA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_HSUPA = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSUPA;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_HSPA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_HSPA = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSPA;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_IDEN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_IDEN = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_IDEN;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_EVDO_B in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_B = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_B;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_LTE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_LTE = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_LTE;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_EHRPD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_EHRPD = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EHRPD;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_HSPAP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_HSPAP = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSPAP;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_GSM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_GSM = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_GSM;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_TD_SCDMA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_TD_SCDMA = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_TD_SCDMA;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_IWLAN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_IWLAN = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_IWLAN;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_NR in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_NR = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_NR;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_NRNSA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_NRNSA = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_NRNSA;
	/**
	 * This describes more details regarding the connection.type. It may be the type of cell technology connection, but it could be used for describing details about a wifi connection.
	 *
	 * @deprecated Use NETWORK_CONNECTION_SUBTYPE_VALUE_LTE_CA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var NETHOSTCONNECTIONSUBTYPEVALUES_LTE_CA = TMP_NETHOSTCONNECTIONSUBTYPEVALUES_LTE_CA;
	/**
	 * The constant map of values for NetHostConnectionSubtypeValues.
	 * @deprecated Use the NETHOSTCONNECTIONSUBTYPEVALUES_XXXXX constants rather than the NetHostConnectionSubtypeValues.XXXXX for bundle minification.
	 */
	var NetHostConnectionSubtypeValues = /*#__PURE__*/createConstMap([TMP_NETHOSTCONNECTIONSUBTYPEVALUES_GPRS, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EDGE, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_UMTS, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_CDMA, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_0, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_A, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_CDMA2000_1XRTT, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSDPA, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSUPA, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSPA, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_IDEN, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_B, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_LTE, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_EHRPD, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_HSPAP, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_GSM, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_TD_SCDMA, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_IWLAN, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_NR, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_NRNSA, TMP_NETHOSTCONNECTIONSUBTYPEVALUES_LTE_CA]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for HttpFlavorValues enum definition
	 *
	 * Kind of HTTP protocol used.
	 *
	 * Note: If `net.transport` is not specified, it can be assumed to be `IP.TCP` except if `http.flavor` is `QUIC`, in which case `IP.UDP` is assumed.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_HTTPFLAVORVALUES_HTTP_1_0 = '1.0';
	var TMP_HTTPFLAVORVALUES_HTTP_1_1 = '1.1';
	var TMP_HTTPFLAVORVALUES_HTTP_2_0 = '2.0';
	var TMP_HTTPFLAVORVALUES_SPDY = 'SPDY';
	var TMP_HTTPFLAVORVALUES_QUIC = 'QUIC';
	/**
	 * Kind of HTTP protocol used.
	 *
	 * Note: If `net.transport` is not specified, it can be assumed to be `IP.TCP` except if `http.flavor` is `QUIC`, in which case `IP.UDP` is assumed.
	 *
	 * @deprecated Use HTTP_FLAVOR_VALUE_HTTP_1_0 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HTTPFLAVORVALUES_HTTP_1_0 = TMP_HTTPFLAVORVALUES_HTTP_1_0;
	/**
	 * Kind of HTTP protocol used.
	 *
	 * Note: If `net.transport` is not specified, it can be assumed to be `IP.TCP` except if `http.flavor` is `QUIC`, in which case `IP.UDP` is assumed.
	 *
	 * @deprecated Use HTTP_FLAVOR_VALUE_HTTP_1_1 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HTTPFLAVORVALUES_HTTP_1_1 = TMP_HTTPFLAVORVALUES_HTTP_1_1;
	/**
	 * Kind of HTTP protocol used.
	 *
	 * Note: If `net.transport` is not specified, it can be assumed to be `IP.TCP` except if `http.flavor` is `QUIC`, in which case `IP.UDP` is assumed.
	 *
	 * @deprecated Use HTTP_FLAVOR_VALUE_HTTP_2_0 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HTTPFLAVORVALUES_HTTP_2_0 = TMP_HTTPFLAVORVALUES_HTTP_2_0;
	/**
	 * Kind of HTTP protocol used.
	 *
	 * Note: If `net.transport` is not specified, it can be assumed to be `IP.TCP` except if `http.flavor` is `QUIC`, in which case `IP.UDP` is assumed.
	 *
	 * @deprecated Use HTTP_FLAVOR_VALUE_SPDY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HTTPFLAVORVALUES_SPDY = TMP_HTTPFLAVORVALUES_SPDY;
	/**
	 * Kind of HTTP protocol used.
	 *
	 * Note: If `net.transport` is not specified, it can be assumed to be `IP.TCP` except if `http.flavor` is `QUIC`, in which case `IP.UDP` is assumed.
	 *
	 * @deprecated Use HTTP_FLAVOR_VALUE_QUIC in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HTTPFLAVORVALUES_QUIC = TMP_HTTPFLAVORVALUES_QUIC;
	/**
	 * The constant map of values for HttpFlavorValues.
	 * @deprecated Use the HTTPFLAVORVALUES_XXXXX constants rather than the HttpFlavorValues.XXXXX for bundle minification.
	 */
	var HttpFlavorValues = {
	  HTTP_1_0: TMP_HTTPFLAVORVALUES_HTTP_1_0,
	  HTTP_1_1: TMP_HTTPFLAVORVALUES_HTTP_1_1,
	  HTTP_2_0: TMP_HTTPFLAVORVALUES_HTTP_2_0,
	  SPDY: TMP_HTTPFLAVORVALUES_SPDY,
	  QUIC: TMP_HTTPFLAVORVALUES_QUIC
	};
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for MessagingDestinationKindValues enum definition
	 *
	 * The kind of message destination.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_MESSAGINGDESTINATIONKINDVALUES_QUEUE = 'queue';
	var TMP_MESSAGINGDESTINATIONKINDVALUES_TOPIC = 'topic';
	/**
	 * The kind of message destination.
	 *
	 * @deprecated Removed in semconv v1.20.0.
	 */
	var MESSAGINGDESTINATIONKINDVALUES_QUEUE = TMP_MESSAGINGDESTINATIONKINDVALUES_QUEUE;
	/**
	 * The kind of message destination.
	 *
	 * @deprecated Removed in semconv v1.20.0.
	 */
	var MESSAGINGDESTINATIONKINDVALUES_TOPIC = TMP_MESSAGINGDESTINATIONKINDVALUES_TOPIC;
	/**
	 * The constant map of values for MessagingDestinationKindValues.
	 * @deprecated Use the MESSAGINGDESTINATIONKINDVALUES_XXXXX constants rather than the MessagingDestinationKindValues.XXXXX for bundle minification.
	 */
	var MessagingDestinationKindValues = /*#__PURE__*/createConstMap([TMP_MESSAGINGDESTINATIONKINDVALUES_QUEUE, TMP_MESSAGINGDESTINATIONKINDVALUES_TOPIC]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for MessagingOperationValues enum definition
	 *
	 * A string identifying the kind of message consumption as defined in the [Operation names](#operation-names) section above. If the operation is &#34;send&#34;, this attribute MUST NOT be set, since the operation can be inferred from the span kind in that case.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_MESSAGINGOPERATIONVALUES_RECEIVE = 'receive';
	var TMP_MESSAGINGOPERATIONVALUES_PROCESS = 'process';
	/**
	 * A string identifying the kind of message consumption as defined in the [Operation names](#operation-names) section above. If the operation is &#34;send&#34;, this attribute MUST NOT be set, since the operation can be inferred from the span kind in that case.
	 *
	 * @deprecated Use MESSAGING_OPERATION_TYPE_VALUE_RECEIVE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var MESSAGINGOPERATIONVALUES_RECEIVE = TMP_MESSAGINGOPERATIONVALUES_RECEIVE;
	/**
	 * A string identifying the kind of message consumption as defined in the [Operation names](#operation-names) section above. If the operation is &#34;send&#34;, this attribute MUST NOT be set, since the operation can be inferred from the span kind in that case.
	 *
	 * @deprecated Use MESSAGING_OPERATION_TYPE_VALUE_PROCESS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var MESSAGINGOPERATIONVALUES_PROCESS = TMP_MESSAGINGOPERATIONVALUES_PROCESS;
	/**
	 * The constant map of values for MessagingOperationValues.
	 * @deprecated Use the MESSAGINGOPERATIONVALUES_XXXXX constants rather than the MessagingOperationValues.XXXXX for bundle minification.
	 */
	var MessagingOperationValues = /*#__PURE__*/createConstMap([TMP_MESSAGINGOPERATIONVALUES_RECEIVE, TMP_MESSAGINGOPERATIONVALUES_PROCESS]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for RpcGrpcStatusCodeValues enum definition
	 *
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_RPCGRPCSTATUSCODEVALUES_OK = 0;
	var TMP_RPCGRPCSTATUSCODEVALUES_CANCELLED = 1;
	var TMP_RPCGRPCSTATUSCODEVALUES_UNKNOWN = 2;
	var TMP_RPCGRPCSTATUSCODEVALUES_INVALID_ARGUMENT = 3;
	var TMP_RPCGRPCSTATUSCODEVALUES_DEADLINE_EXCEEDED = 4;
	var TMP_RPCGRPCSTATUSCODEVALUES_NOT_FOUND = 5;
	var TMP_RPCGRPCSTATUSCODEVALUES_ALREADY_EXISTS = 6;
	var TMP_RPCGRPCSTATUSCODEVALUES_PERMISSION_DENIED = 7;
	var TMP_RPCGRPCSTATUSCODEVALUES_RESOURCE_EXHAUSTED = 8;
	var TMP_RPCGRPCSTATUSCODEVALUES_FAILED_PRECONDITION = 9;
	var TMP_RPCGRPCSTATUSCODEVALUES_ABORTED = 10;
	var TMP_RPCGRPCSTATUSCODEVALUES_OUT_OF_RANGE = 11;
	var TMP_RPCGRPCSTATUSCODEVALUES_UNIMPLEMENTED = 12;
	var TMP_RPCGRPCSTATUSCODEVALUES_INTERNAL = 13;
	var TMP_RPCGRPCSTATUSCODEVALUES_UNAVAILABLE = 14;
	var TMP_RPCGRPCSTATUSCODEVALUES_DATA_LOSS = 15;
	var TMP_RPCGRPCSTATUSCODEVALUES_UNAUTHENTICATED = 16;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_OK in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_OK = TMP_RPCGRPCSTATUSCODEVALUES_OK;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_CANCELLED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_CANCELLED = TMP_RPCGRPCSTATUSCODEVALUES_CANCELLED;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_UNKNOWN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_UNKNOWN = TMP_RPCGRPCSTATUSCODEVALUES_UNKNOWN;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_INVALID_ARGUMENT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_INVALID_ARGUMENT = TMP_RPCGRPCSTATUSCODEVALUES_INVALID_ARGUMENT;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_DEADLINE_EXCEEDED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_DEADLINE_EXCEEDED = TMP_RPCGRPCSTATUSCODEVALUES_DEADLINE_EXCEEDED;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_NOT_FOUND in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_NOT_FOUND = TMP_RPCGRPCSTATUSCODEVALUES_NOT_FOUND;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_ALREADY_EXISTS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_ALREADY_EXISTS = TMP_RPCGRPCSTATUSCODEVALUES_ALREADY_EXISTS;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_PERMISSION_DENIED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_PERMISSION_DENIED = TMP_RPCGRPCSTATUSCODEVALUES_PERMISSION_DENIED;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_RESOURCE_EXHAUSTED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_RESOURCE_EXHAUSTED = TMP_RPCGRPCSTATUSCODEVALUES_RESOURCE_EXHAUSTED;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_FAILED_PRECONDITION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_FAILED_PRECONDITION = TMP_RPCGRPCSTATUSCODEVALUES_FAILED_PRECONDITION;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_ABORTED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_ABORTED = TMP_RPCGRPCSTATUSCODEVALUES_ABORTED;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_OUT_OF_RANGE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_OUT_OF_RANGE = TMP_RPCGRPCSTATUSCODEVALUES_OUT_OF_RANGE;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_UNIMPLEMENTED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_UNIMPLEMENTED = TMP_RPCGRPCSTATUSCODEVALUES_UNIMPLEMENTED;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_INTERNAL in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_INTERNAL = TMP_RPCGRPCSTATUSCODEVALUES_INTERNAL;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_UNAVAILABLE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_UNAVAILABLE = TMP_RPCGRPCSTATUSCODEVALUES_UNAVAILABLE;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_DATA_LOSS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_DATA_LOSS = TMP_RPCGRPCSTATUSCODEVALUES_DATA_LOSS;
	/**
	 * The [numeric status code](https://github.com/grpc/grpc/blob/v1.33.2/doc/statuscodes.md) of the gRPC request.
	 *
	 * @deprecated Use RPC_GRPC_STATUS_CODE_VALUE_UNAUTHENTICATED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var RPCGRPCSTATUSCODEVALUES_UNAUTHENTICATED = TMP_RPCGRPCSTATUSCODEVALUES_UNAUTHENTICATED;
	/**
	 * The constant map of values for RpcGrpcStatusCodeValues.
	 * @deprecated Use the RPCGRPCSTATUSCODEVALUES_XXXXX constants rather than the RpcGrpcStatusCodeValues.XXXXX for bundle minification.
	 */
	var RpcGrpcStatusCodeValues = {
	  OK: TMP_RPCGRPCSTATUSCODEVALUES_OK,
	  CANCELLED: TMP_RPCGRPCSTATUSCODEVALUES_CANCELLED,
	  UNKNOWN: TMP_RPCGRPCSTATUSCODEVALUES_UNKNOWN,
	  INVALID_ARGUMENT: TMP_RPCGRPCSTATUSCODEVALUES_INVALID_ARGUMENT,
	  DEADLINE_EXCEEDED: TMP_RPCGRPCSTATUSCODEVALUES_DEADLINE_EXCEEDED,
	  NOT_FOUND: TMP_RPCGRPCSTATUSCODEVALUES_NOT_FOUND,
	  ALREADY_EXISTS: TMP_RPCGRPCSTATUSCODEVALUES_ALREADY_EXISTS,
	  PERMISSION_DENIED: TMP_RPCGRPCSTATUSCODEVALUES_PERMISSION_DENIED,
	  RESOURCE_EXHAUSTED: TMP_RPCGRPCSTATUSCODEVALUES_RESOURCE_EXHAUSTED,
	  FAILED_PRECONDITION: TMP_RPCGRPCSTATUSCODEVALUES_FAILED_PRECONDITION,
	  ABORTED: TMP_RPCGRPCSTATUSCODEVALUES_ABORTED,
	  OUT_OF_RANGE: TMP_RPCGRPCSTATUSCODEVALUES_OUT_OF_RANGE,
	  UNIMPLEMENTED: TMP_RPCGRPCSTATUSCODEVALUES_UNIMPLEMENTED,
	  INTERNAL: TMP_RPCGRPCSTATUSCODEVALUES_INTERNAL,
	  UNAVAILABLE: TMP_RPCGRPCSTATUSCODEVALUES_UNAVAILABLE,
	  DATA_LOSS: TMP_RPCGRPCSTATUSCODEVALUES_DATA_LOSS,
	  UNAUTHENTICATED: TMP_RPCGRPCSTATUSCODEVALUES_UNAUTHENTICATED
	};
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for MessageTypeValues enum definition
	 *
	 * Whether this is a received or sent message.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_MESSAGETYPEVALUES_SENT = 'SENT';
	var TMP_MESSAGETYPEVALUES_RECEIVED = 'RECEIVED';
	/**
	 * Whether this is a received or sent message.
	 *
	 * @deprecated Use MESSAGE_TYPE_VALUE_SENT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var MESSAGETYPEVALUES_SENT = TMP_MESSAGETYPEVALUES_SENT;
	/**
	 * Whether this is a received or sent message.
	 *
	 * @deprecated Use MESSAGE_TYPE_VALUE_RECEIVED in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var MESSAGETYPEVALUES_RECEIVED = TMP_MESSAGETYPEVALUES_RECEIVED;
	/**
	 * The constant map of values for MessageTypeValues.
	 * @deprecated Use the MESSAGETYPEVALUES_XXXXX constants rather than the MessageTypeValues.XXXXX for bundle minification.
	 */
	var MessageTypeValues = /*#__PURE__*/createConstMap([TMP_MESSAGETYPEVALUES_SENT, TMP_MESSAGETYPEVALUES_RECEIVED]);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	//----------------------------------------------------------------------------------------------------------
	// DO NOT EDIT, this is an Auto-generated file from scripts/semconv/templates//templates/SemanticAttributes.ts.j2
	//----------------------------------------------------------------------------------------------------------
	//----------------------------------------------------------------------------------------------------------
	// Constant values for SemanticResourceAttributes
	//----------------------------------------------------------------------------------------------------------
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_CLOUD_PROVIDER = 'cloud.provider';
	var TMP_CLOUD_ACCOUNT_ID = 'cloud.account.id';
	var TMP_CLOUD_REGION = 'cloud.region';
	var TMP_CLOUD_AVAILABILITY_ZONE = 'cloud.availability_zone';
	var TMP_CLOUD_PLATFORM = 'cloud.platform';
	var TMP_AWS_ECS_CONTAINER_ARN = 'aws.ecs.container.arn';
	var TMP_AWS_ECS_CLUSTER_ARN = 'aws.ecs.cluster.arn';
	var TMP_AWS_ECS_LAUNCHTYPE = 'aws.ecs.launchtype';
	var TMP_AWS_ECS_TASK_ARN = 'aws.ecs.task.arn';
	var TMP_AWS_ECS_TASK_FAMILY = 'aws.ecs.task.family';
	var TMP_AWS_ECS_TASK_REVISION = 'aws.ecs.task.revision';
	var TMP_AWS_EKS_CLUSTER_ARN = 'aws.eks.cluster.arn';
	var TMP_AWS_LOG_GROUP_NAMES = 'aws.log.group.names';
	var TMP_AWS_LOG_GROUP_ARNS = 'aws.log.group.arns';
	var TMP_AWS_LOG_STREAM_NAMES = 'aws.log.stream.names';
	var TMP_AWS_LOG_STREAM_ARNS = 'aws.log.stream.arns';
	var TMP_CONTAINER_NAME = 'container.name';
	var TMP_CONTAINER_ID = 'container.id';
	var TMP_CONTAINER_RUNTIME = 'container.runtime';
	var TMP_CONTAINER_IMAGE_NAME = 'container.image.name';
	var TMP_CONTAINER_IMAGE_TAG = 'container.image.tag';
	var TMP_DEPLOYMENT_ENVIRONMENT = 'deployment.environment';
	var TMP_DEVICE_ID = 'device.id';
	var TMP_DEVICE_MODEL_IDENTIFIER = 'device.model.identifier';
	var TMP_DEVICE_MODEL_NAME = 'device.model.name';
	var TMP_FAAS_NAME = 'faas.name';
	var TMP_FAAS_ID = 'faas.id';
	var TMP_FAAS_VERSION = 'faas.version';
	var TMP_FAAS_INSTANCE = 'faas.instance';
	var TMP_FAAS_MAX_MEMORY = 'faas.max_memory';
	var TMP_HOST_ID = 'host.id';
	var TMP_HOST_NAME = 'host.name';
	var TMP_HOST_TYPE = 'host.type';
	var TMP_HOST_ARCH = 'host.arch';
	var TMP_HOST_IMAGE_NAME = 'host.image.name';
	var TMP_HOST_IMAGE_ID = 'host.image.id';
	var TMP_HOST_IMAGE_VERSION = 'host.image.version';
	var TMP_K8S_CLUSTER_NAME = 'k8s.cluster.name';
	var TMP_K8S_NODE_NAME = 'k8s.node.name';
	var TMP_K8S_NODE_UID = 'k8s.node.uid';
	var TMP_K8S_NAMESPACE_NAME = 'k8s.namespace.name';
	var TMP_K8S_POD_UID = 'k8s.pod.uid';
	var TMP_K8S_POD_NAME = 'k8s.pod.name';
	var TMP_K8S_CONTAINER_NAME = 'k8s.container.name';
	var TMP_K8S_REPLICASET_UID = 'k8s.replicaset.uid';
	var TMP_K8S_REPLICASET_NAME = 'k8s.replicaset.name';
	var TMP_K8S_DEPLOYMENT_UID = 'k8s.deployment.uid';
	var TMP_K8S_DEPLOYMENT_NAME = 'k8s.deployment.name';
	var TMP_K8S_STATEFULSET_UID = 'k8s.statefulset.uid';
	var TMP_K8S_STATEFULSET_NAME = 'k8s.statefulset.name';
	var TMP_K8S_DAEMONSET_UID = 'k8s.daemonset.uid';
	var TMP_K8S_DAEMONSET_NAME = 'k8s.daemonset.name';
	var TMP_K8S_JOB_UID = 'k8s.job.uid';
	var TMP_K8S_JOB_NAME = 'k8s.job.name';
	var TMP_K8S_CRONJOB_UID = 'k8s.cronjob.uid';
	var TMP_K8S_CRONJOB_NAME = 'k8s.cronjob.name';
	var TMP_OS_TYPE = 'os.type';
	var TMP_OS_DESCRIPTION = 'os.description';
	var TMP_OS_NAME = 'os.name';
	var TMP_OS_VERSION = 'os.version';
	var TMP_PROCESS_PID = 'process.pid';
	var TMP_PROCESS_EXECUTABLE_NAME = 'process.executable.name';
	var TMP_PROCESS_EXECUTABLE_PATH = 'process.executable.path';
	var TMP_PROCESS_COMMAND = 'process.command';
	var TMP_PROCESS_COMMAND_LINE = 'process.command_line';
	var TMP_PROCESS_COMMAND_ARGS = 'process.command_args';
	var TMP_PROCESS_OWNER = 'process.owner';
	var TMP_PROCESS_RUNTIME_NAME = 'process.runtime.name';
	var TMP_PROCESS_RUNTIME_VERSION = 'process.runtime.version';
	var TMP_PROCESS_RUNTIME_DESCRIPTION = 'process.runtime.description';
	var TMP_SERVICE_NAME = 'service.name';
	var TMP_SERVICE_NAMESPACE = 'service.namespace';
	var TMP_SERVICE_INSTANCE_ID = 'service.instance.id';
	var TMP_SERVICE_VERSION = 'service.version';
	var TMP_TELEMETRY_SDK_NAME = 'telemetry.sdk.name';
	var TMP_TELEMETRY_SDK_LANGUAGE = 'telemetry.sdk.language';
	var TMP_TELEMETRY_SDK_VERSION = 'telemetry.sdk.version';
	var TMP_TELEMETRY_AUTO_VERSION = 'telemetry.auto.version';
	var TMP_WEBENGINE_NAME = 'webengine.name';
	var TMP_WEBENGINE_VERSION = 'webengine.version';
	var TMP_WEBENGINE_DESCRIPTION = 'webengine.description';
	/**
	 * Name of the cloud provider.
	 *
	 * @deprecated Use ATTR_CLOUD_PROVIDER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CLOUD_PROVIDER = TMP_CLOUD_PROVIDER;
	/**
	 * The cloud account ID the resource is assigned to.
	 *
	 * @deprecated Use ATTR_CLOUD_ACCOUNT_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CLOUD_ACCOUNT_ID = TMP_CLOUD_ACCOUNT_ID;
	/**
	 * The geographical region the resource is running. Refer to your provider&#39;s docs to see the available regions, for example [Alibaba Cloud regions](https://www.alibabacloud.com/help/doc-detail/40654.htm), [AWS regions](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/), [Azure regions](https://azure.microsoft.com/en-us/global-infrastructure/geographies/), or [Google Cloud regions](https://cloud.google.com/about/locations).
	 *
	 * @deprecated Use ATTR_CLOUD_REGION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CLOUD_REGION = TMP_CLOUD_REGION;
	/**
	 * Cloud regions often have multiple, isolated locations known as zones to increase availability. Availability zone represents the zone where the resource is running.
	 *
	 * Note: Availability zones are called &#34;zones&#34; on Alibaba Cloud and Google Cloud.
	 *
	 * @deprecated Use ATTR_CLOUD_AVAILABILITY_ZONE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CLOUD_AVAILABILITY_ZONE = TMP_CLOUD_AVAILABILITY_ZONE;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use ATTR_CLOUD_PLATFORM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CLOUD_PLATFORM = TMP_CLOUD_PLATFORM;
	/**
	 * The Amazon Resource Name (ARN) of an [ECS container instance](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ECS_instances.html).
	 *
	 * @deprecated Use ATTR_AWS_ECS_CONTAINER_ARN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_ECS_CONTAINER_ARN = TMP_AWS_ECS_CONTAINER_ARN;
	/**
	 * The ARN of an [ECS cluster](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/clusters.html).
	 *
	 * @deprecated Use ATTR_AWS_ECS_CLUSTER_ARN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_ECS_CLUSTER_ARN = TMP_AWS_ECS_CLUSTER_ARN;
	/**
	 * The [launch type](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) for an ECS task.
	 *
	 * @deprecated Use ATTR_AWS_ECS_LAUNCHTYPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_ECS_LAUNCHTYPE = TMP_AWS_ECS_LAUNCHTYPE;
	/**
	 * The ARN of an [ECS task definition](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definitions.html).
	 *
	 * @deprecated Use ATTR_AWS_ECS_TASK_ARN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_ECS_TASK_ARN = TMP_AWS_ECS_TASK_ARN;
	/**
	 * The task definition family this task definition is a member of.
	 *
	 * @deprecated Use ATTR_AWS_ECS_TASK_FAMILY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_ECS_TASK_FAMILY = TMP_AWS_ECS_TASK_FAMILY;
	/**
	 * The revision for this task definition.
	 *
	 * @deprecated Use ATTR_AWS_ECS_TASK_REVISION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_ECS_TASK_REVISION = TMP_AWS_ECS_TASK_REVISION;
	/**
	 * The ARN of an EKS cluster.
	 *
	 * @deprecated Use ATTR_AWS_EKS_CLUSTER_ARN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_EKS_CLUSTER_ARN = TMP_AWS_EKS_CLUSTER_ARN;
	/**
	 * The name(s) of the AWS log group(s) an application is writing to.
	 *
	 * Note: Multiple log groups must be supported for cases like multi-container applications, where a single application has sidecar containers, and each write to their own log group.
	 *
	 * @deprecated Use ATTR_AWS_LOG_GROUP_NAMES in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_LOG_GROUP_NAMES = TMP_AWS_LOG_GROUP_NAMES;
	/**
	 * The Amazon Resource Name(s) (ARN) of the AWS log group(s).
	 *
	 * Note: See the [log group ARN format documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html#CWL_ARN_Format).
	 *
	 * @deprecated Use ATTR_AWS_LOG_GROUP_ARNS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_LOG_GROUP_ARNS = TMP_AWS_LOG_GROUP_ARNS;
	/**
	 * The name(s) of the AWS log stream(s) an application is writing to.
	 *
	 * @deprecated Use ATTR_AWS_LOG_STREAM_NAMES in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_LOG_STREAM_NAMES = TMP_AWS_LOG_STREAM_NAMES;
	/**
	 * The ARN(s) of the AWS log stream(s).
	 *
	 * Note: See the [log stream ARN format documentation](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/iam-access-control-overview-cwl.html#CWL_ARN_Format). One log group can contain several log streams, so these ARNs necessarily identify both a log group and a log stream.
	 *
	 * @deprecated Use ATTR_AWS_LOG_STREAM_ARNS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_AWS_LOG_STREAM_ARNS = TMP_AWS_LOG_STREAM_ARNS;
	/**
	 * Container name.
	 *
	 * @deprecated Use ATTR_CONTAINER_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CONTAINER_NAME = TMP_CONTAINER_NAME;
	/**
	 * Container ID. Usually a UUID, as for example used to [identify Docker containers](https://docs.docker.com/engine/reference/run/#container-identification). The UUID might be abbreviated.
	 *
	 * @deprecated Use ATTR_CONTAINER_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CONTAINER_ID = TMP_CONTAINER_ID;
	/**
	 * The container runtime managing this container.
	 *
	 * @deprecated Use ATTR_CONTAINER_RUNTIME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CONTAINER_RUNTIME = TMP_CONTAINER_RUNTIME;
	/**
	 * Name of the image the container was built on.
	 *
	 * @deprecated Use ATTR_CONTAINER_IMAGE_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CONTAINER_IMAGE_NAME = TMP_CONTAINER_IMAGE_NAME;
	/**
	 * Container image tag.
	 *
	 * @deprecated Use ATTR_CONTAINER_IMAGE_TAGS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_CONTAINER_IMAGE_TAG = TMP_CONTAINER_IMAGE_TAG;
	/**
	 * Name of the [deployment environment](https://en.wikipedia.org/wiki/Deployment_environment) (aka deployment tier).
	 *
	 * @deprecated Use ATTR_DEPLOYMENT_ENVIRONMENT in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_DEPLOYMENT_ENVIRONMENT = TMP_DEPLOYMENT_ENVIRONMENT;
	/**
	 * A unique identifier representing the device.
	 *
	 * Note: The device identifier MUST only be defined using the values outlined below. This value is not an advertising identifier and MUST NOT be used as such. On iOS (Swift or Objective-C), this value MUST be equal to the [vendor identifier](https://developer.apple.com/documentation/uikit/uidevice/1620059-identifierforvendor). On Android (Java or Kotlin), this value MUST be equal to the Firebase Installation ID or a globally unique UUID which is persisted across sessions in your application. More information can be found [here](https://developer.android.com/training/articles/user-data-ids) on best practices and exact implementation details. Caution should be taken when storing personal data or anything which can identify a user. GDPR and data protection laws may apply, ensure you do your own due diligence.
	 *
	 * @deprecated Use ATTR_DEVICE_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_DEVICE_ID = TMP_DEVICE_ID;
	/**
	 * The model identifier for the device.
	 *
	 * Note: It&#39;s recommended this value represents a machine readable version of the model identifier rather than the market or consumer-friendly name of the device.
	 *
	 * @deprecated Use ATTR_DEVICE_MODEL_IDENTIFIER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_DEVICE_MODEL_IDENTIFIER = TMP_DEVICE_MODEL_IDENTIFIER;
	/**
	 * The marketing name for the device model.
	 *
	 * Note: It&#39;s recommended this value represents a human readable version of the device model rather than a machine readable alternative.
	 *
	 * @deprecated Use ATTR_DEVICE_MODEL_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_DEVICE_MODEL_NAME = TMP_DEVICE_MODEL_NAME;
	/**
	 * The name of the single function that this runtime instance executes.
	 *
	 * Note: This is the name of the function as configured/deployed on the FaaS platform and is usually different from the name of the callback function (which may be stored in the [`code.namespace`/`code.function`](../../trace/semantic_conventions/span-general.md#source-code-attributes) span attributes).
	 *
	 * @deprecated Use ATTR_FAAS_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_FAAS_NAME = TMP_FAAS_NAME;
	/**
	* The unique ID of the single function that this runtime instance executes.
	*
	* Note: Depending on the cloud provider, use:

	* **AWS Lambda:** The function [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	Take care not to use the &#34;invoked ARN&#34; directly but replace any
	[alias suffix](https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html) with the resolved function version, as the same runtime instance may be invokable with multiple
	different aliases.
	* **GCP:** The [URI of the resource](https://cloud.google.com/iam/docs/full-resource-names)
	* **Azure:** The [Fully Qualified Resource ID](https://docs.microsoft.com/en-us/rest/api/resources/resources/get-by-id).

	On some providers, it may not be possible to determine the full ID at startup,
	which is why this field cannot be made required. For example, on AWS the account ID
	part of the ARN is not available without calling another AWS API
	which may be deemed too slow for a short-running lambda function.
	As an alternative, consider setting `faas.id` as a span attribute instead.
	*
	* @deprecated Use ATTR_CLOUD_RESOURCE_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	*/
	var SEMRESATTRS_FAAS_ID = TMP_FAAS_ID;
	/**
	* The immutable version of the function being executed.
	*
	* Note: Depending on the cloud provider and platform, use:

	* **AWS Lambda:** The [function version](https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html)
	  (an integer represented as a decimal string).
	* **Google Cloud Run:** The [revision](https://cloud.google.com/run/docs/managing/revisions)
	  (i.e., the function name plus the revision suffix).
	* **Google Cloud Functions:** The value of the
	  [`K_REVISION` environment variable](https://cloud.google.com/functions/docs/env-var#runtime_environment_variables_set_automatically).
	* **Azure Functions:** Not applicable. Do not set this attribute.
	*
	* @deprecated Use ATTR_FAAS_VERSION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	*/
	var SEMRESATTRS_FAAS_VERSION = TMP_FAAS_VERSION;
	/**
	 * The execution environment ID as a string, that will be potentially reused for other invocations to the same function/function version.
	 *
	 * Note: * **AWS Lambda:** Use the (full) log stream name.
	 *
	 * @deprecated Use ATTR_FAAS_INSTANCE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_FAAS_INSTANCE = TMP_FAAS_INSTANCE;
	/**
	 * The amount of memory available to the serverless function in MiB.
	 *
	 * Note: It&#39;s recommended to set this attribute since e.g. too little memory can easily stop a Java AWS Lambda function from working correctly. On AWS Lambda, the environment variable `AWS_LAMBDA_FUNCTION_MEMORY_SIZE` provides this information.
	 *
	 * @deprecated Use ATTR_FAAS_MAX_MEMORY in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_FAAS_MAX_MEMORY = TMP_FAAS_MAX_MEMORY;
	/**
	 * Unique host ID. For Cloud, this must be the instance_id assigned by the cloud provider.
	 *
	 * @deprecated Use ATTR_HOST_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_HOST_ID = TMP_HOST_ID;
	/**
	 * Name of the host. On Unix systems, it may contain what the hostname command returns, or the fully qualified hostname, or another name specified by the user.
	 *
	 * @deprecated Use ATTR_HOST_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_HOST_NAME = TMP_HOST_NAME;
	/**
	 * Type of host. For Cloud, this must be the machine type.
	 *
	 * @deprecated Use ATTR_HOST_TYPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_HOST_TYPE = TMP_HOST_TYPE;
	/**
	 * The CPU architecture the host system is running on.
	 *
	 * @deprecated Use ATTR_HOST_ARCH in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_HOST_ARCH = TMP_HOST_ARCH;
	/**
	 * Name of the VM image or OS install the host was instantiated from.
	 *
	 * @deprecated Use ATTR_HOST_IMAGE_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_HOST_IMAGE_NAME = TMP_HOST_IMAGE_NAME;
	/**
	 * VM image ID. For Cloud, this value is from the provider.
	 *
	 * @deprecated Use ATTR_HOST_IMAGE_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_HOST_IMAGE_ID = TMP_HOST_IMAGE_ID;
	/**
	 * The version string of the VM image as defined in [Version Attributes](README.md#version-attributes).
	 *
	 * @deprecated Use ATTR_HOST_IMAGE_VERSION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_HOST_IMAGE_VERSION = TMP_HOST_IMAGE_VERSION;
	/**
	 * The name of the cluster.
	 *
	 * @deprecated Use ATTR_K8S_CLUSTER_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_CLUSTER_NAME = TMP_K8S_CLUSTER_NAME;
	/**
	 * The name of the Node.
	 *
	 * @deprecated Use ATTR_K8S_NODE_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_NODE_NAME = TMP_K8S_NODE_NAME;
	/**
	 * The UID of the Node.
	 *
	 * @deprecated Use ATTR_K8S_NODE_UID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_NODE_UID = TMP_K8S_NODE_UID;
	/**
	 * The name of the namespace that the pod is running in.
	 *
	 * @deprecated Use ATTR_K8S_NAMESPACE_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_NAMESPACE_NAME = TMP_K8S_NAMESPACE_NAME;
	/**
	 * The UID of the Pod.
	 *
	 * @deprecated Use ATTR_K8S_POD_UID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_POD_UID = TMP_K8S_POD_UID;
	/**
	 * The name of the Pod.
	 *
	 * @deprecated Use ATTR_K8S_POD_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_POD_NAME = TMP_K8S_POD_NAME;
	/**
	 * The name of the Container in a Pod template.
	 *
	 * @deprecated Use ATTR_K8S_CONTAINER_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_CONTAINER_NAME = TMP_K8S_CONTAINER_NAME;
	/**
	 * The UID of the ReplicaSet.
	 *
	 * @deprecated Use ATTR_K8S_REPLICASET_UID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_REPLICASET_UID = TMP_K8S_REPLICASET_UID;
	/**
	 * The name of the ReplicaSet.
	 *
	 * @deprecated Use ATTR_K8S_REPLICASET_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_REPLICASET_NAME = TMP_K8S_REPLICASET_NAME;
	/**
	 * The UID of the Deployment.
	 *
	 * @deprecated Use ATTR_K8S_DEPLOYMENT_UID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_DEPLOYMENT_UID = TMP_K8S_DEPLOYMENT_UID;
	/**
	 * The name of the Deployment.
	 *
	 * @deprecated Use ATTR_K8S_DEPLOYMENT_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_DEPLOYMENT_NAME = TMP_K8S_DEPLOYMENT_NAME;
	/**
	 * The UID of the StatefulSet.
	 *
	 * @deprecated Use ATTR_K8S_STATEFULSET_UID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_STATEFULSET_UID = TMP_K8S_STATEFULSET_UID;
	/**
	 * The name of the StatefulSet.
	 *
	 * @deprecated Use ATTR_K8S_STATEFULSET_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_STATEFULSET_NAME = TMP_K8S_STATEFULSET_NAME;
	/**
	 * The UID of the DaemonSet.
	 *
	 * @deprecated Use ATTR_K8S_DAEMONSET_UID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_DAEMONSET_UID = TMP_K8S_DAEMONSET_UID;
	/**
	 * The name of the DaemonSet.
	 *
	 * @deprecated Use ATTR_K8S_DAEMONSET_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_DAEMONSET_NAME = TMP_K8S_DAEMONSET_NAME;
	/**
	 * The UID of the Job.
	 *
	 * @deprecated Use ATTR_K8S_JOB_UID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_JOB_UID = TMP_K8S_JOB_UID;
	/**
	 * The name of the Job.
	 *
	 * @deprecated Use ATTR_K8S_JOB_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_JOB_NAME = TMP_K8S_JOB_NAME;
	/**
	 * The UID of the CronJob.
	 *
	 * @deprecated Use ATTR_K8S_CRONJOB_UID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_CRONJOB_UID = TMP_K8S_CRONJOB_UID;
	/**
	 * The name of the CronJob.
	 *
	 * @deprecated Use ATTR_K8S_CRONJOB_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_K8S_CRONJOB_NAME = TMP_K8S_CRONJOB_NAME;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use ATTR_OS_TYPE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_OS_TYPE = TMP_OS_TYPE;
	/**
	 * Human readable (not intended to be parsed) OS version information, like e.g. reported by `ver` or `lsb_release -a` commands.
	 *
	 * @deprecated Use ATTR_OS_DESCRIPTION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_OS_DESCRIPTION = TMP_OS_DESCRIPTION;
	/**
	 * Human readable operating system name.
	 *
	 * @deprecated Use ATTR_OS_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_OS_NAME = TMP_OS_NAME;
	/**
	 * The version string of the operating system as defined in [Version Attributes](../../resource/semantic_conventions/README.md#version-attributes).
	 *
	 * @deprecated Use ATTR_OS_VERSION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_OS_VERSION = TMP_OS_VERSION;
	/**
	 * Process identifier (PID).
	 *
	 * @deprecated Use ATTR_PROCESS_PID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_PID = TMP_PROCESS_PID;
	/**
	 * The name of the process executable. On Linux based systems, can be set to the `Name` in `proc/[pid]/status`. On Windows, can be set to the base name of `GetProcessImageFileNameW`.
	 *
	 * @deprecated Use ATTR_PROCESS_EXECUTABLE_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_EXECUTABLE_NAME = TMP_PROCESS_EXECUTABLE_NAME;
	/**
	 * The full path to the process executable. On Linux based systems, can be set to the target of `proc/[pid]/exe`. On Windows, can be set to the result of `GetProcessImageFileNameW`.
	 *
	 * @deprecated Use ATTR_PROCESS_EXECUTABLE_PATH in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_EXECUTABLE_PATH = TMP_PROCESS_EXECUTABLE_PATH;
	/**
	 * The command used to launch the process (i.e. the command name). On Linux based systems, can be set to the zeroth string in `proc/[pid]/cmdline`. On Windows, can be set to the first parameter extracted from `GetCommandLineW`.
	 *
	 * @deprecated Use ATTR_PROCESS_COMMAND in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_COMMAND = TMP_PROCESS_COMMAND;
	/**
	 * The full command used to launch the process as a single string representing the full command. On Windows, can be set to the result of `GetCommandLineW`. Do not set this if you have to assemble it just for monitoring; use `process.command_args` instead.
	 *
	 * @deprecated Use ATTR_PROCESS_COMMAND_LINE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_COMMAND_LINE = TMP_PROCESS_COMMAND_LINE;
	/**
	 * All the command arguments (including the command/executable itself) as received by the process. On Linux-based systems (and some other Unixoid systems supporting procfs), can be set according to the list of null-delimited strings extracted from `proc/[pid]/cmdline`. For libc-based executables, this would be the full argv vector passed to `main`.
	 *
	 * @deprecated Use ATTR_PROCESS_COMMAND_ARGS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_COMMAND_ARGS = TMP_PROCESS_COMMAND_ARGS;
	/**
	 * The username of the user that owns the process.
	 *
	 * @deprecated Use ATTR_PROCESS_OWNER in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_OWNER = TMP_PROCESS_OWNER;
	/**
	 * The name of the runtime of this process. For compiled native binaries, this SHOULD be the name of the compiler.
	 *
	 * @deprecated Use ATTR_PROCESS_RUNTIME_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_RUNTIME_NAME = TMP_PROCESS_RUNTIME_NAME;
	/**
	 * The version of the runtime of this process, as returned by the runtime without modification.
	 *
	 * @deprecated Use ATTR_PROCESS_RUNTIME_VERSION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_RUNTIME_VERSION = TMP_PROCESS_RUNTIME_VERSION;
	/**
	 * An additional description about the runtime of the process, for example a specific vendor customization of the runtime environment.
	 *
	 * @deprecated Use ATTR_PROCESS_RUNTIME_DESCRIPTION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_PROCESS_RUNTIME_DESCRIPTION = TMP_PROCESS_RUNTIME_DESCRIPTION;
	/**
	 * Logical name of the service.
	 *
	 * Note: MUST be the same for all instances of horizontally scaled services. If the value was not specified, SDKs MUST fallback to `unknown_service:` concatenated with [`process.executable.name`](process.md#process), e.g. `unknown_service:bash`. If `process.executable.name` is not available, the value MUST be set to `unknown_service`.
	 *
	 * @deprecated Use ATTR_SERVICE_NAME.
	 */
	var SEMRESATTRS_SERVICE_NAME = TMP_SERVICE_NAME;
	/**
	 * A namespace for `service.name`.
	 *
	 * Note: A string value having a meaning that helps to distinguish a group of services, for example the team name that owns a group of services. `service.name` is expected to be unique within the same namespace. If `service.namespace` is not specified in the Resource then `service.name` is expected to be unique for all services that have no explicit namespace defined (so the empty/unspecified namespace is simply one more valid namespace). Zero-length namespace string is assumed equal to unspecified namespace.
	 *
	 * @deprecated Use ATTR_SERVICE_NAMESPACE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_SERVICE_NAMESPACE = TMP_SERVICE_NAMESPACE;
	/**
	 * The string ID of the service instance.
	 *
	 * Note: MUST be unique for each instance of the same `service.namespace,service.name` pair (in other words `service.namespace,service.name,service.instance.id` triplet MUST be globally unique). The ID helps to distinguish instances of the same service that exist at the same time (e.g. instances of a horizontally scaled service). It is preferable for the ID to be persistent and stay the same for the lifetime of the service instance, however it is acceptable that the ID is ephemeral and changes during important lifetime events for the service (e.g. service restarts). If the service has no inherent unique ID that can be used as the value of this attribute it is recommended to generate a random Version 1 or Version 4 RFC 4122 UUID (services aiming for reproducible UUIDs may also use Version 5, see RFC 4122 for more recommendations).
	 *
	 * @deprecated Use ATTR_SERVICE_INSTANCE_ID in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_SERVICE_INSTANCE_ID = TMP_SERVICE_INSTANCE_ID;
	/**
	 * The version string of the service API or implementation.
	 *
	 * @deprecated Use ATTR_SERVICE_VERSION.
	 */
	var SEMRESATTRS_SERVICE_VERSION = TMP_SERVICE_VERSION;
	/**
	 * The name of the telemetry SDK as defined above.
	 *
	 * @deprecated Use ATTR_TELEMETRY_SDK_NAME.
	 */
	var SEMRESATTRS_TELEMETRY_SDK_NAME = TMP_TELEMETRY_SDK_NAME;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use ATTR_TELEMETRY_SDK_LANGUAGE.
	 */
	var SEMRESATTRS_TELEMETRY_SDK_LANGUAGE = TMP_TELEMETRY_SDK_LANGUAGE;
	/**
	 * The version string of the telemetry SDK.
	 *
	 * @deprecated Use ATTR_TELEMETRY_SDK_VERSION.
	 */
	var SEMRESATTRS_TELEMETRY_SDK_VERSION = TMP_TELEMETRY_SDK_VERSION;
	/**
	 * The version string of the auto instrumentation agent, if used.
	 *
	 * @deprecated Use ATTR_TELEMETRY_DISTRO_VERSION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_TELEMETRY_AUTO_VERSION = TMP_TELEMETRY_AUTO_VERSION;
	/**
	 * The name of the web engine.
	 *
	 * @deprecated Use ATTR_WEBENGINE_NAME in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_WEBENGINE_NAME = TMP_WEBENGINE_NAME;
	/**
	 * The version of the web engine.
	 *
	 * @deprecated Use ATTR_WEBENGINE_VERSION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_WEBENGINE_VERSION = TMP_WEBENGINE_VERSION;
	/**
	 * Additional description of the web engine (e.g. detailed version and edition information).
	 *
	 * @deprecated Use ATTR_WEBENGINE_DESCRIPTION in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var SEMRESATTRS_WEBENGINE_DESCRIPTION = TMP_WEBENGINE_DESCRIPTION;
	/**
	 * Create exported Value Map for SemanticResourceAttributes values
	 * @deprecated Use the SEMRESATTRS_XXXXX constants rather than the SemanticResourceAttributes.XXXXX for bundle minification
	 */
	var SemanticResourceAttributes = /*#__PURE__*/createConstMap([TMP_CLOUD_PROVIDER, TMP_CLOUD_ACCOUNT_ID, TMP_CLOUD_REGION, TMP_CLOUD_AVAILABILITY_ZONE, TMP_CLOUD_PLATFORM, TMP_AWS_ECS_CONTAINER_ARN, TMP_AWS_ECS_CLUSTER_ARN, TMP_AWS_ECS_LAUNCHTYPE, TMP_AWS_ECS_TASK_ARN, TMP_AWS_ECS_TASK_FAMILY, TMP_AWS_ECS_TASK_REVISION, TMP_AWS_EKS_CLUSTER_ARN, TMP_AWS_LOG_GROUP_NAMES, TMP_AWS_LOG_GROUP_ARNS, TMP_AWS_LOG_STREAM_NAMES, TMP_AWS_LOG_STREAM_ARNS, TMP_CONTAINER_NAME, TMP_CONTAINER_ID, TMP_CONTAINER_RUNTIME, TMP_CONTAINER_IMAGE_NAME, TMP_CONTAINER_IMAGE_TAG, TMP_DEPLOYMENT_ENVIRONMENT, TMP_DEVICE_ID, TMP_DEVICE_MODEL_IDENTIFIER, TMP_DEVICE_MODEL_NAME, TMP_FAAS_NAME, TMP_FAAS_ID, TMP_FAAS_VERSION, TMP_FAAS_INSTANCE, TMP_FAAS_MAX_MEMORY, TMP_HOST_ID, TMP_HOST_NAME, TMP_HOST_TYPE, TMP_HOST_ARCH, TMP_HOST_IMAGE_NAME, TMP_HOST_IMAGE_ID, TMP_HOST_IMAGE_VERSION, TMP_K8S_CLUSTER_NAME, TMP_K8S_NODE_NAME, TMP_K8S_NODE_UID, TMP_K8S_NAMESPACE_NAME, TMP_K8S_POD_UID, TMP_K8S_POD_NAME, TMP_K8S_CONTAINER_NAME, TMP_K8S_REPLICASET_UID, TMP_K8S_REPLICASET_NAME, TMP_K8S_DEPLOYMENT_UID, TMP_K8S_DEPLOYMENT_NAME, TMP_K8S_STATEFULSET_UID, TMP_K8S_STATEFULSET_NAME, TMP_K8S_DAEMONSET_UID, TMP_K8S_DAEMONSET_NAME, TMP_K8S_JOB_UID, TMP_K8S_JOB_NAME, TMP_K8S_CRONJOB_UID, TMP_K8S_CRONJOB_NAME, TMP_OS_TYPE, TMP_OS_DESCRIPTION, TMP_OS_NAME, TMP_OS_VERSION, TMP_PROCESS_PID, TMP_PROCESS_EXECUTABLE_NAME, TMP_PROCESS_EXECUTABLE_PATH, TMP_PROCESS_COMMAND, TMP_PROCESS_COMMAND_LINE, TMP_PROCESS_COMMAND_ARGS, TMP_PROCESS_OWNER, TMP_PROCESS_RUNTIME_NAME, TMP_PROCESS_RUNTIME_VERSION, TMP_PROCESS_RUNTIME_DESCRIPTION, TMP_SERVICE_NAME, TMP_SERVICE_NAMESPACE, TMP_SERVICE_INSTANCE_ID, TMP_SERVICE_VERSION, TMP_TELEMETRY_SDK_NAME, TMP_TELEMETRY_SDK_LANGUAGE, TMP_TELEMETRY_SDK_VERSION, TMP_TELEMETRY_AUTO_VERSION, TMP_WEBENGINE_NAME, TMP_WEBENGINE_VERSION, TMP_WEBENGINE_DESCRIPTION]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for CloudProviderValues enum definition
	 *
	 * Name of the cloud provider.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_CLOUDPROVIDERVALUES_ALIBABA_CLOUD = 'alibaba_cloud';
	var TMP_CLOUDPROVIDERVALUES_AWS = 'aws';
	var TMP_CLOUDPROVIDERVALUES_AZURE = 'azure';
	var TMP_CLOUDPROVIDERVALUES_GCP = 'gcp';
	/**
	 * Name of the cloud provider.
	 *
	 * @deprecated Use CLOUD_PROVIDER_VALUE_ALIBABA_CLOUD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPROVIDERVALUES_ALIBABA_CLOUD = TMP_CLOUDPROVIDERVALUES_ALIBABA_CLOUD;
	/**
	 * Name of the cloud provider.
	 *
	 * @deprecated Use CLOUD_PROVIDER_VALUE_AWS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPROVIDERVALUES_AWS = TMP_CLOUDPROVIDERVALUES_AWS;
	/**
	 * Name of the cloud provider.
	 *
	 * @deprecated Use CLOUD_PROVIDER_VALUE_AZURE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPROVIDERVALUES_AZURE = TMP_CLOUDPROVIDERVALUES_AZURE;
	/**
	 * Name of the cloud provider.
	 *
	 * @deprecated Use CLOUD_PROVIDER_VALUE_GCP in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPROVIDERVALUES_GCP = TMP_CLOUDPROVIDERVALUES_GCP;
	/**
	 * The constant map of values for CloudProviderValues.
	 * @deprecated Use the CLOUDPROVIDERVALUES_XXXXX constants rather than the CloudProviderValues.XXXXX for bundle minification.
	 */
	var CloudProviderValues = /*#__PURE__*/createConstMap([TMP_CLOUDPROVIDERVALUES_ALIBABA_CLOUD, TMP_CLOUDPROVIDERVALUES_AWS, TMP_CLOUDPROVIDERVALUES_AZURE, TMP_CLOUDPROVIDERVALUES_GCP]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for CloudPlatformValues enum definition
	 *
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_CLOUDPLATFORMVALUES_ALIBABA_CLOUD_ECS = 'alibaba_cloud_ecs';
	var TMP_CLOUDPLATFORMVALUES_ALIBABA_CLOUD_FC = 'alibaba_cloud_fc';
	var TMP_CLOUDPLATFORMVALUES_AWS_EC2 = 'aws_ec2';
	var TMP_CLOUDPLATFORMVALUES_AWS_ECS = 'aws_ecs';
	var TMP_CLOUDPLATFORMVALUES_AWS_EKS = 'aws_eks';
	var TMP_CLOUDPLATFORMVALUES_AWS_LAMBDA = 'aws_lambda';
	var TMP_CLOUDPLATFORMVALUES_AWS_ELASTIC_BEANSTALK = 'aws_elastic_beanstalk';
	var TMP_CLOUDPLATFORMVALUES_AZURE_VM = 'azure_vm';
	var TMP_CLOUDPLATFORMVALUES_AZURE_CONTAINER_INSTANCES = 'azure_container_instances';
	var TMP_CLOUDPLATFORMVALUES_AZURE_AKS = 'azure_aks';
	var TMP_CLOUDPLATFORMVALUES_AZURE_FUNCTIONS = 'azure_functions';
	var TMP_CLOUDPLATFORMVALUES_AZURE_APP_SERVICE = 'azure_app_service';
	var TMP_CLOUDPLATFORMVALUES_GCP_COMPUTE_ENGINE = 'gcp_compute_engine';
	var TMP_CLOUDPLATFORMVALUES_GCP_CLOUD_RUN = 'gcp_cloud_run';
	var TMP_CLOUDPLATFORMVALUES_GCP_KUBERNETES_ENGINE = 'gcp_kubernetes_engine';
	var TMP_CLOUDPLATFORMVALUES_GCP_CLOUD_FUNCTIONS = 'gcp_cloud_functions';
	var TMP_CLOUDPLATFORMVALUES_GCP_APP_ENGINE = 'gcp_app_engine';
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_ALIBABA_CLOUD_ECS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_ALIBABA_CLOUD_ECS = TMP_CLOUDPLATFORMVALUES_ALIBABA_CLOUD_ECS;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_ALIBABA_CLOUD_FC in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_ALIBABA_CLOUD_FC = TMP_CLOUDPLATFORMVALUES_ALIBABA_CLOUD_FC;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AWS_EC2 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AWS_EC2 = TMP_CLOUDPLATFORMVALUES_AWS_EC2;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AWS_ECS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AWS_ECS = TMP_CLOUDPLATFORMVALUES_AWS_ECS;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AWS_EKS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AWS_EKS = TMP_CLOUDPLATFORMVALUES_AWS_EKS;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AWS_LAMBDA in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AWS_LAMBDA = TMP_CLOUDPLATFORMVALUES_AWS_LAMBDA;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AWS_ELASTIC_BEANSTALK in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AWS_ELASTIC_BEANSTALK = TMP_CLOUDPLATFORMVALUES_AWS_ELASTIC_BEANSTALK;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AZURE_VM in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AZURE_VM = TMP_CLOUDPLATFORMVALUES_AZURE_VM;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AZURE_CONTAINER_INSTANCES in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AZURE_CONTAINER_INSTANCES = TMP_CLOUDPLATFORMVALUES_AZURE_CONTAINER_INSTANCES;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AZURE_AKS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AZURE_AKS = TMP_CLOUDPLATFORMVALUES_AZURE_AKS;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AZURE_FUNCTIONS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AZURE_FUNCTIONS = TMP_CLOUDPLATFORMVALUES_AZURE_FUNCTIONS;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_AZURE_APP_SERVICE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_AZURE_APP_SERVICE = TMP_CLOUDPLATFORMVALUES_AZURE_APP_SERVICE;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_GCP_COMPUTE_ENGINE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_GCP_COMPUTE_ENGINE = TMP_CLOUDPLATFORMVALUES_GCP_COMPUTE_ENGINE;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_GCP_CLOUD_RUN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_GCP_CLOUD_RUN = TMP_CLOUDPLATFORMVALUES_GCP_CLOUD_RUN;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_GCP_KUBERNETES_ENGINE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_GCP_KUBERNETES_ENGINE = TMP_CLOUDPLATFORMVALUES_GCP_KUBERNETES_ENGINE;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_GCP_CLOUD_FUNCTIONS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_GCP_CLOUD_FUNCTIONS = TMP_CLOUDPLATFORMVALUES_GCP_CLOUD_FUNCTIONS;
	/**
	 * The cloud platform in use.
	 *
	 * Note: The prefix of the service SHOULD match the one specified in `cloud.provider`.
	 *
	 * @deprecated Use CLOUD_PLATFORM_VALUE_GCP_APP_ENGINE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var CLOUDPLATFORMVALUES_GCP_APP_ENGINE = TMP_CLOUDPLATFORMVALUES_GCP_APP_ENGINE;
	/**
	 * The constant map of values for CloudPlatformValues.
	 * @deprecated Use the CLOUDPLATFORMVALUES_XXXXX constants rather than the CloudPlatformValues.XXXXX for bundle minification.
	 */
	var CloudPlatformValues = /*#__PURE__*/createConstMap([TMP_CLOUDPLATFORMVALUES_ALIBABA_CLOUD_ECS, TMP_CLOUDPLATFORMVALUES_ALIBABA_CLOUD_FC, TMP_CLOUDPLATFORMVALUES_AWS_EC2, TMP_CLOUDPLATFORMVALUES_AWS_ECS, TMP_CLOUDPLATFORMVALUES_AWS_EKS, TMP_CLOUDPLATFORMVALUES_AWS_LAMBDA, TMP_CLOUDPLATFORMVALUES_AWS_ELASTIC_BEANSTALK, TMP_CLOUDPLATFORMVALUES_AZURE_VM, TMP_CLOUDPLATFORMVALUES_AZURE_CONTAINER_INSTANCES, TMP_CLOUDPLATFORMVALUES_AZURE_AKS, TMP_CLOUDPLATFORMVALUES_AZURE_FUNCTIONS, TMP_CLOUDPLATFORMVALUES_AZURE_APP_SERVICE, TMP_CLOUDPLATFORMVALUES_GCP_COMPUTE_ENGINE, TMP_CLOUDPLATFORMVALUES_GCP_CLOUD_RUN, TMP_CLOUDPLATFORMVALUES_GCP_KUBERNETES_ENGINE, TMP_CLOUDPLATFORMVALUES_GCP_CLOUD_FUNCTIONS, TMP_CLOUDPLATFORMVALUES_GCP_APP_ENGINE]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for AwsEcsLaunchtypeValues enum definition
	 *
	 * The [launch type](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) for an ECS task.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_AWSECSLAUNCHTYPEVALUES_EC2 = 'ec2';
	var TMP_AWSECSLAUNCHTYPEVALUES_FARGATE = 'fargate';
	/**
	 * The [launch type](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) for an ECS task.
	 *
	 * @deprecated Use AWS_ECS_LAUNCHTYPE_VALUE_EC2 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var AWSECSLAUNCHTYPEVALUES_EC2 = TMP_AWSECSLAUNCHTYPEVALUES_EC2;
	/**
	 * The [launch type](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) for an ECS task.
	 *
	 * @deprecated Use AWS_ECS_LAUNCHTYPE_VALUE_FARGATE in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var AWSECSLAUNCHTYPEVALUES_FARGATE = TMP_AWSECSLAUNCHTYPEVALUES_FARGATE;
	/**
	 * The constant map of values for AwsEcsLaunchtypeValues.
	 * @deprecated Use the AWSECSLAUNCHTYPEVALUES_XXXXX constants rather than the AwsEcsLaunchtypeValues.XXXXX for bundle minification.
	 */
	var AwsEcsLaunchtypeValues = /*#__PURE__*/createConstMap([TMP_AWSECSLAUNCHTYPEVALUES_EC2, TMP_AWSECSLAUNCHTYPEVALUES_FARGATE]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for HostArchValues enum definition
	 *
	 * The CPU architecture the host system is running on.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_HOSTARCHVALUES_AMD64 = 'amd64';
	var TMP_HOSTARCHVALUES_ARM32 = 'arm32';
	var TMP_HOSTARCHVALUES_ARM64 = 'arm64';
	var TMP_HOSTARCHVALUES_IA64 = 'ia64';
	var TMP_HOSTARCHVALUES_PPC32 = 'ppc32';
	var TMP_HOSTARCHVALUES_PPC64 = 'ppc64';
	var TMP_HOSTARCHVALUES_X86 = 'x86';
	/**
	 * The CPU architecture the host system is running on.
	 *
	 * @deprecated Use HOST_ARCH_VALUE_AMD64 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HOSTARCHVALUES_AMD64 = TMP_HOSTARCHVALUES_AMD64;
	/**
	 * The CPU architecture the host system is running on.
	 *
	 * @deprecated Use HOST_ARCH_VALUE_ARM32 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HOSTARCHVALUES_ARM32 = TMP_HOSTARCHVALUES_ARM32;
	/**
	 * The CPU architecture the host system is running on.
	 *
	 * @deprecated Use HOST_ARCH_VALUE_ARM64 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HOSTARCHVALUES_ARM64 = TMP_HOSTARCHVALUES_ARM64;
	/**
	 * The CPU architecture the host system is running on.
	 *
	 * @deprecated Use HOST_ARCH_VALUE_IA64 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HOSTARCHVALUES_IA64 = TMP_HOSTARCHVALUES_IA64;
	/**
	 * The CPU architecture the host system is running on.
	 *
	 * @deprecated Use HOST_ARCH_VALUE_PPC32 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HOSTARCHVALUES_PPC32 = TMP_HOSTARCHVALUES_PPC32;
	/**
	 * The CPU architecture the host system is running on.
	 *
	 * @deprecated Use HOST_ARCH_VALUE_PPC64 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HOSTARCHVALUES_PPC64 = TMP_HOSTARCHVALUES_PPC64;
	/**
	 * The CPU architecture the host system is running on.
	 *
	 * @deprecated Use HOST_ARCH_VALUE_X86 in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var HOSTARCHVALUES_X86 = TMP_HOSTARCHVALUES_X86;
	/**
	 * The constant map of values for HostArchValues.
	 * @deprecated Use the HOSTARCHVALUES_XXXXX constants rather than the HostArchValues.XXXXX for bundle minification.
	 */
	var HostArchValues = /*#__PURE__*/createConstMap([TMP_HOSTARCHVALUES_AMD64, TMP_HOSTARCHVALUES_ARM32, TMP_HOSTARCHVALUES_ARM64, TMP_HOSTARCHVALUES_IA64, TMP_HOSTARCHVALUES_PPC32, TMP_HOSTARCHVALUES_PPC64, TMP_HOSTARCHVALUES_X86]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for OsTypeValues enum definition
	 *
	 * The operating system type.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_OSTYPEVALUES_WINDOWS = 'windows';
	var TMP_OSTYPEVALUES_LINUX = 'linux';
	var TMP_OSTYPEVALUES_DARWIN = 'darwin';
	var TMP_OSTYPEVALUES_FREEBSD = 'freebsd';
	var TMP_OSTYPEVALUES_NETBSD = 'netbsd';
	var TMP_OSTYPEVALUES_OPENBSD = 'openbsd';
	var TMP_OSTYPEVALUES_DRAGONFLYBSD = 'dragonflybsd';
	var TMP_OSTYPEVALUES_HPUX = 'hpux';
	var TMP_OSTYPEVALUES_AIX = 'aix';
	var TMP_OSTYPEVALUES_SOLARIS = 'solaris';
	var TMP_OSTYPEVALUES_Z_OS = 'z_os';
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_WINDOWS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_WINDOWS = TMP_OSTYPEVALUES_WINDOWS;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_LINUX in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_LINUX = TMP_OSTYPEVALUES_LINUX;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_DARWIN in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_DARWIN = TMP_OSTYPEVALUES_DARWIN;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_FREEBSD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_FREEBSD = TMP_OSTYPEVALUES_FREEBSD;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_NETBSD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_NETBSD = TMP_OSTYPEVALUES_NETBSD;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_OPENBSD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_OPENBSD = TMP_OSTYPEVALUES_OPENBSD;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_DRAGONFLYBSD in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_DRAGONFLYBSD = TMP_OSTYPEVALUES_DRAGONFLYBSD;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_HPUX in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_HPUX = TMP_OSTYPEVALUES_HPUX;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_AIX in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_AIX = TMP_OSTYPEVALUES_AIX;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_SOLARIS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_SOLARIS = TMP_OSTYPEVALUES_SOLARIS;
	/**
	 * The operating system type.
	 *
	 * @deprecated Use OS_TYPE_VALUE_Z_OS in [incubating entry-point]({@link https://github.com/open-telemetry/opentelemetry-js/blob/main/semantic-conventions/README.md#unstable-semconv}).
	 */
	var OSTYPEVALUES_Z_OS = TMP_OSTYPEVALUES_Z_OS;
	/**
	 * The constant map of values for OsTypeValues.
	 * @deprecated Use the OSTYPEVALUES_XXXXX constants rather than the OsTypeValues.XXXXX for bundle minification.
	 */
	var OsTypeValues = /*#__PURE__*/createConstMap([TMP_OSTYPEVALUES_WINDOWS, TMP_OSTYPEVALUES_LINUX, TMP_OSTYPEVALUES_DARWIN, TMP_OSTYPEVALUES_FREEBSD, TMP_OSTYPEVALUES_NETBSD, TMP_OSTYPEVALUES_OPENBSD, TMP_OSTYPEVALUES_DRAGONFLYBSD, TMP_OSTYPEVALUES_HPUX, TMP_OSTYPEVALUES_AIX, TMP_OSTYPEVALUES_SOLARIS, TMP_OSTYPEVALUES_Z_OS]);
	/* ----------------------------------------------------------------------------------------------------------
	 * Constant values for TelemetrySdkLanguageValues enum definition
	 *
	 * The language of the telemetry SDK.
	 * ---------------------------------------------------------------------------------------------------------- */
	// Temporary local constants to assign to the individual exports and the namespaced version
	// Required to avoid the namespace exports using the unminifiable export names for some package types
	var TMP_TELEMETRYSDKLANGUAGEVALUES_CPP = 'cpp';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_DOTNET = 'dotnet';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_ERLANG = 'erlang';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_GO = 'go';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_JAVA = 'java';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_NODEJS = 'nodejs';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_PHP = 'php';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_PYTHON = 'python';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_RUBY = 'ruby';
	var TMP_TELEMETRYSDKLANGUAGEVALUES_WEBJS = 'webjs';
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_CPP.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_CPP = TMP_TELEMETRYSDKLANGUAGEVALUES_CPP;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_DOTNET.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_DOTNET = TMP_TELEMETRYSDKLANGUAGEVALUES_DOTNET;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_ERLANG.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_ERLANG = TMP_TELEMETRYSDKLANGUAGEVALUES_ERLANG;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_GO.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_GO = TMP_TELEMETRYSDKLANGUAGEVALUES_GO;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_JAVA.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_JAVA = TMP_TELEMETRYSDKLANGUAGEVALUES_JAVA;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_NODEJS.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_NODEJS = TMP_TELEMETRYSDKLANGUAGEVALUES_NODEJS;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_PHP.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_PHP = TMP_TELEMETRYSDKLANGUAGEVALUES_PHP;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_PYTHON.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_PYTHON = TMP_TELEMETRYSDKLANGUAGEVALUES_PYTHON;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_RUBY.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_RUBY = TMP_TELEMETRYSDKLANGUAGEVALUES_RUBY;
	/**
	 * The language of the telemetry SDK.
	 *
	 * @deprecated Use TELEMETRY_SDK_LANGUAGE_VALUE_WEBJS.
	 */
	var TELEMETRYSDKLANGUAGEVALUES_WEBJS = TMP_TELEMETRYSDKLANGUAGEVALUES_WEBJS;
	/**
	 * The constant map of values for TelemetrySdkLanguageValues.
	 * @deprecated Use the TELEMETRYSDKLANGUAGEVALUES_XXXXX constants rather than the TelemetrySdkLanguageValues.XXXXX for bundle minification.
	 */
	var TelemetrySdkLanguageValues = /*#__PURE__*/createConstMap([TMP_TELEMETRYSDKLANGUAGEVALUES_CPP, TMP_TELEMETRYSDKLANGUAGEVALUES_DOTNET, TMP_TELEMETRYSDKLANGUAGEVALUES_ERLANG, TMP_TELEMETRYSDKLANGUAGEVALUES_GO, TMP_TELEMETRYSDKLANGUAGEVALUES_JAVA, TMP_TELEMETRYSDKLANGUAGEVALUES_NODEJS, TMP_TELEMETRYSDKLANGUAGEVALUES_PHP, TMP_TELEMETRYSDKLANGUAGEVALUES_PYTHON, TMP_TELEMETRYSDKLANGUAGEVALUES_RUBY, TMP_TELEMETRYSDKLANGUAGEVALUES_WEBJS]);

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	//----------------------------------------------------------------------------------------------------------
	// DO NOT EDIT, this is an Auto-generated file from scripts/semconv/templates/registry/stable/attributes.ts.j2
	//----------------------------------------------------------------------------------------------------------
	/**
	 * ASP.NET Core exception middleware handling result
	 *
	 * @example handled
	 * @example unhandled
	 */
	var ATTR_ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT = 'aspnetcore.diagnostics.exception.result';
	/**
	  * Enum value "aborted" for attribute {@link ATTR_ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT}.
	  */
	var ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_ABORTED = "aborted";
	/**
	  * Enum value "handled" for attribute {@link ATTR_ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT}.
	  */
	var ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_HANDLED = "handled";
	/**
	  * Enum value "skipped" for attribute {@link ATTR_ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT}.
	  */
	var ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_SKIPPED = "skipped";
	/**
	  * Enum value "unhandled" for attribute {@link ATTR_ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT}.
	  */
	var ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_UNHANDLED = "unhandled";
	/**
	 * Full type name of the [`IExceptionHandler`](https://learn.microsoft.com/dotnet/api/microsoft.aspnetcore.diagnostics.iexceptionhandler) implementation that handled the exception.
	 *
	 * @example Contoso.MyHandler
	 */
	var ATTR_ASPNETCORE_DIAGNOSTICS_HANDLER_TYPE = 'aspnetcore.diagnostics.handler.type';
	/**
	 * Rate limiting policy name.
	 *
	 * @example fixed
	 * @example sliding
	 * @example token
	 */
	var ATTR_ASPNETCORE_RATE_LIMITING_POLICY = 'aspnetcore.rate_limiting.policy';
	/**
	 * Rate-limiting result, shows whether the lease was acquired or contains a rejection reason
	 *
	 * @example acquired
	 * @example request_canceled
	 */
	var ATTR_ASPNETCORE_RATE_LIMITING_RESULT = 'aspnetcore.rate_limiting.result';
	/**
	  * Enum value "acquired" for attribute {@link ATTR_ASPNETCORE_RATE_LIMITING_RESULT}.
	  */
	var ASPNETCORE_RATE_LIMITING_RESULT_VALUE_ACQUIRED = "acquired";
	/**
	  * Enum value "endpoint_limiter" for attribute {@link ATTR_ASPNETCORE_RATE_LIMITING_RESULT}.
	  */
	var ASPNETCORE_RATE_LIMITING_RESULT_VALUE_ENDPOINT_LIMITER = "endpoint_limiter";
	/**
	  * Enum value "global_limiter" for attribute {@link ATTR_ASPNETCORE_RATE_LIMITING_RESULT}.
	  */
	var ASPNETCORE_RATE_LIMITING_RESULT_VALUE_GLOBAL_LIMITER = "global_limiter";
	/**
	  * Enum value "request_canceled" for attribute {@link ATTR_ASPNETCORE_RATE_LIMITING_RESULT}.
	  */
	var ASPNETCORE_RATE_LIMITING_RESULT_VALUE_REQUEST_CANCELED = "request_canceled";
	/**
	 * Flag indicating if request was handled by the application pipeline.
	 *
	 * @example true
	 */
	var ATTR_ASPNETCORE_REQUEST_IS_UNHANDLED = 'aspnetcore.request.is_unhandled';
	/**
	 * A value that indicates whether the matched route is a fallback route.
	 *
	 * @example true
	 */
	var ATTR_ASPNETCORE_ROUTING_IS_FALLBACK = 'aspnetcore.routing.is_fallback';
	/**
	 * Match result - success or failure
	 *
	 * @example success
	 * @example failure
	 */
	var ATTR_ASPNETCORE_ROUTING_MATCH_STATUS = 'aspnetcore.routing.match_status';
	/**
	  * Enum value "failure" for attribute {@link ATTR_ASPNETCORE_ROUTING_MATCH_STATUS}.
	  */
	var ASPNETCORE_ROUTING_MATCH_STATUS_VALUE_FAILURE = "failure";
	/**
	  * Enum value "success" for attribute {@link ATTR_ASPNETCORE_ROUTING_MATCH_STATUS}.
	  */
	var ASPNETCORE_ROUTING_MATCH_STATUS_VALUE_SUCCESS = "success";
	/**
	 * Client address - domain name if available without reverse DNS lookup; otherwise, IP address or Unix domain socket name.
	 *
	 * @example client.example.com
	 * @example 10.1.2.80
	 * @example /tmp/my.sock
	 *
	 * @note When observed from the server side, and when communicating through an intermediary, `client.address` **SHOULD** represent the client address behind any intermediaries,  for example proxies, if it's available.
	 */
	var ATTR_CLIENT_ADDRESS = 'client.address';
	/**
	 * Client port number.
	 *
	 * @example 65123
	 *
	 * @note When observed from the server side, and when communicating through an intermediary, `client.port` **SHOULD** represent the client port behind any intermediaries,  for example proxies, if it's available.
	 */
	var ATTR_CLIENT_PORT = 'client.port';
	/**
	 * The column number in `code.file.path` best representing the operation. It **SHOULD** point within the code unit named in `code.function.name`. This attribute **MUST NOT** be used on the Profile signal since the data is already captured in 'message Line'. This constraint is imposed to prevent redundancy and maintain data integrity.
	 *
	 * @example 16
	 */
	var ATTR_CODE_COLUMN_NUMBER = 'code.column.number';
	/**
	 * The source code file name that identifies the code unit as uniquely as possible (preferably an absolute file path). This attribute **MUST NOT** be used on the Profile signal since the data is already captured in 'message Function'. This constraint is imposed to prevent redundancy and maintain data integrity.
	 *
	 * @example "/usr/local/MyApplication/content_root/app/index.php"
	 */
	var ATTR_CODE_FILE_PATH = 'code.file.path';
	/**
	 * The method or function fully-qualified name without arguments. The value should fit the natural representation of the language runtime, which is also likely the same used within `code.stacktrace` attribute value. This attribute **MUST NOT** be used on the Profile signal since the data is already captured in 'message Function'. This constraint is imposed to prevent redundancy and maintain data integrity.
	 *
	 * @example com.example.MyHttpService.serveRequest
	 * @example GuzzleHttp\\Client::transfer
	 * @example fopen
	 *
	 * @note Values and format depends on each language runtime, thus it is impossible to provide an exhaustive list of examples.
	 * The values are usually the same (or prefixes of) the ones found in native stack trace representation stored in
	 * `code.stacktrace` without information on arguments.
	 *
	 * Examples:
	 *
	 *   - Java method: `com.example.MyHttpService.serveRequest`
	 *   - Java anonymous class method: `com.mycompany.Main$1.myMethod`
	 *   - Java lambda method: `com.mycompany.Main$$Lambda/0x0000748ae4149c00.myMethod`
	 *   - PHP function: `GuzzleHttp\Client::transfer`
	 *   - Go function: `github.com/my/repo/pkg.foo.func5`
	 *   - Elixir: `OpenTelemetry.Ctx.new`
	 *   - Erlang: `opentelemetry_ctx:new`
	 *   - Rust: `playground::my_module::my_cool_func`
	 *   - C function: `fopen`
	 */
	var ATTR_CODE_FUNCTION_NAME = 'code.function.name';
	/**
	 * The line number in `code.file.path` best representing the operation. It **SHOULD** point within the code unit named in `code.function.name`. This attribute **MUST NOT** be used on the Profile signal since the data is already captured in 'message Line'. This constraint is imposed to prevent redundancy and maintain data integrity.
	 *
	 * @example 42
	 */
	var ATTR_CODE_LINE_NUMBER = 'code.line.number';
	/**
	 * A stacktrace as a string in the natural representation for the language runtime. The representation is identical to [`exception.stacktrace`](/docs/exceptions/exceptions-spans.md#stacktrace-representation). This attribute **MUST NOT** be used on the Profile signal since the data is already captured in 'message Location'. This constraint is imposed to prevent redundancy and maintain data integrity.
	 *
	 * @example "at com.example.GenerateTrace.methodB(GenerateTrace.java:13)\\n at com.example.GenerateTrace.methodA(GenerateTrace.java:9)\\n at com.example.GenerateTrace.main(GenerateTrace.java:5)\\n"
	 */
	var ATTR_CODE_STACKTRACE = 'code.stacktrace';
	/**
	 * The name of a collection (table, container) within the database.
	 *
	 * @example public.users
	 * @example customers
	 *
	 * @note It is **RECOMMENDED** to capture the value as provided by the application
	 * without attempting to do any case normalization.
	 *
	 * The collection name **SHOULD NOT** be extracted from `db.query.text`,
	 * when the database system supports query text with multiple collections
	 * in non-batch operations.
	 *
	 * For batch operations, if the individual operations are known to have the same
	 * collection name then that collection name **SHOULD** be used.
	 */
	var ATTR_DB_COLLECTION_NAME = 'db.collection.name';
	/**
	 * The name of the database, fully qualified within the server address and port.
	 *
	 * @example customers
	 * @example test.users
	 *
	 * @note If a database system has multiple namespace components, they **SHOULD** be concatenated from the most general to the most specific namespace component, using `|` as a separator between the components. Any missing components (and their associated separators) **SHOULD** be omitted.
	 * Semantic conventions for individual database systems **SHOULD** document what `db.namespace` means in the context of that system.
	 * It is **RECOMMENDED** to capture the value as provided by the application without attempting to do any case normalization.
	 */
	var ATTR_DB_NAMESPACE = 'db.namespace';
	/**
	 * The number of queries included in a batch operation.
	 *
	 * @example 2
	 * @example 3
	 * @example 4
	 *
	 * @note Operations are only considered batches when they contain two or more operations, and so `db.operation.batch.size` **SHOULD** never be `1`.
	 */
	var ATTR_DB_OPERATION_BATCH_SIZE = 'db.operation.batch.size';
	/**
	 * The name of the operation or command being executed.
	 *
	 * @example findAndModify
	 * @example HMSET
	 * @example SELECT
	 *
	 * @note It is **RECOMMENDED** to capture the value as provided by the application
	 * without attempting to do any case normalization.
	 *
	 * The operation name **SHOULD NOT** be extracted from `db.query.text`,
	 * when the database system supports query text with multiple operations
	 * in non-batch operations.
	 *
	 * If spaces can occur in the operation name, multiple consecutive spaces
	 * **SHOULD** be normalized to a single space.
	 *
	 * For batch operations, if the individual operations are known to have the same operation name
	 * then that operation name **SHOULD** be used prepended by `BATCH `,
	 * otherwise `db.operation.name` **SHOULD** be `BATCH` or some other database
	 * system specific term if more applicable.
	 */
	var ATTR_DB_OPERATION_NAME = 'db.operation.name';
	/**
	 * Low cardinality summary of a database query.
	 *
	 * @example SELECT wuser_table
	 * @example INSERT shipping_details SELECT orders
	 * @example get user by id
	 *
	 * @note The query summary describes a class of database queries and is useful
	 * as a grouping key, especially when analyzing telemetry for database
	 * calls involving complex queries.
	 *
	 * Summary may be available to the instrumentation through
	 * instrumentation hooks or other means. If it is not available, instrumentations
	 * that support query parsing **SHOULD** generate a summary following
	 * [Generating query summary](/docs/database/database-spans.md#generating-a-summary-of-the-query)
	 * section.
	 */
	var ATTR_DB_QUERY_SUMMARY = 'db.query.summary';
	/**
	 * The database query being executed.
	 *
	 * @example SELECT * FROM wuser_table where username = ?
	 * @example SET mykey ?
	 *
	 * @note For sanitization see [Sanitization of `db.query.text`](/docs/database/database-spans.md#sanitization-of-dbquerytext).
	 * For batch operations, if the individual operations are known to have the same query text then that query text **SHOULD** be used, otherwise all of the individual query texts **SHOULD** be concatenated with separator `; ` or some other database system specific separator if more applicable.
	 * Parameterized query text **SHOULD NOT** be sanitized. Even though parameterized query text can potentially have sensitive data, by using a parameterized query the user is giving a strong signal that any sensitive data will be passed as parameter values, and the benefit to observability of capturing the static part of the query text by default outweighs the risk.
	 */
	var ATTR_DB_QUERY_TEXT = 'db.query.text';
	/**
	 * Database response status code.
	 *
	 * @example 102
	 * @example ORA-17002
	 * @example 08P01
	 * @example 404
	 *
	 * @note The status code returned by the database. Usually it represents an error code, but may also represent partial success, warning, or differentiate between various types of successful outcomes.
	 * Semantic conventions for individual database systems **SHOULD** document what `db.response.status_code` means in the context of that system.
	 */
	var ATTR_DB_RESPONSE_STATUS_CODE = 'db.response.status_code';
	/**
	 * The name of a stored procedure within the database.
	 *
	 * @example GetCustomer
	 *
	 * @note It is **RECOMMENDED** to capture the value as provided by the application
	 * without attempting to do any case normalization.
	 *
	 * For batch operations, if the individual operations are known to have the same
	 * stored procedure name then that stored procedure name **SHOULD** be used.
	 */
	var ATTR_DB_STORED_PROCEDURE_NAME = 'db.stored_procedure.name';
	/**
	 * The database management system (DBMS) product as identified by the client instrumentation.
	 *
	 * @note The actual DBMS may differ from the one identified by the client. For example, when using PostgreSQL client libraries to connect to a CockroachDB, the `db.system.name` is set to `postgresql` based on the instrumentation's best knowledge.
	 */
	var ATTR_DB_SYSTEM_NAME = 'db.system.name';
	/**
	  * Enum value "actian.ingres" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_ACTIAN_INGRES = "actian.ingres";
	/**
	  * Enum value "aws.dynamodb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_AWS_DYNAMODB = "aws.dynamodb";
	/**
	  * Enum value "aws.redshift" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_AWS_REDSHIFT = "aws.redshift";
	/**
	  * Enum value "azure.cosmosdb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_AZURE_COSMOSDB = "azure.cosmosdb";
	/**
	  * Enum value "cassandra" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_CASSANDRA = "cassandra";
	/**
	  * Enum value "clickhouse" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_CLICKHOUSE = "clickhouse";
	/**
	  * Enum value "cockroachdb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_COCKROACHDB = "cockroachdb";
	/**
	  * Enum value "couchbase" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_COUCHBASE = "couchbase";
	/**
	  * Enum value "couchdb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_COUCHDB = "couchdb";
	/**
	  * Enum value "derby" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_DERBY = "derby";
	/**
	  * Enum value "elasticsearch" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_ELASTICSEARCH = "elasticsearch";
	/**
	  * Enum value "firebirdsql" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_FIREBIRDSQL = "firebirdsql";
	/**
	  * Enum value "gcp.spanner" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_GCP_SPANNER = "gcp.spanner";
	/**
	  * Enum value "geode" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_GEODE = "geode";
	/**
	  * Enum value "h2database" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_H2DATABASE = "h2database";
	/**
	  * Enum value "hbase" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_HBASE = "hbase";
	/**
	  * Enum value "hive" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_HIVE = "hive";
	/**
	  * Enum value "hsqldb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_HSQLDB = "hsqldb";
	/**
	  * Enum value "ibm.db2" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_IBM_DB2 = "ibm.db2";
	/**
	  * Enum value "ibm.informix" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_IBM_INFORMIX = "ibm.informix";
	/**
	  * Enum value "ibm.netezza" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_IBM_NETEZZA = "ibm.netezza";
	/**
	  * Enum value "influxdb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_INFLUXDB = "influxdb";
	/**
	  * Enum value "instantdb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_INSTANTDB = "instantdb";
	/**
	  * Enum value "intersystems.cache" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_INTERSYSTEMS_CACHE = "intersystems.cache";
	/**
	  * Enum value "mariadb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_MARIADB = "mariadb";
	/**
	  * Enum value "memcached" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_MEMCACHED = "memcached";
	/**
	  * Enum value "microsoft.sql_server" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_MICROSOFT_SQL_SERVER = "microsoft.sql_server";
	/**
	  * Enum value "mongodb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_MONGODB = "mongodb";
	/**
	  * Enum value "mysql" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_MYSQL = "mysql";
	/**
	  * Enum value "neo4j" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_NEO4J = "neo4j";
	/**
	  * Enum value "opensearch" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_OPENSEARCH = "opensearch";
	/**
	  * Enum value "oracle.db" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_ORACLE_DB = "oracle.db";
	/**
	  * Enum value "other_sql" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_OTHER_SQL = "other_sql";
	/**
	  * Enum value "postgresql" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_POSTGRESQL = "postgresql";
	/**
	  * Enum value "redis" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_REDIS = "redis";
	/**
	  * Enum value "sap.hana" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_SAP_HANA = "sap.hana";
	/**
	  * Enum value "sap.maxdb" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_SAP_MAXDB = "sap.maxdb";
	/**
	  * Enum value "softwareag.adabas" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_SOFTWAREAG_ADABAS = "softwareag.adabas";
	/**
	  * Enum value "sqlite" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_SQLITE = "sqlite";
	/**
	  * Enum value "teradata" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_TERADATA = "teradata";
	/**
	  * Enum value "trino" for attribute {@link ATTR_DB_SYSTEM_NAME}.
	  */
	var DB_SYSTEM_NAME_VALUE_TRINO = "trino";
	/**
	 * Name of the garbage collector managed heap generation.
	 *
	 * @example gen0
	 * @example gen1
	 * @example gen2
	 */
	var ATTR_DOTNET_GC_HEAP_GENERATION = 'dotnet.gc.heap.generation';
	/**
	  * Enum value "gen0" for attribute {@link ATTR_DOTNET_GC_HEAP_GENERATION}.
	  */
	var DOTNET_GC_HEAP_GENERATION_VALUE_GEN0 = "gen0";
	/**
	  * Enum value "gen1" for attribute {@link ATTR_DOTNET_GC_HEAP_GENERATION}.
	  */
	var DOTNET_GC_HEAP_GENERATION_VALUE_GEN1 = "gen1";
	/**
	  * Enum value "gen2" for attribute {@link ATTR_DOTNET_GC_HEAP_GENERATION}.
	  */
	var DOTNET_GC_HEAP_GENERATION_VALUE_GEN2 = "gen2";
	/**
	  * Enum value "loh" for attribute {@link ATTR_DOTNET_GC_HEAP_GENERATION}.
	  */
	var DOTNET_GC_HEAP_GENERATION_VALUE_LOH = "loh";
	/**
	  * Enum value "poh" for attribute {@link ATTR_DOTNET_GC_HEAP_GENERATION}.
	  */
	var DOTNET_GC_HEAP_GENERATION_VALUE_POH = "poh";
	/**
	 * Describes a class of error the operation ended with.
	 *
	 * @example timeout
	 * @example java.net.UnknownHostException
	 * @example server_certificate_invalid
	 * @example 500
	 *
	 * @note The `error.type` **SHOULD** be predictable, and **SHOULD** have low cardinality.
	 *
	 * When `error.type` is set to a type (e.g., an exception type), its
	 * canonical class name identifying the type within the artifact **SHOULD** be used.
	 *
	 * Instrumentations **SHOULD** document the list of errors they report.
	 *
	 * The cardinality of `error.type` within one instrumentation library **SHOULD** be low.
	 * Telemetry consumers that aggregate data from multiple instrumentation libraries and applications
	 * should be prepared for `error.type` to have high cardinality at query time when no
	 * additional filters are applied.
	 *
	 * If the operation has completed successfully, instrumentations **SHOULD NOT** set `error.type`.
	 *
	 * If a specific domain defines its own set of error identifiers (such as HTTP or gRPC status codes),
	 * it's **RECOMMENDED** to:
	 *
	 *   - Use a domain-specific attribute
	 *   - Set `error.type` to capture all errors, regardless of whether they are defined within the domain-specific set or not.
	 */
	var ATTR_ERROR_TYPE = 'error.type';
	/**
	  * Enum value "_OTHER" for attribute {@link ATTR_ERROR_TYPE}.
	  */
	var ERROR_TYPE_VALUE_OTHER = "_OTHER";
	/**
	 * Indicates that the exception is escaping the scope of the span.
	 *
	 * @deprecated It's no longer recommended to record exceptions that are handled and do not escape the scope of a span.
	 */
	var ATTR_EXCEPTION_ESCAPED = 'exception.escaped';
	/**
	 * The exception message.
	 *
	 * @example Division by zero
	 * @example Can't convert 'int' object to str implicitly
	 */
	var ATTR_EXCEPTION_MESSAGE = 'exception.message';
	/**
	 * A stacktrace as a string in the natural representation for the language runtime. The representation is to be determined and documented by each language SIG.
	 *
	 * @example "Exception in thread "main" java.lang.RuntimeException: Test exception\\n at com.example.GenerateTrace.methodB(GenerateTrace.java:13)\\n at com.example.GenerateTrace.methodA(GenerateTrace.java:9)\\n at com.example.GenerateTrace.main(GenerateTrace.java:5)\\n"
	 */
	var ATTR_EXCEPTION_STACKTRACE = 'exception.stacktrace';
	/**
	 * The type of the exception (its fully-qualified class name, if applicable). The dynamic type of the exception should be preferred over the static type in languages that support it.
	 *
	 * @example java.net.ConnectException
	 * @example OSError
	 */
	var ATTR_EXCEPTION_TYPE = 'exception.type';
	/**
	 * HTTP request headers, `<key>` being the normalized HTTP Header name (lowercase), the value being the header values.
	 *
	 * @example ["application/json"]
	 * @example ["1.2.3.4", "1.2.3.5"]
	 *
	 * @note Instrumentations **SHOULD** require an explicit configuration of which headers are to be captured.
	 * Including all request headers can be a security risk - explicit configuration helps avoid leaking sensitive information.
	 *
	 * The `User-Agent` header is already captured in the `user_agent.original` attribute.
	 * Users **MAY** explicitly configure instrumentations to capture them even though it is not recommended.
	 *
	 * The attribute value **MUST** consist of either multiple header values as an array of strings
	 * or a single-item array containing a possibly comma-concatenated string, depending on the way
	 * the HTTP library provides access to headers.
	 *
	 * Examples:
	 *
	 *   - A header `Content-Type: application/json` **SHOULD** be recorded as the `http.request.header.content-type`
	 *     attribute with value `["application/json"]`.
	 *   - A header `X-Forwarded-For: 1.2.3.4, 1.2.3.5` **SHOULD** be recorded as the `http.request.header.x-forwarded-for`
	 *     attribute with value `["1.2.3.4", "1.2.3.5"]` or `["1.2.3.4, 1.2.3.5"]` depending on the HTTP library.
	 */
	var ATTR_HTTP_REQUEST_HEADER = function ATTR_HTTP_REQUEST_HEADER(key) {
	  return "http.request.header.".concat(key);
	};
	/**
	 * HTTP request method.
	 *
	 * @example GET
	 * @example POST
	 * @example HEAD
	 *
	 * @note HTTP request method value **SHOULD** be "known" to the instrumentation.
	 * By default, this convention defines "known" methods as the ones listed in [RFC9110](https://www.rfc-editor.org/rfc/rfc9110.html#name-methods)
	 * and the PATCH method defined in [RFC5789](https://www.rfc-editor.org/rfc/rfc5789.html).
	 *
	 * If the HTTP request method is not known to instrumentation, it **MUST** set the `http.request.method` attribute to `_OTHER`.
	 *
	 * If the HTTP instrumentation could end up converting valid HTTP request methods to `_OTHER`, then it **MUST** provide a way to override
	 * the list of known HTTP methods. If this override is done via environment variable, then the environment variable **MUST** be named
	 * OTEL_INSTRUMENTATION_HTTP_KNOWN_METHODS and support a comma-separated list of case-sensitive known HTTP methods
	 * (this list **MUST** be a full override of the default known method, it is not a list of known methods in addition to the defaults).
	 *
	 * HTTP method names are case-sensitive and `http.request.method` attribute value **MUST** match a known HTTP method name exactly.
	 * Instrumentations for specific web frameworks that consider HTTP methods to be case insensitive, **SHOULD** populate a canonical equivalent.
	 * Tracing instrumentations that do so, **MUST** also set `http.request.method_original` to the original value.
	 */
	var ATTR_HTTP_REQUEST_METHOD = 'http.request.method';
	/**
	  * Enum value "_OTHER" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_OTHER = "_OTHER";
	/**
	  * Enum value "CONNECT" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_CONNECT = "CONNECT";
	/**
	  * Enum value "DELETE" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_DELETE = "DELETE";
	/**
	  * Enum value "GET" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_GET = "GET";
	/**
	  * Enum value "HEAD" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_HEAD = "HEAD";
	/**
	  * Enum value "OPTIONS" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_OPTIONS = "OPTIONS";
	/**
	  * Enum value "PATCH" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_PATCH = "PATCH";
	/**
	  * Enum value "POST" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_POST = "POST";
	/**
	  * Enum value "PUT" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_PUT = "PUT";
	/**
	  * Enum value "TRACE" for attribute {@link ATTR_HTTP_REQUEST_METHOD}.
	  */
	var HTTP_REQUEST_METHOD_VALUE_TRACE = "TRACE";
	/**
	 * Original HTTP method sent by the client in the request line.
	 *
	 * @example GeT
	 * @example ACL
	 * @example foo
	 */
	var ATTR_HTTP_REQUEST_METHOD_ORIGINAL = 'http.request.method_original';
	/**
	 * The ordinal number of request resending attempt (for any reason, including redirects).
	 *
	 * @example 3
	 *
	 * @note The resend count **SHOULD** be updated each time an HTTP request gets resent by the client, regardless of what was the cause of the resending (e.g. redirection, authorization failure, 503 Server Unavailable, network issues, or any other).
	 */
	var ATTR_HTTP_REQUEST_RESEND_COUNT = 'http.request.resend_count';
	/**
	 * HTTP response headers, `<key>` being the normalized HTTP Header name (lowercase), the value being the header values.
	 *
	 * @example ["application/json"]
	 * @example ["abc", "def"]
	 *
	 * @note Instrumentations **SHOULD** require an explicit configuration of which headers are to be captured.
	 * Including all response headers can be a security risk - explicit configuration helps avoid leaking sensitive information.
	 *
	 * Users **MAY** explicitly configure instrumentations to capture them even though it is not recommended.
	 *
	 * The attribute value **MUST** consist of either multiple header values as an array of strings
	 * or a single-item array containing a possibly comma-concatenated string, depending on the way
	 * the HTTP library provides access to headers.
	 *
	 * Examples:
	 *
	 *   - A header `Content-Type: application/json` header **SHOULD** be recorded as the `http.request.response.content-type`
	 *     attribute with value `["application/json"]`.
	 *   - A header `My-custom-header: abc, def` header **SHOULD** be recorded as the `http.response.header.my-custom-header`
	 *     attribute with value `["abc", "def"]` or `["abc, def"]` depending on the HTTP library.
	 */
	var ATTR_HTTP_RESPONSE_HEADER = function ATTR_HTTP_RESPONSE_HEADER(key) {
	  return "http.response.header.".concat(key);
	};
	/**
	 * [HTTP response status code](https://tools.ietf.org/html/rfc7231#section-6).
	 *
	 * @example 200
	 */
	var ATTR_HTTP_RESPONSE_STATUS_CODE = 'http.response.status_code';
	/**
	 * The matched route, that is, the path template in the format used by the respective server framework.
	 *
	 * @example /users/:userID?
	 * @example {controller}/{action}/{id?}
	 *
	 * @note **MUST NOT** be populated when this is not supported by the HTTP server framework as the route attribute should have low-cardinality and the URI path can NOT substitute it.
	 * **SHOULD** include the [application root](/docs/http/http-spans.md#http-server-definitions) if there is one.
	 */
	var ATTR_HTTP_ROUTE = 'http.route';
	/**
	 * Name of the garbage collector action.
	 *
	 * @example end of minor GC
	 * @example end of major GC
	 *
	 * @note Garbage collector action is generally obtained via [GarbageCollectionNotificationInfo#getGcAction()](https://docs.oracle.com/en/java/javase/11/docs/api/jdk.management/com/sun/management/GarbageCollectionNotificationInfo.html#getGcAction()).
	 */
	var ATTR_JVM_GC_ACTION = 'jvm.gc.action';
	/**
	 * Name of the garbage collector.
	 *
	 * @example G1 Young Generation
	 * @example G1 Old Generation
	 *
	 * @note Garbage collector name is generally obtained via [GarbageCollectionNotificationInfo#getGcName()](https://docs.oracle.com/en/java/javase/11/docs/api/jdk.management/com/sun/management/GarbageCollectionNotificationInfo.html#getGcName()).
	 */
	var ATTR_JVM_GC_NAME = 'jvm.gc.name';
	/**
	 * Name of the memory pool.
	 *
	 * @example G1 Old Gen
	 * @example G1 Eden space
	 * @example G1 Survivor Space
	 *
	 * @note Pool names are generally obtained via [MemoryPoolMXBean#getName()](https://docs.oracle.com/en/java/javase/11/docs/api/java.management/java/lang/management/MemoryPoolMXBean.html#getName()).
	 */
	var ATTR_JVM_MEMORY_POOL_NAME = 'jvm.memory.pool.name';
	/**
	 * The type of memory.
	 *
	 * @example heap
	 * @example non_heap
	 */
	var ATTR_JVM_MEMORY_TYPE = 'jvm.memory.type';
	/**
	  * Enum value "heap" for attribute {@link ATTR_JVM_MEMORY_TYPE}.
	  */
	var JVM_MEMORY_TYPE_VALUE_HEAP = "heap";
	/**
	  * Enum value "non_heap" for attribute {@link ATTR_JVM_MEMORY_TYPE}.
	  */
	var JVM_MEMORY_TYPE_VALUE_NON_HEAP = "non_heap";
	/**
	 * Whether the thread is daemon or not.
	 */
	var ATTR_JVM_THREAD_DAEMON = 'jvm.thread.daemon';
	/**
	 * State of the thread.
	 *
	 * @example runnable
	 * @example blocked
	 */
	var ATTR_JVM_THREAD_STATE = 'jvm.thread.state';
	/**
	  * Enum value "blocked" for attribute {@link ATTR_JVM_THREAD_STATE}.
	  */
	var JVM_THREAD_STATE_VALUE_BLOCKED = "blocked";
	/**
	  * Enum value "new" for attribute {@link ATTR_JVM_THREAD_STATE}.
	  */
	var JVM_THREAD_STATE_VALUE_NEW = "new";
	/**
	  * Enum value "runnable" for attribute {@link ATTR_JVM_THREAD_STATE}.
	  */
	var JVM_THREAD_STATE_VALUE_RUNNABLE = "runnable";
	/**
	  * Enum value "terminated" for attribute {@link ATTR_JVM_THREAD_STATE}.
	  */
	var JVM_THREAD_STATE_VALUE_TERMINATED = "terminated";
	/**
	  * Enum value "timed_waiting" for attribute {@link ATTR_JVM_THREAD_STATE}.
	  */
	var JVM_THREAD_STATE_VALUE_TIMED_WAITING = "timed_waiting";
	/**
	  * Enum value "waiting" for attribute {@link ATTR_JVM_THREAD_STATE}.
	  */
	var JVM_THREAD_STATE_VALUE_WAITING = "waiting";
	/**
	 * Local address of the network connection - IP address or Unix domain socket name.
	 *
	 * @example 10.1.2.80
	 * @example /tmp/my.sock
	 */
	var ATTR_NETWORK_LOCAL_ADDRESS = 'network.local.address';
	/**
	 * Local port number of the network connection.
	 *
	 * @example 65123
	 */
	var ATTR_NETWORK_LOCAL_PORT = 'network.local.port';
	/**
	 * Peer address of the network connection - IP address or Unix domain socket name.
	 *
	 * @example 10.1.2.80
	 * @example /tmp/my.sock
	 */
	var ATTR_NETWORK_PEER_ADDRESS = 'network.peer.address';
	/**
	 * Peer port number of the network connection.
	 *
	 * @example 65123
	 */
	var ATTR_NETWORK_PEER_PORT = 'network.peer.port';
	/**
	 * [OSI application layer](https://wikipedia.org/wiki/Application_layer) or non-OSI equivalent.
	 *
	 * @example amqp
	 * @example http
	 * @example mqtt
	 *
	 * @note The value **SHOULD** be normalized to lowercase.
	 */
	var ATTR_NETWORK_PROTOCOL_NAME = 'network.protocol.name';
	/**
	 * The actual version of the protocol used for network communication.
	 *
	 * @example 1.1
	 * @example 2
	 *
	 * @note If protocol version is subject to negotiation (for example using [ALPN](https://www.rfc-editor.org/rfc/rfc7301.html)), this attribute **SHOULD** be set to the negotiated version. If the actual protocol version is not known, this attribute **SHOULD NOT** be set.
	 */
	var ATTR_NETWORK_PROTOCOL_VERSION = 'network.protocol.version';
	/**
	 * [OSI transport layer](https://wikipedia.org/wiki/Transport_layer) or [inter-process communication method](https://wikipedia.org/wiki/Inter-process_communication).
	 *
	 * @example tcp
	 * @example udp
	 *
	 * @note The value **SHOULD** be normalized to lowercase.
	 *
	 * Consider always setting the transport when setting a port number, since
	 * a port number is ambiguous without knowing the transport. For example
	 * different processes could be listening on TCP port 12345 and UDP port 12345.
	 */
	var ATTR_NETWORK_TRANSPORT = 'network.transport';
	/**
	  * Enum value "pipe" for attribute {@link ATTR_NETWORK_TRANSPORT}.
	  */
	var NETWORK_TRANSPORT_VALUE_PIPE = "pipe";
	/**
	  * Enum value "quic" for attribute {@link ATTR_NETWORK_TRANSPORT}.
	  */
	var NETWORK_TRANSPORT_VALUE_QUIC = "quic";
	/**
	  * Enum value "tcp" for attribute {@link ATTR_NETWORK_TRANSPORT}.
	  */
	var NETWORK_TRANSPORT_VALUE_TCP = "tcp";
	/**
	  * Enum value "udp" for attribute {@link ATTR_NETWORK_TRANSPORT}.
	  */
	var NETWORK_TRANSPORT_VALUE_UDP = "udp";
	/**
	  * Enum value "unix" for attribute {@link ATTR_NETWORK_TRANSPORT}.
	  */
	var NETWORK_TRANSPORT_VALUE_UNIX = "unix";
	/**
	 * [OSI network layer](https://wikipedia.org/wiki/Network_layer) or non-OSI equivalent.
	 *
	 * @example ipv4
	 * @example ipv6
	 *
	 * @note The value **SHOULD** be normalized to lowercase.
	 */
	var ATTR_NETWORK_TYPE = 'network.type';
	/**
	  * Enum value "ipv4" for attribute {@link ATTR_NETWORK_TYPE}.
	  */
	var NETWORK_TYPE_VALUE_IPV4 = "ipv4";
	/**
	  * Enum value "ipv6" for attribute {@link ATTR_NETWORK_TYPE}.
	  */
	var NETWORK_TYPE_VALUE_IPV6 = "ipv6";
	/**
	 * The name of the instrumentation scope - (`InstrumentationScope.Name` in OTLP).
	 *
	 * @example io.opentelemetry.contrib.mongodb
	 */
	var ATTR_OTEL_SCOPE_NAME = 'otel.scope.name';
	/**
	 * The version of the instrumentation scope - (`InstrumentationScope.Version` in OTLP).
	 *
	 * @example 1.0.0
	 */
	var ATTR_OTEL_SCOPE_VERSION = 'otel.scope.version';
	/**
	 * Name of the code, either "OK" or "ERROR". **MUST NOT** be set if the status code is UNSET.
	 */
	var ATTR_OTEL_STATUS_CODE = 'otel.status_code';
	/**
	  * Enum value "ERROR" for attribute {@link ATTR_OTEL_STATUS_CODE}.
	  */
	var OTEL_STATUS_CODE_VALUE_ERROR = "ERROR";
	/**
	  * Enum value "OK" for attribute {@link ATTR_OTEL_STATUS_CODE}.
	  */
	var OTEL_STATUS_CODE_VALUE_OK = "OK";
	/**
	 * Description of the Status if it has a value, otherwise not set.
	 *
	 * @example resource not found
	 */
	var ATTR_OTEL_STATUS_DESCRIPTION = 'otel.status_description';
	/**
	 * Server domain name if available without reverse DNS lookup; otherwise, IP address or Unix domain socket name.
	 *
	 * @example example.com
	 * @example 10.1.2.80
	 * @example /tmp/my.sock
	 *
	 * @note When observed from the client side, and when communicating through an intermediary, `server.address` **SHOULD** represent the server address behind any intermediaries, for example proxies, if it's available.
	 */
	var ATTR_SERVER_ADDRESS = 'server.address';
	/**
	 * Server port number.
	 *
	 * @example 80
	 * @example 8080
	 * @example 443
	 *
	 * @note When observed from the client side, and when communicating through an intermediary, `server.port` **SHOULD** represent the server port behind any intermediaries, for example proxies, if it's available.
	 */
	var ATTR_SERVER_PORT = 'server.port';
	/**
	 * Logical name of the service.
	 *
	 * @example shoppingcart
	 *
	 * @note **MUST** be the same for all instances of horizontally scaled services. If the value was not specified, SDKs **MUST** fallback to `unknown_service:` concatenated with [`process.executable.name`](process.md), e.g. `unknown_service:bash`. If `process.executable.name` is not available, the value **MUST** be set to `unknown_service`.
	 */
	var ATTR_SERVICE_NAME = 'service.name';
	/**
	 * The version string of the service API or implementation. The format is not defined by these conventions.
	 *
	 * @example 2.0.0
	 * @example a01dbef8a
	 */
	var ATTR_SERVICE_VERSION = 'service.version';
	/**
	 * SignalR HTTP connection closure status.
	 *
	 * @example app_shutdown
	 * @example timeout
	 */
	var ATTR_SIGNALR_CONNECTION_STATUS = 'signalr.connection.status';
	/**
	  * Enum value "app_shutdown" for attribute {@link ATTR_SIGNALR_CONNECTION_STATUS}.
	  */
	var SIGNALR_CONNECTION_STATUS_VALUE_APP_SHUTDOWN = "app_shutdown";
	/**
	  * Enum value "normal_closure" for attribute {@link ATTR_SIGNALR_CONNECTION_STATUS}.
	  */
	var SIGNALR_CONNECTION_STATUS_VALUE_NORMAL_CLOSURE = "normal_closure";
	/**
	  * Enum value "timeout" for attribute {@link ATTR_SIGNALR_CONNECTION_STATUS}.
	  */
	var SIGNALR_CONNECTION_STATUS_VALUE_TIMEOUT = "timeout";
	/**
	 * [SignalR transport type](https://github.com/dotnet/aspnetcore/blob/main/src/SignalR/docs/specs/TransportProtocols.md)
	 *
	 * @example web_sockets
	 * @example long_polling
	 */
	var ATTR_SIGNALR_TRANSPORT = 'signalr.transport';
	/**
	  * Enum value "long_polling" for attribute {@link ATTR_SIGNALR_TRANSPORT}.
	  */
	var SIGNALR_TRANSPORT_VALUE_LONG_POLLING = "long_polling";
	/**
	  * Enum value "server_sent_events" for attribute {@link ATTR_SIGNALR_TRANSPORT}.
	  */
	var SIGNALR_TRANSPORT_VALUE_SERVER_SENT_EVENTS = "server_sent_events";
	/**
	  * Enum value "web_sockets" for attribute {@link ATTR_SIGNALR_TRANSPORT}.
	  */
	var SIGNALR_TRANSPORT_VALUE_WEB_SOCKETS = "web_sockets";
	/**
	 * The language of the telemetry SDK.
	 */
	var ATTR_TELEMETRY_SDK_LANGUAGE = 'telemetry.sdk.language';
	/**
	  * Enum value "cpp" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_CPP = "cpp";
	/**
	  * Enum value "dotnet" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_DOTNET = "dotnet";
	/**
	  * Enum value "erlang" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_ERLANG = "erlang";
	/**
	  * Enum value "go" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_GO = "go";
	/**
	  * Enum value "java" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_JAVA = "java";
	/**
	  * Enum value "nodejs" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_NODEJS = "nodejs";
	/**
	  * Enum value "php" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_PHP = "php";
	/**
	  * Enum value "python" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_PYTHON = "python";
	/**
	  * Enum value "ruby" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_RUBY = "ruby";
	/**
	  * Enum value "rust" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_RUST = "rust";
	/**
	  * Enum value "swift" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_SWIFT = "swift";
	/**
	  * Enum value "webjs" for attribute {@link ATTR_TELEMETRY_SDK_LANGUAGE}.
	  */
	var TELEMETRY_SDK_LANGUAGE_VALUE_WEBJS = "webjs";
	/**
	 * The name of the telemetry SDK as defined above.
	 *
	 * @example opentelemetry
	 *
	 * @note The OpenTelemetry SDK **MUST** set the `telemetry.sdk.name` attribute to `opentelemetry`.
	 * If another SDK, like a fork or a vendor-provided implementation, is used, this SDK **MUST** set the
	 * `telemetry.sdk.name` attribute to the fully-qualified class or module name of this SDK's main entry point
	 * or another suitable identifier depending on the language.
	 * The identifier `opentelemetry` is reserved and **MUST NOT** be used in this case.
	 * All custom identifiers **SHOULD** be stable across different versions of an implementation.
	 */
	var ATTR_TELEMETRY_SDK_NAME = 'telemetry.sdk.name';
	/**
	 * The version string of the telemetry SDK.
	 *
	 * @example 1.2.3
	 */
	var ATTR_TELEMETRY_SDK_VERSION = 'telemetry.sdk.version';
	/**
	 * The [URI fragment](https://www.rfc-editor.org/rfc/rfc3986#section-3.5) component
	 *
	 * @example SemConv
	 */
	var ATTR_URL_FRAGMENT = 'url.fragment';
	/**
	 * Absolute URL describing a network resource according to [RFC3986](https://www.rfc-editor.org/rfc/rfc3986)
	 *
	 * @example https://www.foo.bar/search?q=OpenTelemetry#SemConv
	 * @example //localhost
	 *
	 * @note For network calls, URL usually has `scheme://host[:port][path][?query][#fragment]` format, where the fragment
	 * is not transmitted over HTTP, but if it is known, it **SHOULD** be included nevertheless.
	 *
	 * `url.full` **MUST NOT** contain credentials passed via URL in form of `https://username:password@www.example.com/`.
	 * In such case username and password **SHOULD** be redacted and attribute's value **SHOULD** be `https://REDACTED:REDACTED@www.example.com/`.
	 *
	 * `url.full` **SHOULD** capture the absolute URL when it is available (or can be reconstructed).
	 *
	 * Sensitive content provided in `url.full` **SHOULD** be scrubbed when instrumentations can identify it.
	 *
	 *
	 * Query string values for the following keys **SHOULD** be redacted by default and replaced by the
	 * value `REDACTED`:
	 *
	 *   - [`AWSAccessKeyId`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html#RESTAuthenticationQueryStringAuth)
	 *   - [`Signature`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html#RESTAuthenticationQueryStringAuth)
	 *   - [`sig`](https://learn.microsoft.com/azure/storage/common/storage-sas-overview#sas-token)
	 *   - [`X-Goog-Signature`](https://cloud.google.com/storage/docs/access-control/signed-urls)
	 *
	 * This list is subject to change over time.
	 *
	 * When a query string value is redacted, the query string key **SHOULD** still be preserved, e.g.
	 * `https://www.example.com/path?color=blue&sig=REDACTED`.
	 */
	var ATTR_URL_FULL = 'url.full';
	/**
	 * The [URI path](https://www.rfc-editor.org/rfc/rfc3986#section-3.3) component
	 *
	 * @example /search
	 *
	 * @note Sensitive content provided in `url.path` **SHOULD** be scrubbed when instrumentations can identify it.
	 */
	var ATTR_URL_PATH = 'url.path';
	/**
	 * The [URI query](https://www.rfc-editor.org/rfc/rfc3986#section-3.4) component
	 *
	 * @example q=OpenTelemetry
	 *
	 * @note Sensitive content provided in `url.query` **SHOULD** be scrubbed when instrumentations can identify it.
	 *
	 *
	 * Query string values for the following keys **SHOULD** be redacted by default and replaced by the value `REDACTED`:
	 *
	 *   - [`AWSAccessKeyId`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html#RESTAuthenticationQueryStringAuth)
	 *   - [`Signature`](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html#RESTAuthenticationQueryStringAuth)
	 *   - [`sig`](https://learn.microsoft.com/azure/storage/common/storage-sas-overview#sas-token)
	 *   - [`X-Goog-Signature`](https://cloud.google.com/storage/docs/access-control/signed-urls)
	 *
	 * This list is subject to change over time.
	 *
	 * When a query string value is redacted, the query string key **SHOULD** still be preserved, e.g.
	 * `q=OpenTelemetry&sig=REDACTED`.
	 */
	var ATTR_URL_QUERY = 'url.query';
	/**
	 * The [URI scheme](https://www.rfc-editor.org/rfc/rfc3986#section-3.1) component identifying the used protocol.
	 *
	 * @example https
	 * @example ftp
	 * @example telnet
	 */
	var ATTR_URL_SCHEME = 'url.scheme';
	/**
	 * Value of the [HTTP User-Agent](https://www.rfc-editor.org/rfc/rfc9110.html#field.user-agent) header sent by the client.
	 *
	 * @example CERN-LineMode/2.15 libwww/2.17b3
	 * @example Mozilla/5.0 (iPhone; CPU iPhone OS 14_7_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/14.1.2 Mobile/15E148 Safari/604.1
	 * @example YourApp/1.0.0 grpc-java-okhttp/1.27.2
	 */
	var ATTR_USER_AGENT_ORIGINAL = 'user_agent.original';

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	//----------------------------------------------------------------------------------------------------------
	// DO NOT EDIT, this is an Auto-generated file from scripts/semconv/templates/register/stable/metrics.ts.j2
	//----------------------------------------------------------------------------------------------------------
	/**
	 * Number of exceptions caught by exception handling middleware.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Diagnostics`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_ASPNETCORE_DIAGNOSTICS_EXCEPTIONS = 'aspnetcore.diagnostics.exceptions';
	/**
	 * Number of requests that are currently active on the server that hold a rate limiting lease.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.RateLimiting`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_ASPNETCORE_RATE_LIMITING_ACTIVE_REQUEST_LEASES = 'aspnetcore.rate_limiting.active_request_leases';
	/**
	 * Number of requests that are currently queued, waiting to acquire a rate limiting lease.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.RateLimiting`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_ASPNETCORE_RATE_LIMITING_QUEUED_REQUESTS = 'aspnetcore.rate_limiting.queued_requests';
	/**
	 * The time the request spent in a queue waiting to acquire a rate limiting lease.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.RateLimiting`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_ASPNETCORE_RATE_LIMITING_REQUEST_TIME_IN_QUEUE = 'aspnetcore.rate_limiting.request.time_in_queue';
	/**
	 * The duration of rate limiting lease held by requests on the server.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.RateLimiting`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_ASPNETCORE_RATE_LIMITING_REQUEST_LEASE_DURATION = 'aspnetcore.rate_limiting.request_lease.duration';
	/**
	 * Number of requests that tried to acquire a rate limiting lease.
	 *
	 * @note Requests could be:
	 *
	 *   - Rejected by global or endpoint rate limiting policies
	 *   - Canceled while waiting for the lease.
	 *
	 * Meter name: `Microsoft.AspNetCore.RateLimiting`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_ASPNETCORE_RATE_LIMITING_REQUESTS = 'aspnetcore.rate_limiting.requests';
	/**
	 * Number of requests that were attempted to be matched to an endpoint.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Routing`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_ASPNETCORE_ROUTING_MATCH_ATTEMPTS = 'aspnetcore.routing.match_attempts';
	/**
	 * Duration of database client operations.
	 *
	 * @note Batch operations **SHOULD** be recorded as a single operation.
	 */
	var METRIC_DB_CLIENT_OPERATION_DURATION = 'db.client.operation.duration';
	/**
	 * The number of .NET assemblies that are currently loaded.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`AppDomain.CurrentDomain.GetAssemblies().Length`](https://learn.microsoft.com/dotnet/api/system.appdomain.getassemblies).
	 */
	var METRIC_DOTNET_ASSEMBLY_COUNT = 'dotnet.assembly.count';
	/**
	 * The number of exceptions that have been thrown in managed code.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as counting calls to [`AppDomain.CurrentDomain.FirstChanceException`](https://learn.microsoft.com/dotnet/api/system.appdomain.firstchanceexception).
	 */
	var METRIC_DOTNET_EXCEPTIONS = 'dotnet.exceptions';
	/**
	 * The number of garbage collections that have occurred since the process has started.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric uses the [`GC.CollectionCount(int generation)`](https://learn.microsoft.com/dotnet/api/system.gc.collectioncount) API to calculate exclusive collections per generation.
	 */
	var METRIC_DOTNET_GC_COLLECTIONS = 'dotnet.gc.collections';
	/**
	 * The *approximate* number of bytes allocated on the managed GC heap since the process has started. The returned value does not include any native allocations.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`GC.GetTotalAllocatedBytes()`](https://learn.microsoft.com/dotnet/api/system.gc.gettotalallocatedbytes).
	 */
	var METRIC_DOTNET_GC_HEAP_TOTAL_ALLOCATED = 'dotnet.gc.heap.total_allocated';
	/**
	 * The heap fragmentation, as observed during the latest garbage collection.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`GC.GetGCMemoryInfo().GenerationInfo.FragmentationAfterBytes`](https://learn.microsoft.com/dotnet/api/system.gcgenerationinfo.fragmentationafterbytes).
	 */
	var METRIC_DOTNET_GC_LAST_COLLECTION_HEAP_FRAGMENTATION_SIZE = 'dotnet.gc.last_collection.heap.fragmentation.size';
	/**
	 * The managed GC heap size (including fragmentation), as observed during the latest garbage collection.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`GC.GetGCMemoryInfo().GenerationInfo.SizeAfterBytes`](https://learn.microsoft.com/dotnet/api/system.gcgenerationinfo.sizeafterbytes).
	 */
	var METRIC_DOTNET_GC_LAST_COLLECTION_HEAP_SIZE = 'dotnet.gc.last_collection.heap.size';
	/**
	 * The amount of committed virtual memory in use by the .NET GC, as observed during the latest garbage collection.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`GC.GetGCMemoryInfo().TotalCommittedBytes`](https://learn.microsoft.com/dotnet/api/system.gcmemoryinfo.totalcommittedbytes). Committed virtual memory may be larger than the heap size because it includes both memory for storing existing objects (the heap size) and some extra memory that is ready to handle newly allocated objects in the future.
	 */
	var METRIC_DOTNET_GC_LAST_COLLECTION_MEMORY_COMMITTED_SIZE = 'dotnet.gc.last_collection.memory.committed_size';
	/**
	 * The total amount of time paused in GC since the process has started.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`GC.GetTotalPauseDuration()`](https://learn.microsoft.com/dotnet/api/system.gc.gettotalpauseduration).
	 */
	var METRIC_DOTNET_GC_PAUSE_TIME = 'dotnet.gc.pause.time';
	/**
	 * The amount of time the JIT compiler has spent compiling methods since the process has started.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`JitInfo.GetCompilationTime()`](https://learn.microsoft.com/dotnet/api/system.runtime.jitinfo.getcompilationtime).
	 */
	var METRIC_DOTNET_JIT_COMPILATION_TIME = 'dotnet.jit.compilation.time';
	/**
	 * Count of bytes of intermediate language that have been compiled since the process has started.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`JitInfo.GetCompiledILBytes()`](https://learn.microsoft.com/dotnet/api/system.runtime.jitinfo.getcompiledilbytes).
	 */
	var METRIC_DOTNET_JIT_COMPILED_IL_SIZE = 'dotnet.jit.compiled_il.size';
	/**
	 * The number of times the JIT compiler (re)compiled methods since the process has started.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`JitInfo.GetCompiledMethodCount()`](https://learn.microsoft.com/dotnet/api/system.runtime.jitinfo.getcompiledmethodcount).
	 */
	var METRIC_DOTNET_JIT_COMPILED_METHODS = 'dotnet.jit.compiled_methods';
	/**
	 * The number of times there was contention when trying to acquire a monitor lock since the process has started.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`Monitor.LockContentionCount`](https://learn.microsoft.com/dotnet/api/system.threading.monitor.lockcontentioncount).
	 */
	var METRIC_DOTNET_MONITOR_LOCK_CONTENTIONS = 'dotnet.monitor.lock_contentions';
	/**
	 * The number of processors available to the process.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as accessing [`Environment.ProcessorCount`](https://learn.microsoft.com/dotnet/api/system.environment.processorcount).
	 */
	var METRIC_DOTNET_PROCESS_CPU_COUNT = 'dotnet.process.cpu.count';
	/**
	 * CPU time used by the process.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as accessing the corresponding processor time properties on [`System.Diagnostics.Process`](https://learn.microsoft.com/dotnet/api/system.diagnostics.process).
	 */
	var METRIC_DOTNET_PROCESS_CPU_TIME = 'dotnet.process.cpu.time';
	/**
	 * The number of bytes of physical memory mapped to the process context.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`Environment.WorkingSet`](https://learn.microsoft.com/dotnet/api/system.environment.workingset).
	 */
	var METRIC_DOTNET_PROCESS_MEMORY_WORKING_SET = 'dotnet.process.memory.working_set';
	/**
	 * The number of work items that are currently queued to be processed by the thread pool.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`ThreadPool.PendingWorkItemCount`](https://learn.microsoft.com/dotnet/api/system.threading.threadpool.pendingworkitemcount).
	 */
	var METRIC_DOTNET_THREAD_POOL_QUEUE_LENGTH = 'dotnet.thread_pool.queue.length';
	/**
	 * The number of thread pool threads that currently exist.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`ThreadPool.ThreadCount`](https://learn.microsoft.com/dotnet/api/system.threading.threadpool.threadcount).
	 */
	var METRIC_DOTNET_THREAD_POOL_THREAD_COUNT = 'dotnet.thread_pool.thread.count';
	/**
	 * The number of work items that the thread pool has completed since the process has started.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`ThreadPool.CompletedWorkItemCount`](https://learn.microsoft.com/dotnet/api/system.threading.threadpool.completedworkitemcount).
	 */
	var METRIC_DOTNET_THREAD_POOL_WORK_ITEM_COUNT = 'dotnet.thread_pool.work_item.count';
	/**
	 * The number of timer instances that are currently active.
	 *
	 * @note Meter name: `System.Runtime`; Added in: .NET 9.0.
	 * This metric reports the same values as calling [`Timer.ActiveCount`](https://learn.microsoft.com/dotnet/api/system.threading.timer.activecount).
	 */
	var METRIC_DOTNET_TIMER_COUNT = 'dotnet.timer.count';
	/**
	 * Duration of HTTP client requests.
	 */
	var METRIC_HTTP_CLIENT_REQUEST_DURATION = 'http.client.request.duration';
	/**
	 * Duration of HTTP server requests.
	 */
	var METRIC_HTTP_SERVER_REQUEST_DURATION = 'http.server.request.duration';
	/**
	 * Number of classes currently loaded.
	 */
	var METRIC_JVM_CLASS_COUNT = 'jvm.class.count';
	/**
	 * Number of classes loaded since JVM start.
	 */
	var METRIC_JVM_CLASS_LOADED = 'jvm.class.loaded';
	/**
	 * Number of classes unloaded since JVM start.
	 */
	var METRIC_JVM_CLASS_UNLOADED = 'jvm.class.unloaded';
	/**
	 * Number of processors available to the Java virtual machine.
	 */
	var METRIC_JVM_CPU_COUNT = 'jvm.cpu.count';
	/**
	 * Recent CPU utilization for the process as reported by the JVM.
	 *
	 * @note The value range is [0.0,1.0]. This utilization is not defined as being for the specific interval since last measurement (unlike `system.cpu.utilization`). [Reference](https://docs.oracle.com/en/java/javase/17/docs/api/jdk.management/com/sun/management/OperatingSystemMXBean.html#getProcessCpuLoad()).
	 */
	var METRIC_JVM_CPU_RECENT_UTILIZATION = 'jvm.cpu.recent_utilization';
	/**
	 * CPU time used by the process as reported by the JVM.
	 */
	var METRIC_JVM_CPU_TIME = 'jvm.cpu.time';
	/**
	 * Duration of JVM garbage collection actions.
	 */
	var METRIC_JVM_GC_DURATION = 'jvm.gc.duration';
	/**
	 * Measure of memory committed.
	 */
	var METRIC_JVM_MEMORY_COMMITTED = 'jvm.memory.committed';
	/**
	 * Measure of max obtainable memory.
	 */
	var METRIC_JVM_MEMORY_LIMIT = 'jvm.memory.limit';
	/**
	 * Measure of memory used.
	 */
	var METRIC_JVM_MEMORY_USED = 'jvm.memory.used';
	/**
	 * Measure of memory used, as measured after the most recent garbage collection event on this pool.
	 */
	var METRIC_JVM_MEMORY_USED_AFTER_LAST_GC = 'jvm.memory.used_after_last_gc';
	/**
	 * Number of executing platform threads.
	 */
	var METRIC_JVM_THREAD_COUNT = 'jvm.thread.count';
	/**
	 * Number of connections that are currently active on the server.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_KESTREL_ACTIVE_CONNECTIONS = 'kestrel.active_connections';
	/**
	 * Number of TLS handshakes that are currently in progress on the server.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_KESTREL_ACTIVE_TLS_HANDSHAKES = 'kestrel.active_tls_handshakes';
	/**
	 * The duration of connections on the server.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_KESTREL_CONNECTION_DURATION = 'kestrel.connection.duration';
	/**
	 * Number of connections that are currently queued and are waiting to start.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_KESTREL_QUEUED_CONNECTIONS = 'kestrel.queued_connections';
	/**
	 * Number of HTTP requests on multiplexed connections (HTTP/2 and HTTP/3) that are currently queued and are waiting to start.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_KESTREL_QUEUED_REQUESTS = 'kestrel.queued_requests';
	/**
	 * Number of connections rejected by the server.
	 *
	 * @note Connections are rejected when the currently active count exceeds the value configured with `MaxConcurrentConnections`.
	 * Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_KESTREL_REJECTED_CONNECTIONS = 'kestrel.rejected_connections';
	/**
	 * The duration of TLS handshakes on the server.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_KESTREL_TLS_HANDSHAKE_DURATION = 'kestrel.tls_handshake.duration';
	/**
	 * Number of connections that are currently upgraded (WebSockets). .
	 *
	 * @note The counter only tracks HTTP/1.1 connections.
	 *
	 * Meter name: `Microsoft.AspNetCore.Server.Kestrel`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_KESTREL_UPGRADED_CONNECTIONS = 'kestrel.upgraded_connections';
	/**
	 * Number of connections that are currently active on the server.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Http.Connections`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_SIGNALR_SERVER_ACTIVE_CONNECTIONS = 'signalr.server.active_connections';
	/**
	 * The duration of connections on the server.
	 *
	 * @note Meter name: `Microsoft.AspNetCore.Http.Connections`; Added in: ASP.NET Core 8.0
	 */
	var METRIC_SIGNALR_SERVER_CONNECTION_DURATION = 'signalr.server.connection.duration';

	/*
	 * Copyright The OpenTelemetry Authors
	 *
	 * Licensed under the Apache License, Version 2.0 (the "License");
	 * you may not use this file except in compliance with the License.
	 * You may obtain a copy of the License at
	 *
	 *      https://www.apache.org/licenses/LICENSE-2.0
	 *
	 * Unless required by applicable law or agreed to in writing, software
	 * distributed under the License is distributed on an "AS IS" BASIS,
	 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	 * See the License for the specific language governing permissions and
	 * limitations under the License.
	 */
	/* eslint-disable no-restricted-syntax --
	 * These re-exports are only of constants, only two-levels deep, and
	 * should not cause problems for tree-shakers.
	 */
	// Deprecated. These are kept around for compatibility purposes

	var esm$c = /*#__PURE__*/Object.freeze({
		__proto__: null,
		ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_ABORTED: ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_ABORTED,
		ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_HANDLED: ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_HANDLED,
		ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_SKIPPED: ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_SKIPPED,
		ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_UNHANDLED: ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT_VALUE_UNHANDLED,
		ASPNETCORE_RATE_LIMITING_RESULT_VALUE_ACQUIRED: ASPNETCORE_RATE_LIMITING_RESULT_VALUE_ACQUIRED,
		ASPNETCORE_RATE_LIMITING_RESULT_VALUE_ENDPOINT_LIMITER: ASPNETCORE_RATE_LIMITING_RESULT_VALUE_ENDPOINT_LIMITER,
		ASPNETCORE_RATE_LIMITING_RESULT_VALUE_GLOBAL_LIMITER: ASPNETCORE_RATE_LIMITING_RESULT_VALUE_GLOBAL_LIMITER,
		ASPNETCORE_RATE_LIMITING_RESULT_VALUE_REQUEST_CANCELED: ASPNETCORE_RATE_LIMITING_RESULT_VALUE_REQUEST_CANCELED,
		ASPNETCORE_ROUTING_MATCH_STATUS_VALUE_FAILURE: ASPNETCORE_ROUTING_MATCH_STATUS_VALUE_FAILURE,
		ASPNETCORE_ROUTING_MATCH_STATUS_VALUE_SUCCESS: ASPNETCORE_ROUTING_MATCH_STATUS_VALUE_SUCCESS,
		ATTR_ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT: ATTR_ASPNETCORE_DIAGNOSTICS_EXCEPTION_RESULT,
		ATTR_ASPNETCORE_DIAGNOSTICS_HANDLER_TYPE: ATTR_ASPNETCORE_DIAGNOSTICS_HANDLER_TYPE,
		ATTR_ASPNETCORE_RATE_LIMITING_POLICY: ATTR_ASPNETCORE_RATE_LIMITING_POLICY,
		ATTR_ASPNETCORE_RATE_LIMITING_RESULT: ATTR_ASPNETCORE_RATE_LIMITING_RESULT,
		ATTR_ASPNETCORE_REQUEST_IS_UNHANDLED: ATTR_ASPNETCORE_REQUEST_IS_UNHANDLED,
		ATTR_ASPNETCORE_ROUTING_IS_FALLBACK: ATTR_ASPNETCORE_ROUTING_IS_FALLBACK,
		ATTR_ASPNETCORE_ROUTING_MATCH_STATUS: ATTR_ASPNETCORE_ROUTING_MATCH_STATUS,
		ATTR_CLIENT_ADDRESS: ATTR_CLIENT_ADDRESS,
		ATTR_CLIENT_PORT: ATTR_CLIENT_PORT,
		ATTR_CODE_COLUMN_NUMBER: ATTR_CODE_COLUMN_NUMBER,
		ATTR_CODE_FILE_PATH: ATTR_CODE_FILE_PATH,
		ATTR_CODE_FUNCTION_NAME: ATTR_CODE_FUNCTION_NAME,
		ATTR_CODE_LINE_NUMBER: ATTR_CODE_LINE_NUMBER,
		ATTR_CODE_STACKTRACE: ATTR_CODE_STACKTRACE,
		ATTR_DB_COLLECTION_NAME: ATTR_DB_COLLECTION_NAME,
		ATTR_DB_NAMESPACE: ATTR_DB_NAMESPACE,
		ATTR_DB_OPERATION_BATCH_SIZE: ATTR_DB_OPERATION_BATCH_SIZE,
		ATTR_DB_OPERATION_NAME: ATTR_DB_OPERATION_NAME,
		ATTR_DB_QUERY_SUMMARY: ATTR_DB_QUERY_SUMMARY,
		ATTR_DB_QUERY_TEXT: ATTR_DB_QUERY_TEXT,
		ATTR_DB_RESPONSE_STATUS_CODE: ATTR_DB_RESPONSE_STATUS_CODE,
		ATTR_DB_STORED_PROCEDURE_NAME: ATTR_DB_STORED_PROCEDURE_NAME,
		ATTR_DB_SYSTEM_NAME: ATTR_DB_SYSTEM_NAME,
		ATTR_DOTNET_GC_HEAP_GENERATION: ATTR_DOTNET_GC_HEAP_GENERATION,
		ATTR_ERROR_TYPE: ATTR_ERROR_TYPE,
		ATTR_EXCEPTION_ESCAPED: ATTR_EXCEPTION_ESCAPED,
		ATTR_EXCEPTION_MESSAGE: ATTR_EXCEPTION_MESSAGE,
		ATTR_EXCEPTION_STACKTRACE: ATTR_EXCEPTION_STACKTRACE,
		ATTR_EXCEPTION_TYPE: ATTR_EXCEPTION_TYPE,
		ATTR_HTTP_REQUEST_HEADER: ATTR_HTTP_REQUEST_HEADER,
		ATTR_HTTP_REQUEST_METHOD: ATTR_HTTP_REQUEST_METHOD,
		ATTR_HTTP_REQUEST_METHOD_ORIGINAL: ATTR_HTTP_REQUEST_METHOD_ORIGINAL,
		ATTR_HTTP_REQUEST_RESEND_COUNT: ATTR_HTTP_REQUEST_RESEND_COUNT,
		ATTR_HTTP_RESPONSE_HEADER: ATTR_HTTP_RESPONSE_HEADER,
		ATTR_HTTP_RESPONSE_STATUS_CODE: ATTR_HTTP_RESPONSE_STATUS_CODE,
		ATTR_HTTP_ROUTE: ATTR_HTTP_ROUTE,
		ATTR_JVM_GC_ACTION: ATTR_JVM_GC_ACTION,
		ATTR_JVM_GC_NAME: ATTR_JVM_GC_NAME,
		ATTR_JVM_MEMORY_POOL_NAME: ATTR_JVM_MEMORY_POOL_NAME,
		ATTR_JVM_MEMORY_TYPE: ATTR_JVM_MEMORY_TYPE,
		ATTR_JVM_THREAD_DAEMON: ATTR_JVM_THREAD_DAEMON,
		ATTR_JVM_THREAD_STATE: ATTR_JVM_THREAD_STATE,
		ATTR_NETWORK_LOCAL_ADDRESS: ATTR_NETWORK_LOCAL_ADDRESS,
		ATTR_NETWORK_LOCAL_PORT: ATTR_NETWORK_LOCAL_PORT,
		ATTR_NETWORK_PEER_ADDRESS: ATTR_NETWORK_PEER_ADDRESS,
		ATTR_NETWORK_PEER_PORT: ATTR_NETWORK_PEER_PORT,
		ATTR_NETWORK_PROTOCOL_NAME: ATTR_NETWORK_PROTOCOL_NAME,
		ATTR_NETWORK_PROTOCOL_VERSION: ATTR_NETWORK_PROTOCOL_VERSION,
		ATTR_NETWORK_TRANSPORT: ATTR_NETWORK_TRANSPORT,
		ATTR_NETWORK_TYPE: ATTR_NETWORK_TYPE,
		ATTR_OTEL_SCOPE_NAME: ATTR_OTEL_SCOPE_NAME,
		ATTR_OTEL_SCOPE_VERSION: ATTR_OTEL_SCOPE_VERSION,
		ATTR_OTEL_STATUS_CODE: ATTR_OTEL_STATUS_CODE,
		ATTR_OTEL_STATUS_DESCRIPTION: ATTR_OTEL_STATUS_DESCRIPTION,
		ATTR_SERVER_ADDRESS: ATTR_SERVER_ADDRESS,
		ATTR_SERVER_PORT: ATTR_SERVER_PORT,
		ATTR_SERVICE_NAME: ATTR_SERVICE_NAME,
		ATTR_SERVICE_VERSION: ATTR_SERVICE_VERSION,
		ATTR_SIGNALR_CONNECTION_STATUS: ATTR_SIGNALR_CONNECTION_STATUS,
		ATTR_SIGNALR_TRANSPORT: ATTR_SIGNALR_TRANSPORT,
		ATTR_TELEMETRY_SDK_LANGUAGE: ATTR_TELEMETRY_SDK_LANGUAGE,
		ATTR_TELEMETRY_SDK_NAME: ATTR_TELEMETRY_SDK_NAME,
		ATTR_TELEMETRY_SDK_VERSION: ATTR_TELEMETRY_SDK_VERSION,
		ATTR_URL_FRAGMENT: ATTR_URL_FRAGMENT,
		ATTR_URL_FULL: ATTR_URL_FULL,
		ATTR_URL_PATH: ATTR_URL_PATH,
		ATTR_URL_QUERY: ATTR_URL_QUERY,
		ATTR_URL_SCHEME: ATTR_URL_SCHEME,
		ATTR_USER_AGENT_ORIGINAL: ATTR_USER_AGENT_ORIGINAL,
		AWSECSLAUNCHTYPEVALUES_EC2: AWSECSLAUNCHTYPEVALUES_EC2,
		AWSECSLAUNCHTYPEVALUES_FARGATE: AWSECSLAUNCHTYPEVALUES_FARGATE,
		AwsEcsLaunchtypeValues: AwsEcsLaunchtypeValues,
		CLOUDPLATFORMVALUES_ALIBABA_CLOUD_ECS: CLOUDPLATFORMVALUES_ALIBABA_CLOUD_ECS,
		CLOUDPLATFORMVALUES_ALIBABA_CLOUD_FC: CLOUDPLATFORMVALUES_ALIBABA_CLOUD_FC,
		CLOUDPLATFORMVALUES_AWS_EC2: CLOUDPLATFORMVALUES_AWS_EC2,
		CLOUDPLATFORMVALUES_AWS_ECS: CLOUDPLATFORMVALUES_AWS_ECS,
		CLOUDPLATFORMVALUES_AWS_EKS: CLOUDPLATFORMVALUES_AWS_EKS,
		CLOUDPLATFORMVALUES_AWS_ELASTIC_BEANSTALK: CLOUDPLATFORMVALUES_AWS_ELASTIC_BEANSTALK,
		CLOUDPLATFORMVALUES_AWS_LAMBDA: CLOUDPLATFORMVALUES_AWS_LAMBDA,
		CLOUDPLATFORMVALUES_AZURE_AKS: CLOUDPLATFORMVALUES_AZURE_AKS,
		CLOUDPLATFORMVALUES_AZURE_APP_SERVICE: CLOUDPLATFORMVALUES_AZURE_APP_SERVICE,
		CLOUDPLATFORMVALUES_AZURE_CONTAINER_INSTANCES: CLOUDPLATFORMVALUES_AZURE_CONTAINER_INSTANCES,
		CLOUDPLATFORMVALUES_AZURE_FUNCTIONS: CLOUDPLATFORMVALUES_AZURE_FUNCTIONS,
		CLOUDPLATFORMVALUES_AZURE_VM: CLOUDPLATFORMVALUES_AZURE_VM,
		CLOUDPLATFORMVALUES_GCP_APP_ENGINE: CLOUDPLATFORMVALUES_GCP_APP_ENGINE,
		CLOUDPLATFORMVALUES_GCP_CLOUD_FUNCTIONS: CLOUDPLATFORMVALUES_GCP_CLOUD_FUNCTIONS,
		CLOUDPLATFORMVALUES_GCP_CLOUD_RUN: CLOUDPLATFORMVALUES_GCP_CLOUD_RUN,
		CLOUDPLATFORMVALUES_GCP_COMPUTE_ENGINE: CLOUDPLATFORMVALUES_GCP_COMPUTE_ENGINE,
		CLOUDPLATFORMVALUES_GCP_KUBERNETES_ENGINE: CLOUDPLATFORMVALUES_GCP_KUBERNETES_ENGINE,
		CLOUDPROVIDERVALUES_ALIBABA_CLOUD: CLOUDPROVIDERVALUES_ALIBABA_CLOUD,
		CLOUDPROVIDERVALUES_AWS: CLOUDPROVIDERVALUES_AWS,
		CLOUDPROVIDERVALUES_AZURE: CLOUDPROVIDERVALUES_AZURE,
		CLOUDPROVIDERVALUES_GCP: CLOUDPROVIDERVALUES_GCP,
		CloudPlatformValues: CloudPlatformValues,
		CloudProviderValues: CloudProviderValues,
		DBCASSANDRACONSISTENCYLEVELVALUES_ALL: DBCASSANDRACONSISTENCYLEVELVALUES_ALL,
		DBCASSANDRACONSISTENCYLEVELVALUES_ANY: DBCASSANDRACONSISTENCYLEVELVALUES_ANY,
		DBCASSANDRACONSISTENCYLEVELVALUES_EACH_QUORUM: DBCASSANDRACONSISTENCYLEVELVALUES_EACH_QUORUM,
		DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_ONE: DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_ONE,
		DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_QUORUM: DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_QUORUM,
		DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_SERIAL: DBCASSANDRACONSISTENCYLEVELVALUES_LOCAL_SERIAL,
		DBCASSANDRACONSISTENCYLEVELVALUES_ONE: DBCASSANDRACONSISTENCYLEVELVALUES_ONE,
		DBCASSANDRACONSISTENCYLEVELVALUES_QUORUM: DBCASSANDRACONSISTENCYLEVELVALUES_QUORUM,
		DBCASSANDRACONSISTENCYLEVELVALUES_SERIAL: DBCASSANDRACONSISTENCYLEVELVALUES_SERIAL,
		DBCASSANDRACONSISTENCYLEVELVALUES_THREE: DBCASSANDRACONSISTENCYLEVELVALUES_THREE,
		DBCASSANDRACONSISTENCYLEVELVALUES_TWO: DBCASSANDRACONSISTENCYLEVELVALUES_TWO,
		DBSYSTEMVALUES_ADABAS: DBSYSTEMVALUES_ADABAS,
		DBSYSTEMVALUES_CACHE: DBSYSTEMVALUES_CACHE,
		DBSYSTEMVALUES_CASSANDRA: DBSYSTEMVALUES_CASSANDRA,
		DBSYSTEMVALUES_CLOUDSCAPE: DBSYSTEMVALUES_CLOUDSCAPE,
		DBSYSTEMVALUES_COCKROACHDB: DBSYSTEMVALUES_COCKROACHDB,
		DBSYSTEMVALUES_COLDFUSION: DBSYSTEMVALUES_COLDFUSION,
		DBSYSTEMVALUES_COSMOSDB: DBSYSTEMVALUES_COSMOSDB,
		DBSYSTEMVALUES_COUCHBASE: DBSYSTEMVALUES_COUCHBASE,
		DBSYSTEMVALUES_COUCHDB: DBSYSTEMVALUES_COUCHDB,
		DBSYSTEMVALUES_DB2: DBSYSTEMVALUES_DB2,
		DBSYSTEMVALUES_DERBY: DBSYSTEMVALUES_DERBY,
		DBSYSTEMVALUES_DYNAMODB: DBSYSTEMVALUES_DYNAMODB,
		DBSYSTEMVALUES_EDB: DBSYSTEMVALUES_EDB,
		DBSYSTEMVALUES_ELASTICSEARCH: DBSYSTEMVALUES_ELASTICSEARCH,
		DBSYSTEMVALUES_FILEMAKER: DBSYSTEMVALUES_FILEMAKER,
		DBSYSTEMVALUES_FIREBIRD: DBSYSTEMVALUES_FIREBIRD,
		DBSYSTEMVALUES_FIRSTSQL: DBSYSTEMVALUES_FIRSTSQL,
		DBSYSTEMVALUES_GEODE: DBSYSTEMVALUES_GEODE,
		DBSYSTEMVALUES_H2: DBSYSTEMVALUES_H2,
		DBSYSTEMVALUES_HANADB: DBSYSTEMVALUES_HANADB,
		DBSYSTEMVALUES_HBASE: DBSYSTEMVALUES_HBASE,
		DBSYSTEMVALUES_HIVE: DBSYSTEMVALUES_HIVE,
		DBSYSTEMVALUES_HSQLDB: DBSYSTEMVALUES_HSQLDB,
		DBSYSTEMVALUES_INFORMIX: DBSYSTEMVALUES_INFORMIX,
		DBSYSTEMVALUES_INGRES: DBSYSTEMVALUES_INGRES,
		DBSYSTEMVALUES_INSTANTDB: DBSYSTEMVALUES_INSTANTDB,
		DBSYSTEMVALUES_INTERBASE: DBSYSTEMVALUES_INTERBASE,
		DBSYSTEMVALUES_MARIADB: DBSYSTEMVALUES_MARIADB,
		DBSYSTEMVALUES_MAXDB: DBSYSTEMVALUES_MAXDB,
		DBSYSTEMVALUES_MEMCACHED: DBSYSTEMVALUES_MEMCACHED,
		DBSYSTEMVALUES_MONGODB: DBSYSTEMVALUES_MONGODB,
		DBSYSTEMVALUES_MSSQL: DBSYSTEMVALUES_MSSQL,
		DBSYSTEMVALUES_MYSQL: DBSYSTEMVALUES_MYSQL,
		DBSYSTEMVALUES_NEO4J: DBSYSTEMVALUES_NEO4J,
		DBSYSTEMVALUES_NETEZZA: DBSYSTEMVALUES_NETEZZA,
		DBSYSTEMVALUES_ORACLE: DBSYSTEMVALUES_ORACLE,
		DBSYSTEMVALUES_OTHER_SQL: DBSYSTEMVALUES_OTHER_SQL,
		DBSYSTEMVALUES_PERVASIVE: DBSYSTEMVALUES_PERVASIVE,
		DBSYSTEMVALUES_POINTBASE: DBSYSTEMVALUES_POINTBASE,
		DBSYSTEMVALUES_POSTGRESQL: DBSYSTEMVALUES_POSTGRESQL,
		DBSYSTEMVALUES_PROGRESS: DBSYSTEMVALUES_PROGRESS,
		DBSYSTEMVALUES_REDIS: DBSYSTEMVALUES_REDIS,
		DBSYSTEMVALUES_REDSHIFT: DBSYSTEMVALUES_REDSHIFT,
		DBSYSTEMVALUES_SQLITE: DBSYSTEMVALUES_SQLITE,
		DBSYSTEMVALUES_SYBASE: DBSYSTEMVALUES_SYBASE,
		DBSYSTEMVALUES_TERADATA: DBSYSTEMVALUES_TERADATA,
		DBSYSTEMVALUES_VERTICA: DBSYSTEMVALUES_VERTICA,
		DB_SYSTEM_NAME_VALUE_ACTIAN_INGRES: DB_SYSTEM_NAME_VALUE_ACTIAN_INGRES,
		DB_SYSTEM_NAME_VALUE_AWS_DYNAMODB: DB_SYSTEM_NAME_VALUE_AWS_DYNAMODB,
		DB_SYSTEM_NAME_VALUE_AWS_REDSHIFT: DB_SYSTEM_NAME_VALUE_AWS_REDSHIFT,
		DB_SYSTEM_NAME_VALUE_AZURE_COSMOSDB: DB_SYSTEM_NAME_VALUE_AZURE_COSMOSDB,
		DB_SYSTEM_NAME_VALUE_CASSANDRA: DB_SYSTEM_NAME_VALUE_CASSANDRA,
		DB_SYSTEM_NAME_VALUE_CLICKHOUSE: DB_SYSTEM_NAME_VALUE_CLICKHOUSE,
		DB_SYSTEM_NAME_VALUE_COCKROACHDB: DB_SYSTEM_NAME_VALUE_COCKROACHDB,
		DB_SYSTEM_NAME_VALUE_COUCHBASE: DB_SYSTEM_NAME_VALUE_COUCHBASE,
		DB_SYSTEM_NAME_VALUE_COUCHDB: DB_SYSTEM_NAME_VALUE_COUCHDB,
		DB_SYSTEM_NAME_VALUE_DERBY: DB_SYSTEM_NAME_VALUE_DERBY,
		DB_SYSTEM_NAME_VALUE_ELASTICSEARCH: DB_SYSTEM_NAME_VALUE_ELASTICSEARCH,
		DB_SYSTEM_NAME_VALUE_FIREBIRDSQL: DB_SYSTEM_NAME_VALUE_FIREBIRDSQL,
		DB_SYSTEM_NAME_VALUE_GCP_SPANNER: DB_SYSTEM_NAME_VALUE_GCP_SPANNER,
		DB_SYSTEM_NAME_VALUE_GEODE: DB_SYSTEM_NAME_VALUE_GEODE,
		DB_SYSTEM_NAME_VALUE_H2DATABASE: DB_SYSTEM_NAME_VALUE_H2DATABASE,
		DB_SYSTEM_NAME_VALUE_HBASE: DB_SYSTEM_NAME_VALUE_HBASE,
		DB_SYSTEM_NAME_VALUE_HIVE: DB_SYSTEM_NAME_VALUE_HIVE,
		DB_SYSTEM_NAME_VALUE_HSQLDB: DB_SYSTEM_NAME_VALUE_HSQLDB,
		DB_SYSTEM_NAME_VALUE_IBM_DB2: DB_SYSTEM_NAME_VALUE_IBM_DB2,
		DB_SYSTEM_NAME_VALUE_IBM_INFORMIX: DB_SYSTEM_NAME_VALUE_IBM_INFORMIX,
		DB_SYSTEM_NAME_VALUE_IBM_NETEZZA: DB_SYSTEM_NAME_VALUE_IBM_NETEZZA,
		DB_SYSTEM_NAME_VALUE_INFLUXDB: DB_SYSTEM_NAME_VALUE_INFLUXDB,
		DB_SYSTEM_NAME_VALUE_INSTANTDB: DB_SYSTEM_NAME_VALUE_INSTANTDB,
		DB_SYSTEM_NAME_VALUE_INTERSYSTEMS_CACHE: DB_SYSTEM_NAME_VALUE_INTERSYSTEMS_CACHE,
		DB_SYSTEM_NAME_VALUE_MARIADB: DB_SYSTEM_NAME_VALUE_MARIADB,
		DB_SYSTEM_NAME_VALUE_MEMCACHED: DB_SYSTEM_NAME_VALUE_MEMCACHED,
		DB_SYSTEM_NAME_VALUE_MICROSOFT_SQL_SERVER: DB_SYSTEM_NAME_VALUE_MICROSOFT_SQL_SERVER,
		DB_SYSTEM_NAME_VALUE_MONGODB: DB_SYSTEM_NAME_VALUE_MONGODB,
		DB_SYSTEM_NAME_VALUE_MYSQL: DB_SYSTEM_NAME_VALUE_MYSQL,
		DB_SYSTEM_NAME_VALUE_NEO4J: DB_SYSTEM_NAME_VALUE_NEO4J,
		DB_SYSTEM_NAME_VALUE_OPENSEARCH: DB_SYSTEM_NAME_VALUE_OPENSEARCH,
		DB_SYSTEM_NAME_VALUE_ORACLE_DB: DB_SYSTEM_NAME_VALUE_ORACLE_DB,
		DB_SYSTEM_NAME_VALUE_OTHER_SQL: DB_SYSTEM_NAME_VALUE_OTHER_SQL,
		DB_SYSTEM_NAME_VALUE_POSTGRESQL: DB_SYSTEM_NAME_VALUE_POSTGRESQL,
		DB_SYSTEM_NAME_VALUE_REDIS: DB_SYSTEM_NAME_VALUE_REDIS,
		DB_SYSTEM_NAME_VALUE_SAP_HANA: DB_SYSTEM_NAME_VALUE_SAP_HANA,
		DB_SYSTEM_NAME_VALUE_SAP_MAXDB: DB_SYSTEM_NAME_VALUE_SAP_MAXDB,
		DB_SYSTEM_NAME_VALUE_SOFTWAREAG_ADABAS: DB_SYSTEM_NAME_VALUE_SOFTWAREAG_ADABAS,
		DB_SYSTEM_NAME_VALUE_SQLITE: DB_SYSTEM_NAME_VALUE_SQLITE,
		DB_SYSTEM_NAME_VALUE_TERADATA: DB_SYSTEM_NAME_VALUE_TERADATA,
		DB_SYSTEM_NAME_VALUE_TRINO: DB_SYSTEM_NAME_VALUE_TRINO,
		DOTNET_GC_HEAP_GENERATION_VALUE_GEN0: DOTNET_GC_HEAP_GENERATION_VALUE_GEN0,
		DOTNET_GC_HEAP_GENERATION_VALUE_GEN1: DOTNET_GC_HEAP_GENERATION_VALUE_GEN1,
		DOTNET_GC_HEAP_GENERATION_VALUE_GEN2: DOTNET_GC_HEAP_GENERATION_VALUE_GEN2,
		DOTNET_GC_HEAP_GENERATION_VALUE_LOH: DOTNET_GC_HEAP_GENERATION_VALUE_LOH,
		DOTNET_GC_HEAP_GENERATION_VALUE_POH: DOTNET_GC_HEAP_GENERATION_VALUE_POH,
		DbCassandraConsistencyLevelValues: DbCassandraConsistencyLevelValues,
		DbSystemValues: DbSystemValues,
		ERROR_TYPE_VALUE_OTHER: ERROR_TYPE_VALUE_OTHER,
		FAASDOCUMENTOPERATIONVALUES_DELETE: FAASDOCUMENTOPERATIONVALUES_DELETE,
		FAASDOCUMENTOPERATIONVALUES_EDIT: FAASDOCUMENTOPERATIONVALUES_EDIT,
		FAASDOCUMENTOPERATIONVALUES_INSERT: FAASDOCUMENTOPERATIONVALUES_INSERT,
		FAASINVOKEDPROVIDERVALUES_ALIBABA_CLOUD: FAASINVOKEDPROVIDERVALUES_ALIBABA_CLOUD,
		FAASINVOKEDPROVIDERVALUES_AWS: FAASINVOKEDPROVIDERVALUES_AWS,
		FAASINVOKEDPROVIDERVALUES_AZURE: FAASINVOKEDPROVIDERVALUES_AZURE,
		FAASINVOKEDPROVIDERVALUES_GCP: FAASINVOKEDPROVIDERVALUES_GCP,
		FAASTRIGGERVALUES_DATASOURCE: FAASTRIGGERVALUES_DATASOURCE,
		FAASTRIGGERVALUES_HTTP: FAASTRIGGERVALUES_HTTP,
		FAASTRIGGERVALUES_OTHER: FAASTRIGGERVALUES_OTHER,
		FAASTRIGGERVALUES_PUBSUB: FAASTRIGGERVALUES_PUBSUB,
		FAASTRIGGERVALUES_TIMER: FAASTRIGGERVALUES_TIMER,
		FaasDocumentOperationValues: FaasDocumentOperationValues,
		FaasInvokedProviderValues: FaasInvokedProviderValues,
		FaasTriggerValues: FaasTriggerValues,
		HOSTARCHVALUES_AMD64: HOSTARCHVALUES_AMD64,
		HOSTARCHVALUES_ARM32: HOSTARCHVALUES_ARM32,
		HOSTARCHVALUES_ARM64: HOSTARCHVALUES_ARM64,
		HOSTARCHVALUES_IA64: HOSTARCHVALUES_IA64,
		HOSTARCHVALUES_PPC32: HOSTARCHVALUES_PPC32,
		HOSTARCHVALUES_PPC64: HOSTARCHVALUES_PPC64,
		HOSTARCHVALUES_X86: HOSTARCHVALUES_X86,
		HTTPFLAVORVALUES_HTTP_1_0: HTTPFLAVORVALUES_HTTP_1_0,
		HTTPFLAVORVALUES_HTTP_1_1: HTTPFLAVORVALUES_HTTP_1_1,
		HTTPFLAVORVALUES_HTTP_2_0: HTTPFLAVORVALUES_HTTP_2_0,
		HTTPFLAVORVALUES_QUIC: HTTPFLAVORVALUES_QUIC,
		HTTPFLAVORVALUES_SPDY: HTTPFLAVORVALUES_SPDY,
		HTTP_REQUEST_METHOD_VALUE_CONNECT: HTTP_REQUEST_METHOD_VALUE_CONNECT,
		HTTP_REQUEST_METHOD_VALUE_DELETE: HTTP_REQUEST_METHOD_VALUE_DELETE,
		HTTP_REQUEST_METHOD_VALUE_GET: HTTP_REQUEST_METHOD_VALUE_GET,
		HTTP_REQUEST_METHOD_VALUE_HEAD: HTTP_REQUEST_METHOD_VALUE_HEAD,
		HTTP_REQUEST_METHOD_VALUE_OPTIONS: HTTP_REQUEST_METHOD_VALUE_OPTIONS,
		HTTP_REQUEST_METHOD_VALUE_OTHER: HTTP_REQUEST_METHOD_VALUE_OTHER,
		HTTP_REQUEST_METHOD_VALUE_PATCH: HTTP_REQUEST_METHOD_VALUE_PATCH,
		HTTP_REQUEST_METHOD_VALUE_POST: HTTP_REQUEST_METHOD_VALUE_POST,
		HTTP_REQUEST_METHOD_VALUE_PUT: HTTP_REQUEST_METHOD_VALUE_PUT,
		HTTP_REQUEST_METHOD_VALUE_TRACE: HTTP_REQUEST_METHOD_VALUE_TRACE,
		HostArchValues: HostArchValues,
		HttpFlavorValues: HttpFlavorValues,
		JVM_MEMORY_TYPE_VALUE_HEAP: JVM_MEMORY_TYPE_VALUE_HEAP,
		JVM_MEMORY_TYPE_VALUE_NON_HEAP: JVM_MEMORY_TYPE_VALUE_NON_HEAP,
		JVM_THREAD_STATE_VALUE_BLOCKED: JVM_THREAD_STATE_VALUE_BLOCKED,
		JVM_THREAD_STATE_VALUE_NEW: JVM_THREAD_STATE_VALUE_NEW,
		JVM_THREAD_STATE_VALUE_RUNNABLE: JVM_THREAD_STATE_VALUE_RUNNABLE,
		JVM_THREAD_STATE_VALUE_TERMINATED: JVM_THREAD_STATE_VALUE_TERMINATED,
		JVM_THREAD_STATE_VALUE_TIMED_WAITING: JVM_THREAD_STATE_VALUE_TIMED_WAITING,
		JVM_THREAD_STATE_VALUE_WAITING: JVM_THREAD_STATE_VALUE_WAITING,
		MESSAGETYPEVALUES_RECEIVED: MESSAGETYPEVALUES_RECEIVED,
		MESSAGETYPEVALUES_SENT: MESSAGETYPEVALUES_SENT,
		MESSAGINGDESTINATIONKINDVALUES_QUEUE: MESSAGINGDESTINATIONKINDVALUES_QUEUE,
		MESSAGINGDESTINATIONKINDVALUES_TOPIC: MESSAGINGDESTINATIONKINDVALUES_TOPIC,
		MESSAGINGOPERATIONVALUES_PROCESS: MESSAGINGOPERATIONVALUES_PROCESS,
		MESSAGINGOPERATIONVALUES_RECEIVE: MESSAGINGOPERATIONVALUES_RECEIVE,
		METRIC_ASPNETCORE_DIAGNOSTICS_EXCEPTIONS: METRIC_ASPNETCORE_DIAGNOSTICS_EXCEPTIONS,
		METRIC_ASPNETCORE_RATE_LIMITING_ACTIVE_REQUEST_LEASES: METRIC_ASPNETCORE_RATE_LIMITING_ACTIVE_REQUEST_LEASES,
		METRIC_ASPNETCORE_RATE_LIMITING_QUEUED_REQUESTS: METRIC_ASPNETCORE_RATE_LIMITING_QUEUED_REQUESTS,
		METRIC_ASPNETCORE_RATE_LIMITING_REQUESTS: METRIC_ASPNETCORE_RATE_LIMITING_REQUESTS,
		METRIC_ASPNETCORE_RATE_LIMITING_REQUEST_LEASE_DURATION: METRIC_ASPNETCORE_RATE_LIMITING_REQUEST_LEASE_DURATION,
		METRIC_ASPNETCORE_RATE_LIMITING_REQUEST_TIME_IN_QUEUE: METRIC_ASPNETCORE_RATE_LIMITING_REQUEST_TIME_IN_QUEUE,
		METRIC_ASPNETCORE_ROUTING_MATCH_ATTEMPTS: METRIC_ASPNETCORE_ROUTING_MATCH_ATTEMPTS,
		METRIC_DB_CLIENT_OPERATION_DURATION: METRIC_DB_CLIENT_OPERATION_DURATION,
		METRIC_DOTNET_ASSEMBLY_COUNT: METRIC_DOTNET_ASSEMBLY_COUNT,
		METRIC_DOTNET_EXCEPTIONS: METRIC_DOTNET_EXCEPTIONS,
		METRIC_DOTNET_GC_COLLECTIONS: METRIC_DOTNET_GC_COLLECTIONS,
		METRIC_DOTNET_GC_HEAP_TOTAL_ALLOCATED: METRIC_DOTNET_GC_HEAP_TOTAL_ALLOCATED,
		METRIC_DOTNET_GC_LAST_COLLECTION_HEAP_FRAGMENTATION_SIZE: METRIC_DOTNET_GC_LAST_COLLECTION_HEAP_FRAGMENTATION_SIZE,
		METRIC_DOTNET_GC_LAST_COLLECTION_HEAP_SIZE: METRIC_DOTNET_GC_LAST_COLLECTION_HEAP_SIZE,
		METRIC_DOTNET_GC_LAST_COLLECTION_MEMORY_COMMITTED_SIZE: METRIC_DOTNET_GC_LAST_COLLECTION_MEMORY_COMMITTED_SIZE,
		METRIC_DOTNET_GC_PAUSE_TIME: METRIC_DOTNET_GC_PAUSE_TIME,
		METRIC_DOTNET_JIT_COMPILATION_TIME: METRIC_DOTNET_JIT_COMPILATION_TIME,
		METRIC_DOTNET_JIT_COMPILED_IL_SIZE: METRIC_DOTNET_JIT_COMPILED_IL_SIZE,
		METRIC_DOTNET_JIT_COMPILED_METHODS: METRIC_DOTNET_JIT_COMPILED_METHODS,
		METRIC_DOTNET_MONITOR_LOCK_CONTENTIONS: METRIC_DOTNET_MONITOR_LOCK_CONTENTIONS,
		METRIC_DOTNET_PROCESS_CPU_COUNT: METRIC_DOTNET_PROCESS_CPU_COUNT,
		METRIC_DOTNET_PROCESS_CPU_TIME: METRIC_DOTNET_PROCESS_CPU_TIME,
		METRIC_DOTNET_PROCESS_MEMORY_WORKING_SET: METRIC_DOTNET_PROCESS_MEMORY_WORKING_SET,
		METRIC_DOTNET_THREAD_POOL_QUEUE_LENGTH: METRIC_DOTNET_THREAD_POOL_QUEUE_LENGTH,
		METRIC_DOTNET_THREAD_POOL_THREAD_COUNT: METRIC_DOTNET_THREAD_POOL_THREAD_COUNT,
		METRIC_DOTNET_THREAD_POOL_WORK_ITEM_COUNT: METRIC_DOTNET_THREAD_POOL_WORK_ITEM_COUNT,
		METRIC_DOTNET_TIMER_COUNT: METRIC_DOTNET_TIMER_COUNT,
		METRIC_HTTP_CLIENT_REQUEST_DURATION: METRIC_HTTP_CLIENT_REQUEST_DURATION,
		METRIC_HTTP_SERVER_REQUEST_DURATION: METRIC_HTTP_SERVER_REQUEST_DURATION,
		METRIC_JVM_CLASS_COUNT: METRIC_JVM_CLASS_COUNT,
		METRIC_JVM_CLASS_LOADED: METRIC_JVM_CLASS_LOADED,
		METRIC_JVM_CLASS_UNLOADED: METRIC_JVM_CLASS_UNLOADED,
		METRIC_JVM_CPU_COUNT: METRIC_JVM_CPU_COUNT,
		METRIC_JVM_CPU_RECENT_UTILIZATION: METRIC_JVM_CPU_RECENT_UTILIZATION,
		METRIC_JVM_CPU_TIME: METRIC_JVM_CPU_TIME,
		METRIC_JVM_GC_DURATION: METRIC_JVM_GC_DURATION,
		METRIC_JVM_MEMORY_COMMITTED: METRIC_JVM_MEMORY_COMMITTED,
		METRIC_JVM_MEMORY_LIMIT: METRIC_JVM_MEMORY_LIMIT,
		METRIC_JVM_MEMORY_USED: METRIC_JVM_MEMORY_USED,
		METRIC_JVM_MEMORY_USED_AFTER_LAST_GC: METRIC_JVM_MEMORY_USED_AFTER_LAST_GC,
		METRIC_JVM_THREAD_COUNT: METRIC_JVM_THREAD_COUNT,
		METRIC_KESTREL_ACTIVE_CONNECTIONS: METRIC_KESTREL_ACTIVE_CONNECTIONS,
		METRIC_KESTREL_ACTIVE_TLS_HANDSHAKES: METRIC_KESTREL_ACTIVE_TLS_HANDSHAKES,
		METRIC_KESTREL_CONNECTION_DURATION: METRIC_KESTREL_CONNECTION_DURATION,
		METRIC_KESTREL_QUEUED_CONNECTIONS: METRIC_KESTREL_QUEUED_CONNECTIONS,
		METRIC_KESTREL_QUEUED_REQUESTS: METRIC_KESTREL_QUEUED_REQUESTS,
		METRIC_KESTREL_REJECTED_CONNECTIONS: METRIC_KESTREL_REJECTED_CONNECTIONS,
		METRIC_KESTREL_TLS_HANDSHAKE_DURATION: METRIC_KESTREL_TLS_HANDSHAKE_DURATION,
		METRIC_KESTREL_UPGRADED_CONNECTIONS: METRIC_KESTREL_UPGRADED_CONNECTIONS,
		METRIC_SIGNALR_SERVER_ACTIVE_CONNECTIONS: METRIC_SIGNALR_SERVER_ACTIVE_CONNECTIONS,
		METRIC_SIGNALR_SERVER_CONNECTION_DURATION: METRIC_SIGNALR_SERVER_CONNECTION_DURATION,
		MessageTypeValues: MessageTypeValues,
		MessagingDestinationKindValues: MessagingDestinationKindValues,
		MessagingOperationValues: MessagingOperationValues,
		NETHOSTCONNECTIONSUBTYPEVALUES_CDMA: NETHOSTCONNECTIONSUBTYPEVALUES_CDMA,
		NETHOSTCONNECTIONSUBTYPEVALUES_CDMA2000_1XRTT: NETHOSTCONNECTIONSUBTYPEVALUES_CDMA2000_1XRTT,
		NETHOSTCONNECTIONSUBTYPEVALUES_EDGE: NETHOSTCONNECTIONSUBTYPEVALUES_EDGE,
		NETHOSTCONNECTIONSUBTYPEVALUES_EHRPD: NETHOSTCONNECTIONSUBTYPEVALUES_EHRPD,
		NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_0: NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_0,
		NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_A: NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_A,
		NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_B: NETHOSTCONNECTIONSUBTYPEVALUES_EVDO_B,
		NETHOSTCONNECTIONSUBTYPEVALUES_GPRS: NETHOSTCONNECTIONSUBTYPEVALUES_GPRS,
		NETHOSTCONNECTIONSUBTYPEVALUES_GSM: NETHOSTCONNECTIONSUBTYPEVALUES_GSM,
		NETHOSTCONNECTIONSUBTYPEVALUES_HSDPA: NETHOSTCONNECTIONSUBTYPEVALUES_HSDPA,
		NETHOSTCONNECTIONSUBTYPEVALUES_HSPA: NETHOSTCONNECTIONSUBTYPEVALUES_HSPA,
		NETHOSTCONNECTIONSUBTYPEVALUES_HSPAP: NETHOSTCONNECTIONSUBTYPEVALUES_HSPAP,
		NETHOSTCONNECTIONSUBTYPEVALUES_HSUPA: NETHOSTCONNECTIONSUBTYPEVALUES_HSUPA,
		NETHOSTCONNECTIONSUBTYPEVALUES_IDEN: NETHOSTCONNECTIONSUBTYPEVALUES_IDEN,
		NETHOSTCONNECTIONSUBTYPEVALUES_IWLAN: NETHOSTCONNECTIONSUBTYPEVALUES_IWLAN,
		NETHOSTCONNECTIONSUBTYPEVALUES_LTE: NETHOSTCONNECTIONSUBTYPEVALUES_LTE,
		NETHOSTCONNECTIONSUBTYPEVALUES_LTE_CA: NETHOSTCONNECTIONSUBTYPEVALUES_LTE_CA,
		NETHOSTCONNECTIONSUBTYPEVALUES_NR: NETHOSTCONNECTIONSUBTYPEVALUES_NR,
		NETHOSTCONNECTIONSUBTYPEVALUES_NRNSA: NETHOSTCONNECTIONSUBTYPEVALUES_NRNSA,
		NETHOSTCONNECTIONSUBTYPEVALUES_TD_SCDMA: NETHOSTCONNECTIONSUBTYPEVALUES_TD_SCDMA,
		NETHOSTCONNECTIONSUBTYPEVALUES_UMTS: NETHOSTCONNECTIONSUBTYPEVALUES_UMTS,
		NETHOSTCONNECTIONTYPEVALUES_CELL: NETHOSTCONNECTIONTYPEVALUES_CELL,
		NETHOSTCONNECTIONTYPEVALUES_UNAVAILABLE: NETHOSTCONNECTIONTYPEVALUES_UNAVAILABLE,
		NETHOSTCONNECTIONTYPEVALUES_UNKNOWN: NETHOSTCONNECTIONTYPEVALUES_UNKNOWN,
		NETHOSTCONNECTIONTYPEVALUES_WIFI: NETHOSTCONNECTIONTYPEVALUES_WIFI,
		NETHOSTCONNECTIONTYPEVALUES_WIRED: NETHOSTCONNECTIONTYPEVALUES_WIRED,
		NETTRANSPORTVALUES_INPROC: NETTRANSPORTVALUES_INPROC,
		NETTRANSPORTVALUES_IP: NETTRANSPORTVALUES_IP,
		NETTRANSPORTVALUES_IP_TCP: NETTRANSPORTVALUES_IP_TCP,
		NETTRANSPORTVALUES_IP_UDP: NETTRANSPORTVALUES_IP_UDP,
		NETTRANSPORTVALUES_OTHER: NETTRANSPORTVALUES_OTHER,
		NETTRANSPORTVALUES_PIPE: NETTRANSPORTVALUES_PIPE,
		NETTRANSPORTVALUES_UNIX: NETTRANSPORTVALUES_UNIX,
		NETWORK_TRANSPORT_VALUE_PIPE: NETWORK_TRANSPORT_VALUE_PIPE,
		NETWORK_TRANSPORT_VALUE_QUIC: NETWORK_TRANSPORT_VALUE_QUIC,
		NETWORK_TRANSPORT_VALUE_TCP: NETWORK_TRANSPORT_VALUE_TCP,
		NETWORK_TRANSPORT_VALUE_UDP: NETWORK_TRANSPORT_VALUE_UDP,
		NETWORK_TRANSPORT_VALUE_UNIX: NETWORK_TRANSPORT_VALUE_UNIX,
		NETWORK_TYPE_VALUE_IPV4: NETWORK_TYPE_VALUE_IPV4,
		NETWORK_TYPE_VALUE_IPV6: NETWORK_TYPE_VALUE_IPV6,
		NetHostConnectionSubtypeValues: NetHostConnectionSubtypeValues,
		NetHostConnectionTypeValues: NetHostConnectionTypeValues,
		NetTransportValues: NetTransportValues,
		OSTYPEVALUES_AIX: OSTYPEVALUES_AIX,
		OSTYPEVALUES_DARWIN: OSTYPEVALUES_DARWIN,
		OSTYPEVALUES_DRAGONFLYBSD: OSTYPEVALUES_DRAGONFLYBSD,
		OSTYPEVALUES_FREEBSD: OSTYPEVALUES_FREEBSD,
		OSTYPEVALUES_HPUX: OSTYPEVALUES_HPUX,
		OSTYPEVALUES_LINUX: OSTYPEVALUES_LINUX,
		OSTYPEVALUES_NETBSD: OSTYPEVALUES_NETBSD,
		OSTYPEVALUES_OPENBSD: OSTYPEVALUES_OPENBSD,
		OSTYPEVALUES_SOLARIS: OSTYPEVALUES_SOLARIS,
		OSTYPEVALUES_WINDOWS: OSTYPEVALUES_WINDOWS,
		OSTYPEVALUES_Z_OS: OSTYPEVALUES_Z_OS,
		OTEL_STATUS_CODE_VALUE_ERROR: OTEL_STATUS_CODE_VALUE_ERROR,
		OTEL_STATUS_CODE_VALUE_OK: OTEL_STATUS_CODE_VALUE_OK,
		OsTypeValues: OsTypeValues,
		RPCGRPCSTATUSCODEVALUES_ABORTED: RPCGRPCSTATUSCODEVALUES_ABORTED,
		RPCGRPCSTATUSCODEVALUES_ALREADY_EXISTS: RPCGRPCSTATUSCODEVALUES_ALREADY_EXISTS,
		RPCGRPCSTATUSCODEVALUES_CANCELLED: RPCGRPCSTATUSCODEVALUES_CANCELLED,
		RPCGRPCSTATUSCODEVALUES_DATA_LOSS: RPCGRPCSTATUSCODEVALUES_DATA_LOSS,
		RPCGRPCSTATUSCODEVALUES_DEADLINE_EXCEEDED: RPCGRPCSTATUSCODEVALUES_DEADLINE_EXCEEDED,
		RPCGRPCSTATUSCODEVALUES_FAILED_PRECONDITION: RPCGRPCSTATUSCODEVALUES_FAILED_PRECONDITION,
		RPCGRPCSTATUSCODEVALUES_INTERNAL: RPCGRPCSTATUSCODEVALUES_INTERNAL,
		RPCGRPCSTATUSCODEVALUES_INVALID_ARGUMENT: RPCGRPCSTATUSCODEVALUES_INVALID_ARGUMENT,
		RPCGRPCSTATUSCODEVALUES_NOT_FOUND: RPCGRPCSTATUSCODEVALUES_NOT_FOUND,
		RPCGRPCSTATUSCODEVALUES_OK: RPCGRPCSTATUSCODEVALUES_OK,
		RPCGRPCSTATUSCODEVALUES_OUT_OF_RANGE: RPCGRPCSTATUSCODEVALUES_OUT_OF_RANGE,
		RPCGRPCSTATUSCODEVALUES_PERMISSION_DENIED: RPCGRPCSTATUSCODEVALUES_PERMISSION_DENIED,
		RPCGRPCSTATUSCODEVALUES_RESOURCE_EXHAUSTED: RPCGRPCSTATUSCODEVALUES_RESOURCE_EXHAUSTED,
		RPCGRPCSTATUSCODEVALUES_UNAUTHENTICATED: RPCGRPCSTATUSCODEVALUES_UNAUTHENTICATED,
		RPCGRPCSTATUSCODEVALUES_UNAVAILABLE: RPCGRPCSTATUSCODEVALUES_UNAVAILABLE,
		RPCGRPCSTATUSCODEVALUES_UNIMPLEMENTED: RPCGRPCSTATUSCODEVALUES_UNIMPLEMENTED,
		RPCGRPCSTATUSCODEVALUES_UNKNOWN: RPCGRPCSTATUSCODEVALUES_UNKNOWN,
		RpcGrpcStatusCodeValues: RpcGrpcStatusCodeValues,
		SEMATTRS_AWS_DYNAMODB_ATTRIBUTES_TO_GET: SEMATTRS_AWS_DYNAMODB_ATTRIBUTES_TO_GET,
		SEMATTRS_AWS_DYNAMODB_ATTRIBUTE_DEFINITIONS: SEMATTRS_AWS_DYNAMODB_ATTRIBUTE_DEFINITIONS,
		SEMATTRS_AWS_DYNAMODB_CONSISTENT_READ: SEMATTRS_AWS_DYNAMODB_CONSISTENT_READ,
		SEMATTRS_AWS_DYNAMODB_CONSUMED_CAPACITY: SEMATTRS_AWS_DYNAMODB_CONSUMED_CAPACITY,
		SEMATTRS_AWS_DYNAMODB_COUNT: SEMATTRS_AWS_DYNAMODB_COUNT,
		SEMATTRS_AWS_DYNAMODB_EXCLUSIVE_START_TABLE: SEMATTRS_AWS_DYNAMODB_EXCLUSIVE_START_TABLE,
		SEMATTRS_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEXES: SEMATTRS_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEXES,
		SEMATTRS_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEX_UPDATES: SEMATTRS_AWS_DYNAMODB_GLOBAL_SECONDARY_INDEX_UPDATES,
		SEMATTRS_AWS_DYNAMODB_INDEX_NAME: SEMATTRS_AWS_DYNAMODB_INDEX_NAME,
		SEMATTRS_AWS_DYNAMODB_ITEM_COLLECTION_METRICS: SEMATTRS_AWS_DYNAMODB_ITEM_COLLECTION_METRICS,
		SEMATTRS_AWS_DYNAMODB_LIMIT: SEMATTRS_AWS_DYNAMODB_LIMIT,
		SEMATTRS_AWS_DYNAMODB_LOCAL_SECONDARY_INDEXES: SEMATTRS_AWS_DYNAMODB_LOCAL_SECONDARY_INDEXES,
		SEMATTRS_AWS_DYNAMODB_PROJECTION: SEMATTRS_AWS_DYNAMODB_PROJECTION,
		SEMATTRS_AWS_DYNAMODB_PROVISIONED_READ_CAPACITY: SEMATTRS_AWS_DYNAMODB_PROVISIONED_READ_CAPACITY,
		SEMATTRS_AWS_DYNAMODB_PROVISIONED_WRITE_CAPACITY: SEMATTRS_AWS_DYNAMODB_PROVISIONED_WRITE_CAPACITY,
		SEMATTRS_AWS_DYNAMODB_SCANNED_COUNT: SEMATTRS_AWS_DYNAMODB_SCANNED_COUNT,
		SEMATTRS_AWS_DYNAMODB_SCAN_FORWARD: SEMATTRS_AWS_DYNAMODB_SCAN_FORWARD,
		SEMATTRS_AWS_DYNAMODB_SEGMENT: SEMATTRS_AWS_DYNAMODB_SEGMENT,
		SEMATTRS_AWS_DYNAMODB_SELECT: SEMATTRS_AWS_DYNAMODB_SELECT,
		SEMATTRS_AWS_DYNAMODB_TABLE_COUNT: SEMATTRS_AWS_DYNAMODB_TABLE_COUNT,
		SEMATTRS_AWS_DYNAMODB_TABLE_NAMES: SEMATTRS_AWS_DYNAMODB_TABLE_NAMES,
		SEMATTRS_AWS_DYNAMODB_TOTAL_SEGMENTS: SEMATTRS_AWS_DYNAMODB_TOTAL_SEGMENTS,
		SEMATTRS_AWS_LAMBDA_INVOKED_ARN: SEMATTRS_AWS_LAMBDA_INVOKED_ARN,
		SEMATTRS_CODE_FILEPATH: SEMATTRS_CODE_FILEPATH,
		SEMATTRS_CODE_FUNCTION: SEMATTRS_CODE_FUNCTION,
		SEMATTRS_CODE_LINENO: SEMATTRS_CODE_LINENO,
		SEMATTRS_CODE_NAMESPACE: SEMATTRS_CODE_NAMESPACE,
		SEMATTRS_DB_CASSANDRA_CONSISTENCY_LEVEL: SEMATTRS_DB_CASSANDRA_CONSISTENCY_LEVEL,
		SEMATTRS_DB_CASSANDRA_COORDINATOR_DC: SEMATTRS_DB_CASSANDRA_COORDINATOR_DC,
		SEMATTRS_DB_CASSANDRA_COORDINATOR_ID: SEMATTRS_DB_CASSANDRA_COORDINATOR_ID,
		SEMATTRS_DB_CASSANDRA_IDEMPOTENCE: SEMATTRS_DB_CASSANDRA_IDEMPOTENCE,
		SEMATTRS_DB_CASSANDRA_KEYSPACE: SEMATTRS_DB_CASSANDRA_KEYSPACE,
		SEMATTRS_DB_CASSANDRA_PAGE_SIZE: SEMATTRS_DB_CASSANDRA_PAGE_SIZE,
		SEMATTRS_DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT: SEMATTRS_DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT,
		SEMATTRS_DB_CASSANDRA_TABLE: SEMATTRS_DB_CASSANDRA_TABLE,
		SEMATTRS_DB_CONNECTION_STRING: SEMATTRS_DB_CONNECTION_STRING,
		SEMATTRS_DB_HBASE_NAMESPACE: SEMATTRS_DB_HBASE_NAMESPACE,
		SEMATTRS_DB_JDBC_DRIVER_CLASSNAME: SEMATTRS_DB_JDBC_DRIVER_CLASSNAME,
		SEMATTRS_DB_MONGODB_COLLECTION: SEMATTRS_DB_MONGODB_COLLECTION,
		SEMATTRS_DB_MSSQL_INSTANCE_NAME: SEMATTRS_DB_MSSQL_INSTANCE_NAME,
		SEMATTRS_DB_NAME: SEMATTRS_DB_NAME,
		SEMATTRS_DB_OPERATION: SEMATTRS_DB_OPERATION,
		SEMATTRS_DB_REDIS_DATABASE_INDEX: SEMATTRS_DB_REDIS_DATABASE_INDEX,
		SEMATTRS_DB_SQL_TABLE: SEMATTRS_DB_SQL_TABLE,
		SEMATTRS_DB_STATEMENT: SEMATTRS_DB_STATEMENT,
		SEMATTRS_DB_SYSTEM: SEMATTRS_DB_SYSTEM,
		SEMATTRS_DB_USER: SEMATTRS_DB_USER,
		SEMATTRS_ENDUSER_ID: SEMATTRS_ENDUSER_ID,
		SEMATTRS_ENDUSER_ROLE: SEMATTRS_ENDUSER_ROLE,
		SEMATTRS_ENDUSER_SCOPE: SEMATTRS_ENDUSER_SCOPE,
		SEMATTRS_EXCEPTION_ESCAPED: SEMATTRS_EXCEPTION_ESCAPED,
		SEMATTRS_EXCEPTION_MESSAGE: SEMATTRS_EXCEPTION_MESSAGE,
		SEMATTRS_EXCEPTION_STACKTRACE: SEMATTRS_EXCEPTION_STACKTRACE,
		SEMATTRS_EXCEPTION_TYPE: SEMATTRS_EXCEPTION_TYPE,
		SEMATTRS_FAAS_COLDSTART: SEMATTRS_FAAS_COLDSTART,
		SEMATTRS_FAAS_CRON: SEMATTRS_FAAS_CRON,
		SEMATTRS_FAAS_DOCUMENT_COLLECTION: SEMATTRS_FAAS_DOCUMENT_COLLECTION,
		SEMATTRS_FAAS_DOCUMENT_NAME: SEMATTRS_FAAS_DOCUMENT_NAME,
		SEMATTRS_FAAS_DOCUMENT_OPERATION: SEMATTRS_FAAS_DOCUMENT_OPERATION,
		SEMATTRS_FAAS_DOCUMENT_TIME: SEMATTRS_FAAS_DOCUMENT_TIME,
		SEMATTRS_FAAS_EXECUTION: SEMATTRS_FAAS_EXECUTION,
		SEMATTRS_FAAS_INVOKED_NAME: SEMATTRS_FAAS_INVOKED_NAME,
		SEMATTRS_FAAS_INVOKED_PROVIDER: SEMATTRS_FAAS_INVOKED_PROVIDER,
		SEMATTRS_FAAS_INVOKED_REGION: SEMATTRS_FAAS_INVOKED_REGION,
		SEMATTRS_FAAS_TIME: SEMATTRS_FAAS_TIME,
		SEMATTRS_FAAS_TRIGGER: SEMATTRS_FAAS_TRIGGER,
		SEMATTRS_HTTP_CLIENT_IP: SEMATTRS_HTTP_CLIENT_IP,
		SEMATTRS_HTTP_FLAVOR: SEMATTRS_HTTP_FLAVOR,
		SEMATTRS_HTTP_HOST: SEMATTRS_HTTP_HOST,
		SEMATTRS_HTTP_METHOD: SEMATTRS_HTTP_METHOD,
		SEMATTRS_HTTP_REQUEST_CONTENT_LENGTH: SEMATTRS_HTTP_REQUEST_CONTENT_LENGTH,
		SEMATTRS_HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED: SEMATTRS_HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED,
		SEMATTRS_HTTP_RESPONSE_CONTENT_LENGTH: SEMATTRS_HTTP_RESPONSE_CONTENT_LENGTH,
		SEMATTRS_HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED: SEMATTRS_HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED,
		SEMATTRS_HTTP_ROUTE: SEMATTRS_HTTP_ROUTE,
		SEMATTRS_HTTP_SCHEME: SEMATTRS_HTTP_SCHEME,
		SEMATTRS_HTTP_SERVER_NAME: SEMATTRS_HTTP_SERVER_NAME,
		SEMATTRS_HTTP_STATUS_CODE: SEMATTRS_HTTP_STATUS_CODE,
		SEMATTRS_HTTP_TARGET: SEMATTRS_HTTP_TARGET,
		SEMATTRS_HTTP_URL: SEMATTRS_HTTP_URL,
		SEMATTRS_HTTP_USER_AGENT: SEMATTRS_HTTP_USER_AGENT,
		SEMATTRS_MESSAGE_COMPRESSED_SIZE: SEMATTRS_MESSAGE_COMPRESSED_SIZE,
		SEMATTRS_MESSAGE_ID: SEMATTRS_MESSAGE_ID,
		SEMATTRS_MESSAGE_TYPE: SEMATTRS_MESSAGE_TYPE,
		SEMATTRS_MESSAGE_UNCOMPRESSED_SIZE: SEMATTRS_MESSAGE_UNCOMPRESSED_SIZE,
		SEMATTRS_MESSAGING_CONSUMER_ID: SEMATTRS_MESSAGING_CONSUMER_ID,
		SEMATTRS_MESSAGING_CONVERSATION_ID: SEMATTRS_MESSAGING_CONVERSATION_ID,
		SEMATTRS_MESSAGING_DESTINATION: SEMATTRS_MESSAGING_DESTINATION,
		SEMATTRS_MESSAGING_DESTINATION_KIND: SEMATTRS_MESSAGING_DESTINATION_KIND,
		SEMATTRS_MESSAGING_KAFKA_CLIENT_ID: SEMATTRS_MESSAGING_KAFKA_CLIENT_ID,
		SEMATTRS_MESSAGING_KAFKA_CONSUMER_GROUP: SEMATTRS_MESSAGING_KAFKA_CONSUMER_GROUP,
		SEMATTRS_MESSAGING_KAFKA_MESSAGE_KEY: SEMATTRS_MESSAGING_KAFKA_MESSAGE_KEY,
		SEMATTRS_MESSAGING_KAFKA_PARTITION: SEMATTRS_MESSAGING_KAFKA_PARTITION,
		SEMATTRS_MESSAGING_KAFKA_TOMBSTONE: SEMATTRS_MESSAGING_KAFKA_TOMBSTONE,
		SEMATTRS_MESSAGING_MESSAGE_ID: SEMATTRS_MESSAGING_MESSAGE_ID,
		SEMATTRS_MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES: SEMATTRS_MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES,
		SEMATTRS_MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES: SEMATTRS_MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES,
		SEMATTRS_MESSAGING_OPERATION: SEMATTRS_MESSAGING_OPERATION,
		SEMATTRS_MESSAGING_PROTOCOL: SEMATTRS_MESSAGING_PROTOCOL,
		SEMATTRS_MESSAGING_PROTOCOL_VERSION: SEMATTRS_MESSAGING_PROTOCOL_VERSION,
		SEMATTRS_MESSAGING_RABBITMQ_ROUTING_KEY: SEMATTRS_MESSAGING_RABBITMQ_ROUTING_KEY,
		SEMATTRS_MESSAGING_SYSTEM: SEMATTRS_MESSAGING_SYSTEM,
		SEMATTRS_MESSAGING_TEMP_DESTINATION: SEMATTRS_MESSAGING_TEMP_DESTINATION,
		SEMATTRS_MESSAGING_URL: SEMATTRS_MESSAGING_URL,
		SEMATTRS_NET_HOST_CARRIER_ICC: SEMATTRS_NET_HOST_CARRIER_ICC,
		SEMATTRS_NET_HOST_CARRIER_MCC: SEMATTRS_NET_HOST_CARRIER_MCC,
		SEMATTRS_NET_HOST_CARRIER_MNC: SEMATTRS_NET_HOST_CARRIER_MNC,
		SEMATTRS_NET_HOST_CARRIER_NAME: SEMATTRS_NET_HOST_CARRIER_NAME,
		SEMATTRS_NET_HOST_CONNECTION_SUBTYPE: SEMATTRS_NET_HOST_CONNECTION_SUBTYPE,
		SEMATTRS_NET_HOST_CONNECTION_TYPE: SEMATTRS_NET_HOST_CONNECTION_TYPE,
		SEMATTRS_NET_HOST_IP: SEMATTRS_NET_HOST_IP,
		SEMATTRS_NET_HOST_NAME: SEMATTRS_NET_HOST_NAME,
		SEMATTRS_NET_HOST_PORT: SEMATTRS_NET_HOST_PORT,
		SEMATTRS_NET_PEER_IP: SEMATTRS_NET_PEER_IP,
		SEMATTRS_NET_PEER_NAME: SEMATTRS_NET_PEER_NAME,
		SEMATTRS_NET_PEER_PORT: SEMATTRS_NET_PEER_PORT,
		SEMATTRS_NET_TRANSPORT: SEMATTRS_NET_TRANSPORT,
		SEMATTRS_PEER_SERVICE: SEMATTRS_PEER_SERVICE,
		SEMATTRS_RPC_GRPC_STATUS_CODE: SEMATTRS_RPC_GRPC_STATUS_CODE,
		SEMATTRS_RPC_JSONRPC_ERROR_CODE: SEMATTRS_RPC_JSONRPC_ERROR_CODE,
		SEMATTRS_RPC_JSONRPC_ERROR_MESSAGE: SEMATTRS_RPC_JSONRPC_ERROR_MESSAGE,
		SEMATTRS_RPC_JSONRPC_REQUEST_ID: SEMATTRS_RPC_JSONRPC_REQUEST_ID,
		SEMATTRS_RPC_JSONRPC_VERSION: SEMATTRS_RPC_JSONRPC_VERSION,
		SEMATTRS_RPC_METHOD: SEMATTRS_RPC_METHOD,
		SEMATTRS_RPC_SERVICE: SEMATTRS_RPC_SERVICE,
		SEMATTRS_RPC_SYSTEM: SEMATTRS_RPC_SYSTEM,
		SEMATTRS_THREAD_ID: SEMATTRS_THREAD_ID,
		SEMATTRS_THREAD_NAME: SEMATTRS_THREAD_NAME,
		SEMRESATTRS_AWS_ECS_CLUSTER_ARN: SEMRESATTRS_AWS_ECS_CLUSTER_ARN,
		SEMRESATTRS_AWS_ECS_CONTAINER_ARN: SEMRESATTRS_AWS_ECS_CONTAINER_ARN,
		SEMRESATTRS_AWS_ECS_LAUNCHTYPE: SEMRESATTRS_AWS_ECS_LAUNCHTYPE,
		SEMRESATTRS_AWS_ECS_TASK_ARN: SEMRESATTRS_AWS_ECS_TASK_ARN,
		SEMRESATTRS_AWS_ECS_TASK_FAMILY: SEMRESATTRS_AWS_ECS_TASK_FAMILY,
		SEMRESATTRS_AWS_ECS_TASK_REVISION: SEMRESATTRS_AWS_ECS_TASK_REVISION,
		SEMRESATTRS_AWS_EKS_CLUSTER_ARN: SEMRESATTRS_AWS_EKS_CLUSTER_ARN,
		SEMRESATTRS_AWS_LOG_GROUP_ARNS: SEMRESATTRS_AWS_LOG_GROUP_ARNS,
		SEMRESATTRS_AWS_LOG_GROUP_NAMES: SEMRESATTRS_AWS_LOG_GROUP_NAMES,
		SEMRESATTRS_AWS_LOG_STREAM_ARNS: SEMRESATTRS_AWS_LOG_STREAM_ARNS,
		SEMRESATTRS_AWS_LOG_STREAM_NAMES: SEMRESATTRS_AWS_LOG_STREAM_NAMES,
		SEMRESATTRS_CLOUD_ACCOUNT_ID: SEMRESATTRS_CLOUD_ACCOUNT_ID,
		SEMRESATTRS_CLOUD_AVAILABILITY_ZONE: SEMRESATTRS_CLOUD_AVAILABILITY_ZONE,
		SEMRESATTRS_CLOUD_PLATFORM: SEMRESATTRS_CLOUD_PLATFORM,
		SEMRESATTRS_CLOUD_PROVIDER: SEMRESATTRS_CLOUD_PROVIDER,
		SEMRESATTRS_CLOUD_REGION: SEMRESATTRS_CLOUD_REGION,
		SEMRESATTRS_CONTAINER_ID: SEMRESATTRS_CONTAINER_ID,
		SEMRESATTRS_CONTAINER_IMAGE_NAME: SEMRESATTRS_CONTAINER_IMAGE_NAME,
		SEMRESATTRS_CONTAINER_IMAGE_TAG: SEMRESATTRS_CONTAINER_IMAGE_TAG,
		SEMRESATTRS_CONTAINER_NAME: SEMRESATTRS_CONTAINER_NAME,
		SEMRESATTRS_CONTAINER_RUNTIME: SEMRESATTRS_CONTAINER_RUNTIME,
		SEMRESATTRS_DEPLOYMENT_ENVIRONMENT: SEMRESATTRS_DEPLOYMENT_ENVIRONMENT,
		SEMRESATTRS_DEVICE_ID: SEMRESATTRS_DEVICE_ID,
		SEMRESATTRS_DEVICE_MODEL_IDENTIFIER: SEMRESATTRS_DEVICE_MODEL_IDENTIFIER,
		SEMRESATTRS_DEVICE_MODEL_NAME: SEMRESATTRS_DEVICE_MODEL_NAME,
		SEMRESATTRS_FAAS_ID: SEMRESATTRS_FAAS_ID,
		SEMRESATTRS_FAAS_INSTANCE: SEMRESATTRS_FAAS_INSTANCE,
		SEMRESATTRS_FAAS_MAX_MEMORY: SEMRESATTRS_FAAS_MAX_MEMORY,
		SEMRESATTRS_FAAS_NAME: SEMRESATTRS_FAAS_NAME,
		SEMRESATTRS_FAAS_VERSION: SEMRESATTRS_FAAS_VERSION,
		SEMRESATTRS_HOST_ARCH: SEMRESATTRS_HOST_ARCH,
		SEMRESATTRS_HOST_ID: SEMRESATTRS_HOST_ID,
		SEMRESATTRS_HOST_IMAGE_ID: SEMRESATTRS_HOST_IMAGE_ID,
		SEMRESATTRS_HOST_IMAGE_NAME: SEMRESATTRS_HOST_IMAGE_NAME,
		SEMRESATTRS_HOST_IMAGE_VERSION: SEMRESATTRS_HOST_IMAGE_VERSION,
		SEMRESATTRS_HOST_NAME: SEMRESATTRS_HOST_NAME,
		SEMRESATTRS_HOST_TYPE: SEMRESATTRS_HOST_TYPE,
		SEMRESATTRS_K8S_CLUSTER_NAME: SEMRESATTRS_K8S_CLUSTER_NAME,
		SEMRESATTRS_K8S_CONTAINER_NAME: SEMRESATTRS_K8S_CONTAINER_NAME,
		SEMRESATTRS_K8S_CRONJOB_NAME: SEMRESATTRS_K8S_CRONJOB_NAME,
		SEMRESATTRS_K8S_CRONJOB_UID: SEMRESATTRS_K8S_CRONJOB_UID,
		SEMRESATTRS_K8S_DAEMONSET_NAME: SEMRESATTRS_K8S_DAEMONSET_NAME,
		SEMRESATTRS_K8S_DAEMONSET_UID: SEMRESATTRS_K8S_DAEMONSET_UID,
		SEMRESATTRS_K8S_DEPLOYMENT_NAME: SEMRESATTRS_K8S_DEPLOYMENT_NAME,
		SEMRESATTRS_K8S_DEPLOYMENT_UID: SEMRESATTRS_K8S_DEPLOYMENT_UID,
		SEMRESATTRS_K8S_JOB_NAME: SEMRESATTRS_K8S_JOB_NAME,
		SEMRESATTRS_K8S_JOB_UID: SEMRESATTRS_K8S_JOB_UID,
		SEMRESATTRS_K8S_NAMESPACE_NAME: SEMRESATTRS_K8S_NAMESPACE_NAME,
		SEMRESATTRS_K8S_NODE_NAME: SEMRESATTRS_K8S_NODE_NAME,
		SEMRESATTRS_K8S_NODE_UID: SEMRESATTRS_K8S_NODE_UID,
		SEMRESATTRS_K8S_POD_NAME: SEMRESATTRS_K8S_POD_NAME,
		SEMRESATTRS_K8S_POD_UID: SEMRESATTRS_K8S_POD_UID,
		SEMRESATTRS_K8S_REPLICASET_NAME: SEMRESATTRS_K8S_REPLICASET_NAME,
		SEMRESATTRS_K8S_REPLICASET_UID: SEMRESATTRS_K8S_REPLICASET_UID,
		SEMRESATTRS_K8S_STATEFULSET_NAME: SEMRESATTRS_K8S_STATEFULSET_NAME,
		SEMRESATTRS_K8S_STATEFULSET_UID: SEMRESATTRS_K8S_STATEFULSET_UID,
		SEMRESATTRS_OS_DESCRIPTION: SEMRESATTRS_OS_DESCRIPTION,
		SEMRESATTRS_OS_NAME: SEMRESATTRS_OS_NAME,
		SEMRESATTRS_OS_TYPE: SEMRESATTRS_OS_TYPE,
		SEMRESATTRS_OS_VERSION: SEMRESATTRS_OS_VERSION,
		SEMRESATTRS_PROCESS_COMMAND: SEMRESATTRS_PROCESS_COMMAND,
		SEMRESATTRS_PROCESS_COMMAND_ARGS: SEMRESATTRS_PROCESS_COMMAND_ARGS,
		SEMRESATTRS_PROCESS_COMMAND_LINE: SEMRESATTRS_PROCESS_COMMAND_LINE,
		SEMRESATTRS_PROCESS_EXECUTABLE_NAME: SEMRESATTRS_PROCESS_EXECUTABLE_NAME,
		SEMRESATTRS_PROCESS_EXECUTABLE_PATH: SEMRESATTRS_PROCESS_EXECUTABLE_PATH,
		SEMRESATTRS_PROCESS_OWNER: SEMRESATTRS_PROCESS_OWNER,
		SEMRESATTRS_PROCESS_PID: SEMRESATTRS_PROCESS_PID,
		SEMRESATTRS_PROCESS_RUNTIME_DESCRIPTION: SEMRESATTRS_PROCESS_RUNTIME_DESCRIPTION,
		SEMRESATTRS_PROCESS_RUNTIME_NAME: SEMRESATTRS_PROCESS_RUNTIME_NAME,
		SEMRESATTRS_PROCESS_RUNTIME_VERSION: SEMRESATTRS_PROCESS_RUNTIME_VERSION,
		SEMRESATTRS_SERVICE_INSTANCE_ID: SEMRESATTRS_SERVICE_INSTANCE_ID,
		SEMRESATTRS_SERVICE_NAME: SEMRESATTRS_SERVICE_NAME,
		SEMRESATTRS_SERVICE_NAMESPACE: SEMRESATTRS_SERVICE_NAMESPACE,
		SEMRESATTRS_SERVICE_VERSION: SEMRESATTRS_SERVICE_VERSION,
		SEMRESATTRS_TELEMETRY_AUTO_VERSION: SEMRESATTRS_TELEMETRY_AUTO_VERSION,
		SEMRESATTRS_TELEMETRY_SDK_LANGUAGE: SEMRESATTRS_TELEMETRY_SDK_LANGUAGE,
		SEMRESATTRS_TELEMETRY_SDK_NAME: SEMRESATTRS_TELEMETRY_SDK_NAME,
		SEMRESATTRS_TELEMETRY_SDK_VERSION: SEMRESATTRS_TELEMETRY_SDK_VERSION,
		SEMRESATTRS_WEBENGINE_DESCRIPTION: SEMRESATTRS_WEBENGINE_DESCRIPTION,
		SEMRESATTRS_WEBENGINE_NAME: SEMRESATTRS_WEBENGINE_NAME,
		SEMRESATTRS_WEBENGINE_VERSION: SEMRESATTRS_WEBENGINE_VERSION,
		SIGNALR_CONNECTION_STATUS_VALUE_APP_SHUTDOWN: SIGNALR_CONNECTION_STATUS_VALUE_APP_SHUTDOWN,
		SIGNALR_CONNECTION_STATUS_VALUE_NORMAL_CLOSURE: SIGNALR_CONNECTION_STATUS_VALUE_NORMAL_CLOSURE,
		SIGNALR_CONNECTION_STATUS_VALUE_TIMEOUT: SIGNALR_CONNECTION_STATUS_VALUE_TIMEOUT,
		SIGNALR_TRANSPORT_VALUE_LONG_POLLING: SIGNALR_TRANSPORT_VALUE_LONG_POLLING,
		SIGNALR_TRANSPORT_VALUE_SERVER_SENT_EVENTS: SIGNALR_TRANSPORT_VALUE_SERVER_SENT_EVENTS,
		SIGNALR_TRANSPORT_VALUE_WEB_SOCKETS: SIGNALR_TRANSPORT_VALUE_WEB_SOCKETS,
		SemanticAttributes: SemanticAttributes,
		SemanticResourceAttributes: SemanticResourceAttributes,
		TELEMETRYSDKLANGUAGEVALUES_CPP: TELEMETRYSDKLANGUAGEVALUES_CPP,
		TELEMETRYSDKLANGUAGEVALUES_DOTNET: TELEMETRYSDKLANGUAGEVALUES_DOTNET,
		TELEMETRYSDKLANGUAGEVALUES_ERLANG: TELEMETRYSDKLANGUAGEVALUES_ERLANG,
		TELEMETRYSDKLANGUAGEVALUES_GO: TELEMETRYSDKLANGUAGEVALUES_GO,
		TELEMETRYSDKLANGUAGEVALUES_JAVA: TELEMETRYSDKLANGUAGEVALUES_JAVA,
		TELEMETRYSDKLANGUAGEVALUES_NODEJS: TELEMETRYSDKLANGUAGEVALUES_NODEJS,
		TELEMETRYSDKLANGUAGEVALUES_PHP: TELEMETRYSDKLANGUAGEVALUES_PHP,
		TELEMETRYSDKLANGUAGEVALUES_PYTHON: TELEMETRYSDKLANGUAGEVALUES_PYTHON,
		TELEMETRYSDKLANGUAGEVALUES_RUBY: TELEMETRYSDKLANGUAGEVALUES_RUBY,
		TELEMETRYSDKLANGUAGEVALUES_WEBJS: TELEMETRYSDKLANGUAGEVALUES_WEBJS,
		TELEMETRY_SDK_LANGUAGE_VALUE_CPP: TELEMETRY_SDK_LANGUAGE_VALUE_CPP,
		TELEMETRY_SDK_LANGUAGE_VALUE_DOTNET: TELEMETRY_SDK_LANGUAGE_VALUE_DOTNET,
		TELEMETRY_SDK_LANGUAGE_VALUE_ERLANG: TELEMETRY_SDK_LANGUAGE_VALUE_ERLANG,
		TELEMETRY_SDK_LANGUAGE_VALUE_GO: TELEMETRY_SDK_LANGUAGE_VALUE_GO,
		TELEMETRY_SDK_LANGUAGE_VALUE_JAVA: TELEMETRY_SDK_LANGUAGE_VALUE_JAVA,
		TELEMETRY_SDK_LANGUAGE_VALUE_NODEJS: TELEMETRY_SDK_LANGUAGE_VALUE_NODEJS,
		TELEMETRY_SDK_LANGUAGE_VALUE_PHP: TELEMETRY_SDK_LANGUAGE_VALUE_PHP,
		TELEMETRY_SDK_LANGUAGE_VALUE_PYTHON: TELEMETRY_SDK_LANGUAGE_VALUE_PYTHON,
		TELEMETRY_SDK_LANGUAGE_VALUE_RUBY: TELEMETRY_SDK_LANGUAGE_VALUE_RUBY,
		TELEMETRY_SDK_LANGUAGE_VALUE_RUST: TELEMETRY_SDK_LANGUAGE_VALUE_RUST,
		TELEMETRY_SDK_LANGUAGE_VALUE_SWIFT: TELEMETRY_SDK_LANGUAGE_VALUE_SWIFT,
		TELEMETRY_SDK_LANGUAGE_VALUE_WEBJS: TELEMETRY_SDK_LANGUAGE_VALUE_WEBJS,
		TelemetrySdkLanguageValues: TelemetrySdkLanguageValues
	});

	var require$$3 = /*@__PURE__*/getAugmentedNamespace(esm$c);

	var hasRequiredBuild$p;
	function requireBuild$p() {
	  if (hasRequiredBuild$p) return build$n;
	  hasRequiredBuild$p = 1;
	  (function (exports) {

	    _Object$defineProperty$1(exports, "__esModule", {
	      value: true
	    });
	    exports.ATTR_IMQA_ELEMENT_CLASS = exports.ATTR_IMQA_ELEMENT_ID = exports.ATTR_IMQA_ELEMENT_TAG = exports.ATTR_IMQA_ELEMENT_TEXT = exports.ATTR_IMQA_SERVICE_TYPE = exports.ATTR_OS_VERSION = exports.ATTR_OS_NAME = exports.ATTR_IMQA_USER_INTERACTION_PREV_HREF = exports.ATTR_IMQA_BROWSER_LOCATION_HREF = exports.ATTR_IMQA_LONGTASK_DURATION = exports.ATTR_IMQA_LONGTASK_ENTRY_TYPE = exports.ATTR_IMQA_LONGTASK_NAME = exports.ATTR_IMQA_DOCUMENT_SCREEN_XY = exports.ATTR_IMQA_DOCUMENT_REFERRER = exports.ATTR_IMQA_CONNECTIVITY_ONLINE = exports.ATTR_IMQA_LINK_SPAN_ID = exports.ATTR_IMQA_LINK_TRACE_ID = exports.ATTR_IMQA_HTTP_RESPONSE_BODY = exports.ATTR_IMQA_HTTP_REQUEST_BODY = exports.ATTR_IMQA_RUM_SCRIPT_INSTANCE = exports.ATTR_IMQA_RUM_AGENT_VERSION = exports.ATTR_IMQA_RUM_VERSION = exports.ATTR_IMQA_AGENT_VERSION = exports.ATTR_IMQA_SERVICE_KEY = exports.ATTR_IMQA_LOG_MESSAGE = exports.ATTR_IMQA_LOG_LEVEL = exports.ATTR_IMQA_SESSION_ID = exports.ATTR_IMQA_SCREEN_TYPE = exports.ATTR_IMQA_SCREEN_NAME = exports.ATTR_IMQA_SPAN_TYPE = exports.ATTR_IMQA_RUM_COMPONENT = exports.ATTR_IMQA_BROWSER_VERSION_MAJOR = exports.ATTR_IMQA_BROWSER_VERSION = exports.ATTR_IMQA_BROWSER_NAME = exports.ATTR_IMQA_BROWSER_DEVICE = void 0;
	    var tslib_1 = require$$0$9;
	    tslib_1.__exportStar(require$$3, exports);
	    exports.ATTR_IMQA_BROWSER_DEVICE = 'imqa.browser.device';
	    exports.ATTR_IMQA_BROWSER_NAME = 'imqa.browser.name';
	    exports.ATTR_IMQA_BROWSER_VERSION = 'imqa.browser.version';
	    exports.ATTR_IMQA_BROWSER_VERSION_MAJOR = 'imqa.browser.version_major';
	    exports.ATTR_IMQA_RUM_COMPONENT = 'component';
	    exports.ATTR_IMQA_SPAN_TYPE = 'span.type';
	    exports.ATTR_IMQA_SCREEN_NAME = 'screen.name';
	    exports.ATTR_IMQA_SCREEN_TYPE = 'screen.type';
	    exports.ATTR_IMQA_SESSION_ID = 'session.id';
	    exports.ATTR_IMQA_LOG_LEVEL = 'level';
	    exports.ATTR_IMQA_LOG_MESSAGE = 'message';
	    exports.ATTR_IMQA_SERVICE_KEY = 'service.key';
	    exports.ATTR_IMQA_AGENT_VERSION = 'imqa.agent.version';
	    exports.ATTR_IMQA_RUM_VERSION = 'rum.version';
	    exports.ATTR_IMQA_RUM_AGENT_VERSION = 'imqa.rum.version';
	    exports.ATTR_IMQA_RUM_SCRIPT_INSTANCE = 'rum.scriptInstance';
	    exports.ATTR_IMQA_HTTP_REQUEST_BODY = 'http.request.body';
	    exports.ATTR_IMQA_HTTP_RESPONSE_BODY = 'http.response.body';
	    exports.ATTR_IMQA_LINK_TRACE_ID = 'link.traceId';
	    exports.ATTR_IMQA_LINK_SPAN_ID = 'link.spanId';
	    exports.ATTR_IMQA_CONNECTIVITY_ONLINE = 'online';
	    exports.ATTR_IMQA_DOCUMENT_REFERRER = 'document.referrer';
	    exports.ATTR_IMQA_DOCUMENT_SCREEN_XY = 'screen.xy';
	    exports.ATTR_IMQA_LONGTASK_NAME = 'longtask.name';
	    exports.ATTR_IMQA_LONGTASK_ENTRY_TYPE = 'longtask.entry_type';
	    exports.ATTR_IMQA_LONGTASK_DURATION = 'longtask.duration';
	    exports.ATTR_IMQA_BROWSER_LOCATION_HREF = 'location.href';
	    exports.ATTR_IMQA_USER_INTERACTION_PREV_HREF = 'prev.href';
	    exports.ATTR_OS_NAME = 'os.name';
	    exports.ATTR_OS_VERSION = 'os.version';
	    exports.ATTR_IMQA_SERVICE_TYPE = 'imqa.service.type';
	    exports.ATTR_IMQA_ELEMENT_TEXT = 'imqa.element.text';
	    exports.ATTR_IMQA_ELEMENT_TAG = 'imqa.element.tag';
	    exports.ATTR_IMQA_ELEMENT_ID = 'imqa.element.id';
	    exports.ATTR_IMQA_ELEMENT_CLASS = 'imqa.element.class';
	  })(build$n);
	  return build$n;
	}

	var es_string_repeat = {};

	var hasRequiredEs_string_repeat;

	function requireEs_string_repeat () {
		if (hasRequiredEs_string_repeat) return es_string_repeat;
		hasRequiredEs_string_repeat = 1;
		var $ = /*@__PURE__*/ require_export();
		var repeat = /*@__PURE__*/ requireStringRepeat();

		// `String.prototype.repeat` method
		// https://tc39.es/ecma262/#sec-string.prototype.repeat
		$({ target: 'String', proto: true }, {
		  repeat: repeat
		});
		return es_string_repeat;
	}

	var repeat$3;
	var hasRequiredRepeat$3;

	function requireRepeat$3 () {
		if (hasRequiredRepeat$3) return repeat$3;
		hasRequiredRepeat$3 = 1;
		requireEs_string_repeat();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		repeat$3 = getBuiltInPrototypeMethod('String', 'repeat');
		return repeat$3;
	}

	var repeat$2;
	var hasRequiredRepeat$2;

	function requireRepeat$2 () {
		if (hasRequiredRepeat$2) return repeat$2;
		hasRequiredRepeat$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireRepeat$3();

		var StringPrototype = String.prototype;

		repeat$2 = function (it) {
		  var own = it.repeat;
		  return typeof it == 'string' || it === StringPrototype
		    || (isPrototypeOf(StringPrototype, it) && own === StringPrototype.repeat) ? method : own;
		};
		return repeat$2;
	}

	var repeat$1;
	var hasRequiredRepeat$1;

	function requireRepeat$1 () {
		if (hasRequiredRepeat$1) return repeat$1;
		hasRequiredRepeat$1 = 1;
		var parent = /*@__PURE__*/ requireRepeat$2();

		repeat$1 = parent;
		return repeat$1;
	}

	var repeat;
	var hasRequiredRepeat;
	function requireRepeat() {
	  if (hasRequiredRepeat) return repeat;
	  hasRequiredRepeat = 1;
	  repeat = /*@__PURE__*/requireRepeat$1();
	  return repeat;
	}

	var repeatExports = requireRepeat();
	var _repeatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(repeatExports);

	var utils$6 = {};

	var hasRequiredUtils$6;
	function requireUtils$6() {
	  if (hasRequiredUtils$6) return utils$6;
	  hasRequiredUtils$6 = 1;
	  _Object$defineProperty$1(utils$6, "__esModule", {
	    value: true
	  });
	  utils$6.generateId = generateId;
	  utils$6.findCookieValue = findCookieValue;
	  utils$6.isIframe = isIframe;
	  function generateId(bits) {
	    var _context;
	    var xes = _repeatInstanceProperty(_context = 'x').call(_context, bits / 4);
	    return xes.replace(/x/g, function () {
	      return (Math.random() * 16 | 0).toString(16);
	    });
	  }
	  function findCookieValue(cookieName) {
	    var decodedCookie = decodeURIComponent(document.cookie);
	    var cookies = decodedCookie.split(';');
	    for (var i = 0; i < cookies.length; i++) {
	      var _context2;
	      var c = _trimInstanceProperty(_context2 = cookies[i]).call(_context2);
	      if (_indexOfInstanceProperty$1(c).call(c, cookieName + '=') === 0) {
	        return c.substring((cookieName + '=').length, c.length);
	      }
	    }
	    return undefined;
	  }
	  function isIframe() {
	    try {
	      return window.self !== window.top;
	    } catch (e) {
	      console.error(e);
	      return true;
	    }
	  }
	  return utils$6;
	}

	var hasRequiredBuild$o;
	function requireBuild$o() {
	  if (hasRequiredBuild$o) return build$o;
	  hasRequiredBuild$o = 1;
	  (function (exports) {

	    _Object$defineProperty$1(exports, "__esModule", {
	      value: true
	    });
	    exports.COOKIE_NAME = void 0;
	    exports.setSessionId = setSessionId;
	    exports.updateSessionStatus = updateSessionStatus;
	    exports.initSessionTracking = initSessionTracking;
	    exports.getRumSessionId = getRumSessionId;
	    exports.setRumSessionId = setRumSessionId;
	    var semantic_conventions_1 = requireBuild$p();
	    var utils_1 = requireUtils$6();
	    var MaxSessionAgeMillis = 4 * 60 * 60 * 1000;
	    var InactivityTimeoutSeconds = 15 * 60;
	    var PeriodicCheckSeconds = 60;
	    exports.COOKIE_NAME = '__imqa_rum_sid';
	    var rumSessionId;
	    var recentActivity = false;
	    var cookieDomain;
	    var eventTarget;
	    function setSessionId(sessionId) {
	      window.__imqa_session_id = sessionId;
	      updateSessionStatus();
	    }
	    function markActivity() {
	      recentActivity = true;
	    }
	    function pastMaxAge(startTime) {
	      var now = _Date$now();
	      return startTime > now || now > startTime + MaxSessionAgeMillis;
	    }
	    function parseCookieToSessionState() {
	      if (window.__imqa_session_id) {
	        return undefined;
	      }
	      var rawValue = (0, utils_1.findCookieValue)(exports.COOKIE_NAME);
	      if (!rawValue) {
	        return undefined;
	      }
	      var decoded = decodeURIComponent(rawValue);
	      if (!decoded) {
	        return undefined;
	      }
	      var ss = undefined;
	      try {
	        ss = JSON.parse(decoded);
	      } catch (error) {
	        console.error(error);
	        return undefined;
	      }
	      if (!ss || _typeof$1(ss) !== 'object') {
	        return undefined;
	      }
	      if (!ss.id || typeof ss.id !== 'string' || !ss.id.length || ss.id.length !== 32) {
	        return undefined;
	      }
	      if (!ss.startTime || typeof ss.startTime !== 'number' || pastMaxAge(ss.startTime)) {
	        return undefined;
	      }
	      return ss;
	    }
	    function newSessionState() {
	      if (window.__imqa_session_id) {
	        return {
	          id: window.__imqa_session_id,
	          startTime: _Date$now()
	        };
	      }
	      return {
	        id: (0, utils_1.generateId)(128),
	        startTime: _Date$now()
	      };
	    }
	    function renewCookieTimeout(sessionState) {
	      if (pastMaxAge(sessionState.startTime)) {
	        return;
	      }
	      var cookieValue = encodeURIComponent(_JSON$stringify(sessionState));
	      var domain = cookieDomain ? "domain=".concat(cookieDomain, ";") : '';
	      var cookie = exports.COOKIE_NAME + '=' + cookieValue + '; path=/;' + domain + 'max-age=' + InactivityTimeoutSeconds;
	      if ((0, utils_1.isIframe)()) {
	        cookie += ';SameSite=None; Secure';
	      } else {
	        cookie += ';SameSite=Strict';
	      }
	      document.cookie = cookie;
	    }
	    function updateSessionStatus() {
	      var sessionState = parseCookieToSessionState();
	      if (!sessionState) {
	        sessionState = newSessionState();
	        recentActivity = true;
	      }
	      rumSessionId = sessionState.id;
	      if (rumSessionId) {
	        eventTarget === null || eventTarget === void 0 ? void 0 : eventTarget.emit('session-changed', {
	          sessionId: rumSessionId
	        });
	      }
	      if (recentActivity) {
	        renewCookieTimeout(sessionState);
	      }
	      recentActivity = false;
	    }
	    function initSessionTracking(instanceId, newEventTarget, domain) {
	      var _context;
	      if (domain) {
	        cookieDomain = domain;
	      }
	      rumSessionId = instanceId;
	      recentActivity = true;
	      eventTarget = newEventTarget;
	      updateSessionStatus();
	      var intervalHandle = _setInterval(function () {
	        return updateSessionStatus();
	      }, PeriodicCheckSeconds * 1000);
	      _forEachInstanceProperty(_context = ['click', 'scroll', 'mousedown', 'keydown', 'touchend', 'visibilitychange']).call(_context, function (type) {
	        return document.addEventListener(type, markActivity, {
	          capture: true,
	          passive: true
	        });
	      });
	      return {
	        deinit: function deinit() {
	          clearInterval(intervalHandle);
	          rumSessionId = undefined;
	          eventTarget = undefined;
	        }
	      };
	    }
	    function getRumSessionId() {
	      return rumSessionId || '';
	    }
	    function setRumSessionId(span) {
	      span.setAttribute(semantic_conventions_1.ATTR_IMQA_SESSION_ID, getRumSessionId());
	    }
	  })(build$o);
	  return build$o;
	}

	var build$m = {};

	var hasRequiredBuild$n;
	function requireBuild$n() {
	  if (hasRequiredBuild$n) return build$m;
	  hasRequiredBuild$n = 1;
	  (function (exports) {

	    _Object$defineProperty$1(exports, "__esModule", {
	      value: true
	    });
	    exports.spanResources = exports.setScreenName = exports.getScreenName = exports.getTitle = void 0;
	    var session_1 = requireBuild$o();
	    var semantic_conventions_1 = requireBuild$p();
	    var getTitle = function getTitle() {
	      if (!document) return '';
	      var title = document.getElementsByTagName('title')[0];
	      return title ? title.innerHTML : 'unknown';
	    };
	    exports.getTitle = getTitle;
	    var getUrl = function getUrl(urlWithSearchParams) {
	      var url = new _URL(window.location.href);
	      return urlWithSearchParams ? url.href : url.origin + url.pathname;
	    };
	    var getScreenName = function getScreenName(option) {
	      var _context;
	      var screenNameType = option.screenNameType,
	        urlWithSearchParams = option.urlWithSearchParams;
	      if (!window) return 'unknown';
	      var title = (0, exports.getTitle)();
	      if (screenNameType === 'titleOnly') return title;
	      var href = getUrl(urlWithSearchParams);
	      if (screenNameType === 'routeOnly') return href;
	      return _concatInstanceProperty(_context = "".concat(title, " - ")).call(_context, href);
	    };
	    exports.getScreenName = getScreenName;
	    var setScreenName = function setScreenName(span, option) {
	      var _option$screenNameTyp = option.screenNameType,
	        screenNameType = _option$screenNameTyp === void 0 ? 'full' : _option$screenNameTyp,
	        _option$urlWithSearch = option.urlWithSearchParams,
	        urlWithSearchParams = _option$urlWithSearch === void 0 ? true : _option$urlWithSearch;
	      span.setAttribute('screen.name', (0, exports.getScreenName)({
	        screenNameType: screenNameType,
	        urlWithSearchParams: urlWithSearchParams
	      }));
	      span.setAttribute('screen.type', 'page');
	    };
	    exports.setScreenName = setScreenName;
	    var spanResources = function spanResources(span, option) {
	      (0, exports.setScreenName)(span, option);
	      (0, session_1.setRumSessionId)(span);
	      span.setAttribute(semantic_conventions_1.ATTR_URL_FULL, window.location.href);
	    };
	    exports.spanResources = spanResources;
	  })(build$m);
	  return build$m;
	}

	var getOwnPropertySymbols$2;
	var hasRequiredGetOwnPropertySymbols$2;

	function requireGetOwnPropertySymbols$2 () {
		if (hasRequiredGetOwnPropertySymbols$2) return getOwnPropertySymbols$2;
		hasRequiredGetOwnPropertySymbols$2 = 1;
		var parent = /*@__PURE__*/ requireGetOwnPropertySymbols$4();

		getOwnPropertySymbols$2 = parent;
		return getOwnPropertySymbols$2;
	}

	var getOwnPropertySymbols$1;
	var hasRequiredGetOwnPropertySymbols$1;

	function requireGetOwnPropertySymbols$1 () {
		if (hasRequiredGetOwnPropertySymbols$1) return getOwnPropertySymbols$1;
		hasRequiredGetOwnPropertySymbols$1 = 1;
		var parent = /*@__PURE__*/ requireGetOwnPropertySymbols$2();

		getOwnPropertySymbols$1 = parent;
		return getOwnPropertySymbols$1;
	}

	var getOwnPropertySymbols;
	var hasRequiredGetOwnPropertySymbols;

	function requireGetOwnPropertySymbols () {
		if (hasRequiredGetOwnPropertySymbols) return getOwnPropertySymbols;
		hasRequiredGetOwnPropertySymbols = 1;
		getOwnPropertySymbols = /*@__PURE__*/ requireGetOwnPropertySymbols$1();
		return getOwnPropertySymbols;
	}

	var getOwnPropertySymbolsExports = /*@__PURE__*/ requireGetOwnPropertySymbols();
	var _Object$getOwnPropertySymbols = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertySymbolsExports);

	var indexOf$2;
	var hasRequiredIndexOf$2;

	function requireIndexOf$2 () {
		if (hasRequiredIndexOf$2) return indexOf$2;
		hasRequiredIndexOf$2 = 1;
		var parent = /*@__PURE__*/ requireIndexOf$4();

		indexOf$2 = parent;
		return indexOf$2;
	}

	var indexOf$1;
	var hasRequiredIndexOf$1;

	function requireIndexOf$1 () {
		if (hasRequiredIndexOf$1) return indexOf$1;
		hasRequiredIndexOf$1 = 1;
		var parent = /*@__PURE__*/ requireIndexOf$2();

		indexOf$1 = parent;
		return indexOf$1;
	}

	var indexOf;
	var hasRequiredIndexOf;

	function requireIndexOf () {
		if (hasRequiredIndexOf) return indexOf;
		hasRequiredIndexOf = 1;
		indexOf = /*@__PURE__*/ requireIndexOf$1();
		return indexOf;
	}

	var indexOfExports = /*@__PURE__*/ requireIndexOf();
	var _indexOfInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(indexOfExports);

	function _objectWithoutPropertiesLoose(r, e) {
	  if (null == r) return {};
	  var t = {};
	  for (var n in r) if ({}.hasOwnProperty.call(r, n)) {
	    if (-1 !== _indexOfInstanceProperty(e).call(e, n)) continue;
	    t[n] = r[n];
	  }
	  return t;
	}

	function _objectWithoutProperties(e, t) {
	  if (null == e) return {};
	  var o,
	    r,
	    i = _objectWithoutPropertiesLoose(e, t);
	  if (_Object$getOwnPropertySymbols) {
	    var n = _Object$getOwnPropertySymbols(e);
	    for (r = 0; r < n.length; r++) o = n[r], -1 === _indexOfInstanceProperty(t).call(t, o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]);
	  }
	  return i;
	}

	var esnext_promise_try = {};

	var hasRequiredEsnext_promise_try;

	function requireEsnext_promise_try () {
		if (hasRequiredEsnext_promise_try) return esnext_promise_try;
		hasRequiredEsnext_promise_try = 1;
		// TODO: Remove from `core-js@4`
		requireEs_promise_try();
		return esnext_promise_try;
	}

	var esnext_promise_withResolvers = {};

	var hasRequiredEsnext_promise_withResolvers;

	function requireEsnext_promise_withResolvers () {
		if (hasRequiredEsnext_promise_withResolvers) return esnext_promise_withResolvers;
		hasRequiredEsnext_promise_withResolvers = 1;
		// TODO: Remove from `core-js@4`
		requireEs_promise_withResolvers();
		return esnext_promise_withResolvers;
	}

	var promise$2;
	var hasRequiredPromise$2;

	function requirePromise$2 () {
		if (hasRequiredPromise$2) return promise$2;
		hasRequiredPromise$2 = 1;
		var parent = /*@__PURE__*/ requirePromise$4();
		// TODO: Remove from `core-js@4`
		requireEsnext_promise_try();
		requireEsnext_promise_withResolvers();

		promise$2 = parent;
		return promise$2;
	}

	var esnext_aggregateError = {};

	var hasRequiredEsnext_aggregateError;

	function requireEsnext_aggregateError () {
		if (hasRequiredEsnext_aggregateError) return esnext_aggregateError;
		hasRequiredEsnext_aggregateError = 1;
		// TODO: Remove from `core-js@4`
		requireEs_aggregateError();
		return esnext_aggregateError;
	}

	var esnext_promise_allSettled = {};

	var hasRequiredEsnext_promise_allSettled;

	function requireEsnext_promise_allSettled () {
		if (hasRequiredEsnext_promise_allSettled) return esnext_promise_allSettled;
		hasRequiredEsnext_promise_allSettled = 1;
		// TODO: Remove from `core-js@4`
		requireEs_promise_allSettled();
		return esnext_promise_allSettled;
	}

	var esnext_promise_any = {};

	var hasRequiredEsnext_promise_any;

	function requireEsnext_promise_any () {
		if (hasRequiredEsnext_promise_any) return esnext_promise_any;
		hasRequiredEsnext_promise_any = 1;
		// TODO: Remove from `core-js@4`
		requireEs_promise_any();
		return esnext_promise_any;
	}

	var promise$1;
	var hasRequiredPromise$1;

	function requirePromise$1 () {
		if (hasRequiredPromise$1) return promise$1;
		hasRequiredPromise$1 = 1;
		var parent = /*@__PURE__*/ requirePromise$2();
		// TODO: Remove from `core-js@4`
		requireEsnext_aggregateError();
		requireEsnext_promise_allSettled();
		requireEsnext_promise_any();

		promise$1 = parent;
		return promise$1;
	}

	var promise;
	var hasRequiredPromise;

	function requirePromise () {
		if (hasRequiredPromise) return promise;
		hasRequiredPromise = 1;
		promise = /*@__PURE__*/ requirePromise$1();
		return promise;
	}

	var promiseExports = /*@__PURE__*/ requirePromise();
	var _Promise = /*@__PURE__*/getDefaultExportFromCjs(promiseExports);

	function asyncGeneratorStep(n, t, e, r, o, a, c) {
	  try {
	    var i = n[a](c),
	      u = i.value;
	  } catch (n) {
	    return void e(n);
	  }
	  i.done ? t(u) : _Promise.resolve(u).then(r, o);
	}
	function _asyncToGenerator(n) {
	  return function () {
	    var t = this,
	      e = arguments;
	    return new _Promise(function (r, o) {
	      var a = n.apply(t, e);
	      function _next(n) {
	        asyncGeneratorStep(a, r, o, _next, _throw, "next", n);
	      }
	      function _throw(n) {
	        asyncGeneratorStep(a, r, o, _next, _throw, "throw", n);
	      }
	      _next(void 0);
	    });
	  };
	}

	var regeneratorRuntime$1 = {exports: {}};

	var _typeof = {exports: {}};

	var hasRequired_typeof;
	function require_typeof() {
	  if (hasRequired_typeof) return _typeof.exports;
	  hasRequired_typeof = 1;
	  (function (module) {
	    var _Symbol = /*@__PURE__*/requireSymbol$1();
	    var _Symbol$iterator = /*@__PURE__*/requireIterator$1();
	    function _typeof(o) {
	      "@babel/helpers - typeof";

	      return module.exports = _typeof = "function" == typeof _Symbol && "symbol" == typeof _Symbol$iterator ? function (o) {
	        return typeof o;
	      } : function (o) {
	        return o && "function" == typeof _Symbol && o.constructor === _Symbol && o !== _Symbol.prototype ? "symbol" : typeof o;
	      }, module.exports.__esModule = true, module.exports["default"] = module.exports, _typeof(o);
	    }
	    module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;
	  })(_typeof);
	  return _typeof.exports;
	}

	var forEach$2;
	var hasRequiredForEach$2;

	function requireForEach$2 () {
		if (hasRequiredForEach$2) return forEach$2;
		hasRequiredForEach$2 = 1;
		var parent = /*@__PURE__*/ requireForEach$4();

		forEach$2 = parent;
		return forEach$2;
	}

	var forEach$1;
	var hasRequiredForEach$1;

	function requireForEach$1 () {
		if (hasRequiredForEach$1) return forEach$1;
		hasRequiredForEach$1 = 1;
		var parent = /*@__PURE__*/ requireForEach$2();

		forEach$1 = parent;
		return forEach$1;
	}

	var forEach;
	var hasRequiredForEach;

	function requireForEach () {
		if (hasRequiredForEach) return forEach;
		hasRequiredForEach = 1;
		forEach = /*@__PURE__*/ requireForEach$1();
		return forEach;
	}

	var es_array_push = {};

	var arraySetLength;
	var hasRequiredArraySetLength;

	function requireArraySetLength () {
		if (hasRequiredArraySetLength) return arraySetLength;
		hasRequiredArraySetLength = 1;
		var DESCRIPTORS = /*@__PURE__*/ requireDescriptors();
		var isArray = /*@__PURE__*/ requireIsArray$7();

		var $TypeError = TypeError;
		// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
		var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

		// Safari < 13 does not throw an error in this case
		var SILENT_ON_NON_WRITABLE_LENGTH_SET = DESCRIPTORS && !function () {
		  // makes no sense without proper strict mode support
		  if (this !== undefined) return true;
		  try {
		    // eslint-disable-next-line es/no-object-defineproperty -- safe
		    Object.defineProperty([], 'length', { writable: false }).length = 1;
		  } catch (error) {
		    return error instanceof TypeError;
		  }
		}();

		arraySetLength = SILENT_ON_NON_WRITABLE_LENGTH_SET ? function (O, length) {
		  if (isArray(O) && !getOwnPropertyDescriptor(O, 'length').writable) {
		    throw new $TypeError('Cannot set read only .length');
		  } return O.length = length;
		} : function (O, length) {
		  return O.length = length;
		};
		return arraySetLength;
	}

	var hasRequiredEs_array_push;

	function requireEs_array_push () {
		if (hasRequiredEs_array_push) return es_array_push;
		hasRequiredEs_array_push = 1;
		var $ = /*@__PURE__*/ require_export();
		var toObject = /*@__PURE__*/ requireToObject();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var setArrayLength = /*@__PURE__*/ requireArraySetLength();
		var doesNotExceedSafeInteger = /*@__PURE__*/ requireDoesNotExceedSafeInteger();
		var fails = /*@__PURE__*/ requireFails();

		var INCORRECT_TO_LENGTH = fails(function () {
		  return [].push.call({ length: 0x100000000 }, 1) !== 4294967297;
		});

		// V8 <= 121 and Safari <= 15.4; FF < 23 throws InternalError
		// https://bugs.chromium.org/p/v8/issues/detail?id=12681
		var properErrorOnNonWritableLength = function () {
		  try {
		    // eslint-disable-next-line es/no-object-defineproperty -- safe
		    Object.defineProperty([], 'length', { writable: false }).push();
		  } catch (error) {
		    return error instanceof TypeError;
		  }
		};

		var FORCED = INCORRECT_TO_LENGTH || !properErrorOnNonWritableLength();

		// `Array.prototype.push` method
		// https://tc39.es/ecma262/#sec-array.prototype.push
		$({ target: 'Array', proto: true, arity: 1, forced: FORCED }, {
		  // eslint-disable-next-line no-unused-vars -- required for `.length`
		  push: function push(item) {
		    var O = toObject(this);
		    var len = lengthOfArrayLike(O);
		    var argCount = arguments.length;
		    doesNotExceedSafeInteger(len + argCount);
		    for (var i = 0; i < argCount; i++) {
		      O[len] = arguments[i];
		      len++;
		    }
		    setArrayLength(O, len);
		    return len;
		  }
		});
		return es_array_push;
	}

	var push$5;
	var hasRequiredPush$5;

	function requirePush$5 () {
		if (hasRequiredPush$5) return push$5;
		hasRequiredPush$5 = 1;
		requireEs_array_push();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		push$5 = getBuiltInPrototypeMethod('Array', 'push');
		return push$5;
	}

	var push$4;
	var hasRequiredPush$4;

	function requirePush$4 () {
		if (hasRequiredPush$4) return push$4;
		hasRequiredPush$4 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requirePush$5();

		var ArrayPrototype = Array.prototype;

		push$4 = function (it) {
		  var own = it.push;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.push) ? method : own;
		};
		return push$4;
	}

	var push$3;
	var hasRequiredPush$3;

	function requirePush$3 () {
		if (hasRequiredPush$3) return push$3;
		hasRequiredPush$3 = 1;
		var parent = /*@__PURE__*/ requirePush$4();

		push$3 = parent;
		return push$3;
	}

	var push$2;
	var hasRequiredPush$2;

	function requirePush$2 () {
		if (hasRequiredPush$2) return push$2;
		hasRequiredPush$2 = 1;
		var parent = /*@__PURE__*/ requirePush$3();

		push$2 = parent;
		return push$2;
	}

	var push$1;
	var hasRequiredPush$1;

	function requirePush$1 () {
		if (hasRequiredPush$1) return push$1;
		hasRequiredPush$1 = 1;
		var parent = /*@__PURE__*/ requirePush$2();

		push$1 = parent;
		return push$1;
	}

	var push;
	var hasRequiredPush;

	function requirePush () {
		if (hasRequiredPush) return push;
		hasRequiredPush = 1;
		push = /*@__PURE__*/ requirePush$1();
		return push;
	}

	var es_array_unshift = {};

	var deletePropertyOrThrow;
	var hasRequiredDeletePropertyOrThrow;

	function requireDeletePropertyOrThrow () {
		if (hasRequiredDeletePropertyOrThrow) return deletePropertyOrThrow;
		hasRequiredDeletePropertyOrThrow = 1;
		var tryToString = /*@__PURE__*/ requireTryToString();

		var $TypeError = TypeError;

		deletePropertyOrThrow = function (O, P) {
		  if (!delete O[P]) throw new $TypeError('Cannot delete property ' + tryToString(P) + ' of ' + tryToString(O));
		};
		return deletePropertyOrThrow;
	}

	var hasRequiredEs_array_unshift;

	function requireEs_array_unshift () {
		if (hasRequiredEs_array_unshift) return es_array_unshift;
		hasRequiredEs_array_unshift = 1;
		var $ = /*@__PURE__*/ require_export();
		var toObject = /*@__PURE__*/ requireToObject();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var setArrayLength = /*@__PURE__*/ requireArraySetLength();
		var deletePropertyOrThrow = /*@__PURE__*/ requireDeletePropertyOrThrow();
		var doesNotExceedSafeInteger = /*@__PURE__*/ requireDoesNotExceedSafeInteger();

		// IE8-
		var INCORRECT_RESULT = [].unshift(0) !== 1;

		// V8 ~ Chrome < 71 and Safari <= 15.4, FF < 23 throws InternalError
		var properErrorOnNonWritableLength = function () {
		  try {
		    // eslint-disable-next-line es/no-object-defineproperty -- safe
		    Object.defineProperty([], 'length', { writable: false }).unshift();
		  } catch (error) {
		    return error instanceof TypeError;
		  }
		};

		var FORCED = INCORRECT_RESULT || !properErrorOnNonWritableLength();

		// `Array.prototype.unshift` method
		// https://tc39.es/ecma262/#sec-array.prototype.unshift
		$({ target: 'Array', proto: true, arity: 1, forced: FORCED }, {
		  // eslint-disable-next-line no-unused-vars -- required for `.length`
		  unshift: function unshift(item) {
		    var O = toObject(this);
		    var len = lengthOfArrayLike(O);
		    var argCount = arguments.length;
		    if (argCount) {
		      doesNotExceedSafeInteger(len + argCount);
		      var k = len;
		      while (k--) {
		        var to = k + argCount;
		        if (k in O) O[to] = O[k];
		        else deletePropertyOrThrow(O, to);
		      }
		      for (var j = 0; j < argCount; j++) {
		        O[j] = arguments[j];
		      }
		    } return setArrayLength(O, len + argCount);
		  }
		});
		return es_array_unshift;
	}

	var unshift$5;
	var hasRequiredUnshift$5;

	function requireUnshift$5 () {
		if (hasRequiredUnshift$5) return unshift$5;
		hasRequiredUnshift$5 = 1;
		requireEs_array_unshift();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		unshift$5 = getBuiltInPrototypeMethod('Array', 'unshift');
		return unshift$5;
	}

	var unshift$4;
	var hasRequiredUnshift$4;

	function requireUnshift$4 () {
		if (hasRequiredUnshift$4) return unshift$4;
		hasRequiredUnshift$4 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireUnshift$5();

		var ArrayPrototype = Array.prototype;

		unshift$4 = function (it) {
		  var own = it.unshift;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.unshift) ? method : own;
		};
		return unshift$4;
	}

	var unshift$3;
	var hasRequiredUnshift$3;

	function requireUnshift$3 () {
		if (hasRequiredUnshift$3) return unshift$3;
		hasRequiredUnshift$3 = 1;
		var parent = /*@__PURE__*/ requireUnshift$4();

		unshift$3 = parent;
		return unshift$3;
	}

	var unshift$2;
	var hasRequiredUnshift$2;

	function requireUnshift$2 () {
		if (hasRequiredUnshift$2) return unshift$2;
		hasRequiredUnshift$2 = 1;
		var parent = /*@__PURE__*/ requireUnshift$3();

		unshift$2 = parent;
		return unshift$2;
	}

	var unshift$1;
	var hasRequiredUnshift$1;

	function requireUnshift$1 () {
		if (hasRequiredUnshift$1) return unshift$1;
		hasRequiredUnshift$1 = 1;
		var parent = /*@__PURE__*/ requireUnshift$2();

		unshift$1 = parent;
		return unshift$1;
	}

	var unshift;
	var hasRequiredUnshift;

	function requireUnshift () {
		if (hasRequiredUnshift) return unshift;
		hasRequiredUnshift = 1;
		unshift = /*@__PURE__*/ requireUnshift$1();
		return unshift;
	}

	var slice$2;
	var hasRequiredSlice$2;

	function requireSlice$2 () {
		if (hasRequiredSlice$2) return slice$2;
		hasRequiredSlice$2 = 1;
		var parent = /*@__PURE__*/ requireSlice$4();

		slice$2 = parent;
		return slice$2;
	}

	var slice$1;
	var hasRequiredSlice$1;

	function requireSlice$1 () {
		if (hasRequiredSlice$1) return slice$1;
		hasRequiredSlice$1 = 1;
		var parent = /*@__PURE__*/ requireSlice$2();

		slice$1 = parent;
		return slice$1;
	}

	var slice;
	var hasRequiredSlice;

	function requireSlice () {
		if (hasRequiredSlice) return slice;
		hasRequiredSlice = 1;
		slice = /*@__PURE__*/ requireSlice$1();
		return slice;
	}

	var hasRequiredRegeneratorRuntime;
	function requireRegeneratorRuntime() {
	  if (hasRequiredRegeneratorRuntime) return regeneratorRuntime$1.exports;
	  hasRequiredRegeneratorRuntime = 1;
	  (function (module) {
	    var _typeof = require_typeof()["default"];
	    var _Symbol = /*@__PURE__*/requireSymbol$1();
	    var _Object$defineProperty = /*@__PURE__*/requireDefineProperty();
	    var _Object$create = /*@__PURE__*/requireCreate();
	    var _Object$getPrototypeOf = /*@__PURE__*/requireGetPrototypeOf$1();
	    var _forEachInstanceProperty = /*@__PURE__*/requireForEach();
	    var _pushInstanceProperty = /*@__PURE__*/requirePush();
	    var _Object$setPrototypeOf = /*@__PURE__*/requireSetPrototypeOf();
	    var _Promise = /*@__PURE__*/requirePromise();
	    var _unshiftInstanceProperty = /*@__PURE__*/requireUnshift();
	    var _sliceInstanceProperty = /*@__PURE__*/requireSlice();
	    function _regeneratorRuntime() {

	      /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */
	      module.exports = _regeneratorRuntime = function _regeneratorRuntime() {
	        return r;
	      }, module.exports.__esModule = true, module.exports["default"] = module.exports;
	      var t,
	        r = {},
	        e = Object.prototype,
	        n = e.hasOwnProperty,
	        o = "function" == typeof _Symbol ? _Symbol : {},
	        i = o.iterator || "@@iterator",
	        a = o.asyncIterator || "@@asyncIterator",
	        u = o.toStringTag || "@@toStringTag";
	      function c(t, r, e, n) {
	        return _Object$defineProperty(t, r, {
	          value: e,
	          enumerable: !n,
	          configurable: !n,
	          writable: !n
	        });
	      }
	      try {
	        c({}, "");
	      } catch (t) {
	        c = function c(t, r, e) {
	          return t[r] = e;
	        };
	      }
	      function h(r, e, n, o) {
	        var i = e && e.prototype instanceof Generator ? e : Generator,
	          a = _Object$create(i.prototype);
	        return c(a, "_invoke", function (r, e, n) {
	          var o = 1;
	          return function (i, a) {
	            if (3 === o) throw Error("Generator is already running");
	            if (4 === o) {
	              if ("throw" === i) throw a;
	              return {
	                value: t,
	                done: true
	              };
	            }
	            for (n.method = i, n.arg = a;;) {
	              var u = n.delegate;
	              if (u) {
	                var c = d(u, n);
	                if (c) {
	                  if (c === f) continue;
	                  return c;
	                }
	              }
	              if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) {
	                if (1 === o) throw o = 4, n.arg;
	                n.dispatchException(n.arg);
	              } else "return" === n.method && n.abrupt("return", n.arg);
	              o = 3;
	              var h = s(r, e, n);
	              if ("normal" === h.type) {
	                if (o = n.done ? 4 : 2, h.arg === f) continue;
	                return {
	                  value: h.arg,
	                  done: n.done
	                };
	              }
	              "throw" === h.type && (o = 4, n.method = "throw", n.arg = h.arg);
	            }
	          };
	        }(r, n, new Context(o || [])), true), a;
	      }
	      function s(t, r, e) {
	        try {
	          return {
	            type: "normal",
	            arg: t.call(r, e)
	          };
	        } catch (t) {
	          return {
	            type: "throw",
	            arg: t
	          };
	        }
	      }
	      r.wrap = h;
	      var f = {};
	      function Generator() {}
	      function GeneratorFunction() {}
	      function GeneratorFunctionPrototype() {}
	      var l = {};
	      c(l, i, function () {
	        return this;
	      });
	      var p = _Object$getPrototypeOf,
	        y = p && p(p(x([])));
	      y && y !== e && n.call(y, i) && (l = y);
	      var v = GeneratorFunctionPrototype.prototype = Generator.prototype = _Object$create(l);
	      function g(t) {
	        var _context;
	        _forEachInstanceProperty(_context = ["next", "throw", "return"]).call(_context, function (r) {
	          c(t, r, function (t) {
	            return this._invoke(r, t);
	          });
	        });
	      }
	      function AsyncIterator(t, r) {
	        function e(o, i, a, u) {
	          var c = s(t[o], t, i);
	          if ("throw" !== c.type) {
	            var h = c.arg,
	              f = h.value;
	            return f && "object" == _typeof(f) && n.call(f, "__await") ? r.resolve(f.__await).then(function (t) {
	              e("next", t, a, u);
	            }, function (t) {
	              e("throw", t, a, u);
	            }) : r.resolve(f).then(function (t) {
	              h.value = t, a(h);
	            }, function (t) {
	              return e("throw", t, a, u);
	            });
	          }
	          u(c.arg);
	        }
	        var o;
	        c(this, "_invoke", function (t, n) {
	          function i() {
	            return new r(function (r, o) {
	              e(t, n, r, o);
	            });
	          }
	          return o = o ? o.then(i, i) : i();
	        }, true);
	      }
	      function d(r, e) {
	        var n = e.method,
	          o = r.i[n];
	        if (o === t) return e.delegate = null, "throw" === n && r.i["return"] && (e.method = "return", e.arg = t, d(r, e), "throw" === e.method) || "return" !== n && (e.method = "throw", e.arg = new TypeError("The iterator does not provide a '" + n + "' method")), f;
	        var i = s(o, r.i, e.arg);
	        if ("throw" === i.type) return e.method = "throw", e.arg = i.arg, e.delegate = null, f;
	        var a = i.arg;
	        return a ? a.done ? (e[r.r] = a.value, e.next = r.n, "return" !== e.method && (e.method = "next", e.arg = t), e.delegate = null, f) : a : (e.method = "throw", e.arg = new TypeError("iterator result is not an object"), e.delegate = null, f);
	      }
	      function w(t) {
	        var _context2;
	        _pushInstanceProperty(_context2 = this.tryEntries).call(_context2, t);
	      }
	      function m(r) {
	        var e = r[4] || {};
	        e.type = "normal", e.arg = t, r[4] = e;
	      }
	      function Context(t) {
	        this.tryEntries = [[-1]], _forEachInstanceProperty(t).call(t, w, this), this.reset(true);
	      }
	      function x(r) {
	        if (null != r) {
	          var e = r[i];
	          if (e) return e.call(r);
	          if ("function" == typeof r.next) return r;
	          if (!isNaN(r.length)) {
	            var o = -1,
	              a = function e() {
	                for (; ++o < r.length;) if (n.call(r, o)) return e.value = r[o], e.done = false, e;
	                return e.value = t, e.done = true, e;
	              };
	            return a.next = a;
	          }
	        }
	        throw new TypeError(_typeof(r) + " is not iterable");
	      }
	      return GeneratorFunction.prototype = GeneratorFunctionPrototype, c(v, "constructor", GeneratorFunctionPrototype), c(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = c(GeneratorFunctionPrototype, u, "GeneratorFunction"), r.isGeneratorFunction = function (t) {
	        var r = "function" == typeof t && t.constructor;
	        return !!r && (r === GeneratorFunction || "GeneratorFunction" === (r.displayName || r.name));
	      }, r.mark = function (t) {
	        return _Object$setPrototypeOf ? _Object$setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, c(t, u, "GeneratorFunction")), t.prototype = _Object$create(v), t;
	      }, r.awrap = function (t) {
	        return {
	          __await: t
	        };
	      }, g(AsyncIterator.prototype), c(AsyncIterator.prototype, a, function () {
	        return this;
	      }), r.AsyncIterator = AsyncIterator, r.async = function (t, e, n, o, i) {
	        void 0 === i && (i = _Promise);
	        var a = new AsyncIterator(h(t, e, n, o), i);
	        return r.isGeneratorFunction(e) ? a : a.next().then(function (t) {
	          return t.done ? t.value : a.next();
	        });
	      }, g(v), c(v, u, "Generator"), c(v, i, function () {
	        return this;
	      }), c(v, "toString", function () {
	        return "[object Generator]";
	      }), r.keys = function (t) {
	        var r = Object(t),
	          e = [];
	        for (var n in r) _unshiftInstanceProperty(e).call(e, n);
	        return function t() {
	          for (; e.length;) if ((n = e.pop()) in r) return t.value = n, t.done = false, t;
	          return t.done = true, t;
	        };
	      }, r.values = x, Context.prototype = {
	        constructor: Context,
	        reset: function reset(r) {
	          var _context3;
	          if (this.prev = this.next = 0, this.sent = this._sent = t, this.done = false, this.delegate = null, this.method = "next", this.arg = t, _forEachInstanceProperty(_context3 = this.tryEntries).call(_context3, m), !r) for (var e in this) "t" === e.charAt(0) && n.call(this, e) && !isNaN(+_sliceInstanceProperty(e).call(e, 1)) && (this[e] = t);
	        },
	        stop: function stop() {
	          this.done = true;
	          var t = this.tryEntries[0][4];
	          if ("throw" === t.type) throw t.arg;
	          return this.rval;
	        },
	        dispatchException: function dispatchException(r) {
	          if (this.done) throw r;
	          var e = this;
	          function n(t) {
	            a.type = "throw", a.arg = r, e.next = t;
	          }
	          for (var o = e.tryEntries.length - 1; o >= 0; --o) {
	            var i = this.tryEntries[o],
	              a = i[4],
	              u = this.prev,
	              c = i[1],
	              h = i[2];
	            if (-1 === i[0]) return n("end"), false;
	            if (!c && !h) throw Error("try statement without catch or finally");
	            if (null != i[0] && i[0] <= u) {
	              if (u < c) return this.method = "next", this.arg = t, n(c), true;
	              if (u < h) return n(h), false;
	            }
	          }
	        },
	        abrupt: function abrupt(t, r) {
	          for (var e = this.tryEntries.length - 1; e >= 0; --e) {
	            var n = this.tryEntries[e];
	            if (n[0] > -1 && n[0] <= this.prev && this.prev < n[2]) {
	              var o = n;
	              break;
	            }
	          }
	          o && ("break" === t || "continue" === t) && o[0] <= r && r <= o[2] && (o = null);
	          var i = o ? o[4] : {};
	          return i.type = t, i.arg = r, o ? (this.method = "next", this.next = o[2], f) : this.complete(i);
	        },
	        complete: function complete(t, r) {
	          if ("throw" === t.type) throw t.arg;
	          return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && r && (this.next = r), f;
	        },
	        finish: function finish(t) {
	          for (var r = this.tryEntries.length - 1; r >= 0; --r) {
	            var e = this.tryEntries[r];
	            if (e[2] === t) return this.complete(e[4], e[3]), m(e), f;
	          }
	        },
	        "catch": function _catch(t) {
	          for (var r = this.tryEntries.length - 1; r >= 0; --r) {
	            var e = this.tryEntries[r];
	            if (e[0] === t) {
	              var n = e[4];
	              if ("throw" === n.type) {
	                var o = n.arg;
	                m(e);
	              }
	              return o;
	            }
	          }
	          throw Error("illegal catch attempt");
	        },
	        delegateYield: function delegateYield(r, e, n) {
	          return this.delegate = {
	            i: x(r),
	            r: e,
	            n: n
	          }, "next" === this.method && (this.arg = t), f;
	        }
	      }, r;
	    }
	    module.exports = _regeneratorRuntime, module.exports.__esModule = true, module.exports["default"] = module.exports;
	  })(regeneratorRuntime$1);
	  return regeneratorRuntime$1.exports;
	}

	var regenerator;
	var hasRequiredRegenerator;
	function requireRegenerator() {
	  if (hasRequiredRegenerator) return regenerator;
	  hasRequiredRegenerator = 1;
	  // TODO(Babel 8): Remove this file.

	  var runtime = requireRegeneratorRuntime()();
	  regenerator = runtime;

	  // Copied from https://github.com/facebook/regenerator/blob/main/packages/runtime/runtime.js#L736=
	  try {
	    regeneratorRuntime = runtime;
	  } catch (accidentalStrictMode) {
	    if ((typeof _globalThis$3 === "undefined" ? "undefined" : _typeof$1(_globalThis$3)) === "object") {
	      _globalThis$3.regeneratorRuntime = runtime;
	    } else {
	      Function("r", "regeneratorRuntime = r")(runtime);
	    }
	  }
	  return regenerator;
	}

	var regeneratorExports = requireRegenerator();
	var _regeneratorRuntime = /*@__PURE__*/getDefaultExportFromCjs(regeneratorExports);

	var browser$1 = {};

	var build$l = {};

	var isArray$4;
	var hasRequiredIsArray$3;

	function requireIsArray$3 () {
		if (hasRequiredIsArray$3) return isArray$4;
		hasRequiredIsArray$3 = 1;
		var parent = /*@__PURE__*/ requireIsArray$5();

		isArray$4 = parent;
		return isArray$4;
	}

	var isArray$3;
	var hasRequiredIsArray$2;

	function requireIsArray$2 () {
		if (hasRequiredIsArray$2) return isArray$3;
		hasRequiredIsArray$2 = 1;
		var parent = /*@__PURE__*/ requireIsArray$3();

		isArray$3 = parent;
		return isArray$3;
	}

	var isArray$2;
	var hasRequiredIsArray$1;

	function requireIsArray$1 () {
		if (hasRequiredIsArray$1) return isArray$2;
		hasRequiredIsArray$1 = 1;
		isArray$2 = /*@__PURE__*/ requireIsArray$2();
		return isArray$2;
	}

	var isArrayExports = /*@__PURE__*/ requireIsArray$1();
	var _Array$isArray = /*@__PURE__*/getDefaultExportFromCjs(isArrayExports);

	function _arrayWithHoles(r) {
	  if (_Array$isArray(r)) return r;
	}

	var getIteratorMethodExports = /*@__PURE__*/ requireGetIteratorMethod$1();
	var _getIteratorMethod = /*@__PURE__*/getDefaultExportFromCjs(getIteratorMethodExports);

	var pushExports = /*@__PURE__*/ requirePush();
	var _pushInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(pushExports);

	function _iterableToArrayLimit(r, l) {
	  var t = null == r ? null : "undefined" != typeof _Symbol$2 && _getIteratorMethod(r) || r["@@iterator"];
	  if (null != t) {
	    var e,
	      n,
	      i,
	      u,
	      a = [],
	      f = true,
	      o = false;
	    try {
	      if (i = (t = t.call(r)).next, 0 === l) {
	        if (Object(t) !== t) return;
	        f = !1;
	      } else for (; !(f = (e = i.call(t)).done) && (_pushInstanceProperty(a).call(a, e.value), a.length !== l); f = !0);
	    } catch (r) {
	      o = true, n = r;
	    } finally {
	      try {
	        if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
	      } finally {
	        if (o) throw n;
	      }
	    }
	    return a;
	  }
	}

	var sliceExports = /*@__PURE__*/ requireSlice();
	var _sliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(sliceExports);

	var from$2;
	var hasRequiredFrom$2;

	function requireFrom$2 () {
		if (hasRequiredFrom$2) return from$2;
		hasRequiredFrom$2 = 1;
		var parent = /*@__PURE__*/ requireFrom$4();

		from$2 = parent;
		return from$2;
	}

	var from$1;
	var hasRequiredFrom$1;

	function requireFrom$1 () {
		if (hasRequiredFrom$1) return from$1;
		hasRequiredFrom$1 = 1;
		var parent = /*@__PURE__*/ requireFrom$2();

		from$1 = parent;
		return from$1;
	}

	var from;
	var hasRequiredFrom;

	function requireFrom () {
		if (hasRequiredFrom) return from;
		hasRequiredFrom = 1;
		from = /*@__PURE__*/ requireFrom$1();
		return from;
	}

	var fromExports = /*@__PURE__*/ requireFrom();
	var _Array$from = /*@__PURE__*/getDefaultExportFromCjs(fromExports);

	function _arrayLikeToArray$w(r, a) {
	  (null == a || a > r.length) && (a = r.length);
	  for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
	  return n;
	}

	function _unsupportedIterableToArray$w(r, a) {
	  if (r) {
	    var _context;
	    if ("string" == typeof r) return _arrayLikeToArray$w(r, a);
	    var t = _sliceInstanceProperty(_context = {}.toString.call(r)).call(_context, 8, -1);
	    return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? _Array$from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$w(r, a) : void 0;
	  }
	}

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _slicedToArray(r, e) {
	  return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray$w(r, e) || _nonIterableRest();
	}

	var values$6;
	var hasRequiredValues$6;

	function requireValues$6 () {
		if (hasRequiredValues$6) return values$6;
		hasRequiredValues$6 = 1;
		requireEs_array_iterator();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		values$6 = getBuiltInPrototypeMethod('Array', 'values');
		return values$6;
	}

	var values$5;
	var hasRequiredValues$5;

	function requireValues$5 () {
		if (hasRequiredValues$5) return values$5;
		hasRequiredValues$5 = 1;
		var parent = /*@__PURE__*/ requireValues$6();

		values$5 = parent;
		return values$5;
	}

	var values$4;
	var hasRequiredValues$4;

	function requireValues$4 () {
		if (hasRequiredValues$4) return values$4;
		hasRequiredValues$4 = 1;
		requireWeb_domCollections_iterator();
		var classof = /*@__PURE__*/ requireClassof();
		var hasOwn = /*@__PURE__*/ requireHasOwnProperty();
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireValues$5();

		var ArrayPrototype = Array.prototype;

		var DOMIterables = {
		  DOMTokenList: true,
		  NodeList: true
		};

		values$4 = function (it) {
		  var own = it.values;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.values)
		    || hasOwn(DOMIterables, classof(it)) ? method : own;
		};
		return values$4;
	}

	var values$3;
	var hasRequiredValues$3;
	function requireValues$3() {
	  if (hasRequiredValues$3) return values$3;
	  hasRequiredValues$3 = 1;
	  values$3 = /*@__PURE__*/requireValues$4();
	  return values$3;
	}

	var valuesExports$1 = requireValues$3();
	var _valuesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(valuesExports$1);

	var eventProcessor = {};

	var enums = {};

	var hasRequiredEnums;
	function requireEnums() {
	  if (hasRequiredEnums) return enums;
	  hasRequiredEnums = 1;
	  /*
	   * Copyright The OpenTelemetry Authors
	   *
	   * Licensed under the Apache License, Version 2.0 (the "License");
	   * you may not use this file except in compliance with the License.
	   * You may obtain a copy of the License at
	   *
	   *      https://www.apache.org/licenses/LICENSE-2.0
	   *
	   * Unless required by applicable law or agreed to in writing, software
	   * distributed under the License is distributed on an "AS IS" BASIS,
	   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   * See the License for the specific language governing permissions and
	   * limitations under the License.
	   */
	  _Object$defineProperty$1(enums, "__esModule", {
	    value: true
	  });
	  enums.ExceptionEventName = void 0;
	  // Event name definitions
	  enums.ExceptionEventName = 'exception';
	  return enums;
	}

	var utils$5 = {};

	var es_array_splice = {};

	var hasRequiredEs_array_splice;

	function requireEs_array_splice () {
		if (hasRequiredEs_array_splice) return es_array_splice;
		hasRequiredEs_array_splice = 1;
		var $ = /*@__PURE__*/ require_export();
		var toObject = /*@__PURE__*/ requireToObject();
		var toAbsoluteIndex = /*@__PURE__*/ requireToAbsoluteIndex();
		var toIntegerOrInfinity = /*@__PURE__*/ requireToIntegerOrInfinity();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var setArrayLength = /*@__PURE__*/ requireArraySetLength();
		var doesNotExceedSafeInteger = /*@__PURE__*/ requireDoesNotExceedSafeInteger();
		var arraySpeciesCreate = /*@__PURE__*/ requireArraySpeciesCreate();
		var createProperty = /*@__PURE__*/ requireCreateProperty();
		var deletePropertyOrThrow = /*@__PURE__*/ requireDeletePropertyOrThrow();
		var arrayMethodHasSpeciesSupport = /*@__PURE__*/ requireArrayMethodHasSpeciesSupport();

		var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('splice');

		var max = Math.max;
		var min = Math.min;

		// `Array.prototype.splice` method
		// https://tc39.es/ecma262/#sec-array.prototype.splice
		// with adding support of @@species
		$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
		  splice: function splice(start, deleteCount /* , ...items */) {
		    var O = toObject(this);
		    var len = lengthOfArrayLike(O);
		    var actualStart = toAbsoluteIndex(start, len);
		    var argumentsLength = arguments.length;
		    var insertCount, actualDeleteCount, A, k, from, to;
		    if (argumentsLength === 0) {
		      insertCount = actualDeleteCount = 0;
		    } else if (argumentsLength === 1) {
		      insertCount = 0;
		      actualDeleteCount = len - actualStart;
		    } else {
		      insertCount = argumentsLength - 2;
		      actualDeleteCount = min(max(toIntegerOrInfinity(deleteCount), 0), len - actualStart);
		    }
		    doesNotExceedSafeInteger(len + insertCount - actualDeleteCount);
		    A = arraySpeciesCreate(O, actualDeleteCount);
		    for (k = 0; k < actualDeleteCount; k++) {
		      from = actualStart + k;
		      if (from in O) createProperty(A, k, O[from]);
		    }
		    A.length = actualDeleteCount;
		    if (insertCount < actualDeleteCount) {
		      for (k = actualStart; k < len - actualDeleteCount; k++) {
		        from = k + actualDeleteCount;
		        to = k + insertCount;
		        if (from in O) O[to] = O[from];
		        else deletePropertyOrThrow(O, to);
		      }
		      for (k = len; k > len - actualDeleteCount + insertCount; k--) deletePropertyOrThrow(O, k - 1);
		    } else if (insertCount > actualDeleteCount) {
		      for (k = len - actualDeleteCount; k > actualStart; k--) {
		        from = k + actualDeleteCount - 1;
		        to = k + insertCount - 1;
		        if (from in O) O[to] = O[from];
		        else deletePropertyOrThrow(O, to);
		      }
		    }
		    for (k = 0; k < insertCount; k++) {
		      O[k + actualStart] = arguments[k + 2];
		    }
		    setArrayLength(O, len - actualDeleteCount + insertCount);
		    return A;
		  }
		});
		return es_array_splice;
	}

	var splice$3;
	var hasRequiredSplice$3;

	function requireSplice$3 () {
		if (hasRequiredSplice$3) return splice$3;
		hasRequiredSplice$3 = 1;
		requireEs_array_splice();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		splice$3 = getBuiltInPrototypeMethod('Array', 'splice');
		return splice$3;
	}

	var splice$2;
	var hasRequiredSplice$2;

	function requireSplice$2 () {
		if (hasRequiredSplice$2) return splice$2;
		hasRequiredSplice$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireSplice$3();

		var ArrayPrototype = Array.prototype;

		splice$2 = function (it) {
		  var own = it.splice;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.splice) ? method : own;
		};
		return splice$2;
	}

	var splice$1;
	var hasRequiredSplice$1;

	function requireSplice$1 () {
		if (hasRequiredSplice$1) return splice$1;
		hasRequiredSplice$1 = 1;
		var parent = /*@__PURE__*/ requireSplice$2();

		splice$1 = parent;
		return splice$1;
	}

	var splice;
	var hasRequiredSplice;
	function requireSplice() {
	  if (hasRequiredSplice) return splice;
	  hasRequiredSplice = 1;
	  splice = /*@__PURE__*/requireSplice$1();
	  return splice;
	}

	var spliceExports = requireSplice();
	var _spliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(spliceExports);

	var stringify$1 = {exports: {}};

	var hasRequiredStringify$1;
	function requireStringify$1() {
	  if (hasRequiredStringify$1) return stringify$1.exports;
	  hasRequiredStringify$1 = 1;
	  (function (module, exports) {
	    exports = module.exports = stringify;
	    exports.getSerialize = serializer;
	    function stringify(obj, replacer, spaces, cycleReplacer) {
	      return _JSON$stringify(obj, serializer(replacer, cycleReplacer), spaces);
	    }
	    function serializer(replacer, cycleReplacer) {
	      var stack = [],
	        keys = [];
	      if (cycleReplacer == null) cycleReplacer = function cycleReplacer(key, value) {
	        if (stack[0] === value) return "[Circular ~]";
	        return "[Circular ~." + _sliceInstanceProperty$1(keys).call(keys, 0, _indexOfInstanceProperty$1(stack).call(stack, value)).join(".") + "]";
	      };
	      return function (key, value) {
	        if (stack.length > 0) {
	          var thisPos = _indexOfInstanceProperty$1(stack).call(stack, this);
	          ~thisPos ? _spliceInstanceProperty(stack).call(stack, thisPos + 1) : stack.push(this);
	          ~thisPos ? _spliceInstanceProperty(keys).call(keys, thisPos, Infinity, key) : keys.push(key);
	          if (~_indexOfInstanceProperty$1(stack).call(stack, value)) value = cycleReplacer.call(this, key, value);
	        } else stack.push(value);
	        return replacer == null ? value : replacer.call(this, key, value);
	      };
	    }
	  })(stringify$1, stringify$1.exports);
	  return stringify$1.exports;
	}

	var hasRequiredUtils$5;
	function requireUtils$5() {
	  if (hasRequiredUtils$5) return utils$5;
	  hasRequiredUtils$5 = 1;
	  _Object$defineProperty$1(utils$5, "__esModule", {
	    value: true
	  });
	  utils$5.jsonToString = void 0;
	  var tslib_1 = require$$0$9;
	  var api_1 = require$$0$8;
	  var json_stringify_safe_1 = tslib_1.__importDefault(requireStringify$1());
	  var jsonToString = function jsonToString(json) {
	    try {
	      return _JSON$stringify(json);
	    } catch (e) {
	      api_1.diag.error('Failed to stringify json', e);
	      return (0, json_stringify_safe_1.default)(json);
	    }
	  };
	  utils$5.jsonToString = jsonToString;
	  return utils$5;
	}

	var version$c = {};

	var hasRequiredVersion$c;
	function requireVersion$c() {
	  if (hasRequiredVersion$c) return version$c;
	  hasRequiredVersion$c = 1;
	  _Object$defineProperty$1(version$c, "__esModule", {
	    value: true
	  });
	  version$c.VERSION = void 0;
	  version$c.VERSION = '0.0.17';
	  return version$c;
	}

	function _createForOfIteratorHelper$v(r, e) { var t = "undefined" != typeof _Symbol$1 && _getIteratorMethod$1(r) || r["@@iterator"]; if (!t) { if (_Array$isArray$1(r) || (t = _unsupportedIterableToArray$v(r)) || e) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: true } : { done: false, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = true, u = false; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = true, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
	function _unsupportedIterableToArray$v(r, a) { if (r) { var _context4; if ("string" == typeof r) return _arrayLikeToArray$v(r, a); var t = _sliceInstanceProperty$1(_context4 = {}.toString.call(r)).call(_context4, 8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? _Array$from$1(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$v(r, a) : void 0; } }
	function _arrayLikeToArray$v(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
	function ownKeys$G(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols$1) { var o = _Object$getOwnPropertySymbols$1(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor$1(e, r).enumerable; })), t.push.apply(t, o); } return t; }
	function _objectSpread$G(e) { for (var r = 1; r < arguments.length; r++) { var _context2, _context3; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context2 = ownKeys$G(Object(t), true)).call(_context2, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context3 = ownKeys$G(Object(t))).call(_context3, function (r) { _Object$defineProperty$1(e, r, _Object$getOwnPropertyDescriptor$1(t, r)); }); } return e; }
	var hasRequiredEventProcessor;
	function requireEventProcessor() {
	  if (hasRequiredEventProcessor) return eventProcessor;
	  hasRequiredEventProcessor = 1;
	  (function (exports) {

	    _Object$defineProperty$1(exports, "__esModule", {
	      value: true
	    });
	    exports.getEventProcessor = exports.getSpanNameFromEvent = exports.isSentryEventAnException = exports.extractSpanEventsFromException = exports.extractSemAttrsFromEvent = exports.SEMATTRS_SENTRY_VERSION = exports.SEMATTRS_EXCEPTION_THREAD_ID = exports.SEMATTRS_EXCEPTION_TAGS = exports.SEMATTRS_EXCEPTION_PARSED_STACKTRACE = exports.SEMATTRS_EXCEPTION_MODULES = exports.SEMATTRS_EXCEPTION_MODULE = exports.SEMATTRS_EXCEPTION_MECHANISM = void 0;
	    var tslib_1 = require$$0$9;
	    var api_1 = tslib_1.__importStar(require$$0$8);
	    var enums_1 = /*@__PURE__*/requireEnums();
	    var semantic_conventions_1 = require$$3;
	    var utils_1 = requireUtils$5();
	    var version_1 = requireVersion$c();
	    var MODULE_NAME = "@imqa/instrumentation-node";
	    var defaultTracer = api_1.default.trace.getTracer(MODULE_NAME, version_1.VERSION);
	    exports.SEMATTRS_EXCEPTION_MECHANISM = 'exception.mechanism';
	    exports.SEMATTRS_EXCEPTION_MODULE = 'exception.module';
	    exports.SEMATTRS_EXCEPTION_MODULES = 'exception.modules';
	    exports.SEMATTRS_EXCEPTION_PARSED_STACKTRACE = 'exception.parsed_stacktrace';
	    exports.SEMATTRS_EXCEPTION_TAGS = 'exception.tags';
	    exports.SEMATTRS_EXCEPTION_THREAD_ID = 'exception.thread_id';
	    exports.SEMATTRS_SENTRY_VERSION = 'sentry.version';
	    var extractSemAttrsFromEvent = function extractSemAttrsFromEvent(event, hint, sentryVersion) {
	      var _context;
	      var _a, _b, _c, _d, _e, _f;
	      return _objectSpread$G(_objectSpread$G(_objectSpread$G(_objectSpread$G(_objectSpread$G(_objectSpread$G(_objectSpread$G(_objectSpread$G({}, sentryVersion && _defineProperty({}, exports.SEMATTRS_SENTRY_VERSION, sentryVersion)), event.modules && _defineProperty({}, exports.SEMATTRS_EXCEPTION_MODULES, (0, utils_1.jsonToString)(event.modules))), {}, _defineProperty({}, exports.SEMATTRS_EXCEPTION_TAGS, (0, utils_1.jsonToString)({
	        culture: (_a = event.contexts) === null || _a === void 0 ? void 0 : _a.culture,
	        dist: event.dist,
	        environment: event.environment,
	        mechanism: hint.mechanism,
	        release: event.release
	      })), ((_b = event.contexts) === null || _b === void 0 ? void 0 : _b.app) && {
	        'app.build_type': event.contexts.app.build_type,
	        'app.id': event.contexts.app.app_identifier,
	        'app.memory': event.contexts.app.app_memory,
	        'app.name': event.contexts.app.app_name,
	        'app.start_time': event.contexts.app.app_start_time,
	        'app.version': event.contexts.app.app_version
	      }), ((_c = event.contexts) === null || _c === void 0 ? void 0 : _c.response) && _objectSpread$G(_defineProperty(_defineProperty({}, semantic_conventions_1.SEMATTRS_HTTP_STATUS_CODE, event.contexts.response.status_code), semantic_conventions_1.SEMATTRS_HTTP_RESPONSE_CONTENT_LENGTH, event.contexts.response.body_size), (event.contexts.response.headers && _reduceInstanceProperty(_context = _Object$entries(event.contexts.response.headers)).call(_context, function (acc, _ref3) {
	        var _ref4 = _slicedToArray(_ref3, 2),
	          key = _ref4[0],
	          value = _ref4[1];
	        acc["http.response.header.".concat(key)] = value;
	        return acc;
	      }), {}))), ((_d = event.contexts) === null || _d === void 0 ? void 0 : _d.cloud_resource) && {
	        'cloud.provider': event.contexts.cloud_resource['cloud.provider'],
	        'cloud.account.id': event.contexts.cloud_resource['cloud.account.id'],
	        'cloud.region': event.contexts.cloud_resource['cloud.region'],
	        'cloud.availability_zone': event.contexts.cloud_resource['cloud.availability_zone'],
	        'cloud.platform': event.contexts.cloud_resource['cloud.platform'],
	        'host.id': event.contexts.cloud_resource['host.id'],
	        'host.type': event.contexts.cloud_resource['host.type']
	      }), ((_e = event.contexts) === null || _e === void 0 ? void 0 : _e.os) && {
	        'os.build_id': event.contexts.os.build,
	        'os.kernel_version': event.contexts.os.kernel_version,
	        'os.type': event.contexts.os.name,
	        'os.version': event.contexts.os.version
	      }), ((_f = event.contexts) === null || _f === void 0 ? void 0 : _f.device) && {
	        'device.id': event.contexts.device.device_unique_identifier,
	        'device.manufacturer': event.contexts.device.manufacturer,
	        'device.model.identifier': event.contexts.device.model_id,
	        'device.model.name': event.contexts.device.model,
	        'device.type': event.contexts.device.device_type,
	        'device.battery_level': event.contexts.device.battery_level,
	        'device.battery_status': event.contexts.device.battery_status,
	        'device.orientation': event.contexts.device.orientation,
	        'device.brand': event.contexts.device.brand,
	        'device.sreen_resolution': event.contexts.device.screen_resolution,
	        'device.screen_height_pixels': event.contexts.device.screen_height_pixels,
	        'device.screen_width_pixels': event.contexts.device.screen_width_pixels,
	        'device.screen_density': event.contexts.device.screen_density,
	        'device.screen_dpi': event.contexts.device.screen_dpi,
	        'device.online': event.contexts.device.online,
	        'device.charging': event.contexts.device.charging,
	        'device.supports_vibration': event.contexts.device.supports_vibration,
	        'device.supports_accelerometer': event.contexts.device.supports_accelerometer,
	        'device.supports_gyroscope': event.contexts.device.supports_gyroscope,
	        'device.supports_audio': event.contexts.device.supports_audio,
	        'device.supports_location_service': event.contexts.device.supports_location_service,
	        'device.boot_time': event.contexts.device.boot_time,
	        'device.low_memory': event.contexts.device.low_memory,
	        'device.simulator': event.contexts.device.simulator,
	        'device.memory_size': event.contexts.device.memory_size,
	        'device.free_memory': event.contexts.device.free_memory,
	        'device.usable_memory': event.contexts.device.usable_memory,
	        'device.storage_size': event.contexts.device.storage_size,
	        'device.free_storage': event.contexts.device.free_storage,
	        'device.external_storage_size': event.contexts.device.external_storage_size,
	        'device.external_free_storage': event.contexts.device.external_free_storage,
	        'host.cpu.model.name': event.contexts.device.cpu_description,
	        'host.cpu.count': event.contexts.device.processor_count,
	        'host.cpu.frequency': event.contexts.device.processor_frequency
	      }), event.server_name && {
	        'host.name': event.server_name
	      });
	    };
	    exports.extractSemAttrsFromEvent = extractSemAttrsFromEvent;
	    var extractSpanEventsFromException = function extractSpanEventsFromException(exception) {
	      return _objectSpread$G(_objectSpread$G(_objectSpread$G(_defineProperty(_defineProperty(_defineProperty({}, semantic_conventions_1.SEMATTRS_EXCEPTION_MESSAGE, exception.value), exports.SEMATTRS_EXCEPTION_PARSED_STACKTRACE, (0, utils_1.jsonToString)(exception.stacktrace)), semantic_conventions_1.SEMATTRS_EXCEPTION_TYPE, exception.type), exception.mechanism && _defineProperty({}, exports.SEMATTRS_EXCEPTION_MECHANISM, (0, utils_1.jsonToString)(exception.mechanism))), exception.module && _defineProperty({}, exports.SEMATTRS_EXCEPTION_MODULE, exception.module)), exception.thread_id && _defineProperty({}, exports.SEMATTRS_EXCEPTION_THREAD_ID, exception.thread_id));
	    };
	    exports.extractSpanEventsFromException = extractSpanEventsFromException;
	    var isSentryEventAnException = function isSentryEventAnException(event) {
	      var _a, _b;
	      return ((_b = (_a = event.exception) === null || _a === void 0 ? void 0 : _valuesInstanceProperty(_a)) === null || _b === void 0 ? void 0 : _b.length) > 0;
	    };
	    exports.isSentryEventAnException = isSentryEventAnException;
	    var getSpanNameFromEvent = function getSpanNameFromEvent(event) {
	      var _a;
	      return event.message ? event.message : [(_a = event.exception) === null || _a === void 0 ? void 0 : _valuesInstanceProperty(_a)[0].type, event.transaction].join(' ');
	    };
	    exports.getSpanNameFromEvent = getSpanNameFromEvent;
	    var _startOtelSpanFromSentryEvent = function _startOtelSpanFromSentryEvent(_ref8) {
	      var customAttributes = _ref8.customAttributes,
	        event = _ref8.event,
	        hint = _ref8.hint,
	        sentryVersion = _ref8.sentryVersion,
	        span = _ref8.span,
	        spanStatus = _ref8.spanStatus,
	        tracer = _ref8.tracer;
	      var _a, _b;
	      var _span = span;
	      var isRootSpan = false;
	      var startTime = event.timestamp * 1000;
	      var eventAttributes = (0, exports.extractSemAttrsFromEvent)(event, hint, sentryVersion);
	      if (_span == null) {
	        isRootSpan = true;
	        _span = tracer.startSpan((0, exports.getSpanNameFromEvent)(event), {
	          attributes: _objectSpread$G(_objectSpread$G({}, customAttributes), eventAttributes),
	          startTime: startTime,
	          kind: api_1.SpanKind.INTERNAL
	        });
	      }
	      _span.setStatus({
	        code: spanStatus
	      });
	      var _iterator = _createForOfIteratorHelper$v((_b = (_a = event.exception) === null || _a === void 0 ? void 0 : _valuesInstanceProperty(_a)) !== null && _b !== void 0 ? _b : []),
	        _step;
	      try {
	        for (_iterator.s(); !(_step = _iterator.n()).done;) {
	          var exception = _step.value;
	          _span.addEvent(enums_1.ExceptionEventName, (0, exports.extractSpanEventsFromException)(exception));
	        }
	      } catch (err) {
	        _iterator.e(err);
	      } finally {
	        _iterator.f();
	      }
	      if (isRootSpan) {
	        _span.end(startTime);
	      }
	    };
	    var getEventProcessor = function getEventProcessor(tracer, sentryVersion) {
	      return function (event, hint, span, attributes) {
	        try {
	          api_1.diag.debug('Received Sentry event', event);
	          if ((0, exports.isSentryEventAnException)(event)) {
	            var _tracer = tracer;
	            if (_tracer == null) {
	              _tracer = defaultTracer;
	              api_1.diag.debug('Using default tracer');
	            }
	            _startOtelSpanFromSentryEvent({
	              customAttributes: attributes,
	              event: event,
	              hint: hint,
	              sentryVersion: sentryVersion,
	              span: span,
	              spanStatus: api_1.SpanStatusCode.ERROR,
	              tracer: _tracer
	            });
	          }
	        } catch (e) {
	          api_1.diag.error('Error processing event', e);
	        }
	        return event;
	      };
	    };
	    exports.getEventProcessor = getEventProcessor;
	  })(eventProcessor);
	  return eventProcessor;
	}

	var instrumentation = {};

	var imqaIntegration = {};

	var hasRequiredImqaIntegration;
	function requireImqaIntegration() {
	  if (hasRequiredImqaIntegration) return imqaIntegration;
	  hasRequiredImqaIntegration = 1;
	  (function (exports) {

	    _Object$defineProperty$1(exports, "__esModule", {
	      value: true
	    });
	    exports.imqaIntegration = exports._imqaIntegration = void 0;
	    var eventProcessor_1 = requireEventProcessor();
	    var defineIntegration = function defineIntegration(fn) {
	      return fn;
	    };
	    var INTEGRATION_NAME = 'IMQA';
	    exports._imqaIntegration = function () {
	      return {
	        name: INTEGRATION_NAME,
	        setupOnce: function setupOnce() {},
	        setup: function setup(client) {
	          var _a;
	          if (!client.on) {
	            return;
	          }
	          var sdkMetadata = client.getSdkMetadata();
	          var processor = (0, eventProcessor_1.getEventProcessor)(undefined, (_a = sdkMetadata.sdk) === null || _a === void 0 ? void 0 : _a.version);
	          client.on('beforeSendEvent', function (event, hint) {
	            processor(event, hint);
	          });
	        }
	      };
	    };
	    exports.imqaIntegration = defineIntegration(exports._imqaIntegration);
	  })(imqaIntegration);
	  return imqaIntegration;
	}

	function _callSuper$w(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct$x() ? _Reflect$construct$1(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
	function _isNativeReflectConstruct$x() { try { var t = !Boolean.prototype.valueOf.call(_Reflect$construct$1(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct$x = function _isNativeReflectConstruct() { return !!t; })(); }
	var hasRequiredInstrumentation;
	function requireInstrumentation() {
	  if (hasRequiredInstrumentation) return instrumentation;
	  hasRequiredInstrumentation = 1;
	  _Object$defineProperty$1(instrumentation, "__esModule", {
	    value: true
	  });
	  instrumentation.SentryNodeInstrumentation = void 0;
	  var api_1 = require$$0$8;
	  var instrumentation_1 = require$$0$7;
	  var imqaIntegration_1 = requireImqaIntegration();
	  var version_1 = requireVersion$c();
	  var MODULE_NAME = "@imqa/instrumentation-node";
	  var SentryNodeInstrumentation = /*#__PURE__*/function (_instrumentation_1$In) {
	    function SentryNodeInstrumentation() {
	      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	      _classCallCheck(this, SentryNodeInstrumentation);
	      return _callSuper$w(this, SentryNodeInstrumentation, [MODULE_NAME, version_1.VERSION, config]);
	    }
	    _inherits(SentryNodeInstrumentation, _instrumentation_1$In);
	    return _createClass(SentryNodeInstrumentation, [{
	      key: "setConfig",
	      value: function setConfig() {
	        var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	        this._config = _Object$assign({}, config);
	      }
	    }, {
	      key: "getConfig",
	      value: function getConfig() {
	        return this._config;
	      }
	    }, {
	      key: "init",
	      value: function init() {
	        var _this = this;
	        return [new instrumentation_1.InstrumentationNodeModuleDefinition('@sentry/node', ['>=7.30.0 <9'], function (moduleExports) {
	          api_1.diag.debug("Detected Sentry installed with SDK version: ".concat(moduleExports.SDK_VERSION));
	          _this._wrap(moduleExports, 'init', function (original) {
	            return function () {
	              for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	                args[_key] = arguments[_key];
	              }
	              var result = original.apply(_this, args);
	              try {
	                if (moduleExports.addIntegration instanceof Function) {
	                  moduleExports.addIntegration((0, imqaIntegration_1.imqaIntegration)());
	                  api_1.diag.debug('Added IMQA Sentry integration');
	                } else {
	                  api_1.diag.error('Sentry SDK does not support addIntegration method');
	                }
	              } catch (e) {
	                api_1.diag.error('Error adding IMQA Sentry integration', e);
	              }
	              return result;
	            };
	          });
	          return moduleExports;
	        }, function (moduleExports) {})];
	      }
	    }]);
	  }(instrumentation_1.InstrumentationBase);
	  instrumentation.SentryNodeInstrumentation = SentryNodeInstrumentation;
	  return instrumentation;
	}

	var types$1 = {};

	var hasRequiredTypes$1;
	function requireTypes$1() {
	  if (hasRequiredTypes$1) return types$1;
	  hasRequiredTypes$1 = 1;
	  _Object$defineProperty$1(types$1, "__esModule", {
	    value: true
	  });
	  return types$1;
	}

	var hasRequiredBuild$m;
	function requireBuild$m() {
	  if (hasRequiredBuild$m) return build$l;
	  hasRequiredBuild$m = 1;
	  (function (exports) {

	    _Object$defineProperty$1(exports, "__esModule", {
	      value: true
	    });
	    var tslib_1 = require$$0$9;
	    tslib_1.__exportStar(requireEventProcessor(), exports);
	    tslib_1.__exportStar(requireInstrumentation(), exports);
	    tslib_1.__exportStar(requireTypes$1(), exports);
	  })(build$l);
	  return build$l;
	}

	var es_array_fill = {};

	var arrayFill;
	var hasRequiredArrayFill;

	function requireArrayFill () {
		if (hasRequiredArrayFill) return arrayFill;
		hasRequiredArrayFill = 1;
		var toObject = /*@__PURE__*/ requireToObject();
		var toAbsoluteIndex = /*@__PURE__*/ requireToAbsoluteIndex();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();

		// `Array.prototype.fill` method implementation
		// https://tc39.es/ecma262/#sec-array.prototype.fill
		arrayFill = function fill(value /* , start = 0, end = @length */) {
		  var O = toObject(this);
		  var length = lengthOfArrayLike(O);
		  var argumentsLength = arguments.length;
		  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
		  var end = argumentsLength > 2 ? arguments[2] : undefined;
		  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
		  while (endPos > index) O[index++] = value;
		  return O;
		};
		return arrayFill;
	}

	var hasRequiredEs_array_fill;

	function requireEs_array_fill () {
		if (hasRequiredEs_array_fill) return es_array_fill;
		hasRequiredEs_array_fill = 1;
		var $ = /*@__PURE__*/ require_export();
		var fill = /*@__PURE__*/ requireArrayFill();
		var addToUnscopables = /*@__PURE__*/ requireAddToUnscopables();

		// `Array.prototype.fill` method
		// https://tc39.es/ecma262/#sec-array.prototype.fill
		$({ target: 'Array', proto: true }, {
		  fill: fill
		});

		// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
		addToUnscopables('fill');
		return es_array_fill;
	}

	var fill$3;
	var hasRequiredFill$3;

	function requireFill$3 () {
		if (hasRequiredFill$3) return fill$3;
		hasRequiredFill$3 = 1;
		requireEs_array_fill();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		fill$3 = getBuiltInPrototypeMethod('Array', 'fill');
		return fill$3;
	}

	var fill$2;
	var hasRequiredFill$2;

	function requireFill$2 () {
		if (hasRequiredFill$2) return fill$2;
		hasRequiredFill$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireFill$3();

		var ArrayPrototype = Array.prototype;

		fill$2 = function (it) {
		  var own = it.fill;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.fill) ? method : own;
		};
		return fill$2;
	}

	var fill$1;
	var hasRequiredFill$1;

	function requireFill$1 () {
		if (hasRequiredFill$1) return fill$1;
		hasRequiredFill$1 = 1;
		var parent = /*@__PURE__*/ requireFill$2();

		fill$1 = parent;
		return fill$1;
	}

	var fill;
	var hasRequiredFill;
	function requireFill() {
	  if (hasRequiredFill) return fill;
	  hasRequiredFill = 1;
	  fill = /*@__PURE__*/requireFill$1();
	  return fill;
	}

	var fillExports = requireFill();
	var _fillInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(fillExports);

	var cjs = {};

	var errors = {};

	var debugBuild$1 = {};

	var hasRequiredDebugBuild$1;
	function requireDebugBuild$1() {
	  if (hasRequiredDebugBuild$1) return debugBuild$1;
	  hasRequiredDebugBuild$1 = 1;
	  _Object$defineProperty$1(debugBuild$1, '__esModule', {
	    value: true
	  });

	  /**
	   * This serves as a build time flag that will be true by default, but false in non-debug builds or if users replace `__SENTRY_DEBUG__` in their generated code.
	   *
	   * ATTENTION: This constant must never cross package boundaries (i.e. be exported) to guarantee that it can be used for tree shaking.
	   */
	  var DEBUG_BUILD = typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__;
	  debugBuild$1.DEBUG_BUILD = DEBUG_BUILD;
	  return debugBuild$1;
	}

	var globalError = {};

	var worldwide = {};

	var version$b = {};

	var hasRequiredVersion$b;
	function requireVersion$b() {
	  if (hasRequiredVersion$b) return version$b;
	  hasRequiredVersion$b = 1;
	  _Object$defineProperty$1(version$b, '__esModule', {
	    value: true
	  });

	  // This is a magic string replaced by rollup

	  var SDK_VERSION = "8.55.0";
	  version$b.SDK_VERSION = SDK_VERSION;
	  return version$b;
	}

	var hasRequiredWorldwide;
	function requireWorldwide() {
	  if (hasRequiredWorldwide) return worldwide;
	  hasRequiredWorldwide = 1;
	  _Object$defineProperty$1(worldwide, '__esModule', {
	    value: true
	  });
	  var version = /*@__PURE__*/requireVersion$b();

	  /** Get's the global object for the current JavaScript runtime */
	  var GLOBAL_OBJ = _globalThis$3;

	  /**
	   * Returns a global singleton contained in the global `__SENTRY__[]` object.
	   *
	   * If the singleton doesn't already exist in `__SENTRY__`, it will be created using the given factory
	   * function and added to the `__SENTRY__` object.
	   *
	   * @param name name of the global singleton on __SENTRY__
	   * @param creator creator Factory function to create the singleton if it doesn't already exist on `__SENTRY__`
	   * @param obj (Optional) The global object on which to look for `__SENTRY__`, if not `GLOBAL_OBJ`'s return value
	   * @returns the singleton
	   */
	  function getGlobalSingleton(name, creator, obj) {
	    var gbl = obj || GLOBAL_OBJ;
	    var __SENTRY__ = gbl.__SENTRY__ = gbl.__SENTRY__ || {};
	    var versionedCarrier = __SENTRY__[version.SDK_VERSION] = __SENTRY__[version.SDK_VERSION] || {};
	    return versionedCarrier[name] || (versionedCarrier[name] = creator());
	  }
	  worldwide.GLOBAL_OBJ = GLOBAL_OBJ;
	  worldwide.getGlobalSingleton = getGlobalSingleton;
	  return worldwide;
	}

	var handlers = {};

	var debugBuild = {};

	var hasRequiredDebugBuild;
	function requireDebugBuild() {
	  if (hasRequiredDebugBuild) return debugBuild;
	  hasRequiredDebugBuild = 1;
	  _Object$defineProperty$1(debugBuild, '__esModule', {
	    value: true
	  });

	  /**
	   * This serves as a build time flag that will be true by default, but false in non-debug builds or if users replace `__SENTRY_DEBUG__` in their generated code.
	   *
	   * ATTENTION: This constant must never cross package boundaries (i.e. be exported) to guarantee that it can be used for tree shaking.
	   */
	  var DEBUG_BUILD = typeof __SENTRY_DEBUG__ === 'undefined' || __SENTRY_DEBUG__;
	  debugBuild.DEBUG_BUILD = DEBUG_BUILD;
	  return debugBuild;
	}

	var logger = {};

	var hasRequiredLogger$1;
	function requireLogger$1() {
	  if (hasRequiredLogger$1) return logger;
	  hasRequiredLogger$1 = 1;
	  _Object$defineProperty$1(logger, '__esModule', {
	    value: true
	  });
	  var debugBuild = /*@__PURE__*/requireDebugBuild();
	  var worldwide = /*@__PURE__*/requireWorldwide();

	  /** Prefix for logging strings */
	  var PREFIX = 'Sentry Logger ';
	  var CONSOLE_LEVELS = ['debug', 'info', 'warn', 'error', 'log', 'assert', 'trace'];

	  /** This may be mutated by the console instrumentation. */
	  var originalConsoleMethods = {};

	  /** JSDoc */

	  /**
	   * Temporarily disable sentry console instrumentations.
	   *
	   * @param callback The function to run against the original `console` messages
	   * @returns The results of the callback
	   */
	  function consoleSandbox(callback) {
	    if (!('console' in worldwide.GLOBAL_OBJ)) {
	      return callback();
	    }
	    var console = worldwide.GLOBAL_OBJ.console;
	    var wrappedFuncs = {};
	    var wrappedLevels = _Object$keys(originalConsoleMethods);

	    // Restore all wrapped console methods
	    _forEachInstanceProperty(wrappedLevels).call(wrappedLevels, function (level) {
	      var originalConsoleMethod = originalConsoleMethods[level];
	      wrappedFuncs[level] = console[level];
	      console[level] = originalConsoleMethod;
	    });
	    try {
	      return callback();
	    } finally {
	      // Revert restoration to wrapped state
	      _forEachInstanceProperty(wrappedLevels).call(wrappedLevels, function (level) {
	        console[level] = wrappedFuncs[level];
	      });
	    }
	  }
	  function makeLogger() {
	    var enabled = false;
	    var logger = {
	      enable: function enable() {
	        enabled = true;
	      },
	      disable: function disable() {
	        enabled = false;
	      },
	      isEnabled: function isEnabled() {
	        return enabled;
	      }
	    };
	    if (debugBuild.DEBUG_BUILD) {
	      _forEachInstanceProperty(CONSOLE_LEVELS).call(CONSOLE_LEVELS, function (name) {
	        logger[name] = function () {
	          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
	            args[_key] = arguments[_key];
	          }
	          if (enabled) {
	            consoleSandbox(function () {
	              var _worldwide$GLOBAL_OBJ, _context, _context2;
	              (_worldwide$GLOBAL_OBJ = worldwide.GLOBAL_OBJ.console)[name].apply(_worldwide$GLOBAL_OBJ, _concatInstanceProperty(_context = [_concatInstanceProperty(_context2 = "".concat(PREFIX, "[")).call(_context2, name, "]:")]).call(_context, args));
	            });
	          }
	        };
	      });
	    } else {
	      _forEachInstanceProperty(CONSOLE_LEVELS).call(CONSOLE_LEVELS, function (name) {
	        logger[name] = function () {
	          return undefined;
	        };
	      });
	    }
	    return logger;
	  }

	  /**
	   * This is a logger singleton which either logs things or no-ops if logging is not enabled.
	   * The logger is a singleton on the carrier, to ensure that a consistent logger is used throughout the SDK.
	   */
	  var logger$1 = worldwide.getGlobalSingleton('logger', makeLogger);
	  logger.CONSOLE_LEVELS = CONSOLE_LEVELS;
	  logger.consoleSandbox = consoleSandbox;
	  logger.logger = logger$1;
	  logger.originalConsoleMethods = originalConsoleMethods;
	  return logger;
	}

	function _arrayWithoutHoles(r) {
	  if (_Array$isArray(r)) return _arrayLikeToArray$w(r);
	}

	function _iterableToArray(r) {
	  if ("undefined" != typeof _Symbol$2 && null != _getIteratorMethod(r) || null != r["@@iterator"]) return _Array$from(r);
	}

	function _nonIterableSpread() {
	  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	function _toConsumableArray(r) {
	  return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray$w(r) || _nonIterableSpread();
	}

	var es_array_sort = {};

	var environmentFfVersion;
	var hasRequiredEnvironmentFfVersion;

	function requireEnvironmentFfVersion () {
		if (hasRequiredEnvironmentFfVersion) return environmentFfVersion;
		hasRequiredEnvironmentFfVersion = 1;
		var userAgent = /*@__PURE__*/ requireEnvironmentUserAgent();

		var firefox = userAgent.match(/firefox\/(\d+)/i);

		environmentFfVersion = !!firefox && +firefox[1];
		return environmentFfVersion;
	}

	var environmentIsIeOrEdge;
	var hasRequiredEnvironmentIsIeOrEdge;

	function requireEnvironmentIsIeOrEdge () {
		if (hasRequiredEnvironmentIsIeOrEdge) return environmentIsIeOrEdge;
		hasRequiredEnvironmentIsIeOrEdge = 1;
		var UA = /*@__PURE__*/ requireEnvironmentUserAgent();

		environmentIsIeOrEdge = /MSIE|Trident/.test(UA);
		return environmentIsIeOrEdge;
	}

	var environmentWebkitVersion;
	var hasRequiredEnvironmentWebkitVersion;

	function requireEnvironmentWebkitVersion () {
		if (hasRequiredEnvironmentWebkitVersion) return environmentWebkitVersion;
		hasRequiredEnvironmentWebkitVersion = 1;
		var userAgent = /*@__PURE__*/ requireEnvironmentUserAgent();

		var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);

		environmentWebkitVersion = !!webkit && +webkit[1];
		return environmentWebkitVersion;
	}

	var hasRequiredEs_array_sort;

	function requireEs_array_sort () {
		if (hasRequiredEs_array_sort) return es_array_sort;
		hasRequiredEs_array_sort = 1;
		var $ = /*@__PURE__*/ require_export();
		var uncurryThis = /*@__PURE__*/ requireFunctionUncurryThis();
		var aCallable = /*@__PURE__*/ requireACallable();
		var toObject = /*@__PURE__*/ requireToObject();
		var lengthOfArrayLike = /*@__PURE__*/ requireLengthOfArrayLike();
		var deletePropertyOrThrow = /*@__PURE__*/ requireDeletePropertyOrThrow();
		var toString = /*@__PURE__*/ requireToString();
		var fails = /*@__PURE__*/ requireFails();
		var internalSort = /*@__PURE__*/ requireArraySort();
		var arrayMethodIsStrict = /*@__PURE__*/ requireArrayMethodIsStrict();
		var FF = /*@__PURE__*/ requireEnvironmentFfVersion();
		var IE_OR_EDGE = /*@__PURE__*/ requireEnvironmentIsIeOrEdge();
		var V8 = /*@__PURE__*/ requireEnvironmentV8Version();
		var WEBKIT = /*@__PURE__*/ requireEnvironmentWebkitVersion();

		var test = [];
		var nativeSort = uncurryThis(test.sort);
		var push = uncurryThis(test.push);

		// IE8-
		var FAILS_ON_UNDEFINED = fails(function () {
		  test.sort(undefined);
		});
		// V8 bug
		var FAILS_ON_NULL = fails(function () {
		  test.sort(null);
		});
		// Old WebKit
		var STRICT_METHOD = arrayMethodIsStrict('sort');

		var STABLE_SORT = !fails(function () {
		  // feature detection can be too slow, so check engines versions
		  if (V8) return V8 < 70;
		  if (FF && FF > 3) return;
		  if (IE_OR_EDGE) return true;
		  if (WEBKIT) return WEBKIT < 603;

		  var result = '';
		  var code, chr, value, index;

		  // generate an array with more 512 elements (Chakra and old V8 fails only in this case)
		  for (code = 65; code < 76; code++) {
		    chr = String.fromCharCode(code);

		    switch (code) {
		      case 66: case 69: case 70: case 72: value = 3; break;
		      case 68: case 71: value = 4; break;
		      default: value = 2;
		    }

		    for (index = 0; index < 47; index++) {
		      test.push({ k: chr + index, v: value });
		    }
		  }

		  test.sort(function (a, b) { return b.v - a.v; });

		  for (index = 0; index < test.length; index++) {
		    chr = test[index].k.charAt(0);
		    if (result.charAt(result.length - 1) !== chr) result += chr;
		  }

		  return result !== 'DGBEFHACIJK';
		});

		var FORCED = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD || !STABLE_SORT;

		var getSortCompare = function (comparefn) {
		  return function (x, y) {
		    if (y === undefined) return -1;
		    if (x === undefined) return 1;
		    if (comparefn !== undefined) return +comparefn(x, y) || 0;
		    return toString(x) > toString(y) ? 1 : -1;
		  };
		};

		// `Array.prototype.sort` method
		// https://tc39.es/ecma262/#sec-array.prototype.sort
		$({ target: 'Array', proto: true, forced: FORCED }, {
		  sort: function sort(comparefn) {
		    if (comparefn !== undefined) aCallable(comparefn);

		    var array = toObject(this);

		    if (STABLE_SORT) return comparefn === undefined ? nativeSort(array) : nativeSort(array, comparefn);

		    var items = [];
		    var arrayLength = lengthOfArrayLike(array);
		    var itemsLength, index;

		    for (index = 0; index < arrayLength; index++) {
		      if (index in array) push(items, array[index]);
		    }

		    internalSort(items, getSortCompare(comparefn));

		    itemsLength = lengthOfArrayLike(items);
		    index = 0;

		    while (index < itemsLength) array[index] = items[index++];
		    while (index < arrayLength) deletePropertyOrThrow(array, index++);

		    return array;
		  }
		});
		return es_array_sort;
	}

	var sort$3;
	var hasRequiredSort$3;

	function requireSort$3 () {
		if (hasRequiredSort$3) return sort$3;
		hasRequiredSort$3 = 1;
		requireEs_array_sort();
		var getBuiltInPrototypeMethod = /*@__PURE__*/ requireGetBuiltInPrototypeMethod();

		sort$3 = getBuiltInPrototypeMethod('Array', 'sort');
		return sort$3;
	}

	var sort$2;
	var hasRequiredSort$2;

	function requireSort$2 () {
		if (hasRequiredSort$2) return sort$2;
		hasRequiredSort$2 = 1;
		var isPrototypeOf = /*@__PURE__*/ requireObjectIsPrototypeOf();
		var method = /*@__PURE__*/ requireSort$3();

		var ArrayPrototype = Array.prototype;

		sort$2 = function (it) {
		  var own = it.sort;
		  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.sort) ? method : own;
		};
		return sort$2;
	}

	var sort$1;
	var hasRequiredSort$1;

	function requireSort$1 () {
		if (hasRequiredSort$1) return sort$1;
		hasRequiredSort$1 = 1;
		var parent = /*@__PURE__*/ requireSort$2();

		sort$1 = parent;
		return sort$1;
	}

	var sort;
	var hasRequiredSort;
	function requireSort() {
	  if (hasRequiredSort) return sort;
	  hasRequiredSort = 1;
	  sort = /*@__PURE__*/requireSort$1();
	  return sort;
	}

	var sortExports = requireSort();
	var _sortInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(sortExports);

	var stacktrace = {};

	function ownKeys$F(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols$1) { var o = _Object$getOwnPropertySymbols$1(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor$1(e, r).enumerable; })), t.push.apply(t, o); } return t; }
	function _objectSpread$F(e) { for (var r = 1; r < arguments.length; r++) { var _context5, _context6; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context5 = ownKeys$F(Object(t), true)).call(_context5, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context6 = ownKeys$F(Object(t))).call(_context6, function (r) { _Object$defineProperty$1(e, r, _Object$getOwnPropertyDescriptor$1(t, r)); }); } return e; }
	function _createForOfIteratorHelper$u(r, e) { var t = "undefined" != typeof _Symbol$1 && _getIteratorMethod$1(r) || r["@@iterator"]; if (!t) { if (_Array$isArray$1(r) || (t = _unsupportedIterableToArray$u(r)) || e) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: true } : { done: false, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = true, u = false; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = true, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
	function _unsupportedIterableToArray$u(r, a) { if (r) { var _context4; if ("string" == typeof r) return _arrayLikeToArray$u(r, a); var t = _sliceInstanceProperty$1(_context4 = {}.toString.call(r)).call(_context4, 8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? _Array$from$1(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$u(r, a) : void 0; } }
	function _arrayLikeToArray$u(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
	var hasRequiredStacktrace;
	function requireStacktrace() {
	  if (hasRequiredStacktrace) return stacktrace;
	  hasRequiredStacktrace = 1;
	  _Object$defineProperty$1(stacktrace, '__esModule', {
	    value: true
	  });
	  var STACKTRACE_FRAME_LIMIT = 50;
	  var UNKNOWN_FUNCTION = '?';
	  // Used to sanitize webpack (error: *) wrapped stack errors
	  var WEBPACK_ERROR_REGEXP = /\(error: (.*)\)/;
	  var STRIP_FRAME_REGEXP = /captureMessage|captureException/;

	  /**
	   * Creates a stack parser with the supplied line parsers
	   *
	   * StackFrames are returned in the correct order for Sentry Exception
	   * frames and with Sentry SDK internal frames removed from the top and bottom
	   *
	   */
	  function createStackParser() {
	    var _context;
	    for (var _len = arguments.length, parsers = new Array(_len), _key = 0; _key < _len; _key++) {
	      parsers[_key] = arguments[_key];
	    }
	    var sortedParsers = _mapInstanceProperty(_context = _sortInstanceProperty(parsers).call(parsers, function (a, b) {
	      return a[0] - b[0];
	    })).call(_context, function (p) {
	      return p[1];
	    });
	    return function (stack) {
	      var skipFirstLines = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
	      var framesToPop = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
	      var frames = [];
	      var lines = stack.split('\n');
	      for (var i = skipFirstLines; i < lines.length; i++) {
	        var line = lines[i];
	        // Ignore lines over 1kb as they are unlikely to be stack frames.
	        // Many of the regular expressions use backtracking which results in run time that increases exponentially with
	        // input size. Huge strings can result in hangs/Denial of Service:
	        // https://github.com/getsentry/sentry-javascript/issues/2286
	        if (line.length > 1024) {
	          continue;
	        }

	        // https://github.com/getsentry/sentry-javascript/issues/5459
	        // Remove webpack (error: *) wrappers
	        var cleanedLine = WEBPACK_ERROR_REGEXP.test(line) ? line.replace(WEBPACK_ERROR_REGEXP, '$1') : line;

	        // https://github.com/getsentry/sentry-javascript/issues/7813
	        // Skip Error: lines
	        if (cleanedLine.match(/\S*Error: /)) {
	          continue;
	        }
	        var _iterator = _createForOfIteratorHelper$u(sortedParsers),
	          _step;
	        try {
	          for (_iterator.s(); !(_step = _iterator.n()).done;) {
	            var parser = _step.value;
	            var frame = parser(cleanedLine);
	            if (frame) {
	              frames.push(frame);
	              break;
	            }
	          }
	        } catch (err) {
	          _iterator.e(err);
	        } finally {
	          _iterator.f();
	        }
	        if (frames.length >= STACKTRACE_FRAME_LIMIT + framesToPop) {
	          break;
	        }
	      }
	      return stripSentryFramesAndReverse(_sliceInstanceProperty$1(frames).call(frames, framesToPop));
	    };
	  }

	  /**
	   * Gets a stack parser implementation from Options.stackParser
	   * @see Options
	   *
	   * If options contains an array of line parsers, it is converted into a parser
	   */
	  function stackParserFromStackParserOptions(stackParser) {
	    if (_Array$isArray$1(stackParser)) {
	      return createStackParser.apply(void 0, _toConsumableArray(stackParser));
	    }
	    return stackParser;
	  }

	  /**
	   * Removes Sentry frames from the top and bottom of the stack if present and enforces a limit of max number of frames.
	   * Assumes stack input is ordered from top to bottom and returns the reverse representation so call site of the
	   * function that caused the crash is the last frame in the array.
	   * @hidden
	   */
	  function stripSentryFramesAndReverse(stack) {
	    var _context2;
	    if (!stack.length) {
	      return [];
	    }
	    var localStack = _Array$from$1(stack);

	    // If stack starts with one of our API calls, remove it (starts, meaning it's the top of the stack - aka last call)
	    if (/sentryWrapped/.test(getLastStackFrame(localStack).function || '')) {
	      localStack.pop();
	    }

	    // Reversing in the middle of the procedure allows us to just pop the values off the stack
	    _reverseInstanceProperty(localStack).call(localStack);

	    // If stack ends with one of our internal API calls, remove it (ends, meaning it's the bottom of the stack - aka top-most call)
	    if (STRIP_FRAME_REGEXP.test(getLastStackFrame(localStack).function || '')) {
	      localStack.pop();

	      // When using synthetic events, we will have a 2 levels deep stack, as `new Error('Sentry syntheticException')`
	      // is produced within the hub itself, making it:
	      //
	      //   Sentry.captureException()
	      //   getCurrentHub().captureException()
	      //
	      // instead of just the top `Sentry` call itself.
	      // This forces us to possibly strip an additional frame in the exact same was as above.
	      if (STRIP_FRAME_REGEXP.test(getLastStackFrame(localStack).function || '')) {
	        localStack.pop();
	      }
	    }
	    return _mapInstanceProperty(_context2 = _sliceInstanceProperty$1(localStack).call(localStack, 0, STACKTRACE_FRAME_LIMIT)).call(_context2, function (frame) {
	      return _objectSpread$F(_objectSpread$F({}, frame), {}, {
	        filename: frame.filename || getLastStackFrame(localStack).filename,
	        function: frame.function || UNKNOWN_FUNCTION
	      });
	    });
	  }
	  function getLastStackFrame(arr) {
	    return arr[arr.length - 1] || {};
	  }
	  var defaultFunctionName = '<anonymous>';

	  /**
	   * Safely extract function name from itself
	   */
	  function getFunctionName(fn) {
	    try {
	      if (!fn || typeof fn !== 'function') {
	        return defaultFunctionName;
	      }
	      return fn.name || defaultFunctionName;
	    } catch (e) {
	      // Just accessing custom props in some Selenium environments
	      // can cause a "Permission denied" exception (see raven-js#495).
	      return defaultFunctionName;
	    }
	  }

	  /**
	   * Get's stack frames from an event without needing to check for undefined properties.
	   */
	  function getFramesFromEvent(event) {
	    var exception = event.exception;
	    if (exception) {
	      var frames = [];
	      try {
	        var _context3;
	        // @ts-expect-error Object could be undefined
	        _forEachInstanceProperty(_context3 = _valuesInstanceProperty(exception)).call(_context3, function (value) {
	          // @ts-expect-error Value could be undefined
	          if (value.stacktrace.frames) {
	            // @ts-expect-error Value could be undefined
	            frames.push.apply(frames, _toConsumableArray(value.stacktrace.frames));
	          }
	        });
	        return frames;
	      } catch (_oO) {
	        return undefined;
	      }
	    }
	    return undefined;
	  }
	  stacktrace.UNKNOWN_FUNCTION = UNKNOWN_FUNCTION;
	  stacktrace.createStackParser = createStackParser;
	  stacktrace.getFramesFromEvent = getFramesFromEvent;
	  stacktrace.getFunctionName = getFunctionName;
	  stacktrace.stackParserFromStackParserOptions = stackParserFromStackParserOptions;
	  stacktrace.stripSentryFramesAndReverse = stripSentryFramesAndReverse;
	  return stacktrace;
	}

	function _createForOfIteratorHelper$t(r, e) { var t = "undefined" != typeof _Symbol$1 && _getIteratorMethod$1(r) || r["@@iterator"]; if (!t) { if (_Array$isArray$1(r) || (t = _unsupportedIterableToArray$t(r)) || e) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: true } : { done: false, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = true, u = false; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = true, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
	function _unsupportedIterableToArray$t(r, a) { if (r) { var _context3; if ("string" == typeof r) return _arrayLikeToArray$t(r, a); var t = _sliceInstanceProperty$1(_context3 = {}.toString.call(r)).call(_context3, 8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? _Array$from$1(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray$t(r, a) : void 0; } }
	function _arrayLikeToArray$t(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
	var hasRequiredHandlers;
	function requireHandlers() {
	  if (hasRequiredHandlers) return handlers;
	  hasRequiredHandlers = 1;
	  _Object$defineProperty$1(handlers, '__esModule', {
	    value: true
	  });
	  var debugBuild = /*@__PURE__*/requireDebugBuild();
	  var logger = /*@__PURE__*/requireLogger$1();
	  var stacktrace = /*@__PURE__*/requireStacktrace();

	  // We keep the handlers globally
	  var handlers$1 = {};
	  var instrumented = {};

	  /** Add a handler function. */
	  function addHandler(type, handler) {
	    handlers$1[type] = handlers$1[type] || [];
	    handlers$1[type].push(handler);
	  }

	  /**
	   * Reset all instrumentation handlers.
	   * This can be used by tests to ensure we have a clean slate of instrumentation handlers.
	   */
	  function resetInstrumentationHandlers() {
	    var _context;
	    _forEachInstanceProperty(_context = _Object$keys(handlers$1)).call(_context, function (key) {
	      handlers$1[key] = undefined;
	    });
	  }

	  /** Maybe run an instrumentation function, unless it was already called. */
	  function maybeInstrument(type, instrumentFn) {
	    if (!instrumented[type]) {
	      instrumented[type] = true;
	      try {
	        instrumentFn();
	      } catch (e) {
	        debugBuild.DEBUG_BUILD && logger.logger.error("Error while instrumenting ".concat(type), e);
	      }
	    }
	  }

	  /** Trigger handlers for a given instrumentation type. */
	  function triggerHandlers(type, data) {
	    var typeHandlers = type && handlers$1[type];
	    if (!typeHandlers) {
	      return;
	    }
	    var _iterator = _createForOfIteratorHelper$t(typeHandlers),
	      _step;
	    try {
	      for (_iterator.s(); !(_step = _iterator.n()).done;) {
	        var handler = _step.value;
	        try {
	          handler(data);
	        } catch (e) {
	          var _context2;
	          debugBuild.DEBUG_BUILD && logger.logger.error(_concatInstanceProperty(_context2 = "Error while triggering instrumentation handler.\nType: ".concat(type, "\nName: ")).call(_context2, stacktrace.getFunctionName(handler), "\nError:"), e);
	        }
	      }
	    } catch (err) {
	      _iterator.e(err);
	    } finally {
	      _iterator.f();
	    }
	  }
	  handlers.addHandler = addHandler;
	  handlers.maybeInstrument = maybeInstrument;
	  handlers.resetInstrumentationHandlers = resetInstrumentationHandlers;
	  handlers.triggerHandlers = triggerHandlers;
	  return handlers;
	}

	var hasRequiredGlobalError;
	function requireGlobalError() {
	  if (hasRequiredGlobalError) return globalError;
	  hasRequiredGlobalError = 1;
	  _Object$defineProperty$1(globalError, '__esModule', {
	    value: true
	  });
	  var worldwide = /*@__PURE__*/requireWorldwide();
	  var handlers = /*@__PURE__*/requireHandlers();
	  var _oldOnErrorHandler = null;

	  /**
	   * Add an instrumentation handler for when an error is captured by the global error handler.
	   *
	   * Use at your own risk, this might break without changelog notice, only used internally.
	   * @hidden
	   */
	  function addGlobalError