import type { RumOtelWebConfig } from '@imqa/otel-web';
import type { RumOtelWebType } from '@imqa/otel-web';
import type { StorageType } from '@imqa/session';
import type { Attributes } from '@opentelemetry/api';
import type { RumRecorderConfig } from '@imqa/session-recorder';
export interface IMQANativeSession {
    /**
     * IMQA Mobile SDK에서 사용하는 공유된 세션 ID
     */
    __imqa_session_id?: string;
    /**
     * IMQA Mobile SDK에서 Web Agent 비활성화 여부
     */
    __imqa_deactivated?: boolean;
    /**
     * IMQA Mobile SDK에서 사용하는 공유된 서비스 이름
     */
    __imqa_service_name?: string;
    /**
     * IMQA Mobile SDK에서 사용하는 공유된 서비스 키
     */
    __imqa_service_key?: string;
    /**
     * IMQA Mobile SDK에서 사용하는 공유된 서비스 버전
     */
    __imqa_service_version?: string;
    /**
     * IMQA Mobile SDK 종류: "web", "android", "ios" 등. 기본값은 "web"
     */
    __imqa_service_type?: string;
    /**
     * IMQA Mobile SDK에서 세션을 공유할 지 여부(true: 공유 = Mobile SDK에서 공유한 값으로 계측, false: 비공유 = 설정된 값으로 계측)
     */
    __imqa_shared_session?: boolean;
    /**
     * IMQA Mobile SDK에서 사용하는 공유된 콜렉터 URL
     */
    __imqa_collector_url?: string;
}
declare global {
    interface Window extends IMQANativeSession {
        /**
         * IMQA API
         */
        IMQA: RumOtelWebType | undefined;
        IMQANative?: {
            getSession: () => string;
        };
        /**
         * IMQA Web Agent 버전
         */
        __IMQA_WEBAGENT_VERSION__: string;
        /**
         * IMQA Web Agent 빌드 SHA
         */
        __GIT_SHA__: string;
        /**
         * IMQA Web Agent 브랜치
         */
        __BRANCH__: string;
        /**
         * IMQA Web Agent 빌드 시간
         */
        __BUILD_TIME__: string;
    }
}
export type ErrorBoundaryComponent = any;
export type Instrumentations = RumOtelWebConfig['instrumentations'];
export type IgnoreUrls = RumOtelWebConfig['ignoreUrls'];
export type IMQASDKConfig = {
    /**
     * 콜렉터 주소 (필수)
     */
    collectorUrl?: string;
    /**
     * 인증 토큰 (선택 사항)
     */
    authorizationToken?: string;
    /**
     * 서비스 이름 (필수 사항)
     */
    serviceName?: string;
    /**
     * 서비스 키 (필수 사항)
     */
    serviceKey?: string;
    /**
     * 서비스 버전 (필수 사항)
     */
    serviceVersion?: string;
    /**
     * 배포 환경 (선택 사항)
     */
    deploymentEnvironment?: string;
    /**
     * 기본 리소스 속성 (선택 사항)
     */
    defaultAttributes?: Attributes;
    /**
     * 샘플링 확률 (선택 사항, 0-1 범위, 기본값: 1)
     */
    samplingProbability?: number | string;
    /**
     * 네트워크 요청/응답 세부 추적 활성화 (기본값: false)
     */
    advancedNetworkCapture?: boolean;
    /**
     * 세션 리플레이에서 가려야 할 요소의 클래스 (선택 사항)
     */
    blockClass?: string;
    /**
     * 콘솔 캡처 설정 (기본값: false)
     */
    consoleCapture?: boolean;
    /**
     * 디버깅 모드 활성화 (기본값: false)
     */
    debug?: boolean;
    /**
     * Intercom 연동 비활성화 (기본값: false)
     */
    disableIntercom?: boolean;
    /**
     * 세션 리플레이 비활성화 (기본값: true)
     */
    disableReplay?: boolean;
    /**
     * 세션 리플레이에서 무시할 요소의 클래스 (선택 사항)
     */
    ignoreClass?: string;
    /**
     * 무시할 URL 패턴 (선택 사항)
     */
    ignoreUrls?: IgnoreUrls;
    /**
     * 사용자 지정 Instrumentations 설정 (선택 사항)
     */
    instrumentations?: Instrumentations;
    /**
     * 모든 인풋 요소 마스킹 (기본값: true)
     */
    maskAllInputs?: boolean;
    /**
     * 모든 텍스트 마스킹 (기본값: false)
     */
    maskAllText?: boolean;
    /**
     * 텍스트 마스킹에 사용할 클래스 (선택 사항)
     */
    maskClass?: string;
    /**
     * 캔버스 요소 기록 여부 (기본값: false)
     */
    recordCanvas?: boolean;
    /**
     * 세션 레코더 샘플링 설정 (선택 사항)
     */
    sampling?: RumRecorderConfig['sampling'];
    /**
     * Trace Header를 전파할 대상 [도메인 or 정규식] 목록 (선택 사항)
     */
    tracePropagationTargets?: (string | RegExp)[];
    /**
     * Web Vitals 수집 여부 (기본값: true)
     */
    webVitals?: boolean;
    /**
     * WebSocket 수집 여부 (기본값: false)
     */
    websocket?: boolean;
    /**
     * socket.io 수집 여부 (기본값: false)
     */
    socketio?: boolean;
    /**
     * Metrics 수집 여부 (기본값: false)
     */
    captureMetrics?: boolean;
    /**
     * preflight 요청 비활성화 여부 (기본값: false)
     * preflight는 CORS 요청을 위한 OPTIONS 요청입니다.
     */
    disablePreflight?: boolean;
    /**
     * OpAMP 서버 URL (선택 사항)
     * OpAMP 서버 URL을 설정하면, OpAMP를 통해 Agent 설정을 동적으로 업데이트할 수 있습니다.
     * OpAMP 서버는 IMQA에서 제공하는 서버입니다.
     * OpAMP 서버를 사용하지 않으려면, 이 값을 설정하지 않거나 빈 문자열로 설정하세요.
     */
    opampServerUrl?: string;
    /**
     * Exporter protocol
     * json: JSON 프로토콜 사용 (기본값)
     * proto: OTLP Protobuf 프로토콜 사용
     */
    exporterProtocol?: 'proto' | 'json';
    /**
     * 화면이름 옵션.
     * screenNameType은 'routeOnly', 'titleOnly', 'full' 중 하나를 선택할 수 있습니다.
     * routeOnly: URL 경로만 포함, titleOnly: 페이지 제목만 포함, full: 페이지 제목과 URL 경로 모두 포함. 기본값은 'full'입니다.
     * urlWithSearchParams는 true일 경우 URL에 쿼리 파라미터를 포함합니다. 기본값은 true입니다.
     */
    screenNameOption?: RumOtelWebConfig['screenNameOption'];
    /**
     * 세션 저장소 타입 설정 (cookie 또는 localStorage)
     * cookie: 브라우저 쿠키 사용 (기본값)
     * localStorage: 브라우저 로컬 스토리지 사용
     */
    sessionStorage?: StorageType;
};
